/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseEvolutionarySolver;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.adaptivebox.deps.DEPSAgent;
import net.adaptivebox.deps.behavior.DEGTBehavior;
import net.adaptivebox.deps.behavior.PSGTBehavior;
import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;

public final class DEPSSolverImpl
extends BaseEvolutionarySolver
implements XServiceInfo {
    private static final String m_implementationName = DEPSSolverImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.sheet.Solver", "com.sun.star.beans.PropertySet"};
    private final PropertyInfo<Double> m_agentSwitchRate = new PropertyInfo<Double>("AgentSwitchRate", 0.5, "Agent Switch Rate (DE Probability)");
    private final PropertyInfo<Double> m_factor = new PropertyInfo<Double>("DEFactor", 0.5, "DE: Scaling Factor (0-1.2)");
    private final PropertyInfo<Double> m_CR = new PropertyInfo<Double>("DECR", 0.9, "DE: Crossover Probability (0-1)");
    private final PropertyInfo<Double> m_c1 = new PropertyInfo<Double>("PSC1", 1.494, "PS: Cognitive Constant");
    private final PropertyInfo<Double> m_c2 = new PropertyInfo<Double>("PSC2", 1.494, "PS: Social Constant");
    private final PropertyInfo<Double> m_weight = new PropertyInfo<Double>("PSWeight", 0.729, "PS: Constriction Coefficient");
    private final PropertyInfo<Double> m_CL = new PropertyInfo<Double>("PSCL", 0.0, "PS: Mutation Probability (0-0.005)");

    public DEPSSolverImpl(XComponentContext context) {
        super(context, "DEPS Evolutionary Algorithm");
        this.registerProperty(this.m_agentSwitchRate);
        this.registerProperty(this.m_factor);
        this.registerProperty(this.m_CR);
        this.registerProperty(this.m_c1);
        this.registerProperty(this.m_c2);
        this.registerProperty(this.m_weight);
        this.registerProperty(this.m_CL);
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        XSingleComponentFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = Factory.createComponentFactory(DEPSSolverImpl.class, (String[])m_serviceNames);
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public void solve() {
        try {
            this.m_librarySize.setValue(this.m_swarmSize.getValue());
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(DEPSSolverImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initializeSolve();
        DEPSAgent[] agents = new DEPSAgent[((Integer)this.m_swarmSize.getValue()).intValue()];
        for (int i = 0; i < (Integer)this.m_swarmSize.getValue(); ++i) {
            agents[i] = new DEPSAgent();
            agents[i].setProblemEncoder(this.m_problemEncoder);
            agents[i].setPbest(this.m_library.getSelectedPoint(i));
            DEGTBehavior deGTBehavior = new DEGTBehavior();
            deGTBehavior.FACTOR = this.m_factor.getValue();
            deGTBehavior.CR = this.m_CR.getValue();
            PSGTBehavior psGTBehavior = new PSGTBehavior();
            psGTBehavior.c1 = this.m_c1.getValue();
            psGTBehavior.c2 = this.m_c2.getValue();
            psGTBehavior.CL = this.m_CL.getValue();
            psGTBehavior.weight = this.m_weight.getValue();
            agents[i].switchP = this.m_agentSwitchRate.getValue();
            agents[i].setGTBehavior(deGTBehavior);
            agents[i].setGTBehavior(psGTBehavior);
            agents[i].setSpecComparator(this.m_specCompareEngine);
            agents[i].setLibrary(this.m_library);
        }
        this.m_solverStatusDialog.setVisible(true);
        this.m_solverStatusDialog.setMaxIterations((Integer)this.m_learningCycles.getValue());
        this.m_solverStatusDialog.setMaxStagnation((Integer)this.m_required.getValue());
        int learningCycle = 1;
        long runtime = 0L;
        do {
            long startTime = System.nanoTime();
            if (learningCycle >= (Integer)this.m_learningCycles.getValue()) {
                learningCycle = 1;
            }
            if (this.m_solverStatusDialog.getUserState() == 2) {
                this.lockDocument();
            }
            this.m_toleratedCount = 0;
            this.m_toleratedMin = -1.0 * (Double)this.m_tolerance.getValue();
            this.m_toleratedMax = (Double)this.m_tolerance.getValue();
            while (learningCycle <= (Integer)this.m_learningCycles.getValue() && this.m_toleratedCount < (Integer)this.m_required.getValue() && this.m_solverStatusDialog.getUserState() != 3) {
                int i;
                this.m_library.refreshGbest(this.m_specCompareEngine);
                for (i = 0; i < (Integer)this.m_swarmSize.getValue(); ++i) {
                    agents[i].generatePoint();
                }
                for (i = 0; i < (Integer)this.m_swarmSize.getValue(); ++i) {
                    agents[i].learn();
                }
                for (i = 0; i < (Integer)this.m_swarmSize.getValue(); ++i) {
                    boolean inRange;
                    SearchPoint agentPoint = agents[i].getMGState();
                    boolean bl = inRange = agentPoint.getObjectiveValue() >= this.m_toleratedMin && agentPoint.getObjectiveValue() <= this.m_toleratedMax;
                    if (!Library.replace(this.m_envCompareEngine, agentPoint, this.m_totalBestPoint)) continue;
                    this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.m_totalBestPoint.isFeasible());
                    if (inRange) continue;
                    this.m_toleratedMin = agentPoint.getObjectiveValue() - (Double)this.m_tolerance.getValue();
                    this.m_toleratedMax = agentPoint.getObjectiveValue() + (Double)this.m_tolerance.getValue();
                    this.m_toleratedCount = 0;
                }
                if (this.m_specCompareEngine instanceof IUpdateCycleEngine) {
                    ((IUpdateCycleEngine)((Object)this.m_specCompareEngine)).updateCycle(learningCycle);
                }
                this.m_solverStatusDialog.setIteration(learningCycle);
                this.m_solverStatusDialog.setStagnation(this.m_toleratedCount);
                this.m_solverStatusDialog.setRuntime(runtime + (System.nanoTime() - startTime));
                this.m_xReschedule.reschedule();
                ++learningCycle;
            }
            this.applySolution();
            this.unlockDocument();
            this.m_solverStatusDialog.setRuntime(runtime += System.nanoTime() - startTime);
        } while (this.m_solverStatusDialog.waitForUser() == 2);
        this.lockDocument();
        this.finalizeSolve();
    }
}

