/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.AdjustmentEvent;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XScrollBar;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.EventObject;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import java.util.ArrayList;

public abstract class ControlScroller {
    protected WizardDialog CurUnoDialog;
    protected int ncurfieldcount;
    private int nblockincrement;
    private int nlineincrement;
    private int nscrollvalue = 0;
    private int ntotfieldcount;
    private XScrollBar xScrollBar;
    private ArrayList<PropertyValue[]> scrollfields;
    protected int iCompPosX;
    protected int iCompPosY;
    protected int iCompWidth;
    protected int iCompHeight;
    protected short curtabindex;
    protected Integer IStep;
    int iScrollBarWidth = 10;
    private int SORELFIRSTPOSY = 3;
    protected int curHelpIndex;
    private String sIncSuffix;
    protected ArrayList<Object> ControlGroupVector = new ArrayList();

    protected ControlScroller(WizardDialog _CurUnoDialog, int _iStep, int _iCompPosX, int _iCompPosY, int _iCompWidth, int _nblockincrement, int _nlinedistance, int _firsthelpindex) {
        this.nblockincrement = _nblockincrement;
        this.CurUnoDialog = _CurUnoDialog;
        this.curHelpIndex = _firsthelpindex;
        this.curtabindex = UnoDialog.setInitialTabindex(_iStep);
        this.IStep = _iStep;
        this.iCompPosX = _iCompPosX;
        this.iCompPosY = _iCompPosY;
        this.iCompWidth = _iCompWidth;
        this.iCompHeight = 2 * this.SORELFIRSTPOSY + this.nblockincrement * _nlinedistance;
        int iStartPosY = this.iCompPosY + this.SORELFIRSTPOSY;
        int ScrollHeight = this.iCompHeight - 2;
        this.nlineincrement = 1;
        this.sIncSuffix = Desktop.getIncrementSuffix(this.CurUnoDialog.getDlgNameAccess(), "TitleScrollBar");
        this.xScrollBar = this.CurUnoDialog.insertScrollBar("TitleScrollBar" + this.sIncSuffix, 0, new AdjustmentListenerImpl(), new String[]{PropertyNames.PROPERTY_BORDER, PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{(short)0, Boolean.TRUE, ScrollHeight, HelpIds.getHelpIdString(this.curHelpIndex), 1, this.iCompPosX + this.iCompWidth - this.iScrollBarWidth - 1, this.iCompPosY + 1, this.IStep, this.iScrollBarWidth});
        this.scrollfields = new ArrayList();
        int ypos = iStartPosY + this.SORELFIRSTPOSY;
        for (int i = 0; i < this.nblockincrement; ++i) {
            this.insertControlGroup(i, ypos);
            ypos += _nlinedistance;
        }
    }

    protected void initialize(int _ntotfieldcount) {
        try {
            this.ntotfieldcount = _ntotfieldcount;
            this.setCurFieldCount();
            this.nscrollvalue = 0;
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), "ScrollValue", this.nscrollvalue);
            if (this.ntotfieldcount > this.nblockincrement) {
                Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{PropertyNames.PROPERTY_ENABLED, "BlockIncrement", "LineIncrement", "ScrollValue", "ScrollValueMax"}, new Object[]{Boolean.TRUE, this.nblockincrement, this.nlineincrement, this.nscrollvalue, this.ntotfieldcount - this.nblockincrement});
            } else {
                Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{PropertyNames.PROPERTY_ENABLED, "ScrollValue"}, new Object[]{Boolean.FALSE, this.nscrollvalue});
            }
            this.fillupControls(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillupControls(boolean binitialize) {
        for (int a = 0; a < this.nblockincrement; ++a) {
            if (a < this.ncurfieldcount) {
                this.fillupControls(a);
            }
            if (!binitialize) continue;
            this.setControlGroupVisible(a, a < this.ncurfieldcount);
        }
        if (binitialize) {
            this.CurUnoDialog.repaintDialogStep();
        }
    }

    private void fillupControls(int guiRow) {
        PropertyValue[] nameProps = this.scrollfields.get(guiRow);
        PropertyValue[] valueProps = this.scrollfields.get(guiRow + this.nscrollvalue);
        for (int n = 0; n < nameProps.length; ++n) {
            if (!this.CurUnoDialog.getDlgNameAccess().hasByName(nameProps[n].Name)) {
                throw new IllegalArgumentException("No such control !");
            }
            this.setControlData(nameProps[n].Name, valueProps[n].Value);
        }
    }

    private void setScrollValue(int _nscrollvalue) {
        if (_nscrollvalue >= 0) {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), "ScrollValue", _nscrollvalue);
            this.scrollControls();
        }
    }

    protected void setScrollValue(int _nscrollvalue, int _ntotfieldcount) {
        this.setTotalFieldCount(_ntotfieldcount);
        this.setScrollValue(_nscrollvalue);
    }

    protected int getTotalFieldCount() {
        return this.ntotfieldcount;
    }

    protected int getCurFieldCount() {
        return this.ncurfieldcount;
    }

    private void setCurFieldCount() {
        this.ncurfieldcount = this.ntotfieldcount > this.nblockincrement ? this.nblockincrement : this.ntotfieldcount;
    }

    protected void setTotalFieldCount(int _ntotfieldcount) {
        this.ntotfieldcount = _ntotfieldcount;
        this.setCurFieldCount();
        if (this.ntotfieldcount > this.nblockincrement) {
            Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{PropertyNames.PROPERTY_ENABLED, "ScrollValueMax"}, new Object[]{Boolean.TRUE, this.ntotfieldcount - this.nblockincrement});
        } else {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
        }
    }

    protected void toggleComponent(boolean _bdoenable) {
        boolean bdoenable = _bdoenable && this.ntotfieldcount > this.nblockincrement;
        this.CurUnoDialog.setControlProperty("TitleScrollBar" + this.sIncSuffix, PropertyNames.PROPERTY_ENABLED, bdoenable);
    }

    protected void toggleControls(boolean _bdoenable) {
        for (int n = 0; n < this.scrollfields.size(); ++n) {
            PropertyValue[] curproperties = this.scrollfields.get(n);
            for (int m = 0; m < curproperties.length; ++m) {
                PropertyValue curproperty = curproperties[m];
                this.CurUnoDialog.setControlProperty(curproperty.Name, PropertyNames.PROPERTY_ENABLED, _bdoenable);
            }
        }
    }

    protected int getScrollValue() {
        return this.nscrollvalue;
    }

    protected int getBlockIncrementation() {
        return this.nblockincrement;
    }

    private void scrollControls() {
        try {
            this.scrollRowsInfo();
            this.nscrollvalue = (Integer)Helper.getUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), "ScrollValue");
            if (this.nscrollvalue + this.nblockincrement >= this.ntotfieldcount) {
                this.nscrollvalue = this.ntotfieldcount - this.nblockincrement;
            }
            this.fillupControls(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void scrollRowsInfo() {
        int cols = this.scrollfields.size() > 0 ? this.scrollfields.get(0).length : 0;
        for (int a = 0; a < this.ncurfieldcount; ++a) {
            for (int n = 0; n < cols; ++n) {
                this.fieldInfo(a, n);
            }
        }
    }

    private PropertyValue fieldInfo(int guiRow, int column) {
        if (guiRow + this.nscrollvalue < this.scrollfields.size()) {
            return this.fieldInfo(this.scrollfields.get(guiRow + this.nscrollvalue)[column], this.scrollfields.get(guiRow)[column]);
        }
        return null;
    }

    private PropertyValue fieldInfo(PropertyValue valueProp, PropertyValue nameProp) {
        valueProp.Value = this.CurUnoDialog.getDlgNameAccess().hasByName(nameProp.Name) ? this.getControlData(nameProp.Name) : nameProp.Value;
        return valueProp;
    }

    protected void unregisterControlGroup(int _index) {
        this.scrollfields.remove(_index);
    }

    protected void registerControlGroup(PropertyValue[] _currowproperties, int _i) {
        if (_i == 0) {
            this.scrollfields.clear();
        }
        if (_i >= this.scrollfields.size()) {
            this.scrollfields.add(_currowproperties);
        } else {
            this.scrollfields.set(_i, _currowproperties);
        }
    }

    private void setControlData(String controlname, Object newvalue) {
        Object oControlModel = UnoDialog.getModel(this.CurUnoDialog.xDlgContainer.getControl(controlname));
        String propertyname = UnoDialog.getDisplayProperty(oControlModel);
        if (!propertyname.equals(PropertyNames.EMPTY_STRING)) {
            this.CurUnoDialog.setControlProperty(controlname, propertyname, newvalue);
        }
    }

    private Object getControlData(String controlname) {
        Object oControlModel = UnoDialog.getModel(this.CurUnoDialog.xDlgContainer.getControl(controlname));
        String propertyname = UnoDialog.getDisplayProperty(oControlModel);
        if (!propertyname.equals(PropertyNames.EMPTY_STRING)) {
            return this.CurUnoDialog.getControlProperty(controlname, propertyname);
        }
        return null;
    }

    protected PropertyValue[][] getScrollFieldValues() {
        this.scrollRowsInfo();
        PropertyValue[][] retproperties = new PropertyValue[this.scrollfields.size()][];
        try {
            for (int i = 0; i < this.scrollfields.size(); ++i) {
                PropertyValue[] curproperties = this.scrollfields.get(i);
                retproperties[i] = curproperties;
            }
            return retproperties;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    protected abstract void initializeScrollFields();

    protected abstract void insertControlGroup(int var1, int var2);

    protected abstract void setControlGroupVisible(int var1, boolean var2);

    private class AdjustmentListenerImpl
    implements XAdjustmentListener {
        private AdjustmentListenerImpl() {
        }

        public void disposing(EventObject eventObject) {
        }

        public void adjustmentValueChanged(AdjustmentEvent AdjustEvent) {
            ControlScroller.this.scrollControls();
        }
    }
}

