/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class SecurityController {
    public abstract GeneratedClassLoader createClassLoader(ClassLoader var1, Object var2);

    public static GeneratedClassLoader createLoader(ClassLoader parent, Object staticDomain) {
        GeneratedClassLoader loader;
        SecurityController sc;
        Context cx = Context.getContext();
        if (parent == null) {
            parent = cx.getApplicationClassLoader();
        }
        if ((sc = cx.getSecurityController()) == null) {
            loader = cx.createClassLoader(parent);
        } else {
            Object dynamicDomain = sc.getDynamicSecurityDomain(staticDomain);
            loader = sc.createClassLoader(parent, dynamicDomain);
        }
        return loader;
    }

    public abstract Object getDynamicSecurityDomain(Object var1);

    public Object callWithDomain(Object securityDomain, Context cx, final Callable callable, Scriptable scope, final Scriptable thisObj, final Object[] args) throws JavaScriptException {
        return this.execWithDomain(cx, scope, new Script(){

            @Override
            public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
                return callable.call(cx, scope, thisObj, args);
            }
        }, securityDomain);
    }

    public Object execWithDomain(Context cx, Scriptable scope, Script script, Object securityDomain) throws JavaScriptException {
        throw new IllegalStateException("callWithDomain should be overridden");
    }
}

