/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.ListDec;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.io.IOException;

public class EnumerateDec
extends ListDec {
    public EnumerateDec() {
        this("enumerate");
    }

    public EnumerateDec(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new EnumerateDec(this.getName());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.setup(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.setup(teXParser);
    }

    @Override
    public void setup(TeXParser teXParser) throws IOException {
        super.setup(teXParser);
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@enumdepth", LaTeXParserListener.ONE);
        String string = "enum" + RomanNumeral.romannumeral(numericRegister.number(teXParser));
        GenericCommand genericCommand = new GenericCommand(true, "@enumctr", null, teXParser.getListener().createString(string));
        teXParser.putControlSequence(true, genericCommand);
        ControlSequence controlSequence = teXParser.getControlSequence("label" + string);
        if (controlSequence == null) {
            controlSequence = teXParser.getListener().getControlSequence("relax");
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getControlSequence("usecounter"));
        teXObjectList.add(genericCommand);
        this.setup(teXParser, controlSequence, teXObjectList);
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@enumdepth", LaTeXParserListener.MINUS_ONE);
        super.end(teXParser);
    }
}

