/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.common;

import java.util.Objects;
import org.snakeyaml.engine.v2.common.CharConstants;

public class Anchor {
    private final String anchor;

    public Anchor(String anchor) {
        Objects.requireNonNull(anchor, "Anchor must be provided.");
        if (anchor.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor.");
        }
        if (!CharConstants.ANCHOR_FORMAT.matcher(anchor).matches()) {
            throw new IllegalArgumentException("invalid character in the anchor: " + anchor);
        }
        this.anchor = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String toString() {
        return this.anchor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Anchor anchor1 = (Anchor)o;
        return Objects.equals(this.anchor, anchor1.anchor);
    }

    public int hashCode() {
        return Objects.hash(this.anchor);
    }
}

