# Octave
[![Join the chat at https://gitter.im/texmacs/Lobby](https://badges.gitter.im/texmacs/Lobby.svg)](https://gitter.im/texmacs/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

## Installation
It is a built-in plugin in TeXmacs. If you need to customize it, please install it
under the `$TEXMACS_HOME_PATH`:

```
# For GNU/Linux or macOS
git clone git@github.com:texmacs/octave.git $HOME/.TeXmacs/plugins/octave

# For Windows
git clone git@github.com:texmacs/octave.git %APPDATA%\TeXmacs\plugins/octave
```


# The Original README
## Octave to TeXmacs interface
by Michael Graffam <mgraffam@mathlab.sunysb.edu>

All materials in this archive are free as in freedom and are distributed
under the GNU General Public License. Please see the file COPYING for
information about your rights and responsibilities under this license. 

Octave and TeXmacs integrate very easily once a few internal Octave 
variables have been set appropriately. In the future, Octave may natively
support TeXmacs coding and use of the PS1 and PS2 variables may become
obsolete. However, the included m-files (the real meat) should work 
with either interface. 

In your `~/.octaverc` file, or in your system-wide octaverc place the lines:

```
if (length(getenv("TEXMACS_PATH")) > 0)
	PS1="\\002channel:prompt\\005\s:\#> \\005";
	PS2="\\002channel:prompt\\005> \\005";
	global TMSTRUCT=0;
	global TMCOLORS=["black"; "red"; "magenta"; "orange"; "green"; "blue";];
	global TMCOLIDX=6;
endif
```

This places the required TeXmacs coding into Octave's prompt strings and 
sets some configuration variables. To launch Octave from TeXmacs simply 
have TeXmacs call a script like the following (this script is included as 
"tm_octave"):

```
#!/bin/bash
echo -ne "\002verbatim:"
octave -v
exec octave -qi
```

[Note: TeXmacs 1.0.1 and later will detect Octave and set up the session 
management, so this is not necessary ]
	
The TMSTRUCT Octave variable sets the type of TeXmacs output used for
displaying Octave structures. Zero is a tree and non-zero is a bulleted
list. The variables TMCOLORS can be set appropriately for the desired
color scheme used by tmdisp() and other Octave functions.

To use Octave within TeXmacs you'll need Octave code that is aimed at 
producing TeXmacs-compatible output and so forth. A few Octave m-files 
are included for this:

```
tmdisp.m 	  Displays an Octave variable "pretty-printed" via TeXmacs
		  Supports scalar, matrix, structure, list and string types

tmpolyout.m	  Displays an Octave polynomial as a LaTeX formula

num2scm.m	  Converts a scalar to a Scheme expression

mat2scm.m	  Converts a vector or matrix to a Scheme expression

str2scm.m	  Converts an Octave string to a Scheme expression

struct2bullet.m	  Converts an Octave structure to a Scheme bulleted list

struct2tree.m	  Converts an Octave structure to a Scheme tree.
		  The leaves of the tree are switchable between variable 
		  names and contents.

struct2scm.m	  Configurable interface to struct2bullet / struct2tree

list2scm.m	  Converts an Octave list to a Scheme enumerated list
obj2scm.m	  Top-level converter that will convert any of the above
		  Octave types to a Scheme expression. 
```

As necessary (in tmdisp, for example) the TeXmacs interface is tested for, 
and if not present the default Octave output is used. tmdisp may therefore 
be used as a general replacement for Octave's disp that will be compatible 
with both interfaces. 

The files octave.scm and octave.ts need to be placed in the appropriate
places in your TeXmacs directory. See the TeXmacs documentation on 
interfacing to CAS's for more information. 

### Using the TeXmacs interface

After starting TeXmacs insert and Octave session into the document. This 
will start Octave and give you an Octave prompt within the TeXmacs window.

Document settings (such as foreground and background color, fonts, etc) 
can be selected in TeXmacs and the Octave session can be inserted. If this 
TeXmacs document is saved, and then reloaded later it will appear exactly 
the same in TeXmacs but Octave will have been restarted so any variables 
set in Octave will be lost. 

Some of the output generated by the included m-files is interactive, in 
particular the tree output produced when displaying an Octave structure 
through tmdisp() is "switchable." When first displayed the leaves of the 
tree are the names of the fields, but by placing the cursor on the a leaf
and selecting "Switch to next" from the "Switching and Folding" menu in 
TeXmacs (or by using the associated keyboard shortcut) the leaves are 
switched to display the content of the data structure. In this way one can 
easily navigate complicated, nested Octave structures easily. 

