/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

public final class SecurityClassLoad {
    public static void securityClassLoad(ClassLoader loader) throws Exception {
        if (System.getSecurityManager() == null) {
            return;
        }
        SecurityClassLoad.loadCorePackage(loader);
        SecurityClassLoad.loadCoyotePackage(loader);
        SecurityClassLoad.loadLoaderPackage(loader);
        SecurityClassLoad.loadRealmPackage(loader);
        SecurityClassLoad.loadServletsPackage(loader);
        SecurityClassLoad.loadSessionPackage(loader);
        SecurityClassLoad.loadUtilPackage(loader);
        SecurityClassLoad.loadValvesPackage(loader);
        SecurityClassLoad.loadJavaxPackage(loader);
        SecurityClassLoad.loadConnectorPackage(loader);
        SecurityClassLoad.loadTomcatPackage(loader);
    }

    private static final void loadCorePackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.core.";
        loader.loadClass("org.apache.catalina.core.AccessLogAdapter");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.core.ApplicationContextFacade");
        loader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedForward");
        loader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedInclude");
        loader.loadClass("org.apache.catalina.core.AsyncContextImpl");
        loader.loadClass("org.apache.catalina.core.AsyncContextImpl$AsyncRunnable");
        loader.loadClass("org.apache.catalina.core.AsyncContextImpl$DebugException");
        loader.loadClass("org.apache.catalina.core.AsyncListenerWrapper");
        loader.loadClass("org.apache.catalina.core.ContainerBase$PrivilegedAddChild");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.core.DefaultInstanceManager");
        loader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntry");
        loader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntryType");
        loader.loadClass("org.apache.catalina.core.ApplicationHttpRequest$AttributeNamesEnumerator");
    }

    private static final void loadLoaderPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.loader.";
        loader.loadClass("org.apache.catalina.loader.ResourceEntry");
        loader.loadClass("org.apache.catalina.loader.WebappClassLoaderBase$PrivilegedFindResourceByName");
    }

    private static final void loadRealmPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.realm.";
        loader.loadClass("org.apache.catalina.realm.LockOutRealm$LockRecord");
    }

    private static final void loadServletsPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.servlets.";
        loader.loadClass("org.apache.catalina.servlets.DefaultServlet");
    }

    private static final void loadSessionPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.session.";
        loader.loadClass("org.apache.catalina.session.StandardSession");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.session.StandardSession");
        loader.loadClass("org.apache.catalina.session.StandardManager$PrivilegedDoUnload");
    }

    private static final void loadUtilPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.util.";
        loader.loadClass("org.apache.catalina.util.Enumerator");
        loader.loadClass("org.apache.catalina.util.ParameterMap");
        loader.loadClass("org.apache.catalina.util.RequestUtil");
    }

    private static final void loadValvesPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.valves.";
        loader.loadClass("org.apache.catalina.valves.AccessLogValve$3");
    }

    private static final void loadCoyotePackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.coyote.";
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.coyote.http11.AbstractHttp11Processor");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.coyote.http11.Http11Processor");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.coyote.http11.Http11NioProcessor");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.coyote.http11.Http11AprProcessor");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.coyote.http11.AbstractOutputBuffer");
        loader.loadClass("org.apache.coyote.http11.Constants");
        Class<?> clazz = loader.loadClass("org.apache.coyote.Constants");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static final void loadJavaxPackage(ClassLoader loader) throws Exception {
        loader.loadClass("javax.servlet.http.Cookie");
    }

    private static final void loadConnectorPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.catalina.connector.";
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetAttributePrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterMapPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetRequestDispatcherPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterNamesPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterValuePrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetCharacterEncodingPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeadersPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeaderNamesPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetCookiesPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalePrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalesPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.ResponseFacade$SetContentTypePrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.ResponseFacade$DateHeaderPrivilegedAction");
        loader.loadClass("org.apache.catalina.connector.RequestFacade$GetSessionPrivilegedAction");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.connector.ResponseFacade");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.connector.OutputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.connector.CoyoteInputStream");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.connector.InputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.catalina.connector.Response");
    }

    private static final void loadTomcatPackage(ClassLoader loader) throws Exception {
        String basePackage = "org.apache.tomcat.";
        loader.loadClass("org.apache.tomcat.util.buf.B2CConverter");
        loader.loadClass("org.apache.tomcat.util.buf.C2BConverter");
        loader.loadClass("org.apache.tomcat.util.buf.HexUtils");
        loader.loadClass("org.apache.tomcat.util.buf.StringCache");
        loader.loadClass("org.apache.tomcat.util.buf.StringCache$ByteEntry");
        loader.loadClass("org.apache.tomcat.util.buf.StringCache$CharEntry");
        loader.loadClass("org.apache.tomcat.util.buf.UriUtil");
        loader.loadClass("org.apache.tomcat.util.http.HttpMessages");
        Class<?> clazz = loader.loadClass("org.apache.tomcat.util.http.FastHttpDateFormat");
        clazz.newInstance();
        loader.loadClass("org.apache.tomcat.util.http.HttpMessages");
        loader.loadClass("org.apache.tomcat.util.http.parser.HttpParser");
        loader.loadClass("org.apache.tomcat.util.http.parser.HttpParser$DomainParseState");
        loader.loadClass("org.apache.tomcat.util.http.parser.HttpParser$SkipResult");
        loader.loadClass("org.apache.tomcat.util.http.parser.MediaType");
        loader.loadClass("org.apache.tomcat.util.http.parser.MediaTypeCache");
        loader.loadClass("org.apache.tomcat.jni.Status");
        loader.loadClass("org.apache.tomcat.util.net.Constants");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "org.apache.tomcat.util.net.NioBlockingSelector$BlockPoller");
        loader.loadClass("org.apache.tomcat.util.net.SendfileState");
        loader.loadClass("org.apache.tomcat.util.net.SSLSupport$CipherData");
        loader.loadClass("org.apache.tomcat.util.security.PrivilegedGetTccl");
        loader.loadClass("org.apache.tomcat.util.security.PrivilegedSetTccl");
    }

    private static final void loadAnonymousInnerClasses(ClassLoader loader, String enclosingClass) {
        try {
            int i = 1;
            while (true) {
                loader.loadClass(enclosingClass + '$' + i);
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

