/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItem;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;

public final class VMTelemetryModels {
    private final VMTelemetryDataManager dataManager;
    private final DataManagerListener listener;
    private final Timeline timeline;
    private final SynchronousXYItemsModel cpuItemsModel;
    private final SynchronousXYItemsModel memoryItemsModel;
    private final SynchronousXYItemsModel generationsItemsModel;
    private final SynchronousXYItemsModel threadsItemsModel;

    public VMTelemetryModels(VMTelemetryDataManager vMTelemetryDataManager) {
        this.dataManager = vMTelemetryDataManager;
        this.timeline = this.createTimeline();
        this.cpuItemsModel = this.createCPUItemsModel(this.timeline);
        this.memoryItemsModel = this.createMemoryItemsModel(this.timeline);
        this.generationsItemsModel = this.createGenerationsItemsModel(this.timeline);
        this.threadsItemsModel = this.createThreadsItemsModel(this.timeline);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                VMTelemetryModels.this.dataChangedImpl();
            }

            public void dataReset() {
                VMTelemetryModels.this.dataResetImpl();
            }
        };
        vMTelemetryDataManager.addDataListener(this.listener);
    }

    public VMTelemetryDataManager getDataManager() {
        return this.dataManager;
    }

    public SynchronousXYItemsModel cpuItemsModel() {
        return this.cpuItemsModel;
    }

    public SynchronousXYItemsModel memoryItemsModel() {
        return this.memoryItemsModel;
    }

    public SynchronousXYItemsModel generationsItemsModel() {
        return this.generationsItemsModel;
    }

    public SynchronousXYItemsModel threadsItemsModel() {
        return this.threadsItemsModel;
    }

    public void cleanup() {
        this.dataManager.removeDataListener(this.listener);
    }

    private void dataChangedImpl() {
        this.cpuItemsModel.valuesAdded();
        this.memoryItemsModel.valuesAdded();
        this.generationsItemsModel.valuesAdded();
        this.threadsItemsModel.valuesAdded();
    }

    private void dataResetImpl() {
        this.cpuItemsModel.valuesReset();
        this.memoryItemsModel.valuesReset();
        this.generationsItemsModel.valuesReset();
        this.threadsItemsModel.valuesReset();
    }

    private Timeline createTimeline() {
        return new Timeline(){

            public int getTimestampsCount() {
                return VMTelemetryModels.this.dataManager.getItemCount();
            }

            public long getTimestamp(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.timeStamps[n];
            }
        };
    }

    private SynchronousXYItemsModel createCPUItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem("CPU Time", 0L, 1000L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.processCPUTimeInPromile[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 1000L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.GC_TIME_NAME, 0L, 1000L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.relativeGCTimeInPerMil[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 1000L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createMemoryItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.HEAP_SIZE_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.totalMemory[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 0x4000000L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.USED_HEAP_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.usedMemory[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 0x1000000L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createGenerationsItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.SURVGEN_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nSurvivingGenerations[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 11L));
        ProfilerGCXYItem profilerGCXYItem = new ProfilerGCXYItem(""){

            @Override
            public long[] getGCStarts(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcStarts[n];
            }

            @Override
            public long[] getGCEnds(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcFinishs[n];
            }
        };
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{profilerGCXYItem, synchronousXYItem});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createThreadsItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.THREADS_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nTotalThreads[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 3L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.LOADED_CLASSES_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.loadedClassesCount[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 732L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }
}

