/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasource;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSourceProvider {
    private static final boolean SUPPRESS_EXCEPTIONS_UI = Boolean.getBoolean(DataSourceProvider.class.getName() + ".suppressExceptionsUI");
    private static final Logger LOGGER = Logger.getLogger(DataSourceProvider.class.getName());
    private final Set<DataSource> dataSources = Collections.synchronizedSet(new HashSet());
    private final Map<DataChangeListener<? extends DataSource>, Class<? extends DataSource>> listeners = new HashMap<DataChangeListener<? extends DataSource>, Class<? extends DataSource>>();

    DataSourceProvider() {
    }

    public final <Y extends DataSource> void addDataChangeListener(final DataChangeListener<Y> listener, final Class<Y> scope) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (DataSourceProvider.this.listeners.containsKey(listener)) {
                    String msg = "Listener " + listener + " already registered";
                    LOGGER.log(Level.SEVERE, msg, new UnsupportedOperationException(msg));
                } else {
                    DataSourceProvider.this.listeners.put(listener, scope);
                    DataSourceProvider.this.fireCurrentState(listener);
                }
            }
        });
    }

    public final <Y extends DataSource> void removeDataChangeListener(final DataChangeListener<Y> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (!DataSourceProvider.this.listeners.containsKey(listener)) {
                    String msg = "Listener " + listener + " not registered";
                    LOGGER.log(Level.SEVERE, msg, new UnsupportedOperationException(msg));
                } else {
                    DataSourceProvider.this.listeners.remove(listener);
                }
            }
        });
    }

    public final Set<DataSource> getDataSources() {
        return new HashSet<Object>(Arrays.asList(this.dataSources.toArray()));
    }

    public final <Y extends DataSource> Set<Y> getDataSources(Class<Y> scope) {
        return Utils.getFilteredSet(this.getDataSources(), scope);
    }

    protected final void registerDataSource(DataSource added) {
        this.registerDataSources(Collections.singleton(added));
    }

    protected final void registerDataSources(final Set<? extends DataSource> added) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (!added.isEmpty()) {
                    DataSourceProvider.this.registerDataSourcesImpl(DataSourceProvider.this.checkAdded(added));
                }
            }
        });
    }

    protected final void unregisterDataSource(DataSource removed) {
        this.unregisterDataSources(Collections.singleton(removed));
    }

    protected final void unregisterDataSources(final Set<? extends DataSource> removed) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (!removed.isEmpty()) {
                    DataSourceProvider.this.unregisterDataSourcesImpl(DataSourceProvider.this.checkRemoved(removed));
                }
            }
        });
    }

    protected final void changeDataSources(final Set<? extends DataSource> added, final Set<? extends DataSource> removed) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (!removed.isEmpty()) {
                    DataSourceProvider.this.unregisterDataSourcesImpl(DataSourceProvider.this.checkRemoved(removed));
                }
                if (!added.isEmpty()) {
                    DataSourceProvider.this.registerDataSourcesImpl(DataSourceProvider.this.checkAdded(added));
                }
            }
        });
    }

    void registerDataSourcesImpl(Set<? extends DataSource> added) {
        this.dataSources.addAll(added);
        this.fireDataAdded(added);
    }

    void unregisterDataSourcesImpl(Set<? extends DataSource> removed) {
        this.dataSources.removeAll(removed);
        this.fireDataRemoved(removed);
    }

    private Set<? extends DataSource> checkAdded(Set<? extends DataSource> added) {
        HashSet<? extends DataSource> uniqueAdded = new HashSet<DataSource>(added);
        Iterator it = uniqueAdded.iterator();
        while (it.hasNext()) {
            DataSource ds = (DataSource)it.next();
            if (!this.dataSources.contains(ds)) continue;
            it.remove();
            DataSourceProvider.logUnsupportedOperation("DataSource already in repository: " + ds);
        }
        return uniqueAdded;
    }

    private Set<? extends DataSource> checkRemoved(Set<? extends DataSource> removed) {
        HashSet<? extends DataSource> uniqueRemoved = new HashSet<DataSource>(removed);
        Iterator it = uniqueRemoved.iterator();
        while (it.hasNext()) {
            DataSource ds = (DataSource)it.next();
            if (this.dataSources.contains(ds)) continue;
            it.remove();
            DataSourceProvider.logUnsupportedOperation("DataSource not in repository: " + ds);
        }
        return uniqueRemoved;
    }

    private static void logUnsupportedOperation(String msg) {
        if (SUPPRESS_EXCEPTIONS_UI) {
            LOGGER.severe(msg);
        } else {
            LOGGER.log(Level.SEVERE, msg, new UnsupportedOperationException(msg));
        }
    }

    private void fireCurrentState(DataChangeListener<? extends DataSource> listener) {
        this.fireDataChanged(listener, null, null);
    }

    private void fireDataAdded(Set<? extends DataSource> added) {
        this.fireDataChanged(added, Collections.EMPTY_SET);
    }

    private void fireDataRemoved(Set<? extends DataSource> removed) {
        this.fireDataChanged(Collections.EMPTY_SET, removed);
    }

    private void fireDataChanged(Set<? extends DataSource> added, Set<? extends DataSource> removed) {
        Set<DataChangeListener<? extends DataSource>> listenersSet = this.listeners.keySet();
        for (DataChangeListener<? extends DataSource> listener : listenersSet) {
            this.fireDataChanged(listener, added, removed);
        }
    }

    private void fireDataChanged(DataChangeListener<? extends DataSource> listener, Set<? extends DataSource> added, Set<? extends DataSource> removed) {
        Class<? extends DataSource> filter = this.listeners.get(listener);
        Set<? extends DataSource> filteredCurrent = Utils.getFilteredSet(this.dataSources, filter);
        if (added == null && removed == null) {
            DataChangeEvent<? extends DataSource> event = new DataChangeEvent<DataSource>(filteredCurrent, filteredCurrent, null);
            listener.dataChanged(event);
        } else {
            Set<? extends DataSource> filteredRemoved;
            Set<? extends DataSource> filteredAdded = added != null ? Utils.getFilteredSet(added, filter) : Collections.EMPTY_SET;
            Set<? extends DataSource> set = filteredRemoved = removed != null ? Utils.getFilteredSet(removed, filter) : Collections.EMPTY_SET;
            if (!filteredAdded.isEmpty() || !filteredRemoved.isEmpty()) {
                DataChangeEvent<? extends DataSource> event = new DataChangeEvent<DataSource>(filteredCurrent, filteredAdded, filteredRemoved);
                listener.dataChanged(event);
            }
        }
    }
}

