/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.client;

import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;

public class MonitoredData {
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalMNumbers;
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps;
    private int[] threadIds;
    private byte[][] threadStates = new byte[20][20];
    private int[] exThreadIds;
    private long[] exStateTimestamps;
    private byte[] exThreadStates;
    private int mode = 0;
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;
    private int serverState;
    private int serverProgress;

    private MonitoredData(MonitoredNumbersResponse monitoredNumbersResponse) {
        int[] nArray;
        long[] lArray = monitoredNumbersResponse.getGeneralMonitoredNumbers();
        this.generalMNumbers = new long[lArray.length];
        System.arraycopy(lArray, 0, this.generalMNumbers, 0, lArray.length);
        this.mode = monitoredNumbersResponse.getThreadsDataMode();
        if (this.mode == 1) {
            this.nThreads = monitoredNumbersResponse.getNThreads();
            this.nThreadStates = monitoredNumbersResponse.getNThreadStates();
            nArray = monitoredNumbersResponse.getThreadIds();
            this.threadIds = new int[this.nThreads];
            System.arraycopy(nArray, 0, this.threadIds, 0, this.nThreads);
            long[] lArray2 = monitoredNumbersResponse.getStateTimestamps();
            this.stateTimestamps = new long[this.nThreadStates];
            System.arraycopy(lArray2, 0, this.stateTimestamps, 0, this.nThreadStates);
            this.setThreadStates(monitoredNumbersResponse.getThreadStates());
        } else if (this.mode == 2) {
            int n = monitoredNumbersResponse.getExactThreadIds().length;
            this.exThreadIds = new int[n];
            System.arraycopy(monitoredNumbersResponse.getExactThreadIds(), 0, this.exThreadIds, 0, n);
            this.exThreadStates = new byte[n];
            System.arraycopy(monitoredNumbersResponse.getExactThreadStates(), 0, this.exThreadStates, 0, n);
            this.exStateTimestamps = new long[n];
            System.arraycopy(monitoredNumbersResponse.getExactStateTimestamps(), 0, this.exStateTimestamps, 0, n);
        }
        this.nNewThreads = monitoredNumbersResponse.getNNewThreads();
        if (this.nNewThreads > 0) {
            nArray = monitoredNumbersResponse.getNewThreadIds();
            this.newThreadIds = new int[this.nNewThreads];
            System.arraycopy(nArray, 0, this.newThreadIds, 0, this.nNewThreads);
            this.newThreadNames = new String[this.nNewThreads];
            System.arraycopy(monitoredNumbersResponse.getNewThreadNames(), 0, this.newThreadNames, 0, this.nNewThreads);
            this.newThreadClassNames = new String[this.nNewThreads];
            System.arraycopy(monitoredNumbersResponse.getNewThreadClassNames(), 0, this.newThreadClassNames, 0, this.nNewThreads);
        }
        this.gcStarts = monitoredNumbersResponse.getGCStarts();
        MonitoredData.convertToTimeInMillis(this.gcStarts);
        this.gcFinishs = monitoredNumbersResponse.getGCFinishs();
        MonitoredData.convertToTimeInMillis(this.gcFinishs);
        this.serverState = monitoredNumbersResponse.getServerState();
        this.serverProgress = monitoredNumbersResponse.getServerProgress();
    }

    public int getServerState() {
        return this.serverState;
    }

    public int getServerProgress() {
        return this.serverProgress;
    }

    public long getFreeMemory() {
        return this.generalMNumbers[0];
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public long getLastGCPauseInMS() {
        return this.generalMNumbers[6];
    }

    public long getLoadedClassesCount() {
        return this.generalMNumbers[7];
    }

    public long getProcessCpuTime() {
        return this.generalMNumbers[8];
    }

    public static MonitoredData getMonitoredData(MonitoredNumbersResponse monitoredNumbersResponse) {
        return new MonitoredData(monitoredNumbersResponse);
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public long getNSurvivingGenerations() {
        return this.generalMNumbers[4];
    }

    public long getNSystemThreads() {
        return this.generalMNumbers[3];
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public long getNUserThreads() {
        return this.generalMNumbers[2];
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public int getThreadsDataMode() {
        return this.mode;
    }

    public int[] getExplicitThreadIds() {
        return this.exThreadIds;
    }

    public long[] getExplicitStateTimestamps() {
        return this.exStateTimestamps;
    }

    public byte[] getExplicitThreadStates() {
        return this.exThreadStates;
    }

    public long getRelativeGCTimeInPerMil() {
        return this.generalMNumbers[5];
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[][] getThreadStates() {
        return this.threadStates;
    }

    public long getTimestamp() {
        return this.generalMNumbers[9];
    }

    public long getTotalMemory() {
        return this.generalMNumbers[1];
    }

    private static void convertToTimeInMillis(long[] lArray) {
        if (lArray.length > 0) {
            ProfilingSessionStatus profilingSessionStatus = TargetAppRunner.getDefault().getProfilingSessionStatus();
            long l = profilingSessionStatus.startupTimeInCounts;
            long l2 = profilingSessionStatus.startupTimeMillis;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = l2 + (lArray[i] - l) / 1000000L;
            }
        }
    }

    private void setThreadStates(byte[] byArray) {
        this.threadStates = new byte[this.nThreads][this.nThreadStates];
        int n = 0;
        for (int i = 0; i < this.nThreads; ++i) {
            System.arraycopy(byArray, n, this.threadStates[i], 0, this.nThreadStates);
            n += this.nThreadStates;
        }
    }

    private void print() {
        int n;
        for (n = 0; n < this.nThreads; ++n) {
            System.err.print("id = ");
            System.err.print(this.threadIds[n]);
            System.err.print(", states = ");
            for (int i = 0; i < this.nThreadStates; ++i) {
                System.err.print(this.threadStates[n][i]);
            }
            System.err.println();
        }
        if (this.nNewThreads > 0) {
            System.err.println("New threads added: " + this.nNewThreads);
            for (n = 0; n < this.nNewThreads; ++n) {
                System.err.println("  id = " + this.newThreadIds[n] + ", name = " + this.newThreadNames[n] + ", classname = " + this.newThreadClassNames[n]);
            }
        }
        System.err.println();
    }
}

