/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.NoSuchElementException;

abstract class LongIterator {
    static LongIterator EMPTY_ITERATOR = new Empty();

    LongIterator() {
    }

    static LongIterator singleton(long l) {
        return new Singleton(l);
    }

    abstract boolean hasNext();

    abstract long next();

    private static class Singleton
    extends LongIterator {
        private final long item;
        private boolean skipped;

        private Singleton(long l) {
            this.item = l;
        }

        @Override
        boolean hasNext() {
            return !this.skipped;
        }

        @Override
        long next() {
            if (this.hasNext()) {
                this.skipped = true;
                return this.item;
            }
            throw new NoSuchElementException();
        }
    }

    private static class Empty
    extends LongIterator {
        private Empty() {
        }

        @Override
        boolean hasNext() {
            return false;
        }

        @Override
        long next() {
            throw new NoSuchElementException();
        }
    }
}

