/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;

class StackTrace
extends HprofObject {
    private final StackTraceSegment stackTraceSegment;

    StackTrace(StackTraceSegment stackTraceSegment, long l) {
        super(l);
        this.stackTraceSegment = stackTraceSegment;
        assert (this.getHprofBuffer().get(l) == 5);
    }

    long getSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackTraceSegment.stackTraceSerialNumberOffset);
    }

    long getThreadSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackTraceSegment.threadSerialNumberOffset);
    }

    StackFrame[] getStackFrames() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getInt(this.fileOffset + (long)this.stackTraceSegment.numberOfFramesOffset);
        StackFrame[] stackFrameArray = new StackFrame[n];
        long l = this.fileOffset + (long)this.stackTraceSegment.framesListOffset;
        StackFrameSegment stackFrameSegment = this.stackTraceSegment.hprofHeap.getStackFrameSegment();
        int n2 = 0;
        while (n2 < n) {
            long l2 = hprofByteBuffer.getID(l);
            stackFrameArray[n2] = stackFrameSegment.getStackFrameByID(l2);
            ++n2;
            l += (long)hprofByteBuffer.getIDSize();
        }
        return stackFrameArray;
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.stackTraceSegment.hprofHeap.dumpBuffer;
    }
}

