/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.results.jdbc.StringCache;

class SQLParser {
    Object[] commands = new Object[]{"ALTER", 0, "CREATE", 1, "DELETE", 2, "DESCRIBE", 3, "INSERT", 4, "SELECT", 5, "SET", 6, "UPDATE", 7};
    private static final String fromRegexp = "(^\\bSELECT\\b)|(\\bFROM\\b)|(\\bWHERE\\b)|(\\bGROUP\\sBY\\b)|(\\bORDER\\sBY\\b)|(^\\bUPDATE\\b)|(^\\bINSERT INTO\\b)|('[^']*')";
    private static final String wordRegexp = "\\b\\w+\\.?\\w*\\b";
    private final Pattern commandsPattern;
    private final Pattern fromPattern;
    private final Pattern wordPattern;
    private final StringCache strings;

    SQLParser() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.commands.length; i += 2) {
            stringBuffer.append("(^\\b");
            stringBuffer.append(this.commands[i]);
            stringBuffer.append("\\b)|");
        }
        this.commandsPattern = Pattern.compile(stringBuffer.substring(0, stringBuffer.length() - 1).toString(), 2);
        this.fromPattern = Pattern.compile(fromRegexp, 2);
        this.wordPattern = Pattern.compile(wordRegexp, 2);
        this.strings = new StringCache();
    }

    int extractSQLCommandType(String string) {
        if (string != null && string.startsWith("[")) {
            return -2;
        }
        Matcher matcher = this.commandsPattern.matcher(string);
        if (matcher.find()) {
            for (int i = 0; i < this.commands.length; i += 2) {
                if (matcher.start(i / 2 + 1) == -1) continue;
                return (Integer)this.commands[i + 1];
            }
            throw new IllegalArgumentException(matcher.toString());
        }
        return -1;
    }

    String[] extractTables(String string) {
        String string2 = this.extractFromClause(string);
        if (string2 != null) {
            String[] stringArray = string2.trim().split(",");
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Matcher matcher = this.wordPattern.matcher(stringArray[i]);
                if (!matcher.find()) continue;
                hashSet.add(this.strings.intern(matcher.group()));
            }
            return hashSet.toArray(new String[0]);
        }
        return new String[0];
    }

    String extractFromClause(String string) {
        Matcher matcher = this.fromPattern.matcher(string);
        if (matcher.find()) {
            Matcher matcher2;
            if (matcher.start(1) != -1) {
                int n = -1;
                int n2 = -1;
                while (matcher.find()) {
                    if (matcher.end(2) != -1) {
                        n = matcher.end(2);
                        continue;
                    }
                    if (matcher.start(3) != -1) {
                        n2 = matcher.start(3);
                        break;
                    }
                    if (matcher.start(4) != -1) {
                        n2 = matcher.start(4);
                        break;
                    }
                    if (matcher.start(5) == -1) continue;
                    n2 = matcher.start(5);
                    break;
                }
                if (n < n2) {
                    return string.substring(n + 1, n2);
                }
                if (n != -1 && n2 == -1) {
                    return string.substring(n + 1);
                }
            } else if (matcher.start(6) != -1) {
                Matcher matcher3 = this.wordPattern.matcher(string.substring(matcher.end(6) + 1));
                if (matcher3.find()) {
                    return matcher3.group();
                }
            } else if (matcher.start(7) != -1 && (matcher2 = this.wordPattern.matcher(string.substring(matcher.end(7) + 1))).find()) {
                return matcher2.group();
            }
        }
        return null;
    }
}

