/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.monitor;

import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.results.DataManager;

public class VMTelemetryDataManager
extends DataManager {
    public long[] freeMemory;
    public long[] lastGCPauseInMS;
    public long[] loadedClassesCount;
    public long[] processCPUTimeInPromile;
    public long[] nSurvivingGenerations;
    public long[] nSystemThreads;
    public long[] nTotalThreads;
    public long[] nUserThreads;
    public long[] relativeGCTimeInPerMil;
    public long[] timeStamps;
    public long[] totalMemory;
    public long[] usedMemory;
    public long[][] gcFinishs;
    public long[][] gcStarts;
    public long maxHeapSize = Long.MAX_VALUE;
    private MonitoredData lastData = null;
    private boolean firstStart;
    private int lastUnpairedStart;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int itemCount;

    public VMTelemetryDataManager() {
        this(50);
    }

    public VMTelemetryDataManager(int n) {
        this.arrayBufferSize = n;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int n) {
        this.arrayBufferSize = n;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized MonitoredData getLastData() {
        return this.lastData;
    }

    public synchronized void processData(MonitoredData monitoredData) {
        long l;
        long l2 = monitoredData.getProcessCpuTime();
        if (l2 != -1L) {
            if (this.lastData != null) {
                long l3 = (l2 - this.lastData.getProcessCpuTime()) / 1000L;
                long l4 = (monitoredData.getTimestamp() - this.lastData.getTimestamp()) * 1000L;
                if (l4 < 1000L) {
                    l4 = 1000L;
                }
                l = 1000L * l3 / l4;
            } else {
                l = 0L;
            }
        } else {
            l = -1L;
        }
        this.addValuesInternal(monitoredData.getTimestamp(), monitoredData.getFreeMemory(), monitoredData.getTotalMemory(), monitoredData.getNUserThreads(), monitoredData.getNSystemThreads(), monitoredData.getNSurvivingGenerations(), monitoredData.getRelativeGCTimeInPerMil(), monitoredData.getLastGCPauseInMS(), monitoredData.getLoadedClassesCount(), l, monitoredData.getGCStarts(), monitoredData.getGCFinishs());
        this.lastData = monitoredData;
    }

    public synchronized void reset() {
        this.lastData = null;
        this.itemCount = 0;
        this.timeStamps = new long[this.arrayBufferSize];
        this.freeMemory = new long[this.arrayBufferSize];
        this.totalMemory = new long[this.arrayBufferSize];
        this.usedMemory = new long[this.arrayBufferSize];
        this.nUserThreads = new long[this.arrayBufferSize];
        this.nSystemThreads = new long[this.arrayBufferSize];
        this.nTotalThreads = new long[this.arrayBufferSize];
        this.nSurvivingGenerations = new long[this.arrayBufferSize];
        this.relativeGCTimeInPerMil = new long[this.arrayBufferSize];
        this.lastGCPauseInMS = new long[this.arrayBufferSize];
        this.loadedClassesCount = new long[this.arrayBufferSize];
        this.processCPUTimeInPromile = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.gcStarts = new long[this.arrayBufferSize][];
        this.gcFinishs = new long[this.arrayBufferSize][];
        this.firstStart = true;
        this.lastUnpairedStart = -1;
        this.fireDataReset();
    }

    private void addValuesInternal(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long[] lArray, long[] lArray2) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = l;
        this.freeMemory[this.itemCount] = l2;
        this.totalMemory[this.itemCount] = l3;
        this.usedMemory[this.itemCount] = l3 - l2;
        this.nUserThreads[this.itemCount] = l4;
        this.nSystemThreads[this.itemCount] = l5;
        this.nTotalThreads[this.itemCount] = l5 + l4;
        this.nSurvivingGenerations[this.itemCount] = l6;
        this.relativeGCTimeInPerMil[this.itemCount] = l7;
        this.lastGCPauseInMS[this.itemCount] = l8;
        this.loadedClassesCount[this.itemCount] = l9;
        this.processCPUTimeInPromile[this.itemCount] = l10;
        if (lArray.length > 0 || lArray2.length > 0) {
            int n = lArray.length;
            if (this.firstStart && (n > 0 || lArray2.length > 0)) {
                if (n == 0 || lArray[0] > lArray2[0]) {
                    long[] lArray3 = new long[n + 1];
                    if (n > 0) {
                        System.arraycopy(lArray, 0, lArray3, 1, n);
                    }
                    lArray3[0] = this.timeStamps[0];
                    lArray = lArray3;
                }
                this.firstStart = false;
            }
            boolean bl = lArray.length == lArray2.length;
            boolean bl2 = bl && this.lastUnpairedStart == -1 || !bl && this.lastUnpairedStart != -1;
            int n2 = bl2 ? 0 : 1;
            int n3 = Math.max(lArray.length, lArray2.length) + n2;
            if (lArray.length == n3) {
                this.gcStarts[this.itemCount] = lArray;
            } else {
                this.gcStarts[this.itemCount] = new long[n3];
                System.arraycopy(lArray, 0, this.gcStarts[this.itemCount], n2, lArray.length);
            }
            if (lArray2.length == n3) {
                this.gcFinishs[this.itemCount] = lArray2;
            } else {
                this.gcFinishs[this.itemCount] = new long[n3];
                System.arraycopy(lArray2, 0, this.gcFinishs[this.itemCount], 0, lArray2.length);
            }
            if (!bl2) {
                this.gcFinishs[this.itemCount][n3 - 1] = -1L;
            }
            if (this.lastUnpairedStart != -1) {
                long[] lArray4 = this.gcStarts[this.lastUnpairedStart];
                long[] lArray5 = this.gcFinishs[this.lastUnpairedStart];
                lArray5[lArray5.length - 1] = this.gcFinishs[this.itemCount][0];
                this.gcStarts[this.itemCount][0] = lArray4[lArray4.length - 1];
            }
            this.lastUnpairedStart = !bl2 ? this.itemCount : -1;
        } else {
            this.gcStarts[this.itemCount] = lArray;
            this.gcFinishs[this.itemCount] = lArray2;
        }
        ++this.itemCount;
        this.fireDataChanged();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = VMTelemetryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.freeMemory = VMTelemetryDataManager.extendArray(this.freeMemory, this.arrayBufferSize);
            this.totalMemory = VMTelemetryDataManager.extendArray(this.totalMemory, this.arrayBufferSize);
            this.usedMemory = VMTelemetryDataManager.extendArray(this.usedMemory, this.arrayBufferSize);
            this.nUserThreads = VMTelemetryDataManager.extendArray(this.nUserThreads, this.arrayBufferSize);
            this.nSystemThreads = VMTelemetryDataManager.extendArray(this.nSystemThreads, this.arrayBufferSize);
            this.nTotalThreads = VMTelemetryDataManager.extendArray(this.nTotalThreads, this.arrayBufferSize);
            this.nSurvivingGenerations = VMTelemetryDataManager.extendArray(this.nSurvivingGenerations, this.arrayBufferSize);
            this.relativeGCTimeInPerMil = VMTelemetryDataManager.extendArray(this.relativeGCTimeInPerMil, this.arrayBufferSize);
            this.lastGCPauseInMS = VMTelemetryDataManager.extendArray(this.lastGCPauseInMS, this.arrayBufferSize);
            this.loadedClassesCount = VMTelemetryDataManager.extendArray(this.loadedClassesCount, this.arrayBufferSize);
            this.processCPUTimeInPromile = VMTelemetryDataManager.extendArray(this.processCPUTimeInPromile, this.arrayBufferSize);
            this.gcStarts = VMTelemetryDataManager.extendArray(this.gcStarts, this.arrayBufferSize);
            this.gcFinishs = VMTelemetryDataManager.extendArray(this.gcFinishs, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2 + n];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    private static long[][] extendArray(long[][] lArray, int n) {
        int n2 = lArray.length;
        long[][] lArrayArray = new long[n2 + n][];
        System.arraycopy(lArray, 0, lArrayArray, 0, n2);
        return lArrayArray;
    }
}

