/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.kde;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.keyring.KeyringProvider;

class CommonKWalletProvider
implements KeyringProvider {
    private static final Logger logger = Logger.getLogger(CommonKWalletProvider.class.getName());
    private char[] handler = "0".toCharArray();
    private boolean timeoutHappened = false;
    private char[] defaultLocalWallet = "kdewallet".toCharArray();
    private final String kwalletVersion;
    private final String pathVersion;

    CommonKWalletProvider(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        this.kwalletVersion = string;
        this.pathVersion = string2;
    }

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            logger.fine("native keyring integration disabled");
            return false;
        }
        CommandResult commandResult = this.runCommand("isEnabled", new char[0][]);
        if (new String(commandResult.retVal).equals("true")) {
            return this.updateHandler();
        }
        return false;
    }

    public char[] read(String string) {
        if (this.updateHandler()) {
            CommandResult commandResult = this.runCommand("readPassword", this.handler, this.getApplicationName(), string.toCharArray(), this.getApplicationName());
            if (commandResult.exitCode != 0) {
                this.warning("read action returned not 0 exitCode");
            }
            return commandResult.retVal.length > 0 ? commandResult.retVal : null;
        }
        return null;
    }

    public void save(String string, char[] cArray, String string2) {
        if (this.updateHandler()) {
            CommandResult commandResult = this.runCommand("writePassword", this.handler, this.getApplicationName(), string.toCharArray(), cArray, this.getApplicationName());
            if (commandResult.exitCode != 0 || new String(commandResult.retVal).equals("-1")) {
                this.warning("save action failed");
            }
            return;
        }
    }

    public void delete(String string) {
        if (this.updateHandler()) {
            CommandResult commandResult = this.runCommand("removeEntry", this.handler, this.getApplicationName(), string.toCharArray(), this.getApplicationName());
            if (commandResult.exitCode != 0 || new String(commandResult.retVal).equals("-1")) {
                this.warning("delete action failed");
            }
            return;
        }
    }

    private boolean updateHandler() {
        if (this.timeoutHappened) {
            return false;
        }
        this.handler = new String(this.handler).equals("") ? "0".toCharArray() : this.handler;
        CommandResult commandResult = this.runCommand("isOpen", new char[][]{this.handler});
        if (new String(commandResult.retVal).equals("true")) {
            return true;
        }
        char[] cArray = this.defaultLocalWallet;
        commandResult = this.runCommand("localWallet", new char[0][]);
        if (commandResult.exitCode == 0) {
            cArray = commandResult.retVal;
        }
        if (new String(cArray).contains(".service")) {
            return false;
        }
        commandResult = this.runCommand("open", cArray, "0".toCharArray(), this.getApplicationName());
        if (commandResult.exitCode == 2) {
            this.warning("time out happened while accessing KWallet");
            this.timeoutHappened = true;
            return false;
        }
        if (commandResult.exitCode != 0 || new String(commandResult.retVal).equals("-1")) {
            this.warning("failed to access KWallet");
            return false;
        }
        this.handler = commandResult.retVal;
        return true;
    }

    private CommandResult runCommand(String string, char[] ... cArray) {
        Object[] objectArray = new String[cArray.length + 4];
        objectArray[0] = "qdbus";
        objectArray[1] = "org.kde.kwalletd" + this.kwalletVersion;
        objectArray[2] = "/modules/kwalletd" + this.pathVersion;
        objectArray[3] = "org.kde.KWallet." + string;
        for (int i = 0; i < cArray.length; ++i) {
            objectArray[i + 4] = new String(cArray[i]);
        }
        Runtime runtime = Runtime.getRuntime();
        String string2 = "";
        String string3 = "";
        int n = 0;
        try {
            String string4;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "executing {0}", Arrays.toString(objectArray));
            }
            Process process = runtime.exec((String[])objectArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (!string2.equals("")) {
                    string2 = string2.concat("\n");
                }
                string2 = string2.concat(string4);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (!string3.equals("")) {
                    string3 = string3.concat("\n");
                }
                string3 = string3.concat(string4);
            }
            bufferedReader.close();
            n = process.waitFor();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "application exit with code {0} for commandString: {1}; errVal: {2}", new Object[]{n, Arrays.toString(objectArray), string3});
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(objectArray) + "\"", interruptedException);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(objectArray) + "\"", iOException);
        }
        return new CommandResult(n, string2.trim().toCharArray(), string3.trim());
    }

    private char[] getApplicationName() {
        return "NetBeans IDE".toCharArray();
    }

    private void warning(String string) {
        logger.log(Level.WARNING, "Something went wrong: {0}", string);
    }

    public String toString() {
        return "CommonKWalletProvider{kwalletVersion=" + this.kwalletVersion + ", pathVersion=" + this.pathVersion + '}';
    }

    private class CommandResult {
        private int exitCode;
        private char[] retVal;
        private String errVal;

        public CommandResult(int n, char[] cArray, String string) {
            this.exitCode = n;
            this.retVal = cArray;
            this.errVal = string;
        }
    }
}

