/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class ProfilerProgressDisplayer
extends JPanel
implements ProgressDisplayer {
    protected static final String PROGRESS_STRING = Bundle.ProgressDisplayer_ProgressString();
    protected static final String CANCEL_BUTTON_TEXT = Bundle.ProgressDisplayer_CancelButtonText();
    private static ProfilerProgressDisplayer defaultInstance;
    private Dialog owner;
    private JButton cancelButton;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private ProgressDisplayer.ProgressController controller;

    private ProfilerProgressDisplayer() {
    }

    public ProgressDisplayer showProgress(String string) {
        return this.showProgress(string, null);
    }

    public ProgressDisplayer showProgress(String string, ProgressDisplayer.ProgressController progressController) {
        return this.showProgress(PROGRESS_STRING, string, progressController);
    }

    public ProgressDisplayer showProgress(final String string, final String string2, final ProgressDisplayer.ProgressController progressController) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProfilerProgressDisplayer.this.progressLabel == null) {
                    ProfilerProgressDisplayer.this.initComponents();
                }
                DialogDescriptor dialogDescriptor = ProfilerProgressDisplayer.this.createDialogDescriptor(string, string2, progressController);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.pack();
                ProfilerProgressDisplayer.this.owner = dialog;
                if (ProfilerProgressDisplayer.this.owner instanceof JDialog) {
                    ((JDialog)ProfilerProgressDisplayer.this.owner).setDefaultCloseOperation(0);
                }
                dialog.setVisible(true);
            }
        });
        return this;
    }

    public void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProfilerProgressDisplayer.this.owner != null) {
                    ProfilerProgressDisplayer.this.owner.setVisible(false);
                    ProfilerProgressDisplayer.this.owner.dispose();
                }
                ProfilerProgressDisplayer.this.cleanup();
            }
        });
    }

    public static ProfilerProgressDisplayer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilerProgressDisplayer();
        }
        return defaultInstance;
    }

    private void cleanup() {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
        }
        this.controller = null;
        this.owner = null;
    }

    private DialogDescriptor createDialogDescriptor(String string, String string2, ProgressDisplayer.ProgressController progressController) {
        this.controller = progressController;
        this.progressLabel.setText(string2);
        this.progressBar.setIndeterminate(true);
        DialogDescriptor dialogDescriptor = progressController == null ? new DialogDescriptor((Object)this, string, true, new Object[0], null, 0, null, null) : new DialogDescriptor((Object)this, string, true, new Object[]{this.cancelButton}, null, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[0]);
        return dialogDescriptor;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.progressLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 8, 0, 8);
        this.add((Component)this.progressLabel, gridBagConstraints);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setPreferredSize(new Dimension(300, this.progressBar.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 8, 15, 8);
        this.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), gridBagConstraints);
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProfilerProgressDisplayer.this.controller != null) {
                    ProfilerProgressDisplayer.this.controller.cancel();
                }
            }
        });
    }
}

