/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openide.util.NbPreferences;

class CollapsibleSplitPane
extends JSplitPane {
    private static final String PREF_COLLAPSED = "org.netbeans.modules.profiler.heapwalk.ui.CollapsibleSplitPane.collapsed";
    private static final String PREF_LOCATION = "org.netbeans.modules.profiler.heapwalk.ui.CollapsibleSplitPane.location";
    private int savedDividerLocation;

    CollapsibleSplitPane(Component component, Component component2) {
        super(0, component, component2);
        CustomSplitterUI customSplitterUI = new CustomSplitterUI();
        super.setUI(customSplitterUI);
        this.setResizeWeight(1.0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.savedDividerLocation = NbPreferences.forModule(CollapsibleSplitPane.class).getInt(PREF_LOCATION, this.getPreferredSize().height - 150);
        customSplitterUI.setCollapsed(NbPreferences.forModule(CollapsibleSplitPane.class).getBoolean(PREF_COLLAPSED, false));
    }

    void setCollapsed(boolean bl) {
        this.getBottomComponent().setVisible(!bl);
        if (!bl) {
            this.setDividerLocation(this.savedDividerLocation);
        }
        NbPreferences.forModule(CollapsibleSplitPane.class).putBoolean(PREF_COLLAPSED, bl);
    }

    @Override
    public void setDividerLocation(int n) {
        if (!((CustomSplitterUI)this.getUI()).isCollapsed()) {
            this.savedDividerLocation = n;
            NbPreferences.forModule(CollapsibleSplitPane.class).putInt(PREF_LOCATION, this.savedDividerLocation);
        }
        super.setDividerLocation(n);
    }

    @Override
    public void setUI(SplitPaneUI splitPaneUI) {
    }

    @Override
    public void updateUI() {
    }

    private static class CustomSplitterDivider
    extends BasicSplitPaneDivider {
        private boolean isCollapsed;

        public CustomSplitterDivider(CustomSplitterUI customSplitterUI) {
            super(customSplitterUI);
            this.setLayout(new BorderLayout());
            this.updateCursor();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.setCollapsed(!isCollapsed);
                }
            });
        }

        @Override
        public int getDividerSize() {
            return 6;
        }

        @Override
        public Border getBorder() {
            return null;
        }

        @Override
        public CustomSplitterUI getBasicSplitPaneUI() {
            return (CustomSplitterUI)super.getBasicSplitPaneUI();
        }

        @Override
        protected void setMouseOver(boolean bl) {
            super.setMouseOver(bl);
            this.repaint();
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        void setCollapsed(boolean bl) {
            this.isCollapsed = bl;
            this.updateCursor();
            this.getBasicSplitPaneUI().getSplitPane().setCollapsed(this.isCollapsed);
            this.repaint();
        }

        boolean isCollapsed() {
            return this.isCollapsed;
        }

        private void updateCursor() {
            super.setCursor(this.isCollapsed ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(9));
        }

        @Override
        protected void prepareForDragging() {
            if (!this.isCollapsed) {
                super.prepareForDragging();
            }
        }

        @Override
        protected void dragDividerTo(int n) {
            if (!this.isCollapsed) {
                super.dragDividerTo(n);
            }
        }

        @Override
        protected void finishDraggingTo(int n) {
            if (!this.isCollapsed) {
                super.finishDraggingTo(n);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            Color color2;
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n / 2;
            Color color3 = color2 = this.isMouseOver() ? UIManager.getColor("List.selectionBackground") : this.getBackground();
            if (color2 == null) {
                color2 = this.getBackground();
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            Color color4 = color = this.isMouseOver() ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("controlShadow");
            if (color == null) {
                color = this.getBackground().darker();
            }
            graphics.setColor(color);
            if (this.isCollapsed) {
                int[] nArray = new int[]{n3 - 5, n3 + 4, n3};
                int[] nArray2 = new int[]{5, 5, 0};
                graphics.fillPolygon(nArray, nArray2, 3);
            } else {
                int[] nArray = new int[]{n3 - 4, n3 + 4, n3};
                int[] nArray3 = new int[]{1, 1, 5};
                graphics.fillPolygon(nArray, nArray3, 3);
            }
        }
    }

    private static class CustomSplitterUI
    extends BasicSplitPaneUI {
        private CustomSplitterUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new CustomSplitterDivider(this);
        }

        @Override
        public CollapsibleSplitPane getSplitPane() {
            return (CollapsibleSplitPane)super.getSplitPane();
        }

        void setCollapsed(boolean bl) {
            ((CustomSplitterDivider)this.getDivider()).setCollapsed(bl);
        }

        boolean isCollapsed() {
            return ((CustomSplitterDivider)this.getDivider()).isCollapsed();
        }
    }
}

