/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.about;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.about.HTMLPanel;
import net.sourceforge.jnlp.about.InternalHTMLPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.docprovider.TextsProvider;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.swing.SwingUtils;

public final class AboutDialog
extends JPanel
implements Runnable,
ActionListener {
    private static final String about_url_stub = "/net/sourceforge/jnlp/resources/about";
    private static final String authors_url = "/net/sourceforge/jnlp/resources/AUTHORS.html";
    private static final String changelog_url = "/net/sourceforge/jnlp/resources/ChangeLog.html";
    private static final String copying_url = "/net/sourceforge/jnlp/resources/COPYING.html";
    private static final String news_url = "/net/sourceforge/jnlp/resources/NEWS.html";
    private final String app;
    private final JDialog frame;
    private JPanel contentPane;
    private static HTMLPanel aboutPanel;
    private static HTMLPanel authorsPanel;
    private static HTMLPanel newsPanel;
    private static HTMLPanel changelogPanel;
    private static HTMLPanel copyingPanel;
    private static HTMLPanel helpPanel;
    private final JButton aboutButton;
    private final JButton authorsButton;
    private final JButton newsButton;
    private final JButton changelogButton;
    private final JButton copyingButton;
    private final JButton helpButton;
    private final URL res_authors = this.getClass().getResource("/net/sourceforge/jnlp/resources/AUTHORS.html");
    private final URL res_news = this.getClass().getResource("/net/sourceforge/jnlp/resources/NEWS.html");
    private final URL res_changelog = this.getClass().getResource("/net/sourceforge/jnlp/resources/ChangeLog.html");
    private final URL res_copying = this.getClass().getResource("/net/sourceforge/jnlp/resources/COPYING.html");

    private AboutDialog(boolean modal, String app, ShowPage showPage) {
        super(new GridBagLayout());
        this.app = app;
        this.frame = new JDialog((Frame)null, Translator.R("AboutDialogueTabAbout") + " IcedTea-Web", modal);
        this.frame.setName("AboutDialog");
        SwingUtils.info(this.frame);
        this.frame.setContentPane(this);
        this.frame.setDefaultCloseOperation(2);
        this.aboutButton = new JButton(Translator.R("AboutDialogueTabAbout"));
        this.aboutButton.addActionListener(this);
        this.authorsButton = new JButton(Translator.R("AboutDialogueTabAuthors"));
        this.authorsButton.addActionListener(this);
        this.newsButton = new JButton(Translator.R("AboutDialogueTabNews"));
        this.newsButton.addActionListener(this);
        this.changelogButton = new JButton(Translator.R("AboutDialogueTabChangelog"));
        this.changelogButton.addActionListener(this);
        this.copyingButton = new JButton(Translator.R("AboutDialogueTabGPLv2"));
        this.copyingButton.addActionListener(this);
        this.helpButton = new JButton(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.helpButton.addActionListener(this);
        switch (showPage) {
            case ABOUT: {
                this.actionPerformed(new ActionEvent(this.aboutButton, 0, ""));
                break;
            }
            case AUTHORS: {
                this.actionPerformed(new ActionEvent(this.authorsButton, 0, ""));
                break;
            }
            case CHANGELOG: {
                this.actionPerformed(new ActionEvent(this.changelogButton, 0, ""));
                break;
            }
            case HELP: {
                this.actionPerformed(new ActionEvent(this.helpButton, 0, ""));
                break;
            }
            case LICENSE: {
                this.actionPerformed(new ActionEvent(this.copyingButton, 0, ""));
                break;
            }
            case NEWS: {
                this.actionPerformed(new ActionEvent(this.newsButton, 0, ""));
                break;
            }
            default: {
                this.actionPerformed(new ActionEvent(this.aboutButton, 0, ""));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object action = e.getSource();
        if (action.equals(this.aboutButton)) {
            if (aboutPanel == null) {
                URL about_lang;
                String lang = Locale.getDefault().getLanguage();
                try {
                    about_lang = this.getClass().getResource("/net/sourceforge/jnlp/resources/about_" + lang + ".html");
                    about_lang.openStream().close();
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, ex);
                    about_lang = this.getClass().getResource("/net/sourceforge/jnlp/resources/about_en.html");
                }
                aboutPanel = new HTMLPanel(about_lang);
            }
            this.contentPane = aboutPanel;
        } else if (action.equals(this.authorsButton)) {
            if (authorsPanel == null) {
                authorsPanel = new HTMLPanel(this.res_authors);
            }
            this.contentPane = authorsPanel;
        } else if (action.equals(this.newsButton)) {
            if (newsPanel == null) {
                newsPanel = new HTMLPanel(this.res_news);
            }
            this.contentPane = newsPanel;
        } else if (action.equals(this.changelogButton)) {
            if (changelogPanel == null) {
                changelogPanel = new HTMLPanel(this.res_changelog);
            }
            this.contentPane = changelogPanel;
        } else if (action.equals(this.copyingButton)) {
            if (copyingPanel == null) {
                copyingPanel = new HTMLPanel(this.res_copying);
            }
            this.contentPane = copyingPanel;
        } else if (action.equals(this.helpButton)) {
            if (helpPanel == null) {
                try {
                    File f = File.createTempFile("icedtea-web", "help");
                    f.delete();
                    f.mkdir();
                    f.deleteOnExit();
                    TextsProvider.generateRuntimeHtmlTexts(f);
                    File target = new File(f, "icedtea-web.html");
                    if (this.app != null) {
                        target = new File(f, this.app + "." + "html");
                    }
                    helpPanel = new InternalHTMLPanel(target.toURI().toURL());
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
            this.contentPane = helpPanel;
        }
        this.layoutWindow();
    }

    private void layoutWindow() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.contentPane, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.ipady = 16;
        this.add((Component)this.aboutButton, gbc);
        gbc.gridx = 1;
        this.add((Component)this.authorsButton, gbc);
        gbc.gridx = 2;
        this.add((Component)this.newsButton, gbc);
        gbc.gridx = 3;
        this.add((Component)this.changelogButton, gbc);
        gbc.gridx = 4;
        this.add((Component)this.copyingButton, gbc);
        gbc.gridx = 5;
        this.add((Component)this.helpButton, gbc);
        Dimension contentSize = new Dimension(640, 480);
        this.contentPane.setMinimumSize(contentSize);
        this.contentPane.setPreferredSize(contentSize);
        this.contentPane.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.frame.pack();
    }

    @Override
    public void run() {
        this.layoutWindow();
        ScreenFinder.centerWindowsToCurrentScreen(this.frame);
        this.frame.setVisible(true);
    }

    public static void display(String app) {
        AboutDialog.display(false, app);
    }

    public static void display(boolean modal, String app) {
        AboutDialog.display(modal, app, ShowPage.ABOUT);
    }

    public static void display(boolean modal, String app, ShowPage showPage) {
        SwingUtils.invokeLater(new AboutDialog(modal, app, showPage));
    }

    public static enum ShowPage {
        ABOUT,
        AUTHORS,
        NEWS,
        CHANGELOG,
        LICENSE,
        HELP;

    }
}

