﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/InstanceFamilyCreditSpecification.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{
  class AWS_EC2_API ModifyDefaultCreditSpecificationResponse
  {
  public:
    ModifyDefaultCreditSpecificationResponse();
    ModifyDefaultCreditSpecificationResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    ModifyDefaultCreditSpecificationResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    inline const InstanceFamilyCreditSpecification& GetInstanceFamilyCreditSpecification() const{ return m_instanceFamilyCreditSpecification; }

    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    inline void SetInstanceFamilyCreditSpecification(const InstanceFamilyCreditSpecification& value) { m_instanceFamilyCreditSpecification = value; }

    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    inline void SetInstanceFamilyCreditSpecification(InstanceFamilyCreditSpecification&& value) { m_instanceFamilyCreditSpecification = std::move(value); }

    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    inline ModifyDefaultCreditSpecificationResponse& WithInstanceFamilyCreditSpecification(const InstanceFamilyCreditSpecification& value) { SetInstanceFamilyCreditSpecification(value); return *this;}

    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    inline ModifyDefaultCreditSpecificationResponse& WithInstanceFamilyCreditSpecification(InstanceFamilyCreditSpecification&& value) { SetInstanceFamilyCreditSpecification(std::move(value)); return *this;}


    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }

    
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }

    
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }

    
    inline ModifyDefaultCreditSpecificationResponse& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}

    
    inline ModifyDefaultCreditSpecificationResponse& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}

  private:

    InstanceFamilyCreditSpecification m_instanceFamilyCreditSpecification;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
