﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/sts/STS_EXPORTS.h>
#include <aws/sts/STSRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace STS
{
namespace Model
{

  /**
   */
  class AWS_STS_API GetAccessKeyInfoRequest : public STSRequest
  {
  public:
    GetAccessKeyInfoRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "GetAccessKeyInfo"; }

    Aws::String SerializePayload() const override;

  protected:
    void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline const Aws::String& GetAccessKeyId() const{ return m_accessKeyId; }

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline bool AccessKeyIdHasBeenSet() const { return m_accessKeyIdHasBeenSet; }

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline void SetAccessKeyId(const Aws::String& value) { m_accessKeyIdHasBeenSet = true; m_accessKeyId = value; }

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline void SetAccessKeyId(Aws::String&& value) { m_accessKeyIdHasBeenSet = true; m_accessKeyId = std::move(value); }

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline void SetAccessKeyId(const char* value) { m_accessKeyIdHasBeenSet = true; m_accessKeyId.assign(value); }

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline GetAccessKeyInfoRequest& WithAccessKeyId(const Aws::String& value) { SetAccessKeyId(value); return *this;}

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline GetAccessKeyInfoRequest& WithAccessKeyId(Aws::String&& value) { SetAccessKeyId(std::move(value)); return *this;}

    /**
     * <p>The identifier of an access key.</p> <p>This parameter allows (through its
     * regex pattern) a string of characters that can consist of any upper- or
     * lowercase letter or digit.</p>
     */
    inline GetAccessKeyInfoRequest& WithAccessKeyId(const char* value) { SetAccessKeyId(value); return *this;}

  private:

    Aws::String m_accessKeyId;
    bool m_accessKeyIdHasBeenSet;
  };

} // namespace Model
} // namespace STS
} // namespace Aws
