/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private Set<String> requestedMetrics = Metrics.allMetrics();

    public NodesInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.requestedMetrics.clear();
        if (in.getVersion().before(Version.V_7_7_0)) {
            this.addOrRemoveMetric(in.readBoolean(), Metrics.SETTINGS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.OS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.PROCESS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.JVM.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.THREAD_POOL.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.TRANSPORT.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.HTTP.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.PLUGINS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.INGEST.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metrics.INDICES.metricName());
        } else {
            this.requestedMetrics.addAll(Arrays.asList(in.readStringArray()));
        }
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.all();
    }

    public NodesInfoRequest clear() {
        this.requestedMetrics.clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.requestedMetrics.addAll(Metrics.allMetrics());
        return this;
    }

    public boolean settings() {
        return Metrics.SETTINGS.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest settings(boolean settings) {
        this.addOrRemoveMetric(settings, Metrics.SETTINGS.metricName());
        return this;
    }

    public boolean os() {
        return Metrics.OS.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest os(boolean os) {
        this.addOrRemoveMetric(os, Metrics.OS.metricName());
        return this;
    }

    public boolean process() {
        return Metrics.PROCESS.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest process(boolean process) {
        this.addOrRemoveMetric(process, Metrics.PROCESS.metricName());
        return this;
    }

    public boolean jvm() {
        return Metrics.JVM.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest jvm(boolean jvm) {
        this.addOrRemoveMetric(jvm, Metrics.JVM.metricName());
        return this;
    }

    public boolean threadPool() {
        return Metrics.THREAD_POOL.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest threadPool(boolean threadPool) {
        this.addOrRemoveMetric(threadPool, Metrics.THREAD_POOL.metricName());
        return this;
    }

    public boolean transport() {
        return Metrics.TRANSPORT.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest transport(boolean transport) {
        this.addOrRemoveMetric(transport, Metrics.TRANSPORT.metricName());
        return this;
    }

    public boolean http() {
        return Metrics.HTTP.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest http(boolean http) {
        this.addOrRemoveMetric(http, Metrics.HTTP.metricName());
        return this;
    }

    public NodesInfoRequest plugins(boolean plugins) {
        this.addOrRemoveMetric(plugins, Metrics.PLUGINS.metricName());
        return this;
    }

    public boolean plugins() {
        return Metrics.PLUGINS.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest ingest(boolean ingest) {
        this.addOrRemoveMetric(ingest, Metrics.INGEST.metricName());
        return this;
    }

    public boolean ingest() {
        return Metrics.INGEST.containedIn(this.requestedMetrics);
    }

    public NodesInfoRequest indices(boolean indices) {
        this.addOrRemoveMetric(indices, Metrics.INDICES.metricName());
        return this;
    }

    public boolean indices() {
        return Metrics.INDICES.containedIn(this.requestedMetrics);
    }

    private void addOrRemoveMetric(boolean includeMetric, String metricName) {
        if (includeMetric) {
            this.requestedMetrics.add(metricName);
        } else {
            this.requestedMetrics.remove(metricName);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_7_7_0)) {
            out.writeBoolean(Metrics.SETTINGS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.OS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.PROCESS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.JVM.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.THREAD_POOL.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.TRANSPORT.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.HTTP.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.PLUGINS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.INGEST.containedIn(this.requestedMetrics));
            out.writeBoolean(Metrics.INDICES.containedIn(this.requestedMetrics));
        } else {
            out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
        }
    }

    static enum Metrics {
        SETTINGS("settings"),
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        TRANSPORT("transport"),
        HTTP("http"),
        PLUGINS("plugins"),
        INGEST("ingest"),
        INDICES("indices");

        private String metricName;

        private Metrics(String name) {
            this.metricName = name;
        }

        String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        static Set<String> allMetrics() {
            return Arrays.stream(Metrics.values()).map(Metrics::metricName).collect(Collectors.toSet());
        }
    }
}

