/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class GeoQueryContext
implements ToXContentObject {
    public static final String NAME = "geo";
    private final GeoPoint geoPoint;
    private final int boost;
    private final int precision;
    private final List<Integer> neighbours;
    private static final ObjectParser<Builder, Void> GEO_CONTEXT_PARSER = new ObjectParser("geo");

    private GeoQueryContext(GeoPoint geoPoint, int boost, int precision, List<Integer> neighbours) {
        this.geoPoint = geoPoint;
        this.boost = boost;
        this.precision = precision;
        this.neighbours = neighbours;
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public int getBoost() {
        return this.boost;
    }

    public int getPrecision() {
        return this.precision;
    }

    public List<Integer> getNeighbours() {
        return this.neighbours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoQueryContext that = (GeoQueryContext)o;
        if (this.boost != that.boost) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.geoPoint != null ? !this.geoPoint.equals(that.geoPoint) : that.geoPoint != null) {
            return false;
        }
        return this.neighbours != null ? this.neighbours.equals(that.neighbours) : that.neighbours == null;
    }

    public int hashCode() {
        int result = this.geoPoint != null ? this.geoPoint.hashCode() : 0;
        result = 31 * result + this.boost;
        result = 31 * result + this.precision;
        result = 31 * result + (this.neighbours != null ? this.neighbours.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GeoQueryContext fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        Builder builder = new Builder();
        if (token == XContentParser.Token.START_OBJECT) {
            GEO_CONTEXT_PARSER.parse(parser, (Object)builder, null);
        } else if (token == XContentParser.Token.VALUE_STRING) {
            builder.setGeoPoint(GeoPoint.fromGeohash(parser.text()));
        } else {
            throw new ElasticsearchParseException("geo context must be an object or string", new Object[0]);
        }
        return builder.build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("context");
        builder.field("lat", this.geoPoint.getLat());
        builder.field("lon", this.geoPoint.getLon());
        builder.endObject();
        builder.field("boost", this.boost);
        builder.field("neighbours", this.neighbours);
        builder.field("precision", this.precision);
        builder.endObject();
        return builder;
    }

    static {
        GEO_CONTEXT_PARSER.declareField((parser, geoQueryContext, geoContextMapping) -> geoQueryContext.setGeoPoint(GeoUtils.parseGeoPoint(parser)), new ParseField("context", new String[0]), ObjectParser.ValueType.OBJECT);
        GEO_CONTEXT_PARSER.declareInt(Builder::setBoost, new ParseField("boost", new String[0]));
        GEO_CONTEXT_PARSER.declareField((parser, builder, context) -> builder.setPrecision(GeoUtils.parsePrecision(parser)), new ParseField("precision", new String[0]), ObjectParser.ValueType.INT);
        GEO_CONTEXT_PARSER.declareFieldArray(Builder::setNeighbours, (parser, builder) -> GeoUtils.parsePrecision(parser), new ParseField("neighbours", new String[0]), ObjectParser.ValueType.INT_ARRAY);
        GEO_CONTEXT_PARSER.declareDouble(Builder::setLat, new ParseField("lat", new String[0]));
        GEO_CONTEXT_PARSER.declareDouble(Builder::setLon, new ParseField("lon", new String[0]));
    }

    public static class Builder {
        private GeoPoint geoPoint;
        private int boost = 1;
        private int precision = 12;
        private List<Integer> neighbours = Collections.emptyList();
        private double lat = Double.NaN;
        private double lon = Double.NaN;

        public Builder setBoost(int boost) {
            if (boost <= 0) {
                throw new IllegalArgumentException("boost must be greater than 0");
            }
            this.boost = boost;
            return this;
        }

        public Builder setPrecision(int precision) {
            if (precision < 1 || precision > 12) {
                throw new IllegalArgumentException("precision must be between 1 and 12");
            }
            this.precision = precision;
            return this;
        }

        public Builder setNeighbours(List<Integer> neighbours) {
            for (int neighbour : neighbours) {
                if (neighbour >= 1 && neighbour <= 12) continue;
                throw new IllegalArgumentException("neighbour value must be between 1 and 12");
            }
            this.neighbours = neighbours;
            return this;
        }

        public Builder setGeoPoint(GeoPoint geoPoint) {
            Objects.requireNonNull(geoPoint, "geoPoint must not be null");
            this.geoPoint = geoPoint;
            return this;
        }

        void setLat(double lat) {
            this.lat = lat;
        }

        void setLon(double lon) {
            this.lon = lon;
        }

        public GeoQueryContext build() {
            if (this.geoPoint == null && !Double.isNaN(this.lat) && !Double.isNaN(this.lon)) {
                this.geoPoint = new GeoPoint(this.lat, this.lon);
            }
            Objects.requireNonNull(this.geoPoint, "geoPoint must not be null");
            return new GeoQueryContext(this.geoPoint, this.boost, this.precision, this.neighbours);
        }
    }
}

