/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.HashSet;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Node;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.Untranslated;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public final class SvekResult
extends AbstractTextBlock
implements IEntityImage {
    private final Rose rose = new Rose();
    private final DotData dotData;
    private final DotStringFactory dotStringFactory;
    private MinMax minMax;

    public SvekResult(DotData dotData, DotStringFactory dotStringFactory) {
        this.dotData = dotData;
        this.dotStringFactory = dotStringFactory;
    }

    @Override
    public void drawU(UGraphic ug) {
        for (Cluster cluster : this.dotStringFactory.getBibliotekon().allCluster()) {
            cluster.drawU(ug, new UStroke(1.5), this.dotData.getUmlDiagramType(), this.dotData.getSkinParam());
        }
        HColor color = this.rose.getHtmlColor(this.dotData.getSkinParam(), null, this.getArrowColorParam());
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
        }
        color = HColorUtils.noGradient(color);
        for (Node node : this.dotStringFactory.getBibliotekon().allNodes()) {
            double minX = node.getMinX();
            double minY = node.getMinY();
            UGraphic ug2 = node.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            IEntityImage image = node.getImage();
            image.drawU(ug2.apply(new UTranslate(minX, minY)));
            if (!(image instanceof Untranslated)) continue;
            ((Untranslated)image).drawUntranslated(ug.apply(color), minX, minY);
        }
        HashSet<String> ids = new HashSet<String>();
        for (Line line : this.dotStringFactory.getBibliotekon().allLines()) {
            UGraphic ug2 = line.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            line.drawU(ug2, color, ids);
        }
    }

    private ColorParam getArrowColorParam() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.arrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.arrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.arrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.arrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.arrow;
        }
        throw new IllegalStateException();
    }

    private StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, this.dotData.getUmlDiagramType().getStyleName(), SName.arrow);
    }

    @Override
    public HColor getBackcolor() {
        if (SkinParam.USE_STYLES()) {
            Style style = StyleSignature.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
            return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
        }
        return this.dotData.getSkinParam().getBackgroundColor(false);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.minMax == null) {
            this.minMax = TextBlockUtils.getMinMax(this, stringBounder, false);
            this.dotStringFactory.moveSvek(6.0 - this.minMax.getMinX(), 6.0 - this.minMax.getMinY());
        }
        return Dimension2DDouble.delta(this.minMax.getDimension(), 0.0, 12.0);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

