/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.prefix.PrefixMapperTable;
import org.protege.editor.owl.ui.prefix.PrefixMapperTables;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class GeneratePrefixFromOntologyAction
extends AbstractAction {
    private OWLEditorKit owlEditorKit;
    private PrefixMapperTables tables;

    public GeneratePrefixFromOntologyAction(OWLEditorKit owlEditorKit, PrefixMapperTables tables) {
        super("Generate from ontology URI", OWLIcons.getIcon("prefix.generate.png"));
        this.putValue("ShortDescription", "Generate prefix mappings from ontology URIs...");
        this.owlEditorKit = owlEditorKit;
        this.tables = tables;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIHelper uiHelper = new UIHelper(this.owlEditorKit);
        Set<OWLOntology> ontologies = uiHelper.pickOWLOntologies();
        for (OWLOntology ont : ontologies) {
            String prefix;
            String uriString = ((IRI)ont.getOntologyID().getDefaultDocumentIRI().get()).toString();
            if (uriString.endsWith("/")) {
                String sub = uriString.substring(0, uriString.length() - 1);
                prefix = sub.substring(sub.lastIndexOf("/") + 1, sub.length());
            } else {
                prefix = uriString.substring(uriString.lastIndexOf(47) + 1, uriString.length());
            }
            if (prefix.endsWith(".owl")) {
                prefix = prefix.substring(0, prefix.length() - 4);
            }
            prefix = prefix.toLowerCase();
            if (!uriString.endsWith("#") && !uriString.endsWith("/")) {
                uriString = uriString + "#";
            }
            PrefixMapperTable table = this.tables.getPrefixMapperTable();
            int index = table.getModel().addMapping(prefix, uriString);
            table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

