/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import javax.swing.text.StyleConstants;
import org.protege.editor.owl.ui.renderer.styledstring.CSSConstants;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;

public class BackgroundAttribute
extends StyleAttribute {
    private Color background;

    private BackgroundAttribute(Color background) {
        this.background = background;
    }

    public static BackgroundAttribute get(Color color) {
        return new BackgroundAttribute(color);
    }

    @Override
    public String getCSSPropertyName() {
        return CSSConstants.BACKGROUND.getName();
    }

    @Override
    public String getCSSValue() {
        return Integer.toHexString(this.background.getRGB() & 0xFFFFFF);
    }

    @Override
    public AttributedCharacterIterator.Attribute getAttributedStringAttribute() {
        return TextAttribute.BACKGROUND;
    }

    @Override
    public Object getAttributesStringValue() {
        return this.background;
    }

    @Override
    public StyleConstants getTextAttribute() {
        return (StyleConstants.ColorConstants)StyleConstants.Background;
    }

    @Override
    public Object getTextValue() {
        return this.background;
    }

    public int hashCode() {
        return BackgroundAttribute.class.getSimpleName().hashCode() + this.background.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BackgroundAttribute)) {
            return false;
        }
        BackgroundAttribute other = (BackgroundAttribute)obj;
        return this.background.equals(other.background);
    }
}

