/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Pattern;
import sbt.internal.FullScalaLoader;
import sbt.internal.ScalaLibraryClassLoader;
import sbt.internal.TestInterfaceLoader;
import xsbti.AppProvider;
import xsbti.ScalaProvider;

public final class MetaBuildLoader
extends URLClassLoader {
    private final URLClassLoader fullScalaLoader;
    private final URLClassLoader libraryLoader;
    private final URLClassLoader interfaceLoader;

    MetaBuildLoader(URL[] uRLArray, URLClassLoader uRLClassLoader, URLClassLoader uRLClassLoader2, URLClassLoader uRLClassLoader3) {
        super(uRLArray, (ClassLoader)uRLClassLoader);
        this.fullScalaLoader = uRLClassLoader;
        this.libraryLoader = uRLClassLoader2;
        this.interfaceLoader = uRLClassLoader3;
    }

    public String toString() {
        return "SbtMetaBuildClassLoader";
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fullScalaLoader.close();
        this.libraryLoader.close();
        this.interfaceLoader.close();
    }

    public static MetaBuildLoader makeLoader(AppProvider appProvider) throws IOException {
        Object object;
        Pattern pattern = Pattern.compile("test-interface-[0-9.]+\\.jar");
        File[] fileArray = appProvider.mainClasspath();
        URL[] uRLArray = new URL[1];
        URL[] uRLArray2 = new URL[fileArray.length - 1];
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            object = fileArray[i];
            if (pattern.matcher(((File)object).getName()).find()) {
                uRLArray[0] = ((File)object).toURI().toURL();
                continue;
            }
            uRLArray2[n] = ((File)object).toURI().toURL();
            ++n;
        }
        ScalaProvider scalaProvider = appProvider.scalaProvider();
        ClassLoader classLoader = scalaProvider.launcher().topLoader();
        object = new TestInterfaceLoader(uRLArray, classLoader);
        File[] fileArray2 = scalaProvider.jars();
        URL[] uRLArray3 = new URL[1];
        URL[] uRLArray4 = new URL[fileArray2.length - 1];
        int n2 = 0;
        for (int i = 0; i < fileArray2.length; ++i) {
            File file = fileArray2[i];
            if (file.getName().equals("scala-library.jar")) {
                uRLArray3[0] = file.toURI().toURL();
                continue;
            }
            uRLArray4[n2] = file.toURI().toURL();
            ++n2;
        }
        ScalaLibraryClassLoader scalaLibraryClassLoader = new ScalaLibraryClassLoader(uRLArray3, (ClassLoader)object);
        FullScalaLoader fullScalaLoader = new FullScalaLoader(uRLArray4, scalaLibraryClassLoader);
        return new MetaBuildLoader(uRLArray2, fullScalaLoader, scalaLibraryClassLoader, (URLClassLoader)object);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

