/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.scripted.HandlersProvider;
import sbt.internal.scripted.ListTests;
import sbt.internal.scripted.ScriptedTest;
import sbt.internal.scripted.ScriptedTests;
import sbt.internal.util.ManagedLogger;
import sbt.util.LogExchange$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ScriptedRunnerImpl$ {
    public static ScriptedRunnerImpl$ MODULE$;
    private final AtomicInteger generateId;

    static {
        new ScriptedRunnerImpl$();
    }

    public void run(File resourceBaseDirectory, boolean bufferLog, String[] tests, HandlersProvider handlersProvider) {
        ScriptedTests runner = new ScriptedTests(resourceBaseDirectory, bufferLog, handlersProvider);
        ManagedLogger logger = this.newLogger();
        Seq allTests = (Seq)this.get((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])tests), resourceBaseDirectory, logger).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScriptedTest scriptedTest = x0$1;
            if (scriptedTest == null) {
                throw new MatchError((Object)scriptedTest);
            }
            String group = scriptedTest.group();
            String name = scriptedTest.name();
            Seq<Function0<Option<String>>> seq = runner.scriptedTest(group, name, logger);
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        this.runAll((Seq<Function0<Option<String>>>)allTests);
    }

    public void runAll(Seq<Function0<Option<String>>> tests) {
        Seq errors = (Seq)tests.flatMap((Function1 & Serializable & scala.Serializable)test -> Option$.MODULE$.option2Iterable(((Option)test.apply()).map((Function1 & Serializable & scala.Serializable)err -> err)), Seq$.MODULE$.canBuildFrom());
        if (errors.nonEmpty()) {
            throw package$.MODULE$.error(errors.mkString("Failed tests:\n\t", "\n\t", "\n"));
        }
    }

    public Seq<ScriptedTest> get(Seq<String> tests, File baseDirectory, ManagedLogger log) {
        return tests.isEmpty() ? this.listTests(baseDirectory, log) : this.parseTests(tests);
    }

    public Seq<ScriptedTest> listTests(File baseDirectory, ManagedLogger log) {
        return new ListTests(baseDirectory, (Function1<ScriptedTest, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScriptedRunnerImpl$.$anonfun$listTests$1(x$1)), (Logger)log).listTests();
    }

    public Seq<ScriptedTest> parseTests(Seq<String> in) {
        return (Seq)in.map((Function1 & Serializable & scala.Serializable)testString -> {
            String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])testString.split("/"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String group = (String)((SeqLike)option.get()).apply(0);
            String name = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)group, (Object)name);
            Tuple2 tuple22 = tuple2;
            String group2 = (String)tuple22._1();
            String name2 = (String)tuple22._2();
            return new ScriptedTest(group2, name2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public AtomicInteger generateId() {
        return this.generateId;
    }

    /*
     * WARNING - void declaration
     */
    public ManagedLogger newLogger() {
        void var2_2;
        String loggerName = new StringBuilder(9).append("scripted-").append(this.generateId().incrementAndGet()).toString();
        ManagedLogger x = LogExchange$.MODULE$.logger(loggerName);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$listTests$1(ScriptedTest x$1) {
        return true;
    }

    private ScriptedRunnerImpl$() {
        MODULE$ = this;
        this.generateId = new AtomicInteger();
    }
}

