/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.event.resolve.StartResolveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;

public class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private Set fetchedSet = new HashSet();
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings resolveEngineSettings, EventManager eventManager, SortEngine sortEngine) {
        this.settings = resolveEngineSettings;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    public DependencyResolver getDictatorResolver() {
        return this.dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
        this.settings.setDictatorResolver(dependencyResolver);
    }

    public ResolveReport resolve(File file) throws ParseException, IOException {
        return this.resolve(file.toURI().toURL());
    }

    public ResolveReport resolve(URL uRL) throws ParseException, IOException {
        return this.resolve(uRL, new ResolveOptions());
    }

    public ResolveReport resolve(ModuleRevisionId moduleRevisionId, ResolveOptions resolveOptions, boolean bl) throws ParseException, IOException {
        DefaultModuleDescriptor defaultModuleDescriptor;
        ResolveOptions resolveOptions2 = new ResolveOptions(resolveOptions);
        if (resolveOptions.useSpecialConfs()) {
            ResolvedModuleRevision resolvedModuleRevision = this.findModule(moduleRevisionId, new ResolveOptions(resolveOptions));
            if (resolvedModuleRevision == null) {
                Message.verbose("module not found " + moduleRevisionId);
                resolveOptions2.setLog("download-only");
                defaultModuleDescriptor = DefaultModuleDescriptor.newCallerInstance(moduleRevisionId, new String[]{"default"}, resolveOptions.isTransitive(), bl);
            } else {
                String[] stringArray = resolveOptions.getConfs(resolvedModuleRevision.getDescriptor());
                defaultModuleDescriptor = DefaultModuleDescriptor.newCallerInstance(ModuleRevisionId.newInstance(moduleRevisionId, resolvedModuleRevision.getId().getRevision()), stringArray, resolveOptions.isTransitive(), bl);
            }
        } else {
            defaultModuleDescriptor = DefaultModuleDescriptor.newCallerInstance(moduleRevisionId, resolveOptions.getConfs(), resolveOptions.isTransitive(), bl);
        }
        return this.resolve(defaultModuleDescriptor, resolveOptions2);
    }

    public ResolveReport resolve(URL uRL, ResolveOptions resolveOptions) throws ParseException, IOException {
        URLResource uRLResource = new URLResource(uRL);
        ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(uRLResource);
        Message.verbose("using " + moduleDescriptorParser + " to parse " + uRL);
        ModuleDescriptor moduleDescriptor = moduleDescriptorParser.parseDescriptor(this.settings, uRL, resolveOptions.isValidate());
        String string = resolveOptions.getRevision();
        if (string == null && moduleDescriptor.getResolvedModuleRevisionId().getRevision() == null) {
            string = Ivy.getWorkingRevision();
        }
        if (string != null) {
            moduleDescriptor.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(moduleDescriptor.getModuleRevisionId(), string));
        }
        return this.resolve(moduleDescriptor, resolveOptions);
    }

    public ResolveReport resolve(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions) throws ParseException, IOException {
        DependencyResolver dependencyResolver = this.getDictatorResolver();
        IvyContext ivyContext = IvyContext.getContext();
        try {
            Object object;
            Object object2;
            String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
            resolveOptions.setConfs(stringArray);
            if (resolveOptions.getResolveId() == null) {
                resolveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleDescriptor));
            }
            this.eventManager.fireIvyEvent(new StartResolveEvent(moduleDescriptor, stringArray));
            long l = System.currentTimeMillis();
            if ("default".equals(resolveOptions.getLog())) {
                Message.info(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(stringArray));
            } else {
                Message.verbose(":: resolving dependencies :: " + moduleDescriptor.getResolvedModuleRevisionId() + (resolveOptions.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(stringArray));
            }
            Message.verbose("\tvalidate = " + resolveOptions.isValidate());
            Message.verbose("\trefresh = " + resolveOptions.isRefresh());
            ResolveReport resolveReport = new ResolveReport(moduleDescriptor, resolveOptions.getResolveId());
            ResolveData resolveData = new ResolveData(this, resolveOptions);
            ivyContext.setResolveData(resolveData);
            IvyNode[] ivyNodeArray = this.getDependencies(moduleDescriptor, resolveOptions, resolveReport);
            resolveReport.setDependencies(Arrays.asList(ivyNodeArray), resolveOptions.getArtifactFilter());
            if (resolveOptions.getCheckIfChanged()) {
                resolveReport.checkIfChanged();
            }
            ResolutionCacheManager resolutionCacheManager = this.settings.getResolutionCacheManager();
            resolutionCacheManager.saveResolvedModuleDescriptor(moduleDescriptor);
            File file = resolutionCacheManager.getResolvedIvyPropertiesInCache(moduleDescriptor.getResolvedModuleRevisionId());
            Properties properties = new Properties();
            if (ivyNodeArray.length > 0) {
                Object object3;
                DependencyDescriptor dependencyDescriptor;
                int n;
                object2 = new HashMap();
                for (int i = 0; i < ivyNodeArray.length; ++i) {
                    if (ivyNodeArray[i].getModuleRevision() == null || !ivyNodeArray[i].getModuleRevision().isForce()) continue;
                    object2.put(ivyNodeArray[i].getModuleId(), ivyNodeArray[i].getResolvedId());
                }
                object = ivyNodeArray[0].getRoot();
                HashMap<ModuleId, IvyNode> hashMap = new HashMap<ModuleId, IvyNode>();
                for (n = 0; n < ivyNodeArray.length; ++n) {
                    if (ivyNodeArray[n].hasProblem() || (dependencyDescriptor = ivyNodeArray[n].getDependencyDescriptor((IvyNode)object)) == null) continue;
                    object3 = ivyNodeArray[n].getModuleId();
                    hashMap.put((ModuleId)object3, ivyNodeArray[n]);
                }
                for (n = 0; n < ivyNodeArray.length; ++n) {
                    Object object4;
                    if (ivyNodeArray[n].hasProblem() || ivyNodeArray[n].isCompletelyEvicted()) continue;
                    dependencyDescriptor = ivyNodeArray[n].getDependencyDescriptor((IvyNode)object);
                    if (dependencyDescriptor == null && (object4 = (IvyNode)hashMap.get(object3 = ivyNodeArray[n].getModuleId())) != null) {
                        dependencyDescriptor = ((IvyNode)object4).getDependencyDescriptor((IvyNode)object);
                    }
                    if (dependencyDescriptor == null) continue;
                    object3 = ivyNodeArray[n].getResolvedId();
                    object4 = ivyNodeArray[n].getDescriptor();
                    ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
                    ModuleRevisionId moduleRevisionId2 = (ModuleRevisionId)object2.get(ivyNodeArray[n].getModuleId());
                    if (ivyNodeArray[n].getModuleRevision() != null && ivyNodeArray[n].getModuleRevision().isForce() && !((ModuleRevisionId)object3).equals(moduleRevisionId) && !this.settings.getVersionMatcher().isDynamic(moduleRevisionId)) {
                        object3 = moduleRevisionId;
                        object4 = null;
                    }
                    if (object3 == null) {
                        throw new NullPointerException("getResolvedId() is null for " + ivyNodeArray[n].toString());
                    }
                    if (moduleRevisionId == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + dependencyDescriptor.toString());
                    }
                    String string = ((ModuleRevisionId)object3).getRevision();
                    String string2 = moduleRevisionId2 == null ? string : moduleRevisionId2.getRevision();
                    String string3 = object4 == null ? "?" : object4.getStatus();
                    Message.debug("storing dependency " + object3 + " in props");
                    properties.put(moduleRevisionId.encodeToString(), string + " " + string3 + " " + string2 + " " + ((ModuleRevisionId)object3).getBranch());
                }
            }
            object2 = new FileOutputStream(file);
            properties.store((OutputStream)object2, moduleDescriptor.getResolvedModuleRevisionId() + " resolved revisions");
            ((FileOutputStream)object2).close();
            Message.verbose("\tresolved ivy file produced in cache");
            resolveReport.setResolveTime(System.currentTimeMillis() - l);
            if (resolveOptions.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(resolveReport, resolveOptions.getArtifactFilter(), (DownloadOptions)new DownloadOptions().setLog(resolveOptions.getLog()));
            }
            if (resolveOptions.isOutputReport()) {
                this.outputReport(resolveReport, resolutionCacheManager, resolveOptions);
            }
            Message.verbose("\tresolve done (" + resolveReport.getResolveTime() + "ms resolve - " + resolveReport.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new EndResolveEvent(moduleDescriptor, stringArray, resolveReport));
            object = resolveReport;
            return object;
        }
        catch (RuntimeException runtimeException) {
            Message.error(runtimeException.getMessage());
            Message.sumupProblems();
            throw runtimeException;
        }
        finally {
            ivyContext.setResolveData(null);
            this.setDictatorResolver(dependencyResolver);
        }
    }

    public void outputReport(ResolveReport resolveReport, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) throws IOException {
        if ("default".equals(resolveOptions.getLog())) {
            Message.info(":: resolution report :: resolve " + resolveReport.getResolveTime() + "ms :: artifacts dl " + resolveReport.getDownloadTime() + "ms");
        } else {
            Message.verbose(":: resolution report :: resolve " + resolveReport.getResolveTime() + "ms :: artifacts dl " + resolveReport.getDownloadTime() + "ms");
        }
        resolveReport.setProblemMessages(Message.getProblems());
        resolveReport.output(this.settings.getReportOutputters(), resolutionCacheManager, resolveOptions);
    }

    public void downloadArtifacts(ResolveReport resolveReport, Filter filter, DownloadOptions downloadOptions) {
        long l = System.currentTimeMillis();
        IvyNode[] ivyNodeArray = resolveReport.getDependencies().toArray(new IvyNode[resolveReport.getDependencies().size()]);
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent(resolveReport.getArtifacts().toArray(new Artifact[resolveReport.getArtifacts().size()])));
        long l2 = 0L;
        for (int i = 0; i < ivyNodeArray.length; ++i) {
            this.checkInterrupted();
            if (ivyNodeArray[i].isCompletelyEvicted() || ivyNodeArray[i].hasProblem() || ivyNodeArray[i].getModuleRevision() == null) continue;
            DependencyResolver dependencyResolver = ivyNodeArray[i].getModuleRevision().getArtifactResolver();
            Artifact[] artifactArray = ivyNodeArray[i].getSelectedArtifacts(filter);
            DownloadReport downloadReport = dependencyResolver.download(artifactArray, downloadOptions);
            ArtifactDownloadReport[] artifactDownloadReportArray = downloadReport.getArtifactsReports();
            for (int j = 0; j < artifactDownloadReportArray.length; ++j) {
                if (artifactDownloadReportArray[j].getDownloadStatus() == DownloadStatus.FAILED) {
                    if (artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + artifactDownloadReportArray[j].getArtifact() + ". It was required in " + artifactDownloadReportArray[j].getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + artifactDownloadReportArray[j]);
                    dependencyResolver.reportFailure(artifactDownloadReportArray[j].getArtifact());
                    continue;
                }
                if (artifactDownloadReportArray[j].getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                l2 += artifactDownloadReportArray[j].getSize();
            }
            String[] stringArray = ivyNodeArray[i].getRootModuleConfigurations();
            for (int j = 0; j < stringArray.length; ++j) {
                if (ivyNodeArray[i].isEvicted(stringArray[j]) || ivyNodeArray[i].isBlacklisted(stringArray[j])) {
                    resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i]);
                    continue;
                }
                resolveReport.getConfigurationReport(stringArray[j]).addDependency(ivyNodeArray[i], downloadReport);
            }
        }
        resolveReport.setDownloadTime(System.currentTimeMillis() - l);
        resolveReport.setDownloadSize(l2);
    }

    public ArtifactDownloadReport download(Artifact artifact, DownloadOptions downloadOptions) {
        DependencyResolver dependencyResolver = this.settings.getResolver(artifact.getModuleRevisionId());
        DownloadReport downloadReport = dependencyResolver.download(new Artifact[]{artifact}, downloadOptions);
        return downloadReport.getArtifactReport(artifact);
    }

    public ArtifactOrigin locate(Artifact artifact) {
        DependencyResolver dependencyResolver = this.settings.getResolver(artifact.getModuleRevisionId());
        return dependencyResolver.locate(artifact);
    }

    public ArtifactDownloadReport download(ArtifactOrigin artifactOrigin, DownloadOptions downloadOptions) {
        DependencyResolver dependencyResolver = this.settings.getResolver(artifactOrigin.getArtifact().getModuleRevisionId());
        return dependencyResolver.download(artifactOrigin, downloadOptions);
    }

    public IvyNode[] getDependencies(URL uRL, ResolveOptions resolveOptions) throws ParseException, IOException {
        return this.getDependencies(ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, uRL, resolveOptions.isValidate()), resolveOptions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IvyNode[] getDependencies(ModuleDescriptor moduleDescriptor, ResolveOptions resolveOptions, ResolveReport resolveReport) {
        if (moduleDescriptor == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] stringArray = resolveOptions.getConfs(moduleDescriptor);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(stringArray));
            }
            if (moduleDescriptor.getConfiguration(stringArray[i]) != null) continue;
            arrayList.add(" '" + stringArray[i] + "' ");
        }
        if (!arrayList.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (arrayList.size() > 1 ? "s" : "") + " not found in " + moduleDescriptor.getModuleRevisionId() + ": " + arrayList);
        }
        IvyContext ivyContext = IvyContext.pushNewCopyContext();
        try {
            Object object;
            Object object2;
            resolveOptions.setConfs(stringArray);
            Date date = new Date();
            ResolveData resolveData = ivyContext.getResolveData();
            if (resolveData == null) {
                resolveData = new ResolveData(this, resolveOptions);
                ivyContext.setResolveData(resolveData);
            }
            IvyNode ivyNode = new IvyNode(resolveData, moduleDescriptor);
            for (int i = 0; i < stringArray.length; ++i) {
                Message.verbose("resolving dependencies for configuration '" + stringArray[i] + "'");
                this.fetchedSet.clear();
                object2 = null;
                if (resolveReport != null && (object2 = resolveReport.getConfigurationReport(stringArray[i])) == null) {
                    object2 = new ConfigurationResolveReport(this, moduleDescriptor, stringArray[i], date, resolveOptions);
                    resolveReport.addReport(stringArray[i], (ConfigurationResolveReport)object2);
                }
                resolveData.setReport((ConfigurationResolveReport)object2);
                object = new VisitNode(resolveData, ivyNode, null, stringArray[i], null);
                ((VisitNode)object).setRequestedConf(stringArray[i]);
                ivyNode.updateConfsToFetch(Collections.singleton(stringArray[i]));
                boolean bl = false;
                while (!bl) {
                    try {
                        this.fetchDependencies((VisitNode)object, stringArray[i], false);
                        bl = true;
                    }
                    catch (RestartResolveProcess restartResolveProcess) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restartResolveProcess.getMessage());
                        Message.verbose("====================================================");
                        this.fetchedSet.clear();
                    }
                }
                for (IvyNode ivyNode2 : resolveData.getNodes()) {
                    ivyNode2.clean();
                }
            }
            Collection collection = resolveData.getNodes();
            object2 = new LinkedHashSet(collection.size());
            for (IvyNode ivyNode3 : collection) {
                if (ivyNode3 == null || ivyNode3.isRoot() || ivyNode3.isCompletelyBlacklisted()) continue;
                object2.add(ivyNode3);
            }
            object = this.sortEngine.sortNodes((Collection)object2, SortOptions.SILENT);
            Collections.reverse(object);
            this.handleTransiviteEviction(moduleDescriptor, stringArray, resolveData, (List)object);
            IvyNode[] ivyNodeArray = object2.toArray(new IvyNode[object2.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransiviteEviction(ModuleDescriptor moduleDescriptor, String[] stringArray, ResolveData resolveData, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)listIterator.next();
            if (ivyNode.isCompletelyEvicted()) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                IvyNodeCallers.Caller[] callerArray = ivyNode.getCallers(stringArray[i]);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + ivyNode.getId() + " is transitively evicted in " + stringArray[i]);
                }
                boolean bl = callerArray.length > 0;
                for (int j = 0; j < callerArray.length; ++j) {
                    if (callerArray[j].getModuleRevisionId().equals(moduleDescriptor.getModuleRevisionId())) {
                        bl = false;
                        break;
                    }
                    IvyNode ivyNode2 = resolveData.getNode(callerArray[j].getModuleRevisionId());
                    if (ivyNode2 == null) {
                        Message.warn("ivy internal error: no node found for " + callerArray[j].getModuleRevisionId() + ": looked in " + resolveData.getNodeIds() + " and root module id was " + moduleDescriptor.getModuleRevisionId());
                        continue;
                    }
                    if (!ivyNode2.isEvicted(stringArray[i])) {
                        bl = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + ivyNode2.getId() + " of " + ivyNode.getId() + " is evicted");
                }
                if (bl) {
                    Message.verbose("all callers are evicted for " + ivyNode + ": evicting too");
                    ivyNode.markEvicted(stringArray[i], null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(ivyNode.getId() + " isn't transitively evicted, at least one caller was not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode visitNode, String string, boolean bl) {
        int n;
        String[] stringArray;
        this.checkInterrupted();
        long l = System.currentTimeMillis();
        if (visitNode.getParent() != null) {
            Message.verbose("== resolving dependencies " + visitNode.getParent().getId() + "->" + visitNode.getId() + " [" + visitNode.getParentConf() + "->" + string + "]");
        } else {
            Message.verbose("== resolving dependencies for " + visitNode.getId() + " [" + string + "]");
        }
        ResolveData resolveData = visitNode.getNode().getData();
        VisitNode visitNode2 = resolveData.getCurrentVisitNode();
        resolveData.setCurrentVisitNode(visitNode);
        DependencyDescriptor dependencyDescriptor = visitNode.getDependencyDescriptor();
        VersionMatcher versionMatcher = visitNode.getNode().getData().getSettings().getVersionMatcher();
        if (!(dependencyDescriptor == null || visitNode.getRoot() == visitNode.getParent() && versionMatcher.isDynamic(dependencyDescriptor.getDependencyRevisionId()))) {
            this.resolveConflict(visitNode, string);
        }
        if (visitNode.loadData(string, bl)) {
            this.resolveConflict(visitNode, string);
            if (!visitNode.isEvicted() && !visitNode.isCircular()) {
                stringArray = visitNode.getRealConfs(string);
                for (n = 0; n < stringArray.length; ++n) {
                    this.doFetchDependencies(visitNode, stringArray[n]);
                }
            }
        } else if (!(visitNode.hasProblem() || visitNode.isEvicted() || visitNode.isCircular())) {
            stringArray = visitNode.getRealConfs(string);
            for (n = 0; n < stringArray.length; ++n) {
                this.doFetchDependencies(visitNode, stringArray[n]);
            }
        }
        if (visitNode.isEvicted() && (stringArray = visitNode.getEvictedData()).getSelected() != null) {
            for (IvyNode ivyNode : stringArray.getSelected()) {
                if (!ivyNode.isLoaded()) {
                    ivyNode.updateConfsToFetch(Collections.singleton(string));
                    continue;
                }
                this.fetchDependencies(visitNode.gotoNode(ivyNode), string, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(visitNode.getId() + " => dependencies resolved in " + string + " (" + (System.currentTimeMillis() - l) + "ms)");
        }
        resolveData.setCurrentVisitNode(visitNode2);
    }

    private void doFetchDependencies(VisitNode visitNode, String string) {
        String[] stringArray;
        Configuration configuration = visitNode.getConfiguration(string);
        if (configuration == null) {
            if (!visitNode.isConfRequiredByMergedUsageOnly(string)) {
                Message.warn("configuration not found '" + string + "' in " + visitNode.getResolvedId() + ": ignoring");
                if (visitNode.getParent() != null) {
                    Message.warn("it was required from " + visitNode.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean bl = false;
        if (visitNode.getRequestedConf() == null) {
            visitNode.setRequestedConf(string);
            bl = true;
        }
        if ((stringArray = configuration.getExtends()).length > 0) {
            visitNode.updateConfsToFetch(Arrays.asList(stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.fetchDependencies(visitNode, stringArray[i], false);
        }
        if (!this.isDependenciesFetched(visitNode.getNode(), string) && visitNode.isTransitive()) {
            Collection collection = visitNode.getDependencies(string);
            for (VisitNode visitNode2 : collection) {
                int n;
                visitNode2.useRealNode();
                String[] stringArray2 = visitNode2.getRequiredConfigurations(visitNode, string);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], true);
                }
                if (visitNode2.isEvicted() || visitNode2.hasProblem()) continue;
                stringArray2 = visitNode2.getConfsToFetch();
                for (n = 0; n < stringArray2.length; ++n) {
                    this.fetchDependencies(visitNode2, stringArray2[n], false);
                }
            }
            this.markDependenciesFetched(visitNode.getNode(), string);
        }
        if (bl) {
            visitNode.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode ivyNode, String string) {
        String string2 = this.getDependenciesFetchedKey(ivyNode, string);
        return this.fetchedSet.contains(string2);
    }

    private void markDependenciesFetched(IvyNode ivyNode, String string) {
        String string2 = this.getDependenciesFetchedKey(ivyNode, string);
        this.fetchedSet.add(string2);
    }

    private String getDependenciesFetchedKey(IvyNode ivyNode, String string) {
        ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
        String string2 = moduleRevisionId.getOrganisation() + "|" + moduleRevisionId.getName() + "|" + moduleRevisionId.getRevision() + "|" + string;
        return string2;
    }

    private void resolveConflict(VisitNode visitNode, String string) {
        this.resolveConflict(visitNode, visitNode.getParent(), string, Collections.EMPTY_SET);
    }

    private boolean resolveConflict(VisitNode visitNode, VisitNode visitNode2, String string, Collection collection) {
        if (visitNode2 == null || visitNode == visitNode2) {
            return true;
        }
        if (this.checkConflictSolvedEvicted(visitNode, visitNode2)) {
            return true;
        }
        boolean bl = this.settings.debugConflictResolution();
        if (this.checkConflictSolvedSelected(visitNode, visitNode2)) {
            if (this.resolveConflict(visitNode, visitNode2.getParent(), string, collection)) {
                IvyNodeEviction.EvictionData evictionData = visitNode.getEvictionDataInRoot(visitNode.getRootModuleConf(), visitNode2);
                if (evictionData != null) {
                    if (bl) {
                        Message.debug(visitNode + " was previously evicted in root module conf " + visitNode.getRootModuleConf());
                    }
                    visitNode.markEvicted(evictionData);
                    if (bl) {
                        Message.debug("evicting " + visitNode + " by " + evictionData);
                    }
                }
                return true;
            }
            return false;
        }
        Set set = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        set.addAll(visitNode2.getNode().getPendingConflicts(visitNode.getRootModuleConf(), visitNode.getModuleId()));
        Collection collection2 = this.computeConflicts(visitNode, visitNode2, string, collection, set);
        ConflictManager conflictManager = visitNode2.getNode().getConflictManager(visitNode.getModuleId());
        Collection collection3 = this.resolveConflicts(visitNode, visitNode2, collection2, conflictManager);
        if (collection3 == null) {
            if (bl) {
                Message.debug("impossible to resolve conflicts for " + visitNode + " in " + visitNode2 + " yet");
                Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + collection2);
            }
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection2);
            return false;
        }
        if (bl) {
            Message.debug("selected revisions for " + visitNode + " in " + visitNode2 + ": " + collection3);
        }
        if (collection3.contains(visitNode.getNode())) {
            collection = set;
            collection.removeAll(collection3);
            for (IvyNode ivyNode : collection) {
                ivyNode.markEvicted(visitNode.getRootModuleConf(), visitNode2.getNode(), conflictManager, collection3);
                if (!bl) continue;
                Message.debug("evicting " + ivyNode + " by " + ivyNode.getEvictedData(visitNode.getRootModuleConf()));
            }
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection3);
            HashSet hashSet = new HashSet(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            hashSet.removeAll(collection3);
            hashSet.addAll(collection);
            visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), hashSet);
            visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
            return this.resolveConflict(visitNode, visitNode2.getParent(), string, collection);
        }
        if (collection3.isEmpty() && bl) {
            Message.verbose("conflict manager '" + conflictManager + "' evicted all revisions among " + collection2);
        }
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>(visitNode2.getNode().getEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
        collection.removeAll(collection3);
        hashSet.removeAll(collection3);
        hashSet.addAll(collection);
        hashSet.add(visitNode.getNode());
        visitNode2.getNode().setEvictedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), hashSet);
        visitNode2.getNode().setPendingConflicts(visitNode.getModuleId(), visitNode.getRootModuleConf(), Collections.EMPTY_SET);
        visitNode.markEvicted(visitNode2, conflictManager, collection3);
        if (bl) {
            Message.debug("evicting " + visitNode + " by " + visitNode.getEvictedData());
        }
        Set set2 = visitNode2.getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf());
        boolean bl2 = true;
        if (!set2.equals(collection3)) {
            visitNode2.getNode().setResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf(), collection3);
            for (IvyNode ivyNode : collection3) {
                if (set2.contains(ivyNode)) continue;
                bl2 &= this.resolveConflict(visitNode.gotoNode(ivyNode), visitNode2.getParent(), string, collection);
            }
        }
        return bl2;
    }

    private Collection resolveConflicts(VisitNode visitNode, VisitNode visitNode2, Collection collection, ConflictManager conflictManager) {
        if (visitNode.getParent() != visitNode2 && conflictManager == this.settings.getConflictManager(visitNode.getModuleId()) && visitNode.getParent().getNode().getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()).equals(collection)) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("no new conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
            }
            return collection;
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + visitNode + " in " + visitNode2 + ": " + collection);
        }
        return conflictManager.resolveConflicts(visitNode2.getNode(), collection);
    }

    private Collection computeConflicts(VisitNode visitNode, VisitNode visitNode2, String string, Collection collection, Collection collection2) {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        linkedHashSet.add(visitNode.getNode());
        boolean bl = collection2.removeAll(collection);
        if (bl || collection2.isEmpty() && !visitNode.getParent().getNode().equals(visitNode2.getNode())) {
            Collection collection3 = visitNode2.getNode().getDependencies(visitNode.getRootModuleConf(), visitNode2.getNode().getConfigurations(visitNode.getRootModuleConf()), visitNode2.getRequestedConf());
            for (IvyNode ivyNode : collection3) {
                if (ivyNode.getModuleId().equals(visitNode.getModuleId())) {
                    linkedHashSet.add(ivyNode);
                }
                linkedHashSet.addAll(ivyNode.getResolvedNodes(visitNode.getModuleId(), visitNode.getRootModuleConf()));
            }
        } else if (collection2.isEmpty()) {
            VisitNode visitNode3 = visitNode.getParent();
            Collection collection4 = visitNode3.getNode().getDependencies(visitNode.getRootModuleConf(), visitNode3.getNode().getConfigurations(visitNode.getRootModuleConf()), visitNode3.getRequestedConf());
            for (IvyNode ivyNode : collection4) {
                if (!ivyNode.getModuleId().equals(visitNode.getModuleId())) continue;
                linkedHashSet.add(ivyNode);
            }
        } else {
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    private boolean checkConflictSolvedSelected(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getResolvedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    private boolean checkConflictSolvedEvicted(VisitNode visitNode, VisitNode visitNode2) {
        if (visitNode2.getEvictedRevisions(visitNode.getModuleId()).contains(visitNode.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + visitNode + " in " + visitNode2);
            }
            return true;
        }
        return false;
    }

    public ResolvedModuleRevision findModule(ModuleRevisionId moduleRevisionId, ResolveOptions resolveOptions) {
        DependencyResolver dependencyResolver = this.settings.getResolver(moduleRevisionId);
        if (dependencyResolver == null) {
            throw new IllegalStateException("no resolver found for " + moduleRevisionId.getModuleId());
        }
        DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newCallerInstance(moduleRevisionId, new String[]{"*"}, false, false);
        if (resolveOptions.getResolveId() == null) {
            resolveOptions.setResolveId(ResolveOptions.getDefaultResolveId(defaultModuleDescriptor));
        }
        try {
            return dependencyResolver.getDependency(new DefaultDependencyDescriptor(moduleRevisionId, true), new ResolveData(this, resolveOptions, new ConfigurationResolveReport(this, defaultModuleDescriptor, "default", null, resolveOptions)));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("problem while parsing repository module descriptor for " + moduleRevisionId + ": " + parseException, parseException);
        }
    }

    public DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor, ResolveOptions resolveOptions) {
        String string;
        if (dependencyDescriptor == null) {
            return null;
        }
        String string2 = string = resolveOptions.getResolveMode() == null ? this.settings.getResolveMode(dependencyDescriptor.getDependencyId()) : resolveOptions.getResolveMode();
        if ("dynamic".equals(string) && !dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            return dependencyDescriptor.clone(ModuleRevisionId.newInstance(dependencyDescriptor.getDynamicConstraintDependencyRevisionId(), dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dependencyDescriptor;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

