/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarContent {
    public static String TABLE_NAME = "content";
    private Long size;
    private Long compression;
    private String mimeType;
    private String text;
    private String encoding;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarContent(long size, long compression, String mimeType, String text, String encoding, String comment) {
        this.size = size;
        this.compression = compression;
        this.mimeType = mimeType;
        this.text = text;
        this.encoding = encoding;
        this.comment = comment;
    }

    public HarContent(long size, String mimeType) {
        this.size = size;
        this.mimeType = mimeType;
    }

    public HarContent(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"content\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("size".equals(name)) {
                this.setSize(jp.getValueAsLong());
                continue;
            }
            if ("compression".equals(name)) {
                this.setCompression(jp.getValueAsLong());
                continue;
            }
            if ("mimeType".equals(name)) {
                this.setMimeType(jp.getText());
                continue;
            }
            if ("text".equals(name)) {
                this.setText(jp.getText());
                continue;
            }
            if ("encoding".equals(name)) {
                this.setEncoding(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in content element", jp.getCurrentLocation());
        }
        if (this.size == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing size field in content element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing size field in content element", jp.getCurrentLocation());
            }
        }
        if (this.mimeType == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing mimeType field in content element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing mimeType field in content element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarContent(HarDatabaseConfig config, long responseId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,size,compression,mime_type,text,encoding,comment FROM " + tableName + " WHERE response_id=?");
            ps.setLong(1, responseId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarContent for response id " + responseId + " found in database");
            }
            long contentId = rs.getLong(1);
            this.setSize(rs.getLong(2));
            this.setCompression(rs.getLong(3));
            if (rs.wasNull()) {
                this.compression = null;
            }
            this.setMimeType(rs.getString(4));
            this.setText(rs.getString(5));
            this.setEncoding(rs.getString(6));
            this.setComment(rs.getString(7));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARCONTENT, contentId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("content");
        g.writeNumberField("size", this.size.longValue());
        if (this.compression != null) {
            g.writeNumberField("compression", this.compression.longValue());
        }
        g.writeStringField("mimeType", this.mimeType);
        if (this.text != null) {
            g.writeStringField("text", this.text);
        }
        if (this.encoding != null) {
            g.writeStringField("encoding", this.encoding);
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long responseId, HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ",size " + config.getLongDbType() + ",compression " + config.getLongDbType() + ",mime_type " + config.getStringDbType() + ",text " + config.getStringDbType() + ",encoding " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",response_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (size,compression,mime_type,text,encoding,comment,response_id) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setLong(1, this.size);
            if (this.compression == null) {
                ps.setNull(2, -5);
            } else {
                ps.setLong(2, this.compression);
            }
            ps.setString(3, this.mimeType);
            if (this.text == null) {
                ps.setNull(4, -1);
            } else {
                ps.setString(4, this.text);
            }
            if (this.encoding == null) {
                ps.setNull(5, -1);
            } else {
                ps.setString(5, this.encoding);
            }
            if (this.comment == null) {
                ps.setNull(6, -1);
            } else {
                ps.setString(6, this.comment);
            }
            ps.setLong(7, responseId);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarContent entry");
            }
            long contentId = rs.getLong(1);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARCONTENT, contentId, logId);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + tableName + " WHERE response_id IN (SELECT id FROM " + config.getTablePrefix() + "response" + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, tableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCompression() {
        return this.compression;
    }

    public void setCompression(long compression) {
        this.compression = compression;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"content\": { \"size\": " + this.size + ", \"compression\": " + this.compression + ", \"mimeType\": \"" + this.mimeType + "\", \"text\": " + "\"" + this.text + "\", \"encoding\": " + "\"" + this.encoding + "\", \"comment\": " + "\"" + this.comment + "\", " + this.customFields + "}\n";
    }
}

