/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.eventBus;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.eventBus.EventPublisher;

public class SimpleEventBus
implements EventBus {
    private Map<String, RegisteredPublisher> nameToPublisher = new HashMap<String, RegisteredPublisher>();
    private List<RegisteredConsumer> danglingConsumers = new ArrayList<RegisteredConsumer>();
    private final Lock regMgmtLock = new ReentrantLock(true);
    private static Logger log = Logger.getLogger(SimpleEventBus.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublisher(EventPublisher publisher, String ... eventTypes) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        if (eventTypes == null || eventTypes.length == 0) {
            throw new InvalidParameterException("At least one event type must be specified");
        }
        this.regMgmtLock.lock();
        try {
            if (this.nameToPublisher.get(publisher.getPublisherName()) != null) {
                throw new InvalidParameterException("Publisher with name " + publisher.getPublisherName() + " already registered by " + this.nameToPublisher.get(publisher.getPublisherName()).getPublisher().getClass().getCanonicalName());
            }
            log.debug((Object)("registerPublisher " + publisher.getPublisherName()));
            RegisteredPublisher regProd = new RegisteredPublisher(publisher, eventTypes);
            ArrayList<RegisteredConsumer> consumers = new ArrayList<RegisteredConsumer>();
            this.danglingConsumers.removeIf(regCon -> {
                if (regCon.getPublisherName().equals(publisher.getPublisherName())) {
                    consumers.add((RegisteredConsumer)regCon);
                    return true;
                }
                return false;
            });
            regProd.addConsumers(consumers);
            this.nameToPublisher.put(publisher.getPublisherName(), regProd);
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void unregisterPublisher(EventPublisher publisher) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("unregisterPublisher " + publisher.getPublisherName()));
            RegisteredPublisher regPub = this.nameToPublisher.remove(publisher.getPublisherName());
            if (regPub == null) {
                throw new InvalidParameterException("Publisher with name " + publisher.getPublisherName() + " not registered");
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void registerConsumer(EventConsumer consumer, String publisherName) {
        this.registerConsumer(consumer, publisherName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(EventConsumer consumer, String publisherName, String ... eventTypes) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("registerConsumer " + consumer.getClass().getCanonicalName() + " for " + publisherName));
            RegisteredPublisher publisher = this.nameToPublisher.get(publisherName);
            if (publisher == null) {
                this.danglingConsumers.add(new RegisteredConsumer(consumer, eventTypes, publisherName));
            } else {
                publisher.addConsumer(consumer, eventTypes);
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(EventConsumer consumer) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("unregisterConsumer " + consumer.getClass().getCanonicalName()));
            for (Map.Entry<String, RegisteredPublisher> entry : this.nameToPublisher.entrySet()) {
                entry.getValue().removeConsumer(consumer);
            }
            this.removeDanglingConsumer(consumer);
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    private void removeDanglingConsumer(EventConsumer consumer) {
        Iterator<RegisteredConsumer> iter = this.danglingConsumers.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getConsumer().equals(consumer)) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(EventConsumer consumer, String publisherName) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("unregisterConsumer " + consumer.getClass().getCanonicalName() + " for " + publisherName));
            RegisteredPublisher publisher = this.nameToPublisher.get(publisherName);
            if (publisher != null) {
                publisher.removeConsumer(consumer);
            } else {
                this.removeDanglingConsumer(consumer);
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void publishSyncEvent(EventPublisher publisher, Event event) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        RegisteredPublisher regPublisher = this.nameToPublisher.get(publisher.getPublisherName());
        if (regPublisher == null) {
            throw new InvalidParameterException("Publisher not registered: " + publisher.getPublisherName());
        }
        log.debug((Object)("publishSyncEvent " + event.getEventType() + " from " + publisher.getPublisherName()));
        boolean foundType = false;
        for (String type : regPublisher.getEventTypes()) {
            if (!event.getEventType().equals(type)) continue;
            foundType = true;
            break;
        }
        if (!foundType) {
            throw new InvalidParameterException("Event type: " + event.getEventType() + " not registered for publisher: " + publisher.getPublisherName());
        }
        for (RegisteredConsumer regCon : regPublisher.getConsumers()) {
            String[] eventTypes = regCon.getEventTypes();
            boolean isListeningforEvent = false;
            if (eventTypes == null) {
                isListeningforEvent = true;
            } else {
                for (String type : eventTypes) {
                    if (!event.getEventType().equals(type)) continue;
                    isListeningforEvent = true;
                    break;
                }
            }
            if (!isListeningforEvent) continue;
            try {
                regCon.getConsumer().eventReceived(event);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class RegisteredPublisher {
        private EventPublisher publisher;
        private String[] eventTypes;
        private List<RegisteredConsumer> consumers = new CopyOnWriteArrayList<RegisteredConsumer>();

        public RegisteredPublisher(EventPublisher publisher, String[] eventTypes) {
            this.publisher = publisher;
            this.eventTypes = eventTypes;
        }

        public EventPublisher getPublisher() {
            return this.publisher;
        }

        public String[] getEventTypes() {
            return this.eventTypes;
        }

        public List<RegisteredConsumer> getConsumers() {
            return this.consumers;
        }

        public void addConsumers(List<RegisteredConsumer> consumers) {
            this.consumers.addAll(consumers);
        }

        public void addConsumer(EventConsumer consumer, String[] eventTypes) {
            this.consumers.add(new RegisteredConsumer(consumer, eventTypes));
        }

        public void removeConsumer(EventConsumer consumer) {
            for (RegisteredConsumer cons : this.consumers) {
                if (!cons.getConsumer().equals(consumer)) continue;
                this.consumers.remove(cons);
                return;
            }
        }
    }

    private static class RegisteredConsumer {
        private EventConsumer consumer;
        private String[] eventTypes;
        private String publisherName;

        public RegisteredConsumer(EventConsumer consumer, String[] eventTypes) {
            this.consumer = consumer;
            this.eventTypes = eventTypes;
        }

        public RegisteredConsumer(EventConsumer consumer, String[] eventTypes, String publisherName) {
            this.consumer = consumer;
            this.eventTypes = eventTypes;
            this.publisherName = publisherName;
        }

        public EventConsumer getConsumer() {
            return this.consumer;
        }

        public String[] getEventTypes() {
            return this.eventTypes;
        }

        public String getPublisherName() {
            return this.publisherName;
        }
    }
}

