/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;

public class PassiveScannerList {
    private static final Logger logger = Logger.getLogger(PassiveScannerList.class);
    private List<PassiveScanner> passiveScanners = new CopyOnWriteArrayList<PassiveScanner>();
    private Set<String> scannerNames = new HashSet<String>();

    protected boolean add(PassiveScanner scanner) {
        if (this.scannerNames.contains(scanner.getName())) {
            return false;
        }
        this.passiveScanners.add(scanner);
        this.scannerNames.add(scanner.getName());
        return true;
    }

    protected List<PassiveScanner> list() {
        return this.passiveScanners;
    }

    public void setAutoTagScanners(List<RegexAutoTagScanner> autoTagScanners) {
        ArrayList<PassiveScanner> tempScanners = new ArrayList<PassiveScanner>(this.passiveScanners.size() + autoTagScanners.size());
        for (PassiveScanner passiveScanner : this.passiveScanners) {
            if (passiveScanner instanceof RegexAutoTagScanner) {
                this.scannerNames.remove(passiveScanner.getName());
                continue;
            }
            tempScanners.add(passiveScanner);
        }
        for (PassiveScanner passiveScanner : autoTagScanners) {
            if (this.scannerNames.contains(passiveScanner.getName())) {
                logger.error((Object)("Duplicate passive scanner name: " + passiveScanner.getName()));
                continue;
            }
            tempScanners.add(passiveScanner);
            this.scannerNames.add(passiveScanner.getName());
        }
        this.passiveScanners = new CopyOnWriteArrayList<PassiveScanner>(tempScanners);
    }

    public PassiveScanner removeScanner(String className) {
        for (PassiveScanner scanner : this.passiveScanners) {
            if (!scanner.getClass().getName().equals(className)) continue;
            this.scannerNames.remove(scanner.getName());
            this.passiveScanners.remove(scanner);
            return scanner;
        }
        return null;
    }

    public PassiveScanner getScanner(int pluginId) {
        for (PassiveScanner scanner : this.passiveScanners) {
            if (!(scanner instanceof PluginPassiveScanner) || ((PluginPassiveScanner)scanner).getPluginId() != pluginId) continue;
            return scanner;
        }
        return null;
    }
}

