
#ifndef KICONTHEMES_EXPORT_H
#define KICONTHEMES_EXPORT_H

#ifdef KICONTHEMES_STATIC_DEFINE
#  define KICONTHEMES_EXPORT
#  define KICONTHEMES_NO_EXPORT
#else
#  ifndef KICONTHEMES_EXPORT
#    ifdef KF5IconThemes_EXPORTS
        /* We are building this library */
#      define KICONTHEMES_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KICONTHEMES_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KICONTHEMES_NO_EXPORT
#    define KICONTHEMES_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KICONTHEMES_DECL_DEPRECATED
#  define KICONTHEMES_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KICONTHEMES_DECL_DEPRECATED_EXPORT
#  define KICONTHEMES_DECL_DEPRECATED_EXPORT KICONTHEMES_EXPORT KICONTHEMES_DECL_DEPRECATED
#endif

#ifndef KICONTHEMES_DECL_DEPRECATED_NO_EXPORT
#  define KICONTHEMES_DECL_DEPRECATED_NO_EXPORT KICONTHEMES_NO_EXPORT KICONTHEMES_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KICONTHEMES_NO_DEPRECATED
#    define KICONTHEMES_NO_DEPRECATED
#  endif
#endif

#define KICONTHEMES_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KICONTHEMES_NO_DEPRECATED) && !defined(KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KICONTHEMES_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KICONTHEMES_NO_DEPRECATED_WARNINGS) && !defined(KICONTHEMES_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KICONTHEMES_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KICONTHEMES_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KICONTHEMES_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KICONTHEMES_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KICONTHEMES_NO_DEPRECATED)
#  undef KICONTHEMES_DEPRECATED
#  define KICONTHEMES_DEPRECATED_EXPORT KICONTHEMES_EXPORT
#  define KICONTHEMES_DEPRECATED_NO_EXPORT KICONTHEMES_NO_EXPORT
#elif defined(KICONTHEMES_NO_DEPRECATED_WARNINGS)
#  define KICONTHEMES_DEPRECATED
#  define KICONTHEMES_DEPRECATED_EXPORT KICONTHEMES_EXPORT
#  define KICONTHEMES_DEPRECATED_NO_EXPORT KICONTHEMES_NO_EXPORT
#else
#  define KICONTHEMES_DEPRECATED KICONTHEMES_DECL_DEPRECATED
#  define KICONTHEMES_DEPRECATED_EXPORT KICONTHEMES_DECL_DEPRECATED_EXPORT
#  define KICONTHEMES_DEPRECATED_NO_EXPORT KICONTHEMES_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KICONTHEMES_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KICONTHEMES_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KICONTHEMES_NO_DEPRECATED
#  define KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54800
#endif
#ifdef KICONTHEMES_NO_DEPRECATED_WARNINGS
#  define KICONTHEMES_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KICONTHEMES_DEPRECATED_WARNINGS_SINCE
#  ifdef KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KICONTHEMES_DEPRECATED_WARNINGS_SINCE KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KICONTHEMES_DEPRECATED_WARNINGS_SINCE 0x54800
#  endif
#endif

#ifndef KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KICONTHEMES_DEPRECATED
#  define KICONTHEMES_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KICONTHEMES_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KICONTHEMES_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x40800
#  define KICONTHEMES_DEPRECATED_VERSION_4_8(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_4_8(text)
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KICONTHEMES_DEPRECATED_VERSION_5_0(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_5_0(text)
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x53f00
#  define KICONTHEMES_DEPRECATED_VERSION_5_63(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_5_63(text)
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x54000
#  define KICONTHEMES_DEPRECATED_VERSION_5_64(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_5_64(text)
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KICONTHEMES_DEPRECATED_VERSION_5_65(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_5_65(text)
#endif

#if KICONTHEMES_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KICONTHEMES_DEPRECATED_VERSION_5_66(text) KICONTHEMES_DECL_DEPRECATED_TEXT(text)
#else
#  define KICONTHEMES_DEPRECATED_VERSION_5_66(text)
#endif
#define KICONTHEMES_DEPRECATED_VERSION_4(minor, text)      KICONTHEMES_DEPRECATED_VERSION_4_##minor(text)
#define KICONTHEMES_DEPRECATED_VERSION_5(minor, text)      KICONTHEMES_DEPRECATED_VERSION_5_##minor(text)
#define KICONTHEMES_DEPRECATED_VERSION(major, minor, text) KICONTHEMES_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KICONTHEMES_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KICONTHEMES_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* KICONTHEMES_EXPORT_H */
