/* zeitgeist-datamodel.h generated by valac 0.48.5, the Vala compiler, do not modify */

#ifndef __ZEITGEIST_DATAMODEL_H__
#define __ZEITGEIST_DATAMODEL_H__

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define ZEITGEIST_TYPE_DATA_SOURCE (zeitgeist_data_source_get_type ())
#define ZEITGEIST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource))
#define ZEITGEIST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSourceClass))
#define ZEITGEIST_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DATA_SOURCE))
#define ZEITGEIST_IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DATA_SOURCE))
#define ZEITGEIST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSourceClass))

typedef struct _ZeitgeistDataSource ZeitgeistDataSource;
typedef struct _ZeitgeistDataSourceClass ZeitgeistDataSourceClass;
typedef struct _ZeitgeistDataSourcePrivate ZeitgeistDataSourcePrivate;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN = 31,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN = 32,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN = 33,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN = 34,
	ZEITGEIST_RESULT_TYPE_RELEVANCY = 100
} ZeitgeistResultType;

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())
typedef enum  {
	ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT = 0,
	ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED = 1
} ZeitgeistRelevantResultType;

#define ZEITGEIST_TYPE_RELEVANT_RESULT_TYPE (zeitgeist_relevant_result_type_get_type ())
typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())
typedef struct _ZeitgeistEventPrivate ZeitgeistEventPrivate;

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
typedef struct _ZeitgeistSubjectPrivate ZeitgeistSubjectPrivate;

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _ZeitgeistTimeRangePrivate ZeitgeistTimeRangePrivate;

#define ZEITGEIST_TYPE_RESULT_SET (zeitgeist_result_set_get_type ())
#define ZEITGEIST_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_RESULT_SET, ZeitgeistResultSet))
#define ZEITGEIST_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_RESULT_SET))
#define ZEITGEIST_RESULT_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_RESULT_SET, ZeitgeistResultSetIface))

typedef struct _ZeitgeistResultSet ZeitgeistResultSet;
typedef struct _ZeitgeistResultSetIface ZeitgeistResultSetIface;

#define ZEITGEIST_TYPE_SIMPLE_RESULT_SET (zeitgeist_simple_result_set_get_type ())
#define ZEITGEIST_SIMPLE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SIMPLE_RESULT_SET, ZeitgeistSimpleResultSet))
#define ZEITGEIST_SIMPLE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SIMPLE_RESULT_SET, ZeitgeistSimpleResultSetClass))
#define ZEITGEIST_IS_SIMPLE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SIMPLE_RESULT_SET))
#define ZEITGEIST_IS_SIMPLE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SIMPLE_RESULT_SET))
#define ZEITGEIST_SIMPLE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SIMPLE_RESULT_SET, ZeitgeistSimpleResultSetClass))

typedef struct _ZeitgeistSimpleResultSet ZeitgeistSimpleResultSet;
typedef struct _ZeitgeistSimpleResultSetClass ZeitgeistSimpleResultSetClass;
typedef struct _ZeitgeistSimpleResultSetPrivate ZeitgeistSimpleResultSetPrivate;

struct _ZeitgeistDataSource {
	GObject parent_instance;
	ZeitgeistDataSourcePrivate * priv;
};

struct _ZeitgeistDataSourceClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()
typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_EVENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _ZeitgeistEvent {
	GObject parent_instance;
	ZeitgeistEventPrivate * priv;
};

struct _ZeitgeistEventClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSubject {
	GObject parent_instance;
	ZeitgeistSubjectPrivate * priv;
};

struct _ZeitgeistSubjectClass {
	GObjectClass parent_class;
};

struct _ZeitgeistTimeRange {
	GObject parent_instance;
	ZeitgeistTimeRangePrivate * priv;
};

struct _ZeitgeistTimeRangeClass {
	GObjectClass parent_class;
};

struct _ZeitgeistResultSetIface {
	GTypeInterface parent_iface;
	guint (*size) (ZeitgeistResultSet* self);
	guint (*estimated_matches) (ZeitgeistResultSet* self);
	ZeitgeistEvent* (*next_value) (ZeitgeistResultSet* self);
	gboolean (*has_next) (ZeitgeistResultSet* self);
	guint (*tell) (ZeitgeistResultSet* self);
	void (*reset) (ZeitgeistResultSet* self);
};

struct _ZeitgeistSimpleResultSet {
	GObject parent_instance;
	ZeitgeistSimpleResultSetPrivate * priv;
};

struct _ZeitgeistSimpleResultSetClass {
	GObjectClass parent_class;
};

GType zeitgeist_data_source_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistDataSource, g_object_unref)
ZeitgeistDataSource* zeitgeist_data_source_new (void);
ZeitgeistDataSource* zeitgeist_data_source_construct (GType object_type);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistEvent, g_object_unref)
ZeitgeistDataSource* zeitgeist_data_source_new_full (const gchar* unique_id,
                                                     const gchar* name,
                                                     const gchar* description,
                                                     GPtrArray* templates);
ZeitgeistDataSource* zeitgeist_data_source_construct_full (GType object_type,
                                                           const gchar* unique_id,
                                                           const gchar* name,
                                                           const gchar* description,
                                                           GPtrArray* templates);
GQuark zeitgeist_data_model_error_quark (void);
ZeitgeistDataSource* zeitgeist_data_source_new_from_variant (GVariant* variant,
                                                             gboolean reset_running,
                                                             GError** error);
ZeitgeistDataSource* zeitgeist_data_source_construct_from_variant (GType object_type,
                                                                   GVariant* variant,
                                                                   gboolean reset_running,
                                                                   GError** error);
GVariant* zeitgeist_data_source_to_variant (ZeitgeistDataSource* self);
const gchar* zeitgeist_data_source_get_unique_id (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_unique_id (ZeitgeistDataSource* self,
                                          const gchar* value);
const gchar* zeitgeist_data_source_get_name (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_name (ZeitgeistDataSource* self,
                                     const gchar* value);
const gchar* zeitgeist_data_source_get_description (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_description (ZeitgeistDataSource* self,
                                            const gchar* value);
GPtrArray* zeitgeist_data_source_get_event_templates (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_event_templates (ZeitgeistDataSource* self,
                                                GPtrArray* value);
gboolean zeitgeist_data_source_get_enabled (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_enabled (ZeitgeistDataSource* self,
                                        gboolean value);
gboolean zeitgeist_data_source_get_running (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_running (ZeitgeistDataSource* self,
                                        gboolean value);
gint64 zeitgeist_data_source_get_timestamp (ZeitgeistDataSource* self);
void zeitgeist_data_source_set_timestamp (ZeitgeistDataSource* self,
                                          gint64 value);
#define ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES "a(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)"
GPtrArray* zeitgeist_data_sources_from_variant (GVariant* sources_variant,
                                                GError** error);
GVariant* zeitgeist_data_sources_to_variant (GHashTable* sources);
GQuark zeitgeist_engine_error_quark (void);
void zeitgeist_register_mimetype (const gchar* mimetype,
                                  const gchar* interpretation_uri);
void zeitgeist_register_mimetype_regex (const gchar* mimetype_regex,
                                        const gchar* interpretation_uri);
const gchar* zeitgeist_interpretation_for_mimetype (const gchar* mimetype);
void zeitgeist_register_uri_scheme (const gchar* uri_scheme,
                                    const gchar* manifestation_type);
const gchar* zeitgeist_manifestation_for_uri (const gchar* uri);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type);
GType zeitgeist_relevant_result_type_get_type (void) G_GNUC_CONST;
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EVENT_SIGNATURE "asaasay"
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSubject, g_object_unref)
ZeitgeistSubject* zeitgeist_event_get_subject (ZeitgeistEvent* self,
                                               gint index);
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
void zeitgeist_event_add_subject (ZeitgeistEvent* self,
                                  ZeitgeistSubject* subject);
void zeitgeist_event_take_subject (ZeitgeistEvent* self,
                                   ZeitgeistSubject* subject);
ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation,
                                          const gchar* manifestation,
                                          const gchar* actor,
                                          const gchar* origin,
                                          ...);
ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type,
                                                const gchar* interpretation,
                                                const gchar* manifestation,
                                                const gchar* actor,
                                                const gchar* origin,
                                                ...);
ZeitgeistEvent* zeitgeist_event_constructv_full (GType object_type,
                                                 const gchar* interpretation,
                                                 const gchar* manifestation,
                                                 const gchar* actor,
                                                 const gchar* origin,
                                                 va_list _vala_va_list);
ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant,
                                                  GError** error);
ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type,
                                                        GVariant* event_variant,
                                                        GError** error);
void zeitgeist_event_set_actor_from_app_info (ZeitgeistEvent* self,
                                              GAppInfo* info);
GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self);
void zeitgeist_event_debug_print (ZeitgeistEvent* self);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self,
                                           ZeitgeistEvent* template_event);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
void zeitgeist_event_set_id (ZeitgeistEvent* self,
                             guint32 value);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self,
                                    gint64 value);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
void zeitgeist_event_set_origin (ZeitgeistEvent* self,
                                 const gchar* value);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
void zeitgeist_event_set_actor (ZeitgeistEvent* self,
                                const gchar* value);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self,
                                         const gchar* value);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self,
                                        const gchar* value);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
void zeitgeist_event_set_subjects (ZeitgeistEvent* self,
                                   GPtrArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
void zeitgeist_event_set_payload (ZeitgeistEvent* self,
                                  GByteArray* value);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents,
                                          GError** error);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events,
                                                  gsize limit,
                                                  GError** error);
ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri,
                                              const gchar* interpretation,
                                              const gchar* manifestation,
                                              const gchar* mimetype,
                                              const gchar* origin,
                                              const gchar* text,
                                              const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type,
                                                    const gchar* uri,
                                                    const gchar* interpretation,
                                                    const gchar* manifestation,
                                                    const gchar* mimetype,
                                                    const gchar* origin,
                                                    const gchar* text,
                                                    const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_new_move_event (const gchar* source_uri,
                                                    const gchar* source_origin,
                                                    const gchar* destination_uri,
                                                    const gchar* destination_origin,
                                                    const gchar* interpretation,
                                                    const gchar* manifestation,
                                                    const gchar* mimetype,
                                                    const gchar* text,
                                                    const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_construct_move_event (GType object_type,
                                                          const gchar* source_uri,
                                                          const gchar* source_origin,
                                                          const gchar* destination_uri,
                                                          const gchar* destination_origin,
                                                          const gchar* interpretation,
                                                          const gchar* manifestation,
                                                          const gchar* mimetype,
                                                          const gchar* text,
                                                          const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant,
                                                      GError** error);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type,
                                                            GVariant* subject_variant,
                                                            GError** error);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self,
                                             ZeitgeistSubject* template_subject);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self,
                                const gchar* value);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self,
                                   const gchar* value);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
void zeitgeist_subject_set_text (ZeitgeistSubject* self,
                                 const gchar* value);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self,
                                    const gchar* value);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self,
                                        const gchar* value);
const gchar* zeitgeist_subject_get_current_origin (ZeitgeistSubject* self);
void zeitgeist_subject_set_current_origin (ZeitgeistSubject* self,
                                           const gchar* value);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self,
                                     const gchar* value);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self,
                                           const gchar* value);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self,
                                          const gchar* value);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistTimeRange, g_object_unref)
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec,
                                              gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type,
                                                    gint64 start_msec,
                                                    gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant,
                                                           GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type,
                                                                 GVariant* variant,
                                                                 GError** error);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self,
                                                    ZeitgeistTimeRange* time_range);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
#define ZEITGEIST_TIMESTAMP_SECOND ((gint64) 1000)
#define ZEITGEIST_TIMESTAMP_MINUTE ((gint64) 60000)
#define ZEITGEIST_TIMESTAMP_HOUR ((gint64) 3600000)
#define ZEITGEIST_TIMESTAMP_DAY ((gint64) 86400000)
#define ZEITGEIST_TIMESTAMP_WEEK ((gint64) 604800000)
#define ZEITGEIST_TIMESTAMP_YEAR 31556952000LL
gint64 zeitgeist_timestamp_from_timeval (GTimeVal* timeval);
void zeitgeist_timestamp_to_timeval (gint64 timestamp,
                                     GTimeVal* result);
gint64 zeitgeist_timestamp_from_now (void);
gint64 zeitgeist_timestamp_from_iso8601 (const gchar* datetime);
gchar* zeitgeist_timestamp_to_iso8601 (gint64 timestamp);
gint64 zeitgeist_timestamp_from_date (GDate* date);
gint64 zeitgeist_timestamp_from_dmy (GDateDay day,
                                     GDateMonth month,
                                     GDateYear year);
void zeitgeist_timestamp_to_date (gint64 timestamp,
                                  GDate* result);
gint64 zeitgeist_timestamp_next_midnight (gint64 timestamp);
gint64 zeitgeist_timestamp_prev_midnight (gint64 timestamp);
#define ZEITGEIST_NCAL_ALARM "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm"
#define ZEITGEIST_NCAL_ATTACHMENT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment"
#define ZEITGEIST_NCAL_CALENDAR "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar"
#define ZEITGEIST_NCAL_CALENDAR_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarData" \
"Object"
#define ZEITGEIST_NCAL_EVENT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event"
#define ZEITGEIST_NCAL_FREEBUSY "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy"
#define ZEITGEIST_NCAL_JOURNAL "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal"
#define ZEITGEIST_NCAL_TIMEZONE "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone"
#define ZEITGEIST_NCAL_TODO "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo"
#define ZEITGEIST_NCO_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact"
#define ZEITGEIST_NCO_CONTACT_GROUP "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup"
#define ZEITGEIST_NCO_CONTACT_LIST "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList"
#define ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDa" \
"taObject"
#define ZEITGEIST_NCO_ORGANIZATION_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationC" \
"ontact"
#define ZEITGEIST_NCO_PERSON_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact"
#define ZEITGEIST_NFO_APPLICATION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application"
#define ZEITGEIST_NFO_ARCHIVE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive"
#define ZEITGEIST_NFO_ARCHIVE_ITEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem"
#define ZEITGEIST_NFO_ATTACHMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment"
#define ZEITGEIST_NFO_AUDIO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio"
#define ZEITGEIST_NFO_BOOKMARK "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark"
#define ZEITGEIST_NFO_BOOKMARK_FOLDER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolde" \
"r"
#define ZEITGEIST_NFO_CURSOR "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor"
#define ZEITGEIST_NFO_DATA_CONTAINER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer"
#define ZEITGEIST_NFO_DELETED_RESOURCE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResour" \
"ce"
#define ZEITGEIST_NFO_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document"
#define ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileD" \
"ataObject"
#define ZEITGEIST_NFO_EXECUTABLE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable"
#define ZEITGEIST_NFO_FILESYSTEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem"
#define ZEITGEIST_NFO_FILESYSTEM_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemIma" \
"ge"
#define ZEITGEIST_NFO_FILE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObjec" \
"t"
#define ZEITGEIST_NFO_FOLDER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder"
#define ZEITGEIST_NFO_FONT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font"
#define ZEITGEIST_NFO_HARD_DISK_PARTITION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskParti" \
"tion"
#define ZEITGEIST_NFO_HTML_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument"
#define ZEITGEIST_NFO_ICON "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon"
#define ZEITGEIST_NFO_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image"
#define ZEITGEIST_NFO_MEDIA "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media"
#define ZEITGEIST_NFO_MEDIA_LIST "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList"
#define ZEITGEIST_NFO_MEDIA_STREAM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream"
#define ZEITGEIST_NFO_MIND_MAP "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap"
#define ZEITGEIST_NFO_OPERATING_SYSTEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSyst" \
"em"
#define ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedText" \
"Document"
#define ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocu" \
"ment"
#define ZEITGEIST_NFO_PRESENTATION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation"
#define ZEITGEIST_NFO_RASTER_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage"
#define ZEITGEIST_NFO_REMOTE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObj" \
"ect"
#define ZEITGEIST_NFO_REMOTE_PORT_ADDRESS "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAdd" \
"ress"
#define ZEITGEIST_NFO_SOFTWARE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software"
#define ZEITGEIST_NFO_SOFTWARE_ITEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem"
#define ZEITGEIST_NFO_SOFTWARE_SERVICE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareServi" \
"ce"
#define ZEITGEIST_NFO_SOURCE_CODE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode"
#define ZEITGEIST_NFO_SPREADSHEET "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet"
#define ZEITGEIST_NFO_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument"
#define ZEITGEIST_NFO_TRASH "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash"
#define ZEITGEIST_NFO_VECTOR_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage"
#define ZEITGEIST_NFO_VIDEO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video"
#define ZEITGEIST_NFO_VISUAL "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual"
#define ZEITGEIST_NFO_WEBSITE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website"
#define ZEITGEIST_NFO_WEB_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject"
#define ZEITGEIST_NIE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject"
#define ZEITGEIST_NIE_INFORMATION_ELEMENT "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationEl" \
"ement"
#define ZEITGEIST_NMM_MOVIE "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie"
#define ZEITGEIST_NMM_MUSIC_ALBUM "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum"
#define ZEITGEIST_NMM_MUSIC_PIECE "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece"
#define ZEITGEIST_NMM_TVSERIES "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries"
#define ZEITGEIST_NMM_TVSHOW "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow"
#define ZEITGEIST_NMO_EMAIL "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email"
#define ZEITGEIST_NMO_IMMESSAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage"
#define ZEITGEIST_NMO_MAILBOX "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox"
#define ZEITGEIST_NMO_MAILBOX_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataOb" \
"ject"
#define ZEITGEIST_NMO_MESSAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message"
#define ZEITGEIST_NMO_MIME_ENTITY "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity"
#define ZEITGEIST_ZG_ACCEPT_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AcceptEvent"
#define ZEITGEIST_ZG_ACCESS_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AccessEvent"
#define ZEITGEIST_ZG_APPLICATION_ACTION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ApplicationA" \
"ction"
#define ZEITGEIST_ZG_CREATE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#CreateEvent"
#define ZEITGEIST_ZG_DELETE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DeleteEvent"
#define ZEITGEIST_ZG_DENY_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DenyEvent"
#define ZEITGEIST_ZG_EVENT_INTERPRETATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventInterpr" \
"etation"
#define ZEITGEIST_ZG_EVENT_MANIFESTATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventManifes" \
"tation"
#define ZEITGEIST_ZG_EXPIRE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ExpireEvent"
#define ZEITGEIST_ZG_HEURISTIC_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#HeuristicAct" \
"ivity"
#define ZEITGEIST_ZG_LEAVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#LeaveEvent"
#define ZEITGEIST_ZG_MODIFY_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ModifyEvent"
#define ZEITGEIST_ZG_MOVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent"
#define ZEITGEIST_ZG_RECEIVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ReceiveEvent"
#define ZEITGEIST_ZG_SCHEDULED_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ScheduledAct" \
"ivity"
#define ZEITGEIST_ZG_SEND_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SendEvent"
#define ZEITGEIST_ZG_SYSTEM_NOTIFICATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SystemNotifi" \
"cation"
#define ZEITGEIST_ZG_USER_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#UserActivity"
#define ZEITGEIST_ZG_WORLD_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#WorldActivit" \
"y"
const gchar* zeitgeist_symbol_get_display_name (const gchar* symbol_uri);
const gchar* zeitgeist_symbol_get_description (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_all_parents (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_all_children (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_children (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_parents (const gchar* symbol_uri);
gboolean zeitgeist_symbol_is_a (const gchar* symbol_uri,
                                const gchar* parent_uri);
GType zeitgeist_result_set_get_type (void) G_GNUC_CONST;
guint zeitgeist_result_set_size (ZeitgeistResultSet* self);
guint zeitgeist_result_set_estimated_matches (ZeitgeistResultSet* self);
ZeitgeistEvent* zeitgeist_result_set_next_value (ZeitgeistResultSet* self);
gboolean zeitgeist_result_set_has_next (ZeitgeistResultSet* self);
guint zeitgeist_result_set_tell (ZeitgeistResultSet* self);
void zeitgeist_result_set_reset (ZeitgeistResultSet* self);
ZeitgeistResultSet* zeitgeist_result_set_iterator (ZeitgeistResultSet* self);
GType zeitgeist_simple_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSimpleResultSet, g_object_unref)
ZeitgeistSimpleResultSet* zeitgeist_simple_result_set_new (GPtrArray* events);
ZeitgeistSimpleResultSet* zeitgeist_simple_result_set_construct (GType object_type,
                                                                 GPtrArray* events);
ZeitgeistSimpleResultSet* zeitgeist_simple_result_set_new_with_num_matches (GPtrArray* events,
                                                                            guint matches);
ZeitgeistSimpleResultSet* zeitgeist_simple_result_set_construct_with_num_matches (GType object_type,
                                                                                  GPtrArray* events,
                                                                                  guint matches);
#define ZEITGEIST_UTILS_ENGINE_DBUS_NAME "org.gnome.zeitgeist.Engine"
#define ZEITGEIST_UTILS_ENGINE_DBUS_PATH "/org/gnome/zeitgeist/log/activity"
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
#define ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE ((gsize) ((4 * 1024) * 1024))
#define ZEITGEIST_UTILS_CACHE_SIZE ((guint) 0)
const gchar* zeitgeist_utils_get_data_path (void);
gchar* zeitgeist_utils_get_default_data_path (void);
const gchar* zeitgeist_utils_get_database_file_path (void);
void zeitgeist_utils_set_database_file_path (const gchar* path);
const gchar* zeitgeist_utils_get_database_file_backup_path (void);
gchar* zeitgeist_utils_get_database_file_retire_name (void);
const gchar* zeitgeist_utils_get_local_extensions_path (void);
gboolean zeitgeist_utils_using_in_memory_database (void);
void zeitgeist_utils_backup_database (GError** error);
gboolean zeitgeist_utils_parse_negation (gchar* * val);
gboolean zeitgeist_utils_parse_noexpand (gchar* * val);
gboolean zeitgeist_utils_parse_wildcard (gchar* * val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
gboolean zeitgeist_utils_log_may_read_directly (void);

G_END_DECLS

#endif
