/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private final File file;
    protected org.apache.maven.artifact.repository.metadata.Metadata metadata;
    private boolean merged;

    protected MavenMetadata(org.apache.maven.artifact.repository.metadata.Metadata metadata, File file2) {
        this.metadata = metadata;
        this.file = file2;
    }

    @Override
    public String getType() {
        return MAVEN_METADATA_XML;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void merge(File existing, File result) throws RepositoryException {
        org.apache.maven.artifact.repository.metadata.Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(org.apache.maven.artifact.repository.metadata.Metadata var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static org.apache.maven.artifact.repository.metadata.Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new org.apache.maven.artifact.repository.metadata.Metadata();
        }
        try (XmlStreamReader reader2 = ReaderFactory.newXmlReader(metadataFile);){
            org.apache.maven.artifact.repository.metadata.Metadata metadata = new MetadataXpp3Reader().read(reader2, false);
            return metadata;
        }
        catch (IOException e2) {
            throw new RepositoryException("Could not read metadata " + metadataFile + ": " + e2.getMessage(), e2);
        }
        catch (XmlPullParserException e3) {
            throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e3.getMessage(), e3);
        }
    }

    private void write(File metadataFile, org.apache.maven.artifact.repository.metadata.Metadata metadata) throws RepositoryException {
        metadataFile.getParentFile().mkdirs();
        try (XmlStreamWriter writer2 = WriterFactory.newXmlWriter(metadataFile);){
            new MetadataXpp3Writer().write(writer2, metadata);
        }
        catch (IOException e2) {
            throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e2.getMessage(), e2);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

