/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class RestSearchAction
extends BaseRestHandler {
    public static final String TOTAL_HITS_AS_INT_PARAM = "rest_total_hits_as_int";
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS;
    private static final DeprecationLogger deprecationLogger;
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in search requests is deprecated.";

    @Override
    public String getName() {
        return "search_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search"), new RestHandler.Route(RestRequest.Method.POST, "/_search"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_search")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest(searchRequest, request, parser, setSize));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute(SearchAction.INSTANCE, searchRequest, new RestStatusToXContentListener((RestChannel)channel));
        };
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, XContentParser requestContentParser, IntConsumer setSize) throws IOException {
        String searchType;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        searchRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        if (requestContentParser != null) {
            searchRequest.source().parseXContent(requestContentParser, true);
        }
        int batchedReduceSize = request.paramAsInt("batched_reduce_size", searchRequest.getBatchedReduceSize());
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        if (request.hasParam("pre_filter_shard_size")) {
            searchRequest.setPreFilterShardSize(request.paramAsInt("pre_filter_shard_size", 128));
        }
        if (request.hasParam("max_concurrent_shard_requests")) {
            int maxConcurrentShardRequests = request.paramAsInt("max_concurrent_shard_requests", searchRequest.getMaxConcurrentShardRequests());
            searchRequest.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        if (request.hasParam("allow_partial_search_results")) {
            searchRequest.allowPartialSearchResults(request.paramAsBoolean("allow_partial_search_results", null));
        }
        if ("query_and_fetch".equals(searchType = request.param("search_type")) || "dfs_query_and_fetch".equals(searchType)) {
            throw new IllegalArgumentException("Unsupported search type [" + searchType + "]");
        }
        searchRequest.searchType(searchType);
        RestSearchAction.parseSearchSource(searchRequest.source(), request, setSize);
        searchRequest.requestCache(request.paramAsBoolean("request_cache", searchRequest.requestCache()));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        if (request.hasParam("type")) {
            deprecationLogger.deprecatedAndMaybeLog("search_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            searchRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        }
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
        searchRequest.setCcsMinimizeRoundtrips(request.paramAsBoolean("ccs_minimize_roundtrips", searchRequest.isCcsMinimizeRoundtrips()));
        RestSearchAction.checkRestTotalHits(request, searchRequest);
    }

    private static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, RestRequest request, IntConsumer setSize) {
        String suggestField;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sDocValueFields;
        StoredFieldsContext storedFieldsContext;
        int size;
        int from;
        QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if ((from = request.paramAsInt("from", -1)) != -1) {
            searchSourceBuilder.from(from);
        }
        if ((size = request.paramAsInt("size", -1)) != -1) {
            setSize.accept(size);
        }
        if (request.hasParam("explain")) {
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("seq_no_primary_term")) {
            searchSourceBuilder.seqNoAndPrimaryTerm(request.paramAsBoolean("seq_no_primary_term", null));
        }
        if (request.hasParam("timeout")) {
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter = request.paramAsInt("terminate_after", 0);
            if (terminateAfter < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if ((storedFieldsContext = StoredFieldsContext.fromRestRequest(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), request)) != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if ((sDocValueFields = request.param("docvalue_fields")) != null && Strings.hasText(sDocValueFields)) {
            String[] sFields;
            for (String field : sFields = Strings.splitStringByCommaToArray(sDocValueFields)) {
                searchSourceBuilder.docValueField(field, null);
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest(request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if (request.hasParam("track_total_hits")) {
            if (Booleans.isBoolean((String)request.param("track_total_hits"))) {
                searchSourceBuilder.trackTotalHits(request.paramAsBoolean("track_total_hits", true));
            } else {
                searchSourceBuilder.trackTotalHitsUpTo(request.paramAsInt("track_total_hits", 10000));
            }
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = Strings.splitStringByCommaToArray(sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            searchSourceBuilder.stats(Arrays.asList(Strings.splitStringByCommaToArray(sStats)));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            String suggestMode = request.param("suggest_mode");
            searchSourceBuilder.suggest(new SuggestBuilder().addSuggestion(suggestField, ((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilder.SuggestMode.resolve(suggestMode))));
        }
    }

    public static void checkRestTotalHits(RestRequest restRequest, SearchRequest searchRequest) {
        Integer trackTotalHitsUpTo;
        boolean totalHitsAsInt = restRequest.paramAsBoolean(TOTAL_HITS_AS_INT_PARAM, false);
        if (!totalHitsAsInt) {
            return;
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) == null) {
            searchRequest.source().trackTotalHits(true);
        } else if (trackTotalHitsUpTo != Integer.MAX_VALUE && trackTotalHitsUpTo != -1) {
            throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + trackTotalHitsUpTo);
        }
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList(TYPED_KEYS_PARAM, TOTAL_HITS_AS_INT_PARAM));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
        deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestSearchAction.class));
    }
}

