/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.ECast;
import org.elasticsearch.painless.node.EConstant;

public abstract class AExpression
extends ANode {
    AExpression prefix;
    boolean read = true;
    boolean statement = false;
    Class<?> expected = null;
    Class<?> actual = null;
    boolean explicit = false;
    boolean internal = false;
    Object constant = null;
    boolean isNull = false;

    AExpression(Location location) {
        super(location);
        this.prefix = null;
    }

    AExpression(Location location, AExpression prefix) {
        super(location);
        this.prefix = Objects.requireNonNull(prefix);
    }

    AExpression cast(ScriptRoot scriptRoot, Locals locals) {
        PainlessCast cast = AnalyzerCaster.getLegalCast(this.location, this.actual, this.expected, this.explicit, this.internal);
        if (cast == null) {
            if (this.constant == null || this instanceof EConstant) {
                return this;
            }
            EConstant econstant = new EConstant(this.location, this.constant);
            econstant.analyze(scriptRoot, locals);
            if (!this.expected.equals(econstant.actual)) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            return econstant;
        }
        if (this.constant == null) {
            ECast ecast = new ECast(this.location, this, cast);
            ecast.statement = this.statement;
            ecast.actual = this.expected;
            ecast.isNull = this.isNull;
            return ecast;
        }
        if (PainlessLookupUtility.isConstantType(this.expected)) {
            this.constant = AnalyzerCaster.constCast(this.location, this.constant, cast);
            EConstant econstant = new EConstant(this.location, this.constant);
            econstant.analyze(scriptRoot, locals);
            if (!this.expected.equals(econstant.actual)) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            return econstant;
        }
        if (this instanceof EConstant) {
            ECast ecast = new ECast(this.location, this, cast);
            ecast.actual = this.expected;
            return ecast;
        }
        EConstant econstant = new EConstant(this.location, this.constant);
        econstant.analyze(scriptRoot, locals);
        if (!this.actual.equals(econstant.actual)) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        ECast ecast = new ECast(this.location, econstant, cast);
        ecast.actual = this.expected;
        return ecast;
    }
}

