/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import org.fibs.geotag.util.JavaFileFilter;

public final class WarningSuppressor {
    private static final String[] PATTERNS_TO_SUPPRESS = new String[]{"public class", "public enum", "public interface", "public abstract class", "public final class", "final class", "class"};

    private WarningSuppressor() {
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(null) == 0) {
            File directory = chooser.getSelectedFile();
            WarningSuppressor.processDirectory(directory);
        }
    }

    private static void processDirectory(File directory) {
        File[] files = directory.listFiles(new JavaFileFilter());
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                WarningSuppressor.processDirectory(file);
            } else {
                WarningSuppressor.processFile(file);
            }
            ++i;
        }
    }

    private static void processFile(File file) {
        File tmpFile;
        block27: {
            tmpFile = new File(String.valueOf(file.getPath()) + ".tmp");
            BufferedReader bufferedReader = null;
            PrintStream printStream = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                printStream = new PrintStream(tmpFile);
                boolean alreadySuppressed = false;
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.startsWith("@SuppressWarnings(\"all\")")) {
                        alreadySuppressed = true;
                    }
                    int i = 0;
                    while (i < PATTERNS_TO_SUPPRESS.length) {
                        String pattern = PATTERNS_TO_SUPPRESS[i];
                        if (line.startsWith(pattern)) {
                            if (!alreadySuppressed) {
                                printStream.println("@SuppressWarnings(\"all\")");
                                System.out.println("Suppressed warnings in " + file.getPath());
                            }
                            alreadySuppressed = false;
                        }
                        ++i;
                    }
                    printStream.println(line);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (printStream != null) {
                    printStream.close();
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                break block27;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block27;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (printStream != null) {
                        printStream.close();
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (printStream != null) {
                printStream.close();
            }
            if (bufferedReader == null) break block27;
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (tmpFile.renameTo(file)) {
            System.out.println("Done. " + file.getName());
        } else {
            System.out.println("Couldn't rename " + tmpFile.getName());
        }
    }
}

