/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.colour.ColourChooser;
import tim.prune.gui.colour.ColourPatch;
import tim.prune.gui.colour.ColourerFactory;
import tim.prune.gui.colour.PatchListener;
import tim.prune.gui.colour.PointColourer;

public class ColourerSelectorPanel
extends JPanel {
    private JComboBox<String> _typeCombo = null;
    private ColourerFactory.ColourerId[] _typeIds = new ColourerFactory.ColourerId[]{ColourerFactory.ColourerId.NONE, ColourerFactory.ColourerId.BY_FILE, ColourerFactory.ColourerId.BY_SEGMENT, ColourerFactory.ColourerId.BY_DATE, ColourerFactory.ColourerId.BY_ALTITUDE, ColourerFactory.ColourerId.BY_SPEED, ColourerFactory.ColourerId.BY_VSPEED, ColourerFactory.ColourerId.BY_GRADIENT};
    private JPanel _patchPanel = null;
    private ColourPatch[] _startEndPatches = null;
    JPanel _maxColoursPanel = null;
    private JComboBox<String> _maxColoursCombo = null;
    private static final String[] LABEL_KEYS = new String[]{"start", "end"};

    public ColourerSelectorPanel(ColourChooser colourChooser) {
        this.makeGuiComponents(colourChooser);
    }

    private void makeGuiComponents(ColourChooser colourChooser) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.colourer.intro"));
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        JPanel jPanel = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel);
        String[] stringArray = new String[this._typeIds.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = I18nManager.getText("dialog.colourer.type." + ColourerFactory.getDescriptionKey(this._typeIds[n]));
            ++n;
        }
        this._typeCombo = new JComboBox<String>(stringArray);
        this._typeCombo.setAlignmentX(0.0f);
        this._typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColourerSelectorPanel.this.onColourerTypeChanged();
            }
        });
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.colourer.type")));
        guiGridLayout.add(this._typeCombo);
        jPanel.setAlignmentX(0.0f);
        this.add(jPanel);
        this._patchPanel = new JPanel();
        this._patchPanel.setLayout(new GridLayout());
        this._startEndPatches = new ColourPatch[2];
        JPanel jPanel2 = new JPanel();
        ColourPatch colourPatch = new ColourPatch(Color.BLACK);
        colourPatch.setVisible(false);
        jPanel2.add(colourPatch);
        this._patchPanel.add(jPanel2);
        int n2 = 0;
        while (n2 < 2) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(new JLabel(I18nManager.getText("dialog.colourer." + LABEL_KEYS[n2])));
            ColourPatch colourPatch2 = new ColourPatch(Color.BLUE);
            colourPatch2.addMouseListener(new PatchListener(colourPatch2, colourChooser));
            jPanel3.add(colourPatch2);
            this._startEndPatches[n2] = colourPatch2;
            jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._patchPanel.add(jPanel3);
            ++n2;
        }
        jPanel2 = new JPanel();
        colourPatch = new ColourPatch(Color.BLACK);
        colourPatch.setVisible(false);
        jPanel2.add(colourPatch);
        this._patchPanel.add(jPanel2);
        this._patchPanel.setAlignmentX(0.0f);
        this.add(this._patchPanel);
        this._maxColoursPanel = new JPanel();
        guiGridLayout = new GuiGridLayout(this._maxColoursPanel);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.colourer.maxcolours")));
        String[] stringArray2 = new String[]{"2", "3", "5", "10", "15"};
        this._maxColoursCombo = new JComboBox<String>(stringArray2);
        guiGridLayout.add(this._maxColoursCombo);
        this._maxColoursPanel.setAlignmentX(0.0f);
        this.add(this._maxColoursPanel);
    }

    public void init(PointColourer pointColourer, Color color) {
        Color color2 = null;
        Color color3 = null;
        if (pointColourer != null) {
            this.selectColourerType(ColourerFactory.getId(pointColourer));
            color2 = pointColourer.getStartColour();
            color3 = pointColourer.getEndColour();
            this._maxColoursCombo.setSelectedItem("" + pointColourer.getMaxColours());
        } else {
            this._maxColoursCombo.setSelectedIndex(2);
        }
        if (color2 == null) {
            color2 = color;
        }
        if (color3 == null) {
            color3 = ColourerSelectorPanel.makeDefaultEndColour(color);
        }
        if (color2 != null) {
            this._startEndPatches[0].setBackground(color2);
        }
        if (color3 != null) {
            this._startEndPatches[1].setBackground(color3);
        }
        this.onColourerTypeChanged();
    }

    private static Color makeDefaultEndColour(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] + 0.33333334f;
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    private void onColourerTypeChanged() {
        ColourerFactory.ColourerId colourerId = this._typeIds[this._typeCombo.getSelectedIndex()];
        this._patchPanel.setVisible(ColourerFactory.areColoursRequired(colourerId));
        this._maxColoursPanel.setVisible(ColourerFactory.isMaxColoursRequired(colourerId));
    }

    public PointColourer getSelectedColourer() {
        ColourerFactory.ColourerId colourerId = this._typeIds[this._typeCombo.getSelectedIndex()];
        return ColourerFactory.createColourer(colourerId, this._startEndPatches[0].getBackground(), this._startEndPatches[1].getBackground(), this._maxColoursCombo.getSelectedItem().toString());
    }

    private void selectColourerType(ColourerFactory.ColourerId colourerId) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._typeIds.length) {
            if (this._typeIds[n2] == colourerId) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            System.err.println("Id " + (Object)((Object)colourerId) + " not found in _typeIds!");
        } else {
            this._typeCombo.setSelectedIndex(n);
        }
    }
}

