/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public class ByteTrie<T> {
    private final ByteTrieNode<T> _root = new ByteTrieNode();
    private int _maxDepth;

    @Nullable
    public T find(byte[] bytes) {
        return this.find(bytes, 0, bytes.length);
    }

    @Nullable
    public T find(byte[] bytes, int offset, int count) {
        int maxIndex = offset + count;
        if (maxIndex > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        ByteTrieNode node = this._root;
        Object value = node._value;
        for (int i = offset; i < maxIndex; ++i) {
            byte b = bytes[i];
            ByteTrieNode child = (ByteTrieNode)node._children.get(b);
            if (child == null) break;
            node = child;
            if (node._value == null) continue;
            value = node._value;
        }
        return (T)value;
    }

    public void addPath(T value, byte[] ... parts) {
        int depth = 0;
        ByteTrieNode<T> node = this._root;
        byte[][] arr$ = parts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] part;
            for (byte b : part = arr$[i$]) {
                ByteTrieNode<T> child = (ByteTrieNode<T>)((ByteTrieNode)node)._children.get(b);
                if (child == null) {
                    child = new ByteTrieNode<T>();
                    ((ByteTrieNode)node)._children.put(b, child);
                }
                node = child;
                ++depth;
            }
        }
        if (depth == 0) {
            throw new IllegalArgumentException("Parts must contain at least one byte.");
        }
        node.setValue(value);
        this._maxDepth = Math.max(this._maxDepth, depth);
    }

    public void setDefaultValue(T defaultValue) {
        this._root.setValue(defaultValue);
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    static class ByteTrieNode<T> {
        private final Map<Byte, ByteTrieNode<T>> _children = new HashMap<Byte, ByteTrieNode<T>>();
        private T _value = null;

        ByteTrieNode() {
        }

        public void setValue(T value) {
            if (this._value != null) {
                throw new RuntimeException("Value already set for this trie node");
            }
            this._value = value;
        }
    }
}

