(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],{

/***/ "/MTu":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/**
 * Open editor url in a new window, and pass a message.
 */
/* harmony default export */ __webpack_exports__["a"] = (function (window, url, data) {
    const editor = window.open(url);
    const wait = 10000;
    const step = 250;
    const { origin } = new URL(url);
    // eslint-disable-next-line no-bitwise
    let count = ~~(wait / step);
    function listen(evt) {
        if (evt.source === editor) {
            count = 0;
            window.removeEventListener('message', listen, false);
        }
    }
    window.addEventListener('message', listen, false);
    // send message
    // periodically resend until ack received or timeout
    function send() {
        if (count <= 0) {
            return;
        }
        editor.postMessage(data, origin);
        setTimeout(send, step);
        count -= 1;
    }
    setTimeout(send, step);
});
//# sourceMappingURL=post.js.map

/***/ }),

/***/ "/ZBw":
/***/ (function(module, exports, __webpack_require__) {

const SemVer = __webpack_require__("u/28")
const Range = __webpack_require__("P86V")
const minSatisfying = (versions, range, options) => {
  let min = null
  let minSV = null
  let rangeObj = null
  try {
    rangeObj = new Range(range, options)
  } catch (er) {
    return null
  }
  versions.forEach((v) => {
    if (rangeObj.test(v)) {
      // satisfies(v, range, options)
      if (!min || minSV.compare(v) === 1) {
        // compare(min, v, true)
        min = v
        minSV = new SemVer(min, options)
      }
    }
  })
  return min
}
module.exports = minSatisfying


/***/ }),

/***/ "0u8k":
/***/ (function(module, exports, __webpack_require__) {

const parse = __webpack_require__("ojZj")
const clean = (version, options) => {
  const s = parse(version.trim().replace(/^[=v]+/, ''), options)
  return s ? s.version : null
}
module.exports = clean


/***/ }),

/***/ "10j7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// generated with build-style.sh
/* harmony default export */ __webpack_exports__["a"] = (`.vega-embed {
  position: relative;
  display: inline-block; }
  .vega-embed.has-actions {
    padding-right: 38px; }
  .vega-embed details:not([open]) > :not(summary) {
    display: none !important; }
  .vega-embed summary {
    list-style: none;
    position: absolute;
    top: 0;
    right: 0;
    padding: 6px;
    z-index: 1000;
    background: white;
    box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1);
    color: #1b1e23;
    border: 1px solid #aaa;
    border-radius: 999px;
    opacity: 0.2;
    transition: opacity 0.4s ease-in;
    outline: none;
    cursor: pointer;
    line-height: 0px; }
    .vega-embed summary::-webkit-details-marker {
      display: none; }
    .vega-embed summary:active {
      box-shadow: #aaa 0px 0px 0px 1px inset; }
    .vega-embed summary svg {
      width: 14px;
      height: 14px; }
  .vega-embed details[open] summary {
    opacity: 0.7; }
  .vega-embed:hover summary,
  .vega-embed:focus summary {
    opacity: 1 !important;
    transition: opacity 0.2s ease; }
  .vega-embed .vega-actions {
    position: absolute;
    z-index: 1001;
    top: 35px;
    right: -9px;
    display: flex;
    flex-direction: column;
    padding-bottom: 8px;
    padding-top: 8px;
    border-radius: 4px;
    box-shadow: 0 2px 8px 0 rgba(0, 0, 0, 0.2);
    border: 1px solid #d9d9d9;
    background: white;
    animation-duration: 0.15s;
    animation-name: scale-in;
    animation-timing-function: cubic-bezier(0.2, 0, 0.13, 1.5);
    text-align: left; }
    .vega-embed .vega-actions a {
      padding: 8px 16px;
      font-family: sans-serif;
      font-size: 14px;
      font-weight: 600;
      white-space: nowrap;
      color: #434a56;
      text-decoration: none; }
      .vega-embed .vega-actions a:hover {
        background-color: #f7f7f9;
        color: black; }
    .vega-embed .vega-actions::before, .vega-embed .vega-actions::after {
      content: "";
      display: inline-block;
      position: absolute; }
    .vega-embed .vega-actions::before {
      left: auto;
      right: 14px;
      top: -16px;
      border: 8px solid #0000;
      border-bottom-color: #d9d9d9; }
    .vega-embed .vega-actions::after {
      left: auto;
      right: 15px;
      top: -14px;
      border: 7px solid #0000;
      border-bottom-color: #fff; }

.vega-embed-wrapper {
  max-width: 100%;
  overflow: scroll;
  padding-right: 14px; }

@keyframes scale-in {
  from {
    opacity: 0;
    transform: scale(0.6); }
  to {
    opacity: 1;
    transform: scale(1); } }
`);
//# sourceMappingURL=style.js.map

/***/ }),

/***/ "1zMv":
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ applyPatch; });

// UNUSED EXPORTS: getValueByPointer, applyOperation, applyReducer, validator, validate, _areEquals, unobserve, observe, generate, compare, JsonPatchError, deepClone, escapePathComponent, unescapePathComponent

// NAMESPACE OBJECT: ./node_modules/fast-json-patch/module/core.mjs
var core_namespaceObject = {};
__webpack_require__.r(core_namespaceObject);
__webpack_require__.d(core_namespaceObject, "JsonPatchError", function() { return JsonPatchError; });
__webpack_require__.d(core_namespaceObject, "deepClone", function() { return deepClone; });
__webpack_require__.d(core_namespaceObject, "getValueByPointer", function() { return getValueByPointer; });
__webpack_require__.d(core_namespaceObject, "applyOperation", function() { return applyOperation; });
__webpack_require__.d(core_namespaceObject, "applyPatch", function() { return applyPatch; });
__webpack_require__.d(core_namespaceObject, "applyReducer", function() { return applyReducer; });
__webpack_require__.d(core_namespaceObject, "validator", function() { return validator; });
__webpack_require__.d(core_namespaceObject, "validate", function() { return validate; });
__webpack_require__.d(core_namespaceObject, "_areEquals", function() { return _areEquals; });

// NAMESPACE OBJECT: ./node_modules/fast-json-patch/module/duplex.mjs
var duplex_namespaceObject = {};
__webpack_require__.r(duplex_namespaceObject);
__webpack_require__.d(duplex_namespaceObject, "unobserve", function() { return unobserve; });
__webpack_require__.d(duplex_namespaceObject, "observe", function() { return observe; });
__webpack_require__.d(duplex_namespaceObject, "generate", function() { return generate; });
__webpack_require__.d(duplex_namespaceObject, "compare", function() { return compare; });

// CONCATENATED MODULE: ./node_modules/fast-json-patch/module/helpers.mjs
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017 Joachim Wester
 * MIT license
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var _hasOwnProperty = Object.prototype.hasOwnProperty;
function helpers_hasOwnProperty(obj, key) {
    return _hasOwnProperty.call(obj, key);
}
function _objectKeys(obj) {
    if (Array.isArray(obj)) {
        var keys = new Array(obj.length);
        for (var k = 0; k < keys.length; k++) {
            keys[k] = "" + k;
        }
        return keys;
    }
    if (Object.keys) {
        return Object.keys(obj);
    }
    var keys = [];
    for (var i in obj) {
        if (helpers_hasOwnProperty(obj, i)) {
            keys.push(i);
        }
    }
    return keys;
}
;
/**
* Deeply clone the object.
* https://jsperf.com/deep-copy-vs-json-stringify-json-parse/25 (recursiveDeepCopy)
* @param  {any} obj value to clone
* @return {any} cloned obj
*/
function _deepClone(obj) {
    switch (typeof obj) {
        case "object":
            return JSON.parse(JSON.stringify(obj)); //Faster than ES5 clone - http://jsperf.com/deep-cloning-of-objects/5
        case "undefined":
            return null; //this is how JSON.stringify behaves for array items
        default:
            return obj; //no need to clone primitives
    }
}
//3x faster than cached /^\d+$/.test(str)
function isInteger(str) {
    var i = 0;
    var len = str.length;
    var charCode;
    while (i < len) {
        charCode = str.charCodeAt(i);
        if (charCode >= 48 && charCode <= 57) {
            i++;
            continue;
        }
        return false;
    }
    return true;
}
/**
* Escapes a json pointer path
* @param path The raw pointer
* @return the Escaped path
*/
function escapePathComponent(path) {
    if (path.indexOf('/') === -1 && path.indexOf('~') === -1)
        return path;
    return path.replace(/~/g, '~0').replace(/\//g, '~1');
}
/**
 * Unescapes a json pointer path
 * @param path The escaped pointer
 * @return The unescaped path
 */
function unescapePathComponent(path) {
    return path.replace(/~1/g, '/').replace(/~0/g, '~');
}
function _getPathRecursive(root, obj) {
    var found;
    for (var key in root) {
        if (helpers_hasOwnProperty(root, key)) {
            if (root[key] === obj) {
                return escapePathComponent(key) + '/';
            }
            else if (typeof root[key] === 'object') {
                found = _getPathRecursive(root[key], obj);
                if (found != '') {
                    return escapePathComponent(key) + '/' + found;
                }
            }
        }
    }
    return '';
}
function getPath(root, obj) {
    if (root === obj) {
        return '/';
    }
    var path = _getPathRecursive(root, obj);
    if (path === '') {
        throw new Error("Object not found in root");
    }
    return '/' + path;
}
/**
* Recursively checks whether an object has any undefined values inside.
*/
function hasUndefined(obj) {
    if (obj === undefined) {
        return true;
    }
    if (obj) {
        if (Array.isArray(obj)) {
            for (var i = 0, len = obj.length; i < len; i++) {
                if (hasUndefined(obj[i])) {
                    return true;
                }
            }
        }
        else if (typeof obj === "object") {
            var objKeys = _objectKeys(obj);
            var objKeysLength = objKeys.length;
            for (var i = 0; i < objKeysLength; i++) {
                if (hasUndefined(obj[objKeys[i]])) {
                    return true;
                }
            }
        }
    }
    return false;
}
function patchErrorMessageFormatter(message, args) {
    var messageParts = [message];
    for (var key in args) {
        var value = typeof args[key] === 'object' ? JSON.stringify(args[key], null, 2) : args[key]; // pretty print
        if (typeof value !== 'undefined') {
            messageParts.push(key + ": " + value);
        }
    }
    return messageParts.join('\n');
}
var PatchError = /** @class */ (function (_super) {
    __extends(PatchError, _super);
    function PatchError(message, name, index, operation, tree) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, patchErrorMessageFormatter(message, { name: name, index: index, operation: operation, tree: tree })) || this;
        _this.name = name;
        _this.index = index;
        _this.operation = operation;
        _this.tree = tree;
        Object.setPrototypeOf(_this, _newTarget.prototype); // restore prototype chain, see https://stackoverflow.com/a/48342359
        _this.message = patchErrorMessageFormatter(message, { name: name, index: index, operation: operation, tree: tree });
        return _this;
    }
    return PatchError;
}(Error));


// CONCATENATED MODULE: ./node_modules/fast-json-patch/module/core.mjs

var JsonPatchError = PatchError;
var deepClone = _deepClone;
/* We use a Javascript hash to store each
 function. Each hash entry (property) uses
 the operation identifiers specified in rfc6902.
 In this way, we can map each patch operation
 to its dedicated function in efficient way.
 */
/* The operations applicable to an object */
var objOps = {
    add: function (obj, key, document) {
        obj[key] = this.value;
        return { newDocument: document };
    },
    remove: function (obj, key, document) {
        var removed = obj[key];
        delete obj[key];
        return { newDocument: document, removed: removed };
    },
    replace: function (obj, key, document) {
        var removed = obj[key];
        obj[key] = this.value;
        return { newDocument: document, removed: removed };
    },
    move: function (obj, key, document) {
        /* in case move target overwrites an existing value,
        return the removed value, this can be taxing performance-wise,
        and is potentially unneeded */
        var removed = getValueByPointer(document, this.path);
        if (removed) {
            removed = _deepClone(removed);
        }
        var originalValue = applyOperation(document, { op: "remove", path: this.from }).removed;
        applyOperation(document, { op: "add", path: this.path, value: originalValue });
        return { newDocument: document, removed: removed };
    },
    copy: function (obj, key, document) {
        var valueToCopy = getValueByPointer(document, this.from);
        // enforce copy by value so further operations don't affect source (see issue #177)
        applyOperation(document, { op: "add", path: this.path, value: _deepClone(valueToCopy) });
        return { newDocument: document };
    },
    test: function (obj, key, document) {
        return { newDocument: document, test: _areEquals(obj[key], this.value) };
    },
    _get: function (obj, key, document) {
        this.value = obj[key];
        return { newDocument: document };
    }
};
/* The operations applicable to an array. Many are the same as for the object */
var arrOps = {
    add: function (arr, i, document) {
        if (isInteger(i)) {
            arr.splice(i, 0, this.value);
        }
        else { // array props
            arr[i] = this.value;
        }
        // this may be needed when using '-' in an array
        return { newDocument: document, index: i };
    },
    remove: function (arr, i, document) {
        var removedList = arr.splice(i, 1);
        return { newDocument: document, removed: removedList[0] };
    },
    replace: function (arr, i, document) {
        var removed = arr[i];
        arr[i] = this.value;
        return { newDocument: document, removed: removed };
    },
    move: objOps.move,
    copy: objOps.copy,
    test: objOps.test,
    _get: objOps._get
};
/**
 * Retrieves a value from a JSON document by a JSON pointer.
 * Returns the value.
 *
 * @param document The document to get the value from
 * @param pointer an escaped JSON pointer
 * @return The retrieved value
 */
function getValueByPointer(document, pointer) {
    if (pointer == '') {
        return document;
    }
    var getOriginalDestination = { op: "_get", path: pointer };
    applyOperation(document, getOriginalDestination);
    return getOriginalDestination.value;
}
/**
 * Apply a single JSON Patch Operation on a JSON document.
 * Returns the {newDocument, result} of the operation.
 * It modifies the `document` and `operation` objects - it gets the values by reference.
 * If you would like to avoid touching your values, clone them:
 * `jsonpatch.applyOperation(document, jsonpatch._deepClone(operation))`.
 *
 * @param document The document to patch
 * @param operation The operation to apply
 * @param validateOperation `false` is without validation, `true` to use default jsonpatch's validation, or you can pass a `validateOperation` callback to be used for validation.
 * @param mutateDocument Whether to mutate the original document or clone it before applying
 * @param banPrototypeModifications Whether to ban modifications to `__proto__`, defaults to `true`.
 * @return `{newDocument, result}` after the operation
 */
function applyOperation(document, operation, validateOperation, mutateDocument, banPrototypeModifications, index) {
    if (validateOperation === void 0) { validateOperation = false; }
    if (mutateDocument === void 0) { mutateDocument = true; }
    if (banPrototypeModifications === void 0) { banPrototypeModifications = true; }
    if (index === void 0) { index = 0; }
    if (validateOperation) {
        if (typeof validateOperation == 'function') {
            validateOperation(operation, 0, document, operation.path);
        }
        else {
            validator(operation, 0);
        }
    }
    /* ROOT OPERATIONS */
    if (operation.path === "") {
        var returnValue = { newDocument: document };
        if (operation.op === 'add') {
            returnValue.newDocument = operation.value;
            return returnValue;
        }
        else if (operation.op === 'replace') {
            returnValue.newDocument = operation.value;
            returnValue.removed = document; //document we removed
            return returnValue;
        }
        else if (operation.op === 'move' || operation.op === 'copy') { // it's a move or copy to root
            returnValue.newDocument = getValueByPointer(document, operation.from); // get the value by json-pointer in `from` field
            if (operation.op === 'move') { // report removed item
                returnValue.removed = document;
            }
            return returnValue;
        }
        else if (operation.op === 'test') {
            returnValue.test = _areEquals(document, operation.value);
            if (returnValue.test === false) {
                throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
            }
            returnValue.newDocument = document;
            return returnValue;
        }
        else if (operation.op === 'remove') { // a remove on root
            returnValue.removed = document;
            returnValue.newDocument = null;
            return returnValue;
        }
        else if (operation.op === '_get') {
            operation.value = document;
            return returnValue;
        }
        else { /* bad operation */
            if (validateOperation) {
                throw new JsonPatchError('Operation `op` property is not one of operations defined in RFC-6902', 'OPERATION_OP_INVALID', index, operation, document);
            }
            else {
                return returnValue;
            }
        }
    } /* END ROOT OPERATIONS */
    else {
        if (!mutateDocument) {
            document = _deepClone(document);
        }
        var path = operation.path || "";
        var keys = path.split('/');
        var obj = document;
        var t = 1; //skip empty element - http://jsperf.com/to-shift-or-not-to-shift
        var len = keys.length;
        var existingPathFragment = undefined;
        var key = void 0;
        var validateFunction = void 0;
        if (typeof validateOperation == 'function') {
            validateFunction = validateOperation;
        }
        else {
            validateFunction = validator;
        }
        while (true) {
            key = keys[t];
            if (banPrototypeModifications && key == '__proto__') {
                throw new TypeError('JSON-Patch: modifying `__proto__` prop is banned for security reasons, if this was on purpose, please set `banPrototypeModifications` flag false and pass it to this function. More info in fast-json-patch README');
            }
            if (validateOperation) {
                if (existingPathFragment === undefined) {
                    if (obj[key] === undefined) {
                        existingPathFragment = keys.slice(0, t).join('/');
                    }
                    else if (t == len - 1) {
                        existingPathFragment = operation.path;
                    }
                    if (existingPathFragment !== undefined) {
                        validateFunction(operation, 0, document, existingPathFragment);
                    }
                }
            }
            t++;
            if (Array.isArray(obj)) {
                if (key === '-') {
                    key = obj.length;
                }
                else {
                    if (validateOperation && !isInteger(key)) {
                        throw new JsonPatchError("Expected an unsigned base-10 integer value, making the new referenced value the array element with the zero-based index", "OPERATION_PATH_ILLEGAL_ARRAY_INDEX", index, operation, document);
                    } // only parse key when it's an integer for `arr.prop` to work
                    else if (isInteger(key)) {
                        key = ~~key;
                    }
                }
                if (t >= len) {
                    if (validateOperation && operation.op === "add" && key > obj.length) {
                        throw new JsonPatchError("The specified index MUST NOT be greater than the number of elements in the array", "OPERATION_VALUE_OUT_OF_BOUNDS", index, operation, document);
                    }
                    var returnValue = arrOps[operation.op].call(operation, obj, key, document); // Apply patch
                    if (returnValue.test === false) {
                        throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
                    }
                    return returnValue;
                }
            }
            else {
                if (key && key.indexOf('~') != -1) {
                    key = unescapePathComponent(key);
                }
                if (t >= len) {
                    var returnValue = objOps[operation.op].call(operation, obj, key, document); // Apply patch
                    if (returnValue.test === false) {
                        throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
                    }
                    return returnValue;
                }
            }
            obj = obj[key];
        }
    }
}
/**
 * Apply a full JSON Patch array on a JSON document.
 * Returns the {newDocument, result} of the patch.
 * It modifies the `document` object and `patch` - it gets the values by reference.
 * If you would like to avoid touching your values, clone them:
 * `jsonpatch.applyPatch(document, jsonpatch._deepClone(patch))`.
 *
 * @param document The document to patch
 * @param patch The patch to apply
 * @param validateOperation `false` is without validation, `true` to use default jsonpatch's validation, or you can pass a `validateOperation` callback to be used for validation.
 * @param mutateDocument Whether to mutate the original document or clone it before applying
 * @param banPrototypeModifications Whether to ban modifications to `__proto__`, defaults to `true`.
 * @return An array of `{newDocument, result}` after the patch
 */
function applyPatch(document, patch, validateOperation, mutateDocument, banPrototypeModifications) {
    if (mutateDocument === void 0) { mutateDocument = true; }
    if (banPrototypeModifications === void 0) { banPrototypeModifications = true; }
    if (validateOperation) {
        if (!Array.isArray(patch)) {
            throw new JsonPatchError('Patch sequence must be an array', 'SEQUENCE_NOT_AN_ARRAY');
        }
    }
    if (!mutateDocument) {
        document = _deepClone(document);
    }
    var results = new Array(patch.length);
    for (var i = 0, length_1 = patch.length; i < length_1; i++) {
        // we don't need to pass mutateDocument argument because if it was true, we already deep cloned the object, we'll just pass `true`
        results[i] = applyOperation(document, patch[i], validateOperation, true, banPrototypeModifications, i);
        document = results[i].newDocument; // in case root was replaced
    }
    results.newDocument = document;
    return results;
}
/**
 * Apply a single JSON Patch Operation on a JSON document.
 * Returns the updated document.
 * Suitable as a reducer.
 *
 * @param document The document to patch
 * @param operation The operation to apply
 * @return The updated document
 */
function applyReducer(document, operation, index) {
    var operationResult = applyOperation(document, operation);
    if (operationResult.test === false) { // failed test
        throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
    }
    return operationResult.newDocument;
}
/**
 * Validates a single operation. Called from `jsonpatch.validate`. Throws `JsonPatchError` in case of an error.
 * @param {object} operation - operation object (patch)
 * @param {number} index - index of operation in the sequence
 * @param {object} [document] - object where the operation is supposed to be applied
 * @param {string} [existingPathFragment] - comes along with `document`
 */
function validator(operation, index, document, existingPathFragment) {
    if (typeof operation !== 'object' || operation === null || Array.isArray(operation)) {
        throw new JsonPatchError('Operation is not an object', 'OPERATION_NOT_AN_OBJECT', index, operation, document);
    }
    else if (!objOps[operation.op]) {
        throw new JsonPatchError('Operation `op` property is not one of operations defined in RFC-6902', 'OPERATION_OP_INVALID', index, operation, document);
    }
    else if (typeof operation.path !== 'string') {
        throw new JsonPatchError('Operation `path` property is not a string', 'OPERATION_PATH_INVALID', index, operation, document);
    }
    else if (operation.path.indexOf('/') !== 0 && operation.path.length > 0) {
        // paths that aren't empty string should start with "/"
        throw new JsonPatchError('Operation `path` property must start with "/"', 'OPERATION_PATH_INVALID', index, operation, document);
    }
    else if ((operation.op === 'move' || operation.op === 'copy') && typeof operation.from !== 'string') {
        throw new JsonPatchError('Operation `from` property is not present (applicable in `move` and `copy` operations)', 'OPERATION_FROM_REQUIRED', index, operation, document);
    }
    else if ((operation.op === 'add' || operation.op === 'replace' || operation.op === 'test') && operation.value === undefined) {
        throw new JsonPatchError('Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)', 'OPERATION_VALUE_REQUIRED', index, operation, document);
    }
    else if ((operation.op === 'add' || operation.op === 'replace' || operation.op === 'test') && hasUndefined(operation.value)) {
        throw new JsonPatchError('Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)', 'OPERATION_VALUE_CANNOT_CONTAIN_UNDEFINED', index, operation, document);
    }
    else if (document) {
        if (operation.op == "add") {
            var pathLen = operation.path.split("/").length;
            var existingPathLen = existingPathFragment.split("/").length;
            if (pathLen !== existingPathLen + 1 && pathLen !== existingPathLen) {
                throw new JsonPatchError('Cannot perform an `add` operation at the desired path', 'OPERATION_PATH_CANNOT_ADD', index, operation, document);
            }
        }
        else if (operation.op === 'replace' || operation.op === 'remove' || operation.op === '_get') {
            if (operation.path !== existingPathFragment) {
                throw new JsonPatchError('Cannot perform the operation at a path that does not exist', 'OPERATION_PATH_UNRESOLVABLE', index, operation, document);
            }
        }
        else if (operation.op === 'move' || operation.op === 'copy') {
            var existingValue = { op: "_get", path: operation.from, value: undefined };
            var error = validate([existingValue], document);
            if (error && error.name === 'OPERATION_PATH_UNRESOLVABLE') {
                throw new JsonPatchError('Cannot perform the operation from a path that does not exist', 'OPERATION_FROM_UNRESOLVABLE', index, operation, document);
            }
        }
    }
}
/**
 * Validates a sequence of operations. If `document` parameter is provided, the sequence is additionally validated against the object document.
 * If error is encountered, returns a JsonPatchError object
 * @param sequence
 * @param document
 * @returns {JsonPatchError|undefined}
 */
function validate(sequence, document, externalValidator) {
    try {
        if (!Array.isArray(sequence)) {
            throw new JsonPatchError('Patch sequence must be an array', 'SEQUENCE_NOT_AN_ARRAY');
        }
        if (document) {
            //clone document and sequence so that we can safely try applying operations
            applyPatch(_deepClone(document), _deepClone(sequence), externalValidator || true);
        }
        else {
            externalValidator = externalValidator || validator;
            for (var i = 0; i < sequence.length; i++) {
                externalValidator(sequence[i], i, document, undefined);
            }
        }
    }
    catch (e) {
        if (e instanceof JsonPatchError) {
            return e;
        }
        else {
            throw e;
        }
    }
}
// based on https://github.com/epoberezkin/fast-deep-equal
// MIT License
// Copyright (c) 2017 Evgeny Poberezkin
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
function _areEquals(a, b) {
    if (a === b)
        return true;
    if (a && b && typeof a == 'object' && typeof b == 'object') {
        var arrA = Array.isArray(a), arrB = Array.isArray(b), i, length, key;
        if (arrA && arrB) {
            length = a.length;
            if (length != b.length)
                return false;
            for (i = length; i-- !== 0;)
                if (!_areEquals(a[i], b[i]))
                    return false;
            return true;
        }
        if (arrA != arrB)
            return false;
        var keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length)
            return false;
        for (i = length; i-- !== 0;)
            if (!b.hasOwnProperty(keys[i]))
                return false;
        for (i = length; i-- !== 0;) {
            key = keys[i];
            if (!_areEquals(a[key], b[key]))
                return false;
        }
        return true;
    }
    return a !== a && b !== b;
}
;

// CONCATENATED MODULE: ./node_modules/fast-json-patch/module/duplex.mjs
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017 Joachim Wester
 * MIT license
 */


var beforeDict = new WeakMap();
var Mirror = /** @class */ (function () {
    function Mirror(obj) {
        this.observers = new Map();
        this.obj = obj;
    }
    return Mirror;
}());
var ObserverInfo = /** @class */ (function () {
    function ObserverInfo(callback, observer) {
        this.callback = callback;
        this.observer = observer;
    }
    return ObserverInfo;
}());
function getMirror(obj) {
    return beforeDict.get(obj);
}
function getObserverFromMirror(mirror, callback) {
    return mirror.observers.get(callback);
}
function removeObserverFromMirror(mirror, observer) {
    mirror.observers.delete(observer.callback);
}
/**
 * Detach an observer from an object
 */
function unobserve(root, observer) {
    observer.unobserve();
}
/**
 * Observes changes made to an object, which can then be retrieved using generate
 */
function observe(obj, callback) {
    var patches = [];
    var observer;
    var mirror = getMirror(obj);
    if (!mirror) {
        mirror = new Mirror(obj);
        beforeDict.set(obj, mirror);
    }
    else {
        var observerInfo = getObserverFromMirror(mirror, callback);
        observer = observerInfo && observerInfo.observer;
    }
    if (observer) {
        return observer;
    }
    observer = {};
    mirror.value = _deepClone(obj);
    if (callback) {
        observer.callback = callback;
        observer.next = null;
        var dirtyCheck = function () {
            generate(observer);
        };
        var fastCheck = function () {
            clearTimeout(observer.next);
            observer.next = setTimeout(dirtyCheck);
        };
        if (typeof window !== 'undefined') { //not Node
            window.addEventListener('mouseup', fastCheck);
            window.addEventListener('keyup', fastCheck);
            window.addEventListener('mousedown', fastCheck);
            window.addEventListener('keydown', fastCheck);
            window.addEventListener('change', fastCheck);
        }
    }
    observer.patches = patches;
    observer.object = obj;
    observer.unobserve = function () {
        generate(observer);
        clearTimeout(observer.next);
        removeObserverFromMirror(mirror, observer);
        if (typeof window !== 'undefined') {
            window.removeEventListener('mouseup', fastCheck);
            window.removeEventListener('keyup', fastCheck);
            window.removeEventListener('mousedown', fastCheck);
            window.removeEventListener('keydown', fastCheck);
            window.removeEventListener('change', fastCheck);
        }
    };
    mirror.observers.set(callback, new ObserverInfo(callback, observer));
    return observer;
}
/**
 * Generate an array of patches from an observer
 */
function generate(observer, invertible) {
    if (invertible === void 0) { invertible = false; }
    var mirror = beforeDict.get(observer.object);
    _generate(mirror.value, observer.object, observer.patches, "", invertible);
    if (observer.patches.length) {
        applyPatch(mirror.value, observer.patches);
    }
    var temp = observer.patches;
    if (temp.length > 0) {
        observer.patches = [];
        if (observer.callback) {
            observer.callback(temp);
        }
    }
    return temp;
}
// Dirty check if obj is different from mirror, generate patches and update mirror
function _generate(mirror, obj, patches, path, invertible) {
    if (obj === mirror) {
        return;
    }
    if (typeof obj.toJSON === "function") {
        obj = obj.toJSON();
    }
    var newKeys = _objectKeys(obj);
    var oldKeys = _objectKeys(mirror);
    var changed = false;
    var deleted = false;
    //if ever "move" operation is implemented here, make sure this test runs OK: "should not generate the same patch twice (move)"
    for (var t = oldKeys.length - 1; t >= 0; t--) {
        var key = oldKeys[t];
        var oldVal = mirror[key];
        if (helpers_hasOwnProperty(obj, key) && !(obj[key] === undefined && oldVal !== undefined && Array.isArray(obj) === false)) {
            var newVal = obj[key];
            if (typeof oldVal == "object" && oldVal != null && typeof newVal == "object" && newVal != null) {
                _generate(oldVal, newVal, patches, path + "/" + escapePathComponent(key), invertible);
            }
            else {
                if (oldVal !== newVal) {
                    changed = true;
                    if (invertible) {
                        patches.push({ op: "test", path: path + "/" + escapePathComponent(key), value: _deepClone(oldVal) });
                    }
                    patches.push({ op: "replace", path: path + "/" + escapePathComponent(key), value: _deepClone(newVal) });
                }
            }
        }
        else if (Array.isArray(mirror) === Array.isArray(obj)) {
            if (invertible) {
                patches.push({ op: "test", path: path + "/" + escapePathComponent(key), value: _deepClone(oldVal) });
            }
            patches.push({ op: "remove", path: path + "/" + escapePathComponent(key) });
            deleted = true; // property has been deleted
        }
        else {
            if (invertible) {
                patches.push({ op: "test", path: path, value: mirror });
            }
            patches.push({ op: "replace", path: path, value: obj });
            changed = true;
        }
    }
    if (!deleted && newKeys.length == oldKeys.length) {
        return;
    }
    for (var t = 0; t < newKeys.length; t++) {
        var key = newKeys[t];
        if (!helpers_hasOwnProperty(mirror, key) && obj[key] !== undefined) {
            patches.push({ op: "add", path: path + "/" + escapePathComponent(key), value: _deepClone(obj[key]) });
        }
    }
}
/**
 * Create an array of patches from the differences in two objects
 */
function compare(tree1, tree2, invertible) {
    if (invertible === void 0) { invertible = false; }
    var patches = [];
    _generate(tree1, tree2, patches, '', invertible);
    return patches;
}

// CONCATENATED MODULE: ./node_modules/fast-json-patch/index.mjs





/**
 * Default export for backwards compat
 */





/* harmony default export */ var fast_json_patch = (Object.assign({}, core_namespaceObject, duplex_namespaceObject, {
    JsonPatchError: PatchError,
    deepClone: _deepClone,
    escapePathComponent: escapePathComponent,
    unescapePathComponent: unescapePathComponent
}));

/***/ }),

/***/ "3iBx":
/***/ (function(module) {

module.exports = JSON.parse("{\"name\":\"vega-tooltip\",\"version\":\"0.23.2\",\"description\":\"A tooltip plugin for Vega-Lite and Vega visualizations.\",\"main\":\"build/vega-tooltip.js\",\"module\":\"build/src/index.js\",\"unpkg\":\"build/vega-tooltip.min.js\",\"jsdelivr\":\"build/vega-tooltip.min.js\",\"typings\":\"build/src/index.d.ts\",\"repository\":{\"type\":\"git\",\"url\":\"https://github.com/vega/vega-tooltip.git\"},\"keywords\":[\"vega-lite\",\"vega\",\"tooltip\"],\"author\":{\"name\":\"UW Interactive Data Lab\",\"url\":\"https://idl.cs.washington.edu\"},\"collaborators\":[\"Dominik Moritz\",\"Sira Horradarn\",\"Zening Qu\",\"Kanit Wongsuphasawat\",\"Yuri Astrakhan\",\"Jeffrey Heer\"],\"license\":\"BSD-3-Clause\",\"bugs\":{\"url\":\"https://github.com/vega/vega-tooltip/issues\"},\"homepage\":\"https://github.com/vega/vega-tooltip#readme\",\"scripts\":{\"prepare\":\"beemo create-config --silent\",\"tsc:src\":\"tsc -b tsconfig.src.json\",\"build\":\"yarn tsc:src && rollup -c\",\"clean\":\"rm -rf build examples/data && rm -f src/style.ts\",\"copy:data\":\"rsync -r node_modules/vega-datasets/data/* examples/data\",\"copy:build\":\"rsync -r build/* examples/build\",\"deploy:gh\":\"yarn build && yarn copy:build && gh-pages -d examples && yarn clean\",\"prettierbase\":\"beemo prettier 'examples/*.{html,scss,css}'\",\"eslintbase\":\"beemo eslint .\",\"format\":\"yarn eslintbase --fix && yarn prettierbase --write\",\"lint\":\"yarn eslintbase && yarn prettierbase --check\",\"postbuild\":\"terser build/vega-tooltip.js -c -m -o build/vega-tooltip.min.js\",\"prebuild\":\"mkdir -p build && yarn copy:data && ./build-style.sh\",\"prepublishOnly\":\"yarn clean && yarn build\",\"preversion\":\"yarn lint\",\"start\":\"yarn build && concurrently --kill-others -n Server,Typescript,Rollup 'browser-sync start -s -f build examples --serveStatic examples' 'yarn tsc:src -w' 'rollup -c -w'\",\"pretest\":\"./build-style.sh\",\"test\":\"jest\"},\"devDependencies\":{\"@rollup/plugin-commonjs\":\"13.0.0\",\"@rollup/plugin-json\":\"^4.1.0\",\"@rollup/plugin-node-resolve\":\"^8.1.0\",\"@types/jest\":\"^26.0.4\",\"browser-sync\":\"^2.26.7\",\"codecov\":\"^3.7.0\",\"concurrently\":\"^5.2.0\",\"gh-pages\":\"^3.1.0\",\"jest\":\"^26.1.0\",\"node-sass\":\"^4.14.1\",\"path\":\"^0.12.7\",\"rollup\":\"^2.21.0\",\"terser\":\"^4.8.0\",\"ts-jest\":\"^26.1.1\",\"typescript\":\"^3.9.6\",\"vega-datasets\":\"^2.1.0\",\"vega-lite-dev-config\":\"^0.11.8\",\"vega-typings\":\"^0.18.0\"},\"dependencies\":{\"vega-util\":\"^1.14.1\"},\"beemo\":{\"module\":\"vega-lite-dev-config\",\"drivers\":[\"prettier\",\"eslint\"]},\"jest\":{\"testURL\":\"http://localhost/\",\"transform\":{\"^.+\\\\.tsx?$\":\"ts-jest\"},\"testRegex\":\"(/__tests__/.*|(\\\\.|/)(test|spec))\\\\.(jsx?|tsx?)$\",\"moduleFileExtensions\":[\"ts\",\"tsx\",\"js\",\"jsx\",\"json\",\"node\"],\"testPathIgnorePatterns\":[\"node_modules\",\"<rootDir>/build\",\"src\"]}}");

/***/ }),

/***/ "8Sdu":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ event_selector; });

// CONCATENATED MODULE: ./node_modules/vega-event-selector/src/event-selector.js
/**
 * Parse an event selector string.
 * Returns an array of event stream definitions.
 */
/* harmony default export */ var event_selector = (function(selector, source, marks) {
  DEFAULT_SOURCE = source || VIEW;
  MARKS = marks || DEFAULT_MARKS;
  return parseMerge(selector.trim()).map(parseSelector);
});

var VIEW    = 'view',
    LBRACK  = '[',
    RBRACK  = ']',
    LBRACE  = '{',
    RBRACE  = '}',
    COLON   = ':',
    COMMA   = ',',
    NAME    = '@',
    GT      = '>',
    ILLEGAL = /[[\]{}]/,
    DEFAULT_SOURCE,
    MARKS,
    DEFAULT_MARKS = {
      '*': 1,
      arc: 1,
      area: 1,
      group: 1,
      image: 1,
      line: 1,
      path: 1,
      rect: 1,
      rule: 1,
      shape: 1,
      symbol: 1,
      text: 1,
      trail: 1
    };

function isMarkType(type) {
  return MARKS[type];
}

function find(s, i, endChar, pushChar, popChar) {
  var count = 0,
      n = s.length,
      c;
  for (; i<n; ++i) {
    c = s[i];
    if (!count && c === endChar) return i;
    else if (popChar && popChar.indexOf(c) >= 0) --count;
    else if (pushChar && pushChar.indexOf(c) >= 0) ++count;
  }
  return i;
}

function parseMerge(s) {
  var output = [],
      start = 0,
      n = s.length,
      i = 0;

  while (i < n) {
    i = find(s, i, COMMA, LBRACK + LBRACE, RBRACK + RBRACE);
    output.push(s.substring(start, i).trim());
    start = ++i;
  }

  if (output.length === 0) {
    throw 'Empty event selector: ' + s;
  }
  return output;
}

function parseSelector(s) {
  return s[0] === '['
    ? parseBetween(s)
    : parseStream(s);
}

function parseBetween(s) {
  var n = s.length,
      i = 1,
      b, stream;

  i = find(s, i, RBRACK, LBRACK, RBRACK);
  if (i === n) {
    throw 'Empty between selector: ' + s;
  }

  b = parseMerge(s.substring(1, i));
  if (b.length !== 2) {
    throw 'Between selector must have two elements: ' + s;
  }

  s = s.slice(i + 1).trim();
  if (s[0] !== GT) {
    throw 'Expected \'>\' after between selector: ' + s;
  }

  b = b.map(parseSelector);

  stream = parseSelector(s.slice(1).trim());
  if (stream.between) {
    return {
      between: b,
      stream: stream
    };
  } else {
    stream.between = b;
  }

  return stream;
}

function parseStream(s) {
  var stream = {source: DEFAULT_SOURCE},
      source = [],
      throttle = [0, 0],
      markname = 0,
      start = 0,
      n = s.length,
      i = 0, j,
      filter;

  // extract throttle from end
  if (s[n-1] === RBRACE) {
    i = s.lastIndexOf(LBRACE);
    if (i >= 0) {
      try {
        throttle = parseThrottle(s.substring(i+1, n-1));
      } catch (e) {
        throw 'Invalid throttle specification: ' + s;
      }
      s = s.slice(0, i).trim();
      n = s.length;
    } else throw 'Unmatched right brace: ' + s;
    i = 0;
  }

  if (!n) throw s;

  // set name flag based on first char
  if (s[0] === NAME) markname = ++i;

  // extract first part of multi-part stream selector
  j = find(s, i, COLON);
  if (j < n) {
    source.push(s.substring(start, j).trim());
    start = i = ++j;
  }

  // extract remaining part of stream selector
  i = find(s, i, LBRACK);
  if (i === n) {
    source.push(s.substring(start, n).trim());
  } else {
    source.push(s.substring(start, i).trim());
    filter = [];
    start = ++i;
    if (start === n) throw 'Unmatched left bracket: ' + s;
  }

  // extract filters
  while (i < n) {
    i = find(s, i, RBRACK);
    if (i === n) throw 'Unmatched left bracket: ' + s;
    filter.push(s.substring(start, i).trim());
    if (i < n-1 && s[++i] !== LBRACK) throw 'Expected left bracket: ' + s;
    start = ++i;
  }

  // marshall event stream specification
  if (!(n = source.length) || ILLEGAL.test(source[n-1])) {
    throw 'Invalid event selector: ' + s;
  }

  if (n > 1) {
    stream.type = source[1];
    if (markname) {
      stream.markname = source[0].slice(1);
    } else if (isMarkType(source[0])) {
      stream.marktype = source[0];
    } else {
      stream.source = source[0];
    }
  } else {
    stream.type = source[0];
  }
  if (stream.type.slice(-1) === '!') {
    stream.consume = true;
    stream.type = stream.type.slice(0, -1);
  }
  if (filter != null) stream.filter = filter;
  if (throttle[0]) stream.throttle = throttle[0];
  if (throttle[1]) stream.debounce = throttle[1];

  return stream;
}

function parseThrottle(s) {
  var a = s.split(COMMA);
  if (!s.length || a.length > 2) throw s;
  return a.map(function(_) {
    var x = +_;
    if (x !== x) throw s;
    return x;
  });
}

// CONCATENATED MODULE: ./node_modules/vega-event-selector/index.js



/***/ }),

/***/ "8WEG":
/***/ (function(module) {

module.exports = JSON.parse("{\"a\":\"5.13.0\"}");

/***/ }),

/***/ "8ZXz":
/***/ (function(module, exports, __webpack_require__) {

const compare = __webpack_require__("MDTW")
const neq = (a, b, loose) => compare(a, b, loose) !== 0
module.exports = neq


/***/ }),

/***/ "9nwm":
/***/ (function(module, exports, __webpack_require__) {

// given a set of versions and a range, create a "simplified" range
// that includes the same versions that the original range does
// If the original range is shorter than the simplified one, return that.
const satisfies = __webpack_require__("KoYs")
const compare = __webpack_require__("MDTW")
module.exports = (versions, range, options) => {
  const set = []
  let min = null
  let prev = null
  const v = versions.sort((a, b) => compare(a, b, options))
  for (const version of v) {
    const included = satisfies(version, range, options)
    if (included) {
      prev = version
      if (!min)
        min = version
    } else {
      if (prev) {
        set.push([min, prev])
      }
      prev = null
      min = null
    }
  }
  if (min)
    set.push([min, null])

  const ranges = []
  for (const [min, max] of set) {
    if (min === max)
      ranges.push(min)
    else if (!max && min === v[0])
      ranges.push('*')
    else if (!max)
      ranges.push(`>=${min}`)
    else if (min === v[0])
      ranges.push(`<=${max}`)
    else
      ranges.push(`${min} - ${max}`)
  }
  const simplified = ranges.join(' || ')
  const original = typeof range.raw === 'string' ? range.raw : String(range)
  return simplified.length < original.length ? simplified : range
}


/***/ }),

/***/ "A3zY":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, "version", function() { return /* reexport */ vega_package["a" /* version */]; });
__webpack_require__.d(__webpack_exports__, "bandwidthNRD", function() { return /* reexport */ src_bandwidth; });
__webpack_require__.d(__webpack_exports__, "bin", function() { return /* reexport */ vega_statistics_src_bin; });
__webpack_require__.d(__webpack_exports__, "bootstrapCI", function() { return /* reexport */ bootstrapCI; });
__webpack_require__.d(__webpack_exports__, "dotbin", function() { return /* reexport */ dotbin; });
__webpack_require__.d(__webpack_exports__, "quantiles", function() { return /* reexport */ quantiles; });
__webpack_require__.d(__webpack_exports__, "quartiles", function() { return /* reexport */ quartiles; });
__webpack_require__.d(__webpack_exports__, "random", function() { return /* reexport */ random_random; });
__webpack_require__.d(__webpack_exports__, "setRandom", function() { return /* reexport */ setRandom; });
__webpack_require__.d(__webpack_exports__, "randomLCG", function() { return /* reexport */ lcg; });
__webpack_require__.d(__webpack_exports__, "randomInteger", function() { return /* reexport */ integer; });
__webpack_require__.d(__webpack_exports__, "randomKDE", function() { return /* reexport */ src_kde; });
__webpack_require__.d(__webpack_exports__, "randomLogNormal", function() { return /* reexport */ lognormal; });
__webpack_require__.d(__webpack_exports__, "sampleLogNormal", function() { return /* reexport */ sampleLogNormal; });
__webpack_require__.d(__webpack_exports__, "densityLogNormal", function() { return /* reexport */ densityLogNormal; });
__webpack_require__.d(__webpack_exports__, "cumulativeLogNormal", function() { return /* reexport */ cumulativeLogNormal; });
__webpack_require__.d(__webpack_exports__, "quantileLogNormal", function() { return /* reexport */ quantileLogNormal; });
__webpack_require__.d(__webpack_exports__, "randomMixture", function() { return /* reexport */ mixture; });
__webpack_require__.d(__webpack_exports__, "randomNormal", function() { return /* reexport */ src_normal; });
__webpack_require__.d(__webpack_exports__, "sampleNormal", function() { return /* reexport */ sampleNormal; });
__webpack_require__.d(__webpack_exports__, "densityNormal", function() { return /* reexport */ densityNormal; });
__webpack_require__.d(__webpack_exports__, "cumulativeNormal", function() { return /* reexport */ cumulativeNormal; });
__webpack_require__.d(__webpack_exports__, "quantileNormal", function() { return /* reexport */ quantileNormal; });
__webpack_require__.d(__webpack_exports__, "randomUniform", function() { return /* reexport */ uniform; });
__webpack_require__.d(__webpack_exports__, "sampleUniform", function() { return /* reexport */ sampleUniform; });
__webpack_require__.d(__webpack_exports__, "densityUniform", function() { return /* reexport */ densityUniform; });
__webpack_require__.d(__webpack_exports__, "cumulativeUniform", function() { return /* reexport */ cumulativeUniform; });
__webpack_require__.d(__webpack_exports__, "quantileUniform", function() { return /* reexport */ quantileUniform; });
__webpack_require__.d(__webpack_exports__, "regressionLinear", function() { return /* reexport */ linear; });
__webpack_require__.d(__webpack_exports__, "regressionLog", function() { return /* reexport */ log; });
__webpack_require__.d(__webpack_exports__, "regressionExp", function() { return /* reexport */ exp; });
__webpack_require__.d(__webpack_exports__, "regressionPow", function() { return /* reexport */ pow; });
__webpack_require__.d(__webpack_exports__, "regressionQuad", function() { return /* reexport */ regression_quad; });
__webpack_require__.d(__webpack_exports__, "regressionPoly", function() { return /* reexport */ poly; });
__webpack_require__.d(__webpack_exports__, "regressionLoess", function() { return /* reexport */ loess; });
__webpack_require__.d(__webpack_exports__, "sampleCurve", function() { return /* reexport */ sampleCurve; });
__webpack_require__.d(__webpack_exports__, "TIME_UNITS", function() { return /* reexport */ TIME_UNITS; });
__webpack_require__.d(__webpack_exports__, "YEAR", function() { return /* reexport */ YEAR; });
__webpack_require__.d(__webpack_exports__, "QUARTER", function() { return /* reexport */ QUARTER; });
__webpack_require__.d(__webpack_exports__, "MONTH", function() { return /* reexport */ MONTH; });
__webpack_require__.d(__webpack_exports__, "WEEK", function() { return /* reexport */ WEEK; });
__webpack_require__.d(__webpack_exports__, "DATE", function() { return /* reexport */ DATE; });
__webpack_require__.d(__webpack_exports__, "DAY", function() { return /* reexport */ DAY; });
__webpack_require__.d(__webpack_exports__, "DAYOFYEAR", function() { return /* reexport */ DAYOFYEAR; });
__webpack_require__.d(__webpack_exports__, "HOURS", function() { return /* reexport */ HOURS; });
__webpack_require__.d(__webpack_exports__, "MINUTES", function() { return /* reexport */ MINUTES; });
__webpack_require__.d(__webpack_exports__, "SECONDS", function() { return /* reexport */ SECONDS; });
__webpack_require__.d(__webpack_exports__, "MILLISECONDS", function() { return /* reexport */ MILLISECONDS; });
__webpack_require__.d(__webpack_exports__, "timeUnitSpecifier", function() { return /* reexport */ timeUnitSpecifier; });
__webpack_require__.d(__webpack_exports__, "timeUnits", function() { return /* reexport */ timeUnits; });
__webpack_require__.d(__webpack_exports__, "dayofyear", function() { return /* reexport */ dayofyear; });
__webpack_require__.d(__webpack_exports__, "week", function() { return /* reexport */ util_week; });
__webpack_require__.d(__webpack_exports__, "utcdayofyear", function() { return /* reexport */ utcdayofyear; });
__webpack_require__.d(__webpack_exports__, "utcweek", function() { return /* reexport */ utcweek; });
__webpack_require__.d(__webpack_exports__, "timeFloor", function() { return /* reexport */ timeFloor; });
__webpack_require__.d(__webpack_exports__, "utcFloor", function() { return /* reexport */ utcFloor; });
__webpack_require__.d(__webpack_exports__, "timeInterval", function() { return /* reexport */ timeInterval; });
__webpack_require__.d(__webpack_exports__, "timeOffset", function() { return /* reexport */ timeOffset; });
__webpack_require__.d(__webpack_exports__, "timeSequence", function() { return /* reexport */ timeSequence; });
__webpack_require__.d(__webpack_exports__, "utcInterval", function() { return /* reexport */ utcInterval; });
__webpack_require__.d(__webpack_exports__, "utcOffset", function() { return /* reexport */ utcOffset; });
__webpack_require__.d(__webpack_exports__, "utcSequence", function() { return /* reexport */ utcSequence; });
__webpack_require__.d(__webpack_exports__, "timeBin", function() { return /* reexport */ src_bin; });
__webpack_require__.d(__webpack_exports__, "accessor", function() { return /* reexport */ vega_util["f" /* accessor */]; });
__webpack_require__.d(__webpack_exports__, "accessorName", function() { return /* reexport */ vega_util["h" /* accessorName */]; });
__webpack_require__.d(__webpack_exports__, "accessorFields", function() { return /* reexport */ vega_util["g" /* accessorFields */]; });
__webpack_require__.d(__webpack_exports__, "id", function() { return /* reexport */ vega_util["w" /* id */]; });
__webpack_require__.d(__webpack_exports__, "identity", function() { return /* reexport */ vega_util["x" /* identity */]; });
__webpack_require__.d(__webpack_exports__, "zero", function() { return /* reexport */ vega_util["kb" /* zero */]; });
__webpack_require__.d(__webpack_exports__, "one", function() { return /* reexport */ vega_util["O" /* one */]; });
__webpack_require__.d(__webpack_exports__, "truthy", function() { return /* reexport */ vega_util["gb" /* truthy */]; });
__webpack_require__.d(__webpack_exports__, "falsy", function() { return /* reexport */ vega_util["r" /* falsy */]; });
__webpack_require__.d(__webpack_exports__, "logger", function() { return /* reexport */ vega_util["K" /* logger */]; });
__webpack_require__.d(__webpack_exports__, "None", function() { return /* reexport */ vega_util["d" /* None */]; });
__webpack_require__.d(__webpack_exports__, "Error", function() { return /* reexport */ vega_util["b" /* Error */]; });
__webpack_require__.d(__webpack_exports__, "Warn", function() { return /* reexport */ vega_util["e" /* Warn */]; });
__webpack_require__.d(__webpack_exports__, "Info", function() { return /* reexport */ vega_util["c" /* Info */]; });
__webpack_require__.d(__webpack_exports__, "Debug", function() { return /* reexport */ vega_util["a" /* Debug */]; });
__webpack_require__.d(__webpack_exports__, "mergeConfig", function() { return /* reexport */ vega_util["N" /* mergeConfig */]; });
__webpack_require__.d(__webpack_exports__, "writeConfig", function() { return /* reexport */ vega_util["jb" /* writeConfig */]; });
__webpack_require__.d(__webpack_exports__, "panLinear", function() { return /* reexport */ vega_util["Q" /* panLinear */]; });
__webpack_require__.d(__webpack_exports__, "panLog", function() { return /* reexport */ vega_util["R" /* panLog */]; });
__webpack_require__.d(__webpack_exports__, "panPow", function() { return /* reexport */ vega_util["S" /* panPow */]; });
__webpack_require__.d(__webpack_exports__, "panSymlog", function() { return /* reexport */ vega_util["T" /* panSymlog */]; });
__webpack_require__.d(__webpack_exports__, "zoomLinear", function() { return /* reexport */ vega_util["lb" /* zoomLinear */]; });
__webpack_require__.d(__webpack_exports__, "zoomLog", function() { return /* reexport */ vega_util["mb" /* zoomLog */]; });
__webpack_require__.d(__webpack_exports__, "zoomPow", function() { return /* reexport */ vega_util["nb" /* zoomPow */]; });
__webpack_require__.d(__webpack_exports__, "zoomSymlog", function() { return /* reexport */ vega_util["ob" /* zoomSymlog */]; });
__webpack_require__.d(__webpack_exports__, "quarter", function() { return /* reexport */ vega_util["V" /* quarter */]; });
__webpack_require__.d(__webpack_exports__, "utcquarter", function() { return /* reexport */ vega_util["hb" /* utcquarter */]; });
__webpack_require__.d(__webpack_exports__, "array", function() { return /* reexport */ vega_util["i" /* array */]; });
__webpack_require__.d(__webpack_exports__, "clampRange", function() { return /* reexport */ vega_util["j" /* clampRange */]; });
__webpack_require__.d(__webpack_exports__, "compare", function() { return /* reexport */ vega_util["k" /* compare */]; });
__webpack_require__.d(__webpack_exports__, "constant", function() { return /* reexport */ vega_util["l" /* constant */]; });
__webpack_require__.d(__webpack_exports__, "debounce", function() { return /* reexport */ vega_util["m" /* debounce */]; });
__webpack_require__.d(__webpack_exports__, "error", function() { return /* reexport */ vega_util["n" /* error */]; });
__webpack_require__.d(__webpack_exports__, "extend", function() { return /* reexport */ vega_util["o" /* extend */]; });
__webpack_require__.d(__webpack_exports__, "extent", function() { return /* reexport */ vega_util["p" /* extent */]; });
__webpack_require__.d(__webpack_exports__, "extentIndex", function() { return /* reexport */ vega_util["q" /* extentIndex */]; });
__webpack_require__.d(__webpack_exports__, "fastmap", function() { return /* reexport */ vega_util["s" /* fastmap */]; });
__webpack_require__.d(__webpack_exports__, "field", function() { return /* reexport */ vega_util["t" /* field */]; });
__webpack_require__.d(__webpack_exports__, "flush", function() { return /* reexport */ vega_util["u" /* flush */]; });
__webpack_require__.d(__webpack_exports__, "hasOwnProperty", function() { return /* reexport */ vega_util["v" /* hasOwnProperty */]; });
__webpack_require__.d(__webpack_exports__, "inherits", function() { return /* reexport */ vega_util["y" /* inherits */]; });
__webpack_require__.d(__webpack_exports__, "inrange", function() { return /* reexport */ vega_util["z" /* inrange */]; });
__webpack_require__.d(__webpack_exports__, "isArray", function() { return /* reexport */ vega_util["A" /* isArray */]; });
__webpack_require__.d(__webpack_exports__, "isBoolean", function() { return /* reexport */ vega_util["B" /* isBoolean */]; });
__webpack_require__.d(__webpack_exports__, "isDate", function() { return /* reexport */ vega_util["C" /* isDate */]; });
__webpack_require__.d(__webpack_exports__, "isFunction", function() { return /* reexport */ vega_util["D" /* isFunction */]; });
__webpack_require__.d(__webpack_exports__, "isNumber", function() { return /* reexport */ vega_util["E" /* isNumber */]; });
__webpack_require__.d(__webpack_exports__, "isObject", function() { return /* reexport */ vega_util["F" /* isObject */]; });
__webpack_require__.d(__webpack_exports__, "isRegExp", function() { return /* reexport */ vega_util["G" /* isRegExp */]; });
__webpack_require__.d(__webpack_exports__, "isString", function() { return /* reexport */ vega_util["H" /* isString */]; });
__webpack_require__.d(__webpack_exports__, "key", function() { return /* reexport */ vega_util["I" /* key */]; });
__webpack_require__.d(__webpack_exports__, "lerp", function() { return /* reexport */ vega_util["J" /* lerp */]; });
__webpack_require__.d(__webpack_exports__, "lruCache", function() { return /* reexport */ vega_util["L" /* lruCache */]; });
__webpack_require__.d(__webpack_exports__, "merge", function() { return /* reexport */ vega_util["M" /* merge */]; });
__webpack_require__.d(__webpack_exports__, "pad", function() { return /* reexport */ vega_util["P" /* pad */]; });
__webpack_require__.d(__webpack_exports__, "peek", function() { return /* reexport */ vega_util["U" /* peek */]; });
__webpack_require__.d(__webpack_exports__, "repeat", function() { return /* reexport */ vega_util["W" /* repeat */]; });
__webpack_require__.d(__webpack_exports__, "span", function() { return /* reexport */ vega_util["X" /* span */]; });
__webpack_require__.d(__webpack_exports__, "splitAccessPath", function() { return /* reexport */ vega_util["Y" /* splitAccessPath */]; });
__webpack_require__.d(__webpack_exports__, "stringValue", function() { return /* reexport */ vega_util["Z" /* stringValue */]; });
__webpack_require__.d(__webpack_exports__, "toBoolean", function() { return /* reexport */ vega_util["ab" /* toBoolean */]; });
__webpack_require__.d(__webpack_exports__, "toDate", function() { return /* reexport */ vega_util["bb" /* toDate */]; });
__webpack_require__.d(__webpack_exports__, "toNumber", function() { return /* reexport */ vega_util["cb" /* toNumber */]; });
__webpack_require__.d(__webpack_exports__, "toString", function() { return /* reexport */ vega_util["eb" /* toString */]; });
__webpack_require__.d(__webpack_exports__, "toSet", function() { return /* reexport */ vega_util["db" /* toSet */]; });
__webpack_require__.d(__webpack_exports__, "truncate", function() { return /* reexport */ vega_util["fb" /* truncate */]; });
__webpack_require__.d(__webpack_exports__, "visitArray", function() { return /* reexport */ vega_util["ib" /* visitArray */]; });
__webpack_require__.d(__webpack_exports__, "loader", function() { return /* reexport */ index_browser_loader; });
__webpack_require__.d(__webpack_exports__, "read", function() { return /* reexport */ read; });
__webpack_require__.d(__webpack_exports__, "inferType", function() { return /* reexport */ inferType; });
__webpack_require__.d(__webpack_exports__, "inferTypes", function() { return /* reexport */ inferTypes; });
__webpack_require__.d(__webpack_exports__, "typeParsers", function() { return /* reexport */ typeParsers; });
__webpack_require__.d(__webpack_exports__, "format", function() { return /* reexport */ formats_format; });
__webpack_require__.d(__webpack_exports__, "formats", function() { return /* reexport */ formats_formats; });
__webpack_require__.d(__webpack_exports__, "responseType", function() { return /* reexport */ responseType; });
__webpack_require__.d(__webpack_exports__, "Bounds", function() { return /* reexport */ Bounds; });
__webpack_require__.d(__webpack_exports__, "Gradient", function() { return /* reexport */ Gradient; });
__webpack_require__.d(__webpack_exports__, "GroupItem", function() { return /* reexport */ GroupItem; });
__webpack_require__.d(__webpack_exports__, "ResourceLoader", function() { return /* reexport */ ResourceLoader; });
__webpack_require__.d(__webpack_exports__, "Item", function() { return /* reexport */ Item; });
__webpack_require__.d(__webpack_exports__, "Scenegraph", function() { return /* reexport */ Scenegraph; });
__webpack_require__.d(__webpack_exports__, "Handler", function() { return /* reexport */ Handler_Handler; });
__webpack_require__.d(__webpack_exports__, "Renderer", function() { return /* reexport */ Renderer_Renderer; });
__webpack_require__.d(__webpack_exports__, "CanvasHandler", function() { return /* reexport */ CanvasHandler; });
__webpack_require__.d(__webpack_exports__, "CanvasRenderer", function() { return /* reexport */ CanvasRenderer; });
__webpack_require__.d(__webpack_exports__, "SVGHandler", function() { return /* reexport */ SVGHandler; });
__webpack_require__.d(__webpack_exports__, "SVGRenderer", function() { return /* reexport */ SVGRenderer; });
__webpack_require__.d(__webpack_exports__, "SVGStringRenderer", function() { return /* reexport */ SVGStringRenderer; });
__webpack_require__.d(__webpack_exports__, "RenderType", function() { return /* reexport */ RenderType; });
__webpack_require__.d(__webpack_exports__, "renderModule", function() { return /* reexport */ renderModule; });
__webpack_require__.d(__webpack_exports__, "intersect", function() { return /* reexport */ intersect_intersect; });
__webpack_require__.d(__webpack_exports__, "Marks", function() { return /* reexport */ src_marks; });
__webpack_require__.d(__webpack_exports__, "boundClip", function() { return /* reexport */ boundClip; });
__webpack_require__.d(__webpack_exports__, "boundContext", function() { return /* reexport */ boundContext_context; });
__webpack_require__.d(__webpack_exports__, "boundStroke", function() { return /* reexport */ boundStroke; });
__webpack_require__.d(__webpack_exports__, "boundItem", function() { return /* reexport */ boundItem; });
__webpack_require__.d(__webpack_exports__, "boundMark", function() { return /* reexport */ boundMark; });
__webpack_require__.d(__webpack_exports__, "pathCurves", function() { return /* reexport */ curves; });
__webpack_require__.d(__webpack_exports__, "pathSymbols", function() { return /* reexport */ symbols_symbols; });
__webpack_require__.d(__webpack_exports__, "pathRectangle", function() { return /* reexport */ path_rectangle; });
__webpack_require__.d(__webpack_exports__, "pathTrail", function() { return /* reexport */ path_trail; });
__webpack_require__.d(__webpack_exports__, "pathParse", function() { return /* reexport */ path_parse; });
__webpack_require__.d(__webpack_exports__, "pathRender", function() { return /* reexport */ path_render; });
__webpack_require__.d(__webpack_exports__, "point", function() { return /* reexport */ util_point; });
__webpack_require__.d(__webpack_exports__, "domCreate", function() { return /* reexport */ domCreate; });
__webpack_require__.d(__webpack_exports__, "domFind", function() { return /* reexport */ domFind; });
__webpack_require__.d(__webpack_exports__, "domChild", function() { return /* reexport */ domChild; });
__webpack_require__.d(__webpack_exports__, "domClear", function() { return /* reexport */ domClear; });
__webpack_require__.d(__webpack_exports__, "openTag", function() { return /* reexport */ openTag; });
__webpack_require__.d(__webpack_exports__, "closeTag", function() { return /* reexport */ closeTag; });
__webpack_require__.d(__webpack_exports__, "font", function() { return /* reexport */ text_font; });
__webpack_require__.d(__webpack_exports__, "fontFamily", function() { return /* reexport */ fontFamily; });
__webpack_require__.d(__webpack_exports__, "fontSize", function() { return /* reexport */ text_fontSize; });
__webpack_require__.d(__webpack_exports__, "lineHeight", function() { return /* reexport */ lineHeight; });
__webpack_require__.d(__webpack_exports__, "multiLineOffset", function() { return /* reexport */ multiLineOffset; });
__webpack_require__.d(__webpack_exports__, "textMetrics", function() { return /* reexport */ textMetrics; });
__webpack_require__.d(__webpack_exports__, "sceneEqual", function() { return /* reexport */ sceneEqual; });
__webpack_require__.d(__webpack_exports__, "pathEqual", function() { return /* reexport */ pathEqual; });
__webpack_require__.d(__webpack_exports__, "sceneToJSON", function() { return /* reexport */ sceneToJSON; });
__webpack_require__.d(__webpack_exports__, "sceneFromJSON", function() { return /* reexport */ sceneFromJSON; });
__webpack_require__.d(__webpack_exports__, "intersectPath", function() { return /* reexport */ intersectPath; });
__webpack_require__.d(__webpack_exports__, "intersectPoint", function() { return /* reexport */ intersectPoint; });
__webpack_require__.d(__webpack_exports__, "intersectRule", function() { return /* reexport */ intersectRule; });
__webpack_require__.d(__webpack_exports__, "intersectBoxLine", function() { return /* reexport */ intersectBoxLine; });
__webpack_require__.d(__webpack_exports__, "sceneZOrder", function() { return /* reexport */ zorder; });
__webpack_require__.d(__webpack_exports__, "sceneVisit", function() { return /* reexport */ visit_visit; });
__webpack_require__.d(__webpack_exports__, "scenePickVisit", function() { return /* reexport */ pickVisit; });
__webpack_require__.d(__webpack_exports__, "resetSVGClipId", function() { return /* reexport */ resetSVGClipId; });
__webpack_require__.d(__webpack_exports__, "resetSVGDefIds", function() { return /* reexport */ resetSVGDefIds; });
__webpack_require__.d(__webpack_exports__, "Dataflow", function() { return /* reexport */ Dataflow; });
__webpack_require__.d(__webpack_exports__, "EventStream", function() { return /* reexport */ EventStream; });
__webpack_require__.d(__webpack_exports__, "Parameters", function() { return /* reexport */ Parameters; });
__webpack_require__.d(__webpack_exports__, "Pulse", function() { return /* reexport */ Pulse; });
__webpack_require__.d(__webpack_exports__, "MultiPulse", function() { return /* reexport */ MultiPulse; });
__webpack_require__.d(__webpack_exports__, "Operator", function() { return /* reexport */ Operator; });
__webpack_require__.d(__webpack_exports__, "Transform", function() { return /* reexport */ Transform; });
__webpack_require__.d(__webpack_exports__, "changeset", function() { return /* reexport */ ChangeSet_changeset; });
__webpack_require__.d(__webpack_exports__, "ingest", function() { return /* reexport */ ingest; });
__webpack_require__.d(__webpack_exports__, "isTuple", function() { return /* reexport */ isTuple; });
__webpack_require__.d(__webpack_exports__, "definition", function() { return /* reexport */ register_definition; });
__webpack_require__.d(__webpack_exports__, "transform", function() { return /* reexport */ register_transform; });
__webpack_require__.d(__webpack_exports__, "transforms", function() { return /* reexport */ register_transforms; });
__webpack_require__.d(__webpack_exports__, "tupleid", function() { return /* reexport */ tupleid; });
__webpack_require__.d(__webpack_exports__, "scale", function() { return /* reexport */ scales_scale; });
__webpack_require__.d(__webpack_exports__, "scheme", function() { return /* reexport */ schemes_scheme; });
__webpack_require__.d(__webpack_exports__, "interpolate", function() { return /* reexport */ interpolate_interpolate; });
__webpack_require__.d(__webpack_exports__, "interpolateColors", function() { return /* reexport */ interpolateColors; });
__webpack_require__.d(__webpack_exports__, "interpolateRange", function() { return /* reexport */ interpolateRange; });
__webpack_require__.d(__webpack_exports__, "quantizeInterpolator", function() { return /* reexport */ quantizeInterpolator; });
__webpack_require__.d(__webpack_exports__, "projection", function() { return /* reexport */ projections_projection; });
__webpack_require__.d(__webpack_exports__, "View", function() { return /* reexport */ View; });
__webpack_require__.d(__webpack_exports__, "formatLocale", function() { return /* reexport */ numberFormatDefaultLocale; });
__webpack_require__.d(__webpack_exports__, "timeFormatLocale", function() { return /* reexport */ timeFormatDefaultLocale; });
__webpack_require__.d(__webpack_exports__, "locale", function() { return /* reexport */ locale_locale; });
__webpack_require__.d(__webpack_exports__, "defaultLocale", function() { return /* reexport */ locale_defaultLocale; });
__webpack_require__.d(__webpack_exports__, "resetDefaultLocale", function() { return /* reexport */ resetDefaultLocale; });
__webpack_require__.d(__webpack_exports__, "expressionFunction", function() { return /* reexport */ expressionFunction; });
__webpack_require__.d(__webpack_exports__, "parse", function() { return /* reexport */ src_parse; });
__webpack_require__.d(__webpack_exports__, "runtimeContext", function() { return /* reexport */ src_context; });

// NAMESPACE OBJECT: ./node_modules/vega-transforms/index.js
var vega_transforms_namespaceObject = {};
__webpack_require__.r(vega_transforms_namespaceObject);
__webpack_require__.d(vega_transforms_namespaceObject, "aggregate", function() { return Aggregate; });
__webpack_require__.d(vega_transforms_namespaceObject, "bin", function() { return Bin; });
__webpack_require__.d(vega_transforms_namespaceObject, "collect", function() { return Collect; });
__webpack_require__.d(vega_transforms_namespaceObject, "compare", function() { return Compare; });
__webpack_require__.d(vega_transforms_namespaceObject, "countpattern", function() { return CountPattern; });
__webpack_require__.d(vega_transforms_namespaceObject, "cross", function() { return Cross; });
__webpack_require__.d(vega_transforms_namespaceObject, "density", function() { return Density; });
__webpack_require__.d(vega_transforms_namespaceObject, "dotbin", function() { return DotBin; });
__webpack_require__.d(vega_transforms_namespaceObject, "expression", function() { return Expression; });
__webpack_require__.d(vega_transforms_namespaceObject, "extent", function() { return Extent; });
__webpack_require__.d(vega_transforms_namespaceObject, "facet", function() { return Facet; });
__webpack_require__.d(vega_transforms_namespaceObject, "field", function() { return Field; });
__webpack_require__.d(vega_transforms_namespaceObject, "filter", function() { return Filter; });
__webpack_require__.d(vega_transforms_namespaceObject, "flatten", function() { return Flatten; });
__webpack_require__.d(vega_transforms_namespaceObject, "fold", function() { return Fold; });
__webpack_require__.d(vega_transforms_namespaceObject, "formula", function() { return Formula; });
__webpack_require__.d(vega_transforms_namespaceObject, "generate", function() { return Generate; });
__webpack_require__.d(vega_transforms_namespaceObject, "impute", function() { return Impute; });
__webpack_require__.d(vega_transforms_namespaceObject, "joinaggregate", function() { return JoinAggregate; });
__webpack_require__.d(vega_transforms_namespaceObject, "kde", function() { return KDE; });
__webpack_require__.d(vega_transforms_namespaceObject, "key", function() { return Key; });
__webpack_require__.d(vega_transforms_namespaceObject, "load", function() { return Load; });
__webpack_require__.d(vega_transforms_namespaceObject, "lookup", function() { return Lookup; });
__webpack_require__.d(vega_transforms_namespaceObject, "multiextent", function() { return MultiExtent; });
__webpack_require__.d(vega_transforms_namespaceObject, "multivalues", function() { return MultiValues; });
__webpack_require__.d(vega_transforms_namespaceObject, "params", function() { return Params; });
__webpack_require__.d(vega_transforms_namespaceObject, "pivot", function() { return Pivot; });
__webpack_require__.d(vega_transforms_namespaceObject, "prefacet", function() { return PreFacet; });
__webpack_require__.d(vega_transforms_namespaceObject, "project", function() { return Project; });
__webpack_require__.d(vega_transforms_namespaceObject, "proxy", function() { return Proxy; });
__webpack_require__.d(vega_transforms_namespaceObject, "quantile", function() { return Quantile; });
__webpack_require__.d(vega_transforms_namespaceObject, "relay", function() { return Relay; });
__webpack_require__.d(vega_transforms_namespaceObject, "sample", function() { return Sample; });
__webpack_require__.d(vega_transforms_namespaceObject, "sequence", function() { return Sequence; });
__webpack_require__.d(vega_transforms_namespaceObject, "sieve", function() { return Sieve; });
__webpack_require__.d(vega_transforms_namespaceObject, "subflow", function() { return Subflow; });
__webpack_require__.d(vega_transforms_namespaceObject, "timeunit", function() { return TimeUnit; });
__webpack_require__.d(vega_transforms_namespaceObject, "tupleindex", function() { return TupleIndex; });
__webpack_require__.d(vega_transforms_namespaceObject, "values", function() { return Values; });
__webpack_require__.d(vega_transforms_namespaceObject, "window", function() { return Window; });

// NAMESPACE OBJECT: ./node_modules/d3-interpolate/src/index.js
var d3_interpolate_src_namespaceObject = {};
__webpack_require__.r(d3_interpolate_src_namespaceObject);
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolate", function() { return src_value; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateArray", function() { return src_array; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateBasis", function() { return src_basis; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateBasisClosed", function() { return src_basisClosed; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateDate", function() { return src_date; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateDiscrete", function() { return discrete; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateHue", function() { return src_hue; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateNumber", function() { return d3_interpolate_src_number; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateNumberArray", function() { return numberArray; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateObject", function() { return src_object; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateRound", function() { return src_round; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateString", function() { return src_string; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateTransformCss", function() { return interpolateTransformCss; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateTransformSvg", function() { return interpolateTransformSvg; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateZoom", function() { return zoom; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateRgb", function() { return src_rgb; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateRgbBasis", function() { return rgbBasis; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateRgbBasisClosed", function() { return rgbBasisClosed; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateHsl", function() { return src_hsl; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateHslLong", function() { return hslLong; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateLab", function() { return lab_lab; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateHcl", function() { return src_hcl; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateHclLong", function() { return hclLong; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateCubehelix", function() { return src_cubehelix; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "interpolateCubehelixLong", function() { return cubehelixLong; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "piecewise", function() { return piecewise_piecewise; });
__webpack_require__.d(d3_interpolate_src_namespaceObject, "quantize", function() { return src_quantize; });

// NAMESPACE OBJECT: ./node_modules/vega-view-transforms/index.js
var vega_view_transforms_namespaceObject = {};
__webpack_require__.r(vega_view_transforms_namespaceObject);
__webpack_require__.d(vega_view_transforms_namespaceObject, "bound", function() { return Bound; });
__webpack_require__.d(vega_view_transforms_namespaceObject, "identifier", function() { return Identifier; });
__webpack_require__.d(vega_view_transforms_namespaceObject, "mark", function() { return Mark; });
__webpack_require__.d(vega_view_transforms_namespaceObject, "overlap", function() { return Overlap; });
__webpack_require__.d(vega_view_transforms_namespaceObject, "render", function() { return Render; });
__webpack_require__.d(vega_view_transforms_namespaceObject, "viewlayout", function() { return ViewLayout; });

// NAMESPACE OBJECT: ./node_modules/vega-encode/index.js
var vega_encode_namespaceObject = {};
__webpack_require__.r(vega_encode_namespaceObject);
__webpack_require__.d(vega_encode_namespaceObject, "axisticks", function() { return AxisTicks; });
__webpack_require__.d(vega_encode_namespaceObject, "datajoin", function() { return DataJoin; });
__webpack_require__.d(vega_encode_namespaceObject, "encode", function() { return Encode; });
__webpack_require__.d(vega_encode_namespaceObject, "legendentries", function() { return LegendEntries; });
__webpack_require__.d(vega_encode_namespaceObject, "linkpath", function() { return LinkPath; });
__webpack_require__.d(vega_encode_namespaceObject, "pie", function() { return Pie; });
__webpack_require__.d(vega_encode_namespaceObject, "scale", function() { return Scale; });
__webpack_require__.d(vega_encode_namespaceObject, "sortitems", function() { return SortItems; });
__webpack_require__.d(vega_encode_namespaceObject, "stack", function() { return Stack; });

// NAMESPACE OBJECT: ./node_modules/vega-geo/index.js
var vega_geo_namespaceObject = {};
__webpack_require__.r(vega_geo_namespaceObject);
__webpack_require__.d(vega_geo_namespaceObject, "contour", function() { return Contour; });
__webpack_require__.d(vega_geo_namespaceObject, "geojson", function() { return GeoJSON; });
__webpack_require__.d(vega_geo_namespaceObject, "geopath", function() { return GeoPath; });
__webpack_require__.d(vega_geo_namespaceObject, "geopoint", function() { return GeoPoint; });
__webpack_require__.d(vega_geo_namespaceObject, "geoshape", function() { return GeoShape; });
__webpack_require__.d(vega_geo_namespaceObject, "graticule", function() { return Graticule; });
__webpack_require__.d(vega_geo_namespaceObject, "heatmap", function() { return Heatmap; });
__webpack_require__.d(vega_geo_namespaceObject, "isocontour", function() { return Isocontour; });
__webpack_require__.d(vega_geo_namespaceObject, "kde2d", function() { return KDE2D; });
__webpack_require__.d(vega_geo_namespaceObject, "projection", function() { return Projection; });

// NAMESPACE OBJECT: ./node_modules/vega-force/index.js
var vega_force_namespaceObject = {};
__webpack_require__.r(vega_force_namespaceObject);
__webpack_require__.d(vega_force_namespaceObject, "force", function() { return Force; });

// NAMESPACE OBJECT: ./node_modules/vega-hierarchy/index.js
var vega_hierarchy_namespaceObject = {};
__webpack_require__.r(vega_hierarchy_namespaceObject);
__webpack_require__.d(vega_hierarchy_namespaceObject, "nest", function() { return Nest; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "pack", function() { return Pack; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "partition", function() { return Partition; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "stratify", function() { return Stratify; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "tree", function() { return Tree; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "treelinks", function() { return TreeLinks; });
__webpack_require__.d(vega_hierarchy_namespaceObject, "treemap", function() { return Treemap; });

// NAMESPACE OBJECT: ./node_modules/vega-regression/index.js
var vega_regression_namespaceObject = {};
__webpack_require__.r(vega_regression_namespaceObject);
__webpack_require__.d(vega_regression_namespaceObject, "loess", function() { return Loess; });
__webpack_require__.d(vega_regression_namespaceObject, "regression", function() { return Regression; });

// NAMESPACE OBJECT: ./node_modules/vega-voronoi/index.js
var vega_voronoi_namespaceObject = {};
__webpack_require__.r(vega_voronoi_namespaceObject);
__webpack_require__.d(vega_voronoi_namespaceObject, "voronoi", function() { return Voronoi_Voronoi; });

// NAMESPACE OBJECT: ./node_modules/vega-wordcloud/index.js
var vega_wordcloud_namespaceObject = {};
__webpack_require__.r(vega_wordcloud_namespaceObject);
__webpack_require__.d(vega_wordcloud_namespaceObject, "wordcloud", function() { return Wordcloud; });

// NAMESPACE OBJECT: ./node_modules/vega-crossfilter/index.js
var vega_crossfilter_namespaceObject = {};
__webpack_require__.r(vega_crossfilter_namespaceObject);
__webpack_require__.d(vega_crossfilter_namespaceObject, "crossfilter", function() { return CrossFilter; });
__webpack_require__.d(vega_crossfilter_namespaceObject, "resolvefilter", function() { return ResolveFilter; });

// EXTERNAL MODULE: ./node_modules/vega-util/index.js + 47 modules
var vega_util = __webpack_require__("J29t");

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/util/UniqueList.js


function UniqueList(idFunc) {
  var $ = idFunc || vega_util["x" /* identity */],
      list = [],
      ids = {};

  list.add = function(_) {
    var id = $(_);
    if (!ids[id]) {
      ids[id] = 1;
      list.push(_);
    }
    return list;
  };

  list.remove = function(_) {
    var id = $(_), idx;
    if (ids[id]) {
      ids[id] = 0;
      if ((idx = list.indexOf(_)) >= 0) {
        list.splice(idx, 1);
      }
    }
    return list;
  };

  return list;
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/util/asyncCallback.js
/**
 * Invoke and await a potentially async callback function. If
 * an error occurs, trap it and route to Dataflow.error.
 * @param {Dataflow} df - The dataflow instance
 * @param {function} callback - A callback function to invoke
 *   and then await. The dataflow will be passed as the single
 *   argument to the function.
 */
/* harmony default export */ var asyncCallback = (async function(df, callback) {
  try { await callback(df); } catch (err) { df.error(err); }
});

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/Tuple.js
var TUPLE_ID_KEY = Symbol('vega_id'),
    TUPLE_ID = 1;

/**
 * Resets the internal tuple id counter to one.
 */
function Tuple_reset() {
  TUPLE_ID = 1;
}

/**
 * Checks if an input value is a registered tuple.
 * @param {*} t - The value to check.
 * @return {boolean} True if the input is a tuple, false otherwise.
 */
function isTuple(t) {
  return !!(t && tupleid(t));
}

/**
 * Returns the id of a tuple.
 * @param {object} t - The input tuple.
 * @return {*} the tuple id.
 */
function tupleid(t) {
  return t[TUPLE_ID_KEY];
}

/**
 * Sets the id of a tuple.
 * @param {object} t - The input tuple.
 * @param {*} id - The id value to set.
 * @return {object} the input tuple.
 */
function setid(t, id) {
  t[TUPLE_ID_KEY] = id;
  return t;
}

/**
 * Ingest an object or value as a data tuple.
 * If the input value is an object, an id field will be added to it. For
 * efficiency, the input object is modified directly. A copy is not made.
 * If the input value is a literal, it will be wrapped in a new object
 * instance, with the value accessible as the 'data' property.
 * @param datum - The value to ingest.
 * @return {object} The ingested data tuple.
 */
function ingest(datum) {
  var t = (datum === Object(datum)) ? datum : {data: datum};
  return tupleid(t) ? t : setid(t, TUPLE_ID++);
}

/**
 * Given a source tuple, return a derived copy.
 * @param {object} t - The source tuple.
 * @return {object} The derived tuple.
 */
function Tuple_derive(t) {
  return rederive(t, ingest({}));
}

/**
 * Rederive a derived tuple by copying values from the source tuple.
 * @param {object} t - The source tuple.
 * @param {object} d - The derived tuple.
 * @return {object} The derived tuple.
 */
function rederive(t, d) {
  for (var k in t) d[k] = t[k];
  return d;
}

/**
 * Replace an existing tuple with a new tuple.
 * @param {object} t - The existing data tuple.
 * @param {object} d - The new tuple that replaces the old.
 * @return {object} The new tuple.
 */
function replace(t, d) {
  return setid(d, tupleid(t));
}

/**
 * Generate an augmented comparator function that provides stable
 * sorting by tuple id when the given comparator produces ties.
 * @param {function} cmp - The comparator to augment.
 * @param {function} [f] - Optional tuple accessor function.
 * @return {function} An augmented comparator function.
 */
function stableCompare(cmp, f) {
  return !cmp ? null
    : f ? (a, b) => cmp(a, b) || (tupleid(f(a)) - tupleid(f(b)))
    : (a, b) => cmp(a, b) || (tupleid(a) - tupleid(b));
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/ChangeSet.js



function isChangeSet(v) {
  return v && v.constructor === ChangeSet_changeset;
}

function ChangeSet_changeset() {
  var add = [],  // insert tuples
      rem = [],  // remove tuples
      mod = [],  // modify tuples
      remp = [], // remove by predicate
      modp = [], // modify by predicate
      clean = null,
      reflow = false;

  return {
    constructor: ChangeSet_changeset,
    insert: function(t) {
      var d = Object(vega_util["i" /* array */])(t), i = 0, n = d.length;
      for (; i<n; ++i) add.push(d[i]);
      return this;
    },
    remove: function(t) {
      var a = Object(vega_util["D" /* isFunction */])(t) ? remp : rem,
          d = Object(vega_util["i" /* array */])(t), i = 0, n = d.length;
      for (; i<n; ++i) a.push(d[i]);
      return this;
    },
    modify: function(t, field, value) {
      var m = {field: field, value: Object(vega_util["l" /* constant */])(value)};
      if (Object(vega_util["D" /* isFunction */])(t)) {
        m.filter = t;
        modp.push(m);
      } else {
        m.tuple = t;
        mod.push(m);
      }
      return this;
    },
    encode: function(t, set) {
      if (Object(vega_util["D" /* isFunction */])(t)) modp.push({filter: t, field: set});
      else mod.push({tuple: t, field: set});
      return this;
    },
    clean: function(value) {
      clean = value;
      return this;
    },
    reflow: function() {
      reflow = true;
      return this;
    },
    pulse: function(pulse, tuples) {
      var cur = {}, out = {}, i, n, m, f, t, id;

      // build lookup table of current tuples
      for (i=0, n=tuples.length; i<n; ++i) {
        cur[tupleid(tuples[i])] = 1;
      }

      // process individual tuples to remove
      for (i=0, n=rem.length; i<n; ++i) {
        t = rem[i];
        cur[tupleid(t)] = -1;
      }

      // process predicate-based removals
      for (i=0, n=remp.length; i<n; ++i) {
        f = remp[i];
        tuples.forEach(function(t) {
          if (f(t)) cur[tupleid(t)] = -1;
        });
      }

      // process all add tuples
      for (i=0, n=add.length; i<n; ++i) {
        t = add[i];
        id = tupleid(t);
        if (cur[id]) {
          // tuple already resides in dataset
          // if flagged for both add and remove, cancel
          cur[id] = 1;
        } else {
          // tuple does not reside in dataset, add
          pulse.add.push(ingest(add[i]));
        }
      }

      // populate pulse rem list
      for (i=0, n=tuples.length; i<n; ++i) {
        t = tuples[i];
        if (cur[tupleid(t)] < 0) pulse.rem.push(t);
      }

      // modify helper method
      function modify(t, f, v) {
        if (v) {
          t[f] = v(t);
        } else {
          pulse.encode = f;
        }
        if (!reflow) out[tupleid(t)] = t;
      }

      // process individual tuples to modify
      for (i=0, n=mod.length; i<n; ++i) {
        m = mod[i];
        t = m.tuple;
        f = m.field;
        id = cur[tupleid(t)];
        if (id > 0) {
          modify(t, f, m.value);
          pulse.modifies(f);
        }
      }

      // process predicate-based modifications
      for (i=0, n=modp.length; i<n; ++i) {
        m = modp[i];
        f = m.filter;
        tuples.forEach(function(t) {
          if (f(t) && cur[tupleid(t)] > 0) {
            modify(t, m.field, m.value);
          }
        });
        pulse.modifies(m.field);
      }

      // upon reflow request, populate mod with all non-removed tuples
      // otherwise, populate mod with modified tuples only
      if (reflow) {
        pulse.mod = rem.length || remp.length
          ? tuples.filter(function(t) { return cur[tupleid(t)] > 0; })
          : tuples.slice();
      } else {
        for (id in out) pulse.mod.push(out[id]);
      }

      // set pulse garbage collection request
      if (clean || clean == null && (rem.length || remp.length)) {
        pulse.clean(true);
      }

      return pulse;
    }
  };
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/Parameters.js


var CACHE = '_:mod:_';

/**
 * Hash that tracks modifications to assigned values.
 * Callers *must* use the set method to update values.
 */
function Parameters() {
  Object.defineProperty(this, CACHE, {writable: true, value: {}});
}

var Parameters_prototype = Parameters.prototype;

/**
 * Set a parameter value. If the parameter value changes, the parameter
 * will be recorded as modified.
 * @param {string} name - The parameter name.
 * @param {number} index - The index into an array-value parameter. Ignored if
 *   the argument is undefined, null or less than zero.
 * @param {*} value - The parameter value to set.
 * @param {boolean} [force=false] - If true, records the parameter as modified
 *   even if the value is unchanged.
 * @return {Parameters} - This parameter object.
 */
Parameters_prototype.set = function(name, index, value, force) {
  var o = this,
      v = o[name],
      mod = o[CACHE];

  if (index != null && index >= 0) {
    if (v[index] !== value || force) {
      v[index] = value;
      mod[index + ':' + name] = -1;
      mod[name] = -1;
    }
  } else if (v !== value || force) {
    o[name] = value;
    mod[name] = Object(vega_util["A" /* isArray */])(value) ? 1 + value.length : -1;
  }

  return o;
};

/**
 * Tests if one or more parameters has been modified. If invoked with no
 * arguments, returns true if any parameter value has changed. If the first
 * argument is array, returns trues if any parameter name in the array has
 * changed. Otherwise, tests if the given name and optional array index has
 * changed.
 * @param {string} name - The parameter name to test.
 * @param {number} [index=undefined] - The parameter array index to test.
 * @return {boolean} - Returns true if a queried parameter was modified.
 */
Parameters_prototype.modified = function(name, index) {
  var mod = this[CACHE], k;
  if (!arguments.length) {
    for (k in mod) { if (mod[k]) return true; }
    return false;
  } else if (Object(vega_util["A" /* isArray */])(name)) {
    for (k=0; k<name.length; ++k) {
      if (mod[name[k]]) return true;
    }
    return false;
  }
  return (index != null && index >= 0)
    ? (index + 1 < mod[name] || !!mod[index + ':' + name])
    : !!mod[name];
};

/**
 * Clears the modification records. After calling this method,
 * all parameters are considered unmodified.
 */
Parameters_prototype.clear = function() {
  this[CACHE] = {};
  return this;
};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/Operator.js




var OP_ID = 0;
var PULSE = 'pulse';
var NO_PARAMS = new Parameters();

// Boolean Flags
var SKIP     = 1,
    MODIFIED = 2;

/**
 * An Operator is a processing node in a dataflow graph.
 * Each operator stores a value and an optional value update function.
 * Operators can accept a hash of named parameters. Parameter values can
 * either be direct (JavaScript literals, arrays, objects) or indirect
 * (other operators whose values will be pulled dynamically). Operators
 * included as parameters will have this operator added as a dependency.
 * @constructor
 * @param {*} [init] - The initial value for this operator.
 * @param {function(object, Pulse)} [update] - An update function. Upon
 *   evaluation of this operator, the update function will be invoked and the
 *   return value will be used as the new value of this operator.
 * @param {object} [params] - The parameters for this operator.
 * @param {boolean} [react=true] - Flag indicating if this operator should
 *   listen for changes to upstream operators included as parameters.
 * @see parameters
 */
function Operator(init, update, params, react) {
  this.id = ++OP_ID;
  this.value = init;
  this.stamp = -1;
  this.rank = -1;
  this.qrank = -1;
  this.flags = 0;

  if (update) {
    this._update = update;
  }
  if (params) this.parameters(params, react);
}

var Operator_prototype = Operator.prototype;

/**
 * Returns a list of target operators dependent on this operator.
 * If this list does not exist, it is created and then returned.
 * @return {UniqueList}
 */
Operator_prototype.targets = function() {
  return this._targets || (this._targets = UniqueList(vega_util["w" /* id */]));
};

/**
 * Sets the value of this operator.
 * @param {*} value - the value to set.
 * @return {Number} Returns 1 if the operator value has changed
 *   according to strict equality, returns 0 otherwise.
 */
Operator_prototype.set = function(value) {
  if (this.value !== value) {
    this.value = value;
    return 1;
  } else {
    return 0;
  }
};

function Operator_flag(bit) {
  return function(state) {
    var f = this.flags;
    if (arguments.length === 0) return !!(f & bit);
    this.flags = state ? (f | bit) : (f & ~bit);
    return this;
  };
}

/**
 * Indicates that operator evaluation should be skipped on the next pulse.
 * This operator will still propagate incoming pulses, but its update function
 * will not be invoked. The skip flag is reset after every pulse, so calling
 * this method will affect processing of the next pulse only.
 */
Operator_prototype.skip = Operator_flag(SKIP);

/**
 * Indicates that this operator's value has been modified on its most recent
 * pulse. Normally modification is checked via strict equality; however, in
 * some cases it is more efficient to update the internal state of an object.
 * In those cases, the modified flag can be used to trigger propagation. Once
 * set, the modification flag persists across pulses until unset. The flag can
 * be used with the last timestamp to test if a modification is recent.
 */
Operator_prototype.modified = Operator_flag(MODIFIED);

/**
 * Sets the parameters for this operator. The parameter values are analyzed for
 * operator instances. If found, this operator will be added as a dependency
 * of the parameterizing operator. Operator values are dynamically marshalled
 * from each operator parameter prior to evaluation. If a parameter value is
 * an array, the array will also be searched for Operator instances. However,
 * the search does not recurse into sub-arrays or object properties.
 * @param {object} params - A hash of operator parameters.
 * @param {boolean} [react=true] - A flag indicating if this operator should
 *   automatically update (react) when parameter values change. In other words,
 *   this flag determines if the operator registers itself as a listener on
 *   any upstream operators included in the parameters.
 * @param {boolean} [initonly=false] - A flag indicating if this operator
 *   should calculate an update only upon its initiatal evaluation, then
 *   deregister dependencies and suppress all future update invocations.
 * @return {Operator[]} - An array of upstream dependencies.
 */
Operator_prototype.parameters = function(params, react, initonly) {
  react = react !== false;
  var self = this,
      argval = (self._argval = self._argval || new Parameters()),
      argops = (self._argops = self._argops || []),
      deps = [],
      name, value, n, i;

  function add(name, index, value) {
    if (value instanceof Operator) {
      if (value !== self) {
        if (react) value.targets().add(self);
        deps.push(value);
      }
      argops.push({op:value, name:name, index:index});
    } else {
      argval.set(name, index, value);
    }
  }

  for (name in params) {
    value = params[name];

    if (name === PULSE) {
      Object(vega_util["i" /* array */])(value).forEach(function(op) {
        if (!(op instanceof Operator)) {
          Object(vega_util["n" /* error */])('Pulse parameters must be operator instances.');
        } else if (op !== self) {
          op.targets().add(self);
          deps.push(op);
        }
      });
      self.source = value;
    } else if (Object(vega_util["A" /* isArray */])(value)) {
      argval.set(name, -1, Array(n = value.length));
      for (i=0; i<n; ++i) add(name, i, value[i]);
    } else {
      add(name, -1, value);
    }
  }

  this.marshall().clear(); // initialize values
  if (initonly) argops.initonly = true;

  return deps;
};

/**
 * Internal method for marshalling parameter values.
 * Visits each operator dependency to pull the latest value.
 * @return {Parameters} A Parameters object to pass to the update function.
 */
Operator_prototype.marshall = function(stamp) {
  var argval = this._argval || NO_PARAMS,
      argops = this._argops, item, i, n, op, mod;

  if (argops) {
    for (i=0, n=argops.length; i<n; ++i) {
      item = argops[i];
      op = item.op;
      mod = op.modified() && op.stamp === stamp;
      argval.set(item.name, item.index, op.value, mod);
    }

    if (argops.initonly) {
      for (i=0; i<n; ++i) {
        item = argops[i];
        item.op.targets().remove(this);
      }
      this._argops = null;
      this._update = null;
    }
  }
  return argval;
};

/**
 * Detach this operator from the dataflow.
 * Unregisters listeners on upstream dependencies.
 */
Operator_prototype.detach = function() {
  var argops = this._argops,
      i, n, item, op;

  if (argops) {
    for (i=0, n=argops.length; i<n; ++i) {
      item = argops[i];
      op = item.op;
      if (op._targets) {
        op._targets.remove(this);
      }
    }
  }
};

/**
 * Delegate method to perform operator processing.
 * Subclasses can override this method to perform custom processing.
 * By default, it marshalls parameters and calls the update function
 * if that function is defined. If the update function does not
 * change the operator value then StopPropagation is returned.
 * If no update function is defined, this method does nothing.
 * @param {Pulse} pulse - the current dataflow pulse.
 * @return The output pulse or StopPropagation. A falsy return value
 *   (including undefined) will let the input pulse pass through.
 */
Operator_prototype.evaluate = function(pulse) {
  var update = this._update;
  if (update) {
    var params = this.marshall(pulse.stamp),
        v = update.call(this, params, pulse);

    params.clear();
    if (v !== this.value) {
      this.value = v;
    } else if (!this.modified()) {
      return pulse.StopPropagation;
    }
  }
};

/**
 * Run this operator for the current pulse. If this operator has already
 * been run at (or after) the pulse timestamp, returns StopPropagation.
 * Internally, this method calls {@link evaluate} to perform processing.
 * If {@link evaluate} returns a falsy value, the input pulse is returned.
 * This method should NOT be overridden, instead overrride {@link evaluate}.
 * @param {Pulse} pulse - the current dataflow pulse.
 * @return the output pulse for this operator (or StopPropagation)
 */
Operator_prototype.run = function(pulse) {
  if (pulse.stamp < this.stamp) return pulse.StopPropagation;
  var rv;
  if (this.skip()) {
    this.skip(false);
    rv = 0;
  } else {
    rv = this.evaluate(pulse);
  }
  return (this.pulse = rv || pulse);
};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/add.js



/**
 * Add an operator to the dataflow graph. This function accepts a
 * variety of input argument types. The basic signature supports an
 * initial value, update function and parameters. If the first parameter
 * is an Operator instance, it will be added directly. If it is a
 * constructor for an Operator subclass, a new instance will be instantiated.
 * Otherwise, if the first parameter is a function instance, it will be used
 * as the update function and a null initial value is assumed.
 * @param {*} init - One of: the operator to add, the initial value of
 *   the operator, an operator class to instantiate, or an update function.
 * @param {function} [update] - The operator update function.
 * @param {object} [params] - The operator parameters.
 * @param {boolean} [react=true] - Flag indicating if this operator should
 *   listen for changes to upstream operators included as parameters.
 * @return {Operator} - The added operator.
 */
/* harmony default export */ var dataflow_add = (function(init, update, params, react) {
  var shift = 1,
    op;

  if (init instanceof Operator) {
    op = init;
  } else if (init && init.prototype instanceof Operator) {
    op = new init();
  } else if (Object(vega_util["D" /* isFunction */])(init)) {
    op = new Operator(null, init);
  } else {
    shift = 0;
    op = new Operator(init, update);
  }

  this.rank(op);
  if (shift) {
    react = params;
    params = update;
  }
  if (params) this.connect(op, op.parameters(params, react));
  this.touch(op);

  return op;
});

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/connect.js
/**
 * Connect a target operator as a dependent of source operators.
 * If necessary, this method will rerank the target operator and its
 * dependents to ensure propagation proceeds in a topologically sorted order.
 * @param {Operator} target - The target operator.
 * @param {Array<Operator>} - The source operators that should propagate
 *   to the target operator.
 */
/* harmony default export */ var connect = (function(target, sources) {
  var targetRank = target.rank, i, n;

  for (i=0, n=sources.length; i<n; ++i) {
    if (targetRank < sources[i].rank) {
      this.rerank(target);
      return;
    }
  }
});

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/EventStream.js



var STREAM_ID = 0;

/**
 * Models an event stream.
 * @constructor
 * @param {function(Object, number): boolean} [filter] - Filter predicate.
 *   Events pass through when truthy, events are suppressed when falsy.
 * @param {function(Object): *} [apply] - Applied to input events to produce
 *   new event values.
 * @param {function(Object)} [receive] - Event callback function to invoke
 *   upon receipt of a new event. Use to override standard event processing.
 */
function EventStream(filter, apply, receive) {
  this.id = ++STREAM_ID;
  this.value = null;
  if (receive) this.receive = receive;
  if (filter) this._filter = filter;
  if (apply) this._apply = apply;
}

/**
 * Creates a new event stream instance with the provided
 * (optional) filter, apply and receive functions.
 * @param {function(Object, number): boolean} [filter] - Filter predicate.
 *   Events pass through when truthy, events are suppressed when falsy.
 * @param {function(Object): *} [apply] - Applied to input events to produce
 *   new event values.
 * @see EventStream
 */
function EventStream_stream(filter, apply, receive) {
  return new EventStream(filter, apply, receive);
}

var EventStream_prototype = EventStream.prototype;

EventStream_prototype._filter = vega_util["gb" /* truthy */];

EventStream_prototype._apply = vega_util["x" /* identity */];

EventStream_prototype.targets = function() {
  return this._targets || (this._targets = UniqueList(vega_util["w" /* id */]));
};

EventStream_prototype.consume = function(_) {
  if (!arguments.length) return !!this._consume;
  this._consume = !!_;
  return this;
};

EventStream_prototype.receive = function(evt) {
  if (this._filter(evt)) {
    var val = (this.value = this._apply(evt)),
        trg = this._targets,
        n = trg ? trg.length : 0,
        i = 0;

    for (; i<n; ++i) trg[i].receive(val);

    if (this._consume) {
      evt.preventDefault();
      evt.stopPropagation();
    }
  }
};

EventStream_prototype.filter = function(filter) {
  var s = EventStream_stream(filter);
  this.targets().add(s);
  return s;
};

EventStream_prototype.apply = function(apply) {
  var s = EventStream_stream(null, apply);
  this.targets().add(s);
  return s;
};

EventStream_prototype.merge = function() {
  var s = EventStream_stream();

  this.targets().add(s);
  for (var i=0, n=arguments.length; i<n; ++i) {
    arguments[i].targets().add(s);
  }

  return s;
};

EventStream_prototype.throttle = function(pause) {
  var t = -1;
  return this.filter(function() {
    var now = Date.now();
    if ((now - t) > pause) {
      t = now;
      return 1;
    } else {
      return 0;
    }
  });
};

EventStream_prototype.debounce = function(delay) {
  var s = EventStream_stream();

  this.targets().add(EventStream_stream(null, null,
    Object(vega_util["m" /* debounce */])(delay, function(e) {
      var df = e.dataflow;
      s.receive(e);
      if (df && df.run) df.run();
    })
  ));

  return s;
};

EventStream_prototype.between = function(a, b) {
  var active = false;
  a.targets().add(EventStream_stream(null, null, function() { active = true; }));
  b.targets().add(EventStream_stream(null, null, function() { active = false; }));
  return this.filter(function() { return active; });
};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/events.js



/**
 * Create a new event stream from an event source.
 * @param {object} source - The event source to monitor. The input must
 *  support the addEventListener method.
 * @param {string} type - The event type.
 * @param {function(object): boolean} [filter] - Event filter function.
 * @param {function(object): *} [apply] - Event application function.
 *   If provided, this function will be invoked and the result will be
 *   used as the downstream event value.
 * @return {EventStream}
 */
/* harmony default export */ var dataflow_events = (function(source, type, filter, apply) {
  var df = this,
      s = EventStream_stream(filter, apply),
      send = function(e) {
        e.dataflow = df;
        try {
          s.receive(e);
        } catch (error) {
          df.error(error);
        } finally {
          df.run();
        }
      },
      sources;

  if (typeof source === 'string' && typeof document !== 'undefined') {
    sources = document.querySelectorAll(source);
  } else {
    sources = Object(vega_util["i" /* array */])(source);
  }

  for (var i=0, n=sources.length; i<n; ++i) {
    sources[i].addEventListener(type, send);
  }

  return s;
});

// CONCATENATED MODULE: ./node_modules/vega-loader/src/loader.js


// Matches absolute URLs with optional protocol
//   https://...    file://...    //...
const protocol_re = /^([A-Za-z]+:)?\/\//;

// Matches allowed URIs. From https://github.com/cure53/DOMPurify/blob/master/src/regexp.js with added file://
const allowed_re = /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp|file|data):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i; // eslint-disable-line no-useless-escape
const whitespace_re = /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205f\u3000]/g; // eslint-disable-line no-control-regex


// Special treatment in node.js for the file: protocol
const fileProtocol = 'file://';

/**
 * Factory for a loader constructor that provides methods for requesting
 * files from either the network or disk, and for sanitizing request URIs.
 * @param {function} fetch - The Fetch API for HTTP network requests.
 *   If null or undefined, HTTP loading will be disabled.
 * @param {object} fs - The file system interface for file loading.
 *   If null or undefined, local file loading will be disabled.
 * @return {function} A loader constructor with the following signature:
 *   param {object} [options] - Optional default loading options to use.
 *   return {object} - A new loader instance.
 */
/* harmony default export */ var src_loader = (function(fetch, fs) {
  return function(options) {
    return {
      options: options || {},
      sanitize: sanitize,
      load: load,
      fileAccess: !!fs,
      file: fileLoader(fs),
      http: httpLoader(fetch)
    };
  };
});

/**
 * Load an external resource, typically either from the web or from the local
 * filesystem. This function uses {@link sanitize} to first sanitize the uri,
 * then calls either {@link http} (for web requests) or {@link file} (for
 * filesystem loading).
 * @param {string} uri - The resource indicator (e.g., URL or filename).
 * @param {object} [options] - Optional loading options. These options will
 *   override any existing default options.
 * @return {Promise} - A promise that resolves to the loaded content.
 */
async function load(uri, options) {
  const opt = await this.sanitize(uri, options),
        url = opt.href;

  return opt.localFile
    ? this.file(url)
    : this.http(url, options);
}

/**
 * URI sanitizer function.
 * @param {string} uri - The uri (url or filename) to sanity check.
 * @param {object} options - An options hash.
 * @return {Promise} - A promise that resolves to an object containing
 *  sanitized uri data, or rejects it the input uri is deemed invalid.
 *  The properties of the resolved object are assumed to be
 *  valid attributes for an HTML 'a' tag. The sanitized uri *must* be
 *  provided by the 'href' property of the returned object.
 */
async function sanitize(uri, options) {
  options = Object(vega_util["o" /* extend */])({}, this.options, options);

  const fileAccess = this.fileAccess,
        result = {href: null};

  let isFile, loadFile, base;

  const isAllowed = allowed_re.test(uri.replace(whitespace_re, ''));

  if (uri == null || typeof uri !== 'string' || !isAllowed) {
    Object(vega_util["n" /* error */])('Sanitize failure, invalid URI: ' + Object(vega_util["Z" /* stringValue */])(uri));
  }

  const hasProtocol = protocol_re.test(uri);

  // if relative url (no protocol/host), prepend baseURL
  if ((base = options.baseURL) && !hasProtocol) {
    // Ensure that there is a slash between the baseURL (e.g. hostname) and url
    if (!uri.startsWith('/') && base[base.length-1] !== '/') {
      uri = '/' + uri;
    }
    uri = base + uri;
  }

  // should we load from file system?
  loadFile = (isFile = uri.startsWith(fileProtocol))
    || options.mode === 'file'
    || options.mode !== 'http' && !hasProtocol && fileAccess;

  if (isFile) {
    // strip file protocol
    uri = uri.slice(fileProtocol.length);
  } else if (uri.startsWith('//')) {
    if (options.defaultProtocol === 'file') {
      // if is file, strip protocol and set loadFile flag
      uri = uri.slice(2);
      loadFile = true;
    } else {
      // if relative protocol (starts with '//'), prepend default protocol
      uri = (options.defaultProtocol || 'http') + ':' + uri;
    }
  }

  // set non-enumerable mode flag to indicate local file load
  Object.defineProperty(result, 'localFile', {value: !!loadFile});

  // set uri
  result.href = uri;

  // set default result target, if specified
  if (options.target) {
    result.target = options.target + '';
  }

  // set default result rel, if specified (#1542)
  if (options.rel) {
    result.rel = options.rel + '';
  }

  // provide control over cross-origin image handling (#2238)
  // https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_enabled_image
  if (options.context === 'image' && options.crossOrigin) {
    result.crossOrigin = options.crossOrigin + '';
  }

  // return
  return result;
}

/**
 * File system loader factory.
 * @param {object} fs - The file system interface.
 * @return {function} - A file loader with the following signature:
 *   param {string} filename - The file system path to load.
 *   param {string} filename - The file system path to load.
 *   return {Promise} A promise that resolves to the file contents.
 */
function fileLoader(fs) {
  return fs
    ? function(filename) {
        return new Promise(function(accept, reject) {
          fs.readFile(filename, function(error, data) {
            if (error) reject(error);
            else accept(data);
          });
        });
      }
    : fileReject;
}

/**
 * Default file system loader that simply rejects.
 */
async function fileReject() {
  Object(vega_util["n" /* error */])('No file system access.');
}

/**
 * HTTP request handler factory.
 * @param {function} fetch - The Fetch API method.
 * @return {function} - An http loader with the following signature:
 *   param {string} url - The url to request.
 *   param {object} options - An options hash.
 *   return {Promise} - A promise that resolves to the file contents.
 */
function httpLoader(fetch) {
  return fetch
    ? async function(url, options) {
        const opt = Object(vega_util["o" /* extend */])({}, this.options.http, options),
              type = options && options.response,
              response = await fetch(url, opt);

        return !response.ok
          ? Object(vega_util["n" /* error */])(response.status + '' + response.statusText)
          : Object(vega_util["D" /* isFunction */])(response[type]) ? response[type]()
          : response.text();
      }
    : httpReject;
}

/**
 * Default http request handler that simply rejects.
 */
async function httpReject() {
  Object(vega_util["n" /* error */])('No HTTP fetch method available.');
}

// CONCATENATED MODULE: ./node_modules/vega-loader/src/type.js


var typeParsers = {
  boolean: vega_util["ab" /* toBoolean */],
  integer: vega_util["cb" /* toNumber */],
  number:  vega_util["cb" /* toNumber */],
  date:    vega_util["bb" /* toDate */],
  string:  vega_util["eb" /* toString */],
  unknown: vega_util["x" /* identity */]
};

var typeTests = [
  isBoolean,
  isInteger,
  isNumber,
  isDate
];

var typeList = [
  'boolean',
  'integer',
  'number',
  'date'
];

function inferType(values, field) {
  if (!values || !values.length) return 'unknown';

  const n = values.length,
        m = typeTests.length,
        a = typeTests.map((_, i) => i + 1);

  for (let i = 0, t = 0, j, value; i < n; ++i) {
    value = field ? values[i][field] : values[i];
    for (j = 0; j < m; ++j) {
      if (a[j] && isValid(value) && !typeTests[j](value)) {
        a[j] = 0;
        ++t;
        if (t === typeTests.length) return 'string';
      }
    }
  }

  return typeList[
    a.reduce((u, v) => u === 0 ? v : u, 0) - 1
  ];
}

function inferTypes(data, fields) {
  return fields.reduce(function(types, field) {
    types[field] = inferType(data, field);
    return types;
  }, {});
}

// -- Type Checks ----

function isValid(_) {
  return _ != null && _ === _;
}

function isBoolean(_) {
  return _ === 'true' || _ === 'false' || _ === true || _ === false;
}

function isDate(_) {
  return !Number.isNaN(Date.parse(_));
}

function isNumber(_) {
  return !Number.isNaN(+_) && !(_ instanceof Date);
}

function isInteger(_) {
  return isNumber(_) && Number.isInteger(+_);
}

// CONCATENATED MODULE: ./node_modules/d3-dsv/src/dsv.js
var EOL = {},
    EOF = {},
    QUOTE = 34,
    NEWLINE = 10,
    RETURN = 13;

function objectConverter(columns) {
  return new Function("d", "return {" + columns.map(function(name, i) {
    return JSON.stringify(name) + ": d[" + i + "] || \"\"";
  }).join(",") + "}");
}

function customConverter(columns, f) {
  var object = objectConverter(columns);
  return function(row, i) {
    return f(object(row), i, columns);
  };
}

// Compute unique columns in order of discovery.
function inferColumns(rows) {
  var columnSet = Object.create(null),
      columns = [];

  rows.forEach(function(row) {
    for (var column in row) {
      if (!(column in columnSet)) {
        columns.push(columnSet[column] = column);
      }
    }
  });

  return columns;
}

function dsv_pad(value, width) {
  var s = value + "", length = s.length;
  return length < width ? new Array(width - length + 1).join(0) + s : s;
}

function dsv_formatYear(year) {
  return year < 0 ? "-" + dsv_pad(-year, 6)
    : year > 9999 ? "+" + dsv_pad(year, 6)
    : dsv_pad(year, 4);
}

function formatDate(date) {
  var hours = date.getUTCHours(),
      minutes = date.getUTCMinutes(),
      seconds = date.getUTCSeconds(),
      milliseconds = date.getUTCMilliseconds();
  return isNaN(date) ? "Invalid Date"
      : dsv_formatYear(date.getUTCFullYear(), 4) + "-" + dsv_pad(date.getUTCMonth() + 1, 2) + "-" + dsv_pad(date.getUTCDate(), 2)
      + (milliseconds ? "T" + dsv_pad(hours, 2) + ":" + dsv_pad(minutes, 2) + ":" + dsv_pad(seconds, 2) + "." + dsv_pad(milliseconds, 3) + "Z"
      : seconds ? "T" + dsv_pad(hours, 2) + ":" + dsv_pad(minutes, 2) + ":" + dsv_pad(seconds, 2) + "Z"
      : minutes || hours ? "T" + dsv_pad(hours, 2) + ":" + dsv_pad(minutes, 2) + "Z"
      : "");
}

/* harmony default export */ var dsv = (function(delimiter) {
  var reFormat = new RegExp("[\"" + delimiter + "\n\r]"),
      DELIMITER = delimiter.charCodeAt(0);

  function parse(text, f) {
    var convert, columns, rows = parseRows(text, function(row, i) {
      if (convert) return convert(row, i - 1);
      columns = row, convert = f ? customConverter(row, f) : objectConverter(row);
    });
    rows.columns = columns || [];
    return rows;
  }

  function parseRows(text, f) {
    var rows = [], // output rows
        N = text.length,
        I = 0, // current character index
        n = 0, // current line number
        t, // current token
        eof = N <= 0, // current token followed by EOF?
        eol = false; // current token followed by EOL?

    // Strip the trailing newline.
    if (text.charCodeAt(N - 1) === NEWLINE) --N;
    if (text.charCodeAt(N - 1) === RETURN) --N;

    function token() {
      if (eof) return EOF;
      if (eol) return eol = false, EOL;

      // Unescape quotes.
      var i, j = I, c;
      if (text.charCodeAt(j) === QUOTE) {
        while (I++ < N && text.charCodeAt(I) !== QUOTE || text.charCodeAt(++I) === QUOTE);
        if ((i = I) >= N) eof = true;
        else if ((c = text.charCodeAt(I++)) === NEWLINE) eol = true;
        else if (c === RETURN) { eol = true; if (text.charCodeAt(I) === NEWLINE) ++I; }
        return text.slice(j + 1, i - 1).replace(/""/g, "\"");
      }

      // Find next delimiter or newline.
      while (I < N) {
        if ((c = text.charCodeAt(i = I++)) === NEWLINE) eol = true;
        else if (c === RETURN) { eol = true; if (text.charCodeAt(I) === NEWLINE) ++I; }
        else if (c !== DELIMITER) continue;
        return text.slice(j, i);
      }

      // Return last token before EOF.
      return eof = true, text.slice(j, N);
    }

    while ((t = token()) !== EOF) {
      var row = [];
      while (t !== EOL && t !== EOF) row.push(t), t = token();
      if (f && (row = f(row, n++)) == null) continue;
      rows.push(row);
    }

    return rows;
  }

  function preformatBody(rows, columns) {
    return rows.map(function(row) {
      return columns.map(function(column) {
        return formatValue(row[column]);
      }).join(delimiter);
    });
  }

  function format(rows, columns) {
    if (columns == null) columns = inferColumns(rows);
    return [columns.map(formatValue).join(delimiter)].concat(preformatBody(rows, columns)).join("\n");
  }

  function formatBody(rows, columns) {
    if (columns == null) columns = inferColumns(rows);
    return preformatBody(rows, columns).join("\n");
  }

  function formatRows(rows) {
    return rows.map(formatRow).join("\n");
  }

  function formatRow(row) {
    return row.map(formatValue).join(delimiter);
  }

  function formatValue(value) {
    return value == null ? ""
        : value instanceof Date ? formatDate(value)
        : reFormat.test(value += "") ? "\"" + value.replace(/"/g, "\"\"") + "\""
        : value;
  }

  return {
    parse: parse,
    parseRows: parseRows,
    format: format,
    formatBody: formatBody,
    formatRows: formatRows,
    formatRow: formatRow,
    formatValue: formatValue
  };
});

// CONCATENATED MODULE: ./node_modules/vega-loader/src/formats/dsv.js



function delimitedFormat(delimiter) {
  const parse = function(data, format) {
    const delim = {delimiter: delimiter};
    return dsv_dsv(data, format ? Object(vega_util["o" /* extend */])(format, delim) : delim);
  };

  parse.responseType = 'text';

  return parse;
}

function dsv_dsv(data, format) {
  if (format.header) {
    data = format.header
      .map(vega_util["Z" /* stringValue */])
      .join(format.delimiter) + '\n' + data;
  }
  return dsv(format.delimiter).parse(data + '');
}

dsv_dsv.responseType = 'text';

// EXTERNAL MODULE: ./node_modules/vega-loader/src/formats/json.js
var json = __webpack_require__("mw3f");

// CONCATENATED MODULE: ./node_modules/topojson-client/src/identity.js
/* harmony default export */ var identity = (function(x) {
  return x;
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/transform.js


/* harmony default export */ var src_transform = (function(transform) {
  if (transform == null) return identity;
  var x0,
      y0,
      kx = transform.scale[0],
      ky = transform.scale[1],
      dx = transform.translate[0],
      dy = transform.translate[1];
  return function(input, i) {
    if (!i) x0 = y0 = 0;
    var j = 2, n = input.length, output = new Array(n);
    output[0] = (x0 += input[0]) * kx + dx;
    output[1] = (y0 += input[1]) * ky + dy;
    while (j < n) output[j] = input[j], ++j;
    return output;
  };
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/bbox.js


/* harmony default export */ var src_bbox = (function(topology) {
  var t = src_transform(topology.transform), key,
      x0 = Infinity, y0 = x0, x1 = -x0, y1 = -x0;

  function bboxPoint(p) {
    p = t(p);
    if (p[0] < x0) x0 = p[0];
    if (p[0] > x1) x1 = p[0];
    if (p[1] < y0) y0 = p[1];
    if (p[1] > y1) y1 = p[1];
  }

  function bboxGeometry(o) {
    switch (o.type) {
      case "GeometryCollection": o.geometries.forEach(bboxGeometry); break;
      case "Point": bboxPoint(o.coordinates); break;
      case "MultiPoint": o.coordinates.forEach(bboxPoint); break;
    }
  }

  topology.arcs.forEach(function(arc) {
    var i = -1, n = arc.length, p;
    while (++i < n) {
      p = t(arc[i], i);
      if (p[0] < x0) x0 = p[0];
      if (p[0] > x1) x1 = p[0];
      if (p[1] < y0) y0 = p[1];
      if (p[1] > y1) y1 = p[1];
    }
  });

  for (key in topology.objects) {
    bboxGeometry(topology.objects[key]);
  }

  return [x0, y0, x1, y1];
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/reverse.js
/* harmony default export */ var src_reverse = (function(array, n) {
  var t, j = array.length, i = j - n;
  while (i < --j) t = array[i], array[i++] = array[j], array[j] = t;
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/feature.js



/* harmony default export */ var src_feature = (function(topology, o) {
  if (typeof o === "string") o = topology.objects[o];
  return o.type === "GeometryCollection"
      ? {type: "FeatureCollection", features: o.geometries.map(function(o) { return feature_feature(topology, o); })}
      : feature_feature(topology, o);
});

function feature_feature(topology, o) {
  var id = o.id,
      bbox = o.bbox,
      properties = o.properties == null ? {} : o.properties,
      geometry = feature_object(topology, o);
  return id == null && bbox == null ? {type: "Feature", properties: properties, geometry: geometry}
      : bbox == null ? {type: "Feature", id: id, properties: properties, geometry: geometry}
      : {type: "Feature", id: id, bbox: bbox, properties: properties, geometry: geometry};
}

function feature_object(topology, o) {
  var transformPoint = src_transform(topology.transform),
      arcs = topology.arcs;

  function arc(i, points) {
    if (points.length) points.pop();
    for (var a = arcs[i < 0 ? ~i : i], k = 0, n = a.length; k < n; ++k) {
      points.push(transformPoint(a[k], k));
    }
    if (i < 0) src_reverse(points, n);
  }

  function point(p) {
    return transformPoint(p);
  }

  function line(arcs) {
    var points = [];
    for (var i = 0, n = arcs.length; i < n; ++i) arc(arcs[i], points);
    if (points.length < 2) points.push(points[0]); // This should never happen per the specification.
    return points;
  }

  function ring(arcs) {
    var points = line(arcs);
    while (points.length < 4) points.push(points[0]); // This may happen if an arc has only two points.
    return points;
  }

  function polygon(arcs) {
    return arcs.map(ring);
  }

  function geometry(o) {
    var type = o.type, coordinates;
    switch (type) {
      case "GeometryCollection": return {type: type, geometries: o.geometries.map(geometry)};
      case "Point": coordinates = point(o.coordinates); break;
      case "MultiPoint": coordinates = o.coordinates.map(point); break;
      case "LineString": coordinates = line(o.arcs); break;
      case "MultiLineString": coordinates = o.arcs.map(line); break;
      case "Polygon": coordinates = polygon(o.arcs); break;
      case "MultiPolygon": coordinates = o.arcs.map(polygon); break;
      default: return null;
    }
    return {type: type, coordinates: coordinates};
  }

  return geometry(o);
}

// CONCATENATED MODULE: ./node_modules/topojson-client/src/stitch.js
/* harmony default export */ var stitch = (function(topology, arcs) {
  var stitchedArcs = {},
      fragmentByStart = {},
      fragmentByEnd = {},
      fragments = [],
      emptyIndex = -1;

  // Stitch empty arcs first, since they may be subsumed by other arcs.
  arcs.forEach(function(i, j) {
    var arc = topology.arcs[i < 0 ? ~i : i], t;
    if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
      t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
    }
  });

  arcs.forEach(function(i) {
    var e = ends(i),
        start = e[0],
        end = e[1],
        f, g;

    if (f = fragmentByEnd[start]) {
      delete fragmentByEnd[f.end];
      f.push(i);
      f.end = end;
      if (g = fragmentByStart[end]) {
        delete fragmentByStart[g.start];
        var fg = g === f ? f : f.concat(g);
        fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g.end] = fg;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else if (f = fragmentByStart[end]) {
      delete fragmentByStart[f.start];
      f.unshift(i);
      f.start = start;
      if (g = fragmentByEnd[start]) {
        delete fragmentByEnd[g.end];
        var gf = g === f ? f : g.concat(f);
        fragmentByStart[gf.start = g.start] = fragmentByEnd[gf.end = f.end] = gf;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else {
      f = [i];
      fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
    }
  });

  function ends(i) {
    var arc = topology.arcs[i < 0 ? ~i : i], p0 = arc[0], p1;
    if (topology.transform) p1 = [0, 0], arc.forEach(function(dp) { p1[0] += dp[0], p1[1] += dp[1]; });
    else p1 = arc[arc.length - 1];
    return i < 0 ? [p1, p0] : [p0, p1];
  }

  function flush(fragmentByEnd, fragmentByStart) {
    for (var k in fragmentByEnd) {
      var f = fragmentByEnd[k];
      delete fragmentByStart[f.start];
      delete f.start;
      delete f.end;
      f.forEach(function(i) { stitchedArcs[i < 0 ? ~i : i] = 1; });
      fragments.push(f);
    }
  }

  flush(fragmentByEnd, fragmentByStart);
  flush(fragmentByStart, fragmentByEnd);
  arcs.forEach(function(i) { if (!stitchedArcs[i < 0 ? ~i : i]) fragments.push([i]); });

  return fragments;
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/mesh.js



/* harmony default export */ var mesh = (function(topology) {
  return feature_object(topology, meshArcs.apply(this, arguments));
});

function meshArcs(topology, object, filter) {
  var arcs, i, n;
  if (arguments.length > 1) arcs = extractArcs(topology, object, filter);
  else for (i = 0, arcs = new Array(n = topology.arcs.length); i < n; ++i) arcs[i] = i;
  return {type: "MultiLineString", arcs: stitch(topology, arcs)};
}

function extractArcs(topology, object, filter) {
  var arcs = [],
      geomsByArc = [],
      geom;

  function extract0(i) {
    var j = i < 0 ? ~i : i;
    (geomsByArc[j] || (geomsByArc[j] = [])).push({i: i, g: geom});
  }

  function extract1(arcs) {
    arcs.forEach(extract0);
  }

  function extract2(arcs) {
    arcs.forEach(extract1);
  }

  function extract3(arcs) {
    arcs.forEach(extract2);
  }

  function geometry(o) {
    switch (geom = o, o.type) {
      case "GeometryCollection": o.geometries.forEach(geometry); break;
      case "LineString": extract1(o.arcs); break;
      case "MultiLineString": case "Polygon": extract2(o.arcs); break;
      case "MultiPolygon": extract3(o.arcs); break;
    }
  }

  geometry(object);

  geomsByArc.forEach(filter == null
      ? function(geoms) { arcs.push(geoms[0].i); }
      : function(geoms) { if (filter(geoms[0].g, geoms[geoms.length - 1].g)) arcs.push(geoms[0].i); });

  return arcs;
}

// CONCATENATED MODULE: ./node_modules/topojson-client/src/merge.js



function planarRingArea(ring) {
  var i = -1, n = ring.length, a, b = ring[n - 1], area = 0;
  while (++i < n) a = b, b = ring[i], area += a[0] * b[1] - a[1] * b[0];
  return Math.abs(area); // Note: doubled area!
}

/* harmony default export */ var merge = (function(topology) {
  return feature_object(topology, mergeArcs.apply(this, arguments));
});

function mergeArcs(topology, objects) {
  var polygonsByArc = {},
      polygons = [],
      groups = [];

  objects.forEach(geometry);

  function geometry(o) {
    switch (o.type) {
      case "GeometryCollection": o.geometries.forEach(geometry); break;
      case "Polygon": extract(o.arcs); break;
      case "MultiPolygon": o.arcs.forEach(extract); break;
    }
  }

  function extract(polygon) {
    polygon.forEach(function(ring) {
      ring.forEach(function(arc) {
        (polygonsByArc[arc = arc < 0 ? ~arc : arc] || (polygonsByArc[arc] = [])).push(polygon);
      });
    });
    polygons.push(polygon);
  }

  function area(ring) {
    return planarRingArea(feature_object(topology, {type: "Polygon", arcs: [ring]}).coordinates[0]);
  }

  polygons.forEach(function(polygon) {
    if (!polygon._) {
      var group = [],
          neighbors = [polygon];
      polygon._ = 1;
      groups.push(group);
      while (polygon = neighbors.pop()) {
        group.push(polygon);
        polygon.forEach(function(ring) {
          ring.forEach(function(arc) {
            polygonsByArc[arc < 0 ? ~arc : arc].forEach(function(polygon) {
              if (!polygon._) {
                polygon._ = 1;
                neighbors.push(polygon);
              }
            });
          });
        });
      }
    }
  });

  polygons.forEach(function(polygon) {
    delete polygon._;
  });

  return {
    type: "MultiPolygon",
    arcs: groups.map(function(polygons) {
      var arcs = [], n;

      // Extract the exterior (unique) arcs.
      polygons.forEach(function(polygon) {
        polygon.forEach(function(ring) {
          ring.forEach(function(arc) {
            if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
              arcs.push(arc);
            }
          });
        });
      });

      // Stitch the arcs into one or more rings.
      arcs = stitch(topology, arcs);

      // If more than one ring is returned,
      // at most one of these rings can be the exterior;
      // choose the one with the greatest absolute area.
      if ((n = arcs.length) > 1) {
        for (var i = 1, k = area(arcs[0]), ki, t; i < n; ++i) {
          if ((ki = area(arcs[i])) > k) {
            t = arcs[0], arcs[0] = arcs[i], arcs[i] = t, k = ki;
          }
        }
      }

      return arcs;
    }).filter(function(arcs) {
      return arcs.length > 0;
    })
  };
}

// CONCATENATED MODULE: ./node_modules/topojson-client/src/bisect.js
/* harmony default export */ var src_bisect = (function(a, x) {
  var lo = 0, hi = a.length;
  while (lo < hi) {
    var mid = lo + hi >>> 1;
    if (a[mid] < x) lo = mid + 1;
    else hi = mid;
  }
  return lo;
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/neighbors.js


/* harmony default export */ var src_neighbors = (function(objects) {
  var indexesByArc = {}, // arc index -> array of object indexes
      neighbors = objects.map(function() { return []; });

  function line(arcs, i) {
    arcs.forEach(function(a) {
      if (a < 0) a = ~a;
      var o = indexesByArc[a];
      if (o) o.push(i);
      else indexesByArc[a] = [i];
    });
  }

  function polygon(arcs, i) {
    arcs.forEach(function(arc) { line(arc, i); });
  }

  function geometry(o, i) {
    if (o.type === "GeometryCollection") o.geometries.forEach(function(o) { geometry(o, i); });
    else if (o.type in geometryType) geometryType[o.type](o.arcs, i);
  }

  var geometryType = {
    LineString: line,
    MultiLineString: polygon,
    Polygon: polygon,
    MultiPolygon: function(arcs, i) { arcs.forEach(function(arc) { polygon(arc, i); }); }
  };

  objects.forEach(geometry);

  for (var i in indexesByArc) {
    for (var indexes = indexesByArc[i], m = indexes.length, j = 0; j < m; ++j) {
      for (var k = j + 1; k < m; ++k) {
        var ij = indexes[j], ik = indexes[k], n;
        if ((n = neighbors[ij])[i = src_bisect(n, ik)] !== ik) n.splice(i, 0, ik);
        if ((n = neighbors[ik])[i = src_bisect(n, ij)] !== ij) n.splice(i, 0, ij);
      }
    }
  }

  return neighbors;
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/untransform.js


/* harmony default export */ var src_untransform = (function(transform) {
  if (transform == null) return identity;
  var x0,
      y0,
      kx = transform.scale[0],
      ky = transform.scale[1],
      dx = transform.translate[0],
      dy = transform.translate[1];
  return function(input, i) {
    if (!i) x0 = y0 = 0;
    var j = 2,
        n = input.length,
        output = new Array(n),
        x1 = Math.round((input[0] - dx) / kx),
        y1 = Math.round((input[1] - dy) / ky);
    output[0] = x1 - x0, x0 = x1;
    output[1] = y1 - y0, y0 = y1;
    while (j < n) output[j] = input[j], ++j;
    return output;
  };
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/quantize.js



/* harmony default export */ var quantize = (function(topology, transform) {
  if (topology.transform) throw new Error("already quantized");

  if (!transform || !transform.scale) {
    if (!((n = Math.floor(transform)) >= 2)) throw new Error("n must be ≥2");
    box = topology.bbox || src_bbox(topology);
    var x0 = box[0], y0 = box[1], x1 = box[2], y1 = box[3], n;
    transform = {scale: [x1 - x0 ? (x1 - x0) / (n - 1) : 1, y1 - y0 ? (y1 - y0) / (n - 1) : 1], translate: [x0, y0]};
  } else {
    box = topology.bbox;
  }

  var t = src_untransform(transform), box, key, inputs = topology.objects, outputs = {};

  function quantizePoint(point) {
    return t(point);
  }

  function quantizeGeometry(input) {
    var output;
    switch (input.type) {
      case "GeometryCollection": output = {type: "GeometryCollection", geometries: input.geometries.map(quantizeGeometry)}; break;
      case "Point": output = {type: "Point", coordinates: quantizePoint(input.coordinates)}; break;
      case "MultiPoint": output = {type: "MultiPoint", coordinates: input.coordinates.map(quantizePoint)}; break;
      default: return input;
    }
    if (input.id != null) output.id = input.id;
    if (input.bbox != null) output.bbox = input.bbox;
    if (input.properties != null) output.properties = input.properties;
    return output;
  }

  function quantizeArc(input) {
    var i = 0, j = 1, n = input.length, p, output = new Array(n); // pessimistic
    output[0] = t(input[0], 0);
    while (++i < n) if ((p = t(input[i], i))[0] || p[1]) output[j++] = p; // non-coincident points
    if (j === 1) output[j++] = [0, 0]; // an arc must have at least two points
    output.length = j;
    return output;
  }

  for (key in inputs) outputs[key] = quantizeGeometry(inputs[key]);

  return {
    type: "Topology",
    bbox: box,
    transform: transform,
    objects: outputs,
    arcs: topology.arcs.map(quantizeArc)
  };
});

// CONCATENATED MODULE: ./node_modules/topojson-client/src/index.js









// CONCATENATED MODULE: ./node_modules/vega-loader/src/formats/topojson.js




const filters = {
  interior: (a, b) => a !== b,
  exterior: (a, b) => a === b
};

function topojson(data, format) {
  let method, object, property, filter;
  data = Object(json["a" /* default */])(data, format);

  if (format && format.feature) {
    method = src_feature;
    property = format.feature;
  } else if (format && format.mesh) {
    method = mesh;
    property = format.mesh;
    filter = filters[format.filter];
  } else {
    Object(vega_util["n" /* error */])('Missing TopoJSON feature or mesh parameter.');
  }

  object = (object = data.objects[property])
    ? method(data, object, filter)
    : Object(vega_util["n" /* error */])('Invalid TopoJSON object: ' + property);

  return object && object.features || [object];
}

topojson.responseType = 'json';

// CONCATENATED MODULE: ./node_modules/vega-loader/src/formats/index.js





const formats_format = {
  dsv: dsv_dsv,
  csv: delimitedFormat(','),
  tsv: delimitedFormat('\t'),
  json: json["a" /* default */],
  topojson: topojson
};

function formats_formats(name, reader) {
  if (arguments.length > 1) {
    formats_format[name] = reader;
    return this;
  } else {
    return Object(vega_util["v" /* hasOwnProperty */])(formats_format, name) ? formats_format[name] : null;
  }
}

function responseType(type) {
  const f = formats_formats(type);
  return f && f.responseType || 'text';
}

// CONCATENATED MODULE: ./node_modules/vega-format/src/memoize.js
/* harmony default export */ var memoize = (function(method) {
  const cache = {};
  return spec => cache[spec] || (cache[spec] = method(spec));
});

// CONCATENATED MODULE: ./node_modules/d3-array/src/ticks.js
var e10 = Math.sqrt(50),
    e5 = Math.sqrt(10),
    e2 = Math.sqrt(2);

/* harmony default export */ var src_ticks = (function(start, stop, count) {
  var reverse,
      i = -1,
      n,
      ticks,
      step;

  stop = +stop, start = +start, count = +count;
  if (start === stop && count > 0) return [start];
  if (reverse = stop < start) n = start, start = stop, stop = n;
  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];

  if (step > 0) {
    start = Math.ceil(start / step);
    stop = Math.floor(stop / step);
    ticks = new Array(n = Math.ceil(stop - start + 1));
    while (++i < n) ticks[i] = (start + i) * step;
  } else {
    start = Math.floor(start * step);
    stop = Math.ceil(stop * step);
    ticks = new Array(n = Math.ceil(start - stop + 1));
    while (++i < n) ticks[i] = (start - i) / step;
  }

  if (reverse) ticks.reverse();

  return ticks;
});

function tickIncrement(start, stop, count) {
  var step = (stop - start) / Math.max(0, count),
      power = Math.floor(Math.log(step) / Math.LN10),
      error = step / Math.pow(10, power);
  return power >= 0
      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)
      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
}

function tickStep(start, stop, count) {
  var step0 = Math.abs(stop - start) / Math.max(0, count),
      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
      error = step0 / step1;
  if (error >= e10) step1 *= 10;
  else if (error >= e5) step1 *= 5;
  else if (error >= e2) step1 *= 2;
  return stop < start ? -step1 : step1;
}

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatSpecifier.js
// [[fill]align][sign][symbol][0][width][,][.precision][~][type]
var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;

function formatSpecifier(specifier) {
  if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
  var match;
  return new FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}

formatSpecifier.prototype = FormatSpecifier.prototype; // instanceof

function FormatSpecifier(specifier) {
  this.fill = specifier.fill === undefined ? " " : specifier.fill + "";
  this.align = specifier.align === undefined ? ">" : specifier.align + "";
  this.sign = specifier.sign === undefined ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === undefined ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === undefined ? undefined : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === undefined ? undefined : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === undefined ? "" : specifier.type + "";
}

FormatSpecifier.prototype.toString = function() {
  return this.fill
      + this.align
      + this.sign
      + this.symbol
      + (this.zero ? "0" : "")
      + (this.width === undefined ? "" : Math.max(1, this.width | 0))
      + (this.comma ? "," : "")
      + (this.precision === undefined ? "" : "." + Math.max(0, this.precision | 0))
      + (this.trim ? "~" : "")
      + this.type;
};

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatDecimal.js
// Computes the decimal coefficient and exponent of the specified number x with
// significant digits p, where x is positive and p is in [1, 21] or undefined.
// For example, formatDecimal(1.23) returns ["123", 0].
/* harmony default export */ var formatDecimal = (function(x, p) {
  if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null; // NaN, ±Infinity
  var i, coefficient = x.slice(0, i);

  // The string returned by toExponential either has the form \d\.\d+e[-+]\d+
  // (e.g., 1.2e+3) or the form \de[-+]\d+ (e.g., 1e+3).
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x.slice(i + 1)
  ];
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/exponent.js


/* harmony default export */ var src_exponent = (function(x) {
  return x = formatDecimal(Math.abs(x)), x ? x[1] : NaN;
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionPrefix.js


/* harmony default export */ var precisionPrefix = (function(step, value) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(src_exponent(value) / 3))) * 3 - src_exponent(Math.abs(step)));
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionRound.js


/* harmony default export */ var precisionRound = (function(step, max) {
  step = Math.abs(step), max = Math.abs(max) - step;
  return Math.max(0, src_exponent(max) - src_exponent(step)) + 1;
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/precisionFixed.js


/* harmony default export */ var precisionFixed = (function(step) {
  return Math.max(0, -src_exponent(Math.abs(step)));
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatGroup.js
/* harmony default export */ var formatGroup = (function(grouping, thousands) {
  return function(value, width) {
    var i = value.length,
        t = [],
        j = 0,
        g = grouping[0],
        length = 0;

    while (i > 0 && g > 0) {
      if (length + g + 1 > width) g = Math.max(1, width - length);
      t.push(value.substring(i -= g, i + g));
      if ((length += g + 1) > width) break;
      g = grouping[j = (j + 1) % grouping.length];
    }

    return t.reverse().join(thousands);
  };
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatNumerals.js
/* harmony default export */ var formatNumerals = (function(numerals) {
  return function(value) {
    return value.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatTrim.js
// Trims insignificant zeros, e.g., replaces 1.2000k with 1.2k.
/* harmony default export */ var formatTrim = (function(s) {
  out: for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
    switch (s[i]) {
      case ".": i0 = i1 = i; break;
      case "0": if (i0 === 0) i0 = i; i1 = i; break;
      default: if (!+s[i]) break out; if (i0 > 0) i0 = 0; break;
    }
  }
  return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatPrefixAuto.js


var prefixExponent;

/* harmony default export */ var formatPrefixAuto = (function(x, p) {
  var d = formatDecimal(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1],
      i = exponent - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent / 3))) * 3) + 1,
      n = coefficient.length;
  return i === n ? coefficient
      : i > n ? coefficient + new Array(i - n + 1).join("0")
      : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i)
      : "0." + new Array(1 - i).join("0") + formatDecimal(x, Math.max(0, p + i - 1))[0]; // less than 1y!
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatRounded.js


/* harmony default export */ var formatRounded = (function(x, p) {
  var d = formatDecimal(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1];
  return exponent < 0 ? "0." + new Array(-exponent).join("0") + coefficient
      : coefficient.length > exponent + 1 ? coefficient.slice(0, exponent + 1) + "." + coefficient.slice(exponent + 1)
      : coefficient + new Array(exponent - coefficient.length + 2).join("0");
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/formatTypes.js



/* harmony default export */ var formatTypes = ({
  "%": function(x, p) { return (x * 100).toFixed(p); },
  "b": function(x) { return Math.round(x).toString(2); },
  "c": function(x) { return x + ""; },
  "d": function(x) { return Math.round(x).toString(10); },
  "e": function(x, p) { return x.toExponential(p); },
  "f": function(x, p) { return x.toFixed(p); },
  "g": function(x, p) { return x.toPrecision(p); },
  "o": function(x) { return Math.round(x).toString(8); },
  "p": function(x, p) { return formatRounded(x * 100, p); },
  "r": formatRounded,
  "s": formatPrefixAuto,
  "X": function(x) { return Math.round(x).toString(16).toUpperCase(); },
  "x": function(x) { return Math.round(x).toString(16); }
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/identity.js
/* harmony default export */ var src_identity = (function(x) {
  return x;
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/locale.js









var locale_map = Array.prototype.map,
    prefixes = ["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];

/* harmony default export */ var src_locale = (function(locale) {
  var group = locale.grouping === undefined || locale.thousands === undefined ? src_identity : formatGroup(locale_map.call(locale.grouping, Number), locale.thousands + ""),
      currencyPrefix = locale.currency === undefined ? "" : locale.currency[0] + "",
      currencySuffix = locale.currency === undefined ? "" : locale.currency[1] + "",
      decimal = locale.decimal === undefined ? "." : locale.decimal + "",
      numerals = locale.numerals === undefined ? src_identity : formatNumerals(locale_map.call(locale.numerals, String)),
      percent = locale.percent === undefined ? "%" : locale.percent + "",
      minus = locale.minus === undefined ? "-" : locale.minus + "",
      nan = locale.nan === undefined ? "NaN" : locale.nan + "";

  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);

    var fill = specifier.fill,
        align = specifier.align,
        sign = specifier.sign,
        symbol = specifier.symbol,
        zero = specifier.zero,
        width = specifier.width,
        comma = specifier.comma,
        precision = specifier.precision,
        trim = specifier.trim,
        type = specifier.type;

    // The "n" type is an alias for ",g".
    if (type === "n") comma = true, type = "g";

    // The "" type, and any invalid type, is an alias for ".12~g".
    else if (!formatTypes[type]) precision === undefined && (precision = 12), trim = true, type = "g";

    // If zero fill is specified, padding goes after sign and before digits.
    if (zero || (fill === "0" && align === "=")) zero = true, fill = "0", align = "=";

    // Compute the prefix and suffix.
    // For SI-prefix, the suffix is lazily computed.
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "",
        suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type) ? percent : "";

    // What format function should we use?
    // Is this an integer type?
    // Can this type generate exponential notation?
    var formatType = formatTypes[type],
        maybeSuffix = /[defgprs%]/.test(type);

    // Set the default precision if not specified,
    // or clamp the specified precision to the supported range.
    // For significant precision, it must be in [1, 21].
    // For fixed precision, it must be in [0, 20].
    precision = precision === undefined ? 6
        : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision))
        : Math.max(0, Math.min(20, precision));

    function format(value) {
      var valuePrefix = prefix,
          valueSuffix = suffix,
          i, n, c;

      if (type === "c") {
        valueSuffix = formatType(value) + valueSuffix;
        value = "";
      } else {
        value = +value;

        // Determine the sign. -0 is not less than 0, but 1 / -0 is!
        var valueNegative = value < 0 || 1 / value < 0;

        // Perform the initial formatting.
        value = isNaN(value) ? nan : formatType(Math.abs(value), precision);

        // Trim insignificant zeros.
        if (trim) value = formatTrim(value);

        // If a negative value rounds to zero after formatting, and no explicit positive sign is requested, hide the sign.
        if (valueNegative && +value === 0 && sign !== "+") valueNegative = false;

        // Compute the prefix and suffix.
        valuePrefix = (valueNegative ? (sign === "(" ? sign : minus) : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
        valueSuffix = (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");

        // Break the formatted value into the integer “value” part that can be
        // grouped, and fractional or exponential “suffix” part that is not.
        if (maybeSuffix) {
          i = -1, n = value.length;
          while (++i < n) {
            if (c = value.charCodeAt(i), 48 > c || c > 57) {
              valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
              value = value.slice(0, i);
              break;
            }
          }
        }
      }

      // If the fill character is not "0", grouping is applied before padding.
      if (comma && !zero) value = group(value, Infinity);

      // Compute the padding.
      var length = valuePrefix.length + value.length + valueSuffix.length,
          padding = length < width ? new Array(width - length + 1).join(fill) : "";

      // If the fill character is "0", grouping is applied after padding.
      if (comma && zero) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";

      // Reconstruct the final output based on the desired alignment.
      switch (align) {
        case "<": value = valuePrefix + value + valueSuffix + padding; break;
        case "=": value = valuePrefix + padding + value + valueSuffix; break;
        case "^": value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length); break;
        default: value = padding + valuePrefix + value + valueSuffix; break;
      }

      return numerals(value);
    }

    format.toString = function() {
      return specifier + "";
    };

    return format;
  }

  function formatPrefix(specifier, value) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)),
        e = Math.max(-8, Math.min(8, Math.floor(src_exponent(value) / 3))) * 3,
        k = Math.pow(10, -e),
        prefix = prefixes[8 + e / 3];
    return function(value) {
      return f(k * value) + prefix;
    };
  }

  return {
    format: newFormat,
    formatPrefix: formatPrefix
  };
});

// CONCATENATED MODULE: ./node_modules/d3-format/src/defaultLocale.js


var defaultLocale_locale;
var defaultLocale_format;
var defaultLocale_formatPrefix;

defaultLocale({
  decimal: ".",
  thousands: ",",
  grouping: [3],
  currency: ["$", ""],
  minus: "-"
});

function defaultLocale(definition) {
  defaultLocale_locale = src_locale(definition);
  defaultLocale_format = defaultLocale_locale.format;
  defaultLocale_formatPrefix = defaultLocale_locale.formatPrefix;
  return defaultLocale_locale;
}

// CONCATENATED MODULE: ./node_modules/vega-format/src/number.js




function trimZeroes(numberFormat, decimalChar) {
  return x => {
    var str = numberFormat(x),
        dec = str.indexOf(decimalChar),
        idx, end;

    if (dec < 0) return str;

    idx = rightmostDigit(str, dec);
    end = idx < str.length ? str.slice(idx) : '';
    while (--idx > dec) if (str[idx] !== '0') { ++idx; break; }

    return str.slice(0, idx) + end;
  };
}

function rightmostDigit(str, dec) {
  var i = str.lastIndexOf('e'), c;
  if (i > 0) return i;
  for (i=str.length; --i > dec;) {
    c = str.charCodeAt(i);
    if (c >= 48 && c <= 57) return i + 1; // is digit
  }
}

function numberLocale(locale) {
  const format = memoize(locale.format),
        formatPrefix = locale.formatPrefix;

  return {
    format,
    formatPrefix,
    formatFloat(spec) {
      var s = formatSpecifier(spec || ',');
      if (s.precision == null) {
        s.precision = 12;
        switch (s.type) {
          case '%': s.precision -= 2; break;
          case 'e': s.precision -= 1; break;
        }
        return trimZeroes(
          format(s),          // number format
          format('.1f')(1)[1] // decimal point character
        );
      } else {
        return format(s);
      }
    },
    formatSpan(start, stop, count, specifier) {
      specifier = formatSpecifier(specifier == null ? ',f' : specifier);
      const step = tickStep(start, stop, count),
            value = Math.max(Math.abs(start), Math.abs(stop));
      let precision;

      if (specifier.precision == null) {
        switch (specifier.type) {
          case 's': {
            if (!isNaN(precision = precisionPrefix(step, value))) {
              specifier.precision = precision;
            }
            return formatPrefix(specifier, value);
          }
          case '':
          case 'e':
          case 'g':
          case 'p':
          case 'r': {
            if (!isNaN(precision = precisionRound(step, value))) {
              specifier.precision = precision - (specifier.type === 'e');
            }
            break;
          }
          case 'f':
          case '%': {
            if (!isNaN(precision = precisionFixed(step))) {
              specifier.precision = precision - (specifier.type === '%') * 2;
            }
            break;
          }
        }
      }
      return format(specifier);
    }
  };
}

let defaultNumberLocale;
resetNumberFormatDefaultLocale();

function resetNumberFormatDefaultLocale() {
  return defaultNumberLocale = numberLocale({
    format: defaultLocale_format,
    formatPrefix: defaultLocale_formatPrefix
  });
}

function numberFormatLocale(definition) {
  return numberLocale(src_locale(definition));
}

function numberFormatDefaultLocale(definition) {
  return arguments.length
    ? (defaultNumberLocale = numberFormatLocale(definition))
    : defaultNumberLocale;
}

// CONCATENATED MODULE: ./node_modules/vega-time/src/units.js


const YEAR = 'year';
const QUARTER = 'quarter';
const MONTH = 'month';
const WEEK = 'week';
const DATE = 'date';
const DAY = 'day';
const DAYOFYEAR = 'dayofyear';
const HOURS = 'hours';
const MINUTES = 'minutes';
const SECONDS = 'seconds';
const MILLISECONDS = 'milliseconds';

const TIME_UNITS = [
  YEAR,
  QUARTER,
  MONTH,
  WEEK,
  DATE,
  DAY,
  DAYOFYEAR,
  HOURS,
  MINUTES,
  SECONDS,
  MILLISECONDS
];

const UNITS = TIME_UNITS.reduce((o, u, i) => (o[u] = 1 + i, o), {});

function timeUnits(units) {
  const u = Object(vega_util["i" /* array */])(units).slice(),
        m = {};

  // check validity
  if (!u.length) Object(vega_util["n" /* error */])('Missing time unit.');

  u.forEach(unit => {
    if (Object(vega_util["v" /* hasOwnProperty */])(UNITS, unit)) {
      m[unit] = 1;
    } else {
      Object(vega_util["n" /* error */])(`Invalid time unit: ${unit}.`);
    }
  });

  const numTypes = (
    (m[WEEK] || m[DAY] ? 1 : 0) +
    (m[QUARTER] || m[MONTH] || m[DATE] ? 1 : 0) +
    (m[DAYOFYEAR] ? 1 : 0)
  );

  if (numTypes > 1) {
    Object(vega_util["n" /* error */])(`Incompatible time units: ${units}`);
  }

  // ensure proper sort order
  u.sort((a, b) => UNITS[a] - UNITS[b]);

  return u;
}

const defaultSpecifiers = {
  [YEAR]: '%Y ',
  [QUARTER]: 'Q%q ',
  [MONTH]: '%b ',
  [DATE]: '%d ',
  [WEEK]: 'W%U ',
  [DAY]: '%a ',
  [DAYOFYEAR]: '%j ',
  [HOURS]: '%H:00',
  [MINUTES]: '00:%M',
  [SECONDS]: ':%S',
  [MILLISECONDS]: '.%L',
  [`${YEAR}-${MONTH}`]: '%Y-%m ',
  [`${YEAR}-${MONTH}-${DATE}`]: '%Y-%m-%d ',
  [`${HOURS}-${MINUTES}`]: '%H:%M'
};

function timeUnitSpecifier(units, specifiers) {
  const s = Object(vega_util["o" /* extend */])({}, defaultSpecifiers, specifiers),
        u = timeUnits(units),
        n = u.length;

  let fmt = '', start = 0, end, key;

  for (start=0; start<n; ) {
    for (end=u.length; end > start; --end) {
      key = u.slice(start, end).join('-');
      if (s[key] != null) {
        fmt += s[key];
        start = end;
        break;
      }
    }
  }

  return fmt.trim();
}

// CONCATENATED MODULE: ./node_modules/d3-time/src/interval.js
var interval_t0 = new Date,
    interval_t1 = new Date;

function newInterval(floori, offseti, count, field) {

  function interval(date) {
    return floori(date = arguments.length === 0 ? new Date : new Date(+date)), date;
  }

  interval.floor = function(date) {
    return floori(date = new Date(+date)), date;
  };

  interval.ceil = function(date) {
    return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;
  };

  interval.round = function(date) {
    var d0 = interval(date),
        d1 = interval.ceil(date);
    return date - d0 < d1 - date ? d0 : d1;
  };

  interval.offset = function(date, step) {
    return offseti(date = new Date(+date), step == null ? 1 : Math.floor(step)), date;
  };

  interval.range = function(start, stop, step) {
    var range = [], previous;
    start = interval.ceil(start);
    step = step == null ? 1 : Math.floor(step);
    if (!(start < stop) || !(step > 0)) return range; // also handles Invalid Date
    do range.push(previous = new Date(+start)), offseti(start, step), floori(start);
    while (previous < start && start < stop);
    return range;
  };

  interval.filter = function(test) {
    return newInterval(function(date) {
      if (date >= date) while (floori(date), !test(date)) date.setTime(date - 1);
    }, function(date, step) {
      if (date >= date) {
        if (step < 0) while (++step <= 0) {
          while (offseti(date, -1), !test(date)) {} // eslint-disable-line no-empty
        } else while (--step >= 0) {
          while (offseti(date, +1), !test(date)) {} // eslint-disable-line no-empty
        }
      }
    });
  };

  if (count) {
    interval.count = function(start, end) {
      interval_t0.setTime(+start), interval_t1.setTime(+end);
      floori(interval_t0), floori(interval_t1);
      return Math.floor(count(interval_t0, interval_t1));
    };

    interval.every = function(step) {
      step = Math.floor(step);
      return !isFinite(step) || !(step > 0) ? null
          : !(step > 1) ? interval
          : interval.filter(field
              ? function(d) { return field(d) % step === 0; }
              : function(d) { return interval.count(0, d) % step === 0; });
    };
  }

  return interval;
}

// CONCATENATED MODULE: ./node_modules/d3-time/src/duration.js
var durationSecond = 1e3;
var durationMinute = 6e4;
var durationHour = 36e5;
var durationDay = 864e5;
var durationWeek = 6048e5;

// CONCATENATED MODULE: ./node_modules/d3-time/src/day.js



var day_day = newInterval(function(date) {
  date.setHours(0, 0, 0, 0);
}, function(date, step) {
  date.setDate(date.getDate() + step);
}, function(start, end) {
  return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationDay;
}, function(date) {
  return date.getDate() - 1;
});

/* harmony default export */ var src_day = (day_day);
var days = day_day.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/week.js



function weekday(i) {
  return newInterval(function(date) {
    date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
    date.setHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setDate(date.getDate() + step * 7);
  }, function(start, end) {
    return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationWeek;
  });
}

var sunday = weekday(0);
var monday = weekday(1);
var tuesday = weekday(2);
var wednesday = weekday(3);
var thursday = weekday(4);
var friday = weekday(5);
var saturday = weekday(6);

var sundays = sunday.range;
var mondays = monday.range;
var tuesdays = tuesday.range;
var wednesdays = wednesday.range;
var thursdays = thursday.range;
var fridays = friday.range;
var saturdays = saturday.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcDay.js



var utcDay = newInterval(function(date) {
  date.setUTCHours(0, 0, 0, 0);
}, function(date, step) {
  date.setUTCDate(date.getUTCDate() + step);
}, function(start, end) {
  return (end - start) / durationDay;
}, function(date) {
  return date.getUTCDate() - 1;
});

/* harmony default export */ var src_utcDay = (utcDay);
var utcDays = utcDay.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcWeek.js



function utcWeekday(i) {
  return newInterval(function(date) {
    date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);
    date.setUTCHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setUTCDate(date.getUTCDate() + step * 7);
  }, function(start, end) {
    return (end - start) / durationWeek;
  });
}

var utcSunday = utcWeekday(0);
var utcMonday = utcWeekday(1);
var utcTuesday = utcWeekday(2);
var utcWednesday = utcWeekday(3);
var utcThursday = utcWeekday(4);
var utcFriday = utcWeekday(5);
var utcSaturday = utcWeekday(6);

var utcSundays = utcSunday.range;
var utcMondays = utcMonday.range;
var utcTuesdays = utcTuesday.range;
var utcWednesdays = utcWednesday.range;
var utcThursdays = utcThursday.range;
var utcFridays = utcFriday.range;
var utcSaturdays = utcSaturday.range;

// CONCATENATED MODULE: ./node_modules/vega-time/src/util.js


const util_t0 = new Date;

function localYear(y) {
  util_t0.setFullYear(y);
  util_t0.setMonth(0);
  util_t0.setDate(1);
  util_t0.setHours(0, 0, 0, 0);
  return util_t0;
}

function dayofyear(d) {
  return localDayOfYear(new Date(d));
}

function util_week(d) {
  return localWeekNum(new Date(d));
}

function localDayOfYear(d) {
  return src_day.count(localYear(d.getFullYear()) - 1, d);
}

function localWeekNum(d) {
  return sunday.count(localYear(d.getFullYear()) - 1, d);
}

function localFirst(y) {
  return localYear(y).getDay();
}

function localDate(y, m, d, H, M, S, L) {
  if (0 <= y && y < 100) {
    var date = new Date(-1, m, d, H, M, S, L);
    date.setFullYear(y);
    return date;
  }
  return new Date(y, m, d, H, M, S, L);
}

function utcdayofyear(d) {
  return utcDayOfYear(new Date(d));
}

function utcweek(d) {
  return utcWeekNum(new Date(d));
}

function utcDayOfYear(d) {
  const y = Date.UTC(d.getUTCFullYear(), 0, 1);
  return src_utcDay.count(y - 1, d);
}

function utcWeekNum(d) {
  const y = Date.UTC(d.getUTCFullYear(), 0, 1);
  return utcSunday.count(y - 1, d);
}

function utcFirst(y) {
  util_t0.setTime(Date.UTC(y, 0, 1));
  return util_t0.getUTCDay();
}

function utcDate(y, m, d, H, M, S, L) {
  if (0 <= y && y < 100) {
    var date = new Date(Date.UTC(-1, m, d, H, M, S, L));
    date.setUTCFullYear(d.y);
    return date;
  }
  return new Date(Date.UTC(y, m, d, H, M, S, L));
}

// CONCATENATED MODULE: ./node_modules/vega-time/src/floor.js




function floor_floor(units, step, get, inv, newDate) {
  const s = step || 1,
        b = Object(vega_util["U" /* peek */])(units),
        _ = (unit, p, key) => {
          key = key || unit;
          return getUnit(get[key], inv[key], unit === b && s, p);
        };

  const t = new Date,
        u = Object(vega_util["db" /* toSet */])(units),
        y = u[YEAR] ? _(YEAR) : Object(vega_util["l" /* constant */])(2012),
        m = u[MONTH] ? _(MONTH)
          : u[QUARTER] ? _(QUARTER)
          : vega_util["kb" /* zero */],
        d = u[WEEK] && u[DAY] ? _(DAY, 1, WEEK + DAY)
          : u[WEEK] ? _(WEEK, 1)
          : u[DAY] ? _(DAY, 1)
          : u[DATE] ? _(DATE, 1)
          : u[DAYOFYEAR] ? _(DAYOFYEAR, 1)
          : vega_util["O" /* one */],
        H = u[HOURS] ? _(HOURS) : vega_util["kb" /* zero */],
        M = u[MINUTES] ? _(MINUTES) : vega_util["kb" /* zero */],
        S = u[SECONDS] ? _(SECONDS) : vega_util["kb" /* zero */],
        L = u[MILLISECONDS] ? _(MILLISECONDS) : vega_util["kb" /* zero */];

  return function(v) {
    t.setTime(+v);
    const year = y(t);
    return newDate(year, m(t), d(t, year), H(t), M(t), S(t), L(t));
  };
}

function getUnit(f, inv, step, phase) {
  const u = step <= 1 ? f
    : phase ? (d, y) => phase + step * Math.floor((f(d, y) - phase) / step)
    : (d, y) => step * Math.floor(f(d, y) / step);
  return inv ? (d, y) => inv(u(d, y), y) : u;
}

// returns the day of the year based on week number, day of week,
// and the day of the week for the first day of the year
function floor_weekday(week, day, firstDay) {
  return day + week * 7 - (firstDay + 6) % 7;
}

// -- LOCAL TIME --

const localGet = {
  [YEAR]:         d => d.getFullYear(),
  [QUARTER]:      d => Math.floor(d.getMonth() / 3),
  [MONTH]:        d => d.getMonth(),
  [DATE]:         d => d.getDate(),
  [HOURS]:        d => d.getHours(),
  [MINUTES]:      d => d.getMinutes(),
  [SECONDS]:      d => d.getSeconds(),
  [MILLISECONDS]: d => d.getMilliseconds(),
  [DAYOFYEAR]:    d => localDayOfYear(d),
  [WEEK]:         d => localWeekNum(d),
  [WEEK + DAY]:   (d, y) => floor_weekday(localWeekNum(d), d.getDay(), localFirst(y)),
  [DAY]:          (d, y) => floor_weekday(1, d.getDay(), localFirst(y))
};

const localInv = {
  [QUARTER]: q => 3 * q,
  [WEEK]:    (w, y) => floor_weekday(w, 0, localFirst(y))
};

function timeFloor(units, step) {
  return floor_floor(units, step || 1, localGet, localInv, localDate);
}

// -- UTC TIME --

const utcGet = {
  [YEAR]:         d => d.getUTCFullYear(),
  [QUARTER]:      d => Math.floor(d.getUTCMonth() / 3),
  [MONTH]:        d => d.getUTCMonth(),
  [DATE]:         d => d.getUTCDate(),
  [HOURS]:        d => d.getUTCHours(),
  [MINUTES]:      d => d.getUTCMinutes(),
  [SECONDS]:      d => d.getUTCSeconds(),
  [MILLISECONDS]: d => d.getUTCMilliseconds(),
  [DAYOFYEAR]:    d => utcDayOfYear(d),
  [WEEK]:         d => utcWeekNum(d),
  [DAY]:          (d, y) => floor_weekday(1, d.getUTCDay(), utcFirst(y)),
  [WEEK + DAY]:   (d, y) => floor_weekday(utcWeekNum(d), d.getUTCDay(), utcFirst(y))
};

const utcInv = {
  [QUARTER]: q => 3 * q,
  [WEEK]:    (w, y) => floor_weekday(w, 0, utcFirst(y))
};

function utcFloor(units, step) {
  return floor_floor(units, step || 1, utcGet, utcInv, utcDate);
}

// CONCATENATED MODULE: ./node_modules/d3-time/src/year.js


var year_year = newInterval(function(date) {
  date.setMonth(0, 1);
  date.setHours(0, 0, 0, 0);
}, function(date, step) {
  date.setFullYear(date.getFullYear() + step);
}, function(start, end) {
  return end.getFullYear() - start.getFullYear();
}, function(date) {
  return date.getFullYear();
});

// An optimized implementation for this simple case.
year_year.every = function(k) {
  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
    date.setFullYear(Math.floor(date.getFullYear() / k) * k);
    date.setMonth(0, 1);
    date.setHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setFullYear(date.getFullYear() + step * k);
  });
};

/* harmony default export */ var src_year = (year_year);
var years = year_year.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/month.js


var month_month = newInterval(function(date) {
  date.setDate(1);
  date.setHours(0, 0, 0, 0);
}, function(date, step) {
  date.setMonth(date.getMonth() + step);
}, function(start, end) {
  return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
}, function(date) {
  return date.getMonth();
});

/* harmony default export */ var src_month = (month_month);
var months = month_month.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/hour.js



var hour_hour = newInterval(function(date) {
  date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond - date.getMinutes() * durationMinute);
}, function(date, step) {
  date.setTime(+date + step * durationHour);
}, function(start, end) {
  return (end - start) / durationHour;
}, function(date) {
  return date.getHours();
});

/* harmony default export */ var src_hour = (hour_hour);
var hours = hour_hour.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/minute.js



var minute_minute = newInterval(function(date) {
  date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond);
}, function(date, step) {
  date.setTime(+date + step * durationMinute);
}, function(start, end) {
  return (end - start) / durationMinute;
}, function(date) {
  return date.getMinutes();
});

/* harmony default export */ var src_minute = (minute_minute);
var minutes = minute_minute.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/second.js



var second_second = newInterval(function(date) {
  date.setTime(date - date.getMilliseconds());
}, function(date, step) {
  date.setTime(+date + step * durationSecond);
}, function(start, end) {
  return (end - start) / durationSecond;
}, function(date) {
  return date.getUTCSeconds();
});

/* harmony default export */ var src_second = (second_second);
var seconds = second_second.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/millisecond.js


var millisecond_millisecond = newInterval(function() {
  // noop
}, function(date, step) {
  date.setTime(+date + step);
}, function(start, end) {
  return end - start;
});

// An optimized implementation for this simple case.
millisecond_millisecond.every = function(k) {
  k = Math.floor(k);
  if (!isFinite(k) || !(k > 0)) return null;
  if (!(k > 1)) return millisecond_millisecond;
  return newInterval(function(date) {
    date.setTime(Math.floor(date / k) * k);
  }, function(date, step) {
    date.setTime(+date + step * k);
  }, function(start, end) {
    return (end - start) / k;
  });
};

/* harmony default export */ var src_millisecond = (millisecond_millisecond);
var milliseconds = millisecond_millisecond.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcYear.js


var utcYear = newInterval(function(date) {
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
}, function(date, step) {
  date.setUTCFullYear(date.getUTCFullYear() + step);
}, function(start, end) {
  return end.getUTCFullYear() - start.getUTCFullYear();
}, function(date) {
  return date.getUTCFullYear();
});

// An optimized implementation for this simple case.
utcYear.every = function(k) {
  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
    date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);
    date.setUTCMonth(0, 1);
    date.setUTCHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setUTCFullYear(date.getUTCFullYear() + step * k);
  });
};

/* harmony default export */ var src_utcYear = (utcYear);
var utcYears = utcYear.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcMonth.js


var utcMonth = newInterval(function(date) {
  date.setUTCDate(1);
  date.setUTCHours(0, 0, 0, 0);
}, function(date, step) {
  date.setUTCMonth(date.getUTCMonth() + step);
}, function(start, end) {
  return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
}, function(date) {
  return date.getUTCMonth();
});

/* harmony default export */ var src_utcMonth = (utcMonth);
var utcMonths = utcMonth.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcHour.js



var utcHour = newInterval(function(date) {
  date.setUTCMinutes(0, 0, 0);
}, function(date, step) {
  date.setTime(+date + step * durationHour);
}, function(start, end) {
  return (end - start) / durationHour;
}, function(date) {
  return date.getUTCHours();
});

/* harmony default export */ var src_utcHour = (utcHour);
var utcHours = utcHour.range;

// CONCATENATED MODULE: ./node_modules/d3-time/src/utcMinute.js



var utcMinute = newInterval(function(date) {
  date.setUTCSeconds(0, 0);
}, function(date, step) {
  date.setTime(+date + step * durationMinute);
}, function(start, end) {
  return (end - start) / durationMinute;
}, function(date) {
  return date.getUTCMinutes();
});

/* harmony default export */ var src_utcMinute = (utcMinute);
var utcMinutes = utcMinute.range;

// CONCATENATED MODULE: ./node_modules/vega-time/src/interval.js




const timeIntervals = {
  [YEAR]:         src_year,
  [QUARTER]:      src_month.every(3),
  [MONTH]:        src_month,
  [WEEK]:         sunday,
  [DATE]:         src_day,
  [DAY]:          src_day,
  [DAYOFYEAR]:    src_day,
  [HOURS]:        src_hour,
  [MINUTES]:      src_minute,
  [SECONDS]:      src_second,
  [MILLISECONDS]: src_millisecond
};

const utcIntervals = {
  [YEAR]:         src_utcYear,
  [QUARTER]:      src_utcMonth.every(3),
  [MONTH]:        src_utcMonth,
  [WEEK]:         utcSunday,
  [DATE]:         src_utcDay,
  [DAY]:          src_utcDay,
  [DAYOFYEAR]:    src_utcDay,
  [HOURS]:        src_utcHour,
  [MINUTES]:      src_utcMinute,
  [SECONDS]:      src_second,
  [MILLISECONDS]: src_millisecond
};

function timeInterval(unit) {
  return timeIntervals[unit];
}

function utcInterval(unit) {
  return utcIntervals[unit];
}

function interval_offset(ival, date, step) {
  return ival ? ival.offset(date, step) : undefined;
}

function timeOffset(unit, date, step) {
  return interval_offset(timeInterval(unit), date, step);
}

function utcOffset(unit, date, step) {
  return interval_offset(utcInterval(unit), date, step);
}

function sequence(ival, start, stop, step) {
  return ival ? ival.range(start, stop, step) : undefined;
}

function timeSequence(unit, start, stop, step) {
  return sequence(timeInterval(unit), start, stop, step);
}

function utcSequence(unit, start, stop, step) {
  return sequence(utcInterval(unit), start, stop, step);
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/ascending.js
/* harmony default export */ var ascending = (function(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
});

// CONCATENATED MODULE: ./node_modules/d3-array/src/bisector.js


/* harmony default export */ var bisector = (function(compare) {
  if (compare.length === 1) compare = ascendingComparator(compare);
  return {
    left: function(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) < 0) lo = mid + 1;
        else hi = mid;
      }
      return lo;
    },
    right: function(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) > 0) hi = mid;
        else lo = mid + 1;
      }
      return lo;
    }
  };
});

function ascendingComparator(f) {
  return function(d, x) {
    return ascending(f(d), x);
  };
}

// CONCATENATED MODULE: ./node_modules/vega-time/src/bin.js




const bin_durationSecond = 1000,
      bin_durationMinute = bin_durationSecond * 60,
      bin_durationHour = bin_durationMinute * 60,
      bin_durationDay = bin_durationHour * 24,
      bin_durationWeek = bin_durationDay * 7,
      durationMonth = bin_durationDay * 30,
      durationYear = bin_durationDay * 365;

const Milli   = [YEAR, MONTH, DATE, HOURS, MINUTES, SECONDS, MILLISECONDS],
      Seconds = Milli.slice(0, -1),
      Minutes = Seconds.slice(0, -1),
      Hours   = Minutes.slice(0, -1),
      Day     = Hours.slice(0, -1),
      Week    = [YEAR, WEEK],
      Month   = [YEAR, MONTH],
      Year    = [YEAR];

const intervals = [
  [Seconds,  1,      bin_durationSecond],
  [Seconds,  5,  5 * bin_durationSecond],
  [Seconds, 15, 15 * bin_durationSecond],
  [Seconds, 30, 30 * bin_durationSecond],
  [Minutes,  1,      bin_durationMinute],
  [Minutes,  5,  5 * bin_durationMinute],
  [Minutes, 15, 15 * bin_durationMinute],
  [Minutes, 30, 30 * bin_durationMinute],
  [  Hours,  1,      bin_durationHour  ],
  [  Hours,  3,  3 * bin_durationHour  ],
  [  Hours,  6,  6 * bin_durationHour  ],
  [  Hours, 12, 12 * bin_durationHour  ],
  [    Day,  1,      bin_durationDay   ],
  [   Week,  1,      bin_durationWeek  ],
  [  Month,  1,      durationMonth ],
  [  Month,  3,  3 * durationMonth ],
  [   Year,  1,      durationYear  ]
];

/* harmony default export */ var src_bin = (function(opt) {
  const ext = opt.extent,
        max = opt.maxbins || 40,
        target = Math.abs(Object(vega_util["X" /* span */])(ext)) / max;

  let i = bisector(i => i[2]).right(intervals, target),
      units, step;

  if (i === intervals.length) {
    units = Year,
    step = tickStep(ext[0] / durationYear, ext[1] / durationYear, max);
  } else if (i) {
    i = intervals[target / intervals[i - 1][2] < intervals[i][2] / target ? i - 1 : i];
    units = i[0];
    step = i[1];
  } else {
    units = Milli;
    step = Math.max(tickStep(ext[0], ext[1], max), 1);
  }

  return {units, step};
});

// CONCATENATED MODULE: ./node_modules/vega-time/index.js










// CONCATENATED MODULE: ./node_modules/d3-time-format/src/locale.js


function locale_localDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
    date.setFullYear(d.y);
    return date;
  }
  return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
}

function locale_utcDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
    date.setUTCFullYear(d.y);
    return date;
  }
  return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
}

function locale_newDate(y, m, d) {
  return {y: y, m: m, d: d, H: 0, M: 0, S: 0, L: 0};
}

function formatLocale(locale) {
  var locale_dateTime = locale.dateTime,
      locale_date = locale.date,
      locale_time = locale.time,
      locale_periods = locale.periods,
      locale_weekdays = locale.days,
      locale_shortWeekdays = locale.shortDays,
      locale_months = locale.months,
      locale_shortMonths = locale.shortMonths;

  var periodRe = formatRe(locale_periods),
      periodLookup = formatLookup(locale_periods),
      weekdayRe = formatRe(locale_weekdays),
      weekdayLookup = formatLookup(locale_weekdays),
      shortWeekdayRe = formatRe(locale_shortWeekdays),
      shortWeekdayLookup = formatLookup(locale_shortWeekdays),
      monthRe = formatRe(locale_months),
      monthLookup = formatLookup(locale_months),
      shortMonthRe = formatRe(locale_shortMonths),
      shortMonthLookup = formatLookup(locale_shortMonths);

  var formats = {
    "a": formatShortWeekday,
    "A": formatWeekday,
    "b": formatShortMonth,
    "B": formatMonth,
    "c": null,
    "d": formatDayOfMonth,
    "e": formatDayOfMonth,
    "f": formatMicroseconds,
    "H": formatHour24,
    "I": formatHour12,
    "j": formatDayOfYear,
    "L": formatMilliseconds,
    "m": formatMonthNumber,
    "M": formatMinutes,
    "p": formatPeriod,
    "q": formatQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatSeconds,
    "u": formatWeekdayNumberMonday,
    "U": formatWeekNumberSunday,
    "V": formatWeekNumberISO,
    "w": formatWeekdayNumberSunday,
    "W": formatWeekNumberMonday,
    "x": null,
    "X": null,
    "y": locale_formatYear,
    "Y": formatFullYear,
    "Z": formatZone,
    "%": formatLiteralPercent
  };

  var utcFormats = {
    "a": formatUTCShortWeekday,
    "A": formatUTCWeekday,
    "b": formatUTCShortMonth,
    "B": formatUTCMonth,
    "c": null,
    "d": formatUTCDayOfMonth,
    "e": formatUTCDayOfMonth,
    "f": formatUTCMicroseconds,
    "H": formatUTCHour24,
    "I": formatUTCHour12,
    "j": formatUTCDayOfYear,
    "L": formatUTCMilliseconds,
    "m": formatUTCMonthNumber,
    "M": formatUTCMinutes,
    "p": formatUTCPeriod,
    "q": formatUTCQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatUTCSeconds,
    "u": formatUTCWeekdayNumberMonday,
    "U": formatUTCWeekNumberSunday,
    "V": formatUTCWeekNumberISO,
    "w": formatUTCWeekdayNumberSunday,
    "W": formatUTCWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatUTCYear,
    "Y": formatUTCFullYear,
    "Z": formatUTCZone,
    "%": formatLiteralPercent
  };

  var parses = {
    "a": parseShortWeekday,
    "A": parseWeekday,
    "b": parseShortMonth,
    "B": parseMonth,
    "c": parseLocaleDateTime,
    "d": parseDayOfMonth,
    "e": parseDayOfMonth,
    "f": parseMicroseconds,
    "H": parseHour24,
    "I": parseHour24,
    "j": parseDayOfYear,
    "L": parseMilliseconds,
    "m": parseMonthNumber,
    "M": parseMinutes,
    "p": parsePeriod,
    "q": parseQuarter,
    "Q": parseUnixTimestamp,
    "s": parseUnixTimestampSeconds,
    "S": parseSeconds,
    "u": parseWeekdayNumberMonday,
    "U": parseWeekNumberSunday,
    "V": parseWeekNumberISO,
    "w": parseWeekdayNumberSunday,
    "W": parseWeekNumberMonday,
    "x": parseLocaleDate,
    "X": parseLocaleTime,
    "y": parseYear,
    "Y": parseFullYear,
    "Z": parseZone,
    "%": parseLiteralPercent
  };

  // These recursive directive definitions must be deferred.
  formats.x = newFormat(locale_date, formats);
  formats.X = newFormat(locale_time, formats);
  formats.c = newFormat(locale_dateTime, formats);
  utcFormats.x = newFormat(locale_date, utcFormats);
  utcFormats.X = newFormat(locale_time, utcFormats);
  utcFormats.c = newFormat(locale_dateTime, utcFormats);

  function newFormat(specifier, formats) {
    return function(date) {
      var string = [],
          i = -1,
          j = 0,
          n = specifier.length,
          c,
          pad,
          format;

      if (!(date instanceof Date)) date = new Date(+date);

      while (++i < n) {
        if (specifier.charCodeAt(i) === 37) {
          string.push(specifier.slice(j, i));
          if ((pad = pads[c = specifier.charAt(++i)]) != null) c = specifier.charAt(++i);
          else pad = c === "e" ? " " : "0";
          if (format = formats[c]) c = format(date, pad);
          string.push(c);
          j = i + 1;
        }
      }

      string.push(specifier.slice(j, i));
      return string.join("");
    };
  }

  function newParse(specifier, Z) {
    return function(string) {
      var d = locale_newDate(1900, undefined, 1),
          i = parseSpecifier(d, specifier, string += "", 0),
          week, day;
      if (i != string.length) return null;

      // If a UNIX timestamp is specified, return it.
      if ("Q" in d) return new Date(d.Q);
      if ("s" in d) return new Date(d.s * 1000 + ("L" in d ? d.L : 0));

      // If this is utcParse, never use the local timezone.
      if (Z && !("Z" in d)) d.Z = 0;

      // The am-pm flag is 0 for AM, and 1 for PM.
      if ("p" in d) d.H = d.H % 12 + d.p * 12;

      // If the month was not specified, inherit from the quarter.
      if (d.m === undefined) d.m = "q" in d ? d.q : 0;

      // Convert day-of-week and week-of-year to day-of-year.
      if ("V" in d) {
        if (d.V < 1 || d.V > 53) return null;
        if (!("w" in d)) d.w = 1;
        if ("Z" in d) {
          week = locale_utcDate(locale_newDate(d.y, 0, 1)), day = week.getUTCDay();
          week = day > 4 || day === 0 ? utcMonday.ceil(week) : utcMonday(week);
          week = src_utcDay.offset(week, (d.V - 1) * 7);
          d.y = week.getUTCFullYear();
          d.m = week.getUTCMonth();
          d.d = week.getUTCDate() + (d.w + 6) % 7;
        } else {
          week = locale_localDate(locale_newDate(d.y, 0, 1)), day = week.getDay();
          week = day > 4 || day === 0 ? monday.ceil(week) : monday(week);
          week = src_day.offset(week, (d.V - 1) * 7);
          d.y = week.getFullYear();
          d.m = week.getMonth();
          d.d = week.getDate() + (d.w + 6) % 7;
        }
      } else if ("W" in d || "U" in d) {
        if (!("w" in d)) d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
        day = "Z" in d ? locale_utcDate(locale_newDate(d.y, 0, 1)).getUTCDay() : locale_localDate(locale_newDate(d.y, 0, 1)).getDay();
        d.m = 0;
        d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
      }

      // If a time zone is specified, all fields are interpreted as UTC and then
      // offset according to the specified time zone.
      if ("Z" in d) {
        d.H += d.Z / 100 | 0;
        d.M += d.Z % 100;
        return locale_utcDate(d);
      }

      // Otherwise, all fields are in local time.
      return locale_localDate(d);
    };
  }

  function parseSpecifier(d, specifier, string, j) {
    var i = 0,
        n = specifier.length,
        m = string.length,
        c,
        parse;

    while (i < n) {
      if (j >= m) return -1;
      c = specifier.charCodeAt(i++);
      if (c === 37) {
        c = specifier.charAt(i++);
        parse = parses[c in pads ? specifier.charAt(i++) : c];
        if (!parse || ((j = parse(d, string, j)) < 0)) return -1;
      } else if (c != string.charCodeAt(j++)) {
        return -1;
      }
    }

    return j;
  }

  function parsePeriod(d, string, i) {
    var n = periodRe.exec(string.slice(i));
    return n ? (d.p = periodLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }

  function parseShortWeekday(d, string, i) {
    var n = shortWeekdayRe.exec(string.slice(i));
    return n ? (d.w = shortWeekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }

  function parseWeekday(d, string, i) {
    var n = weekdayRe.exec(string.slice(i));
    return n ? (d.w = weekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }

  function parseShortMonth(d, string, i) {
    var n = shortMonthRe.exec(string.slice(i));
    return n ? (d.m = shortMonthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }

  function parseMonth(d, string, i) {
    var n = monthRe.exec(string.slice(i));
    return n ? (d.m = monthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }

  function parseLocaleDateTime(d, string, i) {
    return parseSpecifier(d, locale_dateTime, string, i);
  }

  function parseLocaleDate(d, string, i) {
    return parseSpecifier(d, locale_date, string, i);
  }

  function parseLocaleTime(d, string, i) {
    return parseSpecifier(d, locale_time, string, i);
  }

  function formatShortWeekday(d) {
    return locale_shortWeekdays[d.getDay()];
  }

  function formatWeekday(d) {
    return locale_weekdays[d.getDay()];
  }

  function formatShortMonth(d) {
    return locale_shortMonths[d.getMonth()];
  }

  function formatMonth(d) {
    return locale_months[d.getMonth()];
  }

  function formatPeriod(d) {
    return locale_periods[+(d.getHours() >= 12)];
  }

  function formatQuarter(d) {
    return 1 + ~~(d.getMonth() / 3);
  }

  function formatUTCShortWeekday(d) {
    return locale_shortWeekdays[d.getUTCDay()];
  }

  function formatUTCWeekday(d) {
    return locale_weekdays[d.getUTCDay()];
  }

  function formatUTCShortMonth(d) {
    return locale_shortMonths[d.getUTCMonth()];
  }

  function formatUTCMonth(d) {
    return locale_months[d.getUTCMonth()];
  }

  function formatUTCPeriod(d) {
    return locale_periods[+(d.getUTCHours() >= 12)];
  }

  function formatUTCQuarter(d) {
    return 1 + ~~(d.getUTCMonth() / 3);
  }

  return {
    format: function(specifier) {
      var f = newFormat(specifier += "", formats);
      f.toString = function() { return specifier; };
      return f;
    },
    parse: function(specifier) {
      var p = newParse(specifier += "", false);
      p.toString = function() { return specifier; };
      return p;
    },
    utcFormat: function(specifier) {
      var f = newFormat(specifier += "", utcFormats);
      f.toString = function() { return specifier; };
      return f;
    },
    utcParse: function(specifier) {
      var p = newParse(specifier += "", true);
      p.toString = function() { return specifier; };
      return p;
    }
  };
}

var pads = {"-": "", "_": " ", "0": "0"},
    numberRe = /^\s*\d+/, // note: ignores next directive
    percentRe = /^%/,
    requoteRe = /[\\^$*+?|[\]().{}]/g;

function locale_pad(value, fill, width) {
  var sign = value < 0 ? "-" : "",
      string = (sign ? -value : value) + "",
      length = string.length;
  return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
}

function requote(s) {
  return s.replace(requoteRe, "\\$&");
}

function formatRe(names) {
  return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
}

function formatLookup(names) {
  var map = {}, i = -1, n = names.length;
  while (++i < n) map[names[i].toLowerCase()] = i;
  return map;
}

function parseWeekdayNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.w = +n[0], i + n[0].length) : -1;
}

function parseWeekdayNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.u = +n[0], i + n[0].length) : -1;
}

function parseWeekNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.U = +n[0], i + n[0].length) : -1;
}

function parseWeekNumberISO(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.V = +n[0], i + n[0].length) : -1;
}

function parseWeekNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.W = +n[0], i + n[0].length) : -1;
}

function parseFullYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 4));
  return n ? (d.y = +n[0], i + n[0].length) : -1;
}

function parseYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2000), i + n[0].length) : -1;
}

function parseZone(d, string, i) {
  var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
  return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
}

function parseQuarter(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.q = n[0] * 3 - 3, i + n[0].length) : -1;
}

function parseMonthNumber(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
}

function parseDayOfMonth(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.d = +n[0], i + n[0].length) : -1;
}

function parseDayOfYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
}

function parseHour24(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.H = +n[0], i + n[0].length) : -1;
}

function parseMinutes(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.M = +n[0], i + n[0].length) : -1;
}

function parseSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.S = +n[0], i + n[0].length) : -1;
}

function parseMilliseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.L = +n[0], i + n[0].length) : -1;
}

function parseMicroseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 6));
  return n ? (d.L = Math.floor(n[0] / 1000), i + n[0].length) : -1;
}

function parseLiteralPercent(d, string, i) {
  var n = percentRe.exec(string.slice(i, i + 1));
  return n ? i + n[0].length : -1;
}

function parseUnixTimestamp(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.Q = +n[0], i + n[0].length) : -1;
}

function parseUnixTimestampSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.s = +n[0], i + n[0].length) : -1;
}

function formatDayOfMonth(d, p) {
  return locale_pad(d.getDate(), p, 2);
}

function formatHour24(d, p) {
  return locale_pad(d.getHours(), p, 2);
}

function formatHour12(d, p) {
  return locale_pad(d.getHours() % 12 || 12, p, 2);
}

function formatDayOfYear(d, p) {
  return locale_pad(1 + src_day.count(src_year(d), d), p, 3);
}

function formatMilliseconds(d, p) {
  return locale_pad(d.getMilliseconds(), p, 3);
}

function formatMicroseconds(d, p) {
  return formatMilliseconds(d, p) + "000";
}

function formatMonthNumber(d, p) {
  return locale_pad(d.getMonth() + 1, p, 2);
}

function formatMinutes(d, p) {
  return locale_pad(d.getMinutes(), p, 2);
}

function formatSeconds(d, p) {
  return locale_pad(d.getSeconds(), p, 2);
}

function formatWeekdayNumberMonday(d) {
  var day = d.getDay();
  return day === 0 ? 7 : day;
}

function formatWeekNumberSunday(d, p) {
  return locale_pad(sunday.count(src_year(d) - 1, d), p, 2);
}

function formatWeekNumberISO(d, p) {
  var day = d.getDay();
  d = (day >= 4 || day === 0) ? thursday(d) : thursday.ceil(d);
  return locale_pad(thursday.count(src_year(d), d) + (src_year(d).getDay() === 4), p, 2);
}

function formatWeekdayNumberSunday(d) {
  return d.getDay();
}

function formatWeekNumberMonday(d, p) {
  return locale_pad(monday.count(src_year(d) - 1, d), p, 2);
}

function locale_formatYear(d, p) {
  return locale_pad(d.getFullYear() % 100, p, 2);
}

function formatFullYear(d, p) {
  return locale_pad(d.getFullYear() % 10000, p, 4);
}

function formatZone(d) {
  var z = d.getTimezoneOffset();
  return (z > 0 ? "-" : (z *= -1, "+"))
      + locale_pad(z / 60 | 0, "0", 2)
      + locale_pad(z % 60, "0", 2);
}

function formatUTCDayOfMonth(d, p) {
  return locale_pad(d.getUTCDate(), p, 2);
}

function formatUTCHour24(d, p) {
  return locale_pad(d.getUTCHours(), p, 2);
}

function formatUTCHour12(d, p) {
  return locale_pad(d.getUTCHours() % 12 || 12, p, 2);
}

function formatUTCDayOfYear(d, p) {
  return locale_pad(1 + src_utcDay.count(src_utcYear(d), d), p, 3);
}

function formatUTCMilliseconds(d, p) {
  return locale_pad(d.getUTCMilliseconds(), p, 3);
}

function formatUTCMicroseconds(d, p) {
  return formatUTCMilliseconds(d, p) + "000";
}

function formatUTCMonthNumber(d, p) {
  return locale_pad(d.getUTCMonth() + 1, p, 2);
}

function formatUTCMinutes(d, p) {
  return locale_pad(d.getUTCMinutes(), p, 2);
}

function formatUTCSeconds(d, p) {
  return locale_pad(d.getUTCSeconds(), p, 2);
}

function formatUTCWeekdayNumberMonday(d) {
  var dow = d.getUTCDay();
  return dow === 0 ? 7 : dow;
}

function formatUTCWeekNumberSunday(d, p) {
  return locale_pad(utcSunday.count(src_utcYear(d) - 1, d), p, 2);
}

function formatUTCWeekNumberISO(d, p) {
  var day = d.getUTCDay();
  d = (day >= 4 || day === 0) ? utcThursday(d) : utcThursday.ceil(d);
  return locale_pad(utcThursday.count(src_utcYear(d), d) + (src_utcYear(d).getUTCDay() === 4), p, 2);
}

function formatUTCWeekdayNumberSunday(d) {
  return d.getUTCDay();
}

function formatUTCWeekNumberMonday(d, p) {
  return locale_pad(utcMonday.count(src_utcYear(d) - 1, d), p, 2);
}

function formatUTCYear(d, p) {
  return locale_pad(d.getUTCFullYear() % 100, p, 2);
}

function formatUTCFullYear(d, p) {
  return locale_pad(d.getUTCFullYear() % 10000, p, 4);
}

function formatUTCZone() {
  return "+0000";
}

function formatLiteralPercent() {
  return "%";
}

function formatUnixTimestamp(d) {
  return +d;
}

function formatUnixTimestampSeconds(d) {
  return Math.floor(+d / 1000);
}

// CONCATENATED MODULE: ./node_modules/d3-time-format/src/defaultLocale.js


var src_defaultLocale_locale;
var defaultLocale_timeFormat;
var timeParse;
var defaultLocale_utcFormat;
var utcParse;

defaultLocale_defaultLocale({
  dateTime: "%x, %X",
  date: "%-m/%-d/%Y",
  time: "%-I:%M:%S %p",
  periods: ["AM", "PM"],
  days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
  shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
  shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
});

function defaultLocale_defaultLocale(definition) {
  src_defaultLocale_locale = formatLocale(definition);
  defaultLocale_timeFormat = src_defaultLocale_locale.format;
  timeParse = src_defaultLocale_locale.parse;
  defaultLocale_utcFormat = src_defaultLocale_locale.utcFormat;
  utcParse = src_defaultLocale_locale.utcParse;
  return src_defaultLocale_locale;
}

// CONCATENATED MODULE: ./node_modules/vega-format/src/time.js






function timeMultiFormat(format, interval, spec) {
  spec = spec || {};
  if (!Object(vega_util["F" /* isObject */])(spec)) {
    Object(vega_util["n" /* error */])(`Invalid time multi-format specifier: ${spec}`);
  }

  const second = interval(SECONDS),
        minute = interval(MINUTES),
        hour = interval(HOURS),
        day = interval(DATE),
        week = interval(WEEK),
        month = interval(MONTH),
        quarter = interval(QUARTER),
        year = interval(YEAR),
        L = format(spec[MILLISECONDS] || '.%L'),
        S = format(spec[SECONDS] || ':%S'),
        M = format(spec[MINUTES] || '%I:%M'),
        H = format(spec[HOURS] || '%I %p'),
        d = format(spec[DATE] || spec[DAY] || '%a %d'),
        w = format(spec[WEEK] || '%b %d'),
        m = format(spec[MONTH] || '%B'),
        q = format(spec[QUARTER] || '%B'),
        y = format(spec[YEAR] || '%Y');

  return date => (
    second(date) < date ? L :
    minute(date) < date ? S :
    hour(date) < date ? M :
    day(date) < date ? H :
    month(date) < date ? (week(date) < date ? d : w) :
    year(date) < date ? (quarter(date) < date ? m : q) :
    y)(date);
}

function timeLocale(locale) {
  const timeFormat = memoize(locale.format),
        utcFormat = memoize(locale.utcFormat);

  return {
    timeFormat: spec => Object(vega_util["H" /* isString */])(spec)
      ? timeFormat(spec)
      : timeMultiFormat(timeFormat, timeInterval, spec),
    utcFormat: spec => Object(vega_util["H" /* isString */])(spec)
      ? utcFormat(spec)
      : timeMultiFormat(utcFormat, utcInterval, spec),
    timeParse: memoize(locale.parse),
    utcParse: memoize(locale.utcParse)
  };
}

let defaultTimeLocale;
resetTimeFormatDefaultLocale();

function resetTimeFormatDefaultLocale() {
  return defaultTimeLocale = timeLocale({
    format: defaultLocale_timeFormat,
    parse: timeParse,
    utcFormat: defaultLocale_utcFormat,
    utcParse: utcParse
  });
}

function timeFormatLocale(definition) {
  return timeLocale(formatLocale(definition));
}

function timeFormatDefaultLocale(definition) {
  return arguments.length
    ? (defaultTimeLocale = timeFormatLocale(definition))
    : defaultTimeLocale;
}

// CONCATENATED MODULE: ./node_modules/vega-format/src/locale.js






const createLocale = (number, time) => Object(vega_util["o" /* extend */])({}, number, time);

function locale_locale(numberSpec, timeSpec) {
  const number = numberSpec
    ? numberFormatLocale(numberSpec)
    : numberFormatDefaultLocale();

  const time = timeSpec
    ? timeFormatLocale(timeSpec)
    : timeFormatDefaultLocale();

  return createLocale(number, time);
}

function locale_defaultLocale(numberSpec, timeSpec) {
  const args = arguments.length;
  if (args && args !== 2) {
    Object(vega_util["n" /* error */])('defaultLocale expects either zero or two arguments.');
  }

  return args
    ? createLocale(
        numberFormatDefaultLocale(numberSpec),
        timeFormatDefaultLocale(timeSpec)
      )
    : createLocale(
        numberFormatDefaultLocale(),
        timeFormatDefaultLocale()
      );
}

function resetDefaultLocale() {
  resetNumberFormatDefaultLocale();
  resetTimeFormatDefaultLocale();
  return locale_defaultLocale();
}

// CONCATENATED MODULE: ./node_modules/vega-format/index.js






// CONCATENATED MODULE: ./node_modules/vega-loader/src/read.js





/* harmony default export */ var read = (function(data, schema, timeParser, utcParser) {
  schema = schema || {};

  const reader = formats_formats(schema.type || 'json');
  if (!reader) Object(vega_util["n" /* error */])('Unknown data format type: ' + schema.type);

  data = reader(data, schema);
  if (schema.parse) read_parse(data, schema.parse, timeParser, utcParser);

  if (Object(vega_util["v" /* hasOwnProperty */])(data, 'columns')) delete data.columns;
  return data;
});

function read_parse(data, types, timeParser, utcParser) {
  if (!data.length) return; // early exit for empty data

  const locale = timeFormatDefaultLocale();
  timeParser = timeParser || locale.timeParse;
  utcParser = utcParser || locale.utcParse;

  var fields = data.columns || Object.keys(data[0]),
      parsers, datum, field, i, j, n, m;

  if (types === 'auto') types = inferTypes(data, fields);

  fields = Object.keys(types);
  parsers = fields.map(function(field) {
    var type = types[field],
        parts, pattern;

    if (type && (type.startsWith('date:') || type.startsWith('utc:'))) {
      parts = type.split(/:(.+)?/, 2);  // split on first :
      pattern = parts[1];

      if ((pattern[0] === '\'' && pattern[pattern.length-1] === '\'') ||
          (pattern[0] === '"'  && pattern[pattern.length-1] === '"')) {
        pattern = pattern.slice(1, -1);
      }

      const parse = parts[0] === 'utc' ? utcParser : timeParser;
      return parse(pattern);
    }

    if (!typeParsers[type]) {
      throw Error('Illegal format pattern: ' + field + ':' + type);
    }

    return typeParsers[type];
  });

  for (i=0, n=data.length, m=fields.length; i<n; ++i) {
    datum = data[i];
    for (j=0; j<m; ++j) {
      field = fields[j];
      datum[field] = parsers[j](datum[field]);
    }
  }
}

// CONCATENATED MODULE: ./node_modules/vega-loader/index.browser.js


var index_browser_loader = src_loader(
  typeof fetch !== 'undefined' && fetch, // use built-in fetch API
  null // no file system access
);







// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/load.js



function load_parse(data, format) {
  const locale = this.locale();
  return read(data, format, locale.timeParse, locale.utcParse);
}

/**
 * Ingests new data into the dataflow. First parses the data using the
 * vega-loader read method, then pulses a changeset to the target operator.
 * @param {Operator} target - The Operator to target with ingested data,
 *   typically a Collect transform instance.
 * @param {*} data - The input data, prior to parsing. For JSON this may
 *   be a string or an object. For CSV, TSV, etc should be a string.
 * @param {object} format - The data format description for parsing
 *   loaded data. This object is passed to the vega-loader read method.
 * @returns {Dataflow}
 */
function load_ingest(target, data, format) {
  data = this.parse(data, format);
  return this.pulse(target, this.changeset().insert(data));
}

/**
 * Request data from an external source, parse it, and return a Promise.
 * @param {string} url - The URL from which to load the data. This string
 *   is passed to the vega-loader load method.
 * @param {object} [format] - The data format description for parsing
 *   loaded data. This object is passed to the vega-loader read method.
 * @return {Promise} A Promise that resolves upon completion of the request.
 *   The resolved object contains the following properties:
 *   - data: an array of parsed data (or null upon error)
 *   - status: a code for success (0), load fail (-1), or parse fail (-2)
 */
async function request(url, format) {
  const df = this;
  let status = 0, data;

  try {
    data = await df.loader().load(url, {
      context: 'dataflow',
      response: responseType(format && format.type)
    });
    try {
      data = df.parse(data, format);
    } catch (err) {
      status = -2;
      df.warn('Data ingestion failed', url, err);
    }
  } catch (err) {
    status = -1;
    df.warn('Loading failed', url, err);
  }

  return {data, status};
}

async function preload(target, url, format) {
  const df = this,
        pending = df._pending || loadPending(df);

  pending.requests += 1;

  const res = await df.request(url, format);
  df.pulse(target, df.changeset().remove(vega_util["gb" /* truthy */]).insert(res.data || []));

  pending.done();
  return res;
}

function loadPending(df) {
  var pending = new Promise(function(a) { accept = a; }),
      accept;

  pending.requests = 0;

  pending.done = function() {
    if (--pending.requests === 0) {
      df._pending = null;
      accept(df);
    }
  };

  return (df._pending = pending);
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/on.js




var on_SKIP = {skip: true};

/**
 * Perform operator updates in response to events. Applies an
 * update function to compute a new operator value. If the update function
 * returns a {@link ChangeSet}, the operator will be pulsed with those tuple
 * changes. Otherwise, the operator value will be updated to the return value.
 * @param {EventStream|Operator} source - The event source to react to.
 *   This argument can be either an EventStream or an Operator.
 * @param {Operator|function(object):Operator} target - The operator to update.
 *   This argument can either be an Operator instance or (if the source
 *   argument is an EventStream), a function that accepts an event object as
 *   input and returns an Operator to target.
 * @param {function(Parameters,Event): *} [update] - Optional update function
 *   to compute the new operator value, or a literal value to set. Update
 *   functions expect to receive a parameter object and event as arguments.
 *   This function can either return a new operator value or (if the source
 *   argument is an EventStream) a {@link ChangeSet} instance to pulse
 *   the target operator with tuple changes.
 * @param {object} [params] - The update function parameters.
 * @param {object} [options] - Additional options hash. If not overridden,
 *   updated operators will be skipped by default.
 * @param {boolean} [options.skip] - If true, the operator will
 *  be skipped: it will not be evaluated, but its dependents will be.
 * @param {boolean} [options.force] - If true, the operator will
 *   be re-evaluated even if its value has not changed.
 * @return {Dataflow}
 */
/* harmony default export */ var dataflow_on = (function(source, target, update, params, options) {
  var fn = source instanceof Operator ? onOperator : onStream;
  fn(this, source, target, update, params, options);
  return this;
});

function onStream(df, stream, target, update, params, options) {
  var opt = Object(vega_util["o" /* extend */])({}, options, on_SKIP), func, op;

  if (!Object(vega_util["D" /* isFunction */])(target)) target = Object(vega_util["l" /* constant */])(target);

  if (update === undefined) {
    func = e => df.touch(target(e));
  } else if (Object(vega_util["D" /* isFunction */])(update)) {
    op = new Operator(null, update, params, false);
    func = e => {
      op.evaluate(e);
      const t = target(e), v = op.value;
      isChangeSet(v) ? df.pulse(t, v, options) : df.update(t, v, opt);
    };
  } else {
    func = e => df.update(target(e), update, opt);
  }

  stream.apply(func);
}

function onOperator(df, source, target, update, params, options) {
  if (update === undefined) {
    source.targets().add(target);
  } else {
    const opt = options || {},
          op = new Operator(null, updater(target, update), params, false);
    op.modified(opt.force);
    op.rank = source.rank;       // immediately follow source
    source.targets().add(op);    // add dependency

    if (target) {
      op.skip(true);             // skip first invocation
      op.value = target.value;   // initialize value
      op.targets().add(target);  // chain dependencies
      df.connect(target, [op]);  // rerank as needed, #1672
    }
  }
}

function updater(target, update) {
  update = Object(vega_util["D" /* isFunction */])(update) ? update : Object(vega_util["l" /* constant */])(update);
  return target
    ? function(_, pulse) {
        const value = update(_, pulse);
        if (!target.skip()) {
          target.skip(value !== this.value).value = value;
        }
        return value;
      }
    : update;
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/rank.js


/**
 * Assigns a rank to an operator. Ranks are assigned in increasing order
 * by incrementing an internal rank counter.
 * @param {Operator} op - The operator to assign a rank.
 */
function rank(op) {
  op.rank = ++this._rank;
}

/**
 * Re-ranks an operator and all downstream target dependencies. This
 * is necessary when upstream dependencies of higher rank are added to
 * a target operator.
 * @param {Operator} op - The operator to re-rank.
 */
function rerank(op) {
  var queue = [op],
      cur, list, i;

  while (queue.length) {
    this.rank(cur = queue.pop());
    if (list = cur._targets) {
      for (i=list.length; --i >= 0;) {
        queue.push(cur = list[i]);
        if (cur === op) Object(vega_util["n" /* error */])('Cycle detected in dataflow graph.');
      }
    }
  }
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/Pulse.js



/**
 * Sentinel value indicating pulse propagation should stop.
 */
const StopPropagation = {};

// Pulse visit type flags
const ADD       = (1 << 0),
      REM       = (1 << 1),
      MOD       = (1 << 2),
      ADD_REM   = ADD | REM,
      ADD_MOD   = ADD | MOD,
      ALL       = ADD | REM | MOD,
      REFLOW    = (1 << 3),
      SOURCE    = (1 << 4),
      NO_SOURCE = (1 << 5),
      NO_FIELDS = (1 << 6);

/**
 * A Pulse enables inter-operator communication during a run of the
 * dataflow graph. In addition to the current timestamp, a pulse may also
 * contain a change-set of added, removed or modified data tuples, as well as
 * a pointer to a full backing data source. Tuple change sets may not
 * be fully materialized; for example, to prevent needless array creation
 * a change set may include larger arrays and corresponding filter functions.
 * The pulse provides a {@link visit} method to enable proper and efficient
 * iteration over requested data tuples.
 *
 * In addition, each pulse can track modification flags for data tuple fields.
 * Responsible transform operators should call the {@link modifies} method to
 * indicate changes to data fields. The {@link modified} method enables
 * querying of this modification state.
 *
 * @constructor
 * @param {Dataflow} dataflow - The backing dataflow instance.
 * @param {number} stamp - The current propagation timestamp.
 * @param {string} [encode] - An optional encoding set name, which is then
 *   accessible as Pulse.encode. Operators can respond to (or ignore) this
 *   setting as appropriate. This parameter can be used in conjunction with
 *   the Encode transform in the vega-encode module.
 */
function Pulse(dataflow, stamp, encode) {
  this.dataflow = dataflow;
  this.stamp = stamp == null ? -1 : stamp;
  this.add = [];
  this.rem = [];
  this.mod = [];
  this.fields = null;
  this.encode = encode || null;
}

const Pulse_prototype = Pulse.prototype;

/**
 * Sentinel value indicating pulse propagation should stop.
 */
Pulse_prototype.StopPropagation = StopPropagation;

/**
 * Boolean flag indicating ADD (added) tuples.
 */
Pulse_prototype.ADD = ADD;

/**
 * Boolean flag indicating REM (removed) tuples.
 */
Pulse_prototype.REM = REM;

/**
 * Boolean flag indicating MOD (modified) tuples.
 */
Pulse_prototype.MOD = MOD;

/**
 * Boolean flag indicating ADD (added) and REM (removed) tuples.
 */
Pulse_prototype.ADD_REM = ADD_REM;

/**
 * Boolean flag indicating ADD (added) and MOD (modified) tuples.
 */
Pulse_prototype.ADD_MOD = ADD_MOD;

/**
 * Boolean flag indicating ADD, REM and MOD tuples.
 */
Pulse_prototype.ALL = ALL;

/**
 * Boolean flag indicating all tuples in a data source
 * except for the ADD, REM and MOD tuples.
 */
Pulse_prototype.REFLOW = REFLOW;

/**
 * Boolean flag indicating a 'pass-through' to a
 * backing data source, ignoring ADD, REM and MOD tuples.
 */
Pulse_prototype.SOURCE = SOURCE;

/**
 * Boolean flag indicating that source data should be
 * suppressed when creating a forked pulse.
 */
Pulse_prototype.NO_SOURCE = NO_SOURCE;

/**
 * Boolean flag indicating that field modifications should be
 * suppressed when creating a forked pulse.
 */
Pulse_prototype.NO_FIELDS = NO_FIELDS;

/**
 * Creates a new pulse based on the values of this pulse.
 * The dataflow, time stamp and field modification values are copied over.
 * By default, new empty ADD, REM and MOD arrays are created.
 * @param {number} flags - Integer of boolean flags indicating which (if any)
 *   tuple arrays should be copied to the new pulse. The supported flag values
 *   are ADD, REM and MOD. Array references are copied directly: new array
 *   instances are not created.
 * @return {Pulse} - The forked pulse instance.
 * @see init
 */
Pulse_prototype.fork = function(flags) {
  return new Pulse(this.dataflow).init(this, flags);
};

/**
 * Creates a copy of this pulse with new materialized array
 * instances for the ADD, REM, MOD, and SOURCE arrays.
 * The dataflow, time stamp and field modification values are copied over.
 * @return {Pulse} - The cloned pulse instance.
 * @see init
 */
Pulse_prototype.clone = function() {
  const p = this.fork(ALL);
  p.add = p.add.slice();
  p.rem = p.rem.slice();
  p.mod = p.mod.slice();
  if (p.source) p.source = p.source.slice();
  return p.materialize(ALL | SOURCE);
};

/**
 * Returns a pulse that adds all tuples from a backing source. This is
 * useful for cases where operators are added to a dataflow after an
 * upstream data pipeline has already been processed, ensuring that
 * new operators can observe all tuples within a stream.
 * @return {Pulse} - A pulse instance with all source tuples included
 *   in the add array. If the current pulse already has all source
 *   tuples in its add array, it is returned directly. If the current
 *   pulse does not have a backing source, it is returned directly.
 */
Pulse_prototype.addAll = function() {
  let p = this;
  if (!p.source || p.source.length === p.add.length) {
    return p;
  } else {
    p = new Pulse(this.dataflow).init(this);
    p.add = p.source;
    return p;
  }
};

/**
 * Initialize this pulse based on the values of another pulse. This method
 * is used internally by {@link fork} to initialize a new forked tuple.
 * The dataflow, time stamp and field modification values are copied over.
 * By default, new empty ADD, REM and MOD arrays are created.
 * @param {Pulse} src - The source pulse to copy from.
 * @param {number} flags - Integer of boolean flags indicating which (if any)
 *   tuple arrays should be copied to the new pulse. The supported flag values
 *   are ADD, REM and MOD. Array references are copied directly: new array
 *   instances are not created. By default, source data arrays are copied
 *   to the new pulse. Use the NO_SOURCE flag to enforce a null source.
 * @return {Pulse} - Returns this Pulse instance.
 */
Pulse_prototype.init = function(src, flags) {
  const p = this;
  p.stamp = src.stamp;
  p.encode = src.encode;

  if (src.fields && !(flags & NO_FIELDS)) {
    p.fields = src.fields;
  }

  if (flags & ADD) {
    p.addF = src.addF;
    p.add = src.add;
  } else {
    p.addF = null;
    p.add = [];
  }

  if (flags & REM) {
    p.remF = src.remF;
    p.rem = src.rem;
  } else {
    p.remF = null;
    p.rem = [];
  }

  if (flags & MOD) {
    p.modF = src.modF;
    p.mod = src.mod;
  } else {
    p.modF = null;
    p.mod = [];
  }

  if (flags & NO_SOURCE) {
    p.srcF = null;
    p.source = null;
  } else {
    p.srcF = src.srcF;
    p.source = src.source;
    if (src.cleans) p.cleans = src.cleans;
  }

  return p;
};

/**
 * Schedules a function to run after pulse propagation completes.
 * @param {function} func - The function to run.
 */
Pulse_prototype.runAfter = function(func) {
  this.dataflow.runAfter(func);
};

/**
 * Indicates if tuples have been added, removed or modified.
 * @param {number} [flags] - The tuple types (ADD, REM or MOD) to query.
 *   Defaults to ALL, returning true if any tuple type has changed.
 * @return {boolean} - Returns true if one or more queried tuple types have
 *   changed, false otherwise.
 */
Pulse_prototype.changed = function(flags) {
  var f = flags || ALL;
  return ((f & ADD) && this.add.length)
      || ((f & REM) && this.rem.length)
      || ((f & MOD) && this.mod.length);
};

/**
 * Forces a "reflow" of tuple values, such that all tuples in the backing
 * source are added to the MOD set, unless already present in the ADD set.
 * @param {boolean} [fork=false] - If true, returns a forked copy of this
 *   pulse, and invokes reflow on that derived pulse.
 * @return {Pulse} - The reflowed pulse instance.
 */
Pulse_prototype.reflow = function(fork) {
  if (fork) return this.fork(ALL).reflow();

  var len = this.add.length,
      src = this.source && this.source.length;
  if (src && src !== len) {
    this.mod = this.source;
    if (len) this.filter(MOD, Pulse_filter(this, ADD));
  }
  return this;
};

/**
 * Get/set metadata to pulse requesting garbage collection
 * to reclaim currently unused resources.
 */
Pulse_prototype.clean = function(value) {
  if (arguments.length) {
    this.cleans = !!value;
    return this;
  } else {
    return this.cleans;
  }
};

/**
 * Marks one or more data field names as modified to assist dependency
 * tracking and incremental processing by transform operators.
 * @param {string|Array<string>} _ - The field(s) to mark as modified.
 * @return {Pulse} - This pulse instance.
 */
Pulse_prototype.modifies = function(_) {
  var hash = this.fields || (this.fields = {});
  if (Object(vega_util["A" /* isArray */])(_)) {
    _.forEach(f => hash[f] = true);
  } else {
    hash[_] = true;
  }
  return this;
};

/**
 * Checks if one or more data fields have been modified during this pulse
 * propagation timestamp.
 * @param {string|Array<string>} _ - The field(s) to check for modified.
 * @param {boolean} nomod - If true, will check the modified flag even if
 *   no mod tuples exist. If false (default), mod tuples must be present.
 * @return {boolean} - Returns true if any of the provided fields has been
 *   marked as modified, false otherwise.
 */
Pulse_prototype.modified = function(_, nomod) {
  var fields = this.fields;
  return !((nomod || this.mod.length) && fields) ? false
    : !arguments.length ? !!fields
    : Object(vega_util["A" /* isArray */])(_) ? _.some(f => fields[f])
    : fields[_];
};

/**
 * Adds a filter function to one more tuple sets. Filters are applied to
 * backing tuple arrays, to determine the actual set of tuples considered
 * added, removed or modified. They can be used to delay materialization of
 * a tuple set in order to avoid expensive array copies. In addition, the
 * filter functions can serve as value transformers: unlike standard predicate
 * function (which return boolean values), Pulse filters should return the
 * actual tuple value to process. If a tuple set is already filtered, the
 * new filter function will be appended into a conjuntive ('and') query.
 * @param {number} flags - Flags indicating the tuple set(s) to filter.
 * @param {function(*):object} filter - Filter function that will be applied
 *   to the tuple set array, and should return a data tuple if the value
 *   should be included in the tuple set, and falsy (or null) otherwise.
 * @return {Pulse} - Returns this pulse instance.
 */
Pulse_prototype.filter = function(flags, filter) {
  var p = this;
  if (flags & ADD) p.addF = addFilter(p.addF, filter);
  if (flags & REM) p.remF = addFilter(p.remF, filter);
  if (flags & MOD) p.modF = addFilter(p.modF, filter);
  if (flags & SOURCE) p.srcF = addFilter(p.srcF, filter);
  return p;
};

function addFilter(a, b) {
  return a
    ? (t, i) => a(t, i) && b(t, i)
    : b;
}

/**
 * Materialize one or more tuple sets in this pulse. If the tuple set(s) have
 * a registered filter function, it will be applied and the tuple set(s) will
 * be replaced with materialized tuple arrays.
 * @param {number} flags - Flags indicating the tuple set(s) to materialize.
 * @return {Pulse} - Returns this pulse instance.
 */
Pulse_prototype.materialize = function(flags) {
  flags = flags || ALL;
  var p = this;
  if ((flags & ADD) && p.addF) {
    p.add = materialize(p.add, p.addF);
    p.addF = null;
  }
  if ((flags & REM) && p.remF) {
    p.rem = materialize(p.rem, p.remF);
    p.remF = null;
  }
  if ((flags & MOD) && p.modF) {
    p.mod = materialize(p.mod, p.modF);
    p.modF = null;
  }
  if ((flags & SOURCE) && p.srcF) {
    p.source = p.source.filter(p.srcF);
    p.srcF = null;
  }
  return p;
};

function materialize(data, filter) {
  var out = [];
  Object(vega_util["ib" /* visitArray */])(data, filter, _ => out.push(_));
  return out;
}

function Pulse_filter(pulse, flags) {
  var map = {};
  pulse.visit(flags, function(t) { map[tupleid(t)] = 1; });
  return t => map[tupleid(t)] ? null : t;
}

/**
 * Visit one or more tuple sets in this pulse.
 * @param {number} flags - Flags indicating the tuple set(s) to visit.
 *   Legal values are ADD, REM, MOD and SOURCE (if a backing data source
 *   has been set).
 * @param {function(object):*} - Visitor function invoked per-tuple.
 * @return {Pulse} - Returns this pulse instance.
 */
Pulse_prototype.visit = function(flags, visitor) {
  var p = this, v = visitor, src, sum;

  if (flags & SOURCE) {
    Object(vega_util["ib" /* visitArray */])(p.source, p.srcF, v);
    return p;
  }

  if (flags & ADD) Object(vega_util["ib" /* visitArray */])(p.add, p.addF, v);
  if (flags & REM) Object(vega_util["ib" /* visitArray */])(p.rem, p.remF, v);
  if (flags & MOD) Object(vega_util["ib" /* visitArray */])(p.mod, p.modF, v);

  if ((flags & REFLOW) && (src = p.source)) {
    sum = p.add.length + p.mod.length;
    if (sum === src.length) {
      // do nothing
    } else if (sum) {
      Object(vega_util["ib" /* visitArray */])(src, Pulse_filter(p, ADD_MOD), v);
    } else {
      // if no add/rem/mod tuples, visit source
      Object(vega_util["ib" /* visitArray */])(src, p.srcF, v);
    }
  }

  return p;
};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/MultiPulse.js



/**
 * Represents a set of multiple pulses. Used as input for operators
 * that accept multiple pulses at a time. Contained pulses are
 * accessible via the public "pulses" array property. This pulse doe
 * not carry added, removed or modified tuples directly. However,
 * the visit method can be used to traverse all such tuples contained
 * in sub-pulses with a timestamp matching this parent multi-pulse.
 * @constructor
 * @param {Dataflow} dataflow - The backing dataflow instance.
 * @param {number} stamp - The timestamp.
 * @param {Array<Pulse>} pulses - The sub-pulses for this multi-pulse.
 */
function MultiPulse(dataflow, stamp, pulses, encode) {
  var p = this,
      c = 0,
      pulse, hash, i, n, f;

  this.dataflow = dataflow;
  this.stamp = stamp;
  this.fields = null;
  this.encode = encode || null;
  this.pulses = pulses;

  for (i=0, n=pulses.length; i<n; ++i) {
    pulse = pulses[i];
    if (pulse.stamp !== stamp) continue;

    if (pulse.fields) {
      hash = p.fields || (p.fields = {});
      for (f in pulse.fields) { hash[f] = 1; }
    }

    if (pulse.changed(p.ADD)) c |= p.ADD;
    if (pulse.changed(p.REM)) c |= p.REM;
    if (pulse.changed(p.MOD)) c |= p.MOD;
  }

  this.changes = c;
}

var MultiPulse_prototype = Object(vega_util["y" /* inherits */])(MultiPulse, Pulse);

/**
 * Creates a new pulse based on the values of this pulse.
 * The dataflow, time stamp and field modification values are copied over.
 * @return {Pulse}
 */
MultiPulse_prototype.fork = function(flags) {
  var p = new Pulse(this.dataflow).init(this, flags & this.NO_FIELDS);
  if (flags !== undefined) {
    if (flags & p.ADD) {
      this.visit(p.ADD, function(t) { return p.add.push(t); });
    }
    if (flags & p.REM) {
      this.visit(p.REM, function(t) { return p.rem.push(t); });
    }
    if (flags & p.MOD) {
      this.visit(p.MOD, function(t) { return p.mod.push(t); });
    }
  }
  return p;
};

MultiPulse_prototype.changed = function(flags) {
  return this.changes & flags;
};

MultiPulse_prototype.modified = function(_) {
  var p = this, fields = p.fields;
  return !(fields && (p.changes & p.MOD)) ? 0
    : Object(vega_util["A" /* isArray */])(_) ? _.some(function(f) { return fields[f]; })
    : fields[_];
};

MultiPulse_prototype.filter = function() {
  Object(vega_util["n" /* error */])('MultiPulse does not support filtering.');
};

MultiPulse_prototype.materialize = function() {
  Object(vega_util["n" /* error */])('MultiPulse does not support materialization.');
};

MultiPulse_prototype.visit = function(flags, visitor) {
  var p = this,
      pulses = p.pulses,
      n = pulses.length,
      i = 0;

  if (flags & p.SOURCE) {
    for (; i<n; ++i) {
      pulses[i].visit(flags, visitor);
    }
  } else {
    for (; i<n; ++i) {
      if (pulses[i].stamp === p.stamp) {
        pulses[i].visit(flags, visitor);
      }
    }
  }

  return p;
};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/run.js
/* eslint-disable require-atomic-updates */






/**
 * Evaluates the dataflow and returns a Promise that resolves when pulse
 * propagation completes. This method will increment the current timestamp
 * and process all updated, pulsed and touched operators. When invoked for
 * the first time, all registered operators will be processed. This method
 * should not be invoked by third-party clients, use {@link runAsync} or
 * {@link run} instead.
 * @param {string} [encode] - The name of an encoding set to invoke during
 *   propagation. This value is added to generated Pulse instances;
 *   operators can then respond to (or ignore) this setting as appropriate.
 *   This parameter can be used in conjunction with the Encode transform in
 *   the vega-encode package.
 * @param {function} [prerun] - An optional callback function to invoke
 *   immediately before dataflow evaluation commences.
 * @param {function} [postrun] - An optional callback function to invoke
 *   after dataflow evaluation completes. The callback will be invoked
 *   after those registered via {@link runAfter}.
 * @return {Promise} - A promise that resolves to this dataflow after
 *   evaluation completes.
 */
async function evaluate(encode, prerun, postrun) {
  const df = this,
        async = [];

  // if the pulse value is set, this is a re-entrant call
  if (df._pulse) return reentrant(df);

  // wait for pending datasets to load
  if (df._pending) await df._pending;

  // invoke prerun function, if provided
  if (prerun) await asyncCallback(df, prerun);

  // exit early if there are no updates
  if (!df._touched.length) {
    df.debug('Dataflow invoked, but nothing to do.');
    return df;
  }

  // increment timestamp clock
  const stamp = ++df._clock;

  // set the current pulse
  df._pulse = new Pulse(df, stamp, encode);

  // initialize priority queue, reset touched operators
  df._touched.forEach(op => df._enqueue(op, true));
  df._touched = UniqueList(vega_util["w" /* id */]);

  let count = 0, op, next, error;

  try {
    while (df._heap.size() > 0) {
      // dequeue operator with highest priority
      op = df._heap.pop();

      // re-queue if rank changed
      if (op.rank !== op.qrank) {
        df._enqueue(op, true);
        continue;
      }

      // otherwise, evaluate the operator
      next = op.run(df._getPulse(op, encode));

      if (next.then) {
        // await if operator returns a promise directly
        next = await next;
      } else if (next.async) {
        // queue parallel asynchronous execution
        async.push(next.async);
        next = StopPropagation;
      }

      // propagate evaluation, enqueue dependent operators
      if (next !== StopPropagation) {
        if (op._targets) op._targets.forEach(op => df._enqueue(op));
      }

      // increment visit counter
      ++count;
    }
  } catch (err) {
    df._heap.clear();
    error = err;
  }

  // reset pulse map
  df._input = {};
  df._pulse = null;

  df.debug(`Pulse ${stamp}: ${count} operators`);

  if (error) {
    df._postrun = [];
    df.error(error);
  }

  // invoke callbacks queued via runAfter
  if (df._postrun.length) {
    const pr = df._postrun.sort((a, b) => b.priority - a.priority);
    df._postrun = [];
    for (let i=0; i<pr.length; ++i) {
      await asyncCallback(df, pr[i].callback);
    }
  }

  // invoke postrun function, if provided
  if (postrun) await asyncCallback(df, postrun);

  // handle non-blocking asynchronous callbacks
  if (async.length) {
    Promise.all(async)
      .then(cb => df.runAsync(null, () => {
        cb.forEach(f => { try { f(df); } catch (err) { df.error(err); } });
      }));
  }

  return df;
}

/**
 * Queues dataflow evaluation to run once any other queued evaluations have
 * completed and returns a Promise that resolves when the queued pulse
 * propagation completes. If provided, a callback function will be invoked
 * immediately before evaluation commences. This method will ensure a
 * separate evaluation is invoked for each time it is called.
 * @param {string} [encode] - The name of an encoding set to invoke during
 *   propagation. This value is added to generated Pulse instances;
 *   operators can then respond to (or ignore) this setting as appropriate.
 *   This parameter can be used in conjunction with the Encode transform in
 *   the vega-encode package.
 * @param {function} [prerun] - An optional callback function to invoke
 *   immediately before dataflow evaluation commences.
 * @param {function} [postrun] - An optional callback function to invoke
 *   after dataflow evaluation completes. The callback will be invoked
 *   after those registered via {@link runAfter}.
 * @return {Promise} - A promise that resolves to this dataflow after
 *   evaluation completes.
 */
async function runAsync(encode, prerun, postrun) {
  // await previously queued functions
  while (this._running) await this._running;

  // run dataflow, manage running promise
  const clear = () => this._running = null;
  (this._running = this.evaluate(encode, prerun, postrun))
    .then(clear, clear);

  return this._running;
}

/**
 * Requests dataflow evaluation and the immediately returns this dataflow
 * instance. If there are pending data loading or other asynchronous
 * operations, the dataflow will evaluate asynchronously after this method
 * has been invoked. To track when dataflow evaluation completes, use the
 * {@link runAsync} method instead. This method will raise an error if
 * invoked while the dataflow is already in the midst of evaluation.
 * @param {string} [encode] - The name of an encoding set to invoke during
 *   propagation. This value is added to generated Pulse instances;
 *   operators can then respond to (or ignore) this setting as appropriate.
 *   This parameter can be used in conjunction with the Encode transform in
 *   the vega-encode module.
 * @param {function} [prerun] - An optional callback function to invoke
 *   immediately before dataflow evaluation commences.
 * @param {function} [postrun] - An optional callback function to invoke
 *   after dataflow evaluation completes. The callback will be invoked
 *   after those registered via {@link runAfter}.
 * @return {Dataflow} - This dataflow instance.
 */
function run_run(encode, prerun, postrun) {
  return this._pulse ? reentrant(this)
    : (this.evaluate(encode, prerun, postrun), this);
}

/**
 * Schedules a callback function to be invoked after the current pulse
 * propagation completes. If no propagation is currently occurring,
 * the function is invoked immediately. Callbacks scheduled via runAfter
 * are invoked immediately upon completion of the current cycle, before
 * any request queued via runAsync. This method is primarily intended for
 * internal use. Third-party callers using runAfter to schedule a callback
 * that invokes {@link run} or {@link runAsync} should not use this method,
 * but instead use {@link runAsync} with prerun or postrun arguments.
 * @param {function(Dataflow)} callback - The callback function to run.
 *   The callback will be invoked with this Dataflow instance as its
 *   sole argument.
 * @param {boolean} enqueue - A boolean flag indicating that the
 *   callback should be queued up to run after the next propagation
 *   cycle, suppressing immediate invocation when propagation is not
 *   currently occurring.
 * @param {number} [priority] - A priority value used to sort registered
 *   callbacks to determine execution order. This argument is intended
 *   for internal Vega use only.
 */
function runAfter(callback, enqueue, priority) {
  if (this._pulse || enqueue) {
    // pulse propagation is currently running, queue to run after
    this._postrun.push({
      priority: priority || 0,
      callback: callback
    });
  } else {
    // pulse propagation already complete, invoke immediately
    try { callback(this); } catch (err) { this.error(err); }
  }
}

/**
 * Raise an error for re-entrant dataflow evaluation.
 */
function reentrant(df) {
  df.error('Dataflow already running. Use runAsync() to chain invocations.');
  return df;
}

/**
 * Enqueue an operator into the priority queue for evaluation. The operator
 * will be enqueued if it has no registered pulse for the current cycle, or if
 * the force argument is true. Upon enqueue, this method also sets the
 * operator's qrank to the current rank value.
 * @param {Operator} op - The operator to enqueue.
 * @param {boolean} [force] - A flag indicating if the operator should be
 *   forceably added to the queue, even if it has already been previously
 *   enqueued during the current pulse propagation. This is useful when the
 *   dataflow graph is dynamically modified and the operator rank changes.
 */
function enqueue(op, force) {
  var q = op.stamp < this._clock;
  if (q) op.stamp = this._clock;
  if (q || force) {
    op.qrank = op.rank;
    this._heap.push(op);
  }
}

/**
 * Provide a correct pulse for evaluating an operator. If the operator has an
 * explicit source operator, we will try to pull the pulse(s) from it.
 * If there is an array of source operators, we build a multi-pulse.
 * Otherwise, we return a current pulse with correct source data.
 * If the pulse is the pulse map has an explicit target set, we use that.
 * Else if the pulse on the upstream source operator is current, we use that.
 * Else we use the pulse from the pulse map, but copy the source tuple array.
 * @param {Operator} op - The operator for which to get an input pulse.
 * @param {string} [encode] - An (optional) encoding set name with which to
 *   annotate the returned pulse. See {@link run} for more information.
 */
function getPulse(op, encode) {
  var s = op.source,
      stamp = this._clock;

  return s && Object(vega_util["A" /* isArray */])(s)
    ? new MultiPulse(this, stamp, s.map(_ => _.pulse), encode)
    : this._input[op.id] || singlePulse(this._pulse, s && s.pulse);
}

function singlePulse(p, s) {
  if (s && s.stamp === p.stamp) {
    return s;
  }

  p = p.fork();
  if (s && s !== StopPropagation) {
    p.source = s.source;
  }
  return p;
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/update.js


var NO_OPT = {skip: false, force: false};

/**
 * Touches an operator, scheduling it to be evaluated. If invoked outside of
 * a pulse propagation, the operator will be evaluated the next time this
 * dataflow is run. If invoked in the midst of pulse propagation, the operator
 * will be queued for evaluation if and only if the operator has not yet been
 * evaluated on the current propagation timestamp.
 * @param {Operator} op - The operator to touch.
 * @param {object} [options] - Additional options hash.
 * @param {boolean} [options.skip] - If true, the operator will
 *   be skipped: it will not be evaluated, but its dependents will be.
 * @return {Dataflow}
 */
function update_touch(op, options) {
  var opt = options || NO_OPT;
  if (this._pulse) {
    // if in midst of propagation, add to priority queue
    this._enqueue(op);
  } else {
    // otherwise, queue for next propagation
    this._touched.add(op);
  }
  if (opt.skip) op.skip(true);
  return this;
}

/**
 * Updates the value of the given operator.
 * @param {Operator} op - The operator to update.
 * @param {*} value - The value to set.
 * @param {object} [options] - Additional options hash.
 * @param {boolean} [options.force] - If true, the operator will
 *   be re-evaluated even if its value has not changed.
 * @param {boolean} [options.skip] - If true, the operator will
 *   be skipped: it will not be evaluated, but its dependents will be.
 * @return {Dataflow}
 */
function update_update(op, value, options) {
  var opt = options || NO_OPT;
  if (op.set(value) || opt.force) {
    this.touch(op, opt);
  }
  return this;
}

/**
 * Pulses an operator with a changeset of tuples. If invoked outside of
 * a pulse propagation, the pulse will be applied the next time this
 * dataflow is run. If invoked in the midst of pulse propagation, the pulse
 * will be added to the set of active pulses and will be applied if and
 * only if the target operator has not yet been evaluated on the current
 * propagation timestamp.
 * @param {Operator} op - The operator to pulse.
 * @param {ChangeSet} value - The tuple changeset to apply.
 * @param {object} [options] - Additional options hash.
 * @param {boolean} [options.skip] - If true, the operator will
 *   be skipped: it will not be evaluated, but its dependents will be.
 * @return {Dataflow}
 */
function update_pulse(op, changeset, options) {
  this.touch(op, options || NO_OPT);

  var p = new Pulse(this, this._clock + (this._pulse ? 0 : 1)),
      t = op.pulse && op.pulse.source || [];

  p.target = op;
  this._input[op.id] = changeset.pulse(p, t);

  return this;
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/util/Heap.js
function Heap(cmp) {
  var nodes = [];
  return {
    clear: () => nodes = [],
    size: () => nodes.length,
    peek: () => nodes[0],
    push: x => {
      nodes.push(x);
      return siftdown(nodes, 0, nodes.length - 1, cmp);
    },
    pop: () => {
      var last = nodes.pop(), item;
      if (nodes.length) {
        item = nodes[0];
        nodes[0] = last;
        siftup(nodes, 0, cmp);
      } else {
        item = last;
      }
      return item;
    }
  };
}

function siftdown(array, start, idx, cmp) {
  var item, parent, pidx;

  item = array[idx];
  while (idx > start) {
    pidx = (idx - 1) >> 1;
    parent = array[pidx];
    if (cmp(item, parent) < 0) {
      array[idx] = parent;
      idx = pidx;
      continue;
    }
    break;
  }
  return (array[idx] = item);
}

function siftup(array, idx, cmp) {
  var start = idx,
      end = array.length,
      item = array[idx],
      cidx = (idx << 1) + 1, ridx;

  while (cidx < end) {
    ridx = cidx + 1;
    if (ridx < end && cmp(array[cidx], array[ridx]) >= 0) {
      cidx = ridx;
    }
    array[idx] = array[cidx];
    idx = cidx;
    cidx = (idx << 1) + 1;
  }
  array[idx] = item;
  return siftdown(array, start, idx, cmp);
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/dataflow/Dataflow.js















/**
 * A dataflow graph for reactive processing of data streams.
 * @constructor
 */
function Dataflow() {
  this.logger(Object(vega_util["K" /* logger */])());
  this.logLevel(vega_util["b" /* Error */]);

  this._clock = 0;
  this._rank = 0;
  this._locale = locale_defaultLocale();
  try {
    this._loader = index_browser_loader();
  } catch (e) {
    // do nothing if loader module is unavailable
  }

  this._touched = UniqueList(vega_util["w" /* id */]);
  this._input = {};
  this._pulse = null;

  this._heap = Heap((a, b) => a.qrank - b.qrank);
  this._postrun = [];
}

var Dataflow_prototype = Dataflow.prototype;

/**
 * The current timestamp of this dataflow. This value reflects the
 * timestamp of the previous dataflow run. The dataflow is initialized
 * with a stamp value of 0. The initial run of the dataflow will have
 * a timestap of 1, and so on. This value will match the
 * {@link Pulse.stamp} property.
 * @return {number} - The current timestamp value.
 */
Dataflow_prototype.stamp = function() {
  return this._clock;
};

/**
 * Gets or sets the loader instance to use for data file loading. A
 * loader object must provide a "load" method for loading files and a
 * "sanitize" method for checking URL/filename validity. Both methods
 * should accept a URI and options hash as arguments, and return a Promise
 * that resolves to the loaded file contents (load) or a hash containing
 * sanitized URI data with the sanitized url assigned to the "href" property
 * (sanitize).
 * @param {object} _ - The loader instance to use.
 * @return {object|Dataflow} - If no arguments are provided, returns
 *   the current loader instance. Otherwise returns this Dataflow instance.
 */
Dataflow_prototype.loader = function(_) {
  if (arguments.length) {
    this._loader = _;
    return this;
  } else {
    return this._loader;
  }
};

/**
 * Gets or sets the locale instance to use for formatting and parsing
 * string values. The locale object should be provided by the
 * vega-format library, and include methods such as format, timeFormat,
 * utcFormat, timeParse, and utcParse.
 * @param {object} _ - The locale instance to use.
 * @return {object|Dataflow} - If no arguments are provided, returns
 *   the current locale instance. Otherwise returns this Dataflow instance.
 */
Dataflow_prototype.locale = function(_) {
  if (arguments.length) {
    this._locale = _;
    return this;
  } else {
    return this._locale;
  }
};

/**
 * Empty entry threshold for garbage cleaning. Map data structures will
 * perform cleaning once the number of empty entries exceeds this value.
 */
Dataflow_prototype.cleanThreshold = 1e4;

// OPERATOR REGISTRATION
Dataflow_prototype.add = dataflow_add;
Dataflow_prototype.connect = connect;
Dataflow_prototype.rank = rank;
Dataflow_prototype.rerank = rerank;

// OPERATOR UPDATES
Dataflow_prototype.pulse = update_pulse;
Dataflow_prototype.touch = update_touch;
Dataflow_prototype.update = update_update;
Dataflow_prototype.changeset = ChangeSet_changeset;

// DATA LOADING
Dataflow_prototype.ingest = load_ingest;
Dataflow_prototype.parse  = load_parse;
Dataflow_prototype.preload = preload;
Dataflow_prototype.request = request;

// EVENT HANDLING
Dataflow_prototype.events = dataflow_events;
Dataflow_prototype.on = dataflow_on;

// PULSE PROPAGATION
Dataflow_prototype.evaluate = evaluate;
Dataflow_prototype.run = run_run;
Dataflow_prototype.runAsync = runAsync;
Dataflow_prototype.runAfter = runAfter;
Dataflow_prototype._enqueue = enqueue;
Dataflow_prototype._getPulse = getPulse;

// LOGGING AND ERROR HANDLING

function logMethod(method) {
  return function() {
    return this._log[method].apply(this, arguments);
  };
}

/**
 * Get or set the logger instance used to log messages. If no arguments are
 * provided, returns the current logger instance. Otherwise, sets the logger
 * and return this Dataflow instance. Provided loggers must support the full
 * API of logger objects generated by the vega-util logger method. Note that
 * by default the log level of the new logger will be used; use the logLevel
 * method to adjust the log level as needed.
 */
Dataflow_prototype.logger = function(logger) {
  if (arguments.length) {
    this._log = logger;
    return this;
  } else {
    return this._log;
  }
};

/**
 * Logs an error message. By default, logged messages are written to console
 * output. The message will only be logged if the current log level is high
 * enough to permit error messages.
 */
Dataflow_prototype.error = logMethod('error');

/**
 * Logs a warning message. By default, logged messages are written to console
 * output. The message will only be logged if the current log level is high
 * enough to permit warning messages.
 */
Dataflow_prototype.warn = logMethod('warn');

/**
 * Logs a information message. By default, logged messages are written to
 * console output. The message will only be logged if the current log level is
 * high enough to permit information messages.
 */
Dataflow_prototype.info = logMethod('info');

/**
 * Logs a debug message. By default, logged messages are written to console
 * output. The message will only be logged if the current log level is high
 * enough to permit debug messages.
 */
Dataflow_prototype.debug = logMethod('debug');

/**
 * Get or set the current log level. If an argument is provided, it
 * will be used as the new log level.
 * @param {number} [level] - Should be one of None, Warn, Info
 * @return {number} - The current log level.
 */
Dataflow_prototype.logLevel = logMethod('level');

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/Transform.js



/**
 * Abstract class for operators that process data tuples.
 * Subclasses must provide a {@link transform} method for operator processing.
 * @constructor
 * @param {*} [init] - The initial value for this operator.
 * @param {object} [params] - The parameters for this operator.
 * @param {Operator} [source] - The operator from which to receive pulses.
 */
function Transform(init, params) {
  Operator.call(this, init, null, params);
}

var Transform_prototype = Object(vega_util["y" /* inherits */])(Transform, Operator);

/**
 * Overrides {@link Operator.evaluate} for transform operators.
 * Internally, this method calls {@link evaluate} to perform processing.
 * If {@link evaluate} returns a falsy value, the input pulse is returned.
 * This method should NOT be overridden, instead overrride {@link evaluate}.
 * @param {Pulse} pulse - the current dataflow pulse.
 * @return the output pulse for this operator (or StopPropagation)
 */
Transform_prototype.run = function(pulse) {
  if (pulse.stamp < this.stamp) return pulse.StopPropagation;

  var rv;
  if (this.skip()) {
    this.skip(false);
  } else {
    rv = this.evaluate(pulse);
  }
  rv = rv || pulse;

  if (rv.then) {
    rv = rv.then(_ => this.pulse =_);
  } else if (rv !== pulse.StopPropagation) {
    this.pulse = rv;
  }

  return rv;
};

/**
 * Overrides {@link Operator.evaluate} for transform operators.
 * Marshalls parameter values and then invokes {@link transform}.
 * @param {Pulse} pulse - the current dataflow pulse.
 * @return {Pulse} The output pulse (or StopPropagation). A falsy return
     value (including undefined) will let the input pulse pass through.
 */
Transform_prototype.evaluate = function(pulse) {
  var params = this.marshall(pulse.stamp),
      out = this.transform(params, pulse);
  params.clear();
  return out;
};

/**
 * Process incoming pulses.
 * Subclasses should override this method to implement transforms.
 * @param {Parameters} _ - The operator parameter values.
 * @param {Pulse} pulse - The current dataflow pulse.
 * @return {Pulse} The output pulse (or StopPropagation). A falsy return
 *   value (including undefined) will let the input pulse pass through.
 */
Transform_prototype.transform = function() {};

// CONCATENATED MODULE: ./node_modules/vega-dataflow/src/register.js


var register_transforms = {};

function register_definition(type) {
  var t = register_transform(type);
  return t && t.Definition || null;
}

function register_transform(type) {
  type = type && type.toLowerCase();
  return Object(vega_util["v" /* hasOwnProperty */])(register_transforms, type) ? register_transforms[type] : null;
}

// CONCATENATED MODULE: ./node_modules/vega-dataflow/index.js
// Utilities



// Core Runtime









// Tuple Methods


// Transform Registry


// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/AggregateKeys.js
function multikey(f) {
  return function(x) {
    var n = f.length,
        i = 1,
        k = String(f[0](x));

    for (; i<n; ++i) {
      k += '|' + f[i](x);
    }

    return k;
  };
}

function groupkey(fields) {
  return !fields || !fields.length ? function() { return ''; }
    : fields.length === 1 ? fields[0]
    : multikey(fields);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/AggregateOps.js


function measureName(op, field, as) {
  return as || (op + (!field ? '' : '_' + field));
}

const noop = () => {};

const base_op = {
  init: noop,
  add:  noop,
  rem:  noop,
  idx:  0
};

const AggregateOps = {
  values: {
    init:  m => m.cell.store = true,
    value: m => m.cell.data.values(),
    idx:  -1
  },
  count: {
    value: m => m.cell.num
  },
  __count__: {
    value: m => m.missing + m.valid
  },
  missing: {
    value: m => m.missing
  },
  valid: {
    value: m => m.valid
  },
  sum: {
    init:  m => m.sum = 0,
    value: m => m.sum,
    add:  (m, v) => m.sum += +v,
    rem:  (m, v) => m.sum -= v
  },
  product: {
    init:  m => m.product = 1,
    value: m => m.valid ? m.product : undefined,
    add:  (m, v) => m.product *= v,
    rem:  (m, v) => m.product /= v
  },
  mean: {
    init:  m => m.mean = 0,
    value: m => m.valid ? m.mean : undefined,
    add:  (m, v) => (m.mean_d = v - m.mean, m.mean += m.mean_d / m.valid),
    rem:  (m, v) => (m.mean_d = v - m.mean, m.mean -= m.valid ? m.mean_d / m.valid : m.mean)
  },
  average: {
    value: m => m.valid ? m.mean : undefined,
    req:  ['mean'], idx: 1
  },
  variance: {
    init:  m => m.dev = 0,
    value: m => m.valid > 1 ? m.dev / (m.valid - 1) : undefined,
    add:  (m, v) => m.dev += m.mean_d * (v - m.mean),
    rem:  (m, v) => m.dev -= m.mean_d * (v - m.mean),
    req:  ['mean'], idx: 1
  },
  variancep: {
    value: m => m.valid > 1 ? m.dev / m.valid : undefined,
    req:  ['variance'], idx: 2
  },
  stdev: {
    value: m => m.valid > 1 ? Math.sqrt(m.dev / (m.valid - 1)) : undefined,
    req:  ['variance'], idx: 2
  },
  stdevp: {
    value: m => m.valid > 1 ? Math.sqrt(m.dev / m.valid) : undefined,
    req:  ['variance'], idx: 2
  },
  stderr: {
    value: m => m.valid > 1 ? Math.sqrt(m.dev / (m.valid * (m.valid - 1))) : undefined,
    req:  ['variance'], idx: 2
  },
  distinct: {
    value: m => m.cell.data.distinct(m.get),
    req:  ['values'], idx: 3
  },
  ci0: {
    value: m => m.cell.data.ci0(m.get),
    req:  ['values'], idx: 3
  },
  ci1: {
    value: m => m.cell.data.ci1(m.get),
    req:  ['values'], idx: 3
  },
  median: {
    value: m => m.cell.data.q2(m.get),
    req:  ['values'], idx: 3
  },
  q1: {
    value: m => m.cell.data.q1(m.get),
    req: ['values'], idx: 3
  },
  q3: {
    value: m => m.cell.data.q3(m.get),
    req:  ['values'], idx: 3
  },
  min: {
    init:  m => m.min = undefined,
    value: m => m.min = (Number.isNaN(m.min) ? m.cell.data.min(m.get) : m.min),
    add:  (m, v) => { if (v < m.min || m.min === undefined) m.min = v; },
    rem:  (m, v) => { if (v <= m.min) m.min = NaN; },
    req:  ['values'], idx: 4
  },
  max: {
    init:  m => m.max = undefined,
    value: m => m.max = (Number.isNaN(m.max) ? m.cell.data.max(m.get) : m.max),
    add:  (m, v) => { if (v > m.max || m.max === undefined) m.max = v; },
    rem:  (m, v) => { if (v >= m.max) m.max = NaN; },
    req:  ['values'], idx: 4
  },
  argmin: {
    init:  m => m.argmin = undefined,
    value: m => m.argmin || m.cell.data.argmin(m.get),
    add:  (m, v, t) => { if (v < m.min) m.argmin = t; },
    rem:  (m, v) => { if (v <= m.min) m.argmin = undefined; },
    req:  ['min', 'values'], idx: 3
  },
  argmax: {
    init:  m => m.argmax = undefined,
    value: m => m.argmax || m.cell.data.argmax(m.get),
    add:  (m, v, t) => { if (v > m.max) m.argmax = t; },
    rem:  (m, v) => { if (v >= m.max) m.argmax = undefined; },
    req:  ['max', 'values'], idx: 3
  }
};

const ValidAggregateOps = Object.keys(AggregateOps);

function measure(key, value) {
  return out => Object(vega_util["o" /* extend */])({
    name: key,
    out: out || key
  }, base_op, value);
}

ValidAggregateOps.forEach(key => {
  AggregateOps[key] = measure(key, AggregateOps[key]);
});

function createMeasure(op, name) {
  return AggregateOps[op](name);
}

function compareIndex(a, b) {
  return a.idx - b.idx;
}

function resolve(agg) {
  const map = {};
  agg.forEach(a => map[a.name] = a);

  const getreqs = a => {
    if (!a.req) return;
    a.req.forEach(key => {
      if (!map[key]) getreqs(map[key] = AggregateOps[key]());
    });
  };
  agg.forEach(getreqs);

  return Object.values(map).sort(compareIndex);
}

function AggregateOps_init() {
  this.valid = 0;
  this.missing = 0;
  this._ops.forEach(op => op.init(this));
}

function AggregateOps_add(v, t) {
  if (v == null || v === '') { ++this.missing; return; }
  if (v !== v) return;
  ++this.valid;
  this._ops.forEach(op => op.add(this, v, t));
}

function AggregateOps_rem(v, t) {
  if (v == null || v === '') { --this.missing; return; }
  if (v !== v) return;
  --this.valid;
  this._ops.forEach(op => op.rem(this, v, t));
}

function AggregateOps_set(t) {
  this._out.forEach(op => t[op.out] = op.value(this));
  return t;
}

function compileMeasures(agg, field) {
  var get = field || vega_util["x" /* identity */],
      ops = resolve(agg),
      out = agg.slice().sort(compareIndex);

  function ctr(cell) {
    this._ops = ops;
    this._out = out;
    this.cell = cell;
    this.init();
  }

  ctr.prototype.init = AggregateOps_init;
  ctr.prototype.add = AggregateOps_add;
  ctr.prototype.rem = AggregateOps_rem;
  ctr.prototype.set = AggregateOps_set;
  ctr.prototype.get = get;
  ctr.fields = agg.map(op => op.out);

  return ctr;
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/numbers.js
/* harmony default export */ var src_numbers = (function*(values, valueof) {
  if (valueof == null) {
    for (let value of values) {
      if (value != null && value !== '' && (value = +value) >= value) {
        yield value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      value = valueof(value, ++index, values);
      if (value != null && value !== '' && (value = +value) >= value) {
        yield value;
      }
    }
  }
});

// CONCATENATED MODULE: ./node_modules/d3-array/src/max.js
function max_max(values, valueof) {
  let max;
  if (valueof === undefined) {
    for (const value of values) {
      if (value != null
          && (max < value || (max === undefined && value >= value))) {
        max = value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null
          && (max < value || (max === undefined && value >= value))) {
        max = value;
      }
    }
  }
  return max;
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/min.js
function min_min(values, valueof) {
  let min;
  if (valueof === undefined) {
    for (const value of values) {
      if (value != null
          && (min > value || (min === undefined && value >= value))) {
        min = value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null
          && (min > value || (min === undefined && value >= value))) {
        min = value;
      }
    }
  }
  return min;
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/quickselect.js


// Based on https://github.com/mourner/quickselect
// ISC license, Copyright 2018 Vladimir Agafonkin.
function quickselect(array, k, left = 0, right = array.length - 1, compare = ascending) {
  while (right > left) {
    if (right - left > 600) {
      const n = right - left + 1;
      const m = k - left + 1;
      const z = Math.log(n);
      const s = 0.5 * Math.exp(2 * z / 3);
      const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
      const newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
      const newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
      quickselect(array, k, newLeft, newRight, compare);
    }

    const t = array[k];
    let i = left;
    let j = right;

    swap(array, left, k);
    if (compare(array[right], t) > 0) swap(array, left, right);

    while (i < j) {
      swap(array, i, j), ++i, --j;
      while (compare(array[i], t) < 0) ++i;
      while (compare(array[j], t) > 0) --j;
    }

    if (compare(array[left], t) === 0) swap(array, left, j);
    else ++j, swap(array, j, right);

    if (j <= k) left = j + 1;
    if (k <= j) right = j - 1;
  }
  return array;
}

function swap(array, i, j) {
  const t = array[i];
  array[i] = array[j];
  array[j] = t;
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/number.js
/* harmony default export */ var src_number = (function(x) {
  return x === null ? NaN : +x;
});

function* number_numbers(values, valueof) {
  if (valueof === undefined) {
    for (let value of values) {
      if (value != null && (value = +value) >= value) {
        yield value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null && (value = +value) >= value) {
        yield value;
      }
    }
  }
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/quantile.js





function quantile(values, p, valueof) {
  values = Float64Array.from(number_numbers(values, valueof));
  if (!(n = values.length)) return;
  if ((p = +p) <= 0 || n < 2) return min_min(values);
  if (p >= 1) return max_max(values);
  var n,
      i = (n - 1) * p,
      i0 = Math.floor(i),
      value0 = max_max(quickselect(values, i0).subarray(0, i0 + 1)),
      value1 = min_min(values.subarray(i0 + 1));
  return value0 + (value1 - value0) * (i - i0);
}

function quantileSorted(values, p, valueof = src_number) {
  if (!(n = values.length)) return;
  if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);
  if (p >= 1) return +valueof(values[n - 1], n - 1, values);
  var n,
      i = (n - 1) * p,
      i0 = Math.floor(i),
      value0 = +valueof(values[i0], i0, values),
      value1 = +valueof(values[i0 + 1], i0 + 1, values);
  return value0 + (value1 - value0) * (i - i0);
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/quantiles.js



/* harmony default export */ var quantiles = (function(array, p, f) {
  var values = Float64Array.from(src_numbers(array, f));

  // don't depend on return value from typed array sort call
  // protects against undefined sort results in Safari (vega/vega-lite#4964)
  values.sort(ascending);

  return p.map(_ => quantileSorted(values, _));
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/quartiles.js


/* harmony default export */ var quartiles = (function(array, f) {
  return quantiles(array, [0.25, 0.50, 0.75], f);
});

// CONCATENATED MODULE: ./node_modules/d3-array/src/variance.js
function variance(values, valueof) {
  let count = 0;
  let delta;
  let mean = 0;
  let sum = 0;
  if (valueof === undefined) {
    for (let value of values) {
      if (value != null && (value = +value) >= value) {
        delta = value - mean;
        mean += delta / ++count;
        sum += delta * (value - mean);
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null && (value = +value) >= value) {
        delta = value - mean;
        mean += delta / ++count;
        sum += delta * (value - mean);
      }
    }
  }
  if (count > 1) return sum / (count - 1);
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/deviation.js


function deviation(values, valueof) {
  const v = variance(values, valueof);
  return v ? Math.sqrt(v) : v;
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/bandwidth.js



// Scott, D. W. (1992) Multivariate Density Estimation:
// Theory, Practice, and Visualization. Wiley.
/* harmony default export */ var src_bandwidth = (function(array, f) {
  var n = array.length,
      v = deviation(array, f),
      q = quartiles(array, f),
      h = (q[2] - q[0]) / 1.34;

  v = Math.min(v, h) || v || Math.abs(q[0]) || 1;

  return 1.06 * v * Math.pow(n, -0.2);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/bin.js
/* harmony default export */ var vega_statistics_src_bin = (function(_) {
  // determine range
  var maxb = _.maxbins || 20,
      base = _.base || 10,
      logb = Math.log(base),
      div  = _.divide || [5, 2],
      min  = _.extent[0],
      max  = _.extent[1],
      span = _.span || (max - min) || Math.abs(min) || 1,
      step, level, minstep, precision, v, i, n, eps;

  if (_.step) {
    // if step size is explicitly given, use that
    step = _.step;
  } else if (_.steps) {
    // if provided, limit choice to acceptable step sizes
    v = span / maxb;
    for (i=0, n=_.steps.length; i < n && _.steps[i] < v; ++i);
    step = _.steps[Math.max(0, i-1)];
  } else {
    // else use span to determine step size
    level = Math.ceil(Math.log(maxb) / logb);
    minstep = _.minstep || 0;
    step = Math.max(
      minstep,
      Math.pow(base, Math.round(Math.log(span) / logb) - level)
    );

    // increase step size if too many bins
    while (Math.ceil(span/step) > maxb) { step *= base; }

    // decrease step size if allowed
    for (i=0, n=div.length; i<n; ++i) {
      v = step / div[i];
      if (v >= minstep && span / v <= maxb) step = v;
    }
  }

  // update precision, min and max
  v = Math.log(step);
  precision = v >= 0 ? 0 : ~~(-v / logb) + 1;
  eps = Math.pow(base, -precision - 1);
  if (_.nice || _.nice === undefined) {
    v = Math.floor(min / step + eps) * step;
    min = min < v ? v - step : v;
    max = Math.ceil(max / step) * step;
  }

  return {
    start: min,
    stop:  max === min ? min + step : max,
    step:  step
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/random.js
var random_random = Math.random;

function setRandom(r) {
  random_random = r;
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/bootstrapCI.js




/* harmony default export */ var bootstrapCI = (function(array, samples, alpha, f) {
  if (!array.length) return [undefined, undefined];

  var values = Float64Array.from(src_numbers(array, f)),
      n = values.length,
      m = samples,
      a, i, j, mu;

  for (j=0, mu=Array(m); j<m; ++j) {
    for (a=0, i=0; i<n; ++i) {
      a += values[~~(random_random() * n)];
    }
    mu[j] = a / n;
  }

  mu.sort(ascending);

  return [
    quantile(mu, alpha/2),
    quantile(mu, 1-(alpha/2))
  ];
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/dotbin.js
// Dot density binning for dot plot construction.
// Based on Leland Wilkinson, Dot Plots, The American Statistician, 1999.
// https://www.cs.uic.edu/~wilkinson/Publications/dotplots.pdf
/* harmony default export */ var dotbin = (function(array, step, smooth, f) {
  f = f || (_ => _);

  let i = 0, j = 1,
      n = array.length,
      v = new Float64Array(n),
      a = f(array[0]),
      b = a,
      w = a + step,
      x;

  for (; j<n; ++j) {
    x = f(array[j]);
    if (x >= w) {
      b = (a + b) / 2;
      for (; i<j; ++i) v[i] = b;
      w = x + step;
      a = x;
    }
    b = x;
  }

  b = (a + b) / 2;
  for (; i<j; ++i) v[i] = b;

  return smooth ? smoothing(v, step + step / 4) : v;
});

// perform smoothing to reduce variance
// swap points between "adjacent" stacks
// Wilkinson defines adjacent as within step/4 units
function smoothing(v, thresh) {
  let n = v.length,
      a = 0,
      b = 1,
      c, d;

  // get left stack
  while (v[a] === v[b]) ++b;

  while (b < n) {
    // get right stack
    c = b + 1;
    while (v[b] === v[c]) ++c;

    // are stacks adjacent?
    // if so, compare sizes and swap as needed
    if (v[b] - v[b-1] < thresh) {
      d = b + ((a + c - b - b) >> 1);
      while (d < b) v[d++] = v[b];
      while (d > b) v[d--] = v[a];
    }

    // update left stack indices
    a = b;
    b = c;
  }

  return v;
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/lcg.js
/* harmony default export */ var lcg = (function(seed) {
  // Random numbers using a Linear Congruential Generator with seed value
  // Uses glibc values from https://en.wikipedia.org/wiki/Linear_congruential_generator
  return function() {
    seed = (1103515245 * seed + 12345) % 2147483647;
    return seed / 2147483647;
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/integer.js


/* harmony default export */ var integer = (function(min, max) {
  if (max == null) {
    max = min;
    min = 0;
  }

  var dist = {},
      a, b, d;

  dist.min = function(_) {
    if (arguments.length) {
      a = _ || 0;
      d = b - a;
      return dist;
    } else {
      return a;
    }
  };

  dist.max = function(_) {
    if (arguments.length) {
      b = _ || 0;
      d = b - a;
      return dist;
    } else {
      return b;
    }
  };

  dist.sample = function() {
    return a + Math.floor(d * random_random());
  };

  dist.pdf = function(x) {
    return (x === Math.floor(x) && x >= a && x < b) ? 1 / d : 0;
  };

  dist.cdf = function(x) {
    var v = Math.floor(x);
    return v < a ? 0 : v >= b ? 1 : (v - a + 1) / d;
  };

  dist.icdf = function(p) {
    return (p >= 0 && p <= 1) ? a - 1 + Math.floor(p * d) : NaN;
  };

  return dist.min(min).max(max);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/constants.js
const SQRT2PI = Math.sqrt(2 * Math.PI);
const SQRT2 = Math.SQRT2;
// CONCATENATED MODULE: ./node_modules/vega-statistics/src/normal.js



let nextSample = NaN;

function sampleNormal(mean, stdev) {
  mean = mean || 0;
  stdev = stdev == null ? 1 : stdev;

  let x = 0, y = 0, rds, c;
  if (nextSample === nextSample) {
    x = nextSample;
    nextSample = NaN;
  } else {
    do {
      x = random_random() * 2 - 1;
      y = random_random() * 2 - 1;
      rds = x * x + y * y;
    } while (rds === 0 || rds > 1);
    c = Math.sqrt(-2 * Math.log(rds) / rds); // Box-Muller transform
    x *= c;
    nextSample = y * c;
  }
  return mean + x * stdev;
}

function densityNormal(value, mean, stdev) {
  stdev = stdev == null ? 1 : stdev;
  const z = (value - (mean || 0)) / stdev;
  return Math.exp(-0.5 * z * z) / (stdev * SQRT2PI);
}

// Approximation from West (2009)
// Better Approximations to Cumulative Normal Functions
function cumulativeNormal(value, mean, stdev) {
  mean = mean || 0;
  stdev = stdev == null ? 1 : stdev;

  let cd,
      z = (value - mean) / stdev,
      Z = Math.abs(z);

  if (Z > 37) {
    cd = 0;
  } else {
    let sum, exp = Math.exp(-Z * Z / 2);
    if (Z < 7.07106781186547) {
      sum = 3.52624965998911e-02 * Z + 0.700383064443688;
      sum = sum * Z + 6.37396220353165;
      sum = sum * Z + 33.912866078383;
      sum = sum * Z + 112.079291497871;
      sum = sum * Z + 221.213596169931;
      sum = sum * Z + 220.206867912376;
      cd = exp * sum;
      sum = 8.83883476483184e-02 * Z + 1.75566716318264;
      sum = sum * Z + 16.064177579207;
      sum = sum * Z + 86.7807322029461;
      sum = sum * Z + 296.564248779674;
      sum = sum * Z + 637.333633378831;
      sum = sum * Z + 793.826512519948;
      sum = sum * Z + 440.413735824752;
      cd = cd / sum;
    } else {
      sum = Z + 0.65;
      sum = Z + 4 / sum;
      sum = Z + 3 / sum;
      sum = Z + 2 / sum;
      sum = Z + 1 / sum;
      cd = exp / sum / 2.506628274631;
    }
  }
  return z > 0 ? 1 - cd : cd;
}

// Approximation of Probit function using inverse error function.
function quantileNormal(p, mean, stdev) {
  if (p < 0 || p > 1) return NaN;
  return (mean || 0) + (stdev == null ? 1 : stdev) * SQRT2 * erfinv(2 * p - 1);
}

// Approximate inverse error function. Implementation from "Approximating
// the erfinv function" by Mike Giles, GPU Computing Gems, volume 2, 2010.
// Ported from Apache Commons Math, http://www.apache.org/licenses/LICENSE-2.0
function erfinv(x) {
  // beware that the logarithm argument must be
  // commputed as (1.0 - x) * (1.0 + x),
  // it must NOT be simplified as 1.0 - x * x as this
  // would induce rounding errors near the boundaries +/-1
  let w = - Math.log((1 - x) * (1 + x)), p;

  if (w < 6.25) {
      w -= 3.125;
      p =  -3.6444120640178196996e-21;
      p =   -1.685059138182016589e-19 + p * w;
      p =   1.2858480715256400167e-18 + p * w;
      p =    1.115787767802518096e-17 + p * w;
      p =   -1.333171662854620906e-16 + p * w;
      p =   2.0972767875968561637e-17 + p * w;
      p =   6.6376381343583238325e-15 + p * w;
      p =  -4.0545662729752068639e-14 + p * w;
      p =  -8.1519341976054721522e-14 + p * w;
      p =   2.6335093153082322977e-12 + p * w;
      p =  -1.2975133253453532498e-11 + p * w;
      p =  -5.4154120542946279317e-11 + p * w;
      p =    1.051212273321532285e-09 + p * w;
      p =  -4.1126339803469836976e-09 + p * w;
      p =  -2.9070369957882005086e-08 + p * w;
      p =   4.2347877827932403518e-07 + p * w;
      p =  -1.3654692000834678645e-06 + p * w;
      p =  -1.3882523362786468719e-05 + p * w;
      p =    0.0001867342080340571352 + p * w;
      p =  -0.00074070253416626697512 + p * w;
      p =   -0.0060336708714301490533 + p * w;
      p =      0.24015818242558961693 + p * w;
      p =       1.6536545626831027356 + p * w;
  } else if (w < 16.0) {
      w = Math.sqrt(w) - 3.25;
      p =   2.2137376921775787049e-09;
      p =   9.0756561938885390979e-08 + p * w;
      p =  -2.7517406297064545428e-07 + p * w;
      p =   1.8239629214389227755e-08 + p * w;
      p =   1.5027403968909827627e-06 + p * w;
      p =   -4.013867526981545969e-06 + p * w;
      p =   2.9234449089955446044e-06 + p * w;
      p =   1.2475304481671778723e-05 + p * w;
      p =  -4.7318229009055733981e-05 + p * w;
      p =   6.8284851459573175448e-05 + p * w;
      p =   2.4031110387097893999e-05 + p * w;
      p =   -0.0003550375203628474796 + p * w;
      p =   0.00095328937973738049703 + p * w;
      p =   -0.0016882755560235047313 + p * w;
      p =    0.0024914420961078508066 + p * w;
      p =   -0.0037512085075692412107 + p * w;
      p =     0.005370914553590063617 + p * w;
      p =       1.0052589676941592334 + p * w;
      p =       3.0838856104922207635 + p * w;
  } else if (Number.isFinite(w)) {
      w = Math.sqrt(w) - 5.0;
      p =  -2.7109920616438573243e-11;
      p =  -2.5556418169965252055e-10 + p * w;
      p =   1.5076572693500548083e-09 + p * w;
      p =  -3.7894654401267369937e-09 + p * w;
      p =   7.6157012080783393804e-09 + p * w;
      p =  -1.4960026627149240478e-08 + p * w;
      p =   2.9147953450901080826e-08 + p * w;
      p =  -6.7711997758452339498e-08 + p * w;
      p =   2.2900482228026654717e-07 + p * w;
      p =  -9.9298272942317002539e-07 + p * w;
      p =   4.5260625972231537039e-06 + p * w;
      p =  -1.9681778105531670567e-05 + p * w;
      p =   7.5995277030017761139e-05 + p * w;
      p =  -0.00021503011930044477347 + p * w;
      p =  -0.00013871931833623122026 + p * w;
      p =       1.0103004648645343977 + p * w;
      p =       4.8499064014085844221 + p * w;
  } else {
      p = Infinity;
  }

  return p * x;
}

/* harmony default export */ var src_normal = (function(mean, stdev) {
  var mu,
      sigma,
      dist = {
        mean: function(_) {
          if (arguments.length) {
            mu = _ || 0;
            return dist;
          } else {
            return mu;
          }
        },
        stdev: function(_) {
          if (arguments.length) {
            sigma = _ == null ? 1 : _;
            return dist;
          } else {
            return sigma;
          }
        },
        sample: () => sampleNormal(mu, sigma),
        pdf: value => densityNormal(value, mu, sigma),
        cdf: value => cumulativeNormal(value, mu, sigma),
        icdf: p => quantileNormal(p, mu, sigma)
      };

  return dist.mean(mean).stdev(stdev);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/kde.js




// TODO: support for additional kernels?
/* harmony default export */ var src_kde = (function(support, bandwidth) {
  var kernel = src_normal(),
      dist = {},
      n = 0;

  dist.data = function(_) {
    if (arguments.length) {
      support = _;
      n = _ ? _.length : 0;
      return dist.bandwidth(bandwidth);
    } else {
      return support;
    }
  };

  dist.bandwidth = function(_) {
    if (!arguments.length) return bandwidth;
    bandwidth = _;
    if (!bandwidth && support) bandwidth = src_bandwidth(support);
    return dist;
  };

  dist.sample = function() {
    return support[~~(random_random() * n)] + bandwidth * kernel.sample();
  };

  dist.pdf = function(x) {
    for (var y=0, i=0; i<n; ++i) {
      y += kernel.pdf((x - support[i]) / bandwidth);
    }
    return y / bandwidth / n;
  };

  dist.cdf = function(x) {
    for (var y=0, i=0; i<n; ++i) {
      y += kernel.cdf((x - support[i]) / bandwidth);
    }
    return y / n;
  };

  dist.icdf = function() {
    throw Error('KDE icdf not supported.');
  };

  return dist.data(support);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/lognormal.js



function sampleLogNormal(mean, stdev) {
  mean = mean || 0;
  stdev = stdev == null ? 1 : stdev;
  return Math.exp(mean + sampleNormal() * stdev);
}

function densityLogNormal(value, mean, stdev) {
  if (value <= 0) return 0;
  mean = mean || 0;
  stdev = stdev == null ? 1 : stdev;
  const z = (Math.log(value) - mean) / stdev;
  return Math.exp(-0.5 * z * z) / (stdev * SQRT2PI * value);
}

function cumulativeLogNormal(value, mean, stdev) {
  return cumulativeNormal(Math.log(value), mean, stdev);
}

function quantileLogNormal(p, mean, stdev) {
  return Math.exp(quantileNormal(p, mean, stdev));
}

/* harmony default export */ var lognormal = (function(mean, stdev) {
  var mu,
      sigma,
      dist = {
        mean: function(_) {
          if (arguments.length) {
            mu = _ || 0;
            return dist;
          } else {
            return mu;
          }
        },
        stdev: function(_) {
          if (arguments.length) {
            sigma = _ == null ? 1 : _;
            return dist;
          } else {
            return sigma;
          }
        },
        sample: () => sampleLogNormal(mu, sigma),
        pdf: value => densityLogNormal(value, mu, sigma),
        cdf: value => cumulativeLogNormal(value, mu, sigma),
        icdf: p => quantileLogNormal(p, mu, sigma)
      };

  return dist.mean(mean).stdev(stdev);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/mixture.js


/* harmony default export */ var mixture = (function(dists, weights) {
  var dist = {}, m = 0, w;

  function normalize(x) {
    var w = [], sum = 0, i;
    for (i=0; i<m; ++i) { sum += (w[i] = (x[i]==null ? 1 : +x[i])); }
    for (i=0; i<m; ++i) { w[i] /= sum; }
    return w;
  }

  dist.weights = function(_) {
    if (arguments.length) {
      w = normalize(weights = (_ || []));
      return dist;
    }
    return weights;
  };

  dist.distributions = function(_) {
    if (arguments.length) {
      if (_) {
        m = _.length;
        dists = _;
      } else {
        m = 0;
        dists = [];
      }
      return dist.weights(weights);
    }
    return dists;
  };

  dist.sample = function() {
    var r = random_random(),
        d = dists[m-1],
        v = w[0],
        i = 0;

    // first select distribution
    for (; i<m-1; v += w[++i]) {
      if (r < v) { d = dists[i]; break; }
    }
    // then sample from it
    return d.sample();
  };

  dist.pdf = function(x) {
    for (var p=0, i=0; i<m; ++i) {
      p += w[i] * dists[i].pdf(x);
    }
    return p;
  };

  dist.cdf = function(x) {
    for (var p=0, i=0; i<m; ++i) {
      p += w[i] * dists[i].cdf(x);
    }
    return p;
  };

  dist.icdf = function() {
    throw Error('Mixture icdf not supported.');
  };

  return dist.distributions(dists).weights(weights);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/uniform.js


function sampleUniform(min, max) {
  if (max == null) {
    max = (min == null ? 1 : min);
    min = 0;
  }
  return min + (max - min) * random_random();
}

function densityUniform(value, min, max) {
  if (max == null) {
    max = (min == null ? 1 : min);
    min = 0;
  }
  return (value >= min && value <= max) ? 1 / (max - min) : 0;
}

function cumulativeUniform(value, min, max) {
  if (max == null) {
    max = (min == null ? 1 : min);
    min = 0;
  }
  return value < min ? 0 : value > max ? 1 : (value - min) / (max - min);
}

function quantileUniform(p, min, max) {
  if (max == null) {
    max = (min == null ? 1 : min);
    min = 0;
  }
  return (p >= 0 && p <= 1) ? min + p * (max - min) : NaN;
}

/* harmony default export */ var uniform = (function(min, max) {
  var a, b,
      dist = {
        min: function(_) {
          if (arguments.length) {
            a = _ || 0;
            return dist;
          } else {
            return a;
          }
        },
        max: function(_) {
          if (arguments.length) {
            b = _ == null ? 1 : _;
            return dist;
          } else {
            return b;
          }
        },
        sample: () => sampleUniform(a, b),
        pdf: value => densityUniform(value, a, b),
        cdf: value => cumulativeUniform(value, a, b),
        icdf: p => quantileUniform(p, a, b)
      };

  if (max == null) {
    max = (min == null ? 1 : min);
    min = 0;
  }
  return dist.min(min).max(max);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/ols.js
// Ordinary Least Squares
/* harmony default export */ var ols = (function(uX, uY, uXY, uX2) {
  const delta = uX2 - uX * uX,
        slope = Math.abs(delta) < 1e-24 ? 0 : (uXY - uX * uY) / delta,
        intercept = uY - slope * uX;

  return [intercept, slope];
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/points.js
function points_points(data, x, y, sort) {
  data = data.filter(d => {
    let u = x(d), v = y(d);
    return u != null && (u = +u) >= u && v != null && (v = +v) >= v;
  });

  if (sort) {
    data.sort((a, b) => x(a) - x(b));
  }

  const n = data.length,
        X = new Float64Array(n),
        Y = new Float64Array(n);

  // extract values, calculate means
  let i = 0, ux = 0, uy = 0, xv, yv, d;
  for (d of data) {
    X[i] = xv = +x(d);
    Y[i] = yv = +y(d);
    ++i;
    ux += (xv - ux) / i;
    uy += (yv - uy) / i;
  }

  // mean center the data
  for (i=0; i<n; ++i) {
    X[i] -= ux;
    Y[i] -= uy;
  }

  return [X, Y, ux, uy];
}

function visitPoints(data, x, y, callback) {
  let i = -1, u, v;

  for (let d of data) {
    u = x(d);
    v = y(d);
    if (u != null && (u = +u) >= u && v != null && (v = +v) >= v) {
      callback(u, v, ++i);
    }
  }
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/r-squared.js


// Adapted from d3-regression by Harry Stevens
// License: https://github.com/HarryStevens/d3-regression/blob/master/LICENSE
/* harmony default export */ var r_squared = (function(data, x, y, uY, predict) {
  let SSE = 0, SST = 0;

  visitPoints(data, x, y, (dx, dy) => {
    const sse = dy - predict(dx),
          sst = dy - uY;

    SSE += sse * sse;
    SST += sst * sst;
  });

  return 1 - SSE / SST;
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/linear.js




// Adapted from d3-regression by Harry Stevens
// License: https://github.com/HarryStevens/d3-regression/blob/master/LICENSE
/* harmony default export */ var linear = (function(data, x, y) {
  let X = 0, Y = 0, XY = 0, X2 = 0, n = 0;

  visitPoints(data, x, y, (dx, dy) => {
    ++n;
    X += (dx - X) / n;
    Y += (dy - Y) / n;
    XY += (dx * dy - XY) / n;
    X2 += (dx * dx - X2) / n;
  });

  const coef = ols(X, Y, XY, X2),
        predict = x => coef[0] + coef[1] * x;

  return {
    coef: coef,
    predict: predict,
    rSquared: r_squared(data, x, y, Y, predict)
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/log.js




// Adapted from d3-regression by Harry Stevens
// License: https://github.com/HarryStevens/d3-regression/blob/master/LICENSE
/* harmony default export */ var log = (function(data, x, y) {
  let X = 0, Y = 0, XY = 0, X2 = 0, n = 0;

  visitPoints(data, x, y, (dx, dy) => {
    ++n;
    dx = Math.log(dx);
    X += (dx - X) / n;
    Y += (dy - Y) / n;
    XY += (dx * dy - XY) / n;
    X2 += (dx * dx - X2) / n;
  });

  const coef = ols(X, Y, XY, X2),
        predict = x => coef[0] + coef[1] * Math.log(x);

  return {
    coef: coef,
    predict: predict,
    rSquared: r_squared(data, x, y, Y, predict)
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/exp.js




/* harmony default export */ var exp = (function(data, x, y) {
  // eslint-disable-next-line no-unused-vars
  const [xv, yv, ux, uy] = points_points(data, x, y);
  let YL = 0, XY = 0, XYL = 0, X2Y = 0, n = 0, dx, ly, xy;

  visitPoints(data, x, y, (_, dy) => {
    dx = xv[n++];
    ly = Math.log(dy);
    xy = dx * dy;

    YL += (dy * ly - YL) / n;
    XY += (xy - XY) / n;
    XYL += (xy * ly - XYL) / n;
    X2Y += (dx * xy - X2Y) / n;
  });

  const [c0, c1] = ols(XY / uy, YL / uy, XYL / uy, X2Y / uy),
        predict = x => Math.exp(c0 + c1 * (x - ux));

  return {
    coef: [Math.exp(c0 - c1 * ux), c1],
    predict: predict,
    rSquared: r_squared(data, x, y, uy, predict)
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/pow.js




// Adapted from d3-regression by Harry Stevens
// License: https://github.com/HarryStevens/d3-regression/blob/master/LICENSE
/* harmony default export */ var pow = (function(data, x, y) {
  let X = 0, Y = 0, XY = 0, X2 = 0, YS = 0, n = 0;

  visitPoints(data, x, y, (dx, dy) => {
    const lx = Math.log(dx),
          ly = Math.log(dy);
    ++n;
    X += (lx - X) / n;
    Y += (ly - Y) / n;
    XY += (lx * ly - XY) / n;
    X2 += (lx * lx - X2) / n;
    YS += (dy - YS) / n;
  });

  const coef = ols(X, Y, XY, X2),
        predict = x => coef[0] * Math.pow(x, coef[1]);

  coef[0] = Math.exp(coef[0]);

  return {
    coef: coef,
    predict: predict,
    rSquared: r_squared(data, x, y, YS, predict)
  };
});
// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/quad.js



/* harmony default export */ var regression_quad = (function(data, x, y) {
  const [xv, yv, ux, uy] = points_points(data, x, y),
        n = xv.length;

  let X2 = 0, X3 = 0, X4 = 0, XY = 0, X2Y = 0,
      i, dx, dy, x2;

  for (i=0; i<n;) {
    dx = xv[i];
    dy = yv[i++];
    x2 = dx * dx;
    X2 += (x2 - X2) / i;
    X3 += (x2 * dx - X3) / i;
    X4 += (x2 * x2 - X4) / i;
    XY += (dx * dy - XY) / i;
    X2Y += (x2 * dy - X2Y) / i;
  }

  const X2X2 = X4 - (X2 * X2),
        d = (X2 * X2X2 - X3 * X3),
        a = (X2Y * X2 - XY * X3) / d,
        b = (XY * X2X2 - X2Y * X3) / d,
        c = -a * X2,
        predict = x => {
          x = x - ux;
          return a * x * x + b * x + c + uy;
        };

  // transform coefficients back from mean-centered space
  return {
    coef: [
      c - b * ux + a * ux * ux + uy,
      b - 2 * a * ux,
      a
    ],
    predict: predict,
    rSquared: r_squared(data, x, y, uy, predict)
  };
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/poly.js





// Adapted from d3-regression by Harry Stevens
// License: https://github.com/HarryStevens/d3-regression/blob/master/LICENSE
// ... which was adapted from regression-js by Tom Alexander
// Source: https://github.com/Tom-Alexander/regression-js/blob/master/src/regression.js#L246
// License: https://github.com/Tom-Alexander/regression-js/blob/master/LICENSE
/* harmony default export */ var poly = (function(data, x, y, order) {
  // use more efficient methods for lower orders
  if (order === 1) return linear(data, x, y);
  if (order === 2) return regression_quad(data, x, y);

  const [xv, yv, ux, uy] = points_points(data, x, y),
        n = xv.length,
        lhs = [],
        rhs = [],
        k = order + 1;

  let i, j, l, v, c;

  for (i=0; i<k; ++i) {
    for (l=0, v=0; l<n; ++l) {
      v += Math.pow(xv[l], i) * yv[l];
    }
    lhs.push(v);

    c = new Float64Array(k);
    for (j=0; j<k; ++j) {
      for (l=0, v=0; l<n; ++l) {
        v += Math.pow(xv[l], i + j);
      }
      c[j] = v;
    }
    rhs.push(c);
  }
  rhs.push(lhs);

  const coef = gaussianElimination(rhs),
        predict = x => {
          x -= ux;
          let y = uy + coef[0] + coef[1] * x + coef[2] * x * x;
          for (i=3; i<k; ++i) y += coef[i] * Math.pow(x, i);
          return y;
        };

  return {
    coef: uncenter(k, coef, -ux, uy),
    predict: predict,
    rSquared: r_squared(data, x, y, uy, predict)
  };
});

function uncenter(k, a, x, y) {
  const z = Array(k);
  let i, j, v, c;

  // initialize to zero
  for (i=0; i<k; ++i) z[i] = 0;

  // polynomial expansion
  for (i=k-1; i>=0; --i) {
    v = a[i];
    c = 1;
    z[i] += v;
    for (j=1; j<=i; ++j) {
      c *= (i + 1 - j) / j; // binomial coefficent
      z[i-j] += v * Math.pow(x, j) * c;
    }
  }

  // bias term
  z[0] += y;

  return z;
}

// Given an array for a two-dimensional matrix and the polynomial order,
// solve A * x = b using Gaussian elimination.
function gaussianElimination(matrix) {
  const n = matrix.length - 1,
        coef = [];

  let i, j, k, r, t;

  for (i = 0; i < n; ++i) {
    r = i; // max row
    for (j = i + 1; j < n; ++j) {
      if (Math.abs(matrix[i][j]) > Math.abs(matrix[i][r])) {
        r = j;
      }
    }

    for (k = i; k < n + 1; ++k) {
      t = matrix[k][i];
      matrix[k][i] = matrix[k][r];
      matrix[k][r] = t;
    }

    for (j = i + 1; j < n; ++j) {
      for (k = n; k >= i; k--) {
        matrix[k][j] -= (matrix[k][i] * matrix[i][j]) / matrix[i][i];
      }
    }
  }

  for (j = n - 1; j >= 0; --j) {
    t = 0;
    for (k = j + 1; k < n; ++k) {
      t += matrix[k][j] * coef[k];
    }
    coef[j] = (matrix[n][j] - t) / matrix[j][j];
  }

  return coef;
}
// CONCATENATED MODULE: ./node_modules/d3-array/src/median.js


/* harmony default export */ var median = (function(values, valueof) {
  return quantile(values, 0.5, valueof);
});

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/regression/loess.js




const maxiters = 2,
      epsilon = 1e-12;

// Adapted from science.js by Jason Davies
// Source: https://github.com/jasondavies/science.js/blob/master/src/stats/loess.js
// License: https://github.com/jasondavies/science.js/blob/master/LICENSE
/* harmony default export */ var loess = (function(data, x, y, bandwidth) {
  const [xv, yv, ux, uy] = points_points(data, x, y, true),
        n = xv.length,
        bw = Math.max(2, ~~(bandwidth * n)), // # nearest neighbors
        yhat = new Float64Array(n),
        residuals = new Float64Array(n),
        robustWeights = new Float64Array(n).fill(1);

  for (let iter = -1; ++iter <= maxiters; ) {
    const interval = [0, bw - 1];

    for (let i = 0; i < n; ++i) {
      const dx = xv[i],
            i0 = interval[0],
            i1 = interval[1],
            edge = (dx - xv[i0]) > (xv[i1] - dx) ? i0 : i1;

      let W = 0, X = 0, Y = 0, XY = 0, X2 = 0,
          denom = 1 / Math.abs(xv[edge] - dx || 1); // avoid singularity!

      for (let k = i0; k <= i1; ++k) {
        const xk = xv[k],
              yk = yv[k],
              w = tricube(Math.abs(dx - xk) * denom) * robustWeights[k],
              xkw = xk * w;

        W += w;
        X += xkw;
        Y += yk * w;
        XY += yk * xkw;
        X2 += xk * xkw;
      }

      // linear regression fit
      const [a, b] = ols(X / W, Y / W, XY / W, X2 / W);
      yhat[i] = a + b * dx;
      residuals[i] = Math.abs(yv[i] - yhat[i]);

      updateInterval(xv, i + 1, interval);
    }

    if (iter === maxiters) {
      break;
    }

    const medianResidual = median(residuals);
    if (Math.abs(medianResidual) < epsilon) break;

    for (let i = 0, arg, w; i < n; ++i){
      arg = residuals[i] / (6 * medianResidual);
      // default to epsilon (rather than zero) for large deviations
      // keeping weights tiny but non-zero prevents singularites
      robustWeights[i] = (arg >= 1) ? epsilon : ((w = 1 - arg * arg) * w);
    }
  }

  return loess_output(xv, yhat, ux, uy);
});

// weighting kernel for local regression
function tricube(x) {
  return (x = 1 - x * x * x) * x * x;
}

// advance sliding window interval of nearest neighbors
function updateInterval(xv, i, interval) {
  let val = xv[i],
      left = interval[0],
      right = interval[1] + 1;

  if (right >= xv.length) return;

  // step right if distance to new right edge is <= distance to old left edge
  // step when distance is equal to ensure movement over duplicate x values
  while (i > left && (xv[right] - val) <= (val - xv[left])) {
    interval[0] = ++left;
    interval[1] = right;
    ++right;
  }
}

// generate smoothed output points
// average points with repeated x values
function loess_output(xv, yhat, ux, uy) {
  const n = xv.length, out = [];
  let i = 0, cnt = 0, prev = [], v;

  for (; i<n; ++i) {
    v = xv[i] + ux;
    if (prev[0] === v) {
      // average output values via online update
      prev[1] += (yhat[i] - prev[1]) / (++cnt);
    } else {
      // add new output point
      cnt = 0;
      prev[1] += uy;
      prev = [v, yhat[i]];
      out.push(prev);
    }
  }
  prev[1] += uy;

  return out;
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/src/sampleCurve.js
// subdivide up to accuracy of 0.1 degrees
const MIN_RADIANS = 0.1 * Math.PI / 180;

// Adaptively sample an interpolated function over a domain extent
/* harmony default export */ var sampleCurve = (function(f, extent, minSteps, maxSteps) {
  minSteps = minSteps || 25;
  maxSteps = Math.max(minSteps, maxSteps || 200);

  const point = x => [x, f(x)],
        minX = extent[0],
        maxX = extent[1],
        span = maxX - minX,
        stop = span / maxSteps,
        prev = [point(minX)],
        next = [];

  if (minSteps === maxSteps) {
    // no adaptation, sample uniform grid directly and return
    for (let i = 1; i < maxSteps; ++i) {
      prev.push(point(minX + (i / minSteps) * span));
    }
    prev.push(point(maxX));
    return prev;
  } else {
    // sample minimum points on uniform grid
    // then move on to perform adaptive refinement
    next.push(point(maxX));
    for (let i = minSteps; --i > 0;) {
      next.push(point(minX + (i / minSteps) * span));
    }
  }

  let p0 = prev[0],
      p1 = next[next.length - 1];

  while (p1) {
    // midpoint for potential curve subdivision
    const pm = point((p0[0] + p1[0]) / 2);

    if (pm[0] - p0[0] >= stop && angleDelta(p0, pm, p1) > MIN_RADIANS) {
      // maximum resolution has not yet been met, and
      // subdivision midpoint sufficiently different from endpoint
      // save subdivision, push midpoint onto the visitation stack
      next.push(pm);
    } else {
      // subdivision midpoint sufficiently similar to endpoint
      // skip subdivision, store endpoint, move to next point on the stack
      p0 = p1;
      prev.push(p1);
      next.pop();
    }
    p1 = next[next.length - 1];
  }

  return prev;
});

function angleDelta(p, q, r) {
  const a0 = Math.atan2(r[1] - p[1], r[0] - p[0]),
        a1 = Math.atan2(q[1] - p[1], q[0] - p[0]);
  return Math.abs(a0 - a1);
}

// CONCATENATED MODULE: ./node_modules/vega-statistics/index.js























// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/TupleStore.js




function TupleStore(key) {
  this._key = key ? Object(vega_util["t" /* field */])(key) : tupleid;
  this.reset();
}

var TupleStore_prototype = TupleStore.prototype;

TupleStore_prototype.reset = function() {
  this._add = [];
  this._rem = [];
  this._ext = null;
  this._get = null;
  this._q = null;
};

TupleStore_prototype.add = function(v) {
  this._add.push(v);
};

TupleStore_prototype.rem = function(v) {
  this._rem.push(v);
};

TupleStore_prototype.values = function() {
  this._get = null;
  if (this._rem.length === 0) return this._add;

  var a = this._add,
      r = this._rem,
      k = this._key,
      n = a.length,
      m = r.length,
      x = Array(n - m),
      map = {}, i, j, v;

  // use unique key field to clear removed values
  for (i=0; i<m; ++i) {
    map[k(r[i])] = 1;
  }
  for (i=0, j=0; i<n; ++i) {
    if (map[k(v = a[i])]) {
      map[k(v)] = 0;
    } else {
      x[j++] = v;
    }
  }

  this._rem = [];
  return (this._add = x);
};

// memoizing statistics methods

TupleStore_prototype.distinct = function(get) {
  var v = this.values(),
      n = v.length,
      map = {},
      count = 0, s;

  while (--n >= 0) {
    s = get(v[n]) + '';
    if (!Object(vega_util["v" /* hasOwnProperty */])(map, s)) {
      map[s] = 1;
      ++count;
    }
  }

  return count;
};

TupleStore_prototype.extent = function(get) {
  if (this._get !== get || !this._ext) {
    var v = this.values(),
        i = Object(vega_util["q" /* extentIndex */])(v, get);
    this._ext = [v[i[0]], v[i[1]]];
    this._get = get;
  }
  return this._ext;
};

TupleStore_prototype.argmin = function(get) {
  return this.extent(get)[0] || {};
};

TupleStore_prototype.argmax = function(get) {
  return this.extent(get)[1] || {};
};

TupleStore_prototype.min = function(get) {
  var m = this.extent(get)[0];
  return m != null ? get(m) : undefined;
};

TupleStore_prototype.max = function(get) {
  var m = this.extent(get)[1];
  return m != null ? get(m) : undefined;
};

TupleStore_prototype.quartile = function(get) {
  if (this._get !== get || !this._q) {
    this._q = quartiles(this.values(), get);
    this._get = get;
  }
  return this._q;
};

TupleStore_prototype.q1 = function(get) {
  return this.quartile(get)[0];
};

TupleStore_prototype.q2 = function(get) {
  return this.quartile(get)[1];
};

TupleStore_prototype.q3 = function(get) {
  return this.quartile(get)[2];
};

TupleStore_prototype.ci = function(get) {
  if (this._get !== get || !this._ci) {
    this._ci = bootstrapCI(this.values(), 1000, 0.05, get);
    this._get = get;
  }
  return this._ci;
};

TupleStore_prototype.ci0 = function(get) {
  return this.ci(get)[0];
};

TupleStore_prototype.ci1 = function(get) {
  return this.ci(get)[1];
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Aggregate.js






/**
 * Group-by aggregation operator.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors to groupby.
 * @param {Array<function(object): *>} [params.fields] - An array of accessors to aggregate.
 * @param {Array<string>} [params.ops] - An array of strings indicating aggregation operations.
 * @param {Array<string>} [params.as] - An array of output field names for aggregated values.
 * @param {boolean} [params.cross=false] - A flag indicating that the full
 *   cross-product of groupby values should be generated, including empty cells.
 *   If true, the drop parameter is ignored and empty cells are retained.
 * @param {boolean} [params.drop=true] - A flag indicating if empty cells should be removed.
 */
function Aggregate(params) {
  Transform.call(this, null, params);

  this._adds = []; // array of added output tuples
  this._mods = []; // array of modified output tuples
  this._alen = 0;  // number of active added tuples
  this._mlen = 0;  // number of active modified tuples
  this._drop = true;   // should empty aggregation cells be removed
  this._cross = false; // produce full cross-product of group-by values

  this._dims = [];   // group-by dimension accessors
  this._dnames = []; // group-by dimension names

  this._measures = []; // collection of aggregation monoids
  this._countOnly = false; // flag indicating only count aggregation
  this._counts = null; // collection of count fields
  this._prev = null;   // previous aggregation cells

  this._inputs = null;  // array of dependent input tuple field names
  this._outputs = null; // array of output tuple field names
}

Aggregate.Definition = {
  'type': 'Aggregate',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'ops', 'type': 'enum', 'array': true, 'values': ValidAggregateOps },
    { 'name': 'fields', 'type': 'field', 'null': true, 'array': true },
    { 'name': 'as', 'type': 'string', 'null': true, 'array': true },
    { 'name': 'drop', 'type': 'boolean', 'default': true },
    { 'name': 'cross', 'type': 'boolean', 'default': false },
    { 'name': 'key', 'type': 'field' }
  ]
};

var Aggregate_prototype = Object(vega_util["y" /* inherits */])(Aggregate, Transform);

Aggregate_prototype.transform = function(_, pulse) {
  var aggr = this,
      out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      mod = _.modified();

  aggr.stamp = out.stamp;

  if (aggr.value && (mod || pulse.modified(aggr._inputs, true))) {
    aggr._prev = aggr.value;
    aggr.value = mod ? aggr.init(_) : {};
    pulse.visit(pulse.SOURCE, t => aggr.add(t));
  } else {
    aggr.value = aggr.value || aggr.init(_);
    pulse.visit(pulse.REM, t => aggr.rem(t));
    pulse.visit(pulse.ADD, t => aggr.add(t));
  }

  // Indicate output fields and return aggregate tuples.
  out.modifies(aggr._outputs);

  // Should empty cells be dropped?
  aggr._drop = _.drop !== false;

  // If domain cross-product requested, generate empty cells as needed
  // and ensure that empty cells are not dropped
  if (_.cross && aggr._dims.length > 1) {
    aggr._drop = false;
    aggr.cross();
  }

  if (pulse.clean() && aggr._drop) {
    out.clean(true).runAfter(() => this.clean());
  }

  return aggr.changes(out);
};

Aggregate_prototype.cross = function() {
  var aggr = this,
      curr = aggr.value,
      dims = aggr._dnames,
      vals = dims.map(function() { return {}; }),
      n = dims.length;

  // collect all group-by domain values
  function collect(cells) {
    var key, i, t, v;
    for (key in cells) {
      t = cells[key].tuple;
      for (i=0; i<n; ++i) {
        vals[i][(v = t[dims[i]])] = v;
      }
    }
  }
  collect(aggr._prev);
  collect(curr);

  // iterate over key cross-product, create cells as needed
  function generate(base, tuple, index) {
    var name = dims[index],
        v = vals[index++],
        k, key;

    for (k in v) {
      tuple[name] = v[k];
      key = base ? base + '|' + k : k;
      if (index < n) generate(key, tuple, index);
      else if (!curr[key]) aggr.cell(key, tuple);
    }
  }
  generate('', {}, 0);
};

Aggregate_prototype.init = function(_) {
  // initialize input and output fields
  var inputs = (this._inputs = []),
      outputs = (this._outputs = []),
      inputMap = {};

  function inputVisit(get) {
    var fields = Object(vega_util["i" /* array */])(Object(vega_util["g" /* accessorFields */])(get)),
        i = 0, n = fields.length, f;
    for (; i<n; ++i) {
      if (!inputMap[f=fields[i]]) {
        inputMap[f] = 1;
        inputs.push(f);
      }
    }
  }

  // initialize group-by dimensions
  this._dims = Object(vega_util["i" /* array */])(_.groupby);
  this._dnames = this._dims.map(function(d) {
    var dname = Object(vega_util["h" /* accessorName */])(d);
    inputVisit(d);
    outputs.push(dname);
    return dname;
  });
  this.cellkey = _.key ? _.key : groupkey(this._dims);

  // initialize aggregate measures
  this._countOnly = true;
  this._counts = [];
  this._measures = [];

  var fields = _.fields || [null],
      ops = _.ops || ['count'],
      as = _.as || [],
      n = fields.length,
      map = {},
      field, op, m, mname, outname, i;

  if (n !== ops.length) {
    Object(vega_util["n" /* error */])('Unmatched number of fields and aggregate ops.');
  }

  for (i=0; i<n; ++i) {
    field = fields[i];
    op = ops[i];

    if (field == null && op !== 'count') {
      Object(vega_util["n" /* error */])('Null aggregate field specified.');
    }
    mname = Object(vega_util["h" /* accessorName */])(field);
    outname = measureName(op, mname, as[i]);
    outputs.push(outname);

    if (op === 'count') {
      this._counts.push(outname);
      continue;
    }

    m = map[mname];
    if (!m) {
      inputVisit(field);
      m = (map[mname] = []);
      m.field = field;
      this._measures.push(m);
    }

    if (op !== 'count') this._countOnly = false;
    m.push(createMeasure(op, outname));
  }

  this._measures = this._measures.map(function(m) {
    return compileMeasures(m, m.field);
  });

  return {}; // aggregation cells (this.value)
};

// -- Cell Management -----

Aggregate_prototype.cellkey = groupkey();

Aggregate_prototype.cell = function(key, t) {
  var cell = this.value[key];
  if (!cell) {
    cell = this.value[key] = this.newcell(key, t);
    this._adds[this._alen++] = cell;
  } else if (cell.num === 0 && this._drop && cell.stamp < this.stamp) {
    cell.stamp = this.stamp;
    this._adds[this._alen++] = cell;
  } else if (cell.stamp < this.stamp) {
    cell.stamp = this.stamp;
    this._mods[this._mlen++] = cell;
  }
  return cell;
};

Aggregate_prototype.newcell = function(key, t) {
  var cell = {
    key:   key,
    num:   0,
    agg:   null,
    tuple: this.newtuple(t, this._prev && this._prev[key]),
    stamp: this.stamp,
    store: false
  };

  if (!this._countOnly) {
    var measures = this._measures,
        n = measures.length, i;

    cell.agg = Array(n);
    for (i=0; i<n; ++i) {
      cell.agg[i] = new measures[i](cell);
    }
  }

  if (cell.store) {
    cell.data = new TupleStore();
  }

  return cell;
};

Aggregate_prototype.newtuple = function(t, p) {
  var names = this._dnames,
      dims = this._dims,
      x = {}, i, n;

  for (i=0, n=dims.length; i<n; ++i) {
    x[names[i]] = dims[i](t);
  }

  return p ? replace(p.tuple, x) : ingest(x);
};

Aggregate_prototype.clean = function() {
  const cells = this.value;
  for (const key in cells) {
    if (cells[key].num === 0) {
      delete cells[key];
    }
  }
};

// -- Process Tuples -----

Aggregate_prototype.add = function(t) {
  var key = this.cellkey(t),
      cell = this.cell(key, t),
      agg, i, n;

  cell.num += 1;
  if (this._countOnly) return;

  if (cell.store) cell.data.add(t);

  agg = cell.agg;
  for (i=0, n=agg.length; i<n; ++i) {
    agg[i].add(agg[i].get(t), t);
  }
};

Aggregate_prototype.rem = function(t) {
  var key = this.cellkey(t),
      cell = this.cell(key, t),
      agg, i, n;

  cell.num -= 1;
  if (this._countOnly) return;

  if (cell.store) cell.data.rem(t);

  agg = cell.agg;
  for (i=0, n=agg.length; i<n; ++i) {
    agg[i].rem(agg[i].get(t), t);
  }
};

Aggregate_prototype.celltuple = function(cell) {
  var tuple = cell.tuple,
      counts = this._counts,
      agg, i, n;

  // consolidate stored values
  if (cell.store) {
    cell.data.values();
  }

  // update tuple properties
  for (i=0, n=counts.length; i<n; ++i) {
    tuple[counts[i]] = cell.num;
  }
  if (!this._countOnly) {
    agg = cell.agg;
    for (i=0, n=agg.length; i<n; ++i) {
      agg[i].set(tuple);
    }
  }

  return tuple;
};

Aggregate_prototype.changes = function(out) {
  var adds = this._adds,
      mods = this._mods,
      prev = this._prev,
      drop = this._drop,
      add = out.add,
      rem = out.rem,
      mod = out.mod,
      cell, key, i, n;

  if (prev) for (key in prev) {
    cell = prev[key];
    if (!drop || cell.num) rem.push(cell.tuple);
  }

  for (i=0, n=this._alen; i<n; ++i) {
    add.push(this.celltuple(adds[i]));
    adds[i] = null; // for garbage collection
  }

  for (i=0, n=this._mlen; i<n; ++i) {
    cell = mods[i];
    (cell.num === 0 && drop ? rem : mod).push(this.celltuple(cell));
    mods[i] = null; // for garbage collection
  }

  this._alen = this._mlen = 0; // reset list of active cells
  this._prev = null;
  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Bin.js




// epsilon bias to offset floating point error (#1737)
const EPSILON = 1e-14;

/**
 * Generates a binning function for discretizing data.
 * @constructor
 * @param {object} params - The parameters for this operator. The
 *   provided values should be valid options for the {@link bin} function.
 * @param {function(object): *} params.field - The data field to bin.
 */
function Bin(params) {
  Transform.call(this, null, params);
}

Bin.Definition = {
  'type': 'Bin',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'interval', 'type': 'boolean', 'default': true },
    { 'name': 'anchor', 'type': 'number' },
    { 'name': 'maxbins', 'type': 'number', 'default': 20 },
    { 'name': 'base', 'type': 'number', 'default': 10 },
    { 'name': 'divide', 'type': 'number', 'array': true, 'default': [5, 2] },
    { 'name': 'extent', 'type': 'number', 'array': true, 'length': 2, 'required': true },
    { 'name': 'span', 'type': 'number' },
    { 'name': 'step', 'type': 'number' },
    { 'name': 'steps', 'type': 'number', 'array': true },
    { 'name': 'minstep', 'type': 'number', 'default': 0 },
    { 'name': 'nice', 'type': 'boolean', 'default': true },
    { 'name': 'name', 'type': 'string' },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['bin0', 'bin1'] }
  ]
};

var Bin_prototype = Object(vega_util["y" /* inherits */])(Bin, Transform);

Bin_prototype.transform = function(_, pulse) {
  var band = _.interval !== false,
      bins = this._bins(_),
      start = bins.start,
      step = bins.step,
      as = _.as || ['bin0', 'bin1'],
      b0 = as[0],
      b1 = as[1],
      flag;

  if (_.modified()) {
    pulse = pulse.reflow(true);
    flag = pulse.SOURCE;
  } else {
    flag = pulse.modified(Object(vega_util["g" /* accessorFields */])(_.field)) ? pulse.ADD_MOD : pulse.ADD;
  }

  pulse.visit(flag, band
    ? function(t) {
        var v = bins(t);
        // minimum bin value (inclusive)
        t[b0] = v;
        // maximum bin value (exclusive)
        // use convoluted math for better floating point agreement
        // see https://github.com/vega/vega/issues/830
        // infinite values propagate through this formula! #2227
        t[b1] = v == null ? null : start + step * (1 + (v - start) / step);
      }
    : function(t) { t[b0] = bins(t); }
  );

  return pulse.modifies(band ? as : b0);
};

Bin_prototype._bins = function(_) {
  if (this.value && !_.modified()) {
    return this.value;
  }

  var field = _.field,
      bins  = vega_statistics_src_bin(_),
      step  = bins.step,
      start = bins.start,
      stop  = start + Math.ceil((bins.stop - start) / step) * step,
      a, d;

  if ((a = _.anchor) != null) {
    d = a - (start + step * Math.floor((a - start) / step));
    start += d;
    stop += d;
  }

  var f = function(t) {
    var v = Object(vega_util["cb" /* toNumber */])(field(t));
    return v == null ? null
      : v < start ? -Infinity
      : v > stop ? +Infinity
      : (
          v = Math.max(start, Math.min(v, stop - step)),
          start + step * Math.floor(EPSILON + (v - start) / step)
        );
  };

  f.start = start;
  f.stop = bins.stop;
  f.step = step;

  return this.value = Object(vega_util["f" /* accessor */])(
    f,
    Object(vega_util["g" /* accessorFields */])(field),
    _.name || 'bin_' + Object(vega_util["h" /* accessorName */])(field)
  );
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/SortedList.js


/* harmony default export */ var SortedList = (function(idFunc, source, input) {
  var $ = idFunc,
      data = source || [],
      add = input || [],
      rem = {},
      cnt = 0;

  return {
    add: function(t) { add.push(t); },
    remove: function(t) { rem[$(t)] = ++cnt; },
    size: function() { return data.length; },
    data: function(compare, resort) {
      if (cnt) {
        data = data.filter(function(t) { return !rem[$(t)]; });
        rem = {};
        cnt = 0;
      }
      if (resort && compare) {
        data.sort(compare);
      }
      if (add.length) {
        data = compare
          ? Object(vega_util["M" /* merge */])(compare, data, add.sort(compare))
          : data.concat(add);
        add = [];
      }
      return data;
    }
  };
});
// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Collect.js




/**
 * Collects all data tuples that pass through this operator.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(*,*): number} [params.sort] - An optional
 *   comparator function for additionally sorting the collected tuples.
 */
function Collect(params) {
  Transform.call(this, [], params);
}

Collect.Definition = {
  'type': 'Collect',
  'metadata': {'source': true},
  'params': [
    { 'name': 'sort', 'type': 'compare' }
  ]
};

var Collect_prototype = Object(vega_util["y" /* inherits */])(Collect, Transform);

Collect_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.ALL),
      list = SortedList(tupleid, this.value, out.materialize(out.ADD).add),
      sort = _.sort,
      mod = pulse.changed() || (sort &&
            (_.modified('sort') || pulse.modified(sort.fields)));

  out.visit(out.REM, list.remove);

  this.modified(mod);
  this.value = out.source = list.data(stableCompare(sort), mod);

  // propagate tree root if defined
  if (pulse.source && pulse.source.root) {
    this.value.root = pulse.source.root;
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Compare.js



/**
 * Generates a comparator function.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<string|function>} params.fields - The fields to compare.
 * @param {Array<string>} [params.orders] - The sort orders.
 *   Each entry should be one of "ascending" (default) or "descending".
 */
function Compare(params) {
  Operator.call(this, null, Compare_update, params);
}

Object(vega_util["y" /* inherits */])(Compare, Operator);

function Compare_update(_) {
  return (this.value && !_.modified())
    ? this.value
    : Object(vega_util["k" /* compare */])(_.fields, _.orders);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/CountPattern.js



/**
 * Count regexp-defined pattern occurrences in a text field.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - An accessor for the text field.
 * @param {string} [params.pattern] - RegExp string defining the text pattern.
 * @param {string} [params.case] - One of 'lower', 'upper' or null (mixed) case.
 * @param {string} [params.stopwords] - RegExp string of words to ignore.
 */
function CountPattern(params) {
  Transform.call(this, null, params);
}

CountPattern.Definition = {
  'type': 'CountPattern',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'case', 'type': 'enum', 'values': ['upper', 'lower', 'mixed'], 'default': 'mixed' },
    { 'name': 'pattern', 'type': 'string', 'default': '[\\w"]+' },
    { 'name': 'stopwords', 'type': 'string', 'default': '' },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['text', 'count'] }
  ]
};

function tokenize(text, tcase, match) {
  switch (tcase) {
    case 'upper': text = text.toUpperCase(); break;
    case 'lower': text = text.toLowerCase(); break;
  }
  return text.match(match);
}

var CountPattern_prototype = Object(vega_util["y" /* inherits */])(CountPattern, Transform);

CountPattern_prototype.transform = function(_, pulse) {
  function process(update) {
    return function(tuple) {
      var tokens = tokenize(get(tuple), _.case, match) || [], t;
      for (var i=0, n=tokens.length; i<n; ++i) {
        if (!stop.test(t = tokens[i])) update(t);
      }
    };
  }

  var init = this._parameterCheck(_, pulse),
      counts = this._counts,
      match = this._match,
      stop = this._stop,
      get = _.field,
      as = _.as || ['text', 'count'],
      add = process(function(t) { counts[t] = 1 + (counts[t] || 0); }),
      rem = process(function(t) { counts[t] -= 1; });

  if (init) {
    pulse.visit(pulse.SOURCE, add);
  } else {
    pulse.visit(pulse.ADD, add);
    pulse.visit(pulse.REM, rem);
  }

  return this._finish(pulse, as); // generate output tuples
};

CountPattern_prototype._parameterCheck = function(_, pulse) {
  var init = false;

  if (_.modified('stopwords') || !this._stop) {
    this._stop = new RegExp('^' + (_.stopwords || '') + '$', 'i');
    init = true;
  }

  if (_.modified('pattern') || !this._match) {
    this._match = new RegExp((_.pattern || '[\\w\']+'), 'g');
    init = true;
  }

  if (_.modified('field') || pulse.modified(_.field.fields)) {
    init = true;
  }

  if (init) this._counts = {};
  return init;
};

CountPattern_prototype._finish = function(pulse, as) {
  var counts = this._counts,
      tuples = this._tuples || (this._tuples = {}),
      text = as[0],
      count = as[1],
      out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      w, t, c;

  for (w in counts) {
    t = tuples[w];
    c = counts[w] || 0;
    if (!t && c) {
      tuples[w] = (t = ingest({}));
      t[text] = w;
      t[count] = c;
      out.add.push(t);
    } else if (c === 0) {
      if (t) out.rem.push(t);
      counts[w] = null;
      tuples[w] = null;
    } else if (t[count] !== c) {
      t[count] = c;
      out.mod.push(t);
    }
  }

  return out.modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Cross.js



/**
 * Perform a cross-product of a tuple stream with itself.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object):boolean} [params.filter] - An optional filter
 *   function for selectively including tuples in the cross product.
 * @param {Array<string>} [params.as] - The names of the output fields.
 */
function Cross(params) {
  Transform.call(this, null, params);
}

Cross.Definition = {
  'type': 'Cross',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'filter', 'type': 'expr' },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['a', 'b'] }
  ]
};

var Cross_prototype = Object(vega_util["y" /* inherits */])(Cross, Transform);

Cross_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE),
      data = this.value,
      as = _.as || ['a', 'b'],
      a = as[0], b = as[1],
      reset = !data
          || pulse.changed(pulse.ADD_REM)
          || _.modified('as')
          || _.modified('filter');

  if (reset) {
    if (data) out.rem = data;
    data = pulse.materialize(pulse.SOURCE).source;
    out.add = this.value = cross(data, a, b, _.filter || vega_util["gb" /* truthy */]);
  } else {
    out.mod = data;
  }

  out.source = this.value;
  return out.modifies(as);
};

function cross(input, a, b, filter) {
  var data = [],
      t = {},
      n = input.length,
      i = 0,
      j, left;

  for (; i<n; ++i) {
    t[a] = left = input[i];
    for (j=0; j<n; ++j) {
      t[b] = input[j];
      if (filter(t)) {
        data.push(ingest(t));
        t = {};
        t[a] = left;
      }
    }
  }

  return data;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/Distributions.js




var Distributions = {
  kde:       src_kde,
  mixture:   mixture,
  normal:    src_normal,
  lognormal: lognormal,
  uniform:   uniform
};

var DISTRIBUTIONS = 'distributions',
    FUNCTION = 'function',
    FIELD = 'field';

/**
 * Parse a parameter object for a probability distribution.
 * @param {object} def - The distribution parameter object.
 * @param {function():Array<object>} - A method for requesting
 *   source data. Used for distributions (such as KDE) that
 *   require sample data points. This method will only be
 *   invoked if the 'from' parameter for a target data source
 *   is not provided. Typically this method returns backing
 *   source data for a Pulse object.
 * @return {object} - The output distribution object.
 */
function Distributions_parse(def, data) {
  var func = def[FUNCTION];
  if (!Object(vega_util["v" /* hasOwnProperty */])(Distributions, func)) {
    Object(vega_util["n" /* error */])('Unknown distribution function: ' + func);
  }

  var d = Distributions[func]();

  for (var name in def) {
    // if data field, extract values
    if (name === FIELD) {
      d.data((def.from || data()).map(def[name]));
    }

    // if distribution mixture, recurse to parse each definition
    else if (name === DISTRIBUTIONS) {
      d[name](def[name].map(function(_) { return Distributions_parse(_, data); }));
    }

    // otherwise, simply set the parameter
    else if (typeof d[name] === FUNCTION) {
      d[name](def[name]);
    }
  }

  return d;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Density.js





/**
 * Grid sample points for a probability density. Given a distribution and
 * a sampling extent, will generate points suitable for plotting either
 * PDF (probability density function) or CDF (cumulative distribution
 * function) curves.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {object} params.distribution - The probability distribution. This
 *   is an object parameter dependent on the distribution type.
 * @param {string} [params.method='pdf'] - The distribution method to sample.
 *   One of 'pdf' or 'cdf'.
 * @param {Array<number>} [params.extent] - The [min, max] extent over which
 *   to sample the distribution. This argument is required in most cases, but
 *   can be omitted if the distribution (e.g., 'kde') supports a 'data' method
 *   that returns numerical sample points from which the extent can be deduced.
 * @param {number} [params.minsteps=25] - The minimum number of curve samples
 *   for plotting the density.
 * @param {number} [params.maxsteps=200] - The maximum number of curve samples
 *   for plotting the density.
 * @param {number} [params.steps] - The exact number of curve samples for
 *   plotting the density. If specified, overrides both minsteps and maxsteps
 *   to set an exact number of uniform samples. Useful in conjunction with
 *   a fixed extent to ensure consistent sample points for stacked densities.
 */
function Density(params) {
  Transform.call(this, null, params);
}

var distributions = [
  {
    'key': {'function': 'normal'},
    'params': [
      { 'name': 'mean', 'type': 'number', 'default': 0 },
      { 'name': 'stdev', 'type': 'number', 'default': 1 }
    ]
  },
  {
    'key': {'function': 'lognormal'},
    'params': [
      { 'name': 'mean', 'type': 'number', 'default': 0 },
      { 'name': 'stdev', 'type': 'number', 'default': 1 }
    ]
  },
  {
    'key': {'function': 'uniform'},
    'params': [
      { 'name': 'min', 'type': 'number', 'default': 0 },
      { 'name': 'max', 'type': 'number', 'default': 1 }
    ]
  },
  {
    'key': {'function': 'kde'},
    'params': [
      { 'name': 'field', 'type': 'field', 'required': true },
      { 'name': 'from', 'type': 'data' },
      { 'name': 'bandwidth', 'type': 'number', 'default': 0 }
    ]
  }
];

var Density_mixture = {
  'key': {'function': 'mixture'},
  'params': [
    { 'name': 'distributions', 'type': 'param', 'array': true,
      'params': distributions },
    { 'name': 'weights', 'type': 'number', 'array': true }
  ]
};

Density.Definition = {
  'type': 'Density',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'extent', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'steps', 'type': 'number' },
    { 'name': 'minsteps', 'type': 'number', 'default': 25 },
    { 'name': 'maxsteps', 'type': 'number', 'default': 200 },
    { 'name': 'method', 'type': 'string', 'default': 'pdf',
      'values': ['pdf', 'cdf'] },
    { 'name': 'distribution', 'type': 'param',
      'params': distributions.concat(Density_mixture) },
    { 'name': 'as', 'type': 'string', 'array': true,
      'default': ['value', 'density'] }
  ]
};

var Density_prototype = Object(vega_util["y" /* inherits */])(Density, Transform);

Density_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);

  if (!this.value || pulse.changed() || _.modified()) {
    var dist = Distributions_parse(_.distribution, Density_source(pulse)),
        minsteps = _.steps || _.minsteps || 25,
        maxsteps = _.steps || _.maxsteps || 200,
        method = _.method || 'pdf';

    if (method !== 'pdf' && method !== 'cdf') {
      Object(vega_util["n" /* error */])('Invalid density method: ' + method);
    }
    if (!_.extent && !dist.data) {
      Object(vega_util["n" /* error */])('Missing density extent parameter.');
    }
    method = dist[method];

    var as = _.as || ['value', 'density'],
        domain = _.extent || Object(vega_util["p" /* extent */])(dist.data()),
        values = sampleCurve(method, domain, minsteps, maxsteps).map(v => {
          var tuple = {};
          tuple[as[0]] = v[0];
          tuple[as[1]] = v[1];
          return ingest(tuple);
        });

    if (this.value) out.rem = this.value;
    this.value = out.add = out.source = values;
  }

  return out;
};

function Density_source(pulse) {
  return function() { return pulse.materialize(pulse.SOURCE).source; };
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/util.js


// use either provided alias or accessor field name
function fieldNames(fields, as) {
  if (!fields) return null;
  return fields.map(function(f, i) {
    return as[i] || Object(vega_util["h" /* accessorName */])(f);
  });
}

function util_partition(data, groupby, field) {
  var groups = [],
      get = function(f) { return f(t); },
      map, i, n, t, k, g;

  // partition data points into groups
  if (groupby == null) {
    groups.push(data.map(field));
  } else {
    for (map={}, i=0, n=data.length; i<n; ++i) {
      t = data[i];
      k = groupby.map(get);
      g = map[k];
      if (!g) {
        map[k] = (g = []);
        g.dims = k;
        groups.push(g);
      }
      g.push(field(t));
    }
  }

  return groups;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/DotBin.js





const Output = 'bin';

/**
 * Dot density binning for dot plot construction.
 * Based on Leland Wilkinson, Dot Plots, The American Statistician, 1999.
 * https://www.cs.uic.edu/~wilkinson/Publications/dotplots.pdf
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to bin.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors to groupby.
 * @param {number} [params.step] - The step size (bin width) within which dots should be
 *   stacked. Defaults to 1/30 of the extent of the data *field*.
 * @param {boolean} [params.smooth=false] - A boolean flag indicating if dot density
 *   stacks should be smoothed to reduce variance.
 */
function DotBin(params) {
  Transform.call(this, null, params);
}

DotBin.Definition = {
  'type': 'DotBin',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'step', 'type': 'number' },
    { 'name': 'smooth', 'type': 'boolean', 'default': false },
    { 'name': 'as', 'type': 'string', 'default': Output }
  ]
};

const DotBin_prototype = Object(vega_util["y" /* inherits */])(DotBin, Transform);

DotBin_prototype.transform = function(_, pulse) {
  if (this.value && !(_.modified() || pulse.changed())) {
    return pulse; // early exit
  }

  const source = pulse.materialize(pulse.SOURCE).source,
        groups = util_partition(pulse.source, _.groupby, vega_util["x" /* identity */]),
        smooth = _.smooth || false,
        field = _.field,
        step = _.step || autostep(source, field),
        sort = stableCompare((a, b) => field(a) - field(b)),
        as = _.as || Output,
        n = groups.length;

  // compute dotplot bins per group
  let min = Infinity, max = -Infinity, i = 0, j;
  for (; i<n; ++i) {
    const g = groups[i].sort(sort);
    j = -1;
    for (const v of dotbin(g, step, smooth, field)) {
      if (v < min) min = v;
      if (v > max) max = v;
      g[++j][as] = v;
    }
  }

  this.value = {
    start: min,
    stop: max,
    step: step
  };
  return pulse.reflow(true).modifies(as);
};

function autostep(data, field) {
  return Object(vega_util["X" /* span */])(Object(vega_util["p" /* extent */])(data, field)) / 30;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Expression.js



/**
 * Wraps an expression function with access to external parameters.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function} params.expr - The expression function. The
 *  function should accept both a datum and a parameter object.
 *  This operator's value will be a new function that wraps the
 *  expression function with access to this operator's parameters.
 */
function Expression(params) {
  Operator.call(this, null, Expression_update, params);
  this.modified(true);
}

Object(vega_util["y" /* inherits */])(Expression, Operator);

function Expression_update(_) {
  var expr = _.expr;
  return this.value && !_.modified('expr')
    ? this.value
    : Object(vega_util["f" /* accessor */])(
        datum => expr(datum, _),
        Object(vega_util["g" /* accessorFields */])(expr),
        Object(vega_util["h" /* accessorName */])(expr)
      );
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Extent.js



/**
 * Computes extents (min/max) for a data field.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The field over which to compute extends.
 */
function Extent(params) {
  Transform.call(this, [undefined, undefined], params);
}

Extent.Definition = {
  'type': 'Extent',
  'metadata': {},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true }
  ]
};

var Extent_prototype = Object(vega_util["y" /* inherits */])(Extent, Transform);

Extent_prototype.transform = function(_, pulse) {
  var extent = this.value,
      field = _.field,
      min = extent[0],
      max = extent[1],
      mod;

  mod = pulse.changed()
     || pulse.modified(field.fields)
     || _.modified('field');

  if (mod || min == null) {
    min = +Infinity;
    max = -Infinity;
  }

  pulse.visit(mod ? pulse.SOURCE : pulse.ADD, function(t) {
    var v = Object(vega_util["cb" /* toNumber */])(field(t));
    if (v != null) {
      // NaNs will fail all comparisons!
      if (v < min) min = v;
      if (v > max) max = v;
    }
  });

  if (!Number.isFinite(min) || !Number.isFinite(max)) {
    let name = Object(vega_util["h" /* accessorName */])(field);
    if (name) name = ` for field "${name}"`;
    pulse.dataflow.warn(`Infinite extent${name}: [${min}, ${max}]`);
    min = max = undefined;
  }
  this.value = [min, max];
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Subflow.js



/**
 * Provides a bridge between a parent transform and a target subflow that
 * consumes only a subset of the tuples that pass through the parent.
 * @constructor
 * @param {Pulse} pulse - A pulse to use as the value of this operator.
 * @param {Transform} parent - The parent transform (typically a Facet instance).
 */
function Subflow(pulse, parent) {
  Operator.call(this, pulse);
  this.parent = parent;
  this.count = 0;
}

var Subflow_prototype = Object(vega_util["y" /* inherits */])(Subflow, Operator);

/**
 * Routes pulses from this subflow to a target transform.
 * @param {Transform} target - A transform that receives the subflow of tuples.
 */
Subflow_prototype.connect = function(target) {
  this.detachSubflow = target.detachSubflow;
  this.targets().add(target);
  return (target.source = this);
};

/**
 * Add an 'add' tuple to the subflow pulse.
 * @param {Tuple} t - The tuple being added.
 */
Subflow_prototype.add = function(t) {
  this.count += 1;
  this.value.add.push(t);
};

/**
 * Add a 'rem' tuple to the subflow pulse.
 * @param {Tuple} t - The tuple being removed.
 */
Subflow_prototype.rem = function(t) {
  this.count -= 1;
  this.value.rem.push(t);
};

/**
 * Add a 'mod' tuple to the subflow pulse.
 * @param {Tuple} t - The tuple being modified.
 */
Subflow_prototype.mod = function(t) {
  this.value.mod.push(t);
};

/**
 * Re-initialize this operator's pulse value.
 * @param {Pulse} pulse - The pulse to copy from.
 * @see Pulse.init
 */
Subflow_prototype.init = function(pulse) {
  this.value.init(pulse, pulse.NO_SOURCE);
};

/**
 * Evaluate this operator. This method overrides the
 * default behavior to simply return the contained pulse value.
 * @return {Pulse}
 */
Subflow_prototype.evaluate = function() {
  // assert: this.value.stamp === pulse.stamp
  return this.value;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Facet.js




/**
 * Facets a dataflow into a set of subflows based on a key.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(Dataflow, string): Operator} params.subflow - A function
 *   that generates a subflow of operators and returns its root operator.
 * @param {function(object): *} params.key - The key field to facet by.
 */
function Facet(params) {
  Transform.call(this, {}, params);
  this._keys = Object(vega_util["s" /* fastmap */])(); // cache previously calculated key values

  // keep track of active subflows, use as targets array for listeners
  // this allows us to limit propagation to only updated subflows
  const a = this._targets = [];
  a.active = 0;
  a.forEach = f => {
    for (let i=0, n=a.active; i<n; ++i) {
      f(a[i], i, a);
    }
  };
}

const Facet_prototype = Object(vega_util["y" /* inherits */])(Facet, Transform);

Facet_prototype.activate = function(flow) {
  this._targets[this._targets.active++] = flow;
};

// parent argument provided by PreFacet subclass
Facet_prototype.subflow = function(key, flow, pulse, parent) {
  let flows = this.value,
      sf = Object(vega_util["v" /* hasOwnProperty */])(flows, key) && flows[key],
      df, p;

  if (!sf) {
    p = parent || (p = this._group[key]) && p.tuple;
    df = pulse.dataflow;
    sf = new Subflow(pulse.fork(pulse.NO_SOURCE), this);
    df.add(sf).connect(flow(df, key, p));
    flows[key] = sf;
    this.activate(sf);
  } else if (sf.value.stamp < pulse.stamp) {
    sf.init(pulse);
    this.activate(sf);
  }

  return sf;
};

Facet_prototype.clean = function() {
  const flows = this.value;
  for (const key in flows) {
    if (flows[key].count === 0) {
      const detach = flows[key].detachSubflow;
      if (detach) detach();
      delete flows[key];
    }
  }
};

Facet_prototype.initTargets = function() {
  const a = this._targets,
        n = a.length;
  for (let i=0; i<n && a[i] != null; ++i) {
    a[i] = null; // ensure old flows can be garbage collected
  }
  a.active = 0;
};

Facet_prototype.transform = function(_, pulse) {
  const df = pulse.dataflow,
        key = _.key,
        flow = _.subflow,
        cache = this._keys,
        rekey = _.modified('key'),
        subflow = key => this.subflow(key, flow, pulse);

  this._group = _.group || {};
  this.initTargets(); // reset list of active subflows

  pulse.visit(pulse.REM, t => {
    const id = tupleid(t),
           k = cache.get(id);
    if (k !== undefined) {
      cache.delete(id);
      subflow(k).rem(t);
    }
  });

  pulse.visit(pulse.ADD, t => {
    const k = key(t);
    cache.set(tupleid(t), k);
    subflow(k).add(t);
  });

  if (rekey || pulse.modified(key.fields)) {
    pulse.visit(pulse.MOD, t => {
      const id = tupleid(t),
            k0 = cache.get(id),
            k1 = key(t);
      if (k0 === k1) {
        subflow(k1).mod(t);
      } else {
        cache.set(id, k1);
        subflow(k0).rem(t);
        subflow(k1).add(t);
      }
    });
  } else if (pulse.changed(pulse.MOD)) {
    pulse.visit(pulse.MOD, t => {
      subflow(cache.get(tupleid(t))).mod(t);
    });
  }

  if (rekey) {
    pulse.visit(pulse.REFLOW, t => {
      const id = tupleid(t),
            k0 = cache.get(id),
            k1 = key(t);
      if (k0 !== k1) {
        cache.set(id, k1);
        subflow(k0).rem(t);
        subflow(k1).add(t);
      }
    });
  }

  if (pulse.clean()) {
    df.runAfter(() => { this.clean(); cache.clean(); });
  } else if (cache.empty > df.cleanThreshold) {
    df.runAfter(cache.clean);
  }

  return pulse;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Field.js



/**
 * Generates one or more field accessor functions.
 * If the 'name' parameter is an array, an array of field accessors
 * will be created and the 'as' parameter will be ignored.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {string} params.name - The field name(s) to access.
 * @param {string} params.as - The accessor function name.
 */
function Field(params) {
  Operator.call(this, null, Field_update, params);
}

Object(vega_util["y" /* inherits */])(Field, Operator);

function Field_update(_) {
  return (this.value && !_.modified()) ? this.value
    : Object(vega_util["A" /* isArray */])(_.name) ? Object(vega_util["i" /* array */])(_.name).map(function(f) { return Object(vega_util["t" /* field */])(f); })
    : Object(vega_util["t" /* field */])(_.name, _.as);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Filter.js



/**
 * Filters data tuples according to a predicate function.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.expr - The predicate expression function
 *   that determines a tuple's filter status. Truthy values pass the filter.
 */
function Filter(params) {
  Transform.call(this, Object(vega_util["s" /* fastmap */])(), params);
}

Filter.Definition = {
  'type': 'Filter',
  'metadata': {'changes': true},
  'params': [
    { 'name': 'expr', 'type': 'expr', 'required': true }
  ]
};

var Filter_prototype = Object(vega_util["y" /* inherits */])(Filter, Transform);

Filter_prototype.transform = function(_, pulse) {
  var df = pulse.dataflow,
      cache = this.value, // cache ids of filtered tuples
      output = pulse.fork(),
      add = output.add,
      rem = output.rem,
      mod = output.mod,
      test = _.expr,
      isMod = true;

  pulse.visit(pulse.REM, function(t) {
    var id = tupleid(t);
    if (!cache.has(id)) rem.push(t);
    else cache.delete(id);
  });

  pulse.visit(pulse.ADD, function(t) {
    if (test(t, _)) add.push(t);
    else cache.set(tupleid(t), 1);
  });

  function revisit(t) {
    var id = tupleid(t),
        b = test(t, _),
        s = cache.get(id);
    if (b && s) {
      cache.delete(id);
      add.push(t);
    } else if (!b && !s) {
      cache.set(id, 1);
      rem.push(t);
    } else if (isMod && b && !s) {
      mod.push(t);
    }
  }

  pulse.visit(pulse.MOD, revisit);

  if (_.modified()) {
    isMod = false;
    pulse.visit(pulse.REFLOW, revisit);
  }

  if (cache.empty > df.cleanThreshold) df.runAfter(cache.clean);
  return output;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Flatten.js




/**
 * Flattens array-typed field values into new data objects.
 * If multiple fields are specified, they are treated as parallel arrays,
 * with output values included for each matching index (or null if missing).
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<function(object): *>} params.fields - An array of field
 *   accessors for the tuple fields that should be flattened.
 * @param {string} [params.index] - Optional output field name for index
 *   value. If unspecified, no index field is included in the output.
 * @param {Array<string>} [params.as] - Output field names for flattened
 *   array fields. Any unspecified fields will use the field name provided
 *   by the fields accessors.
 */
function Flatten(params) {
  Transform.call(this, [], params);
}

Flatten.Definition = {
  'type': 'Flatten',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'fields', 'type': 'field', 'array': true, 'required': true },
    { 'name': 'index', 'type': 'string' },
    { 'name': 'as', 'type': 'string', 'array': true }
  ]
};

var Flatten_prototype = Object(vega_util["y" /* inherits */])(Flatten, Transform);

Flatten_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE),
      fields = _.fields,
      as = fieldNames(fields, _.as || []),
      index = _.index || null,
      m = as.length;

  // remove any previous results
  out.rem = this.value;

  // generate flattened tuples
  pulse.visit(pulse.SOURCE, function(t) {
    var arrays = fields.map(f => f(t)),
        maxlen = arrays.reduce((l, a) => Math.max(l, a.length), 0),
        i = 0, j, d, v;

    for (; i<maxlen; ++i) {
      d = Tuple_derive(t);
      for (j=0; j<m; ++j) {
        d[as[j]] = (v = arrays[j][i]) == null ? null : v;
      }
      if (index) {
        d[index] = i;
      }
      out.add.push(d);
    }
  });

  this.value = out.source = out.add;
  if (index) out.modifies(index);
  return out.modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Fold.js



/**
 * Folds one more tuple fields into multiple tuples in which the field
 * name and values are available under new 'key' and 'value' fields.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.fields - An array of field accessors
 *   for the tuple fields that should be folded.
 * @param {Array<string>} [params.as] - Output field names for folded key
 *   and value fields, defaults to ['key', 'value'].
 */
function Fold(params) {
  Transform.call(this, [], params);
}

Fold.Definition = {
  'type': 'Fold',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'fields', 'type': 'field', 'array': true, 'required': true },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['key', 'value'] }
  ]
};

var Fold_prototype = Object(vega_util["y" /* inherits */])(Fold, Transform);

Fold_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE),
      fields = _.fields,
      fnames = fields.map(vega_util["h" /* accessorName */]),
      as = _.as || ['key', 'value'],
      k = as[0],
      v = as[1],
      n = fields.length;

  out.rem = this.value;

  pulse.visit(pulse.SOURCE, function(t) {
    for (var i=0, d; i<n; ++i) {
      d = Tuple_derive(t);
      d[k] = fnames[i];
      d[v] = fields[i](t);
      out.add.push(d);
    }
  });

  this.value = out.source = out.add;
  return out.modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Formula.js



/**
 * Invokes a function for each data tuple and saves the results as a new field.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.expr - The formula function to invoke for each tuple.
 * @param {string} params.as - The field name under which to save the result.
 * @param {boolean} [params.initonly=false] - If true, the formula is applied to
 *   added tuples only, and does not update in response to modifications.
 */
function Formula(params) {
  Transform.call(this, null, params);
}

Formula.Definition = {
  'type': 'Formula',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'expr', 'type': 'expr', 'required': true },
    { 'name': 'as', 'type': 'string', 'required': true },
    { 'name': 'initonly', 'type': 'boolean' }
  ]
};

var Formula_prototype = Object(vega_util["y" /* inherits */])(Formula, Transform);

Formula_prototype.transform = function(_, pulse) {
  var func = _.expr,
      as = _.as,
      mod = _.modified(),
      flag = _.initonly ? pulse.ADD
        : mod ? pulse.SOURCE
        : pulse.modified(func.fields) || pulse.modified(as) ? pulse.ADD_MOD
        : pulse.ADD;

  if (mod) {
    // parameters updated, need to reflow
    pulse = pulse.materialize().reflow(true);
  }

  if (!_.initonly) {
    pulse.modifies(as);
  }

  return pulse.visit(flag, t => t[as] = func(t, _));
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Generate.js



/**
 * Generates data tuples using a provided generator function.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(Parameters): object} params.generator - A tuple generator
 *   function. This function is given the operator parameters as input.
 *   Changes to any additional parameters will not trigger re-calculation
 *   of previously generated tuples. Only future tuples are affected.
 * @param {number} params.size - The number of tuples to produce.
 */
function Generate(params) {
  Transform.call(this, [], params);
}

var Generate_prototype = Object(vega_util["y" /* inherits */])(Generate, Transform);

Generate_prototype.transform = function(_, pulse) {
  var data = this.value,
      out = pulse.fork(pulse.ALL),
      num = _.size - data.length,
      gen = _.generator,
      add, rem, t;

  if (num > 0) {
    // need more tuples, generate and add
    for (add=[]; --num >= 0;) {
      add.push(t = ingest(gen(_)));
      data.push(t);
    }
    out.add = out.add.length
      ? out.materialize(out.ADD).add.concat(add)
      : add;
  } else {
    // need fewer tuples, remove
    rem = data.slice(0, -num);
    out.rem = out.rem.length
      ? out.materialize(out.REM).rem.concat(rem)
      : rem;
    data = data.slice(-num);
  }

  out.source = this.value = data;
  return out;
};

// CONCATENATED MODULE: ./node_modules/d3-array/src/mean.js
function mean_mean(values, valueof) {
  let count = 0;
  let sum = 0;
  if (valueof === undefined) {
    for (let value of values) {
      if (value != null && (value = +value) >= value) {
        ++count, sum += value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if ((value = valueof(value, ++index, values)) != null && (value = +value) >= value) {
        ++count, sum += value;
      }
    }
  }
  if (count) return sum / count;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Impute.js




var Methods = {
  value: 'value',
  median: median,
  mean: mean_mean,
  min: min_min,
  max: max_max
};

var Empty = [];

/**
 * Impute missing values.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to impute.
 * @param {Array<function(object): *>} [params.groupby] - An array of
 *   accessors to determine series within which to perform imputation.
 * @param {function(object): *} params.key - An accessor for a key value.
 *   Each key value should be unique within a group. New tuples will be
 *   imputed for any key values that are not found within a group.
 * @param {Array<*>} [params.keyvals] - Optional array of required key
 *   values. New tuples will be imputed for any key values that are not
 *   found within a group. In addition, these values will be automatically
 *   augmented with the key values observed in the input data.
 * @param {string} [method='value'] - The imputation method to use. One of
 *   'value', 'mean', 'median', 'max', 'min'.
 * @param {*} [value=0] - The constant value to use for imputation
 *   when using method 'value'.
 */
function Impute(params) {
  Transform.call(this, [], params);
}

Impute.Definition = {
  'type': 'Impute',
  'metadata': {'changes': true},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'key', 'type': 'field', 'required': true },
    { 'name': 'keyvals', 'array': true },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'method', 'type': 'enum', 'default': 'value',
      'values': ['value', 'mean', 'median', 'max', 'min'] },
    { 'name': 'value', 'default': 0 }
  ]
};

var Impute_prototype = Object(vega_util["y" /* inherits */])(Impute, Transform);

function getValue(_) {
  var m = _.method || Methods.value, v;

  if (Methods[m] == null) {
    Object(vega_util["n" /* error */])('Unrecognized imputation method: ' + m);
  } else if (m === Methods.value) {
    v = _.value !== undefined ? _.value : 0;
    return function() { return v; };
  } else {
    return Methods[m];
  }
}

function getField(_) {
  var f = _.field;
  return function(t) { return t ? f(t) : NaN; };
}

Impute_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.ALL),
      impute = getValue(_),
      field = getField(_),
      fName = Object(vega_util["h" /* accessorName */])(_.field),
      kName = Object(vega_util["h" /* accessorName */])(_.key),
      gNames = (_.groupby || []).map(vega_util["h" /* accessorName */]),
      groups = Impute_partition(pulse.source, _.groupby, _.key, _.keyvals),
      curr = [],
      prev = this.value,
      m = groups.domain.length,
      group, value, gVals, kVal, g, i, j, l, n, t;

  for (g=0, l=groups.length; g<l; ++g) {
    group = groups[g];
    gVals = group.values;
    value = NaN;

    // add tuples for missing values
    for (j=0; j<m; ++j) {
      if (group[j] != null) continue;
      kVal = groups.domain[j];

      t = {_impute: true};
      for (i=0, n=gVals.length; i<n; ++i) t[gNames[i]] = gVals[i];
      t[kName] = kVal;
      t[fName] = Number.isNaN(value) ? (value = impute(group, field)) : value;

      curr.push(ingest(t));
    }
  }

  // update pulse with imputed tuples
  if (curr.length) out.add = out.materialize(out.ADD).add.concat(curr);
  if (prev.length) out.rem = out.materialize(out.REM).rem.concat(prev);
  this.value = curr;

  return out;
};

function Impute_partition(data, groupby, key, keyvals) {
  var get = function(f) { return f(t); },
      groups = [],
      domain = keyvals ? keyvals.slice() : [],
      kMap = {},
      gMap = {}, gVals, gKey,
      group, i, j, k, n, t;

  domain.forEach(function(k, i) { kMap[k] = i + 1; });

  for (i=0, n=data.length; i<n; ++i) {
    t = data[i];
    k = key(t);
    j = kMap[k] || (kMap[k] = domain.push(k));

    gKey = (gVals = groupby ? groupby.map(get) : Empty) + '';
    if (!(group = gMap[gKey])) {
      group = (gMap[gKey] = []);
      groups.push(group);
      group.values = gVals;
    }
    group[j-1] = t;
  }

  groups.domain = domain;
  return groups;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/JoinAggregate.js




/**
 * Extend input tuples with aggregate values.
 * Calcuates aggregate values and joins them with the input stream.
 * @constructor
 */
function JoinAggregate(params) {
  Aggregate.call(this, params);
}

JoinAggregate.Definition = {
  'type': 'JoinAggregate',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'fields', 'type': 'field', 'null': true, 'array': true },
    { 'name': 'ops', 'type': 'enum', 'array': true, 'values': ValidAggregateOps },
    { 'name': 'as', 'type': 'string', 'null': true, 'array': true },
    { 'name': 'key', 'type': 'field' }
  ]
};

var JoinAggregate_prototype = Object(vega_util["y" /* inherits */])(JoinAggregate, Aggregate);

JoinAggregate_prototype.transform = function(_, pulse) {
  var aggr = this,
      mod = _.modified(),
      cells;

  // process all input tuples to calculate aggregates
  if (aggr.value && (mod || pulse.modified(aggr._inputs, true))) {
    cells = aggr.value = mod ? aggr.init(_) : {};
    pulse.visit(pulse.SOURCE, function(t) { aggr.add(t); });
  } else {
    cells = aggr.value = aggr.value || this.init(_);
    pulse.visit(pulse.REM, function(t) { aggr.rem(t); });
    pulse.visit(pulse.ADD, function(t) { aggr.add(t); });
  }

  // update aggregation cells
  aggr.changes();

  // write aggregate values to input tuples
  pulse.visit(pulse.SOURCE, function(t) {
    Object(vega_util["o" /* extend */])(t, cells[aggr.cellkey(t)].tuple);
  });

  return pulse.reflow(mod).modifies(this._outputs);
};

JoinAggregate_prototype.changes = function() {
  var adds = this._adds,
      mods = this._mods,
      i, n;

  for (i=0, n=this._alen; i<n; ++i) {
    this.celltuple(adds[i]);
    adds[i] = null; // for garbage collection
  }

  for (i=0, n=this._mlen; i<n; ++i) {
    this.celltuple(mods[i]);
    mods[i] = null; // for garbage collection
  }

  this._alen = this._mlen = 0; // reset list of active cells
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/KDE.js






/**
 * Compute kernel density estimates (KDE) for one or more data groups.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors
 *   to groupby.
 * @param {function(object): *} params.field - An accessor for the data field
 *   to estimate.
 * @param {number} [params.bandwidth=0] - The KDE kernel bandwidth.
 *   If zero or unspecified, the bandwidth is automatically determined.
 * @param {boolean} [params.counts=false] - A boolean flag indicating if the
 *   output values should be probability estimates (false, default) or
 *   smoothed counts (true).
 * @param {string} [params.cumulative=false] - A boolean flag indicating if a
 *   density (false) or cumulative distribution (true) should be generated.
 * @param {Array<number>} [params.extent] - The domain extent over which to
 *   plot the density. If unspecified, the [min, max] data extent is used.
 * @param {string} [params.resolve='independent'] - Indicates how parameters for
 *   multiple densities should be resolved. If "independent" (the default), each
 *   density may have its own domain extent and dynamic number of curve sample
 *   steps. If "shared", the KDE transform will ensure that all densities are
 *   defined over a shared domain and curve steps, enabling stacking.
 * @param {number} [params.minsteps=25] - The minimum number of curve samples
 *   for plotting the density.
 * @param {number} [params.maxsteps=200] - The maximum number of curve samples
 *   for plotting the density.
 * @param {number} [params.steps] - The exact number of curve samples for
 *   plotting the density. If specified, overrides both minsteps and maxsteps
 *   to set an exact number of uniform samples. Useful in conjunction with
 *   a fixed extent to ensure consistent sample points for stacked densities.
 */
function KDE(params) {
  Transform.call(this, null, params);
}

KDE.Definition = {
  'type': 'KDE',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'cumulative', 'type': 'boolean', 'default': false },
    { 'name': 'counts', 'type': 'boolean', 'default': false },
    { 'name': 'bandwidth', 'type': 'number', 'default': 0 },
    { 'name': 'extent', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'resolve', 'type': 'enum', 'values': ['shared', 'independent'], 'default': 'independent' },
    { 'name': 'steps', 'type': 'number' },
    { 'name': 'minsteps', 'type': 'number', 'default': 25 },
    { 'name': 'maxsteps', 'type': 'number', 'default': 200 },
    { 'name': 'as', 'type': 'string', 'array': true, 'default': ['value', 'density'] }
  ]
};

var KDE_prototype = Object(vega_util["y" /* inherits */])(KDE, Transform);

KDE_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);

  if (!this.value || pulse.changed() || _.modified()) {
    const source = pulse.materialize(pulse.SOURCE).source,
          groups = util_partition(source, _.groupby, _.field),
          names = (_.groupby || []).map(vega_util["h" /* accessorName */]),
          bandwidth = _.bandwidth,
          method = _.cumulative ? 'cdf' : 'pdf',
          as = _.as || ['value', 'density'],
          values = [];

    let domain = _.extent,
        minsteps = _.steps || _.minsteps || 25,
        maxsteps = _.steps || _.maxsteps || 200;

    if (method !== 'pdf' && method !== 'cdf') {
      Object(vega_util["n" /* error */])('Invalid density method: ' + method);
    }

    if (_.resolve === 'shared') {
      if (!domain) domain = Object(vega_util["p" /* extent */])(source, _.field);
      minsteps = maxsteps = _.steps || maxsteps;
    }

    groups.forEach(g => {
      const density = src_kde(g, bandwidth)[method],
            scale = _.counts ? g.length : 1,
            local = domain || Object(vega_util["p" /* extent */])(g);

      sampleCurve(density, local, minsteps, maxsteps).forEach(v => {
        const t = {};
        for (let i=0; i<names.length; ++i) {
          t[names[i]] = g.dims[i];
        }
        t[as[0]] = v[0];
        t[as[1]] = v[1] * scale;
        values.push(ingest(t));
      });
    });

    if (this.value) out.rem = this.value;
    this.value = out.add = out.source = values;
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Key.js



/**
 * Generates a key function.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<string>} params.fields - The field name(s) for the key function.
 * @param {boolean} params.flat - A boolean flag indicating if the field names
 *  should be treated as flat property names, side-stepping nested field
 *  lookups normally indicated by dot or bracket notation.
 */
function Key(params) {
  Operator.call(this, null, Key_update, params);
}

Object(vega_util["y" /* inherits */])(Key, Operator);

function Key_update(_) {
  return (this.value && !_.modified()) ? this.value : Object(vega_util["I" /* key */])(_.fields, _.flat);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Load.js



/**
 * Load and parse data from an external source. Marshalls parameter
 * values and then invokes the Dataflow request method.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {string} params.url - The URL to load from.
 * @param {object} params.format - The data format options.
 */
function Load(params) {
  Transform.call(this, [], params);
  this._pending = null;
}

var Load_prototype = Object(vega_util["y" /* inherits */])(Load, Transform);

Load_prototype.transform = function(_, pulse) {
  const df = pulse.dataflow;

  if (this._pending) {
    // update state and return pulse
    return Load_output(this, pulse, this._pending);
  }

  if (Load_stop(_)) return pulse.StopPropagation;

  if (_.values) {
    // parse and ingest values, return output pulse
    return Load_output(this, pulse, df.parse(_.values, _.format));
  } else if (_.async) {
    // return promise for non-blocking async loading
    const p = df.request(_.url, _.format).then(res => {
      this._pending = Object(vega_util["i" /* array */])(res.data);
      return df => df.touch(this);
    });
    return {async: p};
  } else {
    // return promise for synchronous loading
    return df.request(_.url, _.format)
      .then(res => Load_output(this, pulse, Object(vega_util["i" /* array */])(res.data)));
  }
};

function Load_stop(_) {
  return _.modified('async') && !(
    _.modified('values') || _.modified('url') || _.modified('format')
  );
}

function Load_output(op, pulse, data) {
  data.forEach(ingest);
  const out = pulse.fork(pulse.NO_FIELDS & pulse.NO_SOURCE);
  out.rem = op.value;
  op.value = out.source = out.add = data;
  op._pending = null;
  if (out.rem.length) out.clean(true);
  return out;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Lookup.js



/**
 * Extend tuples by joining them with values from a lookup table.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Map} params.index - The lookup table map.
 * @param {Array<function(object): *} params.fields - The fields to lookup.
 * @param {Array<string>} params.as - Output field names for each lookup value.
 * @param {*} [params.default] - A default value to use if lookup fails.
 */
function Lookup(params) {
  Transform.call(this, {}, params);
}

Lookup.Definition = {
  'type': 'Lookup',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'index', 'type': 'index', 'params': [
        {'name': 'from', 'type': 'data', 'required': true },
        {'name': 'key', 'type': 'field', 'required': true }
      ] },
    { 'name': 'values', 'type': 'field', 'array': true },
    { 'name': 'fields', 'type': 'field', 'array': true, 'required': true },
    { 'name': 'as', 'type': 'string', 'array': true },
    { 'name': 'default', 'default': null }
  ]
};

var Lookup_prototype = Object(vega_util["y" /* inherits */])(Lookup, Transform);

Lookup_prototype.transform = function(_, pulse) {
  var out = pulse,
      as = _.as,
      keys = _.fields,
      index = _.index,
      values = _.values,
      defaultValue = _.default==null ? null : _.default,
      reset = _.modified(),
      flag = reset ? pulse.SOURCE : pulse.ADD,
      n = keys.length,
      set, m, mods;

  if (values) {
    m = values.length;

    if (n > 1 && !as) {
      Object(vega_util["n" /* error */])('Multi-field lookup requires explicit "as" parameter.');
    }
    if (as && as.length !== n * m) {
      Object(vega_util["n" /* error */])('The "as" parameter has too few output field names.');
    }
    as = as || values.map(vega_util["h" /* accessorName */]);

    set = function(t) {
      for (var i=0, k=0, j, v; i<n; ++i) {
        v = index.get(keys[i](t));
        if (v == null) for (j=0; j<m; ++j, ++k) t[as[k]] = defaultValue;
        else for (j=0; j<m; ++j, ++k) t[as[k]] = values[j](v);
      }
    };
  } else {
    if (!as) {
      Object(vega_util["n" /* error */])('Missing output field names.');
    }

    set = function(t) {
      for (var i=0, v; i<n; ++i) {
        v = index.get(keys[i](t));
        t[as[i]] = v==null ? defaultValue : v;
      }
    };
  }

  if (reset) {
    out = pulse.reflow(true);
  } else {
    mods = keys.some(function(k) { return pulse.modified(k.fields); });
    flag |= (mods ? pulse.MOD : 0);
  }
  pulse.visit(flag, set);

  return out.modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/MultiExtent.js



/**
 * Computes global min/max extents over a collection of extents.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<Array<number>>} params.extents - The input extents.
 */
function MultiExtent(params) {
  Operator.call(this, null, MultiExtent_update, params);
}

Object(vega_util["y" /* inherits */])(MultiExtent, Operator);

function MultiExtent_update(_) {
  if (this.value && !_.modified()) {
    return this.value;
  }

  var min = +Infinity,
      max = -Infinity,
      ext = _.extents,
      i, n, e;

  for (i=0, n=ext.length; i<n; ++i) {
    e = ext[i];
    if (e[0] < min) min = e[0];
    if (e[1] > max) max = e[1];
  }
  return [min, max];
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/MultiValues.js



/**
 * Merge a collection of value arrays.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<Array<*>>} params.values - The input value arrrays.
 */
function MultiValues(params) {
  Operator.call(this, null, MultiValues_update, params);
}

Object(vega_util["y" /* inherits */])(MultiValues, Operator);

function MultiValues_update(_) {
  return (this.value && !_.modified())
    ? this.value
    : _.values.reduce(function(data, _) { return data.concat(_); }, []);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Params.js



/**
 * Operator whose value is simply its parameter hash. This operator is
 * useful for enabling reactive updates to values of nested objects.
 * @constructor
 * @param {object} params - The parameters for this operator.
 */
function Params(params) {
  Transform.call(this, null, params);
}

Object(vega_util["y" /* inherits */])(Params, Transform);

Params.prototype.transform = function(_, pulse) {
  this.modified(_.modified());
  this.value = _;
  return pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS); // do not pass tuples
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Pivot.js




/**
 * Aggregate and pivot selected field values to become new fields.
 * This operator is useful to construction cross-tabulations.
 * @constructor
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors
 *  to groupby. These fields act just like groupby fields of an Aggregate transform.
 * @param {function(object): *} params.field - The field to pivot on. The unique
 *  values of this field become new field names in the output stream.
 * @param {function(object): *} params.value - The field to populate pivoted fields.
 *  The aggregate values of this field become the values of the new pivoted fields.
 * @param {string} [params.op] - The aggregation operation for the value field,
 *  applied per cell in the output stream. The default is "sum".
 * @param {number} [params.limit] - An optional parameter indicating the maximum
 *  number of pivoted fields to generate. The pivoted field names are sorted in
 *  ascending order prior to enforcing the limit.
 */
function Pivot(params) {
  Aggregate.call(this, params);
}

Pivot.Definition = {
  'type': 'Pivot',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'value', 'type': 'field', 'required': true },
    { 'name': 'op', 'type': 'enum', 'values': ValidAggregateOps, 'default': 'sum' },
    { 'name': 'limit', 'type': 'number', 'default': 0 },
    { 'name': 'key', 'type': 'field' }
  ]
};

var Pivot_prototype = Object(vega_util["y" /* inherits */])(Pivot, Aggregate);

Pivot_prototype._transform = Pivot_prototype.transform;

Pivot_prototype.transform = function(_, pulse) {
  return this._transform(aggregateParams(_, pulse), pulse);
};

// Shoehorn a pivot transform into an aggregate transform!
// First collect all unique pivot field values.
// Then generate aggregate fields for each output pivot field.
function aggregateParams(_, pulse) {
  var key    = _.field,
      value  = _.value,
      op     = (_.op === 'count' ? '__count__' : _.op) || 'sum',
      fields = Object(vega_util["g" /* accessorFields */])(key).concat(Object(vega_util["g" /* accessorFields */])(value)),
      keys   = pivotKeys(key, _.limit || 0, pulse);

  // if data stream content changes, pivot fields may change
  // flag parameter modification to ensure re-initialization
  if (pulse.changed()) _.set('__pivot__', null, null, true);

  return {
    key:      _.key,
    groupby:  _.groupby,
    ops:      keys.map(function() { return op; }),
    fields:   keys.map(function(k) { return Pivot_get(k, key, value, fields); }),
    as:       keys.map(function(k) { return k + ''; }),
    modified: _.modified.bind(_)
  };
}

// Generate aggregate field accessor.
// Output NaN for non-existent values; aggregator will ignore!
function Pivot_get(k, key, value, fields) {
  return Object(vega_util["f" /* accessor */])(
    function(d) { return key(d) === k ? value(d) : NaN; },
    fields,
    k + ''
  );
}

// Collect (and optionally limit) all unique pivot values.
function pivotKeys(key, limit, pulse) {
  var map = {},
      list = [];

  pulse.visit(pulse.SOURCE, function(t) {
    var k = key(t);
    if (!map[k]) {
      map[k] = 1;
      list.push(k);
    }
  });

  // TODO? Move this comparator to vega-util?
  list.sort(function(u, v) {
    return (u<v||u==null) && v!=null ? -1
      : (u>v||v==null) && u!=null ? 1
      : ((v=v instanceof Date?+v:v),(u=u instanceof Date?+u:u))!==u && v===v ? -1
      : v!==v && u===u ? 1 : 0;
  });

  return limit ? list.slice(0, limit) : list;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/PreFacet.js




/**
 * Partitions pre-faceted data into tuple subflows.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(Dataflow, string): Operator} params.subflow - A function
 *   that generates a subflow of operators and returns its root operator.
 * @param {function(object): Array<object>} params.field - The field
 *   accessor for an array of subflow tuple objects.
 */
function PreFacet(params) {
  Facet.call(this, params);
}

const PreFacet_prototype = Object(vega_util["y" /* inherits */])(PreFacet, Facet);

PreFacet_prototype.transform = function(_, pulse) {
  const flow = _.subflow,
        field = _.field,
        subflow = t => this.subflow(tupleid(t), flow, pulse, t);

  if (_.modified('field') || field && pulse.modified(Object(vega_util["g" /* accessorFields */])(field))) {
    Object(vega_util["n" /* error */])('PreFacet does not support field modification.');
  }

  this.initTargets(); // reset list of active subflows

  if (field) {
    pulse.visit(pulse.MOD, t => {
      const sf = subflow(t);
      field(t).forEach(_ => sf.mod(_));
    });

    pulse.visit(pulse.ADD, t => {
      const sf = subflow(t);
      field(t).forEach(_ => sf.add(ingest(_)));
    });

    pulse.visit(pulse.REM, t => {
      const sf = subflow(t);
      field(t).forEach(_ => sf.rem(_));
    });
  } else {
    pulse.visit(pulse.MOD, t => subflow(t).mod(t));
    pulse.visit(pulse.ADD, t => subflow(t).add(t));
    pulse.visit(pulse.REM, t => subflow(t).rem(t));
  }

  if (pulse.clean()) {
    pulse.runAfter(() => this.clean());
  }

  return pulse;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Project.js




/**
 * Performs a relational projection, copying selected fields from source
 * tuples to a new set of derived tuples.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<function(object): *} params.fields - The fields to project,
 *   as an array of field accessors. If unspecified, all fields will be
 *   copied with names unchanged.
 * @param {Array<string>} [params.as] - Output field names for each projected
 *   field. Any unspecified fields will use the field name provided by
 *   the field accessor.
 */
function Project(params) {
  Transform.call(this, null, params);
}

Project.Definition = {
  'type': 'Project',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'fields', 'type': 'field', 'array': true },
    { 'name': 'as', 'type': 'string', 'null': true, 'array': true }
  ]
};

var Project_prototype = Object(vega_util["y" /* inherits */])(Project, Transform);

Project_prototype.transform = function(_, pulse) {
  var fields = _.fields,
      as = fieldNames(_.fields, _.as || []),
      derive = fields
        ? function(s, t) { return Project_project(s, t, fields, as); }
        : rederive,
      out, lut;

  if (this.value) {
    lut = this.value;
  } else {
    pulse = pulse.addAll();
    lut = this.value = {};
  }

  out = pulse.fork(pulse.NO_SOURCE);

  pulse.visit(pulse.REM, function(t) {
    var id = tupleid(t);
    out.rem.push(lut[id]);
    lut[id] = null;
  });

  pulse.visit(pulse.ADD, function(t) {
    var dt = derive(t, ingest({}));
    lut[tupleid(t)] = dt;
    out.add.push(dt);
  });

  pulse.visit(pulse.MOD, function(t) {
    out.mod.push(derive(t, lut[tupleid(t)]));
  });

  return out;
};

function Project_project(s, t, fields, as) {
  for (var i=0, n=fields.length; i<n; ++i) {
    t[as[i]] = fields[i](s);
  }
  return t;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Proxy.js



/**
 * Proxy the value of another operator as a pure signal value.
 * Ensures no tuples are propagated.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {*} params.value - The value to proxy, becomes the value of this operator.
 */
function Proxy(params) {
  Transform.call(this, null, params);
}

var Proxy_prototype = Object(vega_util["y" /* inherits */])(Proxy, Transform);

Proxy_prototype.transform = function(_, pulse) {
  this.value = _.value;
  return _.modified('value')
    ? pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS)
    : pulse.StopPropagation;
};

// CONCATENATED MODULE: ./node_modules/d3-array/src/range.js
/* harmony default export */ var src_range = (function(start, stop, step) {
  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;

  var i = -1,
      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
      range = new Array(n);

  while (++i < n) {
    range[i] = start + i * step;
  }

  return range;
});

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Quantile.js






/**
 * Generates sample quantile values from an input data stream.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - An accessor for the data field
 *   over which to calculate quantile values.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors
 *   to groupby.
 * @param {Array<number>} [params.probs] - An array of probabilities in
 *   the range (0, 1) for which to compute quantile values. If not specified,
 *   the *step* parameter will be used.
 * @param {Array<number>} [params.step=0.01] - A probability step size for
 *   sampling quantile values. All values from one-half the step size up to
 *   1 (exclusive) will be sampled. This parameter is only used if the
 *   *quantiles* parameter is not provided.
 */
function Quantile(params) {
  Transform.call(this, null, params);
}

Quantile.Definition = {
  'type': 'Quantile',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'probs', 'type': 'number', 'array': true },
    { 'name': 'step', 'type': 'number', 'default': 0.01 },
    { 'name': 'as', 'type': 'string', 'array': true, 'default': ['prob', 'value'] }
  ]
};

var Quantile_prototype = Object(vega_util["y" /* inherits */])(Quantile, Transform);

var Quantile_EPSILON = 1e-14;

Quantile_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      as = _.as || ['prob', 'value'];

  if (this.value && !_.modified() && !pulse.changed()) {
    out.source = this.value;
    return out;
  }

  const source = pulse.materialize(pulse.SOURCE).source,
        groups = util_partition(source, _.groupby, _.field),
        names = (_.groupby || []).map(vega_util["h" /* accessorName */]),
        values = [],
        step = _.step || 0.01,
        p = _.probs || src_range(step/2, 1 - Quantile_EPSILON, step),
        n = p.length;

  groups.forEach(g => {
    const q = quantiles(g, p);

    for (let i=0; i<n; ++i) {
      const t = {};
      for (let i=0; i<names.length; ++i) {
        t[names[i]] = g.dims[i];
      }
      t[as[0]] = p[i];
      t[as[1]] = q[i];
      values.push(ingest(t));
    }
  });

  if (this.value) out.rem = this.value;
  this.value = out.add = out.source = values;

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Relay.js



/**
 * Relays a data stream between data processing pipelines.
 * If the derive parameter is set, this transform will create derived
 * copies of observed tuples. This provides derived data streams in which
 * modifications to the tuples do not pollute an upstream data source.
 * @param {object} params - The parameters for this operator.
 * @param {number} [params.derive=false] - Boolean flag indicating if
 *   the transform should make derived copies of incoming tuples.
 * @constructor
 */
function Relay(params) {
  Transform.call(this, null, params);
}

var Relay_prototype = Object(vega_util["y" /* inherits */])(Relay, Transform);

Relay_prototype.transform = function(_, pulse) {
  var out, lut;

  if (this.value) {
    lut = this.value;
  } else {
    out = pulse = pulse.addAll();
    lut = this.value = {};
  }

  if (_.derive) {
    out = pulse.fork(pulse.NO_SOURCE);

    pulse.visit(pulse.REM, t => {
      var id = tupleid(t);
      out.rem.push(lut[id]);
      lut[id] = null;
    });

    pulse.visit(pulse.ADD, t => {
      var dt = Tuple_derive(t);
      lut[tupleid(t)] = dt;
      out.add.push(dt);
    });

    pulse.visit(pulse.MOD, t => {
      var dt = lut[tupleid(t)], k;
      for (k in t) {
        dt[k] = t[k];
        // down stream writes may overwrite re-derived tuples
        // conservatively mark all source fields as modified
        out.modifies(k);
      }
      out.mod.push(dt);
    });
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Sample.js




/**
 * Samples tuples passing through this operator.
 * Uses reservoir sampling to maintain a representative sample.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {number} [params.size=1000] - The maximum number of samples.
 */
function Sample(params) {
  Transform.call(this, [], params);
  this.count = 0;
}

Sample.Definition = {
  'type': 'Sample',
  'metadata': {},
  'params': [
    { 'name': 'size', 'type': 'number', 'default': 1000 }
  ]
};

var Sample_prototype = Object(vega_util["y" /* inherits */])(Sample, Transform);

Sample_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE),
      mod = _.modified('size'),
      num = _.size,
      res = this.value,
      cnt = this.count,
      cap = 0,
      map = res.reduce(function(m, t) {
        m[tupleid(t)] = 1;
        return m;
      }, {});

  // sample reservoir update function
  function update(t) {
    var p, idx;

    if (res.length < num) {
      res.push(t);
    } else {
      idx = ~~((cnt + 1) * random_random());
      if (idx < res.length && idx >= cap) {
        p = res[idx];
        if (map[tupleid(p)]) out.rem.push(p); // eviction
        res[idx] = t;
      }
    }
    ++cnt;
  }

  if (pulse.rem.length) {
    // find all tuples that should be removed, add to output
    pulse.visit(pulse.REM, function(t) {
      var id = tupleid(t);
      if (map[id]) {
        map[id] = -1;
        out.rem.push(t);
      }
      --cnt;
    });

    // filter removed tuples out of the sample reservoir
    res = res.filter(function(t) { return map[tupleid(t)] !== -1; });
  }

  if ((pulse.rem.length || mod) && res.length < num && pulse.source) {
    // replenish sample if backing data source is available
    cap = cnt = res.length;
    pulse.visit(pulse.SOURCE, function(t) {
      // update, but skip previously sampled tuples
      if (!map[tupleid(t)]) update(t);
    });
    cap = -1;
  }

  if (mod && res.length > num) {
    for (var i=0, n=res.length-num; i<n; ++i) {
      map[tupleid(res[i])] = -1;
      out.rem.push(res[i]);
    }
    res = res.slice(n);
  }

  if (pulse.mod.length) {
    // propagate modified tuples in the sample reservoir
    pulse.visit(pulse.MOD, function(t) {
      if (map[tupleid(t)]) out.mod.push(t);
    });
  }

  if (pulse.add.length) {
    // update sample reservoir
    pulse.visit(pulse.ADD, update);
  }

  if (pulse.add.length || cap < 0) {
    // output newly added tuples
    out.add = res.filter(function(t) { return !map[tupleid(t)]; });
  }

  this.count = cnt;
  this.value = out.source = res;
  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Sequence.js




/**
 * Generates data tuples for a specified sequence range of numbers.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {number} params.start - The first number in the sequence.
 * @param {number} params.stop - The last number (exclusive) in the sequence.
 * @param {number} [params.step=1] - The step size between numbers in the sequence.
 */
function Sequence(params) {
  Transform.call(this, null, params);
}

Sequence.Definition = {
  'type': 'Sequence',
  'metadata': {'generates': true, 'changes': true},
  'params': [
    { 'name': 'start', 'type': 'number', 'required': true },
    { 'name': 'stop', 'type': 'number', 'required': true },
    { 'name': 'step', 'type': 'number', 'default': 1 },
    { 'name': 'as', 'type': 'string', 'default': 'data' }
  ]
};

var Sequence_prototype = Object(vega_util["y" /* inherits */])(Sequence, Transform);

Sequence_prototype.transform = function(_, pulse) {
  if (this.value && !_.modified()) return;

  var out = pulse.materialize().fork(pulse.MOD),
      as = _.as || 'data';

  out.rem = this.value ? pulse.rem.concat(this.value) : pulse.rem;

  this.value = src_range(_.start, _.stop, _.step || 1).map(function(v) {
    var t = {};
    t[as] = v;
    return ingest(t);
  });

  out.add = pulse.add.concat(this.value);

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Sieve.js



/**
 * Propagates a new pulse without any tuples so long as the input
 * pulse contains some added, removed or modified tuples.
 * @param {object} params - The parameters for this operator.
 * @constructor
 */
function Sieve(params) {
  Transform.call(this, null, params);
  this.modified(true); // always treat as modified
}

var Sieve_prototype = Object(vega_util["y" /* inherits */])(Sieve, Transform);

Sieve_prototype.transform = function(_, pulse) {
  this.value = pulse.source;
  return pulse.changed()
    ? pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS)
    : pulse.StopPropagation;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/TimeUnit.js




/**
 * Discretize dates to specific time units.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The data field containing date/time values.
 */
function TimeUnit(params) {
  Transform.call(this, null, params);
}

const OUTPUT = ['unit0', 'unit1'];

TimeUnit.Definition = {
  'type': 'TimeUnit',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field', 'required': true },
    { 'name': 'interval', 'type': 'boolean', 'default': true },
    { 'name': 'units', 'type': 'enum', 'values': TIME_UNITS, 'array': true },
    { 'name': 'step', 'type': 'number', 'default': 1 },
    { 'name': 'maxbins', 'type': 'number', 'default': 40 },
    { 'name': 'extent', 'type': 'date', 'array': true},
    { 'name': 'timezone', 'type': 'enum', 'default': 'local', 'values': ['local', 'utc'] },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': OUTPUT }
  ]
};

var TimeUnit_prototype = Object(vega_util["y" /* inherits */])(TimeUnit, Transform);

TimeUnit_prototype.transform = function(_, pulse) {
  var field = _.field,
      band = _.interval !== false,
      utc = _.timezone === 'utc',
      floor = this._floor(_, pulse),
      offset = (utc ? utcInterval : timeInterval)(floor.unit).offset,
      as = _.as || OUTPUT,
      u0 = as[0],
      u1 = as[1],
      min = floor.start || Infinity,
      max = floor.stop || -Infinity,
      step = floor.step,
      flag = pulse.ADD;

  if (_.modified() || pulse.modified(Object(vega_util["g" /* accessorFields */])(field))) {
    pulse = pulse.reflow(true);
    flag = pulse.SOURCE;
    min = Infinity;
    max = -Infinity;
  }

  pulse.visit(flag, function(t) {
    var v = field(t), a, b;
    if (v == null) {
      t[u0] = null;
      if (band) t[u1] = null;
    } else {
      t[u0] = a = b = floor(v);
      if (band) t[u1] = b = offset(a, step);
      if (a < min) min = a;
      if (b > max) max = b;
    }
  });

  floor.start = min;
  floor.stop = max;

  return pulse.modifies(band ? as : u0);
};

TimeUnit_prototype._floor = function(_, pulse) {
  const utc = _.timezone === 'utc';

  // get parameters
  let {units, step} = _.units
    ? {units: _.units, step: _.step || 1}
    : src_bin({
      extent:  _.extent || Object(vega_util["p" /* extent */])(pulse.materialize(pulse.SOURCE).source, _.field),
      maxbins: _.maxbins
    });

  // check / standardize time units
  units = timeUnits(units);

  const prev = this.value || {},
        floor = (utc ? utcFloor : timeFloor)(units, step);

  floor.unit = Object(vega_util["U" /* peek */])(units);
  floor.units = units;
  floor.step = step;
  floor.start = prev.start;
  floor.stop = prev.stop;
  return this.value = floor;
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/TupleIndex.js



/**
 * An index that maps from unique, string-coerced, field values to tuples.
 * Assumes that the field serves as a unique key with no duplicate values.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The field accessor to index.
 */
function TupleIndex(params) {
  Transform.call(this, Object(vega_util["s" /* fastmap */])(), params);
}

var TupleIndex_prototype = Object(vega_util["y" /* inherits */])(TupleIndex, Transform);

TupleIndex_prototype.transform = function(_, pulse) {
  var df = pulse.dataflow,
      field = _.field,
      index = this.value,
      mod = true;

  function set(t) { index.set(field(t), t); }

  if (_.modified('field') || pulse.modified(field.fields)) {
    index.clear();
    pulse.visit(pulse.SOURCE, set);
  } else if (pulse.changed()) {
    pulse.visit(pulse.REM, function(t) { index.delete(field(t)); });
    pulse.visit(pulse.ADD, set);
  } else {
    mod = false;
  }

  this.modified(mod);
  if (index.empty > df.cleanThreshold) df.runAfter(index.clean);
  return pulse.fork();
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Values.js



/**
 * Extracts an array of values. Assumes the source data has already been
 * reduced as needed (e.g., by an upstream Aggregate transform).
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The domain field to extract.
 * @param {function(*,*): number} [params.sort] - An optional
 *   comparator function for sorting the values. The comparator will be
 *   applied to backing tuples prior to value extraction.
 */
function Values(params) {
  Transform.call(this, null, params);
}

var Values_prototype = Object(vega_util["y" /* inherits */])(Values, Transform);

Values_prototype.transform = function(_, pulse) {
  var run = !this.value
    || _.modified('field')
    || _.modified('sort')
    || pulse.changed()
    || (_.sort && pulse.modified(_.sort.fields));

  if (run) {
    this.value = (_.sort
      ? pulse.source.slice().sort(stableCompare(_.sort))
      : pulse.source).map(_.field);
  }
};

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/WindowOps.js


function WindowOp(op, field, param, as) {
  let fn = WindowOps[op](field, param);
  return {
    init:   fn.init || vega_util["kb" /* zero */],
    update: function(w, t) { t[as] = fn.next(w); }
  };
}

const WindowOps = {
  row_number: function() {
    return {
      next: w => w.index + 1
    };
  },
  rank: function() {
    let rank;
    return {
      init: () => rank = 1,
      next: w => {
        let i = w.index,
            data = w.data;
        return (i && w.compare(data[i - 1], data[i])) ? (rank = i + 1) : rank;
      }
    };
  },
  dense_rank: function() {
    let drank;
    return {
      init: () => drank = 1,
      next: w => {
        let i = w.index,
            d = w.data;
        return (i && w.compare(d[i - 1], d[i])) ? ++drank : drank;
      }
    };
  },
  percent_rank: function() {
    let rank = WindowOps.rank(),
        next = rank.next;
    return {
      init: rank.init,
      next: w => (next(w) - 1) / (w.data.length - 1)
    };
  },
  cume_dist: function() {
    let cume;
    return {
      init: () => cume = 0,
      next: w => {
        let i = w.index,
            d = w.data,
            c = w.compare;
        if (cume < i) {
          while (i + 1 < d.length && !c(d[i], d[i + 1])) ++i;
          cume = i;
        }
        return (1 + cume) / d.length;
      }
    };
  },
  ntile: function(field, num) {
    num = +num;
    if (!(num > 0)) Object(vega_util["n" /* error */])('ntile num must be greater than zero.');
    let cume = WindowOps.cume_dist(),
        next = cume.next;
    return {
      init: cume.init,
      next: w => Math.ceil(num * next(w))
    };
  },

  lag: function(field, offset) {
    offset = +offset || 1;
    return {
      next: w => {
        let i = w.index - offset;
        return i >= 0 ? field(w.data[i]) : null;
      }
    };
  },
  lead: function(field, offset) {
    offset = +offset || 1;
    return {
      next: w => {
        let i = w.index + offset,
            d = w.data;
        return i < d.length ? field(d[i]) : null;
      }
    };
  },

  first_value: function(field) {
    return {
      next: w => field(w.data[w.i0])
    };
  },
  last_value: function(field) {
    return {
      next: w => field(w.data[w.i1 - 1])
    };
  },
  nth_value: function(field, nth) {
    nth = +nth;
    if (!(nth > 0)) Object(vega_util["n" /* error */])('nth_value nth must be greater than zero.');
    return {
      next: w => {
        let i = w.i0 + (nth - 1);
        return i < w.i1 ? field(w.data[i]) : null;
      }
    };
  },

  prev_value: function(field) {
    let prev;
    return {
      init: () => prev = null,
      next: w => {
        let v = field(w.data[w.index]);
        return v != null ? (prev = v) : prev;
      }
    };
  },
  next_value: function(field) {
    let v, i;
    return {
      init: () => (v = null, i = -1),
      next: w => {
        let d = w.data;
        return w.index <= i ? v
          : (i = find(field, d, w.index)) < 0
            ? (i = d.length, v = null)
            : (v = field(d[i]));
      }
    };
  }
};

function find(field, data, index) {
  for (let n = data.length; index < n; ++index) {
    let v = field(data[index]);
    if (v != null) return index;
  }
  return -1;
}

var ValidWindowOps = Object.keys(WindowOps);

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/util/WindowState.js





function WindowState(_) {
  let self = this,
      ops = Object(vega_util["i" /* array */])(_.ops),
      fields = Object(vega_util["i" /* array */])(_.fields),
      params = Object(vega_util["i" /* array */])(_.params),
      as = Object(vega_util["i" /* array */])(_.as),
      outputs = self.outputs = [],
      windows = self.windows = [],
      inputs = {},
      map = {},
      countOnly = true,
      counts = [],
      measures = [];

  function visitInputs(f) {
    Object(vega_util["i" /* array */])(Object(vega_util["g" /* accessorFields */])(f)).forEach(_ => inputs[_] = 1);
  }
  visitInputs(_.sort);

  ops.forEach(function(op, i) {
    let field = fields[i],
        mname = Object(vega_util["h" /* accessorName */])(field),
        name = measureName(op, mname, as[i]);

    visitInputs(field);
    outputs.push(name);

    // Window operation
    if (Object(vega_util["v" /* hasOwnProperty */])(WindowOps, op)) {
      windows.push(WindowOp(op, fields[i], params[i], name));
    }

    // Aggregate operation
    else {
      if (field == null && op !== 'count') {
        Object(vega_util["n" /* error */])('Null aggregate field specified.');
      }
      if (op === 'count') {
        counts.push(name);
        return;
      }

      countOnly = false;
      let m = map[mname];
      if (!m) {
        m = (map[mname] = []);
        m.field = field;
        measures.push(m);
      }
      m.push(createMeasure(op, name));
    }
  });

  if (counts.length || measures.length) {
    self.cell = WindowState_cell(measures, counts, countOnly);
  }

  self.inputs = Object.keys(inputs);
}

const WindowState_prototype = WindowState.prototype;

WindowState_prototype.init = function() {
  this.windows.forEach(_ => _.init());
  if (this.cell) this.cell.init();
};

WindowState_prototype.update = function(w, t) {
  let self = this,
      cell = self.cell,
      wind = self.windows,
      data = w.data,
      m = wind && wind.length,
      j;

  if (cell) {
    for (j=w.p0; j<w.i0; ++j) cell.rem(data[j]);
    for (j=w.p1; j<w.i1; ++j) cell.add(data[j]);
    cell.set(t);
  }
  for (j=0; j<m; ++j) wind[j].update(w, t);
};

function WindowState_cell(measures, counts, countOnly) {
  measures = measures.map(m => compileMeasures(m, m.field));

  let cell = {
    num:   0,
    agg:   null,
    store: false,
    count: counts
  };

  if (!countOnly) {
    var n = measures.length,
        a = cell.agg = Array(n),
        i = 0;
    for (; i<n; ++i) a[i] = new measures[i](cell);
  }

  if (cell.store) {
    var store = cell.data = new TupleStore();
  }

  cell.add = function(t) {
    cell.num += 1;
    if (countOnly) return;
    if (store) store.add(t);
    for (let i=0; i<n; ++i) {
      a[i].add(a[i].get(t), t);
    }
  };

  cell.rem = function(t) {
    cell.num -= 1;
    if (countOnly) return;
    if (store) store.rem(t);
    for (let i=0; i<n; ++i) {
      a[i].rem(a[i].get(t), t);
    }
  };

  cell.set = function(t) {
    let i, n;

    // consolidate stored values
    if (store) store.values();

    // update tuple properties
    for (i=0, n=counts.length; i<n; ++i) t[counts[i]] = cell.num;
    if (!countOnly) for (i=0, n=a.length; i<n; ++i) a[i].set(t);
  };

  cell.init = function() {
    cell.num = 0;
    if (store) store.reset();
    for (let i=0; i<n; ++i) a[i].init();
  };

  return cell;
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/src/Window.js









/**
 * Perform window calculations and write results to the input stream.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(*,*): number} [params.sort] - A comparator function for sorting tuples within a window.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors by which to partition tuples into separate windows.
 * @param {Array<string>} params.ops - An array of strings indicating window operations to perform.
 * @param {Array<function(object): *>} [params.fields] - An array of accessors
 *   for data fields to use as inputs to window operations.
 * @param {Array<*>} [params.params] - An array of parameter values for window operations.
 * @param {Array<string>} [params.as] - An array of output field names for window operations.
 * @param {Array<number>} [params.frame] - Window frame definition as two-element array.
 * @param {boolean} [params.ignorePeers=false] - If true, base window frame boundaries on row
 *   number alone, ignoring peers with identical sort values. If false (default),
 *   the window boundaries will be adjusted to include peer values.
 */
function Window(params) {
  Transform.call(this, {}, params);
  this._mlen = 0;
  this._mods = [];
}

Window.Definition = {
  'type': 'Window',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'ops', 'type': 'enum', 'array': true, 'values': ValidWindowOps.concat(ValidAggregateOps) },
    { 'name': 'params', 'type': 'number', 'null': true, 'array': true },
    { 'name': 'fields', 'type': 'field', 'null': true, 'array': true },
    { 'name': 'as', 'type': 'string', 'null': true, 'array': true },
    { 'name': 'frame', 'type': 'number', 'null': true, 'array': true, 'length': 2, 'default': [null, 0] },
    { 'name': 'ignorePeers', 'type': 'boolean', 'default': false }
  ]
};

var Window_prototype = Object(vega_util["y" /* inherits */])(Window, Transform);

Window_prototype.transform = function(_, pulse) {
  var self = this,
      state = self.state,
      mod = _.modified(),
      cmp = stableCompare(_.sort),
      i, n;

  this.stamp = pulse.stamp;

  // initialize window state
  if (!state || mod) {
    state = self.state = new WindowState(_);
  }

  // retrieve group for a tuple
  var key = groupkey(_.groupby);
  function group(t) { return self.group(key(t)); }

  // partition input tuples
  if (mod || pulse.modified(state.inputs)) {
    self.value = {};
    pulse.visit(pulse.SOURCE, function(t) { group(t).add(t); });
  } else {
    pulse.visit(pulse.REM, function(t) { group(t).remove(t); });
    pulse.visit(pulse.ADD, function(t) { group(t).add(t); });
  }

  // perform window calculations for each modified partition
  for (i=0, n=self._mlen; i<n; ++i) {
    processPartition(self._mods[i], state, cmp, _);
  }
  self._mlen = 0;
  self._mods = [];

  // TODO don't reflow everything?
  return pulse.reflow(mod).modifies(state.outputs);
};

Window_prototype.group = function(key) {
  var self = this,
      group = self.value[key];

  if (!group) {
    group = self.value[key] = SortedList(tupleid);
    group.stamp = -1;
  }

  if (group.stamp < self.stamp) {
    group.stamp = self.stamp;
    self._mods[self._mlen++] = group;
  }

  return group;
};

function processPartition(list, state, cmp, _) {
  var sort = _.sort,
      range = sort && !_.ignorePeers,
      frame = _.frame || [null, 0],
      data = list.data(cmp), // use cmp for stable sort
      n = data.length,
      i = 0,
      b = range ? bisector(sort) : null,
      w = {
        i0: 0, i1: 0, p0: 0, p1: 0, index: 0,
        data: data, compare: sort || Object(vega_util["l" /* constant */])(-1)
      };

  for (state.init(); i<n; ++i) {
    setWindow(w, frame, i, n);
    if (range) adjustRange(w, b);
    state.update(w, data[i]);
  }
}

function setWindow(w, f, i, n) {
  w.p0 = w.i0;
  w.p1 = w.i1;
  w.i0 = f[0] == null ? 0 : Math.max(0, i - Math.abs(f[0]));
  w.i1 = f[1] == null ? n : Math.min(n, i + Math.abs(f[1]) + 1);
  w.index = i;
}

// if frame type is 'range', adjust window for peer values
function adjustRange(w, bisect) {
  var r0 = w.i0,
      r1 = w.i1 - 1,
      c = w.compare,
      d = w.data,
      n = d.length - 1;

  if (r0 > 0 && !c(d[r0], d[r0-1])) w.i0 = bisect.left(d, d[r0]);
  if (r1 < n && !c(d[r1], d[r1+1])) w.i1 = bisect.right(d, d[r1]);
}

// CONCATENATED MODULE: ./node_modules/vega-transforms/index.js









































// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/constants.js
const Top = 'top';
const Left = 'left';
const Right = 'right';
const Bottom = 'bottom';

const TopLeft = 'top-left';
const TopRight = 'top-right';
const BottomLeft = 'bottom-left';
const BottomRight = 'bottom-right';

const Start = 'start';
const Middle = 'middle';
const End = 'end';

const constants_X = 'x';
const constants_Y = 'y';

const Group = 'group';

const AxisRole = 'axis';
const TitleRole = 'title';
const FrameRole = 'frame';
const ScopeRole = 'scope';
const LegendRole = 'legend';

const RowHeader = 'row-header';
const RowFooter = 'row-footer';
const RowTitle  = 'row-title';
const ColHeader = 'column-header';
const ColFooter = 'column-footer';
const ColTitle  = 'column-title';

const Padding = 'padding';

const Symbols = 'symbol';

const Fit  = 'fit';
const FitX = 'fit-x';
const FitY = 'fit-y';
const Pad  = 'pad';
const None = 'none';

const All = 'all';
const Each = 'each';
const Flush = 'flush';

const Column = 'column';
const Row = 'row';

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Gradient.js
var gradient_id = 0;

function resetSVGGradientId() {
  gradient_id = 0;
}

const patternPrefix = 'p_';

function isGradient(value) {
  return value && value.gradient;
}

function gradientRef(g, defs, base) {
  let id = g.id,
      type = g.gradient,
      prefix = type === 'radial' ? patternPrefix : '';

  // check id, assign default values as needed
  if (!id) {
    id = g.id = 'gradient_' + (gradient_id++);
    if (type === 'radial') {
      g.x1 = Gradient_get(g.x1, 0.5);
      g.y1 = Gradient_get(g.y1, 0.5);
      g.r1 = Gradient_get(g.r1, 0);
      g.x2 = Gradient_get(g.x2, 0.5);
      g.y2 = Gradient_get(g.y2, 0.5);
      g.r2 = Gradient_get(g.r2, 0.5);
      prefix = patternPrefix;
    } else {
      g.x1 = Gradient_get(g.x1, 0);
      g.y1 = Gradient_get(g.y1, 0);
      g.x2 = Gradient_get(g.x2, 1);
      g.y2 = Gradient_get(g.y2, 0);
    }
  }

  // register definition
  defs[id] = g;

  // return url reference
  return 'url(' + (base || '') + '#' + prefix + id + ')';
}

function Gradient_get(val, def) {
  return val != null ? val : def;
}

/* harmony default export */ var Gradient = (function(p0, p1) {
  var stops = [], gradient;
  return gradient = {
    gradient: 'linear',
    x1: p0 ? p0[0] : 0,
    y1: p0 ? p0[1] : 0,
    x2: p1 ? p1[0] : 1,
    y2: p1 ? p1[1] : 0,
    stops: stops,
    stop: function(offset, color) {
      stops.push({offset: offset, color: color});
      return gradient;
    }
  };
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/basis.js
function basis_point(that, x, y) {
  that._context.bezierCurveTo(
    (2 * that._x0 + that._x1) / 3,
    (2 * that._y0 + that._y1) / 3,
    (that._x0 + 2 * that._x1) / 3,
    (that._y0 + 2 * that._y1) / 3,
    (that._x0 + 4 * that._x1 + x) / 6,
    (that._y0 + 4 * that._y1 + y) / 6
  );
}

function Basis(context) {
  this._context = context;
}

Basis.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 =
    this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 3: basis_point(this, this._x1, this._y1); // proceed
      case 2: this._context.lineTo(this._x1, this._y1); break;
    }
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6); // proceed
      default: basis_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = x;
    this._y0 = this._y1, this._y1 = y;
  }
};

/* harmony default export */ var basis = (function(context) {
  return new Basis(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/noop.js
/* harmony default export */ var src_noop = (function() {});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/basisClosed.js



function BasisClosed(context) {
  this._context = context;
}

BasisClosed.prototype = {
  areaStart: src_noop,
  areaEnd: src_noop,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 =
    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x2, this._y2);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x2, this._y2);
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        break;
      }
    }
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._x2 = x, this._y2 = y; break;
      case 1: this._point = 2; this._x3 = x, this._y3 = y; break;
      case 2: this._point = 3; this._x4 = x, this._y4 = y; this._context.moveTo((this._x0 + 4 * this._x1 + x) / 6, (this._y0 + 4 * this._y1 + y) / 6); break;
      default: basis_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = x;
    this._y0 = this._y1, this._y1 = y;
  }
};

/* harmony default export */ var basisClosed = (function(context) {
  return new BasisClosed(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/basisOpen.js


function BasisOpen(context) {
  this._context = context;
}

BasisOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 =
    this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; var x0 = (this._x0 + 4 * this._x1 + x) / 6, y0 = (this._y0 + 4 * this._y1 + y) / 6; this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0); break;
      case 3: this._point = 4; // proceed
      default: basis_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = x;
    this._y0 = this._y1, this._y1 = y;
  }
};

/* harmony default export */ var basisOpen = (function(context) {
  return new BasisOpen(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/bundle.js


function Bundle(context, beta) {
  this._basis = new Basis(context);
  this._beta = beta;
}

Bundle.prototype = {
  lineStart: function() {
    this._x = [];
    this._y = [];
    this._basis.lineStart();
  },
  lineEnd: function() {
    var x = this._x,
        y = this._y,
        j = x.length - 1;

    if (j > 0) {
      var x0 = x[0],
          y0 = y[0],
          dx = x[j] - x0,
          dy = y[j] - y0,
          i = -1,
          t;

      while (++i <= j) {
        t = i / j;
        this._basis.point(
          this._beta * x[i] + (1 - this._beta) * (x0 + t * dx),
          this._beta * y[i] + (1 - this._beta) * (y0 + t * dy)
        );
      }
    }

    this._x = this._y = null;
    this._basis.lineEnd();
  },
  point: function(x, y) {
    this._x.push(+x);
    this._y.push(+y);
  }
};

/* harmony default export */ var curve_bundle = ((function custom(beta) {

  function bundle(context) {
    return beta === 1 ? new Basis(context) : new Bundle(context, beta);
  }

  bundle.beta = function(beta) {
    return custom(+beta);
  };

  return bundle;
})(0.85));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/cardinal.js
function cardinal_point(that, x, y) {
  that._context.bezierCurveTo(
    that._x1 + that._k * (that._x2 - that._x0),
    that._y1 + that._k * (that._y2 - that._y0),
    that._x2 + that._k * (that._x1 - x),
    that._y2 + that._k * (that._y1 - y),
    that._x2,
    that._y2
  );
}

function Cardinal(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}

Cardinal.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 =
    this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2: this._context.lineTo(this._x2, this._y2); break;
      case 3: cardinal_point(this, this._x1, this._y1); break;
    }
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; this._x1 = x, this._y1 = y; break;
      case 2: this._point = 3; // proceed
      default: cardinal_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var cardinal = ((function custom(tension) {

  function cardinal(context) {
    return new Cardinal(context, tension);
  }

  cardinal.tension = function(tension) {
    return custom(+tension);
  };

  return cardinal;
})(0));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/cardinalOpen.js


function CardinalOpen(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}

CardinalOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 =
    this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;
      case 3: this._point = 4; // proceed
      default: cardinal_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var cardinalOpen = ((function custom(tension) {

  function cardinal(context) {
    return new CardinalOpen(context, tension);
  }

  cardinal.tension = function(tension) {
    return custom(+tension);
  };

  return cardinal;
})(0));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/cardinalClosed.js



function CardinalClosed(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}

CardinalClosed.prototype = {
  areaStart: src_noop,
  areaEnd: src_noop,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =
    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;
      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;
      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;
      default: cardinal_point(this, x, y); break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var cardinalClosed = ((function custom(tension) {

  function cardinal(context) {
    return new CardinalClosed(context, tension);
  }

  cardinal.tension = function(tension) {
    return custom(+tension);
  };

  return cardinal;
})(0));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/math.js
var abs = Math.abs;
var atan2 = Math.atan2;
var math_cos = Math.cos;
var math_max = Math.max;
var math_min = Math.min;
var math_sin = Math.sin;
var sqrt = Math.sqrt;

var math_epsilon = 1e-12;
var pi = Math.PI;
var halfPi = pi / 2;
var tau = 2 * pi;

function acos(x) {
  return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);
}

function asin(x) {
  return x >= 1 ? halfPi : x <= -1 ? -halfPi : Math.asin(x);
}

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/catmullRom.js



function catmullRom_point(that, x, y) {
  var x1 = that._x1,
      y1 = that._y1,
      x2 = that._x2,
      y2 = that._y2;

  if (that._l01_a > math_epsilon) {
    var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a,
        n = 3 * that._l01_a * (that._l01_a + that._l12_a);
    x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
    y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
  }

  if (that._l23_a > math_epsilon) {
    var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a,
        m = 3 * that._l23_a * (that._l23_a + that._l12_a);
    x2 = (x2 * b + that._x1 * that._l23_2a - x * that._l12_2a) / m;
    y2 = (y2 * b + that._y1 * that._l23_2a - y * that._l12_2a) / m;
  }

  that._context.bezierCurveTo(x1, y1, x2, y2, that._x2, that._y2);
}

function CatmullRom(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}

CatmullRom.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 =
    this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a =
    this._l01_2a = this._l12_2a = this._l23_2a =
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2: this._context.lineTo(this._x2, this._y2); break;
      case 3: this.point(this._x2, this._y2); break;
    }
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;

    if (this._point) {
      var x23 = this._x2 - x,
          y23 = this._y2 - y;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }

    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; // proceed
      default: catmullRom_point(this, x, y); break;
    }

    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var curve_catmullRom = ((function custom(alpha) {

  function catmullRom(context) {
    return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
  }

  catmullRom.alpha = function(alpha) {
    return custom(+alpha);
  };

  return catmullRom;
})(0.5));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/catmullRomClosed.js




function CatmullRomClosed(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}

CatmullRomClosed.prototype = {
  areaStart: src_noop,
  areaEnd: src_noop,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =
    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._l01_a = this._l12_a = this._l23_a =
    this._l01_2a = this._l12_2a = this._l23_2a =
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x, y) {
    x = +x, y = +y;

    if (this._point) {
      var x23 = this._x2 - x,
          y23 = this._y2 - y;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }

    switch (this._point) {
      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;
      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;
      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;
      default: catmullRom_point(this, x, y); break;
    }

    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var catmullRomClosed = ((function custom(alpha) {

  function catmullRom(context) {
    return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
  }

  catmullRom.alpha = function(alpha) {
    return custom(+alpha);
  };

  return catmullRom;
})(0.5));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/catmullRomOpen.js



function CatmullRomOpen(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}

CatmullRomOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 =
    this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a =
    this._l01_2a = this._l12_2a = this._l23_2a =
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;

    if (this._point) {
      var x23 = this._x2 - x,
          y23 = this._y2 - y;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }

    switch (this._point) {
      case 0: this._point = 1; break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;
      case 3: this._point = 4; // proceed
      default: catmullRom_point(this, x, y); break;
    }

    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
  }
};

/* harmony default export */ var catmullRomOpen = ((function custom(alpha) {

  function catmullRom(context) {
    return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
  }

  catmullRom.alpha = function(alpha) {
    return custom(+alpha);
  };

  return catmullRom;
})(0.5));

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/linear.js
function Linear(context) {
  this._context = context;
}

Linear.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; // proceed
      default: this._context.lineTo(x, y); break;
    }
  }
};

/* harmony default export */ var curve_linear = (function(context) {
  return new Linear(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/linearClosed.js


function LinearClosed(context) {
  this._context = context;
}

LinearClosed.prototype = {
  areaStart: src_noop,
  areaEnd: src_noop,
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._point) this._context.closePath();
  },
  point: function(x, y) {
    x = +x, y = +y;
    if (this._point) this._context.lineTo(x, y);
    else this._point = 1, this._context.moveTo(x, y);
  }
};

/* harmony default export */ var linearClosed = (function(context) {
  return new LinearClosed(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/monotone.js
function monotone_sign(x) {
  return x < 0 ? -1 : 1;
}

// Calculate the slopes of the tangents (Hermite-type interpolation) based on
// the following paper: Steffen, M. 1990. A Simple Method for Monotonic
// Interpolation in One Dimension. Astronomy and Astrophysics, Vol. 239, NO.
// NOV(II), P. 443, 1990.
function slope3(that, x2, y2) {
  var h0 = that._x1 - that._x0,
      h1 = x2 - that._x1,
      s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0),
      s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0),
      p = (s0 * h1 + s1 * h0) / (h0 + h1);
  return (monotone_sign(s0) + monotone_sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
}

// Calculate a one-sided slope.
function slope2(that, t) {
  var h = that._x1 - that._x0;
  return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
}

// According to https://en.wikipedia.org/wiki/Cubic_Hermite_spline#Representations
// "you can express cubic Hermite interpolation in terms of cubic Bézier curves
// with respect to the four values p0, p0 + m0 / 3, p1 - m1 / 3, p1".
function monotone_point(that, t0, t1) {
  var x0 = that._x0,
      y0 = that._y0,
      x1 = that._x1,
      y1 = that._y1,
      dx = (x1 - x0) / 3;
  that._context.bezierCurveTo(x0 + dx, y0 + dx * t0, x1 - dx, y1 - dx * t1, x1, y1);
}

function MonotoneX(context) {
  this._context = context;
}

MonotoneX.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 =
    this._y0 = this._y1 =
    this._t0 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2: this._context.lineTo(this._x1, this._y1); break;
      case 3: monotone_point(this, this._t0, slope2(this, this._t0)); break;
    }
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    var t1 = NaN;

    x = +x, y = +y;
    if (x === this._x1 && y === this._y1) return; // Ignore coincident points.
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; break;
      case 2: this._point = 3; monotone_point(this, slope2(this, t1 = slope3(this, x, y)), t1); break;
      default: monotone_point(this, this._t0, t1 = slope3(this, x, y)); break;
    }

    this._x0 = this._x1, this._x1 = x;
    this._y0 = this._y1, this._y1 = y;
    this._t0 = t1;
  }
}

function MonotoneY(context) {
  this._context = new ReflectContext(context);
}

(MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x, y) {
  MonotoneX.prototype.point.call(this, y, x);
};

function ReflectContext(context) {
  this._context = context;
}

ReflectContext.prototype = {
  moveTo: function(x, y) { this._context.moveTo(y, x); },
  closePath: function() { this._context.closePath(); },
  lineTo: function(x, y) { this._context.lineTo(y, x); },
  bezierCurveTo: function(x1, y1, x2, y2, x, y) { this._context.bezierCurveTo(y1, x1, y2, x2, y, x); }
};

function monotoneX(context) {
  return new MonotoneX(context);
}

function monotoneY(context) {
  return new MonotoneY(context);
}

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/natural.js
function Natural(context) {
  this._context = context;
}

Natural.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = [];
    this._y = [];
  },
  lineEnd: function() {
    var x = this._x,
        y = this._y,
        n = x.length;

    if (n) {
      this._line ? this._context.lineTo(x[0], y[0]) : this._context.moveTo(x[0], y[0]);
      if (n === 2) {
        this._context.lineTo(x[1], y[1]);
      } else {
        var px = controlPoints(x),
            py = controlPoints(y);
        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
          this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x[i1], y[i1]);
        }
      }
    }

    if (this._line || (this._line !== 0 && n === 1)) this._context.closePath();
    this._line = 1 - this._line;
    this._x = this._y = null;
  },
  point: function(x, y) {
    this._x.push(+x);
    this._y.push(+y);
  }
};

// See https://www.particleincell.com/2012/bezier-splines/ for derivation.
function controlPoints(x) {
  var i,
      n = x.length - 1,
      m,
      a = new Array(n),
      b = new Array(n),
      r = new Array(n);
  a[0] = 0, b[0] = 2, r[0] = x[0] + 2 * x[1];
  for (i = 1; i < n - 1; ++i) a[i] = 1, b[i] = 4, r[i] = 4 * x[i] + 2 * x[i + 1];
  a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x[n - 1] + x[n];
  for (i = 1; i < n; ++i) m = a[i] / b[i - 1], b[i] -= m, r[i] -= m * r[i - 1];
  a[n - 1] = r[n - 1] / b[n - 1];
  for (i = n - 2; i >= 0; --i) a[i] = (r[i] - a[i + 1]) / b[i];
  b[n - 1] = (x[n] + a[n - 1]) / 2;
  for (i = 0; i < n - 1; ++i) b[i] = 2 * x[i + 1] - a[i + 1];
  return [a, b];
}

/* harmony default export */ var natural = (function(context) {
  return new Natural(context);
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/curve/step.js
function Step(context, t) {
  this._context = context;
  this._t = t;
}

Step.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = this._y = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; // proceed
      default: {
        if (this._t <= 0) {
          this._context.lineTo(this._x, y);
          this._context.lineTo(x, y);
        } else {
          var x1 = this._x * (1 - this._t) + x * this._t;
          this._context.lineTo(x1, this._y);
          this._context.lineTo(x1, y);
        }
        break;
      }
    }
    this._x = x, this._y = y;
  }
};

/* harmony default export */ var curve_step = (function(context) {
  return new Step(context, 0.5);
});

function stepBefore(context) {
  return new Step(context, 0);
}

function stepAfter(context) {
  return new Step(context, 1);
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/curves.js




var curves_lookup = {
  'basis': {
    curve: basis
  },
  'basis-closed': {
    curve: basisClosed
  },
  'basis-open': {
    curve: basisOpen
  },
  'bundle': {
    curve: curve_bundle,
    tension: 'beta',
    value: 0.85
  },
  'cardinal': {
    curve: cardinal,
    tension: 'tension',
    value: 0
  },
  'cardinal-open': {
    curve: cardinalOpen,
    tension: 'tension',
    value: 0
  },
  'cardinal-closed': {
    curve: cardinalClosed,
    tension: 'tension',
    value: 0
  },
  'catmull-rom': {
    curve: curve_catmullRom,
    tension: 'alpha',
    value: 0.5
  },
  'catmull-rom-closed': {
    curve: catmullRomClosed,
    tension: 'alpha',
    value: 0.5
  },
  'catmull-rom-open': {
    curve: catmullRomOpen,
    tension: 'alpha',
    value: 0.5
  },
  'linear': {
    curve: curve_linear
  },
  'linear-closed': {
    curve: linearClosed
  },
  'monotone': {
    horizontal: monotoneY,
    vertical:   monotoneX
  },
  'natural': {
    curve: natural
  },
  'step': {
    curve: curve_step
  },
  'step-after': {
    curve: stepAfter
  },
  'step-before': {
    curve: stepBefore
  }
};

function curves(type, orientation, tension) {
  var entry = Object(vega_util["v" /* hasOwnProperty */])(curves_lookup, type) && curves_lookup[type],
      curve = null;

  if (entry) {
    curve = entry.curve || entry[orientation || 'vertical'];
    if (entry.tension && tension != null) {
      curve = curve[entry.tension](tension);
    }
  }

  return curve;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/parse.js
// Path parsing and rendering code adapted from fabric.js -- Thanks!
var cmdlen = { m:2, l:2, h:1, v:1, c:6, s:4, q:4, t:2, a:7 },
    regexp = [/([MLHVCSQTAZmlhvcsqtaz])/g, /###/, /(\d)([-+])/g, /\s|,|###/];

/* harmony default export */ var path_parse = (function(pathstr) {
  var result = [],
      path,
      curr,
      chunks,
      parsed, param,
      cmd, len, i, j, n, m;

  // First, break path into command sequence
  path = pathstr
    .slice()
    .replace(regexp[0], '###$1')
    .split(regexp[1])
    .slice(1);

  // Next, parse each command in turn
  for (i=0, n=path.length; i<n; ++i) {
    curr = path[i];
    chunks = curr
      .slice(1)
      .trim()
      .replace(regexp[2],'$1###$2')
      .split(regexp[3]);
    cmd = curr.charAt(0);

    parsed = [cmd];
    for (j=0, m=chunks.length; j<m; ++j) {
      if ((param = +chunks[j]) === param) { // not NaN
        parsed.push(param);
      }
    }

    len = cmdlen[cmd.toLowerCase()];
    if (parsed.length-1 > len) {
      for (j=1, m=parsed.length; j<m; j+=len) {
        result.push([cmd].concat(parsed.slice(j, j+len)));
      }
    }
    else {
      result.push(parsed);
    }
  }

  return result;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/constants.js
const DegToRad = Math.PI / 180;
const Epsilon = 1e-14;
const HalfPi = Math.PI / 2;
const Tau = Math.PI * 2;
const HalfSqrt3 = Math.sqrt(3) / 2;

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/arc.js


var segmentCache = {};
var bezierCache = {};

var join = [].join;

// Copied from Inkscape svgtopdf, thanks!
function arc_segments(x, y, rx, ry, large, sweep, rotateX, ox, oy) {
  var key = join.call(arguments);
  if (segmentCache[key]) {
    return segmentCache[key];
  }

  var th = rotateX * DegToRad;
  var sin_th = Math.sin(th);
  var cos_th = Math.cos(th);
  rx = Math.abs(rx);
  ry = Math.abs(ry);
  var px = cos_th * (ox - x) * 0.5 + sin_th * (oy - y) * 0.5;
  var py = cos_th * (oy - y) * 0.5 - sin_th * (ox - x) * 0.5;
  var pl = (px*px) / (rx*rx) + (py*py) / (ry*ry);
  if (pl > 1) {
    pl = Math.sqrt(pl);
    rx *= pl;
    ry *= pl;
  }

  var a00 = cos_th / rx;
  var a01 = sin_th / rx;
  var a10 = (-sin_th) / ry;
  var a11 = (cos_th) / ry;
  var x0 = a00 * ox + a01 * oy;
  var y0 = a10 * ox + a11 * oy;
  var x1 = a00 * x + a01 * y;
  var y1 = a10 * x + a11 * y;

  var d = (x1-x0) * (x1-x0) + (y1-y0) * (y1-y0);
  var sfactor_sq = 1 / d - 0.25;
  if (sfactor_sq < 0) sfactor_sq = 0;
  var sfactor = Math.sqrt(sfactor_sq);
  if (sweep == large) sfactor = -sfactor;
  var xc = 0.5 * (x0 + x1) - sfactor * (y1-y0);
  var yc = 0.5 * (y0 + y1) + sfactor * (x1-x0);

  var th0 = Math.atan2(y0-yc, x0-xc);
  var th1 = Math.atan2(y1-yc, x1-xc);

  var th_arc = th1-th0;
  if (th_arc < 0 && sweep === 1) {
    th_arc += Tau;
  } else if (th_arc > 0 && sweep === 0) {
    th_arc -= Tau;
  }

  var segs = Math.ceil(Math.abs(th_arc / (HalfPi + 0.001)));
  var result = [];
  for (var i=0; i<segs; ++i) {
    var th2 = th0 + i * th_arc / segs;
    var th3 = th0 + (i+1) * th_arc / segs;
    result[i] = [xc, yc, th2, th3, rx, ry, sin_th, cos_th];
  }

  return (segmentCache[key] = result);
}

function bezier(params) {
  var key = join.call(params);
  if (bezierCache[key]) {
    return bezierCache[key];
  }

  var cx = params[0],
      cy = params[1],
      th0 = params[2],
      th1 = params[3],
      rx = params[4],
      ry = params[5],
      sin_th = params[6],
      cos_th = params[7];

  var a00 = cos_th * rx;
  var a01 = -sin_th * ry;
  var a10 = sin_th * rx;
  var a11 = cos_th * ry;

  var cos_th0 = Math.cos(th0);
  var sin_th0 = Math.sin(th0);
  var cos_th1 = Math.cos(th1);
  var sin_th1 = Math.sin(th1);

  var th_half = 0.5 * (th1 - th0);
  var sin_th_h2 = Math.sin(th_half * 0.5);
  var t = (8/3) * sin_th_h2 * sin_th_h2 / Math.sin(th_half);
  var x1 = cx + cos_th0 - t * sin_th0;
  var y1 = cy + sin_th0 + t * cos_th0;
  var x3 = cx + cos_th1;
  var y3 = cy + sin_th1;
  var x2 = x3 + t * sin_th1;
  var y2 = y3 - t * cos_th1;

  return (bezierCache[key] = [
    a00 * x1 + a01 * y1,  a10 * x1 + a11 * y1,
    a00 * x2 + a01 * y2,  a10 * x2 + a11 * y2,
    a00 * x3 + a01 * y3,  a10 * x3 + a11 * y3
  ]);
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/render.js


var temp = ['l', 0, 0, 0, 0, 0, 0, 0];

function render_scale(current, sX, sY) {
  var c = (temp[0] = current[0]);
  if (c === 'a' || c === 'A') {
    temp[1] = sX * current[1];
    temp[2] = sY * current[2];
    temp[3] = current[3];
    temp[4] = current[4];
    temp[5] = current[5];
    temp[6] = sX * current[6];
    temp[7] = sY * current[7];
  } else if (c === 'h' || c === 'H') {
    temp[1] = sX * current[1];
  } else if (c === 'v' || c === 'V') {
    temp[1] = sY * current[1];
  } else {
    for (var i=1, n=current.length; i<n; ++i) {
      temp[i] = (i % 2 == 1 ? sX : sY) * current[i];
    }
  }
  return temp;
}

/* harmony default export */ var path_render = (function(context, path, l, t, sX, sY) {
  var current, // current instruction
      previous = null,
      x = 0, // current x
      y = 0, // current y
      controlX = 0, // current control point x
      controlY = 0, // current control point y
      tempX,
      tempY,
      tempControlX,
      tempControlY;

  if (l == null) l = 0;
  if (t == null) t = 0;
  if (sX == null) sX = 1;
  if (sY == null) sY = sX;

  if (context.beginPath) context.beginPath();

  for (var i=0, len=path.length; i<len; ++i) {
    current = path[i];
    if (sX !== 1 || sY !== 1) {
      current = render_scale(current, sX, sY);
    }

    switch (current[0]) { // first letter

      case 'l': // lineto, relative
        x += current[1];
        y += current[2];
        context.lineTo(x + l, y + t);
        break;

      case 'L': // lineto, absolute
        x = current[1];
        y = current[2];
        context.lineTo(x + l, y + t);
        break;

      case 'h': // horizontal lineto, relative
        x += current[1];
        context.lineTo(x + l, y + t);
        break;

      case 'H': // horizontal lineto, absolute
        x = current[1];
        context.lineTo(x + l, y + t);
        break;

      case 'v': // vertical lineto, relative
        y += current[1];
        context.lineTo(x + l, y + t);
        break;

      case 'V': // verical lineto, absolute
        y = current[1];
        context.lineTo(x + l, y + t);
        break;

      case 'm': // moveTo, relative
        x += current[1];
        y += current[2];
        context.moveTo(x + l, y + t);
        break;

      case 'M': // moveTo, absolute
        x = current[1];
        y = current[2];
        context.moveTo(x + l, y + t);
        break;

      case 'c': // bezierCurveTo, relative
        tempX = x + current[5];
        tempY = y + current[6];
        controlX = x + current[3];
        controlY = y + current[4];
        context.bezierCurveTo(
          x + current[1] + l, // x1
          y + current[2] + t, // y1
          controlX + l, // x2
          controlY + t, // y2
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        break;

      case 'C': // bezierCurveTo, absolute
        x = current[5];
        y = current[6];
        controlX = current[3];
        controlY = current[4];
        context.bezierCurveTo(
          current[1] + l,
          current[2] + t,
          controlX + l,
          controlY + t,
          x + l,
          y + t
        );
        break;

      case 's': // shorthand cubic bezierCurveTo, relative
        // transform to absolute x,y
        tempX = x + current[3];
        tempY = y + current[4];
        // calculate reflection of previous control points
        controlX = 2 * x - controlX;
        controlY = 2 * y - controlY;
        context.bezierCurveTo(
          controlX + l,
          controlY + t,
          x + current[1] + l,
          y + current[2] + t,
          tempX + l,
          tempY + t
        );

        // set control point to 2nd one of this command
        // the first control point is assumed to be the reflection of
        // the second control point on the previous command relative
        // to the current point.
        controlX = x + current[1];
        controlY = y + current[2];

        x = tempX;
        y = tempY;
        break;

      case 'S': // shorthand cubic bezierCurveTo, absolute
        tempX = current[3];
        tempY = current[4];
        // calculate reflection of previous control points
        controlX = 2*x - controlX;
        controlY = 2*y - controlY;
        context.bezierCurveTo(
          controlX + l,
          controlY + t,
          current[1] + l,
          current[2] + t,
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        // set control point to 2nd one of this command
        // the first control point is assumed to be the reflection of
        // the second control point on the previous command relative
        // to the current point.
        controlX = current[1];
        controlY = current[2];

        break;

      case 'q': // quadraticCurveTo, relative
        // transform to absolute x,y
        tempX = x + current[3];
        tempY = y + current[4];

        controlX = x + current[1];
        controlY = y + current[2];

        context.quadraticCurveTo(
          controlX + l,
          controlY + t,
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        break;

      case 'Q': // quadraticCurveTo, absolute
        tempX = current[3];
        tempY = current[4];

        context.quadraticCurveTo(
          current[1] + l,
          current[2] + t,
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        controlX = current[1];
        controlY = current[2];
        break;

      case 't': // shorthand quadraticCurveTo, relative

        // transform to absolute x,y
        tempX = x + current[1];
        tempY = y + current[2];

        if (previous[0].match(/[QqTt]/) === null) {
          // If there is no previous command or if the previous command was not a Q, q, T or t,
          // assume the control point is coincident with the current point
          controlX = x;
          controlY = y;
        }
        else if (previous[0] === 't') {
          // calculate reflection of previous control points for t
          controlX = 2 * x - tempControlX;
          controlY = 2 * y - tempControlY;
        }
        else if (previous[0] === 'q') {
          // calculate reflection of previous control points for q
          controlX = 2 * x - controlX;
          controlY = 2 * y - controlY;
        }

        tempControlX = controlX;
        tempControlY = controlY;

        context.quadraticCurveTo(
          controlX + l,
          controlY + t,
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        controlX = x + current[1];
        controlY = y + current[2];
        break;

      case 'T':
        tempX = current[1];
        tempY = current[2];

        // calculate reflection of previous control points
        controlX = 2 * x - controlX;
        controlY = 2 * y - controlY;
        context.quadraticCurveTo(
          controlX + l,
          controlY + t,
          tempX + l,
          tempY + t
        );
        x = tempX;
        y = tempY;
        break;

      case 'a':
        drawArc(context, x + l, y + t, [
          current[1],
          current[2],
          current[3],
          current[4],
          current[5],
          current[6] + x + l,
          current[7] + y + t
        ]);
        x += current[6];
        y += current[7];
        break;

      case 'A':
        drawArc(context, x + l, y + t, [
          current[1],
          current[2],
          current[3],
          current[4],
          current[5],
          current[6] + l,
          current[7] + t
        ]);
        x = current[6];
        y = current[7];
        break;

      case 'z':
      case 'Z':
        context.closePath();
        break;
    }
    previous = current;
  }
});

function drawArc(context, x, y, coords) {
  var seg = arc_segments(
    coords[5], // end x
    coords[6], // end y
    coords[0], // radius x
    coords[1], // radius y
    coords[3], // large flag
    coords[4], // sweep flag
    coords[2], // rotation
    x, y
  );
  for (var i=0; i<seg.length; ++i) {
    var bez = bezier(seg[i]);
    context.bezierCurveTo(bez[0], bez[1], bez[2], bez[3], bez[4], bez[5]);
  }
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/symbols.js





var Tan30 = 0.5773502691896257;

var builtins = {
  'circle': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2;
      context.moveTo(r, 0);
      context.arc(0, 0, r, 0, Tau);
    }
  },
  'cross': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          s = r / 2.5;
      context.moveTo(-r, -s);
      context.lineTo(-r, s);
      context.lineTo(-s, s);
      context.lineTo(-s, r);
      context.lineTo(s, r);
      context.lineTo(s, s);
      context.lineTo(r, s);
      context.lineTo(r, -s);
      context.lineTo(s, -s);
      context.lineTo(s, -r);
      context.lineTo(-s, -r);
      context.lineTo(-s, -s);
      context.closePath();
    }
  },
  'diamond': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2;
      context.moveTo(-r, 0);
      context.lineTo(0, -r);
      context.lineTo(r, 0);
      context.lineTo(0, r);
      context.closePath();
    }
  },
  'square': {
    draw: function(context, size) {
      var w = Math.sqrt(size),
          x = -w / 2;
      context.rect(x, x, w, w);
    }
  },
  'arrow': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          s = r / 7,
          t = r / 2.5,
          v = r / 8;
      context.moveTo(-s, r);
      context.lineTo(s, r);
      context.lineTo(s, -v);
      context.lineTo(t, -v);
      context.lineTo(0, -r);
      context.lineTo(-t, -v);
      context.lineTo(-s, -v);
      context.closePath();
    }
  },
  'wedge': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r,
          o = (h - r * Tan30),
          b = r / 4;
      context.moveTo(0, -h - o);
      context.lineTo(-b, h - o);
      context.lineTo(b, h - o);
      context.closePath();
    }
  },
  'triangle': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r,
          o = (h - r * Tan30);
      context.moveTo(0, -h - o);
      context.lineTo(-r, h - o);
      context.lineTo(r, h - o);
      context.closePath();
    }
  },
  'triangle-up': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r;
      context.moveTo(0, -h);
      context.lineTo(-r, h);
      context.lineTo(r, h);
      context.closePath();
    }
  },
  'triangle-down': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r;
      context.moveTo(0, h);
      context.lineTo(-r, -h);
      context.lineTo(r, -h);
      context.closePath();
    }
  },
  'triangle-right': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r;
      context.moveTo(h, 0);
      context.lineTo(-h, -r);
      context.lineTo(-h, r);
      context.closePath();
    }
  },
  'triangle-left': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2,
          h = HalfSqrt3 * r;
      context.moveTo(-h, 0);
      context.lineTo(h, -r);
      context.lineTo(h, r);
      context.closePath();
    }
  },
  'stroke': {
    draw: function(context, size) {
      var r = Math.sqrt(size) / 2;
      context.moveTo(-r, 0);
      context.lineTo(r, 0);
    }
  }
};

function symbols_symbols(_) {
  return Object(vega_util["v" /* hasOwnProperty */])(builtins, _) ? builtins[_] : customSymbol(_);
}

var symbols_custom = {};

function customSymbol(path) {
  if (!Object(vega_util["v" /* hasOwnProperty */])(symbols_custom, path)) {
    var parsed = path_parse(path);
    symbols_custom[path] = {
      draw: function(context, size) {
        path_render(context, parsed, 0, 0, Math.sqrt(size) / 2);
      }
    };
  }
  return symbols_custom[path];
}

// CONCATENATED MODULE: ./node_modules/d3-path/src/path.js
var path_pi = Math.PI,
    path_tau = 2 * path_pi,
    path_epsilon = 1e-6,
    tauEpsilon = path_tau - path_epsilon;

function Path() {
  this._x0 = this._y0 = // start of current subpath
  this._x1 = this._y1 = null; // end of current subpath
  this._ = "";
}

function path_path() {
  return new Path;
}

Path.prototype = path_path.prototype = {
  constructor: Path,
  moveTo: function(x, y) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y);
  },
  closePath: function() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._ += "Z";
    }
  },
  lineTo: function(x, y) {
    this._ += "L" + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  quadraticCurveTo: function(x1, y1, x, y) {
    this._ += "Q" + (+x1) + "," + (+y1) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  bezierCurveTo: function(x1, y1, x2, y2, x, y) {
    this._ += "C" + (+x1) + "," + (+y1) + "," + (+x2) + "," + (+y2) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  arcTo: function(x1, y1, x2, y2, r) {
    x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
    var x0 = this._x1,
        y0 = this._y1,
        x21 = x2 - x1,
        y21 = y2 - y1,
        x01 = x0 - x1,
        y01 = y0 - y1,
        l01_2 = x01 * x01 + y01 * y01;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x1,y1).
    if (this._x1 === null) {
      this._ += "M" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.
    else if (!(l01_2 > path_epsilon));

    // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?
    // Equivalently, is (x1,y1) coincident with (x2,y2)?
    // Or, is the radius zero? Line to (x1,y1).
    else if (!(Math.abs(y01 * x21 - y21 * x01) > path_epsilon) || !r) {
      this._ += "L" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Otherwise, draw an arc!
    else {
      var x20 = x2 - x0,
          y20 = y2 - y0,
          l21_2 = x21 * x21 + y21 * y21,
          l20_2 = x20 * x20 + y20 * y20,
          l21 = Math.sqrt(l21_2),
          l01 = Math.sqrt(l01_2),
          l = r * Math.tan((path_pi - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2),
          t01 = l / l01,
          t21 = l / l21;

      // If the start tangent is not coincident with (x0,y0), line to.
      if (Math.abs(t01 - 1) > path_epsilon) {
        this._ += "L" + (x1 + t01 * x01) + "," + (y1 + t01 * y01);
      }

      this._ += "A" + r + "," + r + ",0,0," + (+(y01 * x20 > x01 * y20)) + "," + (this._x1 = x1 + t21 * x21) + "," + (this._y1 = y1 + t21 * y21);
    }
  },
  arc: function(x, y, r, a0, a1, ccw) {
    x = +x, y = +y, r = +r, ccw = !!ccw;
    var dx = r * Math.cos(a0),
        dy = r * Math.sin(a0),
        x0 = x + dx,
        y0 = y + dy,
        cw = 1 ^ ccw,
        da = ccw ? a0 - a1 : a1 - a0;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x0,y0).
    if (this._x1 === null) {
      this._ += "M" + x0 + "," + y0;
    }

    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).
    else if (Math.abs(this._x1 - x0) > path_epsilon || Math.abs(this._y1 - y0) > path_epsilon) {
      this._ += "L" + x0 + "," + y0;
    }

    // Is this arc empty? We’re done.
    if (!r) return;

    // Does the angle go the wrong way? Flip the direction.
    if (da < 0) da = da % path_tau + path_tau;

    // Is this a complete circle? Draw two arcs to complete the circle.
    if (da > tauEpsilon) {
      this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x - dx) + "," + (y - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x0) + "," + (this._y1 = y0);
    }

    // Is this arc non-empty? Draw an arc!
    else if (da > path_epsilon) {
      this._ += "A" + r + "," + r + ",0," + (+(da >= path_pi)) + "," + cw + "," + (this._x1 = x + r * Math.cos(a1)) + "," + (this._y1 = y + r * Math.sin(a1));
    }
  },
  rect: function(x, y, w, h) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y) + "h" + (+w) + "v" + (+h) + "h" + (-w) + "Z";
  },
  toString: function() {
    return this._;
  }
};

/* harmony default export */ var src_path = (path_path);

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/rectangle.js


// See http://spencermortensen.com/articles/bezier-circle/
const C = 0.448084975506; // C = 1 - c

function rectangleX(d) {
  return d.x;
}

function rectangleY(d) {
  return d.y;
}

function rectangleWidth(d) {
  return d.width;
}

function rectangleHeight(d) {
  return d.height;
}

function rectangle_number(_) {
  return typeof _ === 'function' ? _ : () => +_;
}

function rectangle_clamp(value, min, max) {
  return Math.max(min, Math.min(value, max));
}

/* harmony default export */ var path_rectangle = (function() {
  var x = rectangleX,
      y = rectangleY,
      width = rectangleWidth,
      height = rectangleHeight,
      crTL = rectangle_number(0),
      crTR = crTL,
      crBL = crTL,
      crBR = crTL,
      context = null;

  function rectangle(_, x0, y0) {
    var buffer,
        x1 = x0 != null ? x0 : +x.call(this, _),
        y1 = y0 != null ? y0 : +y.call(this, _),
        w  = +width.call(this, _),
        h  = +height.call(this, _),
        s  = Math.min(w, h) / 2,
        tl = rectangle_clamp(+crTL.call(this, _), 0, s),
        tr = rectangle_clamp(+crTR.call(this, _), 0, s),
        bl = rectangle_clamp(+crBL.call(this, _), 0, s),
        br = rectangle_clamp(+crBR.call(this, _), 0, s);

    if (!context) context = buffer = src_path();

    if (tl <= 0 && tr <= 0 && bl <= 0 && br <= 0) {
      context.rect(x1, y1, w, h);
    } else {
      var x2 = x1 + w,
          y2 = y1 + h;
      context.moveTo(x1 + tl, y1);
      context.lineTo(x2 - tr, y1);
      context.bezierCurveTo(x2 - C * tr, y1, x2, y1 + C * tr, x2, y1 + tr);
      context.lineTo(x2, y2 - br);
      context.bezierCurveTo(x2, y2 - C * br, x2 - C * br, y2, x2 - br, y2);
      context.lineTo(x1 + bl, y2);
      context.bezierCurveTo(x1 + C * bl, y2, x1, y2 - C * bl, x1, y2 - bl);
      context.lineTo(x1, y1 + tl);
      context.bezierCurveTo(x1, y1 + C * tl, x1 + C * tl, y1, x1 + tl, y1);
      context.closePath();
    }

    if (buffer) {
      context = null;
      return buffer + '' || null;
    }
  }

  rectangle.x = function(_) {
    if (arguments.length) {
      x = rectangle_number(_);
      return rectangle;
    } else {
      return x;
    }
  };

  rectangle.y = function(_) {
    if (arguments.length) {
      y = rectangle_number(_);
      return rectangle;
    } else {
      return y;
    }
  };

  rectangle.width = function(_) {
    if (arguments.length) {
      width = rectangle_number(_);
      return rectangle;
    } else {
      return width;
    }
  };

  rectangle.height = function(_) {
    if (arguments.length) {
      height = rectangle_number(_);
      return rectangle;
    } else {
      return height;
    }
  };

  rectangle.cornerRadius = function(tl, tr, br, bl) {
    if (arguments.length) {
      crTL = rectangle_number(tl);
      crTR = tr != null ? rectangle_number(tr) : crTL;
      crBR = br != null ? rectangle_number(br) : crTL;
      crBL = bl != null ? rectangle_number(bl) : crTR;
      return rectangle;
    } else {
      return crTL;
    }
  };

  rectangle.context = function(_) {
    if (arguments.length) {
      context = _ == null ? null : _;
      return rectangle;
    } else {
      return context;
    }
  };

  return rectangle;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/trail.js



/* harmony default export */ var path_trail = (function() {
  var x,
      y,
      size,
      defined,
      context = null,
      ready, x1, y1, r1;

  function point(x2, y2, w2) {
    var r2 = w2 / 2;

    if (ready) {
      var ux = y1 - y2,
          uy = x2 - x1;

      if (ux || uy) {
        // get normal vector
        var ud = Math.sqrt(ux * ux + uy * uy),
            rx = (ux /= ud) * r1,
            ry = (uy /= ud) * r1,
            t = Math.atan2(uy, ux);

        // draw segment
        context.moveTo(x1 - rx, y1 - ry);
        context.lineTo(x2 - ux * r2, y2 - uy * r2);
        context.arc(x2, y2, r2, t - Math.PI, t);
        context.lineTo(x1 + rx, y1 + ry);
        context.arc(x1, y1, r1, t, t + Math.PI);
      } else {
        context.arc(x2, y2, r2, 0, Tau);
      }
      context.closePath();
    } else {
      ready = 1;
    }
    x1 = x2;
    y1 = y2;
    r1 = r2;
  }

  function trail(data) {
    var i,
        n = data.length,
        d,
        defined0 = false,
        buffer;

    if (context == null) context = buffer = src_path();

    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) ready = 0;
      }
      if (defined0) point(+x(d, i, data), +y(d, i, data), +size(d, i, data));
    }

    if (buffer) {
      context = null;
      return buffer + '' || null;
    }
  }

  trail.x = function(_) {
    if (arguments.length) {
      x = _;
      return trail;
    } else {
      return x;
    }
  };

  trail.y = function(_) {
    if (arguments.length) {
      y = _;
      return trail;
    } else {
      return y;
    }
  };

  trail.size = function(_) {
    if (arguments.length) {
      size = _;
      return trail;
    } else {
      return size;
    }
  };

  trail.defined = function(_) {
    if (arguments.length) {
      defined = _;
      return trail;
    } else {
      return defined;
    }
  };

  trail.context = function(_) {
    if (arguments.length) {
      if (_ == null) {
        context = null;
      } else {
        context = _;
      }
      return trail;
    } else {
      return context;
    }
  };

  return trail;
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/constant.js
/* harmony default export */ var src_constant = (function(x) {
  return function constant() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/arc.js




function arcInnerRadius(d) {
  return d.innerRadius;
}

function arcOuterRadius(d) {
  return d.outerRadius;
}

function arcStartAngle(d) {
  return d.startAngle;
}

function arcEndAngle(d) {
  return d.endAngle;
}

function arcPadAngle(d) {
  return d && d.padAngle; // Note: optional!
}

function arc_intersect(x0, y0, x1, y1, x2, y2, x3, y3) {
  var x10 = x1 - x0, y10 = y1 - y0,
      x32 = x3 - x2, y32 = y3 - y2,
      t = y32 * x10 - x32 * y10;
  if (t * t < math_epsilon) return;
  t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
  return [x0 + t * x10, y0 + t * y10];
}

// Compute perpendicular offset line of length rc.
// http://mathworld.wolfram.com/Circle-LineIntersection.html
function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
  var x01 = x0 - x1,
      y01 = y0 - y1,
      lo = (cw ? rc : -rc) / sqrt(x01 * x01 + y01 * y01),
      ox = lo * y01,
      oy = -lo * x01,
      x11 = x0 + ox,
      y11 = y0 + oy,
      x10 = x1 + ox,
      y10 = y1 + oy,
      x00 = (x11 + x10) / 2,
      y00 = (y11 + y10) / 2,
      dx = x10 - x11,
      dy = y10 - y11,
      d2 = dx * dx + dy * dy,
      r = r1 - rc,
      D = x11 * y10 - x10 * y11,
      d = (dy < 0 ? -1 : 1) * sqrt(math_max(0, r * r * d2 - D * D)),
      cx0 = (D * dy - dx * d) / d2,
      cy0 = (-D * dx - dy * d) / d2,
      cx1 = (D * dy + dx * d) / d2,
      cy1 = (-D * dx + dy * d) / d2,
      dx0 = cx0 - x00,
      dy0 = cy0 - y00,
      dx1 = cx1 - x00,
      dy1 = cy1 - y00;

  // Pick the closer of the two intersection points.
  // TODO Is there a faster way to determine which intersection to use?
  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;

  return {
    cx: cx0,
    cy: cy0,
    x01: -ox,
    y01: -oy,
    x11: cx0 * (r1 / r - 1),
    y11: cy0 * (r1 / r - 1)
  };
}

/* harmony default export */ var src_arc = (function() {
  var innerRadius = arcInnerRadius,
      outerRadius = arcOuterRadius,
      cornerRadius = src_constant(0),
      padRadius = null,
      startAngle = arcStartAngle,
      endAngle = arcEndAngle,
      padAngle = arcPadAngle,
      context = null;

  function arc() {
    var buffer,
        r,
        r0 = +innerRadius.apply(this, arguments),
        r1 = +outerRadius.apply(this, arguments),
        a0 = startAngle.apply(this, arguments) - halfPi,
        a1 = endAngle.apply(this, arguments) - halfPi,
        da = abs(a1 - a0),
        cw = a1 > a0;

    if (!context) context = buffer = src_path();

    // Ensure that the outer radius is always larger than the inner radius.
    if (r1 < r0) r = r1, r1 = r0, r0 = r;

    // Is it a point?
    if (!(r1 > math_epsilon)) context.moveTo(0, 0);

    // Or is it a circle or annulus?
    else if (da > tau - math_epsilon) {
      context.moveTo(r1 * math_cos(a0), r1 * math_sin(a0));
      context.arc(0, 0, r1, a0, a1, !cw);
      if (r0 > math_epsilon) {
        context.moveTo(r0 * math_cos(a1), r0 * math_sin(a1));
        context.arc(0, 0, r0, a1, a0, cw);
      }
    }

    // Or is it a circular or annular sector?
    else {
      var a01 = a0,
          a11 = a1,
          a00 = a0,
          a10 = a1,
          da0 = da,
          da1 = da,
          ap = padAngle.apply(this, arguments) / 2,
          rp = (ap > math_epsilon) && (padRadius ? +padRadius.apply(this, arguments) : sqrt(r0 * r0 + r1 * r1)),
          rc = math_min(abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments)),
          rc0 = rc,
          rc1 = rc,
          t0,
          t1;

      // Apply padding? Note that since r1 ≥ r0, da1 ≥ da0.
      if (rp > math_epsilon) {
        var p0 = asin(rp / r0 * math_sin(ap)),
            p1 = asin(rp / r1 * math_sin(ap));
        if ((da0 -= p0 * 2) > math_epsilon) p0 *= (cw ? 1 : -1), a00 += p0, a10 -= p0;
        else da0 = 0, a00 = a10 = (a0 + a1) / 2;
        if ((da1 -= p1 * 2) > math_epsilon) p1 *= (cw ? 1 : -1), a01 += p1, a11 -= p1;
        else da1 = 0, a01 = a11 = (a0 + a1) / 2;
      }

      var x01 = r1 * math_cos(a01),
          y01 = r1 * math_sin(a01),
          x10 = r0 * math_cos(a10),
          y10 = r0 * math_sin(a10);

      // Apply rounded corners?
      if (rc > math_epsilon) {
        var x11 = r1 * math_cos(a11),
            y11 = r1 * math_sin(a11),
            x00 = r0 * math_cos(a00),
            y00 = r0 * math_sin(a00),
            oc;

        // Restrict the corner radius according to the sector angle.
        if (da < pi && (oc = arc_intersect(x01, y01, x00, y00, x11, y11, x10, y10))) {
          var ax = x01 - oc[0],
              ay = y01 - oc[1],
              bx = x11 - oc[0],
              by = y11 - oc[1],
              kc = 1 / math_sin(acos((ax * bx + ay * by) / (sqrt(ax * ax + ay * ay) * sqrt(bx * bx + by * by))) / 2),
              lc = sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
          rc0 = math_min(rc, (r0 - lc) / (kc - 1));
          rc1 = math_min(rc, (r1 - lc) / (kc + 1));
        }
      }

      // Is the sector collapsed to a line?
      if (!(da1 > math_epsilon)) context.moveTo(x01, y01);

      // Does the sector’s outer ring have rounded corners?
      else if (rc1 > math_epsilon) {
        t0 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
        t1 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);

        context.moveTo(t0.cx + t0.x01, t0.cy + t0.y01);

        // Have the corners merged?
        if (rc1 < rc) context.arc(t0.cx, t0.cy, rc1, atan2(t0.y01, t0.x01), atan2(t1.y01, t1.x01), !cw);

        // Otherwise, draw the two corners and the ring.
        else {
          context.arc(t0.cx, t0.cy, rc1, atan2(t0.y01, t0.x01), atan2(t0.y11, t0.x11), !cw);
          context.arc(0, 0, r1, atan2(t0.cy + t0.y11, t0.cx + t0.x11), atan2(t1.cy + t1.y11, t1.cx + t1.x11), !cw);
          context.arc(t1.cx, t1.cy, rc1, atan2(t1.y11, t1.x11), atan2(t1.y01, t1.x01), !cw);
        }
      }

      // Or is the outer ring just a circular arc?
      else context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);

      // Is there no inner ring, and it’s a circular sector?
      // Or perhaps it’s an annular sector collapsed due to padding?
      if (!(r0 > math_epsilon) || !(da0 > math_epsilon)) context.lineTo(x10, y10);

      // Does the sector’s inner ring (or point) have rounded corners?
      else if (rc0 > math_epsilon) {
        t0 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
        t1 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);

        context.lineTo(t0.cx + t0.x01, t0.cy + t0.y01);

        // Have the corners merged?
        if (rc0 < rc) context.arc(t0.cx, t0.cy, rc0, atan2(t0.y01, t0.x01), atan2(t1.y01, t1.x01), !cw);

        // Otherwise, draw the two corners and the ring.
        else {
          context.arc(t0.cx, t0.cy, rc0, atan2(t0.y01, t0.x01), atan2(t0.y11, t0.x11), !cw);
          context.arc(0, 0, r0, atan2(t0.cy + t0.y11, t0.cx + t0.x11), atan2(t1.cy + t1.y11, t1.cx + t1.x11), cw);
          context.arc(t1.cx, t1.cy, rc0, atan2(t1.y11, t1.x11), atan2(t1.y01, t1.x01), !cw);
        }
      }

      // Or is the inner ring just a circular arc?
      else context.arc(0, 0, r0, a10, a00, cw);
    }

    context.closePath();

    if (buffer) return context = null, buffer + "" || null;
  }

  arc.centroid = function() {
    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,
        a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi / 2;
    return [math_cos(a) * r, math_sin(a) * r];
  };

  arc.innerRadius = function(_) {
    return arguments.length ? (innerRadius = typeof _ === "function" ? _ : src_constant(+_), arc) : innerRadius;
  };

  arc.outerRadius = function(_) {
    return arguments.length ? (outerRadius = typeof _ === "function" ? _ : src_constant(+_), arc) : outerRadius;
  };

  arc.cornerRadius = function(_) {
    return arguments.length ? (cornerRadius = typeof _ === "function" ? _ : src_constant(+_), arc) : cornerRadius;
  };

  arc.padRadius = function(_) {
    return arguments.length ? (padRadius = _ == null ? null : typeof _ === "function" ? _ : src_constant(+_), arc) : padRadius;
  };

  arc.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : src_constant(+_), arc) : startAngle;
  };

  arc.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : src_constant(+_), arc) : endAngle;
  };

  arc.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : src_constant(+_), arc) : padAngle;
  };

  arc.context = function(_) {
    return arguments.length ? ((context = _ == null ? null : _), arc) : context;
  };

  return arc;
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/point.js
function point_x(p) {
  return p[0];
}

function point_y(p) {
  return p[1];
}

// CONCATENATED MODULE: ./node_modules/d3-shape/src/line.js





/* harmony default export */ var src_line = (function() {
  var x = point_x,
      y = point_y,
      defined = src_constant(true),
      context = null,
      curve = curve_linear,
      output = null;

  function line(data) {
    var i,
        n = data.length,
        d,
        defined0 = false,
        buffer;

    if (context == null) output = curve(buffer = src_path());

    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) output.lineStart();
        else output.lineEnd();
      }
      if (defined0) output.point(+x(d, i, data), +y(d, i, data));
    }

    if (buffer) return output = null, buffer + "" || null;
  }

  line.x = function(_) {
    return arguments.length ? (x = typeof _ === "function" ? _ : src_constant(+_), line) : x;
  };

  line.y = function(_) {
    return arguments.length ? (y = typeof _ === "function" ? _ : src_constant(+_), line) : y;
  };

  line.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : src_constant(!!_), line) : defined;
  };

  line.curve = function(_) {
    return arguments.length ? (curve = _, context != null && (output = curve(context)), line) : curve;
  };

  line.context = function(_) {
    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), line) : context;
  };

  return line;
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/area.js






/* harmony default export */ var src_area = (function() {
  var x0 = point_x,
      x1 = null,
      y0 = src_constant(0),
      y1 = point_y,
      defined = src_constant(true),
      context = null,
      curve = curve_linear,
      output = null;

  function area(data) {
    var i,
        j,
        k,
        n = data.length,
        d,
        defined0 = false,
        buffer,
        x0z = new Array(n),
        y0z = new Array(n);

    if (context == null) output = curve(buffer = src_path());

    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) {
          j = i;
          output.areaStart();
          output.lineStart();
        } else {
          output.lineEnd();
          output.lineStart();
          for (k = i - 1; k >= j; --k) {
            output.point(x0z[k], y0z[k]);
          }
          output.lineEnd();
          output.areaEnd();
        }
      }
      if (defined0) {
        x0z[i] = +x0(d, i, data), y0z[i] = +y0(d, i, data);
        output.point(x1 ? +x1(d, i, data) : x0z[i], y1 ? +y1(d, i, data) : y0z[i]);
      }
    }

    if (buffer) return output = null, buffer + "" || null;
  }

  function arealine() {
    return src_line().defined(defined).curve(curve).context(context);
  }

  area.x = function(_) {
    return arguments.length ? (x0 = typeof _ === "function" ? _ : src_constant(+_), x1 = null, area) : x0;
  };

  area.x0 = function(_) {
    return arguments.length ? (x0 = typeof _ === "function" ? _ : src_constant(+_), area) : x0;
  };

  area.x1 = function(_) {
    return arguments.length ? (x1 = _ == null ? null : typeof _ === "function" ? _ : src_constant(+_), area) : x1;
  };

  area.y = function(_) {
    return arguments.length ? (y0 = typeof _ === "function" ? _ : src_constant(+_), y1 = null, area) : y0;
  };

  area.y0 = function(_) {
    return arguments.length ? (y0 = typeof _ === "function" ? _ : src_constant(+_), area) : y0;
  };

  area.y1 = function(_) {
    return arguments.length ? (y1 = _ == null ? null : typeof _ === "function" ? _ : src_constant(+_), area) : y1;
  };

  area.lineX0 =
  area.lineY0 = function() {
    return arealine().x(x0).y(y0);
  };

  area.lineY1 = function() {
    return arealine().x(x0).y(y1);
  };

  area.lineX1 = function() {
    return arealine().x(x1).y(y0);
  };

  area.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : src_constant(!!_), area) : defined;
  };

  area.curve = function(_) {
    return arguments.length ? (curve = _, context != null && (output = curve(context)), area) : curve;
  };

  area.context = function(_) {
    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), area) : context;
  };

  return area;
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/circle.js


/* harmony default export */ var symbol_circle = ({
  draw: function(context, size) {
    var r = Math.sqrt(size / pi);
    context.moveTo(r, 0);
    context.arc(0, 0, r, 0, tau);
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/cross.js
/* harmony default export */ var symbol_cross = ({
  draw: function(context, size) {
    var r = Math.sqrt(size / 5) / 2;
    context.moveTo(-3 * r, -r);
    context.lineTo(-r, -r);
    context.lineTo(-r, -3 * r);
    context.lineTo(r, -3 * r);
    context.lineTo(r, -r);
    context.lineTo(3 * r, -r);
    context.lineTo(3 * r, r);
    context.lineTo(r, r);
    context.lineTo(r, 3 * r);
    context.lineTo(-r, 3 * r);
    context.lineTo(-r, r);
    context.lineTo(-3 * r, r);
    context.closePath();
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/diamond.js
var tan30 = Math.sqrt(1 / 3),
    tan30_2 = tan30 * 2;

/* harmony default export */ var diamond = ({
  draw: function(context, size) {
    var y = Math.sqrt(size / tan30_2),
        x = y * tan30;
    context.moveTo(0, -y);
    context.lineTo(x, 0);
    context.lineTo(0, y);
    context.lineTo(-x, 0);
    context.closePath();
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/star.js


var ka = 0.89081309152928522810,
    kr = Math.sin(pi / 10) / Math.sin(7 * pi / 10),
    star_kx = Math.sin(tau / 10) * kr,
    star_ky = -Math.cos(tau / 10) * kr;

/* harmony default export */ var star = ({
  draw: function(context, size) {
    var r = Math.sqrt(size * ka),
        x = star_kx * r,
        y = star_ky * r;
    context.moveTo(0, -r);
    context.lineTo(x, y);
    for (var i = 1; i < 5; ++i) {
      var a = tau * i / 5,
          c = Math.cos(a),
          s = Math.sin(a);
      context.lineTo(s * r, -c * r);
      context.lineTo(c * x - s * y, s * x + c * y);
    }
    context.closePath();
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/square.js
/* harmony default export */ var square = ({
  draw: function(context, size) {
    var w = Math.sqrt(size),
        x = -w / 2;
    context.rect(x, x, w, w);
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/triangle.js
var sqrt3 = Math.sqrt(3);

/* harmony default export */ var triangle = ({
  draw: function(context, size) {
    var y = -Math.sqrt(size / (sqrt3 * 3));
    context.moveTo(0, y * 2);
    context.lineTo(-sqrt3 * y, -y);
    context.lineTo(sqrt3 * y, -y);
    context.closePath();
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol/wye.js
var wye_c = -0.5,
    wye_s = Math.sqrt(3) / 2,
    wye_k = 1 / Math.sqrt(12),
    wye_a = (wye_k / 2 + 1) * 3;

/* harmony default export */ var wye = ({
  draw: function(context, size) {
    var r = Math.sqrt(size / wye_a),
        x0 = r / 2,
        y0 = r * wye_k,
        x1 = x0,
        y1 = r * wye_k + r,
        x2 = -x1,
        y2 = y1;
    context.moveTo(x0, y0);
    context.lineTo(x1, y1);
    context.lineTo(x2, y2);
    context.lineTo(wye_c * x0 - wye_s * y0, wye_s * x0 + wye_c * y0);
    context.lineTo(wye_c * x1 - wye_s * y1, wye_s * x1 + wye_c * y1);
    context.lineTo(wye_c * x2 - wye_s * y2, wye_s * x2 + wye_c * y2);
    context.lineTo(wye_c * x0 + wye_s * y0, wye_c * y0 - wye_s * x0);
    context.lineTo(wye_c * x1 + wye_s * y1, wye_c * y1 - wye_s * x1);
    context.lineTo(wye_c * x2 + wye_s * y2, wye_c * y2 - wye_s * x2);
    context.closePath();
  }
});

// CONCATENATED MODULE: ./node_modules/d3-shape/src/symbol.js










var symbol_symbols = [
  symbol_circle,
  symbol_cross,
  diamond,
  square,
  star,
  triangle,
  wye
];

/* harmony default export */ var src_symbol = (function() {
  var type = src_constant(symbol_circle),
      size = src_constant(64),
      context = null;

  function symbol() {
    var buffer;
    if (!context) context = buffer = src_path();
    type.apply(this, arguments).draw(context, +size.apply(this, arguments));
    if (buffer) return context = null, buffer + "" || null;
  }

  symbol.type = function(_) {
    return arguments.length ? (type = typeof _ === "function" ? _ : src_constant(_), symbol) : type;
  };

  symbol.size = function(_) {
    return arguments.length ? (size = typeof _ === "function" ? _ : src_constant(+_), symbol) : size;
  };

  symbol.context = function(_) {
    return arguments.length ? (context = _ == null ? null : _, symbol) : context;
  };

  return symbol;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/path/shapes.js








function shapes_value(a, b) {
  return a != null ? a : b;
}

const shapes_x =  item => item.x || 0,
      shapes_y =  item => item.y || 0,
      shapes_w =  item => item.width || 0,
      shapes_h =  item => item.height || 0,
      xw = item => (item.x || 0) + (item.width || 0),
      yh = item => (item.y || 0) + (item.height || 0),
      shapes_sa = item => item.startAngle || 0,
      shapes_ea = item => item.endAngle || 0,
      shapes_pa = item => item.padAngle || 0,
      ir = item => item.innerRadius || 0,
      shapes_or = item => item.outerRadius || 0,
      shapes_cr = item => item.cornerRadius || 0,
      shapes_tl = item => shapes_value(item.cornerRadiusTopLeft, item.cornerRadius) || 0,
      shapes_tr = item => shapes_value(item.cornerRadiusTopRight, item.cornerRadius) || 0,
      shapes_br = item => shapes_value(item.cornerRadiusBottomRight, item.cornerRadius) || 0,
      shapes_bl = item => shapes_value(item.cornerRadiusBottomLeft, item.cornerRadius) || 0,
      shapes_sz = item => shapes_value(item.size, 64),
      shapes_ts = item => item.size || 1,
      shapes_def = item => !(item.defined === false),
      shapes_type = item => symbols_symbols(item.shape || 'circle');

const arcShape    = src_arc().startAngle(shapes_sa).endAngle(shapes_ea).padAngle(shapes_pa)
                      .innerRadius(ir).outerRadius(shapes_or).cornerRadius(shapes_cr),
      areavShape  = src_area().x(shapes_x).y1(shapes_y).y0(yh).defined(shapes_def),
      areahShape  = src_area().y(shapes_y).x1(shapes_x).x0(xw).defined(shapes_def),
      lineShape   = src_line().x(shapes_x).y(shapes_y).defined(shapes_def),
      rectShape   = path_rectangle().x(shapes_x).y(shapes_y).width(shapes_w).height(shapes_h)
                      .cornerRadius(shapes_tl, shapes_tr, shapes_br, shapes_bl),
      symbolShape = src_symbol().type(shapes_type).size(shapes_sz),
      trailShape  = path_trail().x(shapes_x).y(shapes_y).defined(shapes_def).size(shapes_ts);

function hasCornerRadius(item) {
  return item.cornerRadius
    || item.cornerRadiusTopLeft
    || item.cornerRadiusTopRight
    || item.cornerRadiusBottomRight
    || item.cornerRadiusBottomLeft;
}

function shapes_arc(context, item) {
  return arcShape.context(context)(item);
}

function shapes_area(context, items) {
  var item = items[0],
      interp = item.interpolate || 'linear';
  return (item.orient === 'horizontal' ? areahShape : areavShape)
    .curve(curves(interp, item.orient, item.tension))
    .context(context)(items);
}

function shapes_line(context, items) {
  var item = items[0],
      interp = item.interpolate || 'linear';
  return lineShape.curve(curves(interp, item.orient, item.tension))
    .context(context)(items);
}

function shapes_rectangle(context, item, x, y) {
  return rectShape.context(context)(item, x, y);
}

function shapes_shape(context, item) {
  return (item.mark.shape || item.shape)
    .context(context)(item);
}

function shapes_symbol(context, item) {
  return symbolShape.context(context)(item);
}

function shapes_trail(context, items) {
  return trailShape.context(context)(items);
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/svg/clip.js



var clip_id = 1;

function resetSVGClipId() {
  clip_id = 1;
}

/* harmony default export */ var svg_clip = (function(renderer, item, size) {
  var clip = item.clip,
      defs = renderer._defs,
      id = item.clip_id || (item.clip_id = 'clip' + clip_id++),
      c = defs.clipping[id] || (defs.clipping[id] = {id: id});

  if (Object(vega_util["D" /* isFunction */])(clip)) {
    c.path = clip(null);
  } else if (hasCornerRadius(size)) {
    c.path = shapes_rectangle(null, size, 0, 0);
  } else {
    c.width = size.width || 0;
    c.height = size.height || 0;
  }

  return 'url(#' + id + ')';
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Bounds.js
function Bounds(b) {
  this.clear();
  if (b) this.union(b);
}

var Bounds_prototype = Bounds.prototype;

Bounds_prototype.clone = function() {
  return new Bounds(this);
};

Bounds_prototype.clear = function() {
  this.x1 = +Number.MAX_VALUE;
  this.y1 = +Number.MAX_VALUE;
  this.x2 = -Number.MAX_VALUE;
  this.y2 = -Number.MAX_VALUE;
  return this;
};

Bounds_prototype.empty = function() {
  return (
    this.x1 === +Number.MAX_VALUE &&
    this.y1 === +Number.MAX_VALUE &&
    this.x2 === -Number.MAX_VALUE &&
    this.y2 === -Number.MAX_VALUE
  );
};

Bounds_prototype.equals = function(b) {
  return (
    this.x1 === b.x1 &&
    this.y1 === b.y1 &&
    this.x2 === b.x2 &&
    this.y2 === b.y2
  );
};

Bounds_prototype.set = function(x1, y1, x2, y2) {
  if (x2 < x1) {
    this.x2 = x1;
    this.x1 = x2;
  } else {
    this.x1 = x1;
    this.x2 = x2;
  }
  if (y2 < y1) {
    this.y2 = y1;
    this.y1 = y2;
  } else {
    this.y1 = y1;
    this.y2 = y2;
  }
  return this;
};

Bounds_prototype.add = function(x, y) {
  if (x < this.x1) this.x1 = x;
  if (y < this.y1) this.y1 = y;
  if (x > this.x2) this.x2 = x;
  if (y > this.y2) this.y2 = y;
  return this;
};

Bounds_prototype.expand = function(d) {
  this.x1 -= d;
  this.y1 -= d;
  this.x2 += d;
  this.y2 += d;
  return this;
};

Bounds_prototype.round = function() {
  this.x1 = Math.floor(this.x1);
  this.y1 = Math.floor(this.y1);
  this.x2 = Math.ceil(this.x2);
  this.y2 = Math.ceil(this.y2);
  return this;
};

Bounds_prototype.scale = function(s) {
  this.x1 *= s;
  this.y1 *= s;
  this.x2 *= s;
  this.y2 *= s;
  return this;
};

Bounds_prototype.translate = function(dx, dy) {
  this.x1 += dx;
  this.x2 += dx;
  this.y1 += dy;
  this.y2 += dy;
  return this;
};

Bounds_prototype.rotate = function(angle, x, y) {
  const p = this.rotatedPoints(angle, x, y);
  return this.clear()
    .add(p[0], p[1])
    .add(p[2], p[3])
    .add(p[4], p[5])
    .add(p[6], p[7]);
};

Bounds_prototype.rotatedPoints = function(angle, x, y) {
  var {x1, y1, x2, y2} = this,
      cos = Math.cos(angle),
      sin = Math.sin(angle),
      cx = x - x*cos + y*sin,
      cy = y - x*sin - y*cos;

  return [
    cos*x1 - sin*y1 + cx, sin*x1 + cos*y1 + cy,
    cos*x1 - sin*y2 + cx, sin*x1 + cos*y2 + cy,
    cos*x2 - sin*y1 + cx, sin*x2 + cos*y1 + cy,
    cos*x2 - sin*y2 + cx, sin*x2 + cos*y2 + cy
  ];
};

Bounds_prototype.union = function(b) {
  if (b.x1 < this.x1) this.x1 = b.x1;
  if (b.y1 < this.y1) this.y1 = b.y1;
  if (b.x2 > this.x2) this.x2 = b.x2;
  if (b.y2 > this.y2) this.y2 = b.y2;
  return this;
};

Bounds_prototype.intersect = function(b) {
  if (b.x1 > this.x1) this.x1 = b.x1;
  if (b.y1 > this.y1) this.y1 = b.y1;
  if (b.x2 < this.x2) this.x2 = b.x2;
  if (b.y2 < this.y2) this.y2 = b.y2;
  return this;
};

Bounds_prototype.encloses = function(b) {
  return b && (
    this.x1 <= b.x1 &&
    this.x2 >= b.x2 &&
    this.y1 <= b.y1 &&
    this.y2 >= b.y2
  );
};

Bounds_prototype.alignsWith = function(b) {
  return b && (
    this.x1 == b.x1 ||
    this.x2 == b.x2 ||
    this.y1 == b.y1 ||
    this.y2 == b.y2
  );
};

Bounds_prototype.intersects = function(b) {
  return b && !(
    this.x2 < b.x1 ||
    this.x1 > b.x2 ||
    this.y2 < b.y1 ||
    this.y1 > b.y2
  );
};

Bounds_prototype.contains = function(x, y) {
  return !(
    x < this.x1 ||
    x > this.x2 ||
    y < this.y1 ||
    y > this.y2
  );
};

Bounds_prototype.width = function() {
  return this.x2 - this.x1;
};

Bounds_prototype.height = function() {
  return this.y2 - this.y1;
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Item.js


function Item(mark) {
  this.mark = mark;
  this.bounds = (this.bounds || new Bounds());
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/GroupItem.js



function GroupItem(mark) {
  Item.call(this, mark);
  this.items = (this.items || []);
}

Object(vega_util["y" /* inherits */])(GroupItem, Item);

// CONCATENATED MODULE: ./node_modules/vega-canvas/src/domCanvas.js
function domCanvas(w, h) {
  if (typeof document !== 'undefined' && document.createElement) {
    var c = document.createElement('canvas');
    if (c && c.getContext) {
      c.width = w;
      c.height = h;
      return c;
    }
  }
  return null;
}

function domImage() {
  return typeof Image !== 'undefined' ? Image : null;
}

// CONCATENATED MODULE: ./node_modules/vega-canvas/index.browser.js


// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/ResourceLoader.js




function ResourceLoader(customLoader) {
  this._pending = 0;
  this._loader = customLoader || index_browser_loader();
}

var ResourceLoader_prototype = ResourceLoader.prototype;

ResourceLoader_prototype.pending = function() {
  return this._pending;
};

function increment(loader) {
  loader._pending += 1;
}

function decrement(loader) {
  loader._pending -= 1;
}

ResourceLoader_prototype.sanitizeURL = function(uri) {
  var loader = this;
  increment(loader);

  return loader._loader.sanitize(uri, {context:'href'})
    .then(function(opt) {
      decrement(loader);
      return opt;
    })
    .catch(function() {
      decrement(loader);
      return null;
    });
};

ResourceLoader_prototype.loadImage = function(uri) {
  const loader = this,
        Image = domImage();
  increment(loader);

  return loader._loader
    .sanitize(uri, {context: 'image'})
    .then(function(opt) {
      const url = opt.href;
      if (!url || !Image) throw {url: url};

      const img = new Image();

      // set crossOrigin only if cors is defined; empty string sets anonymous mode
      // https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement/crossOrigin
      const cors = Object(vega_util["v" /* hasOwnProperty */])(opt, 'crossOrigin') ? opt.crossOrigin : 'anonymous';
      if (cors != null) img.crossOrigin = cors;

      // attempt to load image resource
      img.onload = () => decrement(loader);
      img.onerror = () => decrement(loader);
      img.src = url;

      return img;
    })
    .catch(function(e) {
      decrement(loader);
      return {complete: false, width: 0, height: 0, src: e && e.url || ''};
    });
};

ResourceLoader_prototype.ready = function() {
  var loader = this;
  return new Promise(function(accept) {
    function poll(value) {
      if (!loader.pending()) accept(value);
      else setTimeout(function() { poll(true); }, 10);
    }
    poll(false);
  });
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/bound/boundStroke.js
/* harmony default export */ var boundStroke = (function(bounds, item, miter) {
  if (item.stroke && item.opacity !== 0 && item.strokeOpacity !== 0) {
    const sw = item.strokeWidth != null ? +item.strokeWidth : 1;
    bounds.expand(sw + (miter ? miterAdjustment(item, sw) : 0));
  }
  return bounds;
});

function miterAdjustment(item, strokeWidth) {
  // TODO: more sophisticated adjustment? Or miter support in boundContext?
  return item.strokeJoin && item.strokeJoin !== 'miter' ? 0 : strokeWidth;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/bound/boundContext.js


var boundContext_bounds, lx, boundContext_ly,
    circleThreshold = Tau - 1e-8;

function boundContext_context(_) {
  boundContext_bounds = _;
  return boundContext_context;
}

function boundContext_noop() {}

function boundContext_add(x, y) { boundContext_bounds.add(x, y); }

function addL(x, y) { boundContext_add(lx = x, boundContext_ly = y); }

function addX(x) { boundContext_add(x, boundContext_bounds.y1); }

function addY(y) { boundContext_add(boundContext_bounds.x1, y); }

boundContext_context.beginPath = boundContext_noop;

boundContext_context.closePath = boundContext_noop;

boundContext_context.moveTo = addL;

boundContext_context.lineTo = addL;

boundContext_context.rect = function(x, y, w, h) {
  boundContext_add(x + w, y + h);
  addL(x, y);
};

boundContext_context.quadraticCurveTo = function(x1, y1, x2, y2) {
  quadExtrema(lx, x1, x2, addX);
  quadExtrema(boundContext_ly, y1, y2, addY);
  addL(x2, y2);
};

function quadExtrema(x0, x1, x2, cb) {
  const t = (x0 - x1) / (x0 + x2 - 2 * x1);
  if (0 < t && t < 1) cb(x0 + (x1 - x0) * t);
}

boundContext_context.bezierCurveTo = function(x1, y1, x2, y2, x3, y3) {
  cubicExtrema(lx, x1, x2, x3, addX);
  cubicExtrema(boundContext_ly, y1, y2, y3, addY);
  addL(x3, y3);
};

function cubicExtrema(x0, x1, x2, x3, cb) {
  const a = x3 - x0 + 3 * x1 - 3 * x2,
        b = x0 + x2 - 2 * x1,
        c = x0 - x1;

  let t0 = 0, t1 = 0, r;

  // solve for parameter t
  if (Math.abs(a) > Epsilon) {
    // quadratic equation
    r = b * b + c * a;
    if (r >= 0) {
      r = Math.sqrt(r);
      t0 = (-b + r) / a;
      t1 = (-b - r) / a;
    }
  } else {
    // linear equation
    t0 = 0.5 * c / b;
  }

  // calculate position
  if (0 < t0 && t0 < 1) cb(cubic(t0, x0, x1, x2, x3));
  if (0 < t1 && t1 < 1) cb(cubic(t1, x0, x1, x2, x3));
}

function cubic(t, x0, x1, x2, x3) {
  const s = 1 - t, s2 = s * s, t2 = t * t;
  return (s2 * s * x0) + (3 * s2 * t * x1) + (3 * s * t2 * x2) + (t2 * t * x3);
}

boundContext_context.arc = function(cx, cy, r, sa, ea, ccw) {
  // store last point on path
  lx = r * Math.cos(ea) + cx;
  boundContext_ly = r * Math.sin(ea) + cy;

  if (Math.abs(ea - sa) > circleThreshold) {
    // treat as full circle
    boundContext_add(cx - r, cy - r);
    boundContext_add(cx + r, cy + r);
  } else {
    const update = a => boundContext_add(r * Math.cos(a) + cx, r * Math.sin(a) + cy);
    let s, i;

    // sample end points
    update(sa);
    update(ea);

    // sample interior points aligned with 90 degrees
    if (ea !== sa) {
      sa = sa % Tau; if (sa < 0) sa += Tau;
      ea = ea % Tau; if (ea < 0) ea += Tau;

      if (ea < sa) {
        ccw = !ccw; // flip direction
        s = sa; sa = ea; ea = s; // swap end-points
      }

      if (ccw) {
        ea -= Tau;
        s = sa - (sa % HalfPi);
        for (i=0; i<4 && s>ea; ++i, s-=HalfPi) update(s);
      } else {
        s = sa - (sa % HalfPi) + HalfPi;
        for (i=0; i<4 && s<ea; ++i, s=s+HalfPi) update(s);
      }
    }
  }
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/context.js


var context_context = (context_context = domCanvas(1,1))
  ? context_context.getContext('2d')
  : null;

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/intersect.js



const intersect_b = new Bounds();

function intersectPath(draw) {
  return function(item, brush) {
    // rely on (inaccurate) bounds intersection if no context
    if (!context_context) return true;

    // add path to offscreen graphics context
    draw(context_context, item);

    // get bounds intersection region
    intersect_b.clear().union(item.bounds).intersect(brush).round();
    const {x1, y1, x2, y2} = intersect_b;

    // iterate over intersection region
    // perform fine grained inclusion test
    for (let y = y1; y <= y2; ++y) {
      for (let x = x1; x <= x2; ++x) {
        if (context_context.isPointInPath(x, y)) {
          return true;
        }
      }
    }

    // false if no hits in intersection region
    return false;
  };
}

function intersectPoint(item, box) {
  return box.contains(item.x || 0, item.y || 0);
}

function intersectRect(item, box) {
  const x = item.x || 0,
        y = item.y || 0,
        w = item.width || 0,
        h = item.height || 0;
  return box.intersects(intersect_b.set(x, y, x + w, y + h));
}

function intersectRule(item, box) {
  const x = item.x || 0,
        y = item.y || 0,
        x2 = item.x2 != null ? item.x2 : x,
        y2 = item.y2 != null ? item.y2 : y;
  return intersectBoxLine(box, x, y, x2, y2);
}

function intersectBoxLine(box, x, y, u, v) {
  const {x1, y1, x2, y2} = box,
        dx = u - x,
        dy = v - y;

  let t0 = 0, t1 = 1, p, q, r, e;

  for (e=0; e<4; ++e) {
    if (e === 0) { p = -dx; q = -(x1 - x); }
    if (e === 1) { p =  dx; q =  (x2 - x); }
    if (e === 2) { p = -dy; q = -(y1 - y); }
    if (e === 3) { p =  dy; q =  (y2 - y); }

    if (Math.abs(p) < 1e-10 && q < 0) return false;

    r = q / p;

    if (p < 0) {
      if (r > t1) return false;
      else if (r > t0) t0 = r;
    } else if (p > 0) {
      if (r < t0) return false;
      else if (r < t1) t1 = r;
    }
  }

  return true;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/blend.js
/* harmony default export */ var blend = (function(context, item) {
  context.globalCompositeOperation = item.blend || 'source-over';
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/value.js
/* harmony default export */ var util_value = (function(value, dflt) {
  return value == null ? dflt : value;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/gradient.js



function addStops(gradient, stops) {
  const n = stops.length;
  for (let i=0; i<n; ++i) {
    gradient.addColorStop(stops[i].offset, stops[i].color);
  }
  return gradient;
}

/* harmony default export */ var canvas_gradient = (function(context, spec, bounds) {
  const w = bounds.width(),
        h = bounds.height();
  let gradient;


  if (spec.gradient === 'radial') {
    gradient = context.createRadialGradient(
      bounds.x1 + util_value(spec.x1, 0.5) * w,
      bounds.y1 + util_value(spec.y1, 0.5) * h,
      Math.max(w, h) * util_value(spec.r1, 0),
      bounds.x1 + util_value(spec.x2, 0.5) * w,
      bounds.y1 + util_value(spec.y2, 0.5) * h,
      Math.max(w, h) * util_value(spec.r2, 0.5)
    );
  } else { // linear gradient
    const x1 = util_value(spec.x1, 0),
          y1 = util_value(spec.y1, 0),
          x2 = util_value(spec.x2, 1),
          y2 = util_value(spec.y2, 0);

    if (x1 === x2 || y1 === y2 || w === h) {
      // axis aligned: use normal gradient
      gradient = context.createLinearGradient(
        bounds.x1 + x1 * w,
        bounds.y1 + y1 * h,
        bounds.x1 + x2 * w,
        bounds.y1 + y2 * h
      );
    } else {
      // not axis aligned: render gradient into a pattern (#2365)
      // this allows us to use normalized bounding box coordinates
      const image = domCanvas(Math.ceil(w), Math.ceil(h)),
            ictx = image.getContext('2d');

      ictx.scale(w, h);
      ictx.fillStyle = addStops(
        ictx.createLinearGradient(x1, y1, x2, y2),
        spec.stops
      );
      ictx.fillRect(0, 0, w, h);

      return context.createPattern(image, 'no-repeat');
    }
  }

  return addStops(gradient, spec.stops);
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/color.js



/* harmony default export */ var canvas_color = (function(context, item, value) {
  return isGradient(value)
    ? canvas_gradient(context, value, item.bounds)
    : value;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/fill.js


/* harmony default export */ var canvas_fill = (function(context, item, opacity) {
  opacity *= (item.fillOpacity==null ? 1 : item.fillOpacity);
  if (opacity > 0) {
    context.globalAlpha = opacity;
    context.fillStyle = canvas_color(context, item, item.fill);
    return true;
  } else {
    return false;
  }
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/stroke.js


var stroke_Empty = [];

/* harmony default export */ var canvas_stroke = (function(context, item, opacity) {
  var lw = (lw = item.strokeWidth) != null ? lw : 1;

  if (lw <= 0) return false;

  opacity *= (item.strokeOpacity==null ? 1 : item.strokeOpacity);
  if (opacity > 0) {
    context.globalAlpha = opacity;
    context.strokeStyle = canvas_color(context, item, item.stroke);

    context.lineWidth = lw;
    context.lineCap = item.strokeCap || 'butt';
    context.lineJoin = item.strokeJoin || 'miter';
    context.miterLimit = item.strokeMiterLimit || 10;

    if (context.setLineDash) {
      context.setLineDash(item.strokeDash || stroke_Empty);
      context.lineDashOffset = item.strokeDashOffset || 0;
    }
    return true;
  } else {
    return false;
  }
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/visit.js
function visit_compare(a, b) {
  return a.zindex - b.zindex || a.index - b.index;
}

function zorder(scene) {
  if (!scene.zdirty) return scene.zitems;

  var items = scene.items,
      output = [], item, i, n;

  for (i=0, n=items.length; i<n; ++i) {
    item = items[i];
    item.index = i;
    if (item.zindex) output.push(item);
  }

  scene.zdirty = false;
  return scene.zitems = output.sort(visit_compare);
}

function visit_visit(scene, visitor) {
  var items = scene.items, i, n;
  if (!items || !items.length) return;

  var zitems = zorder(scene);

  if (zitems && zitems.length) {
    for (i=0, n=items.length; i<n; ++i) {
      if (!items[i].zindex) visitor(items[i]);
    }
    items = zitems;
  }

  for (i=0, n=items.length; i<n; ++i) {
    visitor(items[i]);
  }
}

function pickVisit(scene, visitor) {
  var items = scene.items, hit, i;
  if (!items || !items.length) return null;

  var zitems = zorder(scene);
  if (zitems && zitems.length) items = zitems;

  for (i=items.length; --i >= 0;) {
    if (hit = visitor(items[i])) return hit;
  }

  if (items === zitems) {
    for (items=scene.items, i=items.length; --i >= 0;) {
      if (!items[i].zindex) {
        if (hit = visitor(items[i])) return hit;
      }
    }
  }

  return null;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/draw.js





function drawAll(path) {
  return function(context, scene, bounds) {
    visit_visit(scene, function(item) {
      if (!bounds || bounds.intersects(item.bounds)) {
        drawPath(path, context, item, item);
      }
    });
  };
}

function drawOne(path) {
  return function(context, scene, bounds) {
    if (scene.items.length && (!bounds || bounds.intersects(scene.bounds))) {
      drawPath(path, context, scene.items[0], scene.items);
    }
  };
}

function drawPath(path, context, item, items) {
  var opacity = item.opacity == null ? 1 : item.opacity;
  if (opacity === 0) return;

  if (path(context, items)) return;

  blend(context, item);

  if (item.fill && canvas_fill(context, item, opacity)) {
    context.fill();
  }

  if (item.stroke && canvas_stroke(context, item, opacity)) {
    context.stroke();
  }
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/pick.js



function pick_pick(test) {
  test = test || vega_util["gb" /* truthy */];

  return function(context, scene, x, y, gx, gy) {
    x *= context.pixelRatio;
    y *= context.pixelRatio;

    return pickVisit(scene, function(item) {
      var b = item.bounds;
      // first hit test against bounding box
      if ((b && !b.contains(gx, gy)) || !b) return;
      // if in bounding box, perform more careful test
      if (test(context, item, x, y, gx, gy)) return item;
    });
  };
}

function hitPath(path, filled) {
  return function(context, o, x, y) {
    var item = Array.isArray(o) ? o[0] : o,
        fill = (filled == null) ? item.fill : filled,
        stroke = item.stroke && context.isPointInStroke, lw, lc;

    if (stroke) {
      lw = item.strokeWidth;
      lc = item.strokeCap;
      context.lineWidth = lw != null ? lw : 1;
      context.lineCap   = lc != null ? lc : 'butt';
    }

    return path(context, o) ? false :
      (fill && context.isPointInPath(x, y)) ||
      (stroke && context.isPointInStroke(x, y));
  };
}

function pickPath(path) {
  return pick_pick(hitPath(path));
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/svg/transform.js
function transform_translate(x, y) {
  return 'translate(' + x + ',' + y + ')';
}

function transform_rotate(a) {
  return 'rotate(' + a + ')';
}

function transform_scale(scaleX, scaleY){
  return 'scale('+ scaleX + ',' + scaleY+')';
}

function translateItem(item) {
  return transform_translate(item.x || 0, item.y || 0);
}

function transformItem(item) {
  return transform_translate(item.x || 0, item.y || 0)
    + (item.angle ? ' ' + transform_rotate(item.angle) : '')
    + (item.scaleX || item.scaleY ? ' ' + transform_scale(item.scaleX || 1, item.scaleY || 1) : '');   
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/markItemPath.js








/* harmony default export */ var markItemPath = (function(type, shape, isect) {

  function attr(emit, item) {
    emit('transform', transformItem(item));
    emit('d', shape(null, item));
  }

  function bound(bounds, item) {
    var x = item.x || 0,
        y = item.y || 0;

    shape(boundContext_context(bounds), item);
    boundStroke(bounds, item).translate(x, y);
    if (item.angle) {
      bounds.rotate(item.angle * DegToRad, x, y);
    }

    return bounds;
  }

  function draw(context, item) {
    var x = item.x || 0,
        y = item.y || 0,
        a = item.angle || 0;

    context.translate(x, y);
    if (a) context.rotate(a *= DegToRad);
    context.beginPath();
    shape(context, item);
    if (a) context.rotate(-a);
    context.translate(-x, -y);
  }

  return {
    type:   type,
    tag:    'path',
    nested: false,
    attr:   attr,
    bound:  bound,
    draw:   drawAll(draw),
    pick:   pickPath(draw),
    isect:  isect || intersectPath(draw)
  };

});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/arc.js



/* harmony default export */ var marks_arc = (markItemPath('arc', shapes_arc));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/pickPath.js
function pickArea(a, p) {
  var v = a[0].orient === 'horizontal' ? p[1] : p[0],
      z = a[0].orient === 'horizontal' ? 'y' : 'x',
      i = a.length,
      min = +Infinity, hit, d;

  while (--i >= 0) {
    if (a[i].defined === false) continue;
    d = Math.abs(a[i][z] - v);
    if (d < min) {
      min = d;
      hit = a[i];
    }
  }

  return hit;
}

function pickLine(a, p) {
  var t = Math.pow(a[0].strokeWidth || 1, 2),
      i = a.length, dx, dy, dd;

  while (--i >= 0) {
    if (a[i].defined === false) continue;
    dx = a[i].x - p[0];
    dy = a[i].y - p[1];
    dd = dx * dx + dy * dy;
    if (dd < t) return a[i];
  }

  return null;
}

function pickTrail(a, p) {
  var i = a.length, dx, dy, dd;

  while (--i >= 0) {
    if (a[i].defined === false) continue;
    dx = a[i].x - p[0];
    dy = a[i].y - p[1];
    dd = dx * dx + dy * dy;
    dx = a[i].size || 1;
    if (dd < dx*dx) return a[i];
  }

  return null;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/markMultiItemPath.js






/* harmony default export */ var markMultiItemPath = (function(type, shape, tip) {

  function attr(emit, item) {
    var items = item.mark.items;
    if (items.length) emit('d', shape(null, items));
  }

  function bound(bounds, mark) {
    var items = mark.items;
    if (items.length === 0) {
      return bounds;
    } else {
      shape(boundContext_context(bounds), items);
      return boundStroke(bounds, items[0]);
    }
  }

  function draw(context, items) {
    context.beginPath();
    shape(context, items);
  }

  var hit = hitPath(draw);

  function pick(context, scene, x, y, gx, gy) {
    var items = scene.items,
        b = scene.bounds;

    if (!items || !items.length || b && !b.contains(gx, gy)) {
      return null;
    }

    x *= context.pixelRatio;
    y *= context.pixelRatio;
    return hit(context, items, x, y) ? items[0] : null;
  }

  return {
    type:   type,
    tag:    'path',
    nested: true,
    attr:   attr,
    bound:  bound,
    draw:   drawOne(draw),
    pick:   pick,
    isect:  intersectPoint,
    tip:    tip
  };

});



// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/area.js




/* harmony default export */ var marks_area = (markMultiItemPath('area', shapes_area, pickArea));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/clip.js



/* harmony default export */ var canvas_clip = (function(context, scene) {
  var clip = scene.clip;

  context.save();

  if (Object(vega_util["D" /* isFunction */])(clip)) {
    context.beginPath();
    clip(context);
    context.clip();
  } else {
    clipGroup(context, scene.group);
  }
});

function clipGroup(context, group) {
  context.beginPath();
  hasCornerRadius(group)
    ? shapes_rectangle(context, group, 0, 0)
    : context.rect(0, 0, group.width || 0, group.height || 0);
  context.clip();
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/group.js













function group_offset(item) {
  const sw = util_value(item.strokeWidth, 1);
  return item.strokeOffset != null ? item.strokeOffset
    : item.stroke && sw > 0.5 && sw < 1.5 ? 0.5 - Math.abs(sw - 1)
    : 0;
}

function group_attr(emit, item) {
  emit('transform', translateItem(item));
}

function emitRectangle(emit, item) {
  const off = group_offset(item);
  emit('d', shapes_rectangle(null, item, off, off));
}

function background(emit, item) {
  emit('class', 'background');
  emit('aria-hidden', true);
  emitRectangle(emit, item);
}

function foreground(emit, item) {
  emit('class', 'foreground');
  emit('aria-hidden', true);
  if (item.strokeForeground) {
    emitRectangle(emit, item);
  } else {
    emit('d', '');
  }
}

function content(emit, item, renderer) {
  const url = item.clip ? svg_clip(renderer, item, item) : null;
  emit('clip-path', url);
}

function group_bound(bounds, group) {
  if (!group.clip && group.items) {
    const items = group.items, m = items.length;
    for (let j=0; j<m; ++j) {
      bounds.union(items[j].bounds);
    }
  }

  if ((group.clip || group.width || group.height) && !group.noBound) {
    bounds.add(0, 0).add(group.width || 0, group.height || 0);
  }

  boundStroke(bounds, group);

  return bounds.translate(group.x || 0, group.y || 0);
}

function rectanglePath(context, group, x, y) {
  const off = group_offset(group);
  context.beginPath();
  shapes_rectangle(context, group, (x || 0) + off, (y || 0) + off);
}

const hitBackground = hitPath(rectanglePath);
const hitForeground = hitPath(rectanglePath, false);

function group_draw(context, scene, bounds) {
  visit_visit(scene, group => {
    const gx = group.x || 0,
          gy = group.y || 0,
          fore = group.strokeForeground,
          opacity = group.opacity == null ? 1 : group.opacity;

    // draw group background
    if ((group.stroke || group.fill) && opacity) {
      rectanglePath(context, group, gx, gy);
      blend(context, group);
      if (group.fill && canvas_fill(context, group, opacity)) {
        context.fill();
      }
      if (group.stroke && !fore && canvas_stroke(context, group, opacity)) {
        context.stroke();
      }
    }

    // setup graphics context, set clip and bounds
    context.save();
    context.translate(gx, gy);
    if (group.clip) clipGroup(context, group);
    if (bounds) bounds.translate(-gx, -gy);

    // draw group contents
    visit_visit(group, item => {
      this.draw(context, item, bounds);
    });

    // restore graphics context
    if (bounds) bounds.translate(gx, gy);
    context.restore();

    // draw group foreground
    if (fore && group.stroke && opacity) {
      rectanglePath(context, group, gx, gy);
      blend(context, group);
      if (canvas_stroke(context, group, opacity)) {
        context.stroke();
      }
    }
  });
}

function group_pick(context, scene, x, y, gx, gy) {
  if (scene.bounds && !scene.bounds.contains(gx, gy) || !scene.items) {
    return null;
  }

  const cx = x * context.pixelRatio,
        cy = y * context.pixelRatio;

  return pickVisit(scene, group => {
    let hit, fore, ix, dx, dy, dw, dh, b, c;

    // first hit test bounding box
    b = group.bounds;
    if (b && !b.contains(gx, gy)) return;

    // passed bounds check, test rectangular clip
    dx = group.x || 0;
    dy = group.y || 0;
    dw = dx + (group.width || 0);
    dh = dy + (group.height || 0);
    c = group.clip;
    if (c && (gx < dx || gx > dw || gy < dy || gy > dh)) return;

    // adjust coordinate system
    context.save();
    context.translate(dx, dy);
    dx = gx - dx;
    dy = gy - dy;

    // test background for rounded corner clip
    if (c && hasCornerRadius(group) && !hitBackground(context, group, cx, cy)) {
      context.restore();
      return null;
    }

    fore = group.strokeForeground;
    ix = scene.interactive !== false;

    // hit test against group foreground
    if (ix && fore && group.stroke
        && hitForeground(context, group, cx, cy)) {
      context.restore();
      return group;
    }

    // hit test against contained marks
    hit = pickVisit(group, mark => pickMark(mark, dx, dy)
      ? this.pick(mark, x, y, dx, dy)
      : null
    );

    // hit test against group background
    if (!hit && ix && (group.fill || (!fore && group.stroke))
        && hitBackground(context, group, cx, cy)) {
      hit = group;
    }

    // restore state and return
    context.restore();
    return hit || null;
  });
}

function pickMark(mark, x, y) {
  return (mark.interactive !== false || mark.marktype === 'group')
    && mark.bounds && mark.bounds.contains(x, y);
}

/* harmony default export */ var marks_group = ({
  type:       'group',
  tag:        'g',
  nested:     false,
  attr:       group_attr,
  bound:      group_bound,
  draw:       group_draw,
  pick:       group_pick,
  isect:      intersectRect,
  content:    content,
  background: background,
  foreground: foreground
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/svg/metadata.js
/* harmony default export */ var svg_metadata = ({
  'version': '1.1',
  'xmlns': 'http://www.w3.org/2000/svg',
  'xmlns:xlink': 'http://www.w3.org/1999/xlink'
});
// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/image.js







function getImage(item, renderer) {
  var image = item.image;
  if (!image || item.url && item.url !== image.url) {
    image = {complete: false, width: 0, height: 0};
    renderer.loadImage(item.url).then(image => {
      item.image = image;
      item.image.url = item.url;
    });
  }
  return image;
}

function imageWidth(item, image) {
  return item.width != null ? item.width
    : !image || !image.width ? 0
    : item.aspect !== false && item.height ? item.height * image.width / image.height
    : image.width;
}

function imageHeight(item, image) {
  return item.height != null ? item.height
    : !image || !image.height ? 0
    : item.aspect !== false && item.width ? item.width * image.height / image.width
    : image.height;
}

function imageXOffset(align, w) {
  return align === 'center' ? w / 2 : align === 'right' ? w : 0;
}

function imageYOffset(baseline, h) {
  return baseline === 'middle' ? h / 2 : baseline === 'bottom' ? h : 0;
}

function image_attr(emit, item, renderer) {
  const img = getImage(item, renderer),
        w = imageWidth(item, img),
        h = imageHeight(item, img),
        x = (item.x || 0) - imageXOffset(item.align, w),
        y = (item.y || 0) - imageYOffset(item.baseline, h),
        i = !img.src && img.toDataURL ? img.toDataURL() : img.src || '';

  emit('href', i, svg_metadata['xmlns:xlink'], 'xlink:href');
  emit('transform', transform_translate(x, y));
  emit('width', w);
  emit('height', h);
  emit('preserveAspectRatio', item.aspect === false ? 'none' : 'xMidYMid');
}

function image_bound(bounds, item) {
  const img = item.image,
        w = imageWidth(item, img),
        h = imageHeight(item, img),
        x = (item.x || 0) - imageXOffset(item.align, w),
        y = (item.y || 0) - imageYOffset(item.baseline, h);

  return bounds.set(x, y, x + w, y + h);
}

function image_draw(context, scene, bounds) {
  visit_visit(scene, item => {
    if (bounds && !bounds.intersects(item.bounds)) return; // bounds check

    let img = getImage(item, this),
        w = imageWidth(item, img),
        h = imageHeight(item, img),
        x = (item.x || 0) - imageXOffset(item.align, w),
        y = (item.y || 0) - imageYOffset(item.baseline, h),
        opacity, ar0, ar1, t;

    if (item.aspect !== false) {
      ar0 = img.width / img.height;
      ar1 = item.width / item.height;
      if (ar0 === ar0 && ar1 === ar1 && ar0 !== ar1) {
        if (ar1 < ar0) {
          t = w / ar0;
          y += (h - t) / 2;
          h = t;
        } else {
          t = h * ar0;
          x += (w - t) / 2;
          w = t;
        }
      }
    }

    if (img.complete || img.toDataURL) {
      blend(context, item);
      context.globalAlpha = (opacity = item.opacity) != null ? opacity : 1;
      context.imageSmoothingEnabled = item.smooth !== false;
      context.drawImage(img, x, y, w, h);
    }
  });
}

/* harmony default export */ var marks_image = ({
  type:     'image',
  tag:      'image',
  nested:   false,
  attr:     image_attr,
  bound:    image_bound,
  draw:     image_draw,
  pick:     pick_pick(),
  isect:    vega_util["gb" /* truthy */], // bounds check is sufficient
  get:      getImage,
  xOffset:  imageXOffset,
  yOffset:  imageYOffset
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/line.js




/* harmony default export */ var marks_line = (markMultiItemPath('line', shapes_line, pickLine));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/path.js










function path_attr(emit, item) {
  var sx = item.scaleX || 1,
      sy = item.scaleY || 1;
  if (sx !== 1 || sy !== 1) {
    emit('vector-effect', 'non-scaling-stroke');
  }
  emit('transform', transformItem(item));
  emit('d', item.path);
}

function marks_path_path(context, item) {
  var path = item.path;
  if (path == null) return true;

  var x = item.x || 0,
      y = item.y || 0,
      sx = item.scaleX || 1,
      sy = item.scaleY || 1,
      a = (item.angle || 0) * DegToRad,
      cache = item.pathCache;

  if (!cache || cache.path !== path) {
    (item.pathCache = cache = path_parse(path)).path = path;
  }

  if (a && context.rotate && context.translate) {
    context.translate(x, y);
    context.rotate(a);
    path_render(context, cache, 0, 0, sx, sy);
    context.rotate(-a);
    context.translate(-x, -y);
  } else {
    path_render(context, cache, x, y, sx, sy);
  }
}

function path_bound(bounds, item) {
  marks_path_path(boundContext_context(bounds), item)
    ? bounds.set(0, 0, 0, 0)
    : boundStroke(bounds, item, true);

  if (item.angle) {
    bounds.rotate(item.angle * DegToRad, item.x || 0, item.y || 0);
  }

  return bounds;
}

/* harmony default export */ var marks_path = ({
  type:   'path',
  tag:    'path',
  nested: false,
  attr:   path_attr,
  bound:  path_bound,
  draw:   drawAll(marks_path_path),
  pick:   pickPath(marks_path_path),
  isect:  intersectPath(marks_path_path)
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/rect.js






function rect_attr(emit, item) {
  emit('d', shapes_rectangle(null, item));
}

function rect_bound(bounds, item) {
  var x, y;
  return boundStroke(bounds.set(
    x = item.x || 0,
    y = item.y || 0,
    (x + item.width) || 0,
    (y + item.height) || 0
  ), item);
}

function rect_draw(context, item) {
  context.beginPath();
  shapes_rectangle(context, item);
}

/* harmony default export */ var rect = ({
  type:   'rect',
  tag:    'path',
  nested: false,
  attr:   rect_attr,
  bound:  rect_bound,
  draw:   drawAll(rect_draw),
  pick:   pickPath(rect_draw),
  isect:  intersectRect
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/rule.js








function rule_attr(emit, item) {
  emit('transform', translateItem(item));
  emit('x2', item.x2 != null ? item.x2 - (item.x || 0) : 0);
  emit('y2', item.y2 != null ? item.y2 - (item.y || 0) : 0);
}

function rule_bound(bounds, item) {
  var x1, y1;
  return boundStroke(bounds.set(
    x1 = item.x || 0,
    y1 = item.y || 0,
    item.x2 != null ? item.x2 : x1,
    item.y2 != null ? item.y2 : y1
  ), item);
}

function rule_path(context, item, opacity) {
  var x1, y1, x2, y2;

  if (item.stroke && canvas_stroke(context, item, opacity)) {
    x1 = item.x || 0;
    y1 = item.y || 0;
    x2 = item.x2 != null ? item.x2 : x1;
    y2 = item.y2 != null ? item.y2 : y1;
    context.beginPath();
    context.moveTo(x1, y1);
    context.lineTo(x2, y2);
    return true;
  }
  return false;
}

function rule_draw(context, scene, bounds) {
  visit_visit(scene, function(item) {
    if (bounds && !bounds.intersects(item.bounds)) return; // bounds check
    var opacity = item.opacity == null ? 1 : item.opacity;
    if (opacity && rule_path(context, item, opacity)) {
      blend(context, item);
      context.stroke();
    }
  });
}

function rule_hit(context, item, x, y) {
  if (!context.isPointInStroke) return false;
  return rule_path(context, item, 1) && context.isPointInStroke(x, y);
}

/* harmony default export */ var marks_rule = ({
  type:   'rule',
  tag:    'line',
  nested: false,
  attr:   rule_attr,
  bound:  rule_bound,
  draw:   rule_draw,
  pick:   pick_pick(rule_hit),
  isect:  intersectRule
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/shape.js



/* harmony default export */ var marks_shape = (markItemPath('shape', shapes_shape));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/symbol.js




/* harmony default export */ var marks_symbol = (markItemPath('symbol', shapes_symbol, intersectPoint));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/text.js



// memoize text width measurement
const widthCache = Object(vega_util["L" /* lruCache */])();

var textMetrics = {
  height: text_fontSize,
  measureWidth: measureWidth,
  estimateWidth: estimateWidth,
  width: estimateWidth,
  canvas: useCanvas
};

useCanvas(true);

function useCanvas(use) {
  textMetrics.width = (use && context_context) ? measureWidth : estimateWidth;
}

// make dumb, simple estimate if no canvas is available
function estimateWidth(item, text) {
  return _estimateWidth(textValue(item, text), text_fontSize(item));
}

function _estimateWidth(text, currentFontHeight) {
  return ~~(0.8 * text.length * currentFontHeight);
}

// measure text width if canvas is available
function measureWidth(item, text) {
  return text_fontSize(item) <= 0 || !(text = textValue(item, text)) ? 0
    : _measureWidth(text, text_font(item));
}

function _measureWidth(text, currentFont) {
  const key = `(${currentFont}) ${text}`;
  let width = widthCache.get(key);
  if (width === undefined) {
    context_context.font = currentFont;
    width = context_context.measureText(text).width;
    widthCache.set(key, width);
  }
  return width;
}

function text_fontSize(item) {
  return item.fontSize != null ? (+item.fontSize || 0) : 11;
}

function lineHeight(item) {
  return item.lineHeight != null ? item.lineHeight : (text_fontSize(item) + 2);
}

function lineArray(_) {
  return Object(vega_util["A" /* isArray */])(_) ? _.length > 1 ? _ : _[0] : _;
}

function textLines(item) {
  return lineArray(
    item.lineBreak && item.text && !Object(vega_util["A" /* isArray */])(item.text)
      ? item.text.split(item.lineBreak)
      : item.text
  );
}

function multiLineOffset(item) {
  const tl = textLines(item);
  return (Object(vega_util["A" /* isArray */])(tl) ? (tl.length - 1) : 0) * lineHeight(item);
}

function textValue(item, line) {
  const text = line == null ? '' : (line + '').trim();
  return item.limit > 0 && text.length ? truncate(item, text) : text;
}

function widthGetter(item) {
  if (textMetrics.width === measureWidth) {
    // we are using canvas
    const currentFont = text_font(item);
    return text => _measureWidth(text, currentFont);
  } else {
    // we are relying on estimates
    const currentFontHeight = text_fontSize(item);
    return text => _estimateWidth(text, currentFontHeight);
  }
}

function truncate(item, text) {
  var limit = +item.limit,
      width = widthGetter(item);

  if (width(text) < limit) return text;

  var ellipsis = item.ellipsis || '\u2026',
      rtl = item.dir === 'rtl',
      lo = 0,
      hi = text.length, mid;

  limit -= width(ellipsis);

  if (rtl) {
    while (lo < hi) {
      mid = (lo + hi >>> 1);
      if (width(text.slice(mid)) > limit) lo = mid + 1;
      else hi = mid;
    }
    return ellipsis + text.slice(lo);
  } else {
    while (lo < hi) {
      mid = 1 + (lo + hi >>> 1);
      if (width(text.slice(0, mid)) < limit) lo = mid;
      else hi = mid - 1;
    }
    return text.slice(0, lo) + ellipsis;
  }
}

function fontFamily(item, quote) {
  var font = item.font;
  return (quote && font
    ? String(font).replace(/"/g, '\'')
    : font) || 'sans-serif';
}

function text_font(item, quote) {
  return '' +
    (item.fontStyle ? item.fontStyle + ' ' : '') +
    (item.fontVariant ? item.fontVariant + ' ' : '') +
    (item.fontWeight ? item.fontWeight + ' ' : '') +
    text_fontSize(item) + 'px ' +
    fontFamily(item, quote);
}

function text_offset(item) {
  // perform our own font baseline calculation
  // why? not all browsers support SVG 1.1 'alignment-baseline' :(
  // this also ensures consistent layout across renderers
  var baseline = item.baseline,
      h = text_fontSize(item);

  return Math.round(
    baseline === 'top'         ?  0.79 * h :
    baseline === 'middle'      ?  0.30 * h :
    baseline === 'bottom'      ? -0.21 * h :
    baseline === 'line-top'    ?  0.29 * h + 0.5 * lineHeight(item) :
    baseline === 'line-bottom' ?  0.29 * h - 0.5 * lineHeight(item) : 0
  );
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/text.js












var textAlign = {
  'left':   'start',
  'center': 'middle',
  'right':  'end'
};

var tempBounds = new Bounds();

function anchorPoint(item) {
  var x = item.x || 0,
      y = item.y || 0,
      r = item.radius || 0, t;

  if (r) {
    t = (item.theta || 0) - HalfPi;
    x += r * Math.cos(t);
    y += r * Math.sin(t);
  }

  tempBounds.x1 = x;
  tempBounds.y1 = y;
  return tempBounds;
}

function text_attr(emit, item) {
  var dx = item.dx || 0,
      dy = (item.dy || 0) + text_offset(item),
      p = anchorPoint(item),
      x = p.x1,
      y = p.y1,
      a = item.angle || 0, t;

  emit('text-anchor', textAlign[item.align] || 'start');

  if (a) {
    t = transform_translate(x, y) + ' ' + transform_rotate(a);
    if (dx || dy) t += ' ' + transform_translate(dx, dy);
  } else {
    t = transform_translate(x + dx, y + dy);
  }
  emit('transform', t);
}

function text_bound(bounds, item, mode) {
  var h = textMetrics.height(item),
      a = item.align,
      p = anchorPoint(item),
      x = p.x1,
      y = p.y1,
      dx = item.dx || 0,
      dy = (item.dy || 0) + text_offset(item) - Math.round(0.8*h), // use 4/5 offset
      tl = textLines(item),
      w;

  // get dimensions
  if (Object(vega_util["A" /* isArray */])(tl)) {
    // multi-line text
    h += lineHeight(item) * (tl.length - 1);
    w = tl.reduce((w, t) => Math.max(w, textMetrics.width(item, t)), 0);
  } else {
    // single-line text
    w = textMetrics.width(item, tl);
  }

  // horizontal alignment
  if (a === 'center') {
    dx -= (w / 2);
  } else if (a === 'right') {
    dx -= w;
  } else {
    // left by default, do nothing
  }

  bounds.set(dx+=x, dy+=y, dx+w, dy+h);

  if (item.angle && !mode) {
    bounds.rotate(item.angle * DegToRad, x, y);
  } else if (mode === 2) {
    return bounds.rotatedPoints(item.angle * DegToRad, x, y);
  }
  return bounds;
}

function text_draw(context, scene, bounds) {
  visit_visit(scene, function(item) {
    var opacity = item.opacity == null ? 1 : item.opacity,
        p, x, y, i, lh, tl, str;

    if (bounds && !bounds.intersects(item.bounds) || // bounds check
        opacity === 0 || item.fontSize <= 0 ||
        item.text == null || item.text.length === 0) return;

    context.font = text_font(item);
    context.textAlign = item.align || 'left';

    p = anchorPoint(item);
    x = p.x1,
    y = p.y1;

    if (item.angle) {
      context.save();
      context.translate(x, y);
      context.rotate(item.angle * DegToRad);
      x = y = 0; // reset x, y
    }
    x += (item.dx || 0);
    y += (item.dy || 0) + text_offset(item);

    tl = textLines(item);
    blend(context, item);
    if (Object(vega_util["A" /* isArray */])(tl)) {
      lh = lineHeight(item);
      for (i=0; i<tl.length; ++i) {
        str = textValue(item, tl[i]);
        if (item.fill && canvas_fill(context, item, opacity)) {
          context.fillText(str, x, y);
        }
        if (item.stroke && canvas_stroke(context, item, opacity)) {
          context.strokeText(str, x, y);
        }
        y += lh;
      }
    } else {
      str = textValue(item, tl);
      if (item.fill && canvas_fill(context, item, opacity)) {
        context.fillText(str, x, y);
      }
      if (item.stroke && canvas_stroke(context, item, opacity)) {
        context.strokeText(str, x, y);
      }
    }

    if (item.angle) context.restore();
  });
}

function text_hit(context, item, x, y, gx, gy) {
  if (item.fontSize <= 0) return false;
  if (!item.angle) return true; // bounds sufficient if no rotation

  // project point into space of unrotated bounds
  var p = anchorPoint(item),
      ax = p.x1,
      ay = p.y1,
      b = text_bound(tempBounds, item, 1),
      a = -item.angle * DegToRad,
      cos = Math.cos(a),
      sin = Math.sin(a),
      px = cos * gx - sin * gy + (ax - cos * ax + sin * ay),
      py = sin * gx + cos * gy + (ay - sin * ax - cos * ay);

  return b.contains(px, py);
}

function intersectText(item, box) {
  var p = text_bound(tempBounds, item, 2);
  return intersectBoxLine(box, p[0], p[1], p[2], p[3])
      || intersectBoxLine(box, p[0], p[1], p[4], p[5])
      || intersectBoxLine(box, p[4], p[5], p[6], p[7])
      || intersectBoxLine(box, p[2], p[3], p[6], p[7]);
}

/* harmony default export */ var marks_text = ({
  type:   'text',
  tag:    'text',
  nested: false,
  attr:   text_attr,
  bound:  text_bound,
  draw:   text_draw,
  pick:   pick_pick(text_hit),
  isect:  intersectText
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/trail.js




/* harmony default export */ var marks_trail = (markMultiItemPath('trail', shapes_trail, pickTrail));

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/marks/index.js













/* harmony default export */ var src_marks = ({
  arc:     marks_arc,
  area:    marks_area,
  group:   marks_group,
  image:   marks_image,
  line:    marks_line,
  path:    marks_path,
  rect:    rect,
  rule:    marks_rule,
  shape:   marks_shape,
  symbol:  marks_symbol,
  text:    marks_text,
  trail:   marks_trail
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/bound/boundItem.js



/* harmony default export */ var boundItem = (function(item, func, opt) {
  var type = src_marks[item.mark.marktype],
      bound = func || type.bound;
  if (type.nested) item = item.mark;

  return bound(item.bounds || (item.bounds = new Bounds()), item, opt);
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/bound/boundMark.js




var DUMMY = {mark: null};

/* harmony default export */ var boundMark = (function(mark, bounds, opt) {
  var type  = src_marks[mark.marktype],
      bound = type.bound,
      items = mark.items,
      hasItems = items && items.length,
      i, n, item, b;

  if (type.nested) {
    if (hasItems) {
      item = items[0];
    } else {
      // no items, fake it
      DUMMY.mark = mark;
      item = DUMMY;
    }
    b = boundItem(item, bound, opt);
    bounds = bounds && bounds.union(b) || b;
    return bounds;
  }

  bounds = bounds
    || mark.bounds && mark.bounds.clear()
    || new Bounds();

  if (hasItems) {
    for (i=0, n=items.length; i<n; ++i) {
      bounds.union(boundItem(items[i], bound, opt));
    }
  }

  return mark.bounds = bounds;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/serialize.js


var serialize_keys = [
  'marktype', 'name', 'role', 'interactive', 'clip', 'items', 'zindex',
  'x', 'y', 'width', 'height', 'align', 'baseline',             // layout
  'fill', 'fillOpacity', 'opacity', 'blend',                    // fill
  'stroke', 'strokeOpacity', 'strokeWidth', 'strokeCap',        // stroke
  'strokeDash', 'strokeDashOffset',                             // stroke dash
  'strokeForeground', 'strokeOffset',                           // group
  'startAngle', 'endAngle', 'innerRadius', 'outerRadius',       // arc
  'cornerRadius', 'padAngle',                                   // arc, rect
  'cornerRadiusTopLeft', 'cornerRadiusTopRight',                // rect, group
  'cornerRadiusBottomLeft', 'cornerRadiusBottomRight',
  'interpolate', 'tension', 'orient', 'defined',                // area, line
  'url', 'aspect', 'smooth',                                    // image
  'path', 'scaleX', 'scaleY',                                   // path
  'x2', 'y2',                                                   // rule
  'size', 'shape',                                              // symbol
  'text', 'angle', 'theta', 'radius', 'dir', 'dx', 'dy',        // text
  'ellipsis', 'limit', 'lineBreak', 'lineHeight',
  'font', 'fontSize', 'fontWeight', 'fontStyle', 'fontVariant', // font
  'description', 'aria', 'ariaRole', 'ariaRoleDescription'      // aria
];

function sceneToJSON(scene, indent) {
  return JSON.stringify(scene, serialize_keys, indent);
}

function sceneFromJSON(json) {
  var scene = (typeof json === 'string' ? JSON.parse(json) : json);
  return serialize_initialize(scene);
}

function serialize_initialize(scene) {
  var type = scene.marktype,
      items = scene.items,
      parent, i, n;

  if (items) {
    for (i=0, n=items.length; i<n; ++i) {
      parent = type ? 'mark' : 'group';
      items[i][parent] = scene;
      if (items[i].zindex) items[i][parent].zdirty = true;
      if ('group' === (type || parent)) serialize_initialize(items[i]);
    }
  }

  if (type) boundMark(scene);
  return scene;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Scenegraph.js




function Scenegraph(scene) {
  if (arguments.length) {
    this.root = sceneFromJSON(scene);
  } else {
    this.root = createMark({
      marktype: 'group',
      name: 'root',
      role: 'frame'
    });
    this.root.items = [new GroupItem(this.root)];
  }
}

var Scenegraph_prototype = Scenegraph.prototype;

Scenegraph_prototype.toJSON = function(indent) {
  return sceneToJSON(this.root, indent || 0);
};

Scenegraph_prototype.mark = function(markdef, group, index) {
  group = group || this.root.items[0];
  var mark = createMark(markdef, group);
  group.items[index] = mark;
  if (mark.zindex) mark.group.zdirty = true;
  return mark;
};

function createMark(def, group) {
  const mark = {
    bounds:      new Bounds(),
    clip:        !!def.clip,
    group:       group,
    interactive: def.interactive === false ? false : true,
    items:       [],
    marktype:    def.marktype,
    name:        def.name || undefined,
    role:        def.role || undefined,
    zindex:      def.zindex || 0
  };

  // add accessibility properties if defined
  if (def.aria != null) {
    mark.aria = def.aria;
  }
  if (def.description) {
    mark.description = def.description;
  }

  return mark;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/dom.js
// create a new DOM element
function domCreate(doc, tag, ns) {
  if (!doc && typeof document !== 'undefined' && document.createElement) {
    doc = document;
  }
  return doc
    ? (ns ? doc.createElementNS(ns, tag) : doc.createElement(tag))
    : null;
}

// find first child element with matching tag
function domFind(el, tag) {
  tag = tag.toLowerCase();
  var nodes = el.childNodes, i = 0, n = nodes.length;
  for (; i<n; ++i) if (nodes[i].tagName.toLowerCase() === tag) {
    return nodes[i];
  }
}

// retrieve child element at given index
// create & insert if doesn't exist or if tags do not match
function domChild(el, index, tag, ns) {
  var a = el.childNodes[index], b;
  if (!a || a.tagName.toLowerCase() !== tag.toLowerCase()) {
    b = a || null;
    a = domCreate(el.ownerDocument, tag, ns);
    el.insertBefore(a, b);
  }
  return a;
}

// remove all child elements at or above the given index
function domClear(el, index) {
  var nodes = el.childNodes,
      curr = nodes.length;
  while (curr > index) el.removeChild(nodes[--curr]);
  return el;
}

// generate css class name for mark
function cssClass(mark) {
  return 'mark-' + mark.marktype
    + (mark.role ? ' role-' + mark.role : '')
    + (mark.name ? ' ' + mark.name : '');
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/point.js
/* harmony default export */ var util_point = (function(event, el) {
  var rect = el.getBoundingClientRect();
  return [
    event.clientX - rect.left - (el.clientLeft || 0),
    event.clientY - rect.top - (el.clientTop || 0)
  ];
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/resolveItem.js



/* harmony default export */ var resolveItem = (function(item, event, el, origin) {
  var mark = item && item.mark,
      mdef, p;

  if (mark && (mdef = src_marks[mark.marktype]).tip) {
    p = util_point(event, el);
    p[0] -= origin[0];
    p[1] -= origin[1];
    while (item = item.mark.group) {
      p[0] -= item.x || 0;
      p[1] -= item.y || 0;
    }
    item = mdef.tip(mark.items, p);
  }

  return item;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Handler.js




/**
 * Create a new Handler instance.
 * @param {object} [customLoader] - Optional loader instance for
 *   href URL sanitization. If not specified, a standard loader
 *   instance will be generated.
 * @param {function} [customTooltip] - Optional tooltip handler
 *   function for custom tooltip display.
 * @constructor
 */
function Handler_Handler(customLoader, customTooltip) {
  this._active = null;
  this._handlers = {};
  this._loader = customLoader || index_browser_loader();
  this._tooltip = customTooltip || defaultTooltip;
}

// The default tooltip display handler.
// Sets the HTML title attribute on the visualization container.
function defaultTooltip(handler, event, item, value) {
  handler.element().setAttribute('title', value || '');
}

const Handler_prototype = Handler_Handler.prototype;

/**
 * Initialize a new Handler instance.
 * @param {DOMElement} el - The containing DOM element for the display.
 * @param {Array<number>} origin - The origin of the display, in pixels.
 *   The coordinate system will be translated to this point.
 * @param {object} [obj] - Optional context object that should serve as
 *   the "this" context for event callbacks.
 * @return {Handler} - This handler instance.
 */
Handler_prototype.initialize = function(el, origin, obj) {
  this._el = el;
  this._obj = obj || null;
  return this.origin(origin);
};

/**
 * Returns the parent container element for a visualization.
 * @return {DOMElement} - The containing DOM element.
 */
Handler_prototype.element = function() {
  return this._el;
};

/**
 * Returns the scene element (e.g., canvas or SVG) of the visualization
 * Subclasses must override if the first child is not the scene element.
 * @return {DOMElement} - The scene (e.g., canvas or SVG) element.
 */
Handler_prototype.canvas = function() {
  return this._el && this._el.firstChild;
};

/**
 * Get / set the origin coordinates of the visualization.
 */
Handler_prototype.origin = function(origin) {
  if (arguments.length) {
    this._origin = origin || [0, 0];
    return this;
  } else {
    return this._origin.slice();
  }
};

/**
 * Get / set the scenegraph root.
 */
Handler_prototype.scene = function(scene) {
  if (!arguments.length) return this._scene;
  this._scene = scene;
  return this;
};

/**
 * Add an event handler. Subclasses should override this method.
 */
Handler_prototype.on = function(/*type, handler*/) {};

/**
 * Remove an event handler. Subclasses should override this method.
 */
Handler_prototype.off = function(/*type, handler*/) {};

/**
 * Utility method for finding the array index of an event handler.
 * @param {Array} h - An array of registered event handlers.
 * @param {string} type - The event type.
 * @param {function} handler - The event handler instance to find.
 * @return {number} - The handler's array index or -1 if not registered.
 */
Handler_prototype._handlerIndex = function(h, type, handler) {
  for (let i = h ? h.length : 0; --i>=0;) {
    if (h[i].type === type && (!handler || h[i].handler === handler)) {
      return i;
    }
  }
  return -1;
};

/**
 * Returns an array with registered event handlers.
 * @param {string} [type] - The event type to query. Any annotations
 *   are ignored; for example, for the argument "click.foo", ".foo" will
 *   be ignored and the method returns all "click" handlers. If type is
 *   null or unspecified, this method returns handlers for all types.
 * @return {Array} - A new array containing all registered event handlers.
 */
Handler_prototype.handlers = function(type) {
  const h = this._handlers, a = [];
  if (type) {
    a.push.apply(a, h[this.eventName(type)]);
  } else {
    for (const k in h) { a.push.apply(a, h[k]); }
  }
  return a;
};

/**
 * Parses an event name string to return the specific event type.
 * For example, given "click.foo" returns "click"
 * @param {string} name - The input event type string.
 * @return {string} - A string with the event type only.
 */
Handler_prototype.eventName = function(name) {
  const i = name.indexOf('.');
  return i < 0 ? name : name.slice(0, i);
};

/**
 * Handle hyperlink navigation in response to an item.href value.
 * @param {Event} event - The event triggering hyperlink navigation.
 * @param {Item} item - The scenegraph item.
 * @param {string} href - The URL to navigate to.
 */
Handler_prototype.handleHref = function(event, item, href) {
  this._loader
    .sanitize(href, {context:'href'})
    .then(opt => {
      const e = new MouseEvent(event.type, event),
            a = domCreate(null, 'a');
      for (const name in opt) a.setAttribute(name, opt[name]);
      a.dispatchEvent(e);
    })
    .catch(function() { /* do nothing */ });
};

/**
 * Handle tooltip display in response to an item.tooltip value.
 * @param {Event} event - The event triggering tooltip display.
 * @param {Item} item - The scenegraph item.
 * @param {boolean} show - A boolean flag indicating whether
 *   to show or hide a tooltip for the given item.
 */
Handler_prototype.handleTooltip = function(event, item, show) {
  if (item && item.tooltip != null) {
    item = resolveItem(item, event, this.canvas(), this._origin);
    const value = (show && item && item.tooltip) || null;
    this._tooltip.call(this._obj, this, event, item, value);
  }
};

/**
 * Returns the size of a scenegraph item and its position relative
 * to the viewport.
 * @param {Item} item - The scenegraph item.
 * @return {object} - A bounding box object (compatible with the
 *   DOMRect type) consisting of x, y, width, heigh, top, left,
 *   right, and bottom properties.
 */
Handler_prototype.getItemBoundingClientRect = function(item) {
  const el = this.canvas();
  if (!el) return;

  const rect = el.getBoundingClientRect(),
        origin = this._origin,
        bounds = item.bounds,
        width = bounds.width(),
        height = bounds.height();

  let x = bounds.x1 + origin[0] + rect.left,
      y = bounds.y1 + origin[1] + rect.top;

  // translate coordinate for each parent group
  while (item.mark && (item = item.mark.group)) {
    x += item.x || 0;
    y += item.y || 0;
  }

  // return DOMRect-compatible bounding box
  return {
    x, y, width, height,
    left: x, top: y, right: x + width, bottom: y + height
  };
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/Renderer.js


/**
 * Create a new Renderer instance.
 * @param {object} [loader] - Optional loader instance for
 *   image and href URL sanitization. If not specified, a
 *   standard loader instance will be generated.
 * @constructor
 */
function Renderer_Renderer(loader) {
  this._el = null;
  this._bgcolor = null;
  this._loader = new ResourceLoader(loader);
}

var Renderer_prototype = Renderer_Renderer.prototype;

/**
 * Initialize a new Renderer instance.
 * @param {DOMElement} el - The containing DOM element for the display.
 * @param {number} width - The coordinate width of the display, in pixels.
 * @param {number} height - The coordinate height of the display, in pixels.
 * @param {Array<number>} origin - The origin of the display, in pixels.
 *   The coordinate system will be translated to this point.
 * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
 *   the width and height to determine the final pixel size.
 * @return {Renderer} - This renderer instance.
 */
Renderer_prototype.initialize = function(el, width, height, origin, scaleFactor) {
  this._el = el;
  return this.resize(width, height, origin, scaleFactor);
};

/**
 * Returns the parent container element for a visualization.
 * @return {DOMElement} - The containing DOM element.
 */
Renderer_prototype.element = function() {
  return this._el;
};

/**
 * Returns the scene element (e.g., canvas or SVG) of the visualization
 * Subclasses must override if the first child is not the scene element.
 * @return {DOMElement} - The scene (e.g., canvas or SVG) element.
 */
Renderer_prototype.canvas = function() {
  return this._el && this._el.firstChild;
};

/**
 * Get / set the background color.
 */
Renderer_prototype.background = function(bgcolor) {
  if (arguments.length === 0) return this._bgcolor;
  this._bgcolor = bgcolor;
  return this;
};

/**
 * Resize the display.
 * @param {number} width - The new coordinate width of the display, in pixels.
 * @param {number} height - The new coordinate height of the display, in pixels.
 * @param {Array<number>} origin - The new origin of the display, in pixels.
 *   The coordinate system will be translated to this point.
 * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
 *   the width and height to determine the final pixel size.
 * @return {Renderer} - This renderer instance;
 */
Renderer_prototype.resize = function(width, height, origin, scaleFactor) {
  this._width = width;
  this._height = height;
  this._origin = origin || [0, 0];
  this._scale = scaleFactor || 1;
  return this;
};

/**
 * Report a dirty item whose bounds should be redrawn.
 * This base class method does nothing. Subclasses that perform
 * incremental should implement this method.
 * @param {Item} item - The dirty item whose bounds should be redrawn.
 */
Renderer_prototype.dirty = function(/*item*/) {
};

/**
 * Render an input scenegraph, potentially with a set of dirty items.
 * This method will perform an immediate rendering with available resources.
 * The renderer may also need to perform image loading to perform a complete
 * render. This process can lead to asynchronous re-rendering of the scene
 * after this method returns. To receive notification when rendering is
 * complete, use the renderAsync method instead.
 * @param {object} scene - The root mark of a scenegraph to render.
 * @return {Renderer} - This renderer instance.
 */
Renderer_prototype.render = function(scene) {
  var r = this;

  // bind arguments into a render call, and cache it
  // this function may be subsequently called for async redraw
  r._call = function() { r._render(scene); };

  // invoke the renderer
  r._call();

  // clear the cached call for garbage collection
  // async redraws will stash their own copy
  r._call = null;

  return r;
};

/**
 * Internal rendering method. Renderer subclasses should override this
 * method to actually perform rendering.
 * @param {object} scene - The root mark of a scenegraph to render.
 */
Renderer_prototype._render = function(/*scene*/) {
  // subclasses to override
};

/**
 * Asynchronous rendering method. Similar to render, but returns a Promise
 * that resolves when all rendering is completed. Sometimes a renderer must
 * perform image loading to get a complete rendering. The returned
 * Promise will not resolve until this process completes.
 * @param {object} scene - The root mark of a scenegraph to render.
 * @return {Promise} - A Promise that resolves when rendering is complete.
 */
Renderer_prototype.renderAsync = function(scene) {
  var r = this.render(scene);
  return this._ready
    ? this._ready.then(function() { return r; })
    : Promise.resolve(r);
};

/**
 * Internal method for asynchronous resource loading.
 * Proxies method calls to the ImageLoader, and tracks loading
 * progress to invoke a re-render once complete.
 * @param {string} method - The method name to invoke on the ImageLoader.
 * @param {string} uri - The URI for the requested resource.
 * @return {Promise} - A Promise that resolves to the requested resource.
 */
Renderer_prototype._load = function(method, uri) {
  var r = this,
      p = r._loader[method](uri);

  if (!r._ready) {
    // re-render the scene when loading completes
    var call = r._call;
    r._ready = r._loader.ready()
      .then(function(redraw) {
        if (redraw) call();
        r._ready = null;
      });
  }

  return p;
};

/**
 * Sanitize a URL to include as a hyperlink in the rendered scene.
 * This method proxies a call to ImageLoader.sanitizeURL, but also tracks
 * image loading progress and invokes a re-render once complete.
 * @param {string} uri - The URI string to sanitize.
 * @return {Promise} - A Promise that resolves to the sanitized URL.
 */
Renderer_prototype.sanitizeURL = function(uri) {
  return this._load('sanitizeURL', uri);
};

/**
 * Requests an image to include in the rendered scene.
 * This method proxies a call to ImageLoader.loadImage, but also tracks
 * image loading progress and invokes a re-render once complete.
 * @param {string} uri - The URI string of the image.
 * @return {Promise} - A Promise that resolves to the loaded Image.
 */
Renderer_prototype.loadImage = function(uri) {
  return this._load('loadImage', uri);
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/events.js
const KeyDownEvent = 'keydown';
const KeyPressEvent = 'keypress';
const KeyUpEvent = 'keyup';
const DragEnterEvent = 'dragenter';
const DragLeaveEvent = 'dragleave';
const DragOverEvent = 'dragover';
const MouseDownEvent = 'mousedown';
const MouseUpEvent = 'mouseup';
const MouseMoveEvent = 'mousemove';
const MouseOutEvent = 'mouseout';
const MouseOverEvent = 'mouseover';
const ClickEvent = 'click';
const DoubleClickEvent = 'dblclick';
const WheelEvent = 'wheel';
const MouseWheelEvent = 'mousewheel';
const TouchStartEvent = 'touchstart';
const TouchMoveEvent = 'touchmove';
const TouchEndEvent = 'touchend';

const Events = [
  KeyDownEvent,
  KeyPressEvent,
  KeyUpEvent,
  DragEnterEvent,
  DragLeaveEvent,
  DragOverEvent,
  MouseDownEvent,
  MouseUpEvent,
  MouseMoveEvent,
  MouseOutEvent,
  MouseOverEvent,
  ClickEvent,
  DoubleClickEvent,
  WheelEvent,
  MouseWheelEvent,
  TouchStartEvent,
  TouchMoveEvent,
  TouchEndEvent
];

const TooltipShowEvent = MouseMoveEvent;

const TooltipHideEvent = MouseOutEvent;

const HrefEvent = ClickEvent;

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/CanvasHandler.js







function CanvasHandler(loader, tooltip) {
  Handler_Handler.call(this, loader, tooltip);
  this._down = null;
  this._touch = null;
  this._first = true;
  this._events = {};
}

const CanvasHandler_prototype = Object(vega_util["y" /* inherits */])(CanvasHandler, Handler_Handler);

CanvasHandler_prototype.initialize = function(el, origin, obj) {
  this._canvas = el && domFind(el, 'canvas');

  // add minimal events required for proper state management
  [ClickEvent, MouseDownEvent, MouseMoveEvent, MouseOutEvent, DragLeaveEvent]
    .forEach(type => eventListenerCheck(this, type));

  return Handler_Handler.prototype.initialize.call(this, el, origin, obj);
};

const eventBundle = type => (
  type === TouchStartEvent ||
  type === TouchMoveEvent ||
  type === TouchEndEvent
)
? [TouchStartEvent, TouchMoveEvent, TouchEndEvent]
: [type];

// lazily add listeners to the canvas as needed
function eventListenerCheck(handler, type) {
  eventBundle(type).forEach(_ => addEventListener(handler, _));
}

function addEventListener(handler, type) {
  const canvas = handler.canvas();
  if (canvas && !handler._events[type]) {
    handler._events[type] = 1;
    canvas.addEventListener(type, handler[type]
      ? evt => handler[type](evt)
      : evt => handler.fire(type, evt)
    );
  }
}

// return the backing canvas instance
CanvasHandler_prototype.canvas = function() {
  return this._canvas;
};

// retrieve the current canvas context
CanvasHandler_prototype.context = function() {
  return this._canvas.getContext('2d');
};

// supported events
CanvasHandler_prototype.events = Events;

function move(moveEvent, overEvent, outEvent) {
  return function(evt) {
    const a = this._active,
          p = this.pickEvent(evt);

    if (p === a) {
      // active item and picked item are the same
      this.fire(moveEvent, evt); // fire move
    } else {
      // active item and picked item are different
      if (!a || !a.exit) {
        // fire out for prior active item
        // suppress if active item was removed from scene
        this.fire(outEvent, evt);
      }
      this._active = p;          // set new active item
      this.fire(overEvent, evt); // fire over for new active item
      this.fire(moveEvent, evt); // fire move for new active item
    }
  };
}

function inactive(type) {
  return function(evt) {
    this.fire(type, evt);
    this._active = null;
  };
}

// to keep old versions of firefox happy
CanvasHandler_prototype.DOMMouseScroll = function(evt) {
  this.fire(MouseWheelEvent, evt);
};

CanvasHandler_prototype.mousemove = move(MouseMoveEvent, MouseOverEvent, MouseOutEvent);
CanvasHandler_prototype.dragover  = move(DragOverEvent, DragEnterEvent, DragLeaveEvent);

CanvasHandler_prototype.mouseout  = inactive(MouseOutEvent);
CanvasHandler_prototype.dragleave = inactive(DragLeaveEvent);

CanvasHandler_prototype.mousedown = function(evt) {
  this._down = this._active;
  this.fire(MouseDownEvent, evt);
};

CanvasHandler_prototype.click = function(evt) {
  if (this._down === this._active) {
    this.fire(ClickEvent, evt);
    this._down = null;
  }
};

CanvasHandler_prototype.touchstart = function(evt) {
  this._touch = this.pickEvent(evt.changedTouches[0]);

  if (this._first) {
    this._active = this._touch;
    this._first = false;
  }

  this.fire(TouchStartEvent, evt, true);
};

CanvasHandler_prototype.touchmove = function(evt) {
  this.fire(TouchMoveEvent, evt, true);
};

CanvasHandler_prototype.touchend = function(evt) {
  this.fire(TouchEndEvent, evt, true);
  this._touch = null;
};

// fire an event
CanvasHandler_prototype.fire = function(type, evt, touch) {
  const a = touch ? this._touch : this._active,
        h = this._handlers[type];

  // set event type relative to scenegraph items
  evt.vegaType = type;

  // handle hyperlinks and tooltips first
  if (type === HrefEvent && a && a.href) {
    this.handleHref(evt, a, a.href);
  } else if (type === TooltipShowEvent || type === TooltipHideEvent) {
    this.handleTooltip(evt, a, type !== TooltipHideEvent);
  }

  // invoke all registered handlers
  if (h) {
    for (let i=0, len=h.length; i<len; ++i) {
      h[i].handler.call(this._obj, evt, a);
    }
  }
};

// add an event handler
CanvasHandler_prototype.on = function(type, handler) {
  const name = this.eventName(type),
        h = this._handlers,
        i = this._handlerIndex(h[name], type, handler);

  if (i < 0) {
    eventListenerCheck(this, type);
    (h[name] || (h[name] = [])).push({
      type:    type,
      handler: handler
    });
  }

  return this;
};

// remove an event handler
CanvasHandler_prototype.off = function(type, handler) {
  const name = this.eventName(type),
        h = this._handlers[name],
        i = this._handlerIndex(h, type, handler);

  if (i >= 0) {
    h.splice(i, 1);
  }

  return this;
};

CanvasHandler_prototype.pickEvent = function(evt) {
  const p = util_point(evt, this._canvas),
        o = this._origin;
  return this.pick(this._scene, p[0], p[1], p[0] - o[0], p[1] - o[1]);
};

// find the scenegraph item at the current mouse position
// x, y -- the absolute x, y mouse coordinates on the canvas element
// gx, gy -- the relative coordinates within the current group
CanvasHandler_prototype.pick = function(scene, x, y, gx, gy) {
  const g = this.context(),
        mark = src_marks[scene.marktype];
  return mark.pick.call(this, g, scene, x, y, gx, gy);
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/canvas/resize.js
function devicePixelRatio() {
  return typeof window !== 'undefined' ? window.devicePixelRatio || 1 : 1;
}

var pixelRatio = devicePixelRatio();

/* harmony default export */ var resize = (function(canvas, width, height, origin, scaleFactor, opt) {
  const inDOM = typeof HTMLElement !== 'undefined'
              && canvas instanceof HTMLElement
              && canvas.parentNode != null,
        context = canvas.getContext('2d'),
        ratio = inDOM ? pixelRatio : scaleFactor;

  canvas.width = width * ratio;
  canvas.height = height * ratio;

  for (const key in opt) {
    context[key] = opt[key];
  }

  if (inDOM && ratio !== 1) {
    canvas.style.width = width + 'px';
    canvas.style.height = height + 'px';
  }

  context.pixelRatio = ratio;
  context.setTransform(
    ratio, 0, 0, ratio,
    ratio * origin[0],
    ratio * origin[1]
  );

  return canvas;
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/CanvasRenderer.js










function CanvasRenderer(loader) {
  Renderer_Renderer.call(this, loader);
  this._options = {};
  this._redraw = false;
  this._dirty = new Bounds();
  this._tempb = new Bounds();
}

const CanvasRenderer_prototype = Object(vega_util["y" /* inherits */])(CanvasRenderer, Renderer_Renderer),
      CanvasRenderer_base = Renderer_Renderer.prototype;

CanvasRenderer_prototype.initialize = function(el, width, height, origin, scaleFactor, options) {
  this._options = options || {};

  this._canvas = this._options.externalContext
    ? null
    : domCanvas(1, 1, this._options.type); // instantiate a small canvas

  if (el && this._canvas) {
    domClear(el, 0).appendChild(this._canvas);
    this._canvas.setAttribute('class', 'marks');
  }

  // this method will invoke resize to size the canvas appropriately
  return CanvasRenderer_base.initialize.call(this, el, width, height, origin, scaleFactor);
};

CanvasRenderer_prototype.resize = function(width, height, origin, scaleFactor) {
  CanvasRenderer_base.resize.call(this, width, height, origin, scaleFactor);

  if (this._canvas) {
    // configure canvas size and transform
    resize(this._canvas, this._width, this._height,
      this._origin, this._scale, this._options.context);
  } else {
    // external context needs to be scaled and positioned to origin
    const ctx = this._options.externalContext;
    if (!ctx) Object(vega_util["n" /* error */])('CanvasRenderer is missing a valid canvas or context');
    ctx.scale(this._scale, this._scale);
    ctx.translate(this._origin[0], this._origin[1]);
  }

  this._redraw = true;
  return this;
};

CanvasRenderer_prototype.canvas = function() {
  return this._canvas;
};

CanvasRenderer_prototype.context = function() {
  return this._options.externalContext
    || (this._canvas ? this._canvas.getContext('2d') : null);
};

CanvasRenderer_prototype.dirty = function(item) {
  let b = this._tempb.clear().union(item.bounds),
      g = item.mark.group;

  while (g) {
    b.translate(g.x || 0, g.y || 0);
    g = g.mark.group;
  }

  this._dirty.union(b);
};

function clipToBounds(g, b, origin) {
  // expand bounds by 1 pixel, then round to pixel boundaries
  b.expand(1).round();

  // align to base pixel grid in case of non-integer scaling (#2425)
  if (g.pixelRatio % 1) {
    b.scale(g.pixelRatio).round().scale(1 / g.pixelRatio);
  }

  // to avoid artifacts translate if origin has fractional pixels
  b.translate(-(origin[0] % 1), -(origin[1] % 1));

  // set clip path
  g.beginPath();
  g.rect(b.x1, b.y1, b.width(), b.height());
  g.clip();

  return b;
}

const CanvasRenderer_viewBounds = (origin, width, height) => new Bounds()
  .set(0, 0, width, height)
  .translate(-origin[0], -origin[1]);

CanvasRenderer_prototype._render = function(scene) {
  const g = this.context(),
        o = this._origin,
        w = this._width,
        h = this._height,
        db = this._dirty,
        vb = CanvasRenderer_viewBounds(o, w, h);

  // setup
  g.save();
  const b = this._redraw || db.empty()
    ? (this._redraw = false, vb.expand(1))
    : clipToBounds(g, vb.intersect(db), o);

  this.clear(-o[0], -o[1], w, h);

  // render
  this.draw(g, scene, b);

  // takedown
  g.restore();
  db.clear();

  return this;
};

CanvasRenderer_prototype.draw = function(ctx, scene, bounds) {
  const mark = src_marks[scene.marktype];
  if (scene.clip) canvas_clip(ctx, scene);
  mark.draw.call(this, ctx, scene, bounds);
  if (scene.clip) ctx.restore();
};

CanvasRenderer_prototype.clear = function(x, y, w, h) {
  const opt = this._options,
         g = this.context();

  if (opt.type !== 'pdf' && !opt.externalContext) {
    // calling clear rect voids vector output in pdf mode
    // and could remove external context content (#2615)
    g.clearRect(x, y, w, h);
  }

  if (this._bgcolor != null) {
    g.fillStyle = this._bgcolor;
    g.fillRect(x, y, w, h);
  }
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/SVGHandler.js





function SVGHandler(loader, tooltip) {
  Handler_Handler.call(this, loader, tooltip);
  const h = this;
  h._hrefHandler = listener(h, (evt, item) => {
    if (item && item.href) h.handleHref(evt, item, item.href);
  });
  h._tooltipHandler = listener(h, (evt, item) => {
    h.handleTooltip(evt, item, evt.type !== TooltipHideEvent);
  });
}

const SVGHandler_prototype = Object(vega_util["y" /* inherits */])(SVGHandler, Handler_Handler);

SVGHandler_prototype.initialize = function(el, origin, obj) {
  let svg = this._svg;
  if (svg) {
    svg.removeEventListener(HrefEvent, this._hrefHandler);
    svg.removeEventListener(TooltipShowEvent, this._tooltipHandler);
    svg.removeEventListener(TooltipHideEvent, this._tooltipHandler);
  }
  this._svg = svg = el && domFind(el, 'svg');
  if (svg) {
    svg.addEventListener(HrefEvent, this._hrefHandler);
    svg.addEventListener(TooltipShowEvent, this._tooltipHandler);
    svg.addEventListener(TooltipHideEvent, this._tooltipHandler);
  }
  return Handler_Handler.prototype.initialize.call(this, el, origin, obj);
};

SVGHandler_prototype.canvas = function() {
  return this._svg;
};

// wrap an event listener for the SVG DOM
const listener = (context, handler) => evt => {
  let item = evt.target.__data__;
  item = Array.isArray(item) ? item[0] : item;
  evt.vegaType = evt.type;
  handler.call(context._obj, evt, item);
};

// add an event handler
SVGHandler_prototype.on = function(type, handler) {
  const name = this.eventName(type),
        h = this._handlers,
        i = this._handlerIndex(h[name], type, handler);

  if (i < 0) {
    const x = {
      type,
      handler,
      listener: listener(this, handler)
    };

    (h[name] || (h[name] = [])).push(x);
    if (this._svg) {
      this._svg.addEventListener(name, x.listener);
    }
  }

  return this;
};

// remove an event handler
SVGHandler_prototype.off = function(type, handler) {
  const name = this.eventName(type),
        h = this._handlers[name],
        i = this._handlerIndex(h, type, handler);

  if (i >= 0) {
    if (this._svg) {
      this._svg.removeEventListener(name, h[i].listener);
    }
    h.splice(i, 1);
  }

  return this;
};

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/bandSpace.js
/* harmony default export */ var bandSpace = (function(count, paddingInner, paddingOuter) {
  var space = count - paddingInner + paddingOuter * 2;
  return count ? (space > 0 ? space : 1) : 0;
});

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/types.js
const Identity = 'identity';

const types_Linear = 'linear';
const Log = 'log';
const Pow = 'pow';
const Sqrt = 'sqrt';
const Symlog = 'symlog';

const Time = 'time';
const UTC = 'utc';

const Sequential = 'sequential';
const Diverging = 'diverging';

const types_Quantile = 'quantile';
const Quantize = 'quantize';
const Threshold = 'threshold';

const Ordinal = 'ordinal';
const Point = 'point';
const Band = 'band';
const BinOrdinal = 'bin-ordinal';

// categories
const Continuous = 'continuous';
const Discrete = 'discrete';
const Discretizing = 'discretizing';
const Interpolating = 'interpolating';
const Temporal = 'temporal';

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/invertRange.js
/* harmony default export */ var invertRange = (function(scale) {
  return function(_) {
    var lo = _[0],
        hi = _[1],
        t;

    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }

    return [
      scale.invert(lo),
      scale.invert(hi)
    ];
  };
});

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/invertRangeExtent.js
/* harmony default export */ var invertRangeExtent = (function(scale) {
  return function(_) {
    var range = scale.range(),
        lo = _[0],
        hi = _[1],
        min = -1, max, t, i, n;

    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }

    for (i=0, n=range.length; i<n; ++i) {
      if (range[i] >= lo && range[i] <= hi) {
        if (min < 0) min = i;
        max = i;
      }
    }

    if (min < 0) return undefined;

    lo = scale.invertExtent(range[min]);
    hi = scale.invertExtent(range[max]);

    return [
      lo[0] === undefined ? lo[1] : lo[0],
      hi[1] === undefined ? hi[0] : hi[1]
    ];
  };
});

// CONCATENATED MODULE: ./node_modules/d3-array/src/bisect.js



var ascendingBisect = bisector(ascending);
var bisectRight = ascendingBisect.right;
var bisectLeft = ascendingBisect.left;
/* harmony default export */ var d3_array_src_bisect = (bisectRight);

// CONCATENATED MODULE: ./node_modules/d3-scale/src/init.js
function initRange(domain, range) {
  switch (arguments.length) {
    case 0: break;
    case 1: this.range(domain); break;
    default: this.range(range).domain(domain); break;
  }
  return this;
}

function initInterpolator(domain, interpolator) {
  switch (arguments.length) {
    case 0: break;
    case 1: {
      if (typeof domain === "function") this.interpolator(domain);
      else this.range(domain);
      break;
    }
    default: {
      this.domain(domain);
      if (typeof interpolator === "function") this.interpolator(interpolator);
      else this.range(interpolator);
      break;
    }
  }
  return this;
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/ordinal.js


const implicit = Symbol("implicit");

function ordinal() {
  var index = new Map(),
      domain = [],
      range = [],
      unknown = implicit;

  function scale(d) {
    var key = d + "", i = index.get(key);
    if (!i) {
      if (unknown !== implicit) return unknown;
      index.set(key, i = domain.push(d));
    }
    return range[(i - 1) % range.length];
  }

  scale.domain = function(_) {
    if (!arguments.length) return domain.slice();
    domain = [], index = new Map();
    for (const value of _) {
      const key = value + "";
      if (index.has(key)) continue;
      index.set(key, domain.push(value));
    }
    return scale;
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), scale) : range.slice();
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  scale.copy = function() {
    return ordinal(domain, range).unknown(unknown);
  };

  initRange.apply(scale, arguments);

  return scale;
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/scaleBand.js




function scaleBand_band() {
  var scale = ordinal().unknown(undefined),
      domain = scale.domain,
      ordinalRange = scale.range,
      range = [0, 1],
      step,
      bandwidth,
      round = false,
      paddingInner = 0,
      paddingOuter = 0,
      align = 0.5;

  delete scale.unknown;

  function rescale() {
    var n = domain().length,
        reverse = range[1] < range[0],
        start = range[reverse - 0],
        stop = range[1 - reverse],
        space = bandSpace(n, paddingInner, paddingOuter);

    step = (stop - start) / (space || 1);
    if (round) {
      step = Math.floor(step);
    }
    start += (stop - start - step * (n - paddingInner)) * align;
    bandwidth = step * (1 - paddingInner);
    if (round) {
      start = Math.round(start);
      bandwidth = Math.round(bandwidth);
    }
    var values = src_range(n).map(function(i) { return start + step * i; });
    return ordinalRange(reverse ? values.reverse() : values);
  }

  scale.domain = function(_) {
    if (arguments.length) {
      domain(_);
      return rescale();
    } else {
      return domain();
    }
  };

  scale.range = function(_) {
    if (arguments.length) {
      range = [+_[0], +_[1]];
      return rescale();
    } else {
      return range.slice();
    }
  };

  scale.rangeRound = function(_) {
    range = [+_[0], +_[1]];
    round = true;
    return rescale();
  };

  scale.bandwidth = function() {
    return bandwidth;
  };

  scale.step = function() {
    return step;
  };

  scale.round = function(_) {
    if (arguments.length) {
      round = !!_;
      return rescale();
    } else {
      return round;
    }
  };

  scale.padding = function(_) {
    if (arguments.length) {
      paddingOuter = Math.max(0, Math.min(1, _));
      paddingInner = paddingOuter;
      return rescale();
    } else {
      return paddingInner;
    }
  };

  scale.paddingInner = function(_) {
    if (arguments.length) {
      paddingInner = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return paddingInner;
    }
  };

  scale.paddingOuter = function(_) {
    if (arguments.length) {
      paddingOuter = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return paddingOuter;
    }
  };

  scale.align = function(_) {
    if (arguments.length) {
      align = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return align;
    }
  };

  scale.invertRange = function(_) {
    // bail if range has null or undefined values
    if (_[0] == null || _[1] == null) return;

    var lo = +_[0],
        hi = +_[1],
        reverse = range[1] < range[0],
        values = reverse ? ordinalRange().reverse() : ordinalRange(),
        n = values.length - 1, a, b, t;

    // bail if either range endpoint is invalid
    if (lo !== lo || hi !== hi) return;

    // order range inputs, bail if outside of scale range
    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }
    if (hi < values[0] || lo > range[1-reverse]) return;

    // binary search to index into scale range
    a = Math.max(0, bisectRight(values, lo) - 1);
    b = lo===hi ? a : bisectRight(values, hi) - 1;

    // increment index a if lo is within padding gap
    if (lo - values[a] > bandwidth + 1e-10) ++a;

    if (reverse) {
      // map + swap
      t = a;
      a = n - b;
      b = n - t;
    }
    return (a > b) ? undefined : domain().slice(a, b+1);
  };

  scale.invert = function(_) {
    var value = scale.invertRange([_, _]);
    return value ? value[0] : value;
  };

  scale.copy = function() {
    return scaleBand_band()
        .domain(domain())
        .range(range)
        .round(round)
        .paddingInner(paddingInner)
        .paddingOuter(paddingOuter)
        .align(align);
  };

  return rescale();
}

function pointish(scale) {
  var copy = scale.copy;

  scale.padding = scale.paddingOuter;
  delete scale.paddingInner;

  scale.copy = function() {
    return pointish(copy());
  };

  return scale;
}

function scaleBand_point() {
  return pointish(scaleBand_band().paddingInner(1));
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/tickFormat.js



/* harmony default export */ var src_tickFormat = (function(start, stop, count, specifier) {
  var step = tickStep(start, stop, count),
      precision;
  specifier = formatSpecifier(specifier == null ? ",f" : specifier);
  switch (specifier.type) {
    case "s": {
      var value = Math.max(Math.abs(start), Math.abs(stop));
      if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value))) specifier.precision = precision;
      return defaultLocale_formatPrefix(specifier, value);
    }
    case "":
    case "e":
    case "g":
    case "p":
    case "r": {
      if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start), Math.abs(stop))))) specifier.precision = precision - (specifier.type === "e");
      break;
    }
    case "f":
    case "%": {
      if (specifier.precision == null && !isNaN(precision = precisionFixed(step))) specifier.precision = precision - (specifier.type === "%") * 2;
      break;
    }
  }
  return defaultLocale_format(specifier);
});

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/numbers.js
var numbers_map = Array.prototype.map;

function numbers_numbers(_) {
  return numbers_map.call(_, function(x) { return +x; });
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/slice.js
var slice = Array.prototype.slice;

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales/scaleBinOrdinal.js






function scaleBinOrdinal() {
  var domain = [],
      range = [];

  function scale(x) {
    return x == null || x !== x
      ? undefined
      : range[(d3_array_src_bisect(domain, x) - 1) % range.length];
  }

  scale.domain = function(_) {
    if (arguments.length) {
      domain = numbers_numbers(_);
      return scale;
    } else {
      return domain.slice();
    }
  };

  scale.range = function(_) {
    if (arguments.length) {
      range = slice.call(_);
      return scale;
    } else {
      return range.slice();
    }
  };

  scale.tickFormat = function(count, specifier) {
    return src_tickFormat(domain[0], Object(vega_util["U" /* peek */])(domain), count == null ? 10 : count, specifier);
  };

  scale.copy = function() {
    return scaleBinOrdinal().domain(scale.domain()).range(scale.range());
  };

  return scale;
}
// CONCATENATED MODULE: ./node_modules/d3-color/src/define.js
/* harmony default export */ var define = (function(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
});

function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition) prototype[key] = definition[key];
  return prototype;
}

// CONCATENATED MODULE: ./node_modules/d3-color/src/color.js


function Color() {}

var darker = 0.7;
var brighter = 1 / darker;

var reI = "\\s*([+-]?\\d+)\\s*",
    reN = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",
    reP = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
    reHex = /^#([0-9a-f]{3,8})$/,
    reRgbInteger = new RegExp("^rgb\\(" + [reI, reI, reI] + "\\)$"),
    reRgbPercent = new RegExp("^rgb\\(" + [reP, reP, reP] + "\\)$"),
    reRgbaInteger = new RegExp("^rgba\\(" + [reI, reI, reI, reN] + "\\)$"),
    reRgbaPercent = new RegExp("^rgba\\(" + [reP, reP, reP, reN] + "\\)$"),
    reHslPercent = new RegExp("^hsl\\(" + [reN, reP, reP] + "\\)$"),
    reHslaPercent = new RegExp("^hsla\\(" + [reN, reP, reP, reN] + "\\)$");

var named = {
  aliceblue: 0xf0f8ff,
  antiquewhite: 0xfaebd7,
  aqua: 0x00ffff,
  aquamarine: 0x7fffd4,
  azure: 0xf0ffff,
  beige: 0xf5f5dc,
  bisque: 0xffe4c4,
  black: 0x000000,
  blanchedalmond: 0xffebcd,
  blue: 0x0000ff,
  blueviolet: 0x8a2be2,
  brown: 0xa52a2a,
  burlywood: 0xdeb887,
  cadetblue: 0x5f9ea0,
  chartreuse: 0x7fff00,
  chocolate: 0xd2691e,
  coral: 0xff7f50,
  cornflowerblue: 0x6495ed,
  cornsilk: 0xfff8dc,
  crimson: 0xdc143c,
  cyan: 0x00ffff,
  darkblue: 0x00008b,
  darkcyan: 0x008b8b,
  darkgoldenrod: 0xb8860b,
  darkgray: 0xa9a9a9,
  darkgreen: 0x006400,
  darkgrey: 0xa9a9a9,
  darkkhaki: 0xbdb76b,
  darkmagenta: 0x8b008b,
  darkolivegreen: 0x556b2f,
  darkorange: 0xff8c00,
  darkorchid: 0x9932cc,
  darkred: 0x8b0000,
  darksalmon: 0xe9967a,
  darkseagreen: 0x8fbc8f,
  darkslateblue: 0x483d8b,
  darkslategray: 0x2f4f4f,
  darkslategrey: 0x2f4f4f,
  darkturquoise: 0x00ced1,
  darkviolet: 0x9400d3,
  deeppink: 0xff1493,
  deepskyblue: 0x00bfff,
  dimgray: 0x696969,
  dimgrey: 0x696969,
  dodgerblue: 0x1e90ff,
  firebrick: 0xb22222,
  floralwhite: 0xfffaf0,
  forestgreen: 0x228b22,
  fuchsia: 0xff00ff,
  gainsboro: 0xdcdcdc,
  ghostwhite: 0xf8f8ff,
  gold: 0xffd700,
  goldenrod: 0xdaa520,
  gray: 0x808080,
  green: 0x008000,
  greenyellow: 0xadff2f,
  grey: 0x808080,
  honeydew: 0xf0fff0,
  hotpink: 0xff69b4,
  indianred: 0xcd5c5c,
  indigo: 0x4b0082,
  ivory: 0xfffff0,
  khaki: 0xf0e68c,
  lavender: 0xe6e6fa,
  lavenderblush: 0xfff0f5,
  lawngreen: 0x7cfc00,
  lemonchiffon: 0xfffacd,
  lightblue: 0xadd8e6,
  lightcoral: 0xf08080,
  lightcyan: 0xe0ffff,
  lightgoldenrodyellow: 0xfafad2,
  lightgray: 0xd3d3d3,
  lightgreen: 0x90ee90,
  lightgrey: 0xd3d3d3,
  lightpink: 0xffb6c1,
  lightsalmon: 0xffa07a,
  lightseagreen: 0x20b2aa,
  lightskyblue: 0x87cefa,
  lightslategray: 0x778899,
  lightslategrey: 0x778899,
  lightsteelblue: 0xb0c4de,
  lightyellow: 0xffffe0,
  lime: 0x00ff00,
  limegreen: 0x32cd32,
  linen: 0xfaf0e6,
  magenta: 0xff00ff,
  maroon: 0x800000,
  mediumaquamarine: 0x66cdaa,
  mediumblue: 0x0000cd,
  mediumorchid: 0xba55d3,
  mediumpurple: 0x9370db,
  mediumseagreen: 0x3cb371,
  mediumslateblue: 0x7b68ee,
  mediumspringgreen: 0x00fa9a,
  mediumturquoise: 0x48d1cc,
  mediumvioletred: 0xc71585,
  midnightblue: 0x191970,
  mintcream: 0xf5fffa,
  mistyrose: 0xffe4e1,
  moccasin: 0xffe4b5,
  navajowhite: 0xffdead,
  navy: 0x000080,
  oldlace: 0xfdf5e6,
  olive: 0x808000,
  olivedrab: 0x6b8e23,
  orange: 0xffa500,
  orangered: 0xff4500,
  orchid: 0xda70d6,
  palegoldenrod: 0xeee8aa,
  palegreen: 0x98fb98,
  paleturquoise: 0xafeeee,
  palevioletred: 0xdb7093,
  papayawhip: 0xffefd5,
  peachpuff: 0xffdab9,
  peru: 0xcd853f,
  pink: 0xffc0cb,
  plum: 0xdda0dd,
  powderblue: 0xb0e0e6,
  purple: 0x800080,
  rebeccapurple: 0x663399,
  red: 0xff0000,
  rosybrown: 0xbc8f8f,
  royalblue: 0x4169e1,
  saddlebrown: 0x8b4513,
  salmon: 0xfa8072,
  sandybrown: 0xf4a460,
  seagreen: 0x2e8b57,
  seashell: 0xfff5ee,
  sienna: 0xa0522d,
  silver: 0xc0c0c0,
  skyblue: 0x87ceeb,
  slateblue: 0x6a5acd,
  slategray: 0x708090,
  slategrey: 0x708090,
  snow: 0xfffafa,
  springgreen: 0x00ff7f,
  steelblue: 0x4682b4,
  tan: 0xd2b48c,
  teal: 0x008080,
  thistle: 0xd8bfd8,
  tomato: 0xff6347,
  turquoise: 0x40e0d0,
  violet: 0xee82ee,
  wheat: 0xf5deb3,
  white: 0xffffff,
  whitesmoke: 0xf5f5f5,
  yellow: 0xffff00,
  yellowgreen: 0x9acd32
};

define(Color, color_color, {
  copy: function(channels) {
    return Object.assign(new this.constructor, this, channels);
  },
  displayable: function() {
    return this.rgb().displayable();
  },
  hex: color_formatHex, // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});

function color_formatHex() {
  return this.rgb().formatHex();
}

function color_formatHsl() {
  return hslConvert(this).formatHsl();
}

function color_formatRgb() {
  return this.rgb().formatRgb();
}

function color_color(format) {
  var m, l;
  format = (format + "").trim().toLowerCase();
  return (m = reHex.exec(format)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) // #ff0000
      : l === 3 ? new Rgb((m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), ((m & 0xf) << 4) | (m & 0xf), 1) // #f00
      : l === 8 ? rgba(m >> 24 & 0xff, m >> 16 & 0xff, m >> 8 & 0xff, (m & 0xff) / 0xff) // #ff000000
      : l === 4 ? rgba((m >> 12 & 0xf) | (m >> 8 & 0xf0), (m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), (((m & 0xf) << 4) | (m & 0xf)) / 0xff) // #f000
      : null) // invalid hex
      : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) // rgb(255, 0, 0)
      : (m = reRgbPercent.exec(format)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) // rgb(100%, 0%, 0%)
      : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) // rgba(255, 0, 0, 1)
      : (m = reRgbaPercent.exec(format)) ? rgba(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) // rgb(100%, 0%, 0%, 1)
      : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) // hsl(120, 50%, 50%)
      : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) // hsla(120, 50%, 50%, 1)
      : named.hasOwnProperty(format) ? rgbn(named[format]) // eslint-disable-line no-prototype-builtins
      : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0)
      : null;
}

function rgbn(n) {
  return new Rgb(n >> 16 & 0xff, n >> 8 & 0xff, n & 0xff, 1);
}

function rgba(r, g, b, a) {
  if (a <= 0) r = g = b = NaN;
  return new Rgb(r, g, b, a);
}

function rgbConvert(o) {
  if (!(o instanceof Color)) o = color_color(o);
  if (!o) return new Rgb;
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}

function color_rgb(r, g, b, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}

function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}

define(Rgb, color_rgb, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb: function() {
    return this;
  },
  displayable: function() {
    return (-0.5 <= this.r && this.r < 255.5)
        && (-0.5 <= this.g && this.g < 255.5)
        && (-0.5 <= this.b && this.b < 255.5)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex, // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));

function rgb_formatHex() {
  return "#" + hex(this.r) + hex(this.g) + hex(this.b);
}

function rgb_formatRgb() {
  var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
  return (a === 1 ? "rgb(" : "rgba(")
      + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.b) || 0))
      + (a === 1 ? ")" : ", " + a + ")");
}

function hex(value) {
  value = Math.max(0, Math.min(255, Math.round(value) || 0));
  return (value < 16 ? "0" : "") + value.toString(16);
}

function hsla(h, s, l, a) {
  if (a <= 0) h = s = l = NaN;
  else if (l <= 0 || l >= 1) h = s = NaN;
  else if (s <= 0) h = NaN;
  return new Hsl(h, s, l, a);
}

function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color_color(o);
  if (!o) return new Hsl;
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r = o.r / 255,
      g = o.g / 255,
      b = o.b / 255,
      min = Math.min(r, g, b),
      max = Math.max(r, g, b),
      h = NaN,
      s = max - min,
      l = (max + min) / 2;
  if (s) {
    if (r === max) h = (g - b) / s + (g < b) * 6;
    else if (g === max) h = (b - r) / s + 2;
    else h = (r - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h;
  }
  return new Hsl(h, s, l, o.opacity);
}

function hsl(h, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
}

function Hsl(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

define(Hsl, hsl, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb: function() {
    var h = this.h % 360 + (this.h < 0) * 360,
        s = isNaN(h) || isNaN(this.s) ? 0 : this.s,
        l = this.l,
        m2 = l + (l < 0.5 ? l : 1 - l) * s,
        m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
      hsl2rgb(h, m1, m2),
      hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
      this.opacity
    );
  },
  displayable: function() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s))
        && (0 <= this.l && this.l <= 1)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl: function() {
    var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
    return (a === 1 ? "hsl(" : "hsla(")
        + (this.h || 0) + ", "
        + (this.s || 0) * 100 + "%, "
        + (this.l || 0) * 100 + "%"
        + (a === 1 ? ")" : ", " + a + ")");
  }
}));

/* From FvD 13.37, CSS Color Module Level 3 */
function hsl2rgb(h, m1, m2) {
  return (h < 60 ? m1 + (m2 - m1) * h / 60
      : h < 180 ? m2
      : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60
      : m1) * 255;
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/basis.js
function basis_basis(t1, v0, v1, v2, v3) {
  var t2 = t1 * t1, t3 = t2 * t1;
  return ((1 - 3 * t1 + 3 * t2 - t3) * v0
      + (4 - 6 * t2 + 3 * t3) * v1
      + (1 + 3 * t1 + 3 * t2 - 3 * t3) * v2
      + t3 * v3) / 6;
}

/* harmony default export */ var src_basis = (function(values) {
  var n = values.length - 1;
  return function(t) {
    var i = t <= 0 ? (t = 0) : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n),
        v1 = values[i],
        v2 = values[i + 1],
        v0 = i > 0 ? values[i - 1] : 2 * v1 - v2,
        v3 = i < n - 1 ? values[i + 2] : 2 * v2 - v1;
    return basis_basis((t - i / n) * n, v0, v1, v2, v3);
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/basisClosed.js


/* harmony default export */ var src_basisClosed = (function(values) {
  var n = values.length;
  return function(t) {
    var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n),
        v0 = values[(i + n - 1) % n],
        v1 = values[i % n],
        v2 = values[(i + 1) % n],
        v3 = values[(i + 2) % n];
    return basis_basis((t - i / n) * n, v0, v1, v2, v3);
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/constant.js
/* harmony default export */ var d3_interpolate_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/color.js


function color_linear(a, d) {
  return function(t) {
    return a + t * d;
  };
}

function exponential(a, b, y) {
  return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {
    return Math.pow(a + t * b, y);
  };
}

function color_hue(a, b) {
  var d = b - a;
  return d ? color_linear(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : d3_interpolate_src_constant(isNaN(a) ? b : a);
}

function color_gamma(y) {
  return (y = +y) === 1 ? nogamma : function(a, b) {
    return b - a ? exponential(a, b, y) : d3_interpolate_src_constant(isNaN(a) ? b : a);
  };
}

function nogamma(a, b) {
  var d = b - a;
  return d ? color_linear(a, d) : d3_interpolate_src_constant(isNaN(a) ? b : a);
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/rgb.js





/* harmony default export */ var src_rgb = ((function rgbGamma(y) {
  var color = color_gamma(y);

  function rgb(start, end) {
    var r = color((start = color_rgb(start)).r, (end = color_rgb(end)).r),
        g = color(start.g, end.g),
        b = color(start.b, end.b),
        opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.r = r(t);
      start.g = g(t);
      start.b = b(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }

  rgb.gamma = rgbGamma;

  return rgb;
})(1));

function rgbSpline(spline) {
  return function(colors) {
    var n = colors.length,
        r = new Array(n),
        g = new Array(n),
        b = new Array(n),
        i, color;
    for (i = 0; i < n; ++i) {
      color = color_rgb(colors[i]);
      r[i] = color.r || 0;
      g[i] = color.g || 0;
      b[i] = color.b || 0;
    }
    r = spline(r);
    g = spline(g);
    b = spline(b);
    color.opacity = 1;
    return function(t) {
      color.r = r(t);
      color.g = g(t);
      color.b = b(t);
      return color + "";
    };
  };
}

var rgbBasis = rgbSpline(src_basis);
var rgbBasisClosed = rgbSpline(src_basisClosed);

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/numberArray.js
/* harmony default export */ var numberArray = (function(a, b) {
  if (!b) b = [];
  var n = a ? Math.min(b.length, a.length) : 0,
      c = b.slice(),
      i;
  return function(t) {
    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t) + b[i] * t;
    return c;
  };
});

function isNumberArray(x) {
  return ArrayBuffer.isView(x) && !(x instanceof DataView);
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/array.js



/* harmony default export */ var src_array = (function(a, b) {
  return (isNumberArray(b) ? numberArray : genericArray)(a, b);
});

function genericArray(a, b) {
  var nb = b ? b.length : 0,
      na = a ? Math.min(nb, a.length) : 0,
      x = new Array(na),
      c = new Array(nb),
      i;

  for (i = 0; i < na; ++i) x[i] = src_value(a[i], b[i]);
  for (; i < nb; ++i) c[i] = b[i];

  return function(t) {
    for (i = 0; i < na; ++i) c[i] = x[i](t);
    return c;
  };
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/date.js
/* harmony default export */ var src_date = (function(a, b) {
  var d = new Date;
  return a = +a, b = +b, function(t) {
    return d.setTime(a * (1 - t) + b * t), d;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/number.js
/* harmony default export */ var d3_interpolate_src_number = (function(a, b) {
  return a = +a, b = +b, function(t) {
    return a * (1 - t) + b * t;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/object.js


/* harmony default export */ var src_object = (function(a, b) {
  var i = {},
      c = {},
      k;

  if (a === null || typeof a !== "object") a = {};
  if (b === null || typeof b !== "object") b = {};

  for (k in b) {
    if (k in a) {
      i[k] = src_value(a[k], b[k]);
    } else {
      c[k] = b[k];
    }
  }

  return function(t) {
    for (k in i) c[k] = i[k](t);
    return c;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/string.js


var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
    reB = new RegExp(reA.source, "g");

function string_zero(b) {
  return function() {
    return b;
  };
}

function one(b) {
  return function(t) {
    return b(t) + "";
  };
}

/* harmony default export */ var src_string = (function(a, b) {
  var bi = reA.lastIndex = reB.lastIndex = 0, // scan index for next number in b
      am, // current match in a
      bm, // current match in b
      bs, // string preceding current number in b, if any
      i = -1, // index in s
      s = [], // string constants and placeholders
      q = []; // number interpolators

  // Coerce inputs to strings.
  a = a + "", b = b + "";

  // Interpolate pairs of numbers in a & b.
  while ((am = reA.exec(a))
      && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) { // a string precedes the next number in b
      bs = b.slice(bi, bs);
      if (s[i]) s[i] += bs; // coalesce with previous string
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) { // numbers in a & b match
      if (s[i]) s[i] += bm; // coalesce with previous string
      else s[++i] = bm;
    } else { // interpolate non-matching numbers
      s[++i] = null;
      q.push({i: i, x: d3_interpolate_src_number(am, bm)});
    }
    bi = reB.lastIndex;
  }

  // Add remains of b.
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s[i]) s[i] += bs; // coalesce with previous string
    else s[++i] = bs;
  }

  // Special optimization for only a single match.
  // Otherwise, interpolate each of the numbers and rejoin the string.
  return s.length < 2 ? (q[0]
      ? one(q[0].x)
      : string_zero(b))
      : (b = q.length, function(t) {
          for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
          return s.join("");
        });
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/value.js










/* harmony default export */ var src_value = (function(a, b) {
  var t = typeof b, c;
  return b == null || t === "boolean" ? d3_interpolate_src_constant(b)
      : (t === "number" ? d3_interpolate_src_number
      : t === "string" ? ((c = color_color(b)) ? (b = c, src_rgb) : src_string)
      : b instanceof color_color ? src_rgb
      : b instanceof Date ? src_date
      : isNumberArray(b) ? numberArray
      : Array.isArray(b) ? genericArray
      : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? src_object
      : d3_interpolate_src_number)(a, b);
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/round.js
/* harmony default export */ var src_round = (function(a, b) {
  return a = +a, b = +b, function(t) {
    return Math.round(a * (1 - t) + b * t);
  };
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/constant.js
/* harmony default export */ var d3_scale_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/number.js
/* harmony default export */ var d3_scale_src_number = (function(x) {
  return +x;
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/continuous.js





var continuous_unit = [0, 1];

function continuous_identity(x) {
  return x;
}

function continuous_normalize(a, b) {
  return (b -= (a = +a))
      ? function(x) { return (x - a) / b; }
      : d3_scale_src_constant(isNaN(b) ? NaN : 0.5);
}

function clamper(a, b) {
  var t;
  if (a > b) t = a, a = b, b = t;
  return function(x) { return Math.max(a, Math.min(b, x)); };
}

// normalize(a, b)(x) takes a domain value x in [a,b] and returns the corresponding parameter t in [0,1].
// interpolate(a, b)(t) takes a parameter t in [0,1] and returns the corresponding range value x in [a,b].
function bimap(domain, range, interpolate) {
  var d0 = domain[0], d1 = domain[1], r0 = range[0], r1 = range[1];
  if (d1 < d0) d0 = continuous_normalize(d1, d0), r0 = interpolate(r1, r0);
  else d0 = continuous_normalize(d0, d1), r0 = interpolate(r0, r1);
  return function(x) { return r0(d0(x)); };
}

function polymap(domain, range, interpolate) {
  var j = Math.min(domain.length, range.length) - 1,
      d = new Array(j),
      r = new Array(j),
      i = -1;

  // Reverse descending domains.
  if (domain[j] < domain[0]) {
    domain = domain.slice().reverse();
    range = range.slice().reverse();
  }

  while (++i < j) {
    d[i] = continuous_normalize(domain[i], domain[i + 1]);
    r[i] = interpolate(range[i], range[i + 1]);
  }

  return function(x) {
    var i = d3_array_src_bisect(domain, x, 1, j) - 1;
    return r[i](d[i](x));
  };
}

function continuous_copy(source, target) {
  return target
      .domain(source.domain())
      .range(source.range())
      .interpolate(source.interpolate())
      .clamp(source.clamp())
      .unknown(source.unknown());
}

function transformer() {
  var domain = continuous_unit,
      range = continuous_unit,
      interpolate = src_value,
      transform,
      untransform,
      unknown,
      clamp = continuous_identity,
      piecewise,
      output,
      input;

  function rescale() {
    var n = Math.min(domain.length, range.length);
    if (clamp !== continuous_identity) clamp = clamper(domain[0], domain[n - 1]);
    piecewise = n > 2 ? polymap : bimap;
    output = input = null;
    return scale;
  }

  function scale(x) {
    return isNaN(x = +x) ? unknown : (output || (output = piecewise(domain.map(transform), range, interpolate)))(transform(clamp(x)));
  }

  scale.invert = function(y) {
    return clamp(untransform((input || (input = piecewise(range, domain.map(transform), d3_interpolate_src_number)))(y)));
  };

  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_, d3_scale_src_number), rescale()) : domain.slice();
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();
  };

  scale.rangeRound = function(_) {
    return range = Array.from(_), interpolate = src_round, rescale();
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = _ ? true : continuous_identity, rescale()) : clamp !== continuous_identity;
  };

  scale.interpolate = function(_) {
    return arguments.length ? (interpolate = _, rescale()) : interpolate;
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t, u) {
    transform = t, untransform = u;
    return rescale();
  };
}

function continuous() {
  return transformer()(continuous_identity, continuous_identity);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/linear.js





function linearish(scale) {
  var domain = scale.domain;

  scale.ticks = function(count) {
    var d = domain();
    return src_ticks(d[0], d[d.length - 1], count == null ? 10 : count);
  };

  scale.tickFormat = function(count, specifier) {
    var d = domain();
    return src_tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
  };

  scale.nice = function(count) {
    if (count == null) count = 10;

    var d = domain(),
        i0 = 0,
        i1 = d.length - 1,
        start = d[i0],
        stop = d[i1],
        step;

    if (stop < start) {
      step = start, start = stop, stop = step;
      step = i0, i0 = i1, i1 = step;
    }

    step = tickIncrement(start, stop, count);

    if (step > 0) {
      start = Math.floor(start / step) * step;
      stop = Math.ceil(stop / step) * step;
      step = tickIncrement(start, stop, count);
    } else if (step < 0) {
      start = Math.ceil(start * step) / step;
      stop = Math.floor(stop * step) / step;
      step = tickIncrement(start, stop, count);
    }

    if (step > 0) {
      d[i0] = Math.floor(start / step) * step;
      d[i1] = Math.ceil(stop / step) * step;
      domain(d);
    } else if (step < 0) {
      d[i0] = Math.ceil(start * step) / step;
      d[i1] = Math.floor(stop * step) / step;
      domain(d);
    }

    return scale;
  };

  return scale;
}

function linear_linear() {
  var scale = continuous();

  scale.copy = function() {
    return continuous_copy(scale, linear_linear());
  };

  initRange.apply(scale, arguments);

  return linearish(scale);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/identity.js



function identity_identity(domain) {
  var unknown;

  function scale(x) {
    return isNaN(x = +x) ? unknown : x;
  }

  scale.invert = scale;

  scale.domain = scale.range = function(_) {
    return arguments.length ? (domain = Array.from(_, d3_scale_src_number), scale) : domain.slice();
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  scale.copy = function() {
    return identity_identity(domain).unknown(unknown);
  };

  domain = arguments.length ? Array.from(domain, d3_scale_src_number) : [0, 1];

  return linearish(scale);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/nice.js
/* harmony default export */ var src_nice = (function(domain, interval) {
  domain = domain.slice();

  var i0 = 0,
      i1 = domain.length - 1,
      x0 = domain[i0],
      x1 = domain[i1],
      t;

  if (x1 < x0) {
    t = i0, i0 = i1, i1 = t;
    t = x0, x0 = x1, x1 = t;
  }

  domain[i0] = interval.floor(x0);
  domain[i1] = interval.ceil(x1);
  return domain;
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/log.js






function transformLog(x) {
  return Math.log(x);
}

function transformExp(x) {
  return Math.exp(x);
}

function transformLogn(x) {
  return -Math.log(-x);
}

function transformExpn(x) {
  return -Math.exp(-x);
}

function pow10(x) {
  return isFinite(x) ? +("1e" + x) : x < 0 ? 0 : x;
}

function powp(base) {
  return base === 10 ? pow10
      : base === Math.E ? Math.exp
      : function(x) { return Math.pow(base, x); };
}

function logp(base) {
  return base === Math.E ? Math.log
      : base === 10 && Math.log10
      || base === 2 && Math.log2
      || (base = Math.log(base), function(x) { return Math.log(x) / base; });
}

function reflect(f) {
  return function(x) {
    return -f(-x);
  };
}

function loggish(transform) {
  var scale = transform(transformLog, transformExp),
      domain = scale.domain,
      base = 10,
      logs,
      pows;

  function rescale() {
    logs = logp(base), pows = powp(base);
    if (domain()[0] < 0) {
      logs = reflect(logs), pows = reflect(pows);
      transform(transformLogn, transformExpn);
    } else {
      transform(transformLog, transformExp);
    }
    return scale;
  }

  scale.base = function(_) {
    return arguments.length ? (base = +_, rescale()) : base;
  };

  scale.domain = function(_) {
    return arguments.length ? (domain(_), rescale()) : domain();
  };

  scale.ticks = function(count) {
    var d = domain(),
        u = d[0],
        v = d[d.length - 1],
        r;

    if (r = v < u) i = u, u = v, v = i;

    var i = logs(u),
        j = logs(v),
        p,
        k,
        t,
        n = count == null ? 10 : +count,
        z = [];

    if (!(base % 1) && j - i < n) {
      i = Math.floor(i), j = Math.ceil(j);
      if (u > 0) for (; i <= j; ++i) {
        for (k = 1, p = pows(i); k < base; ++k) {
          t = p * k;
          if (t < u) continue;
          if (t > v) break;
          z.push(t);
        }
      } else for (; i <= j; ++i) {
        for (k = base - 1, p = pows(i); k >= 1; --k) {
          t = p * k;
          if (t < u) continue;
          if (t > v) break;
          z.push(t);
        }
      }
      if (z.length * 2 < n) z = src_ticks(u, v, n);
    } else {
      z = src_ticks(i, j, Math.min(j - i, n)).map(pows);
    }

    return r ? z.reverse() : z;
  };

  scale.tickFormat = function(count, specifier) {
    if (specifier == null) specifier = base === 10 ? ".0e" : ",";
    if (typeof specifier !== "function") specifier = defaultLocale_format(specifier);
    if (count === Infinity) return specifier;
    if (count == null) count = 10;
    var k = Math.max(1, base * count / scale.ticks().length); // TODO fast estimate?
    return function(d) {
      var i = d / pows(Math.round(logs(d)));
      if (i * base < base - 0.5) i *= base;
      return i <= k ? specifier(d) : "";
    };
  };

  scale.nice = function() {
    return domain(src_nice(domain(), {
      floor: function(x) { return pows(Math.floor(logs(x))); },
      ceil: function(x) { return pows(Math.ceil(logs(x))); }
    }));
  };

  return scale;
}

function log_log() {
  var scale = loggish(transformer()).domain([1, 10]);

  scale.copy = function() {
    return continuous_copy(scale, log_log()).base(scale.base());
  };

  initRange.apply(scale, arguments);

  return scale;
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/pow.js




function transformPow(exponent) {
  return function(x) {
    return x < 0 ? -Math.pow(-x, exponent) : Math.pow(x, exponent);
  };
}

function transformSqrt(x) {
  return x < 0 ? -Math.sqrt(-x) : Math.sqrt(x);
}

function transformSquare(x) {
  return x < 0 ? -x * x : x * x;
}

function powish(transform) {
  var scale = transform(continuous_identity, continuous_identity),
      exponent = 1;

  function rescale() {
    return exponent === 1 ? transform(continuous_identity, continuous_identity)
        : exponent === 0.5 ? transform(transformSqrt, transformSquare)
        : transform(transformPow(exponent), transformPow(1 / exponent));
  }

  scale.exponent = function(_) {
    return arguments.length ? (exponent = +_, rescale()) : exponent;
  };

  return linearish(scale);
}

function pow_pow() {
  var scale = powish(transformer());

  scale.copy = function() {
    return continuous_copy(scale, pow_pow()).exponent(scale.exponent());
  };

  initRange.apply(scale, arguments);

  return scale;
}

function pow_sqrt() {
  return pow_pow.apply(null, arguments).exponent(0.5);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/symlog.js




function transformSymlog(c) {
  return function(x) {
    return Math.sign(x) * Math.log1p(Math.abs(x / c));
  };
}

function transformSymexp(c) {
  return function(x) {
    return Math.sign(x) * Math.expm1(Math.abs(x)) * c;
  };
}

function symlogish(transform) {
  var c = 1, scale = transform(transformSymlog(c), transformSymexp(c));

  scale.constant = function(_) {
    return arguments.length ? transform(transformSymlog(c = +_), transformSymexp(c)) : c;
  };

  return linearish(scale);
}

function symlog() {
  var scale = symlogish(transformer());

  scale.copy = function() {
    return continuous_copy(scale, symlog()).constant(scale.constant());
  };

  return initRange.apply(scale, arguments);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/time.js







var time_durationSecond = 1000,
    time_durationMinute = time_durationSecond * 60,
    time_durationHour = time_durationMinute * 60,
    time_durationDay = time_durationHour * 24,
    time_durationWeek = time_durationDay * 7,
    time_durationMonth = time_durationDay * 30,
    time_durationYear = time_durationDay * 365;

function time_date(t) {
  return new Date(t);
}

function time_number(t) {
  return t instanceof Date ? +t : +new Date(+t);
}

function calendar(year, month, week, day, hour, minute, second, millisecond, format) {
  var scale = continuous(),
      invert = scale.invert,
      domain = scale.domain;

  var formatMillisecond = format(".%L"),
      formatSecond = format(":%S"),
      formatMinute = format("%I:%M"),
      formatHour = format("%I %p"),
      formatDay = format("%a %d"),
      formatWeek = format("%b %d"),
      formatMonth = format("%B"),
      formatYear = format("%Y");

  var tickIntervals = [
    [second,  1,      time_durationSecond],
    [second,  5,  5 * time_durationSecond],
    [second, 15, 15 * time_durationSecond],
    [second, 30, 30 * time_durationSecond],
    [minute,  1,      time_durationMinute],
    [minute,  5,  5 * time_durationMinute],
    [minute, 15, 15 * time_durationMinute],
    [minute, 30, 30 * time_durationMinute],
    [  hour,  1,      time_durationHour  ],
    [  hour,  3,  3 * time_durationHour  ],
    [  hour,  6,  6 * time_durationHour  ],
    [  hour, 12, 12 * time_durationHour  ],
    [   day,  1,      time_durationDay   ],
    [   day,  2,  2 * time_durationDay   ],
    [  week,  1,      time_durationWeek  ],
    [ month,  1,      time_durationMonth ],
    [ month,  3,  3 * time_durationMonth ],
    [  year,  1,      time_durationYear  ]
  ];

  function tickFormat(date) {
    return (second(date) < date ? formatMillisecond
        : minute(date) < date ? formatSecond
        : hour(date) < date ? formatMinute
        : day(date) < date ? formatHour
        : month(date) < date ? (week(date) < date ? formatDay : formatWeek)
        : year(date) < date ? formatMonth
        : formatYear)(date);
  }

  function tickInterval(interval, start, stop) {
    if (interval == null) interval = 10;

    // If a desired tick count is specified, pick a reasonable tick interval
    // based on the extent of the domain and a rough estimate of tick size.
    // Otherwise, assume interval is already a time interval and use it.
    if (typeof interval === "number") {
      var target = Math.abs(stop - start) / interval,
          i = bisector(function(i) { return i[2]; }).right(tickIntervals, target),
          step;
      if (i === tickIntervals.length) {
        step = tickStep(start / time_durationYear, stop / time_durationYear, interval);
        interval = year;
      } else if (i) {
        i = tickIntervals[target / tickIntervals[i - 1][2] < tickIntervals[i][2] / target ? i - 1 : i];
        step = i[1];
        interval = i[0];
      } else {
        step = Math.max(tickStep(start, stop, interval), 1);
        interval = millisecond;
      }
      return interval.every(step);
    }

    return interval;
  }

  scale.invert = function(y) {
    return new Date(invert(y));
  };

  scale.domain = function(_) {
    return arguments.length ? domain(Array.from(_, time_number)) : domain().map(time_date);
  };

  scale.ticks = function(interval) {
    var d = domain(),
        t0 = d[0],
        t1 = d[d.length - 1],
        r = t1 < t0,
        t;
    if (r) t = t0, t0 = t1, t1 = t;
    t = tickInterval(interval, t0, t1);
    t = t ? t.range(t0, t1 + 1) : []; // inclusive stop
    return r ? t.reverse() : t;
  };

  scale.tickFormat = function(count, specifier) {
    return specifier == null ? tickFormat : format(specifier);
  };

  scale.nice = function(interval) {
    var d = domain();
    return (interval = tickInterval(interval, d[0], d[d.length - 1]))
        ? domain(src_nice(d, interval))
        : scale;
  };

  scale.copy = function() {
    return continuous_copy(scale, calendar(year, month, week, day, hour, minute, second, millisecond, format));
  };

  return scale;
}

/* harmony default export */ var src_time = (function() {
  return initRange.apply(calendar(src_year, src_month, sunday, src_day, src_hour, src_minute, src_second, src_millisecond, defaultLocale_timeFormat).domain([new Date(2000, 0, 1), new Date(2000, 0, 2)]), arguments);
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/utcTime.js





/* harmony default export */ var utcTime = (function() {
  return initRange.apply(calendar(src_utcYear, src_utcMonth, utcSunday, src_utcDay, src_utcHour, src_utcMinute, src_second, src_millisecond, defaultLocale_utcFormat).domain([Date.UTC(2000, 0, 1), Date.UTC(2000, 0, 2)]), arguments);
});

// CONCATENATED MODULE: ./node_modules/d3-scale/src/sequential.js








function sequential_transformer() {
  var x0 = 0,
      x1 = 1,
      t0,
      t1,
      k10,
      transform,
      interpolator = continuous_identity,
      clamp = false,
      unknown;

  function scale(x) {
    return isNaN(x = +x) ? unknown : interpolator(k10 === 0 ? 0.5 : (x = (transform(x) - t0) * k10, clamp ? Math.max(0, Math.min(1, x)) : x));
  }

  scale.domain = function(_) {
    return arguments.length ? ([x0, x1] = _, t0 = transform(x0 = +x0), t1 = transform(x1 = +x1), k10 = t0 === t1 ? 0 : 1 / (t1 - t0), scale) : [x0, x1];
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = !!_, scale) : clamp;
  };

  scale.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale) : interpolator;
  };

  function range(interpolate) {
    return function(_) {
      var r0, r1;
      return arguments.length ? ([r0, r1] = _, interpolator = interpolate(r0, r1), scale) : [interpolator(0), interpolator(1)];
    };
  }

  scale.range = range(src_value);

  scale.rangeRound = range(src_round);

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t) {
    transform = t, t0 = t(x0), t1 = t(x1), k10 = t0 === t1 ? 0 : 1 / (t1 - t0);
    return scale;
  };
}

function sequential_copy(source, target) {
  return target
      .domain(source.domain())
      .interpolator(source.interpolator())
      .clamp(source.clamp())
      .unknown(source.unknown());
}

function sequential() {
  var scale = linearish(sequential_transformer()(continuous_identity));

  scale.copy = function() {
    return sequential_copy(scale, sequential());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialLog() {
  var scale = loggish(sequential_transformer()).domain([1, 10]);

  scale.copy = function() {
    return sequential_copy(scale, sequentialLog()).base(scale.base());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialSymlog() {
  var scale = symlogish(sequential_transformer());

  scale.copy = function() {
    return sequential_copy(scale, sequentialSymlog()).constant(scale.constant());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialPow() {
  var scale = powish(sequential_transformer());

  scale.copy = function() {
    return sequential_copy(scale, sequentialPow()).exponent(scale.exponent());
  };

  return initInterpolator.apply(scale, arguments);
}

function sequentialSqrt() {
  return sequentialPow.apply(null, arguments).exponent(0.5);
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/piecewise.js
function piecewise_piecewise(interpolate, values) {
  var i = 0, n = values.length - 1, v = values[0], I = new Array(n < 0 ? 0 : n);
  while (i < n) I[i] = interpolate(v, v = values[++i]);
  return function(t) {
    var i = Math.max(0, Math.min(n - 1, Math.floor(t *= n)));
    return I[i](t - i);
  };
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/diverging.js









function diverging_transformer() {
  var x0 = 0,
      x1 = 0.5,
      x2 = 1,
      s = 1,
      t0,
      t1,
      t2,
      k10,
      k21,
      interpolator = continuous_identity,
      transform,
      clamp = false,
      unknown;

  function scale(x) {
    return isNaN(x = +x) ? unknown : (x = 0.5 + ((x = +transform(x)) - t1) * (s * x < s * t1 ? k10 : k21), interpolator(clamp ? Math.max(0, Math.min(1, x)) : x));
  }

  scale.domain = function(_) {
    return arguments.length ? ([x0, x1, x2] = _, t0 = transform(x0 = +x0), t1 = transform(x1 = +x1), t2 = transform(x2 = +x2), k10 = t0 === t1 ? 0 : 0.5 / (t1 - t0), k21 = t1 === t2 ? 0 : 0.5 / (t2 - t1), s = t1 < t0 ? -1 : 1, scale) : [x0, x1, x2];
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = !!_, scale) : clamp;
  };

  scale.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale) : interpolator;
  };

  function range(interpolate) {
    return function(_) {
      var r0, r1, r2;
      return arguments.length ? ([r0, r1, r2] = _, interpolator = piecewise_piecewise(interpolate, [r0, r1, r2]), scale) : [interpolator(0), interpolator(0.5), interpolator(1)];
    };
  }

  scale.range = range(src_value);

  scale.rangeRound = range(src_round);

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t) {
    transform = t, t0 = t(x0), t1 = t(x1), t2 = t(x2), k10 = t0 === t1 ? 0 : 0.5 / (t1 - t0), k21 = t1 === t2 ? 0 : 0.5 / (t2 - t1), s = t1 < t0 ? -1 : 1;
    return scale;
  };
}

function diverging() {
  var scale = linearish(diverging_transformer()(continuous_identity));

  scale.copy = function() {
    return sequential_copy(scale, diverging());
  };

  return initInterpolator.apply(scale, arguments);
}

function divergingLog() {
  var scale = loggish(diverging_transformer()).domain([0.1, 1, 10]);

  scale.copy = function() {
    return sequential_copy(scale, divergingLog()).base(scale.base());
  };

  return initInterpolator.apply(scale, arguments);
}

function divergingSymlog() {
  var scale = symlogish(diverging_transformer());

  scale.copy = function() {
    return sequential_copy(scale, divergingSymlog()).constant(scale.constant());
  };

  return initInterpolator.apply(scale, arguments);
}

function divergingPow() {
  var scale = powish(diverging_transformer());

  scale.copy = function() {
    return sequential_copy(scale, divergingPow()).exponent(scale.exponent());
  };

  return initInterpolator.apply(scale, arguments);
}

function divergingSqrt() {
  return divergingPow.apply(null, arguments).exponent(0.5);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/quantile.js



function quantile_quantile() {
  var domain = [],
      range = [],
      thresholds = [],
      unknown;

  function rescale() {
    var i = 0, n = Math.max(1, range.length);
    thresholds = new Array(n - 1);
    while (++i < n) thresholds[i - 1] = quantile(domain, i / n);
    return scale;
  }

  function scale(x) {
    return isNaN(x = +x) ? unknown : range[d3_array_src_bisect(thresholds, x)];
  }

  scale.invertExtent = function(y) {
    var i = range.indexOf(y);
    return i < 0 ? [NaN, NaN] : [
      i > 0 ? thresholds[i - 1] : domain[0],
      i < thresholds.length ? thresholds[i] : domain[domain.length - 1]
    ];
  };

  scale.domain = function(_) {
    if (!arguments.length) return domain.slice();
    domain = [];
    for (let d of _) if (d != null && !isNaN(d = +d)) domain.push(d);
    domain.sort(ascending);
    return rescale();
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  scale.quantiles = function() {
    return thresholds.slice();
  };

  scale.copy = function() {
    return quantile_quantile()
        .domain(domain)
        .range(range)
        .unknown(unknown);
  };

  return initRange.apply(scale, arguments);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/quantize.js




function quantize_quantize() {
  var x0 = 0,
      x1 = 1,
      n = 1,
      domain = [0.5],
      range = [0, 1],
      unknown;

  function scale(x) {
    return x <= x ? range[d3_array_src_bisect(domain, x, 0, n)] : unknown;
  }

  function rescale() {
    var i = -1;
    domain = new Array(n);
    while (++i < n) domain[i] = ((i + 1) * x1 - (i - n) * x0) / (n + 1);
    return scale;
  }

  scale.domain = function(_) {
    return arguments.length ? ([x0, x1] = _, x0 = +x0, x1 = +x1, rescale()) : [x0, x1];
  };

  scale.range = function(_) {
    return arguments.length ? (n = (range = Array.from(_)).length - 1, rescale()) : range.slice();
  };

  scale.invertExtent = function(y) {
    var i = range.indexOf(y);
    return i < 0 ? [NaN, NaN]
        : i < 1 ? [x0, domain[0]]
        : i >= n ? [domain[n - 1], x1]
        : [domain[i - 1], domain[i]];
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : scale;
  };

  scale.thresholds = function() {
    return domain.slice();
  };

  scale.copy = function() {
    return quantize_quantize()
        .domain([x0, x1])
        .range(range)
        .unknown(unknown);
  };

  return initRange.apply(linearish(scale), arguments);
}

// CONCATENATED MODULE: ./node_modules/d3-scale/src/threshold.js



function threshold_threshold() {
  var domain = [0.5],
      range = [0, 1],
      unknown,
      n = 1;

  function scale(x) {
    return x <= x ? range[d3_array_src_bisect(domain, x, 0, n)] : unknown;
  }

  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_), n = Math.min(domain.length, range.length - 1), scale) : domain.slice();
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), n = Math.min(domain.length, range.length - 1), scale) : range.slice();
  };

  scale.invertExtent = function(y) {
    var i = range.indexOf(y);
    return [domain[i - 1], domain[i]];
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  scale.copy = function() {
    return threshold_threshold()
        .domain(domain)
        .range(range)
        .unknown(unknown);
  };

  return initRange.apply(scale, arguments);
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/scales.js












// scale registry
const scales_scales = {};

/**
 * Augment scales with their type and needed inverse methods.
 */
function create(type, constructor, metadata) {
  const ctr = function scale() {
    var s = constructor();

    if (!s.invertRange) {
      s.invertRange = s.invert ? invertRange(s)
        : s.invertExtent ? invertRangeExtent(s)
        : undefined;
    }

    s.type = type;
    return s;
  };

  ctr.metadata = Object(vega_util["db" /* toSet */])(Object(vega_util["i" /* array */])(metadata));

  return ctr;
}

function scales_scale(type, scale, metadata) {
  if (arguments.length > 1) {
    scales_scales[type] = create(type, scale, metadata);
    return this;
  } else {
    return isValidScaleType(type) ? scales_scales[type] : undefined;
  }
}

// identity scale
scales_scale(Identity, identity_identity);

// continuous scales
scales_scale(types_Linear, linear_linear, Continuous);
scales_scale(Log, log_log, [Continuous, Log]);
scales_scale(Pow, pow_pow, Continuous);
scales_scale(Sqrt, pow_sqrt, Continuous);
scales_scale(Symlog, symlog, Continuous);
scales_scale(Time, src_time, [Continuous, Temporal]);
scales_scale(UTC, utcTime, [Continuous, Temporal]);

// sequential scales
scales_scale(Sequential, sequential, [Continuous, Interpolating]); // backwards compat
scales_scale(`${Sequential}-${types_Linear}`, sequential, [Continuous, Interpolating]);
scales_scale(`${Sequential}-${Log}`, sequentialLog, [Continuous, Interpolating, Log]);
scales_scale(`${Sequential}-${Pow}`, sequentialPow, [Continuous, Interpolating]);
scales_scale(`${Sequential}-${Sqrt}`, sequentialSqrt, [Continuous, Interpolating]);
scales_scale(`${Sequential}-${Symlog}`, sequentialSymlog, [Continuous, Interpolating]);

// diverging scales
scales_scale(`${Diverging}-${types_Linear}`, diverging, [Continuous, Interpolating]);
scales_scale(`${Diverging}-${Log}`, divergingLog, [Continuous, Interpolating, Log]);
scales_scale(`${Diverging}-${Pow}`, divergingPow, [Continuous, Interpolating]);
scales_scale(`${Diverging}-${Sqrt}`, divergingSqrt, [Continuous, Interpolating]);
scales_scale(`${Diverging}-${Symlog}`, divergingSymlog, [Continuous, Interpolating]);

// discretizing scales
scales_scale(types_Quantile, quantile_quantile, [Discretizing, types_Quantile]);
scales_scale(Quantize, quantize_quantize, Discretizing);
scales_scale(Threshold, threshold_threshold, Discretizing);

// discrete scales
scales_scale(BinOrdinal, scaleBinOrdinal, [Discrete, Discretizing]);
scales_scale(Ordinal, ordinal, Discrete);
scales_scale(Band, scaleBand_band, Discrete);
scales_scale(Point, scaleBand_point, Discrete);

function isValidScaleType(type) {
  return Object(vega_util["v" /* hasOwnProperty */])(scales_scales, type);
}

function hasType(key, type) {
  const s = scales_scales[key];
  return s && s.metadata[type];
}

function isContinuous(key) {
  return hasType(key, Continuous);
}

function isDiscrete(key) {
  return hasType(key, Discrete);
}

function isDiscretizing(key) {
  return hasType(key, Discretizing);
}

function isLogarithmic(key) {
  return hasType(key, Log);
}

function isTemporal(key) {
  return hasType(key, Temporal);
}

function isInterpolating(key) {
  return hasType(key, Interpolating);
}

function isQuantile(key) {
  return hasType(key, types_Quantile);
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/discrete.js
/* harmony default export */ var discrete = (function(range) {
  var n = range.length;
  return function(t) {
    return range[Math.max(0, Math.min(n - 1, Math.floor(t * n)))];
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/hue.js


/* harmony default export */ var src_hue = (function(a, b) {
  var i = color_hue(+a, +b);
  return function(t) {
    var x = i(t);
    return x - 360 * Math.floor(x / 360);
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/transform/decompose.js
var degrees = 180 / Math.PI;

var decompose_identity = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};

/* harmony default export */ var decompose = (function(a, b, c, d, e, f) {
  var scaleX, scaleY, skewX;
  if (scaleX = Math.sqrt(a * a + b * b)) a /= scaleX, b /= scaleX;
  if (skewX = a * c + b * d) c -= a * skewX, d -= b * skewX;
  if (scaleY = Math.sqrt(c * c + d * d)) c /= scaleY, d /= scaleY, skewX /= scaleY;
  if (a * d < b * c) a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b, a) * degrees,
    skewX: Math.atan(skewX) * degrees,
    scaleX: scaleX,
    scaleY: scaleY
  };
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/transform/parse.js


var cssNode,
    cssRoot,
    cssView,
    svgNode;

function parseCss(value) {
  if (value === "none") return decompose_identity;
  if (!cssNode) cssNode = document.createElement("DIV"), cssRoot = document.documentElement, cssView = document.defaultView;
  cssNode.style.transform = value;
  value = cssView.getComputedStyle(cssRoot.appendChild(cssNode), null).getPropertyValue("transform");
  cssRoot.removeChild(cssNode);
  value = value.slice(7, -1).split(",");
  return decompose(+value[0], +value[1], +value[2], +value[3], +value[4], +value[5]);
}

function parseSvg(value) {
  if (value == null) return decompose_identity;
  if (!svgNode) svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value);
  if (!(value = svgNode.transform.baseVal.consolidate())) return decompose_identity;
  value = value.matrix;
  return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/transform/index.js



function interpolateTransform(parse, pxComma, pxParen, degParen) {

  function pop(s) {
    return s.length ? s.pop() + " " : "";
  }

  function translate(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q.push({i: i - 4, x: d3_interpolate_src_number(xa, xb)}, {i: i - 2, x: d3_interpolate_src_number(ya, yb)});
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }

  function rotate(a, b, s, q) {
    if (a !== b) {
      if (a - b > 180) b += 360; else if (b - a > 180) a += 360; // shortest path
      q.push({i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: d3_interpolate_src_number(a, b)});
    } else if (b) {
      s.push(pop(s) + "rotate(" + b + degParen);
    }
  }

  function skewX(a, b, s, q) {
    if (a !== b) {
      q.push({i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: d3_interpolate_src_number(a, b)});
    } else if (b) {
      s.push(pop(s) + "skewX(" + b + degParen);
    }
  }

  function scale(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop(s) + "scale(", null, ",", null, ")");
      q.push({i: i - 4, x: d3_interpolate_src_number(xa, xb)}, {i: i - 2, x: d3_interpolate_src_number(ya, yb)});
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop(s) + "scale(" + xb + "," + yb + ")");
    }
  }

  return function(a, b) {
    var s = [], // string constants and placeholders
        q = []; // number interpolators
    a = parse(a), b = parse(b);
    translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
    rotate(a.rotate, b.rotate, s, q);
    skewX(a.skewX, b.skewX, s, q);
    scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
    a = b = null; // gc
    return function(t) {
      var i = -1, n = q.length, o;
      while (++i < n) s[(o = q[i]).i] = o.x(t);
      return s.join("");
    };
  };
}

var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/zoom.js
var rho = Math.SQRT2,
    rho2 = 2,
    rho4 = 4,
    epsilon2 = 1e-12;

function zoom_cosh(x) {
  return ((x = Math.exp(x)) + 1 / x) / 2;
}

function zoom_sinh(x) {
  return ((x = Math.exp(x)) - 1 / x) / 2;
}

function tanh(x) {
  return ((x = Math.exp(2 * x)) - 1) / (x + 1);
}

// p0 = [ux0, uy0, w0]
// p1 = [ux1, uy1, w1]
/* harmony default export */ var zoom = (function(p0, p1) {
  var ux0 = p0[0], uy0 = p0[1], w0 = p0[2],
      ux1 = p1[0], uy1 = p1[1], w1 = p1[2],
      dx = ux1 - ux0,
      dy = uy1 - uy0,
      d2 = dx * dx + dy * dy,
      i,
      S;

  // Special case for u0 ≅ u1.
  if (d2 < epsilon2) {
    S = Math.log(w1 / w0) / rho;
    i = function(t) {
      return [
        ux0 + t * dx,
        uy0 + t * dy,
        w0 * Math.exp(rho * t * S)
      ];
    }
  }

  // General case.
  else {
    var d1 = Math.sqrt(d2),
        b0 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1),
        b1 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1),
        r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0),
        r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
    S = (r1 - r0) / rho;
    i = function(t) {
      var s = t * S,
          coshr0 = zoom_cosh(r0),
          u = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s + r0) - zoom_sinh(r0));
      return [
        ux0 + u * dx,
        uy0 + u * dy,
        w0 * coshr0 / zoom_cosh(rho * s + r0)
      ];
    }
  }

  i.duration = S * 1000;

  return i;
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/hsl.js



function hsl_hsl(hue) {
  return function(start, end) {
    var h = hue((start = hsl(start)).h, (end = hsl(end)).h),
        s = nogamma(start.s, end.s),
        l = nogamma(start.l, end.l),
        opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.h = h(t);
      start.s = s(t);
      start.l = l(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }
}

/* harmony default export */ var src_hsl = (hsl_hsl(color_hue));
var hslLong = hsl_hsl(nogamma);

// CONCATENATED MODULE: ./node_modules/d3-color/src/math.js
var deg2rad = Math.PI / 180;
var rad2deg = 180 / Math.PI;

// CONCATENATED MODULE: ./node_modules/d3-color/src/lab.js




// https://observablehq.com/@mbostock/lab-and-rgb
var K = 18,
    Xn = 0.96422,
    Yn = 1,
    Zn = 0.82521,
    lab_t0 = 4 / 29,
    lab_t1 = 6 / 29,
    lab_t2 = 3 * lab_t1 * lab_t1,
    t3 = lab_t1 * lab_t1 * lab_t1;

function labConvert(o) {
  if (o instanceof Lab) return new Lab(o.l, o.a, o.b, o.opacity);
  if (o instanceof Hcl) return hcl2lab(o);
  if (!(o instanceof Rgb)) o = rgbConvert(o);
  var r = rgb2lrgb(o.r),
      g = rgb2lrgb(o.g),
      b = rgb2lrgb(o.b),
      y = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x, z;
  if (r === g && g === b) x = z = y; else {
    x = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
    z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
  }
  return new Lab(116 * y - 16, 500 * (x - y), 200 * (y - z), o.opacity);
}

function gray(l, opacity) {
  return new Lab(l, 0, 0, opacity == null ? 1 : opacity);
}

function lab(l, a, b, opacity) {
  return arguments.length === 1 ? labConvert(l) : new Lab(l, a, b, opacity == null ? 1 : opacity);
}

function Lab(l, a, b, opacity) {
  this.l = +l;
  this.a = +a;
  this.b = +b;
  this.opacity = +opacity;
}

define(Lab, lab, extend(Color, {
  brighter: function(k) {
    return new Lab(this.l + K * (k == null ? 1 : k), this.a, this.b, this.opacity);
  },
  darker: function(k) {
    return new Lab(this.l - K * (k == null ? 1 : k), this.a, this.b, this.opacity);
  },
  rgb: function() {
    var y = (this.l + 16) / 116,
        x = isNaN(this.a) ? y : y + this.a / 500,
        z = isNaN(this.b) ? y : y - this.b / 200;
    x = Xn * lab2xyz(x);
    y = Yn * lab2xyz(y);
    z = Zn * lab2xyz(z);
    return new Rgb(
      lrgb2rgb( 3.1338561 * x - 1.6168667 * y - 0.4906146 * z),
      lrgb2rgb(-0.9787684 * x + 1.9161415 * y + 0.0334540 * z),
      lrgb2rgb( 0.0719453 * x - 0.2289914 * y + 1.4052427 * z),
      this.opacity
    );
  }
}));

function xyz2lab(t) {
  return t > t3 ? Math.pow(t, 1 / 3) : t / lab_t2 + lab_t0;
}

function lab2xyz(t) {
  return t > lab_t1 ? t * t * t : lab_t2 * (t - lab_t0);
}

function lrgb2rgb(x) {
  return 255 * (x <= 0.0031308 ? 12.92 * x : 1.055 * Math.pow(x, 1 / 2.4) - 0.055);
}

function rgb2lrgb(x) {
  return (x /= 255) <= 0.04045 ? x / 12.92 : Math.pow((x + 0.055) / 1.055, 2.4);
}

function hclConvert(o) {
  if (o instanceof Hcl) return new Hcl(o.h, o.c, o.l, o.opacity);
  if (!(o instanceof Lab)) o = labConvert(o);
  if (o.a === 0 && o.b === 0) return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
  var h = Math.atan2(o.b, o.a) * rad2deg;
  return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
}

function lch(l, c, h, opacity) {
  return arguments.length === 1 ? hclConvert(l) : new Hcl(h, c, l, opacity == null ? 1 : opacity);
}

function hcl(h, c, l, opacity) {
  return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c, l, opacity == null ? 1 : opacity);
}

function Hcl(h, c, l, opacity) {
  this.h = +h;
  this.c = +c;
  this.l = +l;
  this.opacity = +opacity;
}

function hcl2lab(o) {
  if (isNaN(o.h)) return new Lab(o.l, 0, 0, o.opacity);
  var h = o.h * deg2rad;
  return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
}

define(Hcl, hcl, extend(Color, {
  brighter: function(k) {
    return new Hcl(this.h, this.c, this.l + K * (k == null ? 1 : k), this.opacity);
  },
  darker: function(k) {
    return new Hcl(this.h, this.c, this.l - K * (k == null ? 1 : k), this.opacity);
  },
  rgb: function() {
    return hcl2lab(this).rgb();
  }
}));

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/lab.js



function lab_lab(start, end) {
  var l = nogamma((start = lab(start)).l, (end = lab(end)).l),
      a = nogamma(start.a, end.a),
      b = nogamma(start.b, end.b),
      opacity = nogamma(start.opacity, end.opacity);
  return function(t) {
    start.l = l(t);
    start.a = a(t);
    start.b = b(t);
    start.opacity = opacity(t);
    return start + "";
  };
}

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/hcl.js



function hcl_hcl(hue) {
  return function(start, end) {
    var h = hue((start = hcl(start)).h, (end = hcl(end)).h),
        c = nogamma(start.c, end.c),
        l = nogamma(start.l, end.l),
        opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.h = h(t);
      start.c = c(t);
      start.l = l(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }
}

/* harmony default export */ var src_hcl = (hcl_hcl(color_hue));
var hclLong = hcl_hcl(nogamma);

// CONCATENATED MODULE: ./node_modules/d3-color/src/cubehelix.js




var cubehelix_A = -0.14861,
    cubehelix_B = +1.78277,
    cubehelix_C = -0.29227,
    cubehelix_D = -0.90649,
    E = +1.97294,
    ED = E * cubehelix_D,
    EB = E * cubehelix_B,
    BC_DA = cubehelix_B * cubehelix_C - cubehelix_D * cubehelix_A;

function cubehelixConvert(o) {
  if (o instanceof Cubehelix) return new Cubehelix(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Rgb)) o = rgbConvert(o);
  var r = o.r / 255,
      g = o.g / 255,
      b = o.b / 255,
      l = (BC_DA * b + ED * r - EB * g) / (BC_DA + ED - EB),
      bl = b - l,
      k = (E * (g - l) - cubehelix_C * bl) / cubehelix_D,
      s = Math.sqrt(k * k + bl * bl) / (E * l * (1 - l)), // NaN if l=0 or l=1
      h = s ? Math.atan2(k, bl) * rad2deg - 120 : NaN;
  return new Cubehelix(h < 0 ? h + 360 : h, s, l, o.opacity);
}

function cubehelix_cubehelix(h, s, l, opacity) {
  return arguments.length === 1 ? cubehelixConvert(h) : new Cubehelix(h, s, l, opacity == null ? 1 : opacity);
}

function Cubehelix(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

define(Cubehelix, cubehelix_cubehelix, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  rgb: function() {
    var h = isNaN(this.h) ? 0 : (this.h + 120) * deg2rad,
        l = +this.l,
        a = isNaN(this.s) ? 0 : this.s * l * (1 - l),
        cosh = Math.cos(h),
        sinh = Math.sin(h);
    return new Rgb(
      255 * (l + a * (cubehelix_A * cosh + cubehelix_B * sinh)),
      255 * (l + a * (cubehelix_C * cosh + cubehelix_D * sinh)),
      255 * (l + a * (E * cosh)),
      this.opacity
    );
  }
}));

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/cubehelix.js



function src_cubehelix_cubehelix(hue) {
  return (function cubehelixGamma(y) {
    y = +y;

    function cubehelix(start, end) {
      var h = hue((start = cubehelix_cubehelix(start)).h, (end = cubehelix_cubehelix(end)).h),
          s = nogamma(start.s, end.s),
          l = nogamma(start.l, end.l),
          opacity = nogamma(start.opacity, end.opacity);
      return function(t) {
        start.h = h(t);
        start.s = s(t);
        start.l = l(Math.pow(t, y));
        start.opacity = opacity(t);
        return start + "";
      };
    }

    cubehelix.gamma = cubehelixGamma;

    return cubehelix;
  })(1);
}

/* harmony default export */ var src_cubehelix = (src_cubehelix_cubehelix(color_hue));
var cubehelixLong = src_cubehelix_cubehelix(nogamma);

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/quantize.js
/* harmony default export */ var src_quantize = (function(interpolator, n) {
  var samples = new Array(n);
  for (var i = 0; i < n; ++i) samples[i] = interpolator(i / (n - 1));
  return samples;
});

// CONCATENATED MODULE: ./node_modules/d3-interpolate/src/index.js






















// CONCATENATED MODULE: ./node_modules/vega-scale/src/interpolate.js




const scaleProps = ['clamp', 'base', 'constant', 'exponent'];

function interpolateRange(interpolator, range) {
  var start = range[0],
      span = Object(vega_util["U" /* peek */])(range) - start;
  return function(i) { return interpolator(start + i * span); };
}

function interpolateColors(colors, type, gamma) {
  return piecewise_piecewise(interpolate_interpolate(type || 'rgb', gamma), colors);
}

function quantizeInterpolator(interpolator, count) {
  var samples = new Array(count),
      n = count + 1;
  for (var i = 0; i < count;) samples[i] = interpolator(++i / n);
  return samples;
}

function scaleCopy(scale) {
  const t = scale.type,
        s = scale.copy();
  s.type = t;
  return s;
}

function scaleFraction(scale, min, max) {
  var delta = max - min, i, t, s;

  if (!delta || !Number.isFinite(delta)) {
    return Object(vega_util["l" /* constant */])(0.5);
  } else {
    i = (t = scale.type).indexOf('-');
    t = i < 0 ? t : t.slice(i + 1);
    s = scales_scale(t)().domain([min, max]).range([0, 1]);
    scaleProps.forEach(m => scale[m] ? s[m](scale[m]()) : 0);
    return s;
  }
}

function interpolate_interpolate(type, gamma) {
  var interp = d3_interpolate_src_namespaceObject[interpolate_method(type)];
  return (gamma != null && interp && interp.gamma)
    ? interp.gamma(gamma)
    : interp;
}

function interpolate_method(type) {
  return 'interpolate' + type.toLowerCase()
    .split('-')
    .map(function(s) { return s[0].toUpperCase() + s.slice(1); })
    .join('');
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/palettes.js
const palettes_continuous = {
  blues: 'cfe1f2bed8eca8cee58fc1de74b2d75ba3cf4592c63181bd206fb2125ca40a4a90',
  greens: 'd3eecdc0e6baabdda594d3917bc77d60ba6c46ab5e329a512089430e7735036429',
  greys: 'e2e2e2d4d4d4c4c4c4b1b1b19d9d9d8888887575756262624d4d4d3535351e1e1e',
  oranges: 'fdd8b3fdc998fdb87bfda55efc9244f87f2cf06b18e4580bd14904b93d029f3303',
  purples: 'e2e1efd4d4e8c4c5e0b4b3d6a3a0cc928ec3827cb97566ae684ea25c3696501f8c',
  reds: 'fdc9b4fcb49afc9e80fc8767fa7051f6573fec3f2fdc2a25c81b1db21218970b13',

  blueGreen: 'd5efedc1e8e0a7ddd18bd2be70c6a958ba9144ad77319c5d2089460e7736036429',
  bluePurple: 'ccddecbad0e4a8c2dd9ab0d4919cc98d85be8b6db28a55a6873c99822287730f71',
  greenBlue: 'd3eecec5e8c3b1e1bb9bd8bb82cec269c2ca51b2cd3c9fc7288abd1675b10b60a1',
  orangeRed: 'fddcaffdcf9bfdc18afdad77fb9562f67d53ee6545e24932d32d1ebf130da70403',
  purpleBlue: 'dbdaebc8cee4b1c3de97b7d87bacd15b9fc93a90c01e7fb70b70ab056199045281',
  purpleBlueGreen: 'dbd8eac8cee4b0c3de93b7d872acd1549fc83892bb1c88a3097f8702736b016353',
  purpleRed: 'dcc9e2d3b3d7ce9eccd186c0da6bb2e14da0e23189d91e6fc61159ab07498f023a',
  redPurple: 'fccfccfcbec0faa9b8f98faff571a5ec539ddb3695c41b8aa908808d0179700174',
  yellowGreen: 'e4f4acd1eca0b9e2949ed68880c97c62bb6e47aa5e3297502083440e723b036034',
  yellowOrangeBrown: 'feeaa1fedd84fecc63feb746fca031f68921eb7215db5e0bc54c05ab3d038f3204',
  yellowOrangeRed: 'fee087fed16ffebd59fea849fd903efc7335f9522bee3423de1b20ca0b22af0225',

  blueOrange: '134b852f78b35da2cb9dcae1d2e5eff2f0ebfce0bafbbf74e8932fc5690d994a07',
  brownBlueGreen: '704108a0651ac79548e3c78af3e6c6eef1eac9e9e48ed1c74da79e187a72025147',
  purpleGreen: '5b1667834792a67fb6c9aed3e6d6e8eff0efd9efd5aedda971bb75368e490e5e29',
  purpleOrange: '4114696647968f83b7b9b4d6dadbebf3eeeafce0bafbbf74e8932fc5690d994a07',
  redBlue: '8c0d25bf363adf745ef4ae91fbdbc9f2efeed2e5ef9dcae15da2cb2f78b3134b85',
  redGrey: '8c0d25bf363adf745ef4ae91fcdccbfaf4f1e2e2e2c0c0c0969696646464343434',
  yellowGreenBlue: 'eff9bddbf1b4bde5b594d5b969c5be45b4c22c9ec02182b82163aa23479c1c3185',
  redYellowBlue: 'a50026d4322cf16e43fcac64fedd90faf8c1dcf1ecabd6e875abd04a74b4313695',
  redYellowGreen: 'a50026d4322cf16e43fcac63fedd8df9f7aed7ee8ea4d86e64bc6122964f006837',
  pinkYellowGreen: '8e0152c0267edd72adf0b3d6faddedf5f3efe1f2cab6de8780bb474f9125276419',
  spectral: '9e0142d13c4bf0704afcac63fedd8dfbf8b0e0f3a1a9dda269bda94288b55e4fa2',

  viridis: '440154470e61481a6c482575472f7d443a834144873d4e8a39568c35608d31688e2d708e2a788e27818e23888e21918d1f988b1fa08822a8842ab07f35b77943bf7154c56866cc5d7ad1518fd744a5db36bcdf27d2e21be9e51afde725',
  magma: '0000040404130b0924150e3720114b2c11603b0f704a107957157e651a80721f817f24828c29819a2e80a8327db6377ac43c75d1426fde4968e95462f1605df76f5cfa7f5efc8f65fe9f6dfeaf78febf84fece91fddea0fcedaffcfdbf',
  inferno: '0000040403130c0826170c3b240c4f330a5f420a68500d6c5d126e6b176e781c6d86216b932667a12b62ae305cbb3755c73e4cd24644dd513ae65c30ed6925f3771af8850ffb9506fca50afcb519fac62df6d645f2e661f3f484fcffa4',
  plasma: '0d088723069033059742039d5002a25d01a66a00a87801a88405a7900da49c179ea72198b12a90ba3488c33d80cb4779d35171da5a69e16462e76e5bed7953f2834cf68f44fa9a3dfca636fdb32ffec029fcce25f9dc24f5ea27f0f921',

  rainbow: '6e40aa883eb1a43db3bf3cafd83fa4ee4395fe4b83ff576eff6659ff7847ff8c38f3a130e2b72fcfcc36bee044aff05b8ff4576ff65b52f6673af27828ea8d1ddfa319d0b81cbecb23abd82f96e03d82e14c6edb5a5dd0664dbf6e40aa',
  sinebow: 'ff4040fc582af47218e78d0bd5a703bfbf00a7d5038de70b72f41858fc2a40ff402afc5818f4720be78d03d5a700bfbf03a7d50b8de71872f42a58fc4040ff582afc7218f48d0be7a703d5bf00bfd503a7e70b8df41872fc2a58ff4040',

  browns: 'eedbbdecca96e9b97ae4a865dc9856d18954c7784cc0673fb85536ad44339f3632',
  tealBlues: 'bce4d89dd3d181c3cb65b3c245a2b9368fae347da0306a932c5985',
  teals: 'bbdfdfa2d4d58ac9c975bcbb61b0af4da5a43799982b8b8c1e7f7f127273006667',
  warmGreys: 'dcd4d0cec5c1c0b8b4b3aaa7a59c9998908c8b827f7e7673726866665c5a59504e',

  goldGreen: 'f4d166d5ca60b6c35c98bb597cb25760a6564b9c533f8f4f33834a257740146c36',
  goldOrange: 'f4d166f8be5cf8aa4cf5983bf3852aef701be2621fd65322c54923b142239e3a26',
  goldRed: 'f4d166f6be59f9aa51fc964ef6834bee734ae56249db5247cf4244c43141b71d3e',

  lightGreyRed: 'efe9e6e1dad7d5cbc8c8bdb9bbaea9cd967ddc7b43e15f19df4011dc000b',
  lightGreyTeal: 'e4eaead6dcddc8ced2b7c2c7a6b4bc64b0bf22a6c32295c11f85be1876bc',
  lightMulti: 'e0f1f2c4e9d0b0de9fd0e181f6e072f6c053f3993ef77440ef4a3c',
  lightOrange: 'f2e7daf7d5baf9c499fab184fa9c73f68967ef7860e8645bde515bd43d5b',
  lightTealBlue: 'e3e9e0c0dccf9aceca7abfc859afc0389fb9328dad2f7ca0276b95255988',

  darkBlue: '3232322d46681a5c930074af008cbf05a7ce25c0dd38daed50f3faffffff',
  darkGold: '3c3c3c584b37725e348c7631ae8b2bcfa424ecc31ef9de30fff184ffffff',
  darkGreen: '3a3a3a215748006f4d048942489e4276b340a6c63dd2d836ffeb2cffffaa',
  darkMulti: '3737371f5287197d8c29a86995ce3fffe800ffffff',
  darkRed: '3434347036339e3c38cc4037e75d1eec8620eeab29f0ce32ffeb2c'
};

const palettes_discrete = {
  category10: '1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf',
  category20: '1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5',
  category20b: '393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6',
  category20c: '3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9',
  tableau10: '4c78a8f58518e4575672b7b254a24beeca3bb279a2ff9da69d755dbab0ac',
  tableau20: '4c78a89ecae9f58518ffbf7954a24b88d27ab79a20f2cf5b43989483bcb6e45756ff9d9879706ebab0acd67195fcbfd2b279a2d6a5c99e765fd8b5a5',
  accent: '7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666',
  dark2: '1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666',
  paired: 'a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928',
  pastel1: 'fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2',
  pastel2: 'b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc',
  set1: 'e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999',
  set2: '66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3',
  set3: '8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f'
};

// CONCATENATED MODULE: ./node_modules/vega-scale/src/schemes.js



function schemes_colors(palette) {
  var n = palette.length / 6 | 0, c = new Array(n), i = 0;
  while (i < n) c[i] = '#' + palette.slice(i * 6, ++i * 6);
  return c;
}

function schemes_apply(_, f) {
  for (let k in _) schemes_scheme(k, f(_[k]));
}

const schemes = {};
schemes_apply(palettes_discrete, schemes_colors);
schemes_apply(palettes_continuous, _ => interpolateColors(schemes_colors(_)));

function schemes_scheme(name, scheme) {
  name = name && name.toLowerCase();
  if (arguments.length > 1) {
    schemes[name] = scheme;
    return this;
  } else {
    return schemes[name];
  }
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/legend-types.js
var SymbolLegend  = 'symbol';
var DiscreteLegend = 'discrete';
var GradientLegend = 'gradient';

// CONCATENATED MODULE: ./node_modules/vega-scale/src/ticks.js





const defaultFormatter = value => Object(vega_util["A" /* isArray */])(value)
  ? value.map(v => String(v))
  : String(value);

const ticks_ascending = (a, b) => a[1] - b[1];
const descending = (a, b) => b[1] - a[1];

/**
 * Determine the tick count or interval function.
 * @param {Scale} scale - The scale for which to generate tick values.
 * @param {*} count - The desired tick count or interval specifier.
 * @param {number} minStep - The desired minimum step between tick values.
 * @return {*} - The tick count or interval function.
 */
function tickCount(scale, count, minStep) {
  var step;

  if (Object(vega_util["E" /* isNumber */])(count)) {
    if (scale.bins) {
      count = Math.max(count, scale.bins.length);
    }
    if (minStep != null) {
      count = Math.min(
        count,
        Math.floor((Object(vega_util["X" /* span */])(scale.domain()) / minStep) || 1)
      );
    }
  }

  if (Object(vega_util["F" /* isObject */])(count)) {
    step = count.step;
    count = count.interval;
  }

  if (Object(vega_util["H" /* isString */])(count)) {
    count = scale.type === Time ? timeInterval(count)
      : scale.type == UTC ? utcInterval(count)
      : Object(vega_util["n" /* error */])('Only time and utc scales accept interval strings.');
    if (step) count = count.every(step);
  }

  return count;
}

/**
 * Filter a set of candidate tick values, ensuring that only tick values
 * that lie within the scale range are included.
 * @param {Scale} scale - The scale for which to generate tick values.
 * @param {Array<*>} ticks - The candidate tick values.
 * @param {*} count - The tick count or interval function.
 * @return {Array<*>} - The filtered tick values.
 */
function validTicks(scale, ticks, count) {
  let range = scale.range(),
      lo = range[0],
      hi = Object(vega_util["U" /* peek */])(range),
      cmp = ticks_ascending;

  if (lo > hi) {
    range = hi;
    hi = lo;
    lo = range;
    cmp = descending;
  }

  lo = Math.floor(lo);
  hi = Math.ceil(hi);

  // filter ticks to valid values within the range
  // additionally sort ticks in range order (#2579)
  ticks = ticks.map(v => [v, scale(v)])
    .filter(_ => lo <= _[1] && _[1] <= hi)
    .sort(cmp)
    .map(_ => _[0]);

  if (count > 0 && ticks.length > 1) {
    const endpoints = [ticks[0], Object(vega_util["U" /* peek */])(ticks)];
    while (ticks.length > count && ticks.length >= 3) {
      ticks = ticks.filter((_, i) => !(i % 2));
    }
    if (ticks.length < 3) {
      ticks = endpoints;
    }
  }

  return ticks;
}

/**
 * Generate tick values for the given scale and approximate tick count or
 * interval value. If the scale has a 'ticks' method, it will be used to
 * generate the ticks, with the count argument passed as a parameter. If the
 * scale lacks a 'ticks' method, the full scale domain will be returned.
 * @param {Scale} scale - The scale for which to generate tick values.
 * @param {*} [count] - The approximate number of desired ticks.
 * @return {Array<*>} - The generated tick values.
 */
function tickValues(scale, count) {
  return scale.bins ? validTicks(scale, scale.bins)
    : scale.ticks ? scale.ticks(count)
    : scale.domain();
}

/**
 * Generate a label format function for a scale. If the scale has a
 * 'tickFormat' method, it will be used to generate the formatter, with the
 * count and specifier arguments passed as parameters. If the scale lacks a
 * 'tickFormat' method, the returned formatter performs simple string coercion.
 * If the input scale is a logarithmic scale and the format specifier does not
 * indicate a desired decimal precision, a special variable precision formatter
 * that automatically trims trailing zeroes will be generated.
 * @param {Scale} scale - The scale for which to generate the label formatter.
 * @param {*} [count] - The approximate number of desired ticks.
 * @param {string} [specifier] - The format specifier. Must be a legal d3
 *   specifier string (see https://github.com/d3/d3-format#formatSpecifier) or
 *   time multi-format specifier object.
 * @return {function(*):string} - The generated label formatter.
 */
function ticks_tickFormat(locale, scale, count, specifier, formatType, noSkip) {
  var type = scale.type;
  let format = defaultFormatter;

  if (type === Time || formatType === Time) {
    format = locale.timeFormat(specifier);
  }
  else if (type === UTC || formatType === UTC) {
    format = locale.utcFormat(specifier);
  }
  else if (isLogarithmic(type)) {
    const varfmt = locale.formatFloat(specifier);
    if (noSkip || scale.bins) {
      format = varfmt;
    } else {
      const test = tickLog(scale, count, false);
      format = _ => test(_) ? varfmt(_) : '';
    }
  }
  else if (scale.tickFormat) {
    // if d3 scale has tickFormat, it must be continuous
    const d = scale.domain();
    format = locale.formatSpan(d[0], d[d.length - 1], count, specifier);
  }
  else if (specifier) {
    format = locale.format(specifier);
  }

  return format;
}

function tickLog(scale, count, values) {
  const ticks = tickValues(scale, count),
        base = scale.base(),
        logb = Math.log(base),
        k = Math.max(1, base * count / ticks.length);

  // apply d3-scale's log format filter criteria
  const test = d => {
    let i = d / Math.pow(base, Math.round(Math.log(d) / logb));
    if (i * base < base - 0.5) i *= base;
    return i <= k;
  };

  return values ? ticks.filter(test) : test;
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/labels.js





const labels_symbols = {
  [types_Quantile]:  'quantiles',
  [Quantize]:  'thresholds',
  [Threshold]: 'domain'
};

const labels_formats = {
  [types_Quantile]:  'quantiles',
  [Quantize]:  'domain'
};

function labelValues(scale, count) {
  return scale.bins ? binValues(scale.bins)
    : scale.type === Log ? tickLog(scale, count, true)
    : labels_symbols[scale.type] ? thresholdValues(scale[labels_symbols[scale.type]]())
    : tickValues(scale, count);
}

function thresholdFormat(locale, scale, specifier) {
  var _ = scale[labels_formats[scale.type]](),
      n = _.length,
      d = n > 1 ? _[1] - _[0] : _[0], i;

  for (i=1; i<n; ++i) {
    d = Math.min(d, _[i] - _[i-1]);
  }

  // tickCount = 3 ticks times 10 for increased resolution
  return locale.formatSpan(0, d, 3 * 10, specifier);
}

function thresholdValues(thresholds) {
  const values = [-Infinity].concat(thresholds);
  values.max = +Infinity;
  return values;
}

function binValues(bins) {
  const values = bins.slice(0, -1);
  values.max = Object(vega_util["U" /* peek */])(bins);
  return values;
}

function isDiscreteRange(scale) {
  return labels_symbols[scale.type] || scale.bins;
}

function labelFormat(locale, scale, count, type, specifier, formatType, noSkip) {
  const format = labels_formats[scale.type] && formatType !== Time && formatType !== UTC
    ? thresholdFormat(locale, scale, specifier)
    : ticks_tickFormat(locale, scale, count, specifier, formatType, noSkip);

  return type === SymbolLegend && isDiscreteRange(scale) ? formatRange(format)
    : type === DiscreteLegend ? formatDiscrete(format)
    : formatPoint(format);
}

function formatRange(format) {
  return (value, index, array) => {
    var limit = labels_get(array[index + 1], labels_get(array.max, +Infinity)),
        lo = formatValue(value, format),
        hi = formatValue(limit, format);
    return lo && hi ? lo + ' \u2013 ' + hi : hi ? '< ' + hi : '\u2265 ' + lo;
  };
}

function labels_get(value, dflt) {
  return value != null ? value : dflt;
}

function formatDiscrete(format) {
  return (value, index) => index ? format(value) : null;
}

function formatPoint(format) {
  return value => format(value);
}

function formatValue(value, format) {
  return Number.isFinite(value) ? format(value) : null;
}

function labelFraction(scale) {
  var domain = scale.domain(),
      count = domain.length - 1,
      lo = +domain[0],
      hi = +Object(vega_util["U" /* peek */])(domain),
      span = hi - lo;

  if (scale.type === Threshold) {
    const adjust = count ? span / count : 0.1;
    lo -= adjust;
    hi += adjust;
    span = hi - lo;
  }

  return value => (value - lo) / span;
}

// CONCATENATED MODULE: ./node_modules/vega-scale/src/caption.js





function caption_format(locale, scale, specifier, formatType) {
  const type = formatType || scale.type;

  // replace abbreviated time specifiers to improve screen reader experience
  if (Object(vega_util["H" /* isString */])(specifier) && isTemporal(type)) {
    specifier = specifier.replace(/%a/g, '%A').replace(/%b/g, '%B');
  }

  return !specifier && type === Time  ? locale.timeFormat('%A, %d %B %Y, %X')
    : !specifier && type === UTC ? locale.utcFormat('%A, %d %B %Y, %X UTC')
    : labelFormat(locale, scale, 5, null, specifier, formatType, true);
}

function domainCaption(locale, scale, opt) {
  opt = opt || {};
  const max = Math.max(3, opt.maxlen || 7),
        fmt = caption_format(locale, scale, opt.format, opt.formatType);

  // if scale breaks domain into bins, describe boundaries
  if (isDiscretizing(scale.type)) {
    const v = labelValues(scale).slice(1).map(fmt),
          n = v.length;
    return `${n} boundar${n === 1 ? 'y' : 'ies'}: ${v.join(', ')}`;
  }

  // if scale domain is discrete, list values
  else if (isDiscrete(scale.type)) {
    const d = scale.domain(),
          n = d.length,
          v = n > max
            ? d.slice(0, max - 2).map(fmt).join(', ')
              + ', ending with ' + d.slice(-1).map(fmt)
            : d.map(fmt).join(', ');
    return `${n} value${n === 1 ? '' : 's'}: ${v}`;
  }

  // if scale domain is continuous, describe value range
  else {
    const d = scale.domain();
    return `values from ${fmt(d[0])} to ${fmt(Object(vega_util["U" /* peek */])(d))}`;
  }
}

// CONCATENATED MODULE: ./node_modules/vega-scale/index.js




















// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/aria.js



const ARIA_HIDDEN = 'aria-hidden';
const ARIA_LABEL = 'aria-label';
const ARIA_ROLE = 'role';
const ARIA_ROLEDESCRIPTION = 'aria-roledescription';
const GRAPHICS_OBJECT = 'graphics-object';
const GRAPHICS_SYMBOL = 'graphics-symbol';

const aria_bundle = (role, roledesc, label) => ({
  [ARIA_ROLE]: role,
  [ARIA_ROLEDESCRIPTION]: roledesc,
  [ARIA_LABEL]: label || undefined
});

// these roles are covered by related roles
// we can ignore them, no need to generate attributes
const AriaIgnore = Object(vega_util["db" /* toSet */])([
  'axis-domain',
  'axis-grid',
  'axis-label',
  'axis-tick',
  'axis-title',
  'legend-band',
  'legend-entry',
  'legend-gradient',
  'legend-label',
  'legend-title',
  'legend-symbol',
  'title'
]);

// aria attribute generators for guide roles
const AriaGuides = {
  'axis': {desc: 'axis', caption: axisCaption},
  'legend': {desc: 'legend', caption: legendCaption},
  'title-text': {
    desc: 'title',
    caption: item => `Title text '${titleCaption(item)}'`
  },
  'title-subtitle': {
    desc: 'subtitle',
    caption: item => `Subtitle text '${titleCaption(item)}'`
  }
};

// aria properties generated for mark item encoding channels
const AriaEncode = {
  ariaRole: ARIA_ROLE,
  ariaRoleDescription: ARIA_ROLEDESCRIPTION,
  description: ARIA_LABEL
};

function ariaItemAttributes(emit, item) {
  const hide = item.aria === false;
  emit(ARIA_HIDDEN, hide || undefined);

  if (hide || item.description == null) {
    for (const prop in AriaEncode) {
      emit(AriaEncode[prop], undefined);
    }
  } else {
    const type = item.mark.marktype;
    emit(
      ARIA_LABEL,
      item.description
    );
    emit(
      ARIA_ROLE,
      item.ariaRole || (type === 'group' ? GRAPHICS_OBJECT : GRAPHICS_SYMBOL)
    );
    emit(
      ARIA_ROLEDESCRIPTION,
      item.ariaRoleDescription || `${type} mark`
    );
  }
}

function ariaMarkAttributes(mark) {
  return mark.aria === false ? { [ARIA_HIDDEN]: true }
    : AriaIgnore[mark.role] ? null
    : AriaGuides[mark.role] ? ariaGuide(mark, AriaGuides[mark.role])
    : ariaMark(mark);
}

function ariaMark(mark) {
  const type = mark.marktype;
  const recurse = (
    type === 'group' ||
    type === 'text' ||
    mark.items.some(_ => _.description != null && _.aria !== false)
  );
  return aria_bundle(
    recurse ? GRAPHICS_OBJECT : GRAPHICS_SYMBOL,
    `${type} mark container`,
    mark.description
  );
}

function ariaGuide(mark, opt) {
  try {
    const item = mark.items[0],
          caption = opt.caption || (() => '');
    return aria_bundle(
      opt.role || GRAPHICS_SYMBOL,
      opt.desc,
      item.description || caption(item)
    );
  } catch (err) {
    return null;
  }
}

function titleCaption(item) {
  return Object(vega_util["i" /* array */])(item.text).join(' ');
}

function axisCaption(item) {
  const datum = item.datum,
        orient = item.orient,
        title = datum.title ? extractTitle(item) : null,
        ctx = item.context,
        scale = ctx.scales[datum.scale].value,
        locale = ctx.dataflow.locale(),
        type = scale.type,
        xy = (orient === 'left' || orient === 'right') ? 'Y' : 'X';

  return `${xy}-axis`
    + (title ? ` titled '${title}'` : '')
    + ` for a ${isDiscrete(type) ? 'discrete' : type} scale`
    + ` with ${domainCaption(locale, scale, item)}`;
}

function legendCaption(item) {
  const datum = item.datum,
        title = datum.title ? extractTitle(item) : null,
        type = `${datum.type || ''} legend`.trim(),
        scales = datum.scales,
        props = Object.keys(scales),
        ctx = item.context,
        scale = ctx.scales[scales[props[0]]].value,
        locale = ctx.dataflow.locale();

  return capitalize(type)
    + (title ? ` titled '${title}'` : '')
    + ` for ${channelCaption(props)}`
    + ` with ${domainCaption(locale, scale, item)}`;
}

function extractTitle(item) {
  try {
    return Object(vega_util["i" /* array */])(Object(vega_util["U" /* peek */])(item.items).items[0].text).join(' ');
  } catch (err) {
    return null;
  }
}

function channelCaption(props) {
  props = props.map(p => p + (p === 'fill' || p === 'stroke' ? ' color' : ''));
  return props.length < 2 ? props[0]
    : props.slice(0, -1).join(', ') + ' and ' + Object(vega_util["U" /* peek */])(props);
}

function capitalize(s) {
  return s.length ? s[0].toUpperCase() + s.slice(1) : s;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/tags.js
const attrText = val => (val + '')
  .replace(/&/g, '&amp;')
  .replace(/"/g, '&quot;');

/**
 * Generate string for an opening xml tag.
 * @param tag the name of the xml tag
 * @param attr hash of attribute name-value pairs to include
 * @param raw additional raw string to include in tag markup
 */
function openTag(tag, attr, raw) {
  var s = '<' + tag, key, val;
  if (attr) {
    for (key in attr) {
      val = attr[key];
      if (val != null) {
        s += ' ' + key + '="' + attrText(val) + '"';
      }
    }
  }
  if (raw) s += ' ' + raw;
  return s + '>';
}

/**
 * Generate string for closing xml tag.
 * @param tag the name of the xml tag
 */
function closeTag(tag) {
  return '</' + tag + '>';
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/svg/styles.js
const styles = {
  fill:             'fill',
  fillOpacity:      'fill-opacity',
  stroke:           'stroke',
  strokeOpacity:    'stroke-opacity',
  strokeWidth:      'stroke-width',
  strokeCap:        'stroke-linecap',
  strokeJoin:       'stroke-linejoin',
  strokeDash:       'stroke-dasharray',
  strokeDashOffset: 'stroke-dashoffset',
  strokeMiterLimit: 'stroke-miterlimit',
  opacity:          'opacity',
  blend:            'mix-blend-mode'
};

// ensure miter limit default is consistent with canvas (#2498)
const rootAttributes = {
  'fill': 'none',
  'stroke-miterlimit': 10
};

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/SVGRenderer.js













const RootIndex = 0,
      ns = svg_metadata.xmlns;

function SVGRenderer(loader) {
  Renderer_Renderer.call(this, loader);
  this._dirtyID = 0;
  this._dirty = [];
  this._svg = null;
  this._root = null;
  this._defs = null;
}

var SVGRenderer_prototype = Object(vega_util["y" /* inherits */])(SVGRenderer, Renderer_Renderer);
var SVGRenderer_base = Renderer_Renderer.prototype;

SVGRenderer_prototype.initialize = function(el, width, height, padding) {
  // create the svg definitions cache
  this._defs = {
    gradient: {},
    clipping: {}
  };

  if (el) {
    this._svg = domChild(el, 0, 'svg', ns);
    this._svg.setAttribute('class', 'marks');
    domClear(el, 1);

    // set the svg root group
    this._root = domChild(this._svg, RootIndex, 'g', ns);
    for (const attr in rootAttributes) {
      this._root.setAttribute(attr, rootAttributes[attr]);
    }

    // ensure no additional child elements
    domClear(this._svg, RootIndex + 1);
  }

  // set background color if defined
  this.background(this._bgcolor);

  return SVGRenderer_base.initialize.call(this, el, width, height, padding);
};

SVGRenderer_prototype.background = function(bgcolor) {
  if (arguments.length && this._svg) {
    this._svg.style.setProperty('background-color', bgcolor);
  }
  return SVGRenderer_base.background.apply(this, arguments);
};

SVGRenderer_prototype.resize = function(width, height, origin, scaleFactor) {
  SVGRenderer_base.resize.call(this, width, height, origin, scaleFactor);

  if (this._svg) {
    this._svg.setAttribute('width', this._width * this._scale);
    this._svg.setAttribute('height', this._height * this._scale);
    this._svg.setAttribute('viewBox', '0 0 ' + this._width + ' ' + this._height);
    this._root.setAttribute('transform', 'translate(' + this._origin + ')');
  }

  this._dirty = [];

  return this;
};

SVGRenderer_prototype.canvas = function() {
  return this._svg;
};

SVGRenderer_prototype.svg = function() {
  if (!this._svg) return null;

  var attr = {
    class:   'marks',
    width:   this._width * this._scale,
    height:  this._height * this._scale,
    viewBox: '0 0 ' + this._width + ' ' + this._height
  };
  for (var key in svg_metadata) {
    attr[key] = svg_metadata[key];
  }

  var bg = !this._bgcolor ? ''
    : (openTag('rect', {
        width:  this._width,
        height: this._height,
        fill:   this._bgcolor
      }) + closeTag('rect'));

  return openTag('svg', attr)
    + (this._defs.el ? this._defs.el.outerHTML : '')
    + bg
    + this._root.outerHTML
    + closeTag('svg');
};


// -- Render entry point --

SVGRenderer_prototype._render = function(scene) {
  // perform spot updates and re-render markup
  if (this._dirtyCheck()) {
    if (this._dirtyAll) this._resetDefs();
    this.draw(this._root, scene);
    domClear(this._root, 1);
  }

  this.updateDefs();

  this._dirty = [];
  ++this._dirtyID;

  return this;
};

// -- Manage SVG definitions ('defs') block --

SVGRenderer_prototype.updateDefs = function() {
  const svg = this._svg,
        defs = this._defs;

  let el = defs.el,
      index = 0;

  for (const id in defs.gradient) {
    if (!el) defs.el = (el = domChild(svg, RootIndex, 'defs', ns));
    index = updateGradient(el, defs.gradient[id], index);
  }

  for (const id in defs.clipping) {
    if (!el) defs.el = (el = domChild(svg, RootIndex, 'defs', ns));
    index = updateClipping(el, defs.clipping[id], index);
  }

  // clean-up
  if (el) {
    index === 0
      ? (svg.removeChild(el), defs.el = null)
      : domClear(el, index);
  }
};

function updateGradient(el, grad, index) {
  var i, n, stop;

  if (grad.gradient === 'radial') {
    // SVG radial gradients automatically transform to normalized bbox
    // coordinates, in a way that is cumbersome to replicate in canvas.
    // We wrap the radial gradient in a pattern element, allowing us to
    // maintain a circular gradient that matches what canvas provides.
    var pt = domChild(el, index++, 'pattern', ns);
    pt.setAttribute('id', patternPrefix + grad.id);
    pt.setAttribute('viewBox', '0,0,1,1');
    pt.setAttribute('width', '100%');
    pt.setAttribute('height', '100%');
    pt.setAttribute('preserveAspectRatio', 'xMidYMid slice');

    pt = domChild(pt, 0, 'rect', ns);
    pt.setAttribute('width', '1');
    pt.setAttribute('height', '1');
    pt.setAttribute('fill', 'url(' + SVGRenderer_href() + '#' + grad.id + ')');

    el = domChild(el, index++, 'radialGradient', ns);
    el.setAttribute('id', grad.id);
    el.setAttribute('fx', grad.x1);
    el.setAttribute('fy', grad.y1);
    el.setAttribute('fr', grad.r1);
    el.setAttribute('cx', grad.x2);
    el.setAttribute('cy', grad.y2);
    el.setAttribute( 'r', grad.r2);
  } else {
    el = domChild(el, index++, 'linearGradient', ns);
    el.setAttribute('id', grad.id);
    el.setAttribute('x1', grad.x1);
    el.setAttribute('x2', grad.x2);
    el.setAttribute('y1', grad.y1);
    el.setAttribute('y2', grad.y2);
  }

  for (i=0, n=grad.stops.length; i<n; ++i) {
    stop = domChild(el, i, 'stop', ns);
    stop.setAttribute('offset', grad.stops[i].offset);
    stop.setAttribute('stop-color', grad.stops[i].color);
  }
  domClear(el, i);

  return index;
}

function updateClipping(el, clip, index) {
  var mask;

  el = domChild(el, index, 'clipPath', ns);
  el.setAttribute('id', clip.id);

  if (clip.path) {
    mask = domChild(el, 0, 'path', ns);
    mask.setAttribute('d', clip.path);
  } else {
    mask = domChild(el, 0, 'rect', ns);
    mask.setAttribute('x', 0);
    mask.setAttribute('y', 0);
    mask.setAttribute('width', clip.width);
    mask.setAttribute('height', clip.height);
  }
  domClear(el, 1);

  return index + 1;
}

SVGRenderer_prototype._resetDefs = function() {
  var def = this._defs;
  def.gradient = {};
  def.clipping = {};
};


// -- Manage rendering of items marked as dirty --

SVGRenderer_prototype.dirty = function(item) {
  if (item.dirty !== this._dirtyID) {
    item.dirty = this._dirtyID;
    this._dirty.push(item);
  }
};

SVGRenderer_prototype.isDirty = function(item) {
  return this._dirtyAll
    || !item._svg
    || item.dirty === this._dirtyID;
};

SVGRenderer_prototype._dirtyCheck = function() {
  this._dirtyAll = true;
  var items = this._dirty;
  if (!items.length || !this._dirtyID) return true;

  var id = ++this._dirtyID,
      item, mark, type, mdef, i, n, o;

  for (i=0, n=items.length; i<n; ++i) {
    item = items[i];
    mark = item.mark;

    if (mark.marktype !== type) {
      // memoize mark instance lookup
      type = mark.marktype;
      mdef = src_marks[type];
    }

    if (mark.zdirty && mark.dirty !== id) {
      this._dirtyAll = false;
      dirtyParents(item, id);
      mark.items.forEach(function(i) { i.dirty = id; });
    }
    if (mark.zdirty) continue; // handle in standard drawing pass

    if (item.exit) { // EXIT
      if (mdef.nested && mark.items.length) {
        // if nested mark with remaining points, update instead
        o = mark.items[0];
        if (o._svg) this._update(mdef, o._svg, o);
      } else if (item._svg) {
        // otherwise remove from DOM
        o = item._svg.parentNode;
        if (o) o.removeChild(item._svg);
      }
      item._svg = null;
      continue;
    }

    item = (mdef.nested ? mark.items[0] : item);
    if (item._update === id) continue; // already visited

    if (!item._svg || !item._svg.ownerSVGElement) {
      // ENTER
      this._dirtyAll = false;
      dirtyParents(item, id);
    } else {
      // IN-PLACE UPDATE
      this._update(mdef, item._svg, item);
    }
    item._update = id;
  }
  return !this._dirtyAll;
};

function dirtyParents(item, id) {
  for (; item && item.dirty !== id; item=item.mark.group) {
    item.dirty = id;
    if (item.mark && item.mark.dirty !== id) {
      item.mark.dirty = id;
    } else return;
  }
}


// -- Construct & maintain scenegraph to SVG mapping ---

// Draw a mark container.
SVGRenderer_prototype.draw = function(el, scene, prev) {
  if (!this.isDirty(scene)) return scene._svg;

  var svg = this._svg,
      mdef = src_marks[scene.marktype],
      events = scene.interactive === false ? 'none' : null,
      isGroup = mdef.tag === 'g',
      sibling = null,
      i = 0,
      parent;

  parent = SVGRenderer_bind(scene, el, prev, 'g', svg);
  parent.setAttribute('class', cssClass(scene));

  // apply aria attributes to parent container element
  const aria = ariaMarkAttributes(scene);
  for (const key in aria) setAttribute(parent, key, aria[key]);

  if (!isGroup) {
    setAttribute(parent, 'pointer-events', events);
  }
  setAttribute(parent, 'clip-path',
    scene.clip ? svg_clip(this, scene, scene.group) : null);

  const process = item => {
    const dirty = this.isDirty(item),
          node = SVGRenderer_bind(item, parent, sibling, mdef.tag, svg);

    if (dirty) {
      this._update(mdef, node, item);
      if (isGroup) recurse(this, node, item);
    }

    sibling = node;
    ++i;
  };

  if (mdef.nested) {
    if (scene.items.length) process(scene.items[0]);
  } else {
    visit_visit(scene, process);
  }

  domClear(parent, i);
  return parent;
};

// Recursively process group contents.
function recurse(renderer, el, group) {
  el = el.lastChild.previousSibling;
  let prev, idx = 0;

  visit_visit(group, item => {
    prev = renderer.draw(el, item, prev);
    ++idx;
  });

  // remove any extraneous DOM elements
  domClear(el, 1 + idx);
}

// Bind a scenegraph item to an SVG DOM element.
// Create new SVG elements as needed.
function SVGRenderer_bind(item, el, sibling, tag, svg) {
  let node = item._svg, doc;

  // create a new dom node if needed
  if (!node) {
    doc = el.ownerDocument;
    node = domCreate(doc, tag, ns);
    item._svg = node;

    if (item.mark) {
      node.__data__ = item;
      node.__values__ = {fill: 'default'};

      // if group, create background, content, and foreground elements
      if (tag === 'g') {
        const bg = domCreate(doc, 'path', ns);
        node.appendChild(bg);
        bg.__data__ = item;

        const cg = domCreate(doc, 'g', ns);
        node.appendChild(cg);
        cg.__data__ = item;

        const fg = domCreate(doc, 'path', ns);
        node.appendChild(fg);
        fg.__data__ = item;
        fg.__values__ = {fill: 'default'};
      }
    }
  }

  // (re-)insert if (a) not contained in SVG or (b) sibling order has changed
  if (node.ownerSVGElement !== svg || siblingCheck(node, sibling)) {
    el.insertBefore(node, sibling ? sibling.nextSibling : el.firstChild);
  }

  return node;
}

function siblingCheck(node, sibling) {
  return node.parentNode
    && node.parentNode.childNodes.length > 1
    && node.previousSibling != sibling; // treat null/undefined the same
}


// -- Set attributes & styles on SVG elements ---

var SVGRenderer_element = null, // temp var for current SVG element
    SVGRenderer_values = null;  // temp var for current values hash

// Extra configuration for certain mark types
var mark_extras = {
  group: function(mdef, el, item) {
    const fg = SVGRenderer_element = el.childNodes[2];
    SVGRenderer_values = fg.__values__;
    mdef.foreground(SVGRenderer_emit, item, this);

    SVGRenderer_values = el.__values__; // use parent's values hash
    SVGRenderer_element = el.childNodes[1];
    mdef.content(SVGRenderer_emit, item, this);

    const bg = SVGRenderer_element = el.childNodes[0];
    mdef.background(SVGRenderer_emit, item, this);

    const value = item.mark.interactive === false ? 'none' : null;
    if (value !== SVGRenderer_values.events) {
      setAttribute(fg, 'pointer-events', value);
      setAttribute(bg, 'pointer-events', value);
      SVGRenderer_values.events = value;
    }

    if (item.strokeForeground && item.stroke) {
      const fill = item.fill;
      setAttribute(fg, 'display', null);

      // set style of background
      this.style(bg, item);
      setAttribute(bg, 'stroke', null);

      // set style of foreground
      if (fill) item.fill = null;
      SVGRenderer_values = fg.__values__;
      this.style(fg, item);
      if (fill) item.fill = fill;

      // leave element null to prevent downstream styling
      SVGRenderer_element = null;
    } else {
      // ensure foreground is ignored
      setAttribute(fg, 'display', 'none');
    }
  },
  image: function(mdef, el, item) {
    if (item.smooth === false) {
      setStyle(el, 'image-rendering', 'optimizeSpeed');
      setStyle(el, 'image-rendering', 'pixelated');
    } else {
      setStyle(el, 'image-rendering', null);
    }
  },
  text: function(mdef, el, item) {
    let tl = textLines(item),
        key, value, doc, lh;

    if (Object(vega_util["A" /* isArray */])(tl)) {
      // multi-line text
      value = tl.map(_ => textValue(item, _));
      key = value.join('\n'); // content cache key

      if (key !== SVGRenderer_values.text) {
        domClear(el, 0);
        doc = el.ownerDocument;
        lh = lineHeight(item);
        value.forEach((t, i) => {
          const ts = domCreate(doc, 'tspan', ns);
          ts.__data__ = item; // data binding
          ts.textContent = t;
          if (i) {
            ts.setAttribute('x', 0);
            ts.setAttribute('dy', lh);
          }
          el.appendChild(ts);
        });
        SVGRenderer_values.text = key;
      }
    } else {
      // single-line text
      value = textValue(item, tl);
      if (value !== SVGRenderer_values.text) {
        el.textContent = value;
        SVGRenderer_values.text = value;
      }
    }

    setAttribute(el, 'font-family', fontFamily(item));
    setAttribute(el, 'font-size', text_fontSize(item) + 'px');
    setAttribute(el, 'font-style', item.fontStyle);
    setAttribute(el, 'font-variant', item.fontVariant);
    setAttribute(el, 'font-weight', item.fontWeight);
  }
};

function setStyle(el, name, value) {
  if (value !== SVGRenderer_values[name]) {
    if (value == null) {
      el.style.removeProperty(name);
    } else {
      el.style.setProperty(name, value + '');
    }
    SVGRenderer_values[name] = value;
  }
}

SVGRenderer_prototype._update = function(mdef, el, item) {
  // set dom element and values cache
  // provides access to emit method
  SVGRenderer_element = el;
  SVGRenderer_values = el.__values__;

  // apply aria-specific properties
  ariaItemAttributes(SVGRenderer_emit, item);

  // apply svg attributes
  mdef.attr(SVGRenderer_emit, item, this);

  // some marks need special treatment
  const extra = mark_extras[mdef.type];
  if (extra) extra.call(this, mdef, el, item);

  // apply svg style attributes
  // note: element may be modified by 'extra' method
  if (SVGRenderer_element) this.style(SVGRenderer_element, item);
};

function SVGRenderer_emit(name, value, ns) {
  // early exit if value is unchanged
  if (value === SVGRenderer_values[name]) return;

  // use appropriate method given namespace (ns)
  if (ns) {
    setAttributeNS(SVGRenderer_element, name, value, ns);
  } else {
    setAttribute(SVGRenderer_element, name, value);
  }

  // note current value for future comparison
  SVGRenderer_values[name] = value;
}

function setAttribute(el, name, value) {
  if (value != null) {
    // if value is provided, update DOM attribute
    el.setAttribute(name, value);
  } else {
    // else remove DOM attribute
    el.removeAttribute(name);
  }
}

function setAttributeNS(el, name, value, ns) {
  if (value != null) {
    // if value is provided, update DOM attribute
    el.setAttributeNS(ns, name, value);
  } else {
    // else remove DOM attribute
    el.removeAttributeNS(ns, name);
  }
}

SVGRenderer_prototype.style = function(el, o) {
  if (o == null) return;

  for (const prop in styles) {
    let value = prop === 'font' ? fontFamily(o) : o[prop];
    if (value === SVGRenderer_values[prop]) continue;

    const name = styles[prop];
    if (value == null) {
      el.removeAttribute(name);
    } else {
      if (isGradient(value)) {
        value = gradientRef(value, this._defs.gradient, SVGRenderer_href());
      }
      el.setAttribute(name, value + '');
    }

    SVGRenderer_values[prop] = value;
  }
};

function SVGRenderer_href() {
  let loc;
  return typeof window === 'undefined' ? ''
    : (loc = window.location).hash ? loc.href.slice(0, -loc.hash.length)
    : loc.href;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/SVGStringRenderer.js













function SVGStringRenderer(loader) {
  Renderer_Renderer.call(this, loader);

  this._text = {
    head: '',
    bg:   '',
    root: '',
    foot: '',
    defs: '',
    body: ''
  };

  this._defs = {
    gradient: {},
    clipping: {}
  };
}

var SVGStringRenderer_prototype = Object(vega_util["y" /* inherits */])(SVGStringRenderer, Renderer_Renderer);
var SVGStringRenderer_base = Renderer_Renderer.prototype;

SVGStringRenderer_prototype.resize = function(width, height, origin, scaleFactor) {
  SVGStringRenderer_base.resize.call(this, width, height, origin, scaleFactor);
  var o = this._origin,
      t = this._text;

  var attr = {
    class:   'marks',
    width:   this._width * this._scale,
    height:  this._height * this._scale,
    viewBox: '0 0 ' + this._width + ' ' + this._height
  };
  for (var key in svg_metadata) {
    attr[key] = svg_metadata[key];
  }

  t.head = openTag('svg', attr);

  var bg = this._bgcolor;
  if (bg === 'transparent' || bg === 'none') bg = null;

  if (bg) {
    t.bg = openTag('rect', {
      width:  this._width,
      height: this._height,
      fill:   bg
    }) + closeTag('rect');
  } else {
    t.bg = '';
  }

  t.root = openTag('g', Object(vega_util["o" /* extend */])(
    {}, rootAttributes, {transform: 'translate(' + o + ')'}
  ));

  t.foot = closeTag('g') + closeTag('svg');

  return this;
};

SVGStringRenderer_prototype.background = function() {
  var rv = SVGStringRenderer_base.background.apply(this, arguments);
  if (arguments.length && this._text.head) {
    this.resize(this._width, this._height, this._origin, this._scale);
  }
  return rv;
};

SVGStringRenderer_prototype.svg = function() {
  var t = this._text;
  return t.head + t.defs + t.bg + t.root + t.body + t.foot;
};

SVGStringRenderer_prototype._render = function(scene) {
  this._text.body = this.mark(scene);
  this._text.defs = this.buildDefs();
  return this;
};

SVGStringRenderer_prototype.buildDefs = function() {
  let defs = '', tag;

  for (const id in this._defs.gradient) {
    const def = this._defs.gradient[id],
          stops = def.stops;

    if (def.gradient === 'radial') {
      // SVG radial gradients automatically transform to normalized bbox
      // coordinates, in a way that is cumbersome to replicate in canvas.
      // We wrap the radial gradient in a pattern element, allowing us to
      // maintain a circular gradient that matches what canvas provides.

      defs += openTag(tag = 'pattern', {
        id: patternPrefix + id,
        viewBox: '0,0,1,1',
        width: '100%',
        height: '100%',
        preserveAspectRatio: 'xMidYMid slice'
      });

      defs += openTag('rect', {
        width:  '1',
        height: '1',
        fill:   'url(#' + id + ')'
      }) + closeTag('rect');

      defs += closeTag(tag);

      defs += openTag(tag = 'radialGradient', {
        id: id,
        fx: def.x1,
        fy: def.y1,
        fr: def.r1,
        cx: def.x2,
        cy: def.y2,
         r: def.r2
      });
    } else {
      defs += openTag(tag = 'linearGradient', {
        id: id,
        x1: def.x1,
        x2: def.x2,
        y1: def.y1,
        y2: def.y2
      });
    }

    for (let i = 0; i < stops.length; ++i) {
      defs += openTag('stop', {
        offset: stops[i].offset,
        'stop-color': stops[i].color
      }) + closeTag('stop');
    }

    defs += closeTag(tag);
  }

  for (const id in this._defs.clipping) {
    const def = this._defs.clipping[id];

    defs += openTag('clipPath', {id: id});

    if (def.path) {
      defs += openTag('path', {
        d: def.path
      }) + closeTag('path');
    } else {
      defs += openTag('rect', {
        x: 0,
        y: 0,
        width: def.width,
        height: def.height
      }) + closeTag('rect');
    }

    defs += closeTag('clipPath');
  }

  return defs ? (openTag('defs') + defs + closeTag('defs')) : '';
};

SVGStringRenderer_prototype.attr = function(scene, item, attrs, tag) {
  const object = {},
        emit = (name, value, ns, prefixed) => {
          object[prefixed || name] = value;
        };

  // apply mark specific attributes
  if (Array.isArray(attrs)) {
    attrs.forEach(fn => fn(emit, item, this));
  } else {
    attrs(emit, item, this);
  }

  // apply style attributes
  if (tag) {
    applyStyles(object, item, scene, tag, this._defs);
  }

  return object;
};

SVGStringRenderer_prototype.href = function(item) {
  var that = this,
      href = item.href,
      attr;

  if (href) {
    if (attr = that._hrefs && that._hrefs[href]) {
      return attr;
    } else {
      that.sanitizeURL(href).then(attr => {
        // rewrite to use xlink namespace
        // note that this will be deprecated in SVG 2.0
        attr['xlink:href'] = attr.href;
        attr.href = null;
        (that._hrefs || (that._hrefs = {}))[href] = attr;
      });
    }
  }
  return null;
};

SVGStringRenderer_prototype.mark = function(scene) {
  const mdef = src_marks[scene.marktype],
        tag  = mdef.tag,
        attrList = [ariaItemAttributes, mdef.attr];

  let str = '';

  // render opening group tag
  str += openTag('g', Object(vega_util["o" /* extend */])(
    {
      'class': cssClass(scene),
      'clip-path': scene.clip ? svg_clip(this, scene, scene.group) : null
    },
    ariaMarkAttributes(scene),
    {
      'pointer-events': tag !== 'g' && scene.interactive === false ? 'none' : null
    }
  ));

  // render contained elements
  const process = item => {
    const href = this.href(item);
    if (href) str += openTag('a', href);

    str += openTag(
      tag,
      this.attr(scene, item, attrList, tag !== 'g' ? tag : null)
    );

    if (tag === 'text') {
      const tl = textLines(item);
      if (Object(vega_util["A" /* isArray */])(tl)) {
        // multi-line text
        const attrs = {x: 0, dy: lineHeight(item)};
        for (let i=0; i<tl.length; ++i) {
          str += openTag('tspan', i ? attrs: null)
            + escape_text(textValue(item, tl[i]))
            + closeTag('tspan');
        }
      } else {
        // single-line text
        str += escape_text(textValue(item, tl));
      }
    } else if (tag === 'g') {
      const fore = item.strokeForeground,
            fill = item.fill,
            stroke = item.stroke;

      if (fore && stroke) {
        item.stroke = null;
      }

      str += openTag(
        'path',
        this.attr(scene, item, mdef.background, 'bgrect')
      ) + closeTag('path');

      str += openTag('g', this.attr(scene, item, mdef.content))
        + this.markGroup(item)
        + closeTag('g');

      if (fore && stroke) {
        if (fill) item.fill = null;
        item.stroke = stroke;

        str += openTag(
          'path',
          this.attr(scene, item, mdef.foreground, 'bgrect')
        ) + closeTag('path');

        if (fill) item.fill = fill;
      } else {
        str += openTag(
          'path',
          this.attr(scene, item, mdef.foreground, 'bgfore')
        ) + closeTag('path');
      }
    }

    str += closeTag(tag);
    if (href) str += closeTag('a');
  };

  if (mdef.nested) {
    if (scene.items && scene.items.length) process(scene.items[0]);
  } else {
    visit_visit(scene, process);
  }

  // render closing group tag
  return str + closeTag('g');
};

SVGStringRenderer_prototype.markGroup = function(scene) {
  let str = '';
  visit_visit(scene, item => { str += this.mark(item); });
  return str;
};

function applyStyles(s, item, scene, tag, defs) {
  if (item == null) return s;

  if (tag === 'bgrect' && scene.interactive === false) {
    s['pointer-events'] = 'none';
  }

  if (tag === 'bgfore') {
    if (scene.interactive === false) {
      s['pointer-events'] = 'none';
    }
    s.display = 'none';
    if (item.fill !== null) return s;
  }

  if (tag === 'image' && item.smooth === false) {
    s.style = 'image-rendering: optimizeSpeed; image-rendering: pixelated;';
  }

  if (tag === 'text') {
    s['font-family'] = fontFamily(item);
    s['font-size'] = text_fontSize(item) + 'px';
    if (item.fontStyle) s['font-style'] = item.fontStyle;
    if (item.fontVariant) s['font-variant'] = item.fontVariant;
    if (item.fontWeight) s['font-weight'] = item.fontWeight;
  }

  for (const prop in styles) {
    let value = item[prop];
    const name = styles[prop];

    if (value === 'transparent' && (name === 'fill' || name === 'stroke')) {
      // transparent is not a legal SVG value
      // we can skip it to rely on default 'none' instead
    } else if (value != null) {
      if (isGradient(value)) {
        value = gradientRef(value, defs.gradient, '');
      }
      s[name] = value;
    }
  }

  return s;
}

function escape_text(s) {
  return s.replace(/&/g, '&amp;')
          .replace(/</g, '&lt;')
          .replace(/>/g, '&gt;');
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/modules.js






var Canvas = 'canvas';
var PNG = 'png';
var SVG = 'svg';
var modules_None = 'none';

var RenderType = {
  Canvas: Canvas,
  PNG:    PNG,
  SVG:    SVG,
  None:   modules_None
};

var modules = {};

modules[Canvas] = modules[PNG] = {
  renderer: CanvasRenderer,
  headless: CanvasRenderer,
  handler:  CanvasHandler
};

modules[SVG] = {
  renderer: SVGRenderer,
  headless: SVGStringRenderer,
  handler:  SVGHandler
};

modules[modules_None] = {};

function renderModule(name, _) {
  name = String(name || '').toLowerCase();
  if (arguments.length > 1) {
    modules[name] = _;
    return this;
  } else {
    return modules[name];
  }
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/intersect.js




function intersect_intersect(scene, bounds, filter) {
  const hits = [], // intersection results
        box = new Bounds().union(bounds), // defensive copy
        type = scene.marktype;

  return type ? intersectMark(scene, box, filter, hits)
    : type === 'group' ? intersectGroup(scene, box, filter, hits)
    : Object(vega_util["n" /* error */])('Intersect scene must be mark node or group item.');
}

function intersectMark(mark, box, filter, hits) {
  if (visitMark(mark, box, filter)) {
    const items = mark.items,
          type = mark.marktype,
          n = items.length;

    let i = 0;

    if (type === 'group') {
      for (; i<n; ++i) {
        intersectGroup(items[i], box, filter, hits);
      }
    } else {
      for (const test = src_marks[type].isect; i<n; ++i) {
        let item = items[i];
        if (intersectItem(item, box, test)) hits.push(item);
      }
    }
  }
  return hits;
}

function visitMark(mark, box, filter) {
  // process if bounds intersect and if
  // (1) mark is a group mark (so we must recurse), or
  // (2) mark is interactive and passes filter
  return mark.bounds && box.intersects(mark.bounds) && (
    mark.marktype === 'group' ||
    mark.interactive !== false && (!filter || filter(mark))
  );
}

function intersectGroup(group, box, filter, hits) {
  // test intersect against group
  // skip groups by default unless filter says otherwise
  if ((filter && filter(group.mark)) &&
      intersectItem(group, box, src_marks.group.isect)) {
    hits.push(group);
  }

  // recursively test children marks
  // translate box to group coordinate space
  const marks = group.items,
        n = marks && marks.length;

  if (n) {
    const x = group.x || 0,
          y = group.y || 0;
    box.translate(-x, -y);
    for (let i=0; i<n; ++i) {
      intersectMark(marks[i], box, filter, hits);
    }
    box.translate(x, y);
  }

  return hits;
}

function intersectItem(item, box, test) {
  // test bounds enclosure, bounds intersection, then detailed test
  const bounds = item.bounds;
  return box.encloses(bounds) || (box.intersects(bounds) && test(item, box));
}


// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/bound/boundClip.js




var clipBounds = new Bounds();

/* harmony default export */ var boundClip = (function(mark) {
  var clip = mark.clip;

  if (Object(vega_util["D" /* isFunction */])(clip)) {
    clip(boundContext_context(clipBounds.clear()));
  } else if (clip) {
    clipBounds.set(0, 0, mark.group.width, mark.group.height);
  } else return;

  mark.bounds.intersect(clipBounds);
});

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/src/util/equal.js



var TOLERANCE = 1e-9;

function sceneEqual(a, b, key) {
  return (a === b) ? true
    : (key === 'path') ? pathEqual(a, b)
    : (a instanceof Date && b instanceof Date) ? +a === +b
    : (Object(vega_util["E" /* isNumber */])(a) && Object(vega_util["E" /* isNumber */])(b)) ? Math.abs(a - b) <= TOLERANCE
    : (!a || !b || !Object(vega_util["F" /* isObject */])(a) && !Object(vega_util["F" /* isObject */])(b)) ? a == b
    : (a == null || b == null) ? false
    : objectEqual(a, b);
}

function pathEqual(a, b) {
  return sceneEqual(path_parse(a), path_parse(b));
}

function objectEqual(a, b) {
  var ka = Object.keys(a),
      kb = Object.keys(b),
      key, i;

  if (ka.length !== kb.length) return false;

  ka.sort();
  kb.sort();

  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] != kb[i]) return false;
  }

  for (i = ka.length - 1; i >= 0; i--) {
    key = ka[i];
    if (!sceneEqual(a[key], b[key], key)) return false;
  }

  return typeof a === typeof b;
}

// CONCATENATED MODULE: ./node_modules/vega-scenegraph/index.js













































// deprecated, remove in next major version


function resetSVGDefIds() {
  resetSVGClipId();
  resetSVGGradientId();
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/Bound.js





/**
 * Calculate bounding boxes for scenegraph items.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {object} params.mark - The scenegraph mark instance to bound.
 */
function Bound(params) {
  Transform.call(this, null, params);
}

var Bound_prototype = Object(vega_util["y" /* inherits */])(Bound, Transform);

Bound_prototype.transform = function(_, pulse) {
  var view = pulse.dataflow,
      mark = _.mark,
      type = mark.marktype,
      entry = src_marks[type],
      bound = entry.bound,
      markBounds = mark.bounds, rebound;

  if (entry.nested) {
    // multi-item marks have a single bounds instance
    if (mark.items.length) view.dirty(mark.items[0]);
    markBounds = Bound_boundItem(mark, bound);
    mark.items.forEach(function(item) {
      item.bounds.clear().union(markBounds);
    });
  }

  else if (type === Group || _.modified()) {
    // operator parameters modified -> re-bound all items
    // updates group bounds in response to modified group content
    pulse.visit(pulse.MOD, item => view.dirty(item));
    markBounds.clear();
    mark.items.forEach(item => markBounds.union(Bound_boundItem(item, bound)));

    // force reflow for axes/legends/titles to propagate any layout changes
    switch (mark.role) {
      case AxisRole:
      case LegendRole:
      case TitleRole:
        pulse.reflow();
    }
  }

  else {
    // incrementally update bounds, re-bound mark as needed
    rebound = pulse.changed(pulse.REM);

    pulse.visit(pulse.ADD, item => {
      markBounds.union(Bound_boundItem(item, bound));
    });

    pulse.visit(pulse.MOD, item => {
      rebound = rebound || markBounds.alignsWith(item.bounds);
      view.dirty(item);
      markBounds.union(Bound_boundItem(item, bound));
    });

    if (rebound) {
      markBounds.clear();
      mark.items.forEach(item => markBounds.union(item.bounds));
    }
  }

  // ensure mark bounds do not exceed any clipping region
  boundClip(mark);

  return pulse.modifies('bounds');
};

function Bound_boundItem(item, bound, opt) {
  return bound(item.bounds.clear(), item, opt);
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/Identifier.js



var COUNTER_NAME = ':vega_identifier:';

/**
 * Adds a unique identifier to all added tuples.
 * This transform creates a new signal that serves as an id counter.
 * As a result, the id counter is shared across all instances of this
 * transform, generating unique ids across multiple data streams. In
 * addition, this signal value can be included in a snapshot of the
 * dataflow state, enabling correct resumption of id allocation.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {string} params.as - The field name for the generated identifier.
 */
function Identifier(params) {
  Transform.call(this, 0, params);
}

Identifier.Definition = {
  'type': 'Identifier',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'as', 'type': 'string', 'required': true }
  ]
};

var Identifier_prototype = Object(vega_util["y" /* inherits */])(Identifier, Transform);

Identifier_prototype.transform = function(_, pulse) {
  var counter = getCounter(pulse.dataflow),
      id = counter.value,
      as = _.as;

  pulse.visit(pulse.ADD, t => {
    if (!t[as]) t[as] = ++id;
  });

  counter.set(this.value = id);
  return pulse;
};

function getCounter(view) {
  var counter = view._signals[COUNTER_NAME];
  if (!counter) {
    view._signals[COUNTER_NAME] = (counter = view.add(0));
  }
  return counter;
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/Mark.js





/**
 * Bind scenegraph items to a scenegraph mark instance.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {object} params.markdef - The mark definition for creating the mark.
 *   This is an object of legal scenegraph mark properties which *must* include
 *   the 'marktype' property.
 */
function Mark(params) {
  Transform.call(this, null, params);
}

var Mark_prototype = Object(vega_util["y" /* inherits */])(Mark, Transform);

Mark_prototype.transform = function(_, pulse) {
  var mark = this.value;

  // acquire mark on first invocation, bind context and group
  if (!mark) {
    mark = pulse.dataflow.scenegraph().mark(_.markdef, Mark_lookup(_), _.index);
    mark.group.context = _.context;
    if (!_.context.group) _.context.group = mark.group;
    mark.source = this.source; // point to upstream collector
    mark.clip = _.clip;
    mark.interactive = _.interactive;
    this.value = mark;
  }

  // initialize entering items
  var Init = mark.marktype === Group ? GroupItem : Item;
  pulse.visit(pulse.ADD, item => Init.call(item, mark));

  // update clipping and/or interactive status
  if (_.modified('clip') || _.modified('interactive')) {
    mark.clip = _.clip;
    mark.interactive = !!_.interactive;
    mark.zdirty = true; // force scenegraph re-eval
    pulse.reflow();
  }

  // bind items array to scenegraph mark
  mark.items = pulse.source;
  return pulse;
};

function Mark_lookup(_) {
  var g = _.groups, p = _.parent;
  return g && g.size === 1 ? g.get(Object.keys(g.object)[0])
    : g && p ? g.lookup(p)
    : null;
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/Overlap.js





/**
 * Analyze items for overlap, changing opacity to hide items with
 * overlapping bounding boxes. This transform will preserve at least
 * two items (e.g., first and last) even if overlap persists.
 * @param {object} params - The parameters for this operator.
 * @param {function(*,*): number} [params.sort] - A comparator
 *   function for sorting items.
 * @param {object} [params.method] - The overlap removal method to apply.
 *   One of 'parity' (default, hide every other item until there is no
 *   more overlap) or 'greedy' (sequentially scan and hide and items that
 *   overlap with the last visible item).
 * @param {object} [params.boundScale] - A scale whose range should be used
 *   to bound the items. Items exceeding the bounds of the scale range
 *   will be treated as overlapping. If null or undefined, no bounds check
 *   will be applied.
 * @param {object} [params.boundOrient] - The orientation of the scale
 *   (top, bottom, left, or right) used to bound items. This parameter is
 *   ignored if boundScale is null or undefined.
 * @param {object} [params.boundTolerance] - The tolerance in pixels for
 *   bound inclusion testing (default 1). This specifies by how many pixels
 *   an item's bounds may exceed the scale range bounds and not be culled.
 * @constructor
 */
function Overlap(params) {
  Transform.call(this, null, params);
}

var Overlap_prototype = Object(vega_util["y" /* inherits */])(Overlap, Transform);

var methods = {
  parity: items => {
    return items.filter((item, i) => i % 2 ? (item.opacity = 0) : 1);
  },
  greedy: (items, sep) => {
    var a;
    return items.filter((b, i) => {
      if (!i || !Overlap_intersect(a.bounds, b.bounds, sep)) {
        a = b;
        return 1;
      } else {
        return b.opacity = 0;
      }
    });
  }
};

// compute bounding box intersection
// including padding pixels of separation
function Overlap_intersect(a, b, sep) {
  return sep > Math.max(
    b.x1 - a.x2,
    a.x1 - b.x2,
    b.y1 - a.y2,
    a.y1 - b.y2
  );
}

function hasOverlap(items, pad) {
  for (var i=1, n=items.length, a=items[0].bounds, b; i<n; a=b, ++i) {
    if (Overlap_intersect(a, b = items[i].bounds, pad)) return true;
  }
}

function hasBounds(item) {
  var b = item.bounds;
  return b.width() > 1 && b.height() > 1;
}

function boundTest(scale, orient, tolerance) {
  var range = scale.range(),
      b = new Bounds();

  if (orient === Top || orient === Bottom) {
    b.set(range[0], -Infinity, range[1], +Infinity);
  } else {
    b.set(-Infinity, range[0], +Infinity, range[1]);
  }
  b.expand(tolerance || 1);

  return item => b.encloses(item.bounds);
}

// reset all items to be fully opaque
function Overlap_reset(source) {
  source.forEach(item => item.opacity = 1);
  return source;
}

// add all tuples to mod, fork pulse if parameters were modified
// fork prevents cross-stream tuple pollution (e.g., pulse from scale)
function Overlap_reflow(pulse, _) {
  return pulse.reflow(_.modified()).modifies('opacity');
}

Overlap_prototype.transform = function(_, pulse) {
  var reduce = methods[_.method] || methods.parity,
      source = pulse.materialize(pulse.SOURCE).source,
      sep = _.separation || 0,
      items, test, bounds;

  if (!source || !source.length) return;

  if (!_.method) {
    // early exit if method is falsy
    if (_.modified('method')) {
      Overlap_reset(source);
      pulse = Overlap_reflow(pulse, _);
    }
    return pulse;
  }

  // skip labels with no content
  source = source.filter(hasBounds);

  // early exit, nothing to do
  if (!source.length) return;

  if (_.sort) {
    source = source.slice().sort(_.sort);
  }

  items = Overlap_reset(source);
  pulse = Overlap_reflow(pulse, _);

  if (items.length >= 3 && hasOverlap(items, sep)) {
    do {
      items = reduce(items, sep);
    } while (items.length >= 3 && hasOverlap(items, sep));

    if (items.length < 3 && !Object(vega_util["U" /* peek */])(source).opacity) {
      if (items.length > 1) Object(vega_util["U" /* peek */])(items).opacity = 0;
      Object(vega_util["U" /* peek */])(source).opacity = 1;
    }
  }

  if (_.boundScale && _.boundTolerance >= 0) {
    test = boundTest(_.boundScale, _.boundOrient, +_.boundTolerance);
    source.forEach(item => {
      if (!test(item)) item.opacity = 0;
    });
  }

  // re-calculate mark bounds
  bounds = items[0].mark.bounds.clear();
  source.forEach(item => {
    if (item.opacity) bounds.union(item.bounds);
  });

  return pulse;
};

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/Render.js



/**
 * Queue modified scenegraph items for rendering.
 * @constructor
 */
function Render(params) {
  Transform.call(this, null, params);
}

var Render_prototype = Object(vega_util["y" /* inherits */])(Render, Transform);

Render_prototype.transform = function(_, pulse) {
  var view = pulse.dataflow;

  pulse.visit(pulse.ALL, item => view.dirty(item));

  // set z-index dirty flag as needed
  if (pulse.fields && pulse.fields['zindex']) {
    var item = pulse.source && pulse.source[0];
    if (item) item.mark.zdirty = true;
  }
};

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/layout/util.js


const util_tempBounds = new Bounds();

function util_set(item, property, value) {
  return item[property] === value ? 0
    : (item[property] = value, 1);
}
// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/layout/axis.js




function isYAxis(mark) {
  var orient = mark.items[0].orient;
  return orient === Left || orient === Right;
}

function axisIndices(datum) {
  var index = +datum.grid;
  return [
    datum.ticks  ? index++ : -1, // ticks index
    datum.labels ? index++ : -1, // labels index
    index + (+datum.domain)      // title index
  ];
}

function axisLayout(view, axis, width, height) {  
  var item = axis.items[0],
      datum = item.datum,
      delta = item.translate != null ? item.translate : 0.5,
      orient = item.orient,
      indices = axisIndices(datum),
      range = item.range,
      offset = item.offset,
      position = item.position,
      minExtent = item.minExtent,
      maxExtent = item.maxExtent,
      title = datum.title && item.items[indices[2]].items[0],
      titlePadding = item.titlePadding,
      bounds = item.bounds,
      dl = title && multiLineOffset(title),
      x = 0, y = 0, i, s;

  util_tempBounds.clear().union(bounds);
  bounds.clear();
  if ((i=indices[0]) > -1) bounds.union(item.items[i].bounds);
  if ((i=indices[1]) > -1) bounds.union(item.items[i].bounds);

  // position axis group and title
  switch (orient) {
    case Top:
      x = position || 0;
      y = -offset;
      s = Math.max(minExtent, Math.min(maxExtent, -bounds.y1));
      bounds.add(0, -s).add(range, 0);
      if (title) axisTitleLayout(view, title, s, titlePadding, dl, 0, -1, bounds);
      break;
    case Left:
      x = -offset;
      y = position || 0;
      s = Math.max(minExtent, Math.min(maxExtent, -bounds.x1));
      bounds.add(-s, 0).add(0, range);
      if (title) axisTitleLayout(view, title, s, titlePadding, dl, 1, -1, bounds);
      break;
    case Right:
      x = width + offset;
      y = position || 0;
      s = Math.max(minExtent, Math.min(maxExtent, bounds.x2));
      bounds.add(0, 0).add(s, range);
      if (title) axisTitleLayout(view, title, s, titlePadding, dl, 1, 1, bounds);
      break;
    case Bottom:
      x = position || 0;
      y = height + offset;
      s = Math.max(minExtent, Math.min(maxExtent, bounds.y2));
      bounds.add(0, 0).add(range, s);
      if (title) axisTitleLayout(view, title, s, titlePadding, 0, 0, 1, bounds);
      break;
    default:
      x = item.x;
      y = item.y;
  }

  // update bounds
  boundStroke(bounds.translate(x, y), item);

  if (util_set(item, 'x', x + delta) | util_set(item, 'y', y + delta)) {
    item.bounds = util_tempBounds;
    view.dirty(item);
    item.bounds = bounds;
    view.dirty(item);
  }

  return item.mark.bounds.clear().union(bounds);
}

function axisTitleLayout(view, title, offset, pad, dl, isYAxis, sign, bounds) {
  const b = title.bounds;

  if (title.auto) {
    const v = sign * (offset + dl + pad);
    let dx = 0, dy = 0;

    view.dirty(title);
    isYAxis
      ? dx = (title.x || 0) - (title.x = v)
      : dy = (title.y || 0) - (title.y = v);
    title.mark.bounds.clear().union(b.translate(-dx, -dy));
    view.dirty(title);
  }

  bounds.union(b);
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/layout/grid.js





// aggregation functions for grid margin determination
const grid_min = (a, b) => Math.floor(Math.min(a, b));
const grid_max = (a, b) => Math.ceil(Math.max(a, b));

function gridLayoutGroups(group) {
  var groups = group.items,
      n = groups.length,
      i = 0, mark, items;

  var views = {
    marks:      [],
    rowheaders: [],
    rowfooters: [],
    colheaders: [],
    colfooters: [],
    rowtitle: null,
    coltitle: null
  };

  // layout axes, gather legends, collect bounds
  for (; i<n; ++i) {
    mark = groups[i];
    items = mark.items;
    if (mark.marktype === Group) {
      switch (mark.role) {
        case AxisRole:
        case LegendRole:
        case TitleRole:
          break;
        case RowHeader: views.rowheaders.push(...items); break;
        case RowFooter: views.rowfooters.push(...items); break;
        case ColHeader: views.colheaders.push(...items); break;
        case ColFooter: views.colfooters.push(...items); break;
        case RowTitle:  views.rowtitle = items[0]; break;
        case ColTitle:  views.coltitle = items[0]; break;
        default:        views.marks.push(...items);
      }
    }
  }

  return views;
}

function bboxFlush(item) {
  return new Bounds().set(0, 0, item.width || 0, item.height || 0);
}

function bboxFull(item) {
  var b = item.bounds.clone();
  return b.empty()
    ? b.set(0, 0, 0, 0)
    : b.translate(-(item.x || 0), -(item.y || 0));
}

function grid_get(opt, key, d) {
  var v = Object(vega_util["F" /* isObject */])(opt) ? opt[key] : opt;
  return v != null ? v : (d !== undefined ? d : 0);
}

function offsetValue(v) {
  return v < 0 ? Math.ceil(-v) : 0;
}

function gridLayout(view, groups, opt) {
  var dirty = !opt.nodirty,
      bbox = opt.bounds === Flush ? bboxFlush : bboxFull,
      bounds = util_tempBounds.set(0, 0, 0, 0),
      alignCol = grid_get(opt.align, Column),
      alignRow = grid_get(opt.align, Row),
      padCol = grid_get(opt.padding, Column),
      padRow = grid_get(opt.padding, Row),
      ncols = opt.columns || groups.length,
      nrows = ncols <= 0 ? 1 : Math.ceil(groups.length / ncols),
      n = groups.length,
      xOffset = Array(n), xExtent = Array(ncols), xMax = 0,
      yOffset = Array(n), yExtent = Array(nrows), yMax = 0,
      dx = Array(n), dy = Array(n), boxes = Array(n),
      m, i, c, r, b, g, px, py, x, y, offset;

  for (i=0; i<ncols; ++i) xExtent[i] = 0;
  for (i=0; i<nrows; ++i) yExtent[i] = 0;

  // determine offsets for each group
  for (i=0; i<n; ++i) {
    g = groups[i];
    b = boxes[i] = bbox(g);
    g.x = g.x || 0; dx[i] = 0;
    g.y = g.y || 0; dy[i] = 0;
    c = i % ncols;
    r = ~~(i / ncols);
    xMax = Math.max(xMax, px = Math.ceil(b.x2));
    yMax = Math.max(yMax, py = Math.ceil(b.y2));
    xExtent[c] = Math.max(xExtent[c], px);
    yExtent[r] = Math.max(yExtent[r], py);
    xOffset[i] = padCol + offsetValue(b.x1);
    yOffset[i] = padRow + offsetValue(b.y1);
    if (dirty) view.dirty(groups[i]);
  }

  // set initial alignment offsets
  for (i=0; i<n; ++i) {
    if (i % ncols === 0) xOffset[i] = 0;
    if (i < ncols) yOffset[i] = 0;
  }

  // enforce column alignment constraints
  if (alignCol === Each) {
    for (c=1; c<ncols; ++c) {
      for (offset=0, i=c; i<n; i += ncols) {
        if (offset < xOffset[i]) offset = xOffset[i];
      }
      for (i=c; i<n; i += ncols) {
        xOffset[i] = offset + xExtent[c-1];
      }
    }
  } else if (alignCol === All) {
    for (offset=0, i=0; i<n; ++i) {
      if (i % ncols && offset < xOffset[i]) offset = xOffset[i];
    }
    for (i=0; i<n; ++i) {
      if (i % ncols) xOffset[i] = offset + xMax;
    }
  } else {
    for (alignCol=false, c=1; c<ncols; ++c) {
      for (i=c; i<n; i += ncols) {
        xOffset[i] += xExtent[c-1];
      }
    }
  }

  // enforce row alignment constraints
  if (alignRow === Each) {
    for (r=1; r<nrows; ++r) {
      for (offset=0, i=r*ncols, m=i+ncols; i<m; ++i) {
        if (offset < yOffset[i]) offset = yOffset[i];
      }
      for (i=r*ncols; i<m; ++i) {
        yOffset[i] = offset + yExtent[r-1];
      }
    }
  } else if (alignRow === All) {
    for (offset=0, i=ncols; i<n; ++i) {
      if (offset < yOffset[i]) offset = yOffset[i];
    }
    for (i=ncols; i<n; ++i) {
      yOffset[i] = offset + yMax;
    }
  } else {
    for (alignRow=false, r=1; r<nrows; ++r) {
      for (i=r*ncols, m=i+ncols; i<m; ++i) {
        yOffset[i] += yExtent[r-1];
      }
    }
  }

  // perform horizontal grid layout
  for (x=0, i=0; i<n; ++i) {
    x = xOffset[i] + (i % ncols ? x : 0);
    dx[i] += x - groups[i].x;
  }

  // perform vertical grid layout
  for (c=0; c<ncols; ++c) {
    for (y=0, i=c; i<n; i += ncols) {
      y += yOffset[i];
      dy[i] += y - groups[i].y;
    }
  }

  // perform horizontal centering
  if (alignCol && grid_get(opt.center, Column) && nrows > 1) {
    for (i=0; i<n; ++i) {
      b = alignCol === All ? xMax : xExtent[i % ncols];
      x = b - boxes[i].x2 - groups[i].x - dx[i];
      if (x > 0) dx[i] += x / 2;
    }
  }

  // perform vertical centering
  if (alignRow && grid_get(opt.center, Row) && ncols !== 1) {
    for (i=0; i<n; ++i) {
      b = alignRow === All ? yMax : yExtent[~~(i / ncols)];
      y = b - boxes[i].y2 - groups[i].y - dy[i];
      if (y > 0) dy[i] += y / 2;
    }
  }

  // position grid relative to anchor
  for (i=0; i<n; ++i) {
    bounds.union(boxes[i].translate(dx[i], dy[i]));
  }
  x = grid_get(opt.anchor, constants_X);
  y = grid_get(opt.anchor, constants_Y);
  switch (grid_get(opt.anchor, Column)) {
    case End:    x -= bounds.width(); break;
    case Middle: x -= bounds.width() / 2;
  }
  switch (grid_get(opt.anchor, Row)) {
    case End:    y -= bounds.height(); break;
    case Middle: y -= bounds.height() / 2;
  }
  x = Math.round(x);
  y = Math.round(y);

  // update mark positions, bounds, dirty
  bounds.clear();
  for (i=0; i<n; ++i) {
    groups[i].mark.bounds.clear();
  }
  for (i=0; i<n; ++i) {
    g = groups[i];
    g.x += (dx[i] += x);
    g.y += (dy[i] += y);
    bounds.union(g.mark.bounds.union(g.bounds.translate(dx[i], dy[i])));
    if (dirty) view.dirty(g);
  }

  return bounds;
}

function trellisLayout(view, group, opt) {
  var views = gridLayoutGroups(group),
      groups = views.marks,
      bbox = opt.bounds === Flush ? boundFlush : boundFull,
      off = opt.offset,
      ncols = opt.columns || groups.length,
      nrows = ncols <= 0 ? 1 : Math.ceil(groups.length / ncols),
      cells = nrows * ncols,
      x, y, x2, y2, anchor, band, offset;

  // -- initial grid layout
  const bounds = gridLayout(view, groups, opt);
  if (bounds.empty()) bounds.set(0, 0, 0, 0); // empty grid

  // -- layout grid headers and footers --

  // perform row header layout
  if (views.rowheaders) {
    band = grid_get(opt.headerBand, Row, null);
    x = layoutHeaders(view, views.rowheaders, groups, ncols, nrows, -grid_get(off, 'rowHeader'), grid_min, 0, bbox, 'x1', 0, ncols, 1, band);
  }

  // perform column header layout
  if (views.colheaders) {
    band = grid_get(opt.headerBand, Column, null);
    y = layoutHeaders(view, views.colheaders, groups, ncols, ncols, -grid_get(off, 'columnHeader'), grid_min, 1, bbox, 'y1', 0, 1, ncols, band);
  }

  // perform row footer layout
  if (views.rowfooters) {
    band = grid_get(opt.footerBand, Row, null);
    x2 = layoutHeaders(view, views.rowfooters, groups, ncols, nrows,  grid_get(off, 'rowFooter'), grid_max, 0, bbox, 'x2', ncols-1, ncols, 1, band);
  }

  // perform column footer layout
  if (views.colfooters) {
    band = grid_get(opt.footerBand, Column, null);
    y2 = layoutHeaders(view, views.colfooters, groups, ncols, ncols,  grid_get(off, 'columnFooter'), grid_max, 1, bbox, 'y2', cells-ncols, 1, ncols, band);
  }

  // perform row title layout
  if (views.rowtitle) {
    anchor = grid_get(opt.titleAnchor, Row);
    offset = grid_get(off, 'rowTitle');
    offset = anchor === End ? x2 + offset : x - offset;
    band = grid_get(opt.titleBand, Row, 0.5);
    layoutTitle(view, views.rowtitle, offset, 0, bounds, band);
  }

  // perform column title layout
  if (views.coltitle) {
    anchor = grid_get(opt.titleAnchor, Column);
    offset = grid_get(off, 'columnTitle');
    offset = anchor === End ? y2 + offset : y - offset;
    band = grid_get(opt.titleBand, Column, 0.5);
    layoutTitle(view, views.coltitle, offset, 1, bounds, band);
  }
}

function boundFlush(item, field) {
  return field === 'x1' ? (item.x || 0)
    : field === 'y1' ? (item.y || 0)
    : field === 'x2' ? (item.x || 0) + (item.width || 0)
    : field === 'y2' ? (item.y || 0) + (item.height || 0)
    : undefined;
}

function boundFull(item, field) {
  return item.bounds[field];
}

function layoutHeaders(view, headers, groups, ncols, limit, offset, agg, isX, bound, bf, start, stride, back, band) {
  var n = groups.length,
      init = 0,
      edge = 0,
      i, j, k, m, b, h, g, x, y;

  // if no groups, early exit and return 0
  if (!n) return init;

  // compute margin
  for (i=start; i<n; i+=stride) {
    if (groups[i]) init = agg(init, bound(groups[i], bf));
  }

  // if no headers, return margin calculation
  if (!headers.length) return init;

  // check if number of headers exceeds number of rows or columns
  if (headers.length > limit) {
    view.warn('Grid headers exceed limit: ' + limit);
    headers = headers.slice(0, limit);
  }

  // apply offset
  init += offset;

  // clear mark bounds for all headers
  for (j=0, m=headers.length; j<m; ++j) {
    view.dirty(headers[j]);
    headers[j].mark.bounds.clear();
  }

  // layout each header
  for (i=start, j=0, m=headers.length; j<m; ++j, i+=stride) {
    h = headers[j];
    b = h.mark.bounds;

    // search for nearest group to align to
    // necessary if table has empty cells
    for (k=i; k >= 0 && (g = groups[k]) == null; k-=back);

    // assign coordinates and update bounds
    if (isX) {
      x = band == null ? g.x : Math.round(g.bounds.x1 + band * g.bounds.width());
      y = init;
    } else {
      x = init;
      y = band == null ? g.y : Math.round(g.bounds.y1 + band * g.bounds.height());
    }
    b.union(h.bounds.translate(x - (h.x || 0), y - (h.y || 0)));
    h.x = x;
    h.y = y;
    view.dirty(h);

    // update current edge of layout bounds
    edge = agg(edge, b[bf]);
  }

  return edge;
}

function layoutTitle(view, g, offset, isX, bounds, band) {
  if (!g) return;
  view.dirty(g);

  // compute title coordinates
  var x = offset, y = offset;
  isX
    ? (x = Math.round(bounds.x1 + band * bounds.width()))
    : (y = Math.round(bounds.y1 + band * bounds.height()));

  // assign coordinates and update bounds
  g.bounds.translate(x - (g.x || 0), y - (g.y || 0));
  g.mark.bounds.clear().union(g.bounds);
  g.x = x;
  g.y = y;

  // queue title for redraw
  view.dirty(g);
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/layout/legend.js



// utility for looking up legend layout configuration
function legend_lookup(config, orient) {
  const opt = config[orient] || {};
  return (key, d) => opt[key] != null ? opt[key]
    : config[key] != null ? config[key]
    : d;
}

// if legends specify offset directly, use the maximum specified value
function offsets(legends, value) {
  var max = -Infinity;
  legends.forEach(item => {
    if (item.offset != null) max = Math.max(max, item.offset);
  });
  return max > -Infinity ? max : value;
}

function legendParams(g, orient, config, xb, yb, w, h) {
  const _ = legend_lookup(config, orient),
        offset = offsets(g, _('offset', 0)),
        anchor = _('anchor', Start),
        mult = anchor === End ? 1 : anchor === Middle ? 0.5 : 0;

  const p = {
    align:   Each,
    bounds:  _('bounds', Flush),
    columns: _('direction') === 'vertical' ? 1 : g.length,
    padding: _('margin', 8),
    center:  _('center'),
    nodirty: true
  };

  switch (orient) {
    case Left:
      p.anchor = {
        x: Math.floor(xb.x1) - offset, column: End,
        y: mult * (h || xb.height() + 2 * xb.y1), row: anchor
      };
      break;
    case Right:
      p.anchor = {
        x: Math.ceil(xb.x2) + offset,
        y: mult * (h || xb.height() + 2 * xb.y1), row: anchor
      };
      break;
    case Top:
      p.anchor = {
        y: Math.floor(yb.y1) - offset, row: End,
        x: mult * (w || yb.width() + 2 * yb.x1), column: anchor
      };
      break;
    case Bottom:
      p.anchor = {
        y: Math.ceil(yb.y2) + offset,
        x: mult * (w || yb.width() + 2 * yb.x1), column: anchor
      };
      break;
    case TopLeft:
      p.anchor = {x: offset, y: offset};
      break;
    case TopRight:
      p.anchor = {x: w - offset, y: offset, column: End};
      break;
    case BottomLeft:
      p.anchor = {x: offset, y: h - offset, row: End};
      break;
    case BottomRight:
      p.anchor = {x: w - offset, y: h - offset, column: End, row: End};
      break;
  }

  return p;
}

function legendLayout(view, legend) {
  var item = legend.items[0],
      datum = item.datum,
      orient = item.orient,
      bounds = item.bounds,
      x = item.x, y = item.y, w, h;

  // cache current bounds for later comparison
  item._bounds
    ? item._bounds.clear().union(bounds)
    : item._bounds = bounds.clone();
  bounds.clear();

  // adjust legend to accommodate padding and title
  legendGroupLayout(view, item, item.items[0].items[0]);

  // aggregate bounds to determine size, and include origin
  bounds = legendBounds(item, bounds);
  w = 2 * item.padding;
  h = 2 * item.padding;
  if (!bounds.empty()) {
    w = Math.ceil(bounds.width() + w);
    h = Math.ceil(bounds.height() + h);
  }

  if (datum.type === Symbols) {
    legendEntryLayout(item.items[0].items[0].items[0].items);
  }

  if (orient !== None) {
    item.x = x = 0;
    item.y = y = 0;
  }
  item.width = w;
  item.height = h;
  boundStroke(bounds.set(x, y, x + w, y + h), item);
  item.mark.bounds.clear().union(bounds);

  return item;
}

function legendBounds(item, b) {
  // aggregate item bounds
  item.items.forEach(_ => b.union(_.bounds));

  // anchor to legend origin
  b.x1 = item.padding;
  b.y1 = item.padding;

  return b;
}

function legendGroupLayout(view, item, entry) {
  var pad = item.padding,
      ex = pad - entry.x,
      ey = pad - entry.y;

  if (!item.datum.title) {
    if (ex || ey) legend_translate(view, entry, ex, ey);
  } else {
    var title = item.items[1].items[0],
        anchor = title.anchor,
        tpad = item.titlePadding || 0,
        tx = pad - title.x,
        ty = pad - title.y;

    switch (title.orient) {
      case Left:
        ex += Math.ceil(title.bounds.width()) + tpad;
        break;
      case Right:
      case Bottom:
        break;
      default:
        ey += title.bounds.height() + tpad;
    }
    if (ex || ey) legend_translate(view, entry, ex, ey);

    switch (title.orient) {
      case Left:
        ty += legendTitleOffset(item, entry, title, anchor, 1, 1);
        break;
      case Right:
        tx += legendTitleOffset(item, entry, title, End, 0, 0) + tpad;
        ty += legendTitleOffset(item, entry, title, anchor, 1, 1);
        break;
      case Bottom:
        tx += legendTitleOffset(item, entry, title, anchor, 0, 0);
        ty += legendTitleOffset(item, entry, title, End, -1, 0, 1) + tpad;
        break;
      default:
        tx += legendTitleOffset(item, entry, title, anchor, 0, 0);
    }
    if (tx || ty) legend_translate(view, title, tx, ty);

    // translate legend if title pushes into negative coordinates
    if ((tx = Math.round(title.bounds.x1 - pad)) < 0) {
      legend_translate(view, entry, -tx, 0);
      legend_translate(view, title, -tx, 0);
    }
  }
}

function legendTitleOffset(item, entry, title, anchor, y, lr, noBar) {
  const grad = item.datum.type !== 'symbol',
        vgrad = title.datum.vgrad,
        e = grad && (lr || !vgrad) && !noBar ? entry.items[0] : entry,
        s = e.bounds[y ? 'y2' : 'x2'] - item.padding,
        u = vgrad && lr ? s : 0,
        v = vgrad && lr ? 0 : s,
        o = y <= 0 ? 0 : multiLineOffset(title);

  return Math.round(anchor === Start ? u
    : anchor === End ? (v - o)
    : 0.5 * (s - o));
}

function legend_translate(view, item, dx, dy) {
  item.x += dx;
  item.y += dy;
  item.bounds.translate(dx, dy);
  item.mark.bounds.translate(dx, dy);
  view.dirty(item);
}

function legendEntryLayout(entries) {
  // get max widths for each column
  var widths = entries.reduce((w, g) => {
    w[g.column] = Math.max(g.bounds.x2 - g.x, w[g.column] || 0);
    return w;
  }, {});

  // set dimensions of legend entry groups
  entries.forEach(g => {
    g.width  = widths[g.column];
    g.height = g.bounds.y2 - g.y;
  });
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/layout/title.js



function titleLayout(view, mark, width, height, viewBounds) {
  var group = mark.items[0],
      frame = group.frame,
      orient = group.orient,
      anchor = group.anchor,
      offset = group.offset,
      padding = group.padding,
      title = group.items[0].items[0],
      subtitle = group.items[1] && group.items[1].items[0],
      end = (orient === Left || orient === Right) ? height : width,
      start = 0, x = 0, y = 0, sx = 0, sy = 0, pos;

  if (frame !== Group) {
    orient === Left ? (start = viewBounds.y2, end = viewBounds.y1)
      : orient === Right ? (start = viewBounds.y1, end = viewBounds.y2)
      : (start = viewBounds.x1, end = viewBounds.x2);
  } else if (orient === Left) {
    start = height, end = 0;
  }

  pos = (anchor === Start) ? start
    : (anchor === End) ? end
    : (start + end) / 2;

  if (subtitle && subtitle.text) {
    // position subtitle
    switch (orient) {
      case Top:
      case Bottom:
        sy = title.bounds.height() + padding;
        break;
      case Left:
        sx = title.bounds.width() + padding;
        break;
      case Right:
        sx = -title.bounds.width() - padding;
        break;
    }

    util_tempBounds.clear().union(subtitle.bounds);
    util_tempBounds.translate(sx - (subtitle.x || 0), sy - (subtitle.y || 0));
    if (util_set(subtitle, 'x', sx) | util_set(subtitle, 'y', sy)) {
      view.dirty(subtitle);
      subtitle.bounds.clear().union(util_tempBounds);
      subtitle.mark.bounds.clear().union(util_tempBounds);
      view.dirty(subtitle);
    }

    util_tempBounds.clear().union(subtitle.bounds);
  } else {
    util_tempBounds.clear();
  }
  util_tempBounds.union(title.bounds);

  // position title group
  switch (orient) {
    case Top:
      x = pos;
      y = viewBounds.y1 - util_tempBounds.height() - offset;
      break;
    case Left:
      x = viewBounds.x1 - util_tempBounds.width() - offset;
      y = pos;
      break;
    case Right:
      x = viewBounds.x2 + util_tempBounds.width() + offset;
      y = pos;
      break;
    case Bottom:
      x = pos;
      y = viewBounds.y2 + offset;
      break;
    default:
      x = group.x;
      y = group.y;
  }

  if (util_set(group, 'x', x) | util_set(group, 'y', y)) {
    util_tempBounds.translate(x, y);
    view.dirty(group);
    group.bounds.clear().union(util_tempBounds);
    mark.bounds.clear().union(util_tempBounds);
    view.dirty(group);
  }
  return group.bounds;
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/src/ViewLayout.js











/**
 * Layout view elements such as axes and legends.
 * Also performs size adjustments.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {object} params.mark - Scenegraph mark of groups to layout.
 */
function ViewLayout(params) {
  Transform.call(this, null, params);
}

var ViewLayout_prototype = Object(vega_util["y" /* inherits */])(ViewLayout, Transform);

ViewLayout_prototype.transform = function(_, pulse) {
  var view = pulse.dataflow;
  _.mark.items.forEach(group => {
    if (_.layout) trellisLayout(view, group, _.layout);
    layoutGroup(view, group, _);
  });
  return shouldReflow(_.mark.group) ? pulse.reflow() : pulse;
};

function shouldReflow(group) {
  // We typically should reflow if layout is invoked (#2568), as child items
  // may have resized and reflow ensures group bounds are re-calculated.
  // However, legend entries have a special exception to avoid instability.
  // For example, if a selected legend symbol gains a stroke on hover,
  // we don't want to re-position subsequent elements in the legend.
  return group && group.mark.role !== 'legend-entry';
}

function layoutGroup(view, group, _) {
  var items = group.items,
      width = Math.max(0, group.width || 0),
      height = Math.max(0, group.height || 0),
      viewBounds = new Bounds().set(0, 0, width, height),
      xBounds = viewBounds.clone(),
      yBounds = viewBounds.clone(),
      legends = [], title,
      mark, orient, b, i, n;

  // layout axes, gather legends, collect bounds
  for (i=0, n=items.length; i<n; ++i) {
    mark = items[i];
    switch (mark.role) {
      case AxisRole:
        b = isYAxis(mark) ? xBounds : yBounds;
        b.union(axisLayout(view, mark, width, height));
        break;
      case TitleRole:
        title = mark;
        break;
      case LegendRole:
        legends.push(legendLayout(view, mark));
        break;
      case FrameRole:
      case ScopeRole:
      case RowHeader:
      case RowFooter:
      case RowTitle:
      case ColHeader:
      case ColFooter:
      case ColTitle:
        xBounds.union(mark.bounds);
        yBounds.union(mark.bounds);
        break;
      default:
        viewBounds.union(mark.bounds);
    }
  }

  // layout legends, adjust viewBounds
  if (legends.length) {
    // group legends by orient
    const l = {};
    legends.forEach(item => {
      orient = item.orient || Right;
      if (orient !== None) (l[orient] || (l[orient] = [])).push(item);
    });

    // perform grid layout for each orient group
    for (let orient in l) {
      const g = l[orient];
      gridLayout(view, g, legendParams(
        g, orient, _.legends, xBounds, yBounds, width, height
      ));
    }

    // update view bounds
    legends.forEach(item => {
      const b = item.bounds;

      if (!b.equals(item._bounds)) {
        item.bounds = item._bounds;
        view.dirty(item); // dirty previous location
        item.bounds = b;
        view.dirty(item);
      }

      if (_.autosize && _.autosize.type === Fit) {
        // For autosize fit, incorporate the orthogonal dimension only.
        // Legends that overrun the chart area will then be clipped;
        // otherwise the chart area gets reduced to nothing!
        switch(item.orient) {
          case Left:
          case Right:
            viewBounds.add(b.x1, 0).add(b.x2, 0);
            break;
          case Top:
          case Bottom:
            viewBounds.add(0, b.y1).add(0, b.y2);
        }
      } else {
        viewBounds.union(b);
      }
    });
  }

  // combine bounding boxes
  viewBounds.union(xBounds).union(yBounds);

  // layout title, adjust bounds
  if (title) {
    viewBounds.union(titleLayout(view, title, width, height, viewBounds));
  }

  // override aggregated view bounds if content is clipped
  if (group.clip) {
    viewBounds.set(0, 0, group.width || 0, group.height || 0);
  }

  // perform size adjustment
  viewSizeLayout(view, group, viewBounds, _);
}

function viewSizeLayout(view, group, viewBounds, _) {
  const auto = _.autosize || {},
        type = auto.type;

  if (view._autosize < 1 || !type) return;

  let viewWidth = view._width,
      viewHeight = view._height,
      width  = Math.max(0, group.width || 0),
      left   = Math.max(0, Math.ceil(-viewBounds.x1)),
      right  = Math.max(0, Math.ceil(viewBounds.x2 - width)),
      height = Math.max(0, group.height || 0),
      top    = Math.max(0, Math.ceil(-viewBounds.y1)),
      bottom = Math.max(0, Math.ceil(viewBounds.y2 - height));

  if (auto.contains === Padding) {
    const padding = view.padding();
    viewWidth -= padding.left + padding.right;
    viewHeight -= padding.top + padding.bottom;
  }

  if (type === None) {
    left = 0;
    top = 0;
    width = viewWidth;
    height = viewHeight;
  }

  else if (type === Fit) {
    width = Math.max(0, viewWidth - left - right);
    height = Math.max(0, viewHeight - top - bottom);
  }

  else if (type === FitX) {
    width = Math.max(0, viewWidth - left - right);
    viewHeight = height + top + bottom;
  }

  else if (type === FitY) {
    viewWidth = width + left + right;
    height = Math.max(0, viewHeight - top - bottom);
  }

  else if (type === Pad) {
    viewWidth = width + left + right;
    viewHeight = height + top + bottom;
  }

  view._resizeView(
    viewWidth, viewHeight,
    width, height,
    [left, top],
    auto.resize
  );
}

// CONCATENATED MODULE: ./node_modules/vega-view-transforms/index.js







// CONCATENATED MODULE: ./node_modules/vega-encode/src/AxisTicks.js




/**
 * Generates axis ticks for visualizing a spatial scale.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Scale} params.scale - The scale to generate ticks for.
 * @param {*} [params.count=10] - The approximate number of ticks, or
 *   desired tick interval, to use.
 * @param {Array<*>} [params.values] - The exact tick values to use.
 *   These must be legal domain values for the provided scale.
 *   If provided, the count argument is ignored.
 * @param {function(*):string} [params.formatSpecifier] - A format specifier
 *   to use in conjunction with scale.tickFormat. Legal values are
 *   any valid d3 4.0 format specifier.
 * @param {function(*):string} [params.format] - The format function to use.
 *   If provided, the formatSpecifier argument is ignored.
 */
function AxisTicks(params) {
  Transform.call(this, null, params);
}

var AxisTicks_prototype = Object(vega_util["y" /* inherits */])(AxisTicks, Transform);

AxisTicks_prototype.transform = function(_, pulse) {
  if (this.value && !_.modified()) {
    return pulse.StopPropagation;
  }

  var locale = pulse.dataflow.locale(),
      out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      ticks = this.value,
      scale = _.scale,
      tally = _.count == null ? (_.values ? _.values.length : 10) : _.count,
      count = tickCount(scale, tally, _.minstep),
      format = _.format || ticks_tickFormat(locale, scale, count, _.formatSpecifier, _.formatType, !!_.values),
      values = _.values ? validTicks(scale, _.values, count) : tickValues(scale, count);

  if (ticks) out.rem = ticks;

  ticks = values.map(function(value, i) {
    return ingest({
      index: i / (values.length - 1 || 1),
      value: value,
      label: format(value)
    });
  });

  if (_.extra && ticks.length) {
    // add an extra tick pegged to the initial domain value
    // this is used to generate axes with 'binned' domains
    ticks.push(ingest({
      index: -1,
      extra: {value: ticks[0].value},
      label: ''
    }));
  }

  out.source = ticks;
  out.add = ticks;
  this.value = ticks;

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/DataJoin.js



/**
 * Joins a set of data elements against a set of visual items.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): object} [params.item] - An item generator function.
 * @param {function(object): *} [params.key] - The key field associating data and visual items.
 */
function DataJoin(params) {
  Transform.call(this, null, params);
}

var DataJoin_prototype = Object(vega_util["y" /* inherits */])(DataJoin, Transform);

function defaultItemCreate() {
  return ingest({});
}

function newMap(key) {
  const map = Object(vega_util["s" /* fastmap */])().test(t => t.exit);
  map.lookup = t => map.get(key(t));
  return map;
}

DataJoin_prototype.transform = function(_, pulse) {
  var df = pulse.dataflow,
      out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      item = _.item || defaultItemCreate,
      key = _.key || tupleid,
      map = this.value;

  // prevent transient (e.g., hover) requests from
  // cascading across marks derived from marks
  if (Object(vega_util["A" /* isArray */])(out.encode)) {
    out.encode = null;
  }

  if (map && (_.modified('key') || pulse.modified(key))) {
    Object(vega_util["n" /* error */])('DataJoin does not support modified key function or fields.');
  }

  if (!map) {
    pulse = pulse.addAll();
    this.value = map = newMap(key);
  }

  pulse.visit(pulse.ADD, t => {
    const k = key(t);
    let x = map.get(k);

    if (x) {
      if (x.exit) {
        map.empty--;
        out.add.push(x);
      } else {
        out.mod.push(x);
      }
    } else {
      x = item(t);
      map.set(k, x);
      out.add.push(x);
    }

    x.datum = t;
    x.exit = false;
  });

  pulse.visit(pulse.MOD, t => {
    const k = key(t),
          x = map.get(k);

    if (x) {
      x.datum = t;
      out.mod.push(x);
    }
  });

  pulse.visit(pulse.REM, t => {
    const k = key(t),
          x = map.get(k);

    if (t === x.datum && !x.exit) {
      out.rem.push(x);
      x.exit = true;
      ++map.empty;
    }
  });

  if (pulse.changed(pulse.ADD_MOD)) out.modifies('datum');

  if (pulse.clean() || _.clean && map.empty > df.cleanThreshold) {
    df.runAfter(map.clean);
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/Encode.js



/**
 * Invokes encoding functions for visual items.
 * @constructor
 * @param {object} params - The parameters to the encoding functions. This
 *   parameter object will be passed through to all invoked encoding functions.
 * @param {object} [params.mod=false] - Flag indicating if tuples in the input
 *   mod set that are unmodified by encoders should be included in the output.
 * @param {object} param.encoders - The encoding functions
 * @param {function(object, object): boolean} [param.encoders.update] - Update encoding set
 * @param {function(object, object): boolean} [param.encoders.enter] - Enter encoding set
 * @param {function(object, object): boolean} [param.encoders.exit] - Exit encoding set
 */
function Encode(params) {
  Transform.call(this, null, params);
}

var Encode_prototype = Object(vega_util["y" /* inherits */])(Encode, Transform);

Encode_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.ADD_REM),
      fmod = _.mod || false,
      encoders = _.encoders,
      encode = pulse.encode;

  // if an array, the encode directive includes additional sets
  // that must be defined in order for the primary set to be invoked
  // e.g., only run the update set if the hover set is defined
  if (Object(vega_util["A" /* isArray */])(encode)) {
    if (out.changed() || encode.every(function(e) { return encoders[e]; })) {
      encode = encode[0];
      out.encode = null; // consume targeted encode directive
    } else {
      return pulse.StopPropagation;
    }
  }

  // marshall encoder functions
  var reenter = encode === 'enter',
      update = encoders.update || vega_util["r" /* falsy */],
      enter = encoders.enter || vega_util["r" /* falsy */],
      exit = encoders.exit || vega_util["r" /* falsy */],
      set = (encode && !reenter ? encoders[encode] : update) || vega_util["r" /* falsy */];

  if (pulse.changed(pulse.ADD)) {
    pulse.visit(pulse.ADD, function(t) { enter(t, _); update(t, _); });
    out.modifies(enter.output);
    out.modifies(update.output);
    if (set !== vega_util["r" /* falsy */] && set !== update) {
      pulse.visit(pulse.ADD, function(t) { set(t, _); });
      out.modifies(set.output);
    }
  }

  if (pulse.changed(pulse.REM) && exit !== vega_util["r" /* falsy */]) {
    pulse.visit(pulse.REM, function(t) { exit(t, _); });
    out.modifies(exit.output);
  }

  if (reenter || set !== vega_util["r" /* falsy */]) {
    var flag = pulse.MOD | (_.modified() ? pulse.REFLOW : 0);
    if (reenter) {
      pulse.visit(flag, function(t) {
        var mod = enter(t, _) || fmod;
        if (set(t, _) || mod) out.mod.push(t);
      });
      if (out.mod.length) out.modifies(enter.output);
    } else {
      pulse.visit(flag, function(t) {
        if (set(t, _) || fmod) out.mod.push(t);
      });
    }
    if (out.mod.length) out.modifies(set.output);
  }

  return out.changed() ? out : pulse.StopPropagation;
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/LegendEntries.js




/**
 * Generates legend entries for visualizing a scale.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Scale} params.scale - The scale to generate items for.
 * @param {*} [params.count=5] - The approximate number of items, or
 *   desired tick interval, to use.
 * @param {*} [params.limit] - The maximum number of entries to
 *   include in a symbol legend.
 * @param {Array<*>} [params.values] - The exact tick values to use.
 *   These must be legal domain values for the provided scale.
 *   If provided, the count argument is ignored.
 * @param {string} [params.formatSpecifier] - A format specifier
 *   to use in conjunction with scale.tickFormat. Legal values are
 *   any valid D3 format specifier string.
 * @param {function(*):string} [params.format] - The format function to use.
 *   If provided, the formatSpecifier argument is ignored.
 */
function LegendEntries(params) {
  Transform.call(this, [], params);
}

var LegendEntries_prototype = Object(vega_util["y" /* inherits */])(LegendEntries, Transform);

LegendEntries_prototype.transform = function(_, pulse) {
  if (this.value != null && !_.modified()) {
    return pulse.StopPropagation;
  }

  var locale = pulse.dataflow.locale(),
      out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      items = this.value,
      type  = _.type || SymbolLegend,
      scale = _.scale,
      limit = +_.limit,
      count = tickCount(scale, _.count == null ? 5 : _.count, _.minstep),
      lskip = !!_.values || type === SymbolLegend,
      format = _.format || labelFormat(locale, scale, count, type, _.formatSpecifier, _.formatType, lskip),
      values = _.values || labelValues(scale, count),
      domain, fraction, size, offset, ellipsis;

  if (items) out.rem = items;

  if (type === SymbolLegend) {
    if (limit && values.length > limit) {
      pulse.dataflow.warn('Symbol legend count exceeds limit, filtering items.');
      items = values.slice(0, limit - 1);
      ellipsis = true;
    } else {
      items = values;
    }

    if (Object(vega_util["D" /* isFunction */])(size = _.size)) {
      // if first value maps to size zero, remove from list (vega#717)
      if (!_.values && scale(items[0]) === 0) {
        items = items.slice(1);
      }
      // compute size offset for legend entries
      offset = items.reduce(function(max, value) {
        return Math.max(max, size(value, _));
      }, 0);
    } else {
      size = Object(vega_util["l" /* constant */])(offset = size || 8);
    }

    items = items.map(function(value, index) {
      return ingest({
        index:  index,
        label:  format(value, index, items),
        value:  value,
        offset: offset,
        size:   size(value, _)
      });
    });

    if (ellipsis) {
      ellipsis = values[items.length];
      items.push(ingest({
        index:    items.length,
        label:    `\u2026${values.length-items.length} entries`,
        value:    ellipsis,
        offset:   offset,
        size:     size(ellipsis, _)
      }));
    }
  }

  else if (type === GradientLegend) {
    domain = scale.domain(),
    fraction = scaleFraction(scale, domain[0], Object(vega_util["U" /* peek */])(domain));

    // if automatic label generation produces 2 or fewer values,
    // use the domain end points instead (fixes vega/vega#1364)
    if (values.length < 3 && !_.values && domain[0] !== Object(vega_util["U" /* peek */])(domain)) {
      values = [domain[0], Object(vega_util["U" /* peek */])(domain)];
    }

    items = values.map(function(value, index) {
      return ingest({
        index: index,
        label: format(value, index, values),
        value: value,
        perc:  fraction(value)
      });
    });
  }

  else {
    size = values.length - 1;
    fraction = labelFraction(scale);

    items = values.map(function(value, index) {
      return ingest({
        index: index,
        label: format(value, index, values),
        value: value,
        perc:  index ? fraction(value) : 0,
        perc2: index === size ? 1 : fraction(values[index+1])
      });
    });
  }

  out.source = items;
  out.add = items;
  this.value = items;

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/LinkPath.js



var Paths = Object(vega_util["s" /* fastmap */])({
  'line': LinkPath_line,
  'line-radial': lineR,
  'arc': LinkPath_arc,
  'arc-radial': arcR,
  'curve': LinkPath_curve,
  'curve-radial': curveR,
  'orthogonal-horizontal': orthoX,
  'orthogonal-vertical': orthoY,
  'orthogonal-radial': orthoR,
  'diagonal-horizontal': diagonalX,
  'diagonal-vertical': diagonalY,
  'diagonal-radial': diagonalR
});

function sourceX(t) { return t.source.x; }
function sourceY(t) { return t.source.y; }
function targetX(t) { return t.target.x; }
function targetY(t) { return t.target.y; }

 /**
  * Layout paths linking source and target elements.
  * @constructor
  * @param {object} params - The parameters for this operator.
  */
function LinkPath(params) {
  Transform.call(this, {}, params);
}

LinkPath.Definition = {
  'type': 'LinkPath',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'sourceX', 'type': 'field', 'default': 'source.x' },
    { 'name': 'sourceY', 'type': 'field', 'default': 'source.y' },
    { 'name': 'targetX', 'type': 'field', 'default': 'target.x' },
    { 'name': 'targetY', 'type': 'field', 'default': 'target.y' },
    { 'name': 'orient', 'type': 'enum', 'default': 'vertical',
      'values': ['horizontal', 'vertical', 'radial'] },
    { 'name': 'shape', 'type': 'enum', 'default': 'line',
      'values': ['line', 'arc', 'curve', 'diagonal', 'orthogonal'] },
    { 'name': 'require', 'type': 'signal' },
    { 'name': 'as', 'type': 'string', 'default': 'path' }
  ]
};

var LinkPath_prototype = Object(vega_util["y" /* inherits */])(LinkPath, Transform);

LinkPath_prototype.transform = function(_, pulse) {
  var sx = _.sourceX || sourceX,
      sy = _.sourceY || sourceY,
      tx = _.targetX || targetX,
      ty = _.targetY || targetY,
      as = _.as || 'path',
      orient = _.orient || 'vertical',
      shape = _.shape || 'line',
      path = Paths.get(shape + '-' + orient) || Paths.get(shape);

  if (!path) {
    Object(vega_util["n" /* error */])('LinkPath unsupported type: ' + _.shape
      + (_.orient ? '-' + _.orient : ''));
  }

  pulse.visit(pulse.SOURCE, function(t) {
    t[as] = path(sx(t), sy(t), tx(t), ty(t));
  });

  return pulse.reflow(_.modified()).modifies(as);
};

// -- Link Path Generation Methods -----

function LinkPath_line(sx, sy, tx, ty) {
  return 'M' + sx + ',' + sy +
         'L' + tx + ',' + ty;
}

function lineR(sa, sr, ta, tr) {
  return LinkPath_line(
    sr * Math.cos(sa), sr * Math.sin(sa),
    tr * Math.cos(ta), tr * Math.sin(ta)
  );
}

function LinkPath_arc(sx, sy, tx, ty) {
  var dx = tx - sx,
      dy = ty - sy,
      rr = Math.sqrt(dx * dx + dy * dy) / 2,
      ra = 180 * Math.atan2(dy, dx) / Math.PI;
  return 'M' + sx + ',' + sy +
         'A' + rr + ',' + rr +
         ' ' + ra + ' 0 1' +
         ' ' + tx + ',' + ty;
}

function arcR(sa, sr, ta, tr) {
  return LinkPath_arc(
    sr * Math.cos(sa), sr * Math.sin(sa),
    tr * Math.cos(ta), tr * Math.sin(ta)
  );
}

function LinkPath_curve(sx, sy, tx, ty) {
  var dx = tx - sx,
      dy = ty - sy,
      ix = 0.2 * (dx + dy),
      iy = 0.2 * (dy - dx);
  return 'M' + sx + ',' + sy +
         'C' + (sx+ix) + ',' + (sy+iy) +
         ' ' + (tx+iy) + ',' + (ty-ix) +
         ' ' + tx + ',' + ty;
}

function curveR(sa, sr, ta, tr) {
  return LinkPath_curve(
    sr * Math.cos(sa), sr * Math.sin(sa),
    tr * Math.cos(ta), tr * Math.sin(ta)
  );
}

function orthoX(sx, sy, tx, ty) {
  return 'M' + sx + ',' + sy +
         'V' + ty + 'H' + tx;
}

function orthoY(sx, sy, tx, ty) {
  return 'M' + sx + ',' + sy +
         'H' + tx + 'V' + ty;
}

function orthoR(sa, sr, ta, tr) {
  var sc = Math.cos(sa),
      ss = Math.sin(sa),
      tc = Math.cos(ta),
      ts = Math.sin(ta),
      sf = Math.abs(ta - sa) > Math.PI ? ta <= sa : ta > sa;
  return 'M' + (sr*sc) + ',' + (sr*ss) +
         'A' + sr + ',' + sr + ' 0 0,' + (sf?1:0) +
         ' ' + (sr*tc) + ',' + (sr*ts) +
         'L' + (tr*tc) + ',' + (tr*ts);
}

function diagonalX(sx, sy, tx, ty) {
  var m = (sx + tx) / 2;
  return 'M' + sx + ',' + sy +
         'C' + m  + ',' + sy +
         ' ' + m  + ',' + ty +
         ' ' + tx + ',' + ty;
}

function diagonalY(sx, sy, tx, ty) {
  var m = (sy + ty) / 2;
  return 'M' + sx + ',' + sy +
         'C' + sx + ',' + m +
         ' ' + tx + ',' + m +
         ' ' + tx + ',' + ty;
}

function diagonalR(sa, sr, ta, tr) {
  var sc = Math.cos(sa),
      ss = Math.sin(sa),
      tc = Math.cos(ta),
      ts = Math.sin(ta),
      mr = (sr + tr) / 2;
  return 'M' + (sr*sc) + ',' + (sr*ss) +
         'C' + (mr*sc) + ',' + (mr*ss) +
         ' ' + (mr*tc) + ',' + (mr*ts) +
         ' ' + (tr*tc) + ',' + (tr*ts);
}

// CONCATENATED MODULE: ./node_modules/d3-array/src/sum.js
function sum_sum(values, valueof) {
  let sum = 0;
  if (valueof === undefined) {
    for (let value of values) {
      if (value = +value) {
        sum += value;
      }
    }
  } else {
    let index = -1;
    for (let value of values) {
      if (value = +valueof(value, ++index, values)) {
        sum += value;
      }
    }
  }
  return sum;
}

// CONCATENATED MODULE: ./node_modules/vega-encode/src/Pie.js




/**
 * Pie and donut chart layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to size pie segments.
 * @param {number} [params.startAngle=0] - The start angle (in radians) of the layout.
 * @param {number} [params.endAngle=2π] - The end angle (in radians) of the layout.
 * @param {boolean} [params.sort] - Boolean flag for sorting sectors by value.
 */
function Pie(params) {
  Transform.call(this, null, params);
}

Pie.Definition = {
  'type': 'Pie',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'startAngle', 'type': 'number', 'default': 0 },
    { 'name': 'endAngle', 'type': 'number', 'default': 6.283185307179586 },
    { 'name': 'sort', 'type': 'boolean', 'default': false },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['startAngle', 'endAngle'] }
  ]
};

var Pie_prototype = Object(vega_util["y" /* inherits */])(Pie, Transform);

Pie_prototype.transform = function(_, pulse) {
  var as = _.as || ['startAngle', 'endAngle'],
      startAngle = as[0],
      endAngle = as[1],
      field = _.field || vega_util["O" /* one */],
      start = _.startAngle || 0,
      stop = _.endAngle != null ? _.endAngle : 2 * Math.PI,
      data = pulse.source,
      values = data.map(field),
      n = values.length,
      a = start,
      k = (stop - start) / sum_sum(values),
      index = src_range(n),
      i, t, v;

  if (_.sort) {
    index.sort(function(a, b) {
      return values[a] - values[b];
    });
  }

  for (i=0; i<n; ++i) {
    v = values[index[i]];
    t = data[index[i]];
    t[startAngle] = a;
    t[endAngle] = (a += v * k);
  }

  this.value = values;
  return pulse.reflow(_.modified()).modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/Scale.js









var DEFAULT_COUNT = 5;

function includeZero(scale) {
  const type = scale.type;
  return !scale.bins && (
    type === types_Linear || type === Pow || type === Sqrt
  );
}

function includePad(type) {
  return isContinuous(type) && type !== Sequential;
}

var Scale_SKIP = Object(vega_util["db" /* toSet */])([
  'set', 'modified', 'clear', 'type', 'scheme', 'schemeExtent', 'schemeCount',
  'domain', 'domainMin', 'domainMid', 'domainMax',
  'domainRaw', 'domainImplicit', 'nice', 'zero', 'bins',
  'range', 'rangeStep', 'round', 'reverse', 'interpolate', 'interpolateGamma'
]);

/**
 * Maintains a scale function mapping data values to visual channels.
 * @constructor
 * @param {object} params - The parameters for this operator.
 */
function Scale(params) {
  Transform.call(this, null, params);
  this.modified(true); // always treat as modified
}

var Scale_prototype = Object(vega_util["y" /* inherits */])(Scale, Transform);

Scale_prototype.transform = function(_, pulse) {
  var df = pulse.dataflow,
      scale = this.value,
      key = scaleKey(_);

  if (!scale || key !== scale.type) {
    this.value = scale = scales_scale(key)();
  }

  for (key in _) if (!Scale_SKIP[key]) {
    // padding is a scale property for band/point but not others
    if (key === 'padding' && includePad(scale.type)) continue;
    // invoke scale property setter, raise warning if not found
    Object(vega_util["D" /* isFunction */])(scale[key])
      ? scale[key](_[key])
      : df.warn('Unsupported scale property: ' + key);
  }

  configureRange(scale, _,
    configureBins(scale, _, configureDomain(scale, _, df))
  );

  return pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);
};

function scaleKey(_) {
  var t = _.type, d = '', n;

  // backwards compatibility pre Vega 5.
  if (t === Sequential) return Sequential + '-' + types_Linear;

  if (isContinuousColor(_)) {
    n = _.rawDomain ? _.rawDomain.length
      : _.domain ? _.domain.length + +(_.domainMid != null)
      : 0;
    d = n === 2 ? Sequential + '-'
      : n === 3 ? Diverging + '-'
      : '';
  }

  return ((d + t) || types_Linear).toLowerCase();
}

function isContinuousColor(_) {
  const t = _.type;
  return isContinuous(t) && t !== Time && t !== UTC && (
    _.scheme || _.range && _.range.length && _.range.every(vega_util["H" /* isString */])
  );
}

function configureDomain(scale, _, df) {
  // check raw domain, if provided use that and exit early
  var raw = rawDomain(scale, _.domainRaw, df);
  if (raw > -1) return raw;

  var domain = _.domain,
      type = scale.type,
      zero = _.zero || (_.zero === undefined && includeZero(scale)),
      n, mid;

  if (!domain) return 0;

  // adjust continuous domain for minimum pixel padding
  if (includePad(type) && _.padding && domain[0] !== Object(vega_util["U" /* peek */])(domain)) {
    domain = padDomain(type, domain, _.range, _.padding, _.exponent, _.constant);
  }

  // adjust domain based on zero, min, max settings
  if (zero || _.domainMin != null || _.domainMax != null || _.domainMid != null) {
    n = ((domain = domain.slice()).length - 1) || 1;
    if (zero) {
      if (domain[0] > 0) domain[0] = 0;
      if (domain[n] < 0) domain[n] = 0;
    }
    if (_.domainMin != null) domain[0] = _.domainMin;
    if (_.domainMax != null) domain[n] = _.domainMax;

    if (_.domainMid != null) {
      mid = _.domainMid;
      const i = mid > domain[n] ? n + 1 : mid < domain[0] ? 0 : n;
      if (i !== n) df.warn('Scale domainMid exceeds domain min or max.', mid);
      domain.splice(i, 0, mid);
    }
  }

  // set the scale domain
  scale.domain(domainCheck(type, domain, df));

  // if ordinal scale domain is defined, prevent implicit
  // domain construction as side-effect of scale lookup
  if (type === Ordinal) {
    scale.unknown(_.domainImplicit ? implicit : undefined);
  }

  // perform 'nice' adjustment as requested
  if (_.nice && scale.nice) {
    scale.nice((_.nice !== true && tickCount(scale, _.nice)) || null);
  }

  // return the cardinality of the domain
  return domain.length;
}

function rawDomain(scale, raw, df) {
  if (raw) {
    scale.domain(domainCheck(scale.type, raw, df));
    return raw.length;
  } else {
    return -1;
  }
}

function padDomain(type, domain, range, pad, exponent, constant) {
  var span = Math.abs(Object(vega_util["U" /* peek */])(range) - range[0]),
      frac = span / (span - 2 * pad),
      d = type === Log    ? Object(vega_util["mb" /* zoomLog */])(domain, null, frac)
        : type === Sqrt   ? Object(vega_util["nb" /* zoomPow */])(domain, null, frac, 0.5)
        : type === Pow    ? Object(vega_util["nb" /* zoomPow */])(domain, null, frac, exponent || 1)
        : type === Symlog ? Object(vega_util["ob" /* zoomSymlog */])(domain, null, frac, constant || 1)
        : Object(vega_util["lb" /* zoomLinear */])(domain, null, frac);

  domain = domain.slice();
  domain[0] = d[0];
  domain[domain.length-1] = d[1];
  return domain;
}

function domainCheck(type, domain, df) {
  if (isLogarithmic(type)) {
    // sum signs of domain values
    // if all pos or all neg, abs(sum) === domain.length
    var s = Math.abs(domain.reduce(function(s, v) {
      return s + (v < 0 ? -1 : v > 0 ? 1 : 0);
    }, 0));

    if (s !== domain.length) {
      df.warn('Log scale domain includes zero: ' + Object(vega_util["Z" /* stringValue */])(domain));
    }
  }
  return domain;
}

function configureBins(scale, _, count) {
  let bins = _.bins;

  if (bins && !Object(vega_util["A" /* isArray */])(bins)) {
    // generate bin boundary array
    let domain = scale.domain(),
        lo = domain[0],
        hi = Object(vega_util["U" /* peek */])(domain),
        start = bins.start == null ? lo : bins.start,
        stop = bins.stop == null ? hi : bins.stop,
        step = bins.step;

    if (!step) Object(vega_util["n" /* error */])('Scale bins parameter missing step property.');
    if (start < lo) start = step * Math.ceil(lo / step);
    if (stop > hi) stop = step * Math.floor(hi / step);
    bins = src_range(start, stop + step / 2, step);
  }

  if (bins) {
    // assign bin boundaries to scale instance
    scale.bins = bins;
  } else if (scale.bins) {
    // no current bins, remove bins if previously set
    delete scale.bins;
  }

  // special handling for bin-ordinal scales
  if (scale.type === BinOrdinal) {
    if (!bins) {
      // the domain specifies the bins
      scale.bins = scale.domain();
    } else if (!_.domain && !_.domainRaw) {
      // the bins specify the domain
      scale.domain(bins);
      count = bins.length;
    }
  }

  // return domain cardinality
  return count;
}

function configureRange(scale, _, count) {
  var type = scale.type,
      round = _.round || false,
      range = _.range;

  // if range step specified, calculate full range extent
  if (_.rangeStep != null) {
    range = configureRangeStep(type, _, count);
  }

  // else if a range scheme is defined, use that
  else if (_.scheme) {
    range = configureScheme(type, _, count);
    if (Object(vega_util["D" /* isFunction */])(range)) {
      if (scale.interpolator) {
        return scale.interpolator(range);
      } else {
        Object(vega_util["n" /* error */])(`Scale type ${type} does not support interpolating color schemes.`);
      }
    }
  }

  // given a range array for an interpolating scale, convert to interpolator
  if (range && isInterpolating(type)) {
    return scale.interpolator(
      interpolateColors(flip(range, _.reverse), _.interpolate, _.interpolateGamma)
    );
  }

  // configure rounding / interpolation
  if (range && _.interpolate && scale.interpolate) {
    scale.interpolate(interpolate_interpolate(_.interpolate, _.interpolateGamma));
  } else if (Object(vega_util["D" /* isFunction */])(scale.round)) {
    scale.round(round);
  } else if (Object(vega_util["D" /* isFunction */])(scale.rangeRound)) {
    scale.interpolate(round ? src_round : src_value);
  }

  if (range) scale.range(flip(range, _.reverse));
}

function configureRangeStep(type, _, count) {
  if (type !== Band && type !== Point) {
    Object(vega_util["n" /* error */])('Only band and point scales support rangeStep.');
  }

  // calculate full range based on requested step size and padding
  var outer = (_.paddingOuter != null ? _.paddingOuter : _.padding) || 0,
      inner = type === Point ? 1
            : ((_.paddingInner != null ? _.paddingInner : _.padding) || 0);
  return [0, _.rangeStep * bandSpace(count, inner, outer)];
}

function configureScheme(type, _, count) {
  var extent = _.schemeExtent,
      name, scheme;

  if (Object(vega_util["A" /* isArray */])(_.scheme)) {
    scheme = interpolateColors(_.scheme, _.interpolate, _.interpolateGamma);
  } else {
    name = _.scheme.toLowerCase();
    scheme = schemes_scheme(name);
    if (!scheme) Object(vega_util["n" /* error */])(`Unrecognized scheme name: ${_.scheme}`);
  }

  // determine size for potential discrete range
  count = (type === Threshold) ? count + 1
    : (type === BinOrdinal) ? count - 1
    : (type === types_Quantile || type === Quantize) ? (+_.schemeCount || DEFAULT_COUNT)
    : count;

  // adjust and/or quantize scheme as appropriate
  return isInterpolating(type) ? adjustScheme(scheme, extent, _.reverse)
    : Object(vega_util["D" /* isFunction */])(scheme) ? quantizeInterpolator(adjustScheme(scheme, extent), count)
    : type === Ordinal ? scheme : scheme.slice(0, count);
}

function adjustScheme(scheme, extent, reverse) {
  return (Object(vega_util["D" /* isFunction */])(scheme) && (extent || reverse))
    ? interpolateRange(scheme, flip(extent || [0, 1], reverse))
    : scheme;
}

function flip(array, reverse) {
  return reverse ? array.slice().reverse() : array;
}


// CONCATENATED MODULE: ./node_modules/vega-encode/src/SortItems.js



/**
 * Sorts scenegraph items in the pulse source array.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(*,*): number} [params.sort] - A comparator
 *   function for sorting tuples.
 */
function SortItems(params) {
  Transform.call(this, null, params);
}

var SortItems_prototype = Object(vega_util["y" /* inherits */])(SortItems, Transform);

SortItems_prototype.transform = function(_, pulse) {
  var mod = _.modified('sort')
         || pulse.changed(pulse.ADD)
         || pulse.modified(_.sort.fields)
         || pulse.modified('datum');

  if (mod) pulse.source.sort(stableCompare(_.sort));

  this.modified(mod);
  return pulse;
};

// CONCATENATED MODULE: ./node_modules/vega-encode/src/Stack.js



var Zero = 'zero',
    Center = 'center',
    Normalize = 'normalize',
    DefOutput = ['y0', 'y1'];

/**
 * Stack layout for visualization elements.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to stack.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors to groupby.
 * @param {function(object,object): number} [params.sort] - A comparator for stack sorting.
 * @param {string} [offset='zero'] - Stack baseline offset. One of 'zero', 'center', 'normalize'.
 */
function Stack(params) {
  Transform.call(this, null, params);
}

Stack.Definition = {
  'type': 'Stack',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'offset', 'type': 'enum', 'default': Zero, 'values': [Zero, Center, Normalize] },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': DefOutput }
  ]
};

var Stack_prototype = Object(vega_util["y" /* inherits */])(Stack, Transform);

Stack_prototype.transform = function(_, pulse) {
  var as = _.as || DefOutput,
      y0 = as[0],
      y1 = as[1],
      sort = stableCompare(_.sort),
      field = _.field || vega_util["O" /* one */],
      stack = _.offset === Center ? stackCenter
            : _.offset === Normalize ? stackNormalize
            : stackZero,
      groups, i, n, max;

  // partition, sum, and sort the stack groups
  groups = Stack_partition(pulse.source, _.groupby, sort, field);

  // compute stack layouts per group
  for (i=0, n=groups.length, max=groups.max; i<n; ++i) {
    stack(groups[i], max, field, y0, y1);
  }

  return pulse.reflow(_.modified()).modifies(as);
};

function stackCenter(group, max, field, y0, y1) {
  var last = (max - group.sum) / 2,
      m = group.length,
      j = 0, t;

  for (; j<m; ++j) {
    t = group[j];
    t[y0] = last;
    t[y1] = (last += Math.abs(field(t)));
  }
}

function stackNormalize(group, max, field, y0, y1) {
  var scale = 1 / group.sum,
      last = 0,
      m = group.length,
      j = 0, v = 0, t;

  for (; j<m; ++j) {
    t = group[j];
    t[y0] = last;
    t[y1] = last = scale * (v += Math.abs(field(t)));
  }
}

function stackZero(group, max, field, y0, y1) {
  var lastPos = 0,
      lastNeg = 0,
      m = group.length,
      j = 0, v, t;

  for (; j<m; ++j) {
    t = group[j];
    v = +field(t);
    if (v < 0) {
      t[y0] = lastNeg;
      t[y1] = (lastNeg += v);
    } else {
      t[y0] = lastPos;
      t[y1] = (lastPos += v);
    }
  }
}

function Stack_partition(data, groupby, sort, field) {
  var groups = [],
      get = function(f) { return f(t); },
      map, i, n, m, t, k, g, s, max;

  // partition data points into stack groups
  if (groupby == null) {
    groups.push(data.slice());
  } else {
    for (map={}, i=0, n=data.length; i<n; ++i) {
      t = data[i];
      k = groupby.map(get);
      g = map[k];
      if (!g) {
        map[k] = (g = []);
        groups.push(g);
      }
      g.push(t);
    }
  }

  // compute sums of groups, sort groups as needed
  for (k=0, max=0, m=groups.length; k<m; ++k) {
    g = groups[k];
    for (i=0, s=0, n=g.length; i<n; ++i) {
      s += Math.abs(field(g[i]));
    }
    g.sum = s;
    if (s > max) max = s;
    if (sort) g.sort(sort);
  }
  groups.max = max;

  return groups;
}

// CONCATENATED MODULE: ./node_modules/vega-encode/index.js










// CONCATENATED MODULE: ./node_modules/vega-geo/src/util/contours.js


function contours_noop() {}

const cases = [
  [],
  [[[1.0, 1.5], [0.5, 1.0]]],
  [[[1.5, 1.0], [1.0, 1.5]]],
  [[[1.5, 1.0], [0.5, 1.0]]],
  [[[1.0, 0.5], [1.5, 1.0]]],
  [[[1.0, 1.5], [0.5, 1.0]], [[1.0, 0.5], [1.5, 1.0]]],
  [[[1.0, 0.5], [1.0, 1.5]]],
  [[[1.0, 0.5], [0.5, 1.0]]],
  [[[0.5, 1.0], [1.0, 0.5]]],
  [[[1.0, 1.5], [1.0, 0.5]]],
  [[[0.5, 1.0], [1.0, 0.5]], [[1.5, 1.0], [1.0, 1.5]]],
  [[[1.5, 1.0], [1.0, 0.5]]],
  [[[0.5, 1.0], [1.5, 1.0]]],
  [[[1.0, 1.5], [1.5, 1.0]]],
  [[[0.5, 1.0], [1.0, 1.5]]],
  []
];

// Implementation adapted from d3/d3-contour. Thanks!
/* harmony default export */ var util_contours = (function() {
  var dx = 1,
      dy = 1,
      smooth = smoothLinear;

  function contours(values, tz) {
    return tz.map(value => contour(values, value));
  }

  // Accumulate, smooth contour rings, assign holes to exterior rings.
  // Based on https://github.com/mbostock/shapefile/blob/v0.6.2/shp/polygon.js
  function contour(values, value) {
    var polygons = [],
        holes = [];

    isorings(values, value, function(ring) {
      smooth(ring, values, value);
      if (contours_area(ring) > 0) polygons.push([ring]);
      else holes.push(ring);
    });

    holes.forEach(function(hole) {
      for (var i = 0, n = polygons.length, polygon; i < n; ++i) {
        if (contains((polygon = polygons[i])[0], hole) !== -1) {
          polygon.push(hole);
          return;
        }
      }
    });

    return {
      type: 'MultiPolygon',
      value: value,
      coordinates: polygons
    };
  }

  // Marching squares with isolines stitched into rings.
  // Based on https://github.com/topojson/topojson-client/blob/v3.0.0/src/stitch.js
  function isorings(values, value, callback) {
    var fragmentByStart = new Array,
        fragmentByEnd = new Array,
        x, y, t0, t1, t2, t3;

    // Special case for the first row (y = -1, t2 = t3 = 0).
    x = y = -1;
    t1 = values[0] >= value;
    cases[t1 << 1].forEach(stitch);
    while (++x < dx - 1) {
      t0 = t1, t1 = values[x + 1] >= value;
      cases[t0 | t1 << 1].forEach(stitch);
    }
    cases[t1 << 0].forEach(stitch);

    // General case for the intermediate rows.
    while (++y < dy - 1) {
      x = -1;
      t1 = values[y * dx + dx] >= value;
      t2 = values[y * dx] >= value;
      cases[t1 << 1 | t2 << 2].forEach(stitch);
      while (++x < dx - 1) {
        t0 = t1, t1 = values[y * dx + dx + x + 1] >= value;
        t3 = t2, t2 = values[y * dx + x + 1] >= value;
        cases[t0 | t1 << 1 | t2 << 2 | t3 << 3].forEach(stitch);
      }
      cases[t1 | t2 << 3].forEach(stitch);
    }

    // Special case for the last row (y = dy - 1, t0 = t1 = 0).
    x = -1;
    t2 = values[y * dx] >= value;
    cases[t2 << 2].forEach(stitch);
    while (++x < dx - 1) {
      t3 = t2, t2 = values[y * dx + x + 1] >= value;
      cases[t2 << 2 | t3 << 3].forEach(stitch);
    }
    cases[t2 << 3].forEach(stitch);

    function stitch(line) {
      var start = [line[0][0] + x, line[0][1] + y],
          end = [line[1][0] + x, line[1][1] + y],
          startIndex = index(start),
          endIndex = index(end),
          f, g;
      if (f = fragmentByEnd[startIndex]) {
        if (g = fragmentByStart[endIndex]) {
          delete fragmentByEnd[f.end];
          delete fragmentByStart[g.start];
          if (f === g) {
            f.ring.push(end);
            callback(f.ring);
          } else {
            fragmentByStart[f.start] = fragmentByEnd[g.end] = {start: f.start, end: g.end, ring: f.ring.concat(g.ring)};
          }
        } else {
          delete fragmentByEnd[f.end];
          f.ring.push(end);
          fragmentByEnd[f.end = endIndex] = f;
        }
      } else if (f = fragmentByStart[endIndex]) {
        if (g = fragmentByEnd[startIndex]) {
          delete fragmentByStart[f.start];
          delete fragmentByEnd[g.end];
          if (f === g) {
            f.ring.push(end);
            callback(f.ring);
          } else {
            fragmentByStart[g.start] = fragmentByEnd[f.end] = {start: g.start, end: f.end, ring: g.ring.concat(f.ring)};
          }
        } else {
          delete fragmentByStart[f.start];
          f.ring.unshift(start);
          fragmentByStart[f.start = startIndex] = f;
        }
      } else {
        fragmentByStart[startIndex] = fragmentByEnd[endIndex] = {start: startIndex, end: endIndex, ring: [start, end]};
      }
    }
  }

  function index(point) {
    return point[0] * 2 + point[1] * (dx + 1) * 4;
  }

  function smoothLinear(ring, values, value) {
    ring.forEach(function(point) {
      var x = point[0],
          y = point[1],
          xt = x | 0,
          yt = y | 0,
          v0,
          v1 = values[yt * dx + xt];
      if (x > 0 && x < dx && xt === x) {
        v0 = values[yt * dx + xt - 1];
        point[0] = x + (value - v0) / (v1 - v0) - 0.5;
      }
      if (y > 0 && y < dy && yt === y) {
        v0 = values[(yt - 1) * dx + xt];
        point[1] = y + (value - v0) / (v1 - v0) - 0.5;
      }
    });
  }

  contours.contour = contour;

  contours.size = function(_) {
    if (!arguments.length) return [dx, dy];
    var _0 = Math.floor(_[0]), _1 = Math.floor(_[1]);
    if (!(_0 >= 0 && _1 >= 0)) Object(vega_util["n" /* error */])('invalid size');
    return dx = _0, dy = _1, contours;
  };

  contours.smooth = function(_) {
    return arguments.length ? (smooth = _ ? smoothLinear : contours_noop, contours) : smooth === smoothLinear;
  };

  return contours;
});

function contours_area(ring) {
  var i = 0,
      n = ring.length,
      area = ring[n - 1][1] * ring[0][0] - ring[n - 1][0] * ring[0][1];
  while (++i < n) area += ring[i - 1][1] * ring[i][0] - ring[i - 1][0] * ring[i][1];
  return area;
}

function contains(ring, hole) {
  var i = -1, n = hole.length, c;
  while (++i < n) if (c = ringContains(ring, hole[i])) return c;
  return 0;
}

function ringContains(ring, point) {
  var x = point[0], y = point[1], contains = -1;
  for (var i = 0, n = ring.length, j = n - 1; i < n; j = i++) {
    var pi = ring[i], xi = pi[0], yi = pi[1], pj = ring[j], xj = pj[0], yj = pj[1];
    if (segmentContains(pi, pj, point)) return 0;
    if (((yi > y) !== (yj > y)) && ((x < (xj - xi) * (y - yi) / (yj - yi) + xi))) contains = -contains;
  }
  return contains;
}

function segmentContains(a, b, c) {
  var i; return collinear(a, b, c) && within(a[i = +(a[0] === b[0])], c[i], b[i]);
}

function collinear(a, b, c) {
  return (b[0] - a[0]) * (c[1] - a[1]) === (c[0] - a[0]) * (b[1] - a[1]);
}

function within(p, q, r) {
  return p <= q && q <= r || r <= q && q <= p;
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/util/quantize.js



/* harmony default export */ var util_quantize = (function(k, nice, zero) {
  return function(values) {
    var ex = Object(vega_util["p" /* extent */])(values),
        start = zero ? Math.min(ex[0], 0) : ex[0],
        stop = ex[1],
        span = stop - start,
        step = nice ? tickStep(start, stop, k) : (span / (k + 1));
    return src_range(step, stop, step);
  };
});

// CONCATENATED MODULE: ./node_modules/vega-geo/src/Isocontour.js






/**
 * Generate isocontours (level sets) based on input raster grid data.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} [params.field] - The field with raster grid
 *   data. If unspecified, the tuple itself is interpreted as a raster grid.
 * @param {Array<number>} [params.thresholds] - Contour threshold array. If
 *   specified, the levels, nice, resolve, and zero parameters are ignored.
 * @param {number} [params.levels] - The desired number of contour levels.
 * @param {boolean} [params.nice] - Boolean flag indicating if the contour
 *   threshold values should be automatically aligned to "nice"
 *   human-friendly values. Setting this flag may cause the number of
 *   thresholds to deviate from the specified levels.
 * @param {string} [params.resolve] - The method for resolving thresholds
 *   across multiple input grids. If 'independent' (the default), threshold
 *   calculation will be performed separately for each grid. If 'shared', a
 *   single set of threshold values will be used for all input grids.
 * @param {boolean} [params.zero] - Boolean flag indicating if the contour
 *   threshold values should include zero.
 * @param {boolean} [params.smooth] - Boolean flag indicating if the contour
 *   polygons should be smoothed using linear interpolation. The default is
 *   true. The parameter is ignored when using density estimation.
 * @param {boolean} [params.scale] - Optional numerical value by which to
 *   scale the output isocontour coordinates. This parameter can be useful
 *   to scale the contours to match a desired output resolution.
 * @param {string} [params.as='contour'] - The output field in which to store
 *   the generated isocontour data (default 'contour').
 */
function Isocontour(params) {
  Transform.call(this, null, params);
}

Isocontour.Definition = {
  'type': 'Isocontour',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'thresholds', 'type': 'number', 'array': true },
    { 'name': 'levels', 'type': 'number' },
    { 'name': 'nice', 'type': 'boolean', 'default': false },
    { 'name': 'resolve', 'type': 'enum', 'values': ['shared', 'independent'], 'default': 'independent' },
    { 'name': 'zero', 'type': 'boolean', 'default': true },
    { 'name': 'smooth', 'type': 'boolean', 'default': true },
    { 'name': 'scale', 'type': 'number', 'expr': true },
    { 'name': 'translate', 'type': 'number', 'array': true, 'expr': true },
    { 'name': 'as', 'type': 'string', 'null': true, 'default': 'contour' }
  ]
};

var Isocontour_prototype = Object(vega_util["y" /* inherits */])(Isocontour, Transform);

Isocontour_prototype.transform = function(_, pulse) {
  if (this.value && !pulse.changed() && !_.modified()) {
    return pulse.StopPropagation;
  }

  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      source = pulse.materialize(pulse.SOURCE).source,
      field = _.field || vega_util["x" /* identity */],
      contour = util_contours().smooth(_.smooth !== false),
      tz = _.thresholds || levels(source, field, _),
      as = _.as === null ? null : _.as || 'contour',
      values = [];

  source.forEach(t => {
    const grid = field(t);

    // generate contour paths in GeoJSON format
    const paths = contour.size([grid.width, grid.height])(
      grid.values, Object(vega_util["A" /* isArray */])(tz) ? tz : tz(grid.values)
    );

    // adjust contour path coordinates as needed
    transformPaths(paths, grid, t, _);

    // ingest; copy source data properties to output
    paths.forEach(p => {
      values.push(rederive(t, ingest(as != null ? {[as]: p} : p)));
    });
  });

  if (this.value) out.rem = this.value;
  this.value = out.source = out.add = values;

  return out;
};

function levels(values, f, _) {
  const q = util_quantize(_.levels || 10, _.nice, _.zero !== false);
  return _.resolve !== 'shared'
    ? q
    : q(values.map(t => max_max(f(t).values)));
}

function transformPaths(paths, grid, datum, _) {
  let s = _.scale || grid.scale,
      t = _.translate || grid.translate;
  if (Object(vega_util["D" /* isFunction */])(s)) s = s(datum, _);
  if (Object(vega_util["D" /* isFunction */])(t)) t = t(datum, _);
  if ((s === 1 || s == null) && !t) return;

  const sx = (Object(vega_util["E" /* isNumber */])(s) ? s : s[0]) || 1,
        sy = (Object(vega_util["E" /* isNumber */])(s) ? s : s[1]) || 1,
        tx = t && t[0] || 0,
        ty = t && t[1] || 0;

  paths.forEach(Isocontour_transform(grid, sx, sy, tx, ty));
}

function Isocontour_transform(grid, sx, sy, tx, ty) {
  const x1 = grid.x1 || 0,
        y1 = grid.y1 || 0,
        flip = sx * sy < 0;

  function transformPolygon(coordinates) {
    coordinates.forEach(transformRing);
  }

  function transformRing(coordinates) {
    if (flip) coordinates.reverse(); // maintain winding order
    coordinates.forEach(transformPoint);
  }

  function transformPoint(coordinates) {
    coordinates[0] = (coordinates[0] - x1) * sx + tx;
    coordinates[1] = (coordinates[1] - y1) * sy + ty;
  }

  return function(geometry) {
    geometry.coordinates.forEach(transformPolygon);
    return geometry;
  };
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/util/density2D.js




function density2D_radius(bw, data, f) {
  const v = bw >= 0 ? bw : src_bandwidth(data, f);
  return Math.round((Math.sqrt(4 * v * v + 1) - 1) / 2);
}

function density2D_number(_) {
  return Object(vega_util["D" /* isFunction */])(_) ? _ : Object(vega_util["l" /* constant */])(+_);
}

// Implementation adapted from d3/d3-contour. Thanks!
/* harmony default export */ var density2D = (function() {
  var x = d => d[0],
      y = d => d[1],
      weight = vega_util["O" /* one */],
      bandwidth = [-1, -1],
      dx = 960,
      dy = 500,
      k = 2; // log2(cellSize)

  function density(data, counts) {
    const rx = density2D_radius(bandwidth[0], data, x) >> k, // blur x-radius
          ry = density2D_radius(bandwidth[1], data, y) >> k, // blur y-radius
          ox = rx ? rx + 2 : 0, // x-offset padding for blur
          oy = ry ? ry + 2 : 0, // y-offset padding for blur
          n = 2 * ox + (dx >> k), // grid width
          m = 2 * oy + (dy >> k), // grid height
          values0 = new Float32Array(n * m),
          values1 = new Float32Array(n * m);

    let values = values0;

    data.forEach(d => {
      const xi = ox + (+x(d) >> k),
            yi = oy + (+y(d) >> k);

      if (xi >= 0 && xi < n && yi >= 0 && yi < m) {
        values0[xi + yi * n] += +weight(d);
      }
    });

    if (rx > 0 && ry > 0) {
      blurX(n, m, values0, values1, rx);
      blurY(n, m, values1, values0, ry);
      blurX(n, m, values0, values1, rx);
      blurY(n, m, values1, values0, ry);
      blurX(n, m, values0, values1, rx);
      blurY(n, m, values1, values0, ry);
    } else if (rx > 0) {
      blurX(n, m, values0, values1, rx);
      blurX(n, m, values1, values0, rx);
      blurX(n, m, values0, values1, rx);
      values = values1;
    } else if (ry > 0) {
      blurY(n, m, values0, values1, ry);
      blurY(n, m, values1, values0, ry);
      blurY(n, m, values0, values1, ry);
      values = values1;
    }

    // scale density estimates
    // density in points per square pixel or probability density
    let s = counts ? Math.pow(2, -2 * k) : 1 / sum_sum(values);
    for (let i=0, sz=n*m; i<sz; ++i) values[i] *= s;

    return {
      values: values,
      scale: 1 << k,
      width: n,
      height: m,
      x1: ox,
      y1: oy,
      x2: ox + (dx >> k),
      y2: oy + (dy >> k)
    };
  }

  density.x = function(_) {
    return arguments.length ? (x = density2D_number(_), density) : x;
  };

  density.y = function(_) {
    return arguments.length ? (y = density2D_number(_), density) : y;
  };

  density.weight = function(_) {
    return arguments.length ? (weight = density2D_number(_), density) : weight;
  };

  density.size = function(_) {
    if (!arguments.length) return [dx, dy];
    var _0 = +_[0], _1 = +_[1];
    if (!(_0 >= 0 && _1 >= 0)) Object(vega_util["n" /* error */])('invalid size');
    return dx = _0, dy = _1, density;
  };

  density.cellSize = function(_) {
    if (!arguments.length) return 1 << k;
    if (!((_ = +_) >= 1)) Object(vega_util["n" /* error */])('invalid cell size');
    k = Math.floor(Math.log(_) / Math.LN2);
    return density;
  };

  density.bandwidth = function(_) {
    if (!arguments.length) return bandwidth;
    _ = Object(vega_util["i" /* array */])(_);
    if (_.length === 1) _ = [+_[0], +_[0]];
    if (_.length !== 2) Object(vega_util["n" /* error */])('invalid bandwidth');
    return bandwidth = _, density;
  };

  return density;
});

function blurX(n, m, source, target, r) {
  const w = (r << 1) + 1;
  for (let j = 0; j < m; ++j) {
    for (let i = 0, sr = 0; i < n + r; ++i) {
      if (i < n) {
        sr += source[i + j * n];
      }
      if (i >= r) {
        if (i >= w) {
          sr -= source[i - w + j * n];
        }
        target[i - r + j * n] = sr / Math.min(i + 1, n - 1 + w - i, w);
      }
    }
  }
}

function blurY(n, m, source, target, r) {
  const w = (r << 1) + 1;
  for (let i = 0; i < n; ++i) {
    for (let j = 0, sr = 0; j < m + r; ++j) {
      if (j < m) {
        sr += source[i + j * n];
      }
      if (j >= r) {
        if (j >= w) {
          sr -= source[i + (j - w) * n];
        }
        target[i + (j - r) * n] = sr / Math.min(j + 1, m - 1 + w - j, w);
      }
    }
  }
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/KDE2D.js




/**
 * Perform 2D kernel-density estimation of point data.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<number>} params.size - The [width, height] extent (in
 *   units of input pixels) over which to perform density estimation.
 * @param {function(object): number} params.x - The x-coordinate accessor.
 * @param {function(object): number} params.y - The y-coordinate accessor.
 * @param {function(object): number} [params.weight] - The weight accessor.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors
 *   to groupby.
 * @param {number} [params.cellSize] - Contour density calculation cell size.
 *   This parameter determines the level of spatial approximation. For example,
 *   the default value of 4 maps to 2x reductions in both x- and y- dimensions.
 *   A value of 1 will result in an output raster grid whose dimensions exactly
 *   matches the size parameter.
 * @param {Array<number>} [params.bandwidth] - The KDE kernel bandwidths,
 *   in pixels. The input can be a two-element array specifying separate
 *   x and y bandwidths, or a single-element array specifying both. If the
 *   bandwidth is unspecified or less than zero, the bandwidth will be
 *   automatically determined.
 * @param {boolean} [params.counts=false] - A boolean flag indicating if the
 *   output values should be probability estimates (false, default) or
 *   smoothed counts (true).
 * @param {string} [params.as='grid'] - The output field in which to store
 *   the generated raster grid (default 'grid').
 */
function KDE2D(params) {
  Transform.call(this, null, params);
}

KDE2D.Definition = {
  'type': 'KDE2D',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2, 'required': true },
    { 'name': 'x', 'type': 'field', 'required': true },
    { 'name': 'y', 'type': 'field', 'required': true },
    { 'name': 'weight', 'type': 'field' },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'cellSize', 'type': 'number' },
    { 'name': 'bandwidth', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'counts', 'type': 'boolean', 'default': false },
    { 'name': 'as', 'type': 'string', 'default': 'grid'}
  ]
};

var KDE2D_prototype = Object(vega_util["y" /* inherits */])(KDE2D, Transform);

const PARAMS = ['x', 'y', 'weight', 'size', 'cellSize', 'bandwidth'];

function KDE2D_params(obj, _) {
  PARAMS.forEach(param => _[param] != null ? obj[param](_[param]) : 0);
  return obj;
}

KDE2D_prototype.transform = function(_, pulse) {
  if (this.value && !pulse.changed() && !_.modified())
    return pulse.StopPropagation;

  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      source = pulse.materialize(pulse.SOURCE).source,
      groups = KDE2D_partition(source, _.groupby),
      names = (_.groupby || []).map(vega_util["h" /* accessorName */]),
      kde = KDE2D_params(density2D(), _),
      as = _.as || 'grid',
      values = [];

  function set(t, vals) {
    for (let i=0; i<names.length; ++i) t[names[i]] = vals[i];
    return t;
  }

  // generate density raster grids
  values = groups.map(g => ingest(
    set({[as]: kde(g, _.counts)}, g.dims)
  ));

  if (this.value) out.rem = this.value;
  this.value = out.source = out.add = values;

  return out;
};

function KDE2D_partition(data, groupby) {
  var groups = [],
      get = f => f(t),
      map, i, n, t, k, g;

  // partition data points into groups
  if (groupby == null) {
    groups.push(data);
  } else {
    for (map={}, i=0, n=data.length; i<n; ++i) {
      t = data[i];
      k = groupby.map(get);
      g = map[k];
      if (!g) {
        map[k] = (g = []);
        g.dims = k;
        groups.push(g);
      }
      g.push(t);
    }
  }

  return groups;
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/Contour.js








/**
 * Generate contours based on kernel-density estimation of point data.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<number>} params.size - The dimensions [width, height] over which to compute contours.
 *  If the values parameter is provided, this must be the dimensions of the input data.
 *  If density estimation is performed, this is the output view dimensions in pixels.
 * @param {Array<number>} [params.values] - An array of numeric values representing an
 *  width x height grid of values over which to compute contours. If unspecified, this
 *  transform will instead attempt to compute contours for the kernel density estimate
 *  using values drawn from data tuples in the input pulse.
 * @param {function(object): number} [params.x] - The pixel x-coordinate accessor for density estimation.
 * @param {function(object): number} [params.y] - The pixel y-coordinate accessor for density estimation.
 * @param {function(object): number} [params.weight] - The data point weight accessor for density estimation.
 * @param {number} [params.cellSize] - Contour density calculation cell size.
 * @param {number} [params.bandwidth] - Kernel density estimation bandwidth.
 * @param {Array<number>} [params.thresholds] - Contour threshold array. If
 *   this parameter is set, the count and nice parameters will be ignored.
 * @param {number} [params.count] - The desired number of contours.
 * @param {boolean} [params.nice] - Boolean flag indicating if the contour
 *   threshold values should be automatically aligned to "nice"
 *   human-friendly values. Setting this flag may cause the number of
 *   thresholds to deviate from the specified count.
 * @param {boolean} [params.smooth] - Boolean flag indicating if the contour
 *   polygons should be smoothed using linear interpolation. The default is
 *   true. The parameter is ignored when using density estimation.
 */
function Contour(params) {
  Transform.call(this, null, params);
}

Contour.Definition = {
  'type': 'Contour',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2, 'required': true },
    { 'name': 'values', 'type': 'number', 'array': true },
    { 'name': 'x', 'type': 'field' },
    { 'name': 'y', 'type': 'field' },
    { 'name': 'weight', 'type': 'field' },
    { 'name': 'cellSize', 'type': 'number' },
    { 'name': 'bandwidth', 'type': 'number' },
    { 'name': 'count', 'type': 'number' },
    { 'name': 'nice', 'type': 'boolean', 'default': false },
    { 'name': 'thresholds', 'type': 'number', 'array': true },
    { 'name': 'smooth', 'type': 'boolean', 'default': true }
  ]
};

var Contour_prototype = Object(vega_util["y" /* inherits */])(Contour, Transform);

Contour_prototype.transform = function(_, pulse) {
  if (this.value && !pulse.changed() && !_.modified()) {
    return pulse.StopPropagation;
  }

  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS),
      contour = util_contours().smooth(_.smooth !== false),
      values = _.values,
      thresh = _.thresholds || util_quantize(_.count || 10, _.nice, !!values),
      size = _.size, grid, post;

  if (!values) {
    values = pulse.materialize(pulse.SOURCE).source;
    grid = KDE2D_params(density2D(), _)(values, true);
    post = Isocontour_transform(grid, grid.scale || 1, grid.scale || 1, 0, 0);
    size = [grid.width, grid.height];
    values = grid.values;
  }

  thresh = Object(vega_util["A" /* isArray */])(thresh) ? thresh : thresh(values);
  values = contour.size(size)(values, thresh);
  if (post) values.forEach(post);

  if (this.value) out.rem = this.value;
  this.value = out.source = out.add = (values || []).map(ingest);

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-geo/src/constants.js
var Feature = 'Feature';
var FeatureCollection = 'FeatureCollection';
var MultiPoint = 'MultiPoint';

// CONCATENATED MODULE: ./node_modules/vega-geo/src/GeoJSON.js




/**
 * Consolidate an array of [longitude, latitude] points or GeoJSON features
 * into a combined GeoJSON object. This transform is particularly useful for
 * combining geo data for a Projection's fit argument. The resulting GeoJSON
 * data is available as this transform's value. Input pulses are unchanged.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<function(object): *>} [params.fields] - A two-element array
 *   of field accessors for the longitude and latitude values.
 * @param {function(object): *} params.geojson - A field accessor for
 *   retrieving GeoJSON feature data.
 */
function GeoJSON(params) {
  Transform.call(this, null, params);
}

GeoJSON.Definition = {
  'type': 'GeoJSON',
  'metadata': {},
  'params': [
    { 'name': 'fields', 'type': 'field', 'array': true, 'length': 2 },
    { 'name': 'geojson', 'type': 'field' }
  ]
};

var GeoJSON_prototype = Object(vega_util["y" /* inherits */])(GeoJSON, Transform);

GeoJSON_prototype.transform = function(_, pulse) {
  var features = this._features,
      points = this._points,
      fields = _.fields,
      lon = fields && fields[0],
      lat = fields && fields[1],
      geojson = _.geojson || (!fields && vega_util["x" /* identity */]),
      flag = pulse.ADD,
      mod;

  mod = _.modified()
    || pulse.changed(pulse.REM)
    || pulse.modified(Object(vega_util["g" /* accessorFields */])(geojson))
    || (lon && (pulse.modified(Object(vega_util["g" /* accessorFields */])(lon))))
    || (lat && (pulse.modified(Object(vega_util["g" /* accessorFields */])(lat))));

  if (!this.value || mod) {
    flag = pulse.SOURCE;
    this._features = (features = []);
    this._points = (points = []);
  }

  if (geojson) {
    pulse.visit(flag, function(t) {
      features.push(geojson(t));
    });
  }

  if (lon && lat) {
    pulse.visit(flag, function(t) {
      var x = lon(t),
          y = lat(t);
      if (x != null && y != null && (x = +x) === x && (y = +y) === y) {
        points.push([x, y]);
      }
    });
    features = features.concat({
      type: Feature,
      geometry: {
        type: MultiPoint,
        coordinates: points
      }
    });
  }

  this.value = {
    type: FeatureCollection,
    features: features
  };
};

// CONCATENATED MODULE: ./node_modules/d3-geo/src/identity.js
/* harmony default export */ var d3_geo_src_identity = (function(x) {
  return x;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/stream.js
function streamGeometry(geometry, stream) {
  if (geometry && streamGeometryType.hasOwnProperty(geometry.type)) {
    streamGeometryType[geometry.type](geometry, stream);
  }
}

var streamObjectType = {
  Feature: function(object, stream) {
    streamGeometry(object.geometry, stream);
  },
  FeatureCollection: function(object, stream) {
    var features = object.features, i = -1, n = features.length;
    while (++i < n) streamGeometry(features[i].geometry, stream);
  }
};

var streamGeometryType = {
  Sphere: function(object, stream) {
    stream.sphere();
  },
  Point: function(object, stream) {
    object = object.coordinates;
    stream.point(object[0], object[1], object[2]);
  },
  MultiPoint: function(object, stream) {
    var coordinates = object.coordinates, i = -1, n = coordinates.length;
    while (++i < n) object = coordinates[i], stream.point(object[0], object[1], object[2]);
  },
  LineString: function(object, stream) {
    streamLine(object.coordinates, stream, 0);
  },
  MultiLineString: function(object, stream) {
    var coordinates = object.coordinates, i = -1, n = coordinates.length;
    while (++i < n) streamLine(coordinates[i], stream, 0);
  },
  Polygon: function(object, stream) {
    streamPolygon(object.coordinates, stream);
  },
  MultiPolygon: function(object, stream) {
    var coordinates = object.coordinates, i = -1, n = coordinates.length;
    while (++i < n) streamPolygon(coordinates[i], stream);
  },
  GeometryCollection: function(object, stream) {
    var geometries = object.geometries, i = -1, n = geometries.length;
    while (++i < n) streamGeometry(geometries[i], stream);
  }
};

function streamLine(coordinates, stream, closed) {
  var i = -1, n = coordinates.length - closed, coordinate;
  stream.lineStart();
  while (++i < n) coordinate = coordinates[i], stream.point(coordinate[0], coordinate[1], coordinate[2]);
  stream.lineEnd();
}

function streamPolygon(coordinates, stream) {
  var i = -1, n = coordinates.length;
  stream.polygonStart();
  while (++i < n) streamLine(coordinates[i], stream, 1);
  stream.polygonEnd();
}

/* harmony default export */ var src_stream = (function(object, stream) {
  if (object && streamObjectType.hasOwnProperty(object.type)) {
    streamObjectType[object.type](object, stream);
  } else {
    streamGeometry(object, stream);
  }
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/adder.js
// Adds floating point numbers with twice the normal precision.
// Reference: J. R. Shewchuk, Adaptive Precision Floating-Point Arithmetic and
// Fast Robust Geometric Predicates, Discrete & Computational Geometry 18(3)
// 305–363 (1997).
// Code adapted from GeographicLib by Charles F. F. Karney,
// http://geographiclib.sourceforge.net/

/* harmony default export */ var adder = (function() {
  return new Adder;
});

function Adder() {
  this.reset();
}

Adder.prototype = {
  constructor: Adder,
  reset: function() {
    this.s = // rounded value
    this.t = 0; // exact error
  },
  add: function(y) {
    adder_add(adder_temp, y, this.t);
    adder_add(this, adder_temp.s, this.s);
    if (this.s) this.t += adder_temp.t;
    else this.s = adder_temp.t;
  },
  valueOf: function() {
    return this.s;
  }
};

var adder_temp = new Adder;

function adder_add(adder, a, b) {
  var x = adder.s = a + b,
      bv = x - a,
      av = x - bv;
  adder.t = (a - av) + (b - bv);
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/math.js
var src_math_epsilon = 1e-6;
var math_epsilon2 = 1e-12;
var math_pi = Math.PI;
var math_halfPi = math_pi / 2;
var quarterPi = math_pi / 4;
var math_tau = math_pi * 2;

var math_degrees = 180 / math_pi;
var radians = math_pi / 180;

var math_abs = Math.abs;
var atan = Math.atan;
var math_atan2 = Math.atan2;
var src_math_cos = Math.cos;
var ceil = Math.ceil;
var math_exp = Math.exp;
var math_floor = Math.floor;
var math_log = Math.log;
var math_pow = Math.pow;
var src_math_sin = Math.sin;
var math_sign = Math.sign || function(x) { return x > 0 ? 1 : x < 0 ? -1 : 0; };
var math_sqrt = Math.sqrt;
var tan = Math.tan;

function math_acos(x) {
  return x > 1 ? 0 : x < -1 ? math_pi : Math.acos(x);
}

function math_asin(x) {
  return x > 1 ? math_halfPi : x < -1 ? -math_halfPi : Math.asin(x);
}

function haversin(x) {
  return (x = src_math_sin(x / 2)) * x;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/noop.js
function noop_noop() {}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/area.js




var areaSum = adder(),
    areaRingSum = adder(),
    area_x00,
    area_y00,
    area_x0,
    area_y0;

var areaStream = {
  point: noop_noop,
  lineStart: noop_noop,
  lineEnd: noop_noop,
  polygonStart: function() {
    areaStream.lineStart = areaRingStart;
    areaStream.lineEnd = areaRingEnd;
  },
  polygonEnd: function() {
    areaStream.lineStart = areaStream.lineEnd = areaStream.point = noop_noop;
    areaSum.add(math_abs(areaRingSum));
    areaRingSum.reset();
  },
  result: function() {
    var area = areaSum / 2;
    areaSum.reset();
    return area;
  }
};

function areaRingStart() {
  areaStream.point = areaPointFirst;
}

function areaPointFirst(x, y) {
  areaStream.point = areaPoint;
  area_x00 = area_x0 = x, area_y00 = area_y0 = y;
}

function areaPoint(x, y) {
  areaRingSum.add(area_y0 * x - area_x0 * y);
  area_x0 = x, area_y0 = y;
}

function areaRingEnd() {
  areaPoint(area_x00, area_y00);
}

/* harmony default export */ var path_area = (areaStream);

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/bounds.js


var bounds_x0 = Infinity,
    bounds_y0 = bounds_x0,
    bounds_x1 = -bounds_x0,
    bounds_y1 = bounds_x1;

var boundsStream = {
  point: boundsPoint,
  lineStart: noop_noop,
  lineEnd: noop_noop,
  polygonStart: noop_noop,
  polygonEnd: noop_noop,
  result: function() {
    var bounds = [[bounds_x0, bounds_y0], [bounds_x1, bounds_y1]];
    bounds_x1 = bounds_y1 = -(bounds_y0 = bounds_x0 = Infinity);
    return bounds;
  }
};

function boundsPoint(x, y) {
  if (x < bounds_x0) bounds_x0 = x;
  if (x > bounds_x1) bounds_x1 = x;
  if (y < bounds_y0) bounds_y0 = y;
  if (y > bounds_y1) bounds_y1 = y;
}

/* harmony default export */ var path_bounds = (boundsStream);

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/centroid.js


// TODO Enforce positive area for exterior, negative area for interior?

var centroid_X0 = 0,
    centroid_Y0 = 0,
    Z0 = 0,
    centroid_X1 = 0,
    centroid_Y1 = 0,
    Z1 = 0,
    centroid_X2 = 0,
    Y2 = 0,
    Z2 = 0,
    centroid_x00,
    centroid_y00,
    centroid_x0,
    centroid_y0;

var centroidStream = {
  point: centroidPoint,
  lineStart: centroidLineStart,
  lineEnd: centroidLineEnd,
  polygonStart: function() {
    centroidStream.lineStart = centroidRingStart;
    centroidStream.lineEnd = centroidRingEnd;
  },
  polygonEnd: function() {
    centroidStream.point = centroidPoint;
    centroidStream.lineStart = centroidLineStart;
    centroidStream.lineEnd = centroidLineEnd;
  },
  result: function() {
    var centroid = Z2 ? [centroid_X2 / Z2, Y2 / Z2]
        : Z1 ? [centroid_X1 / Z1, centroid_Y1 / Z1]
        : Z0 ? [centroid_X0 / Z0, centroid_Y0 / Z0]
        : [NaN, NaN];
    centroid_X0 = centroid_Y0 = Z0 =
    centroid_X1 = centroid_Y1 = Z1 =
    centroid_X2 = Y2 = Z2 = 0;
    return centroid;
  }
};

function centroidPoint(x, y) {
  centroid_X0 += x;
  centroid_Y0 += y;
  ++Z0;
}

function centroidLineStart() {
  centroidStream.point = centroidPointFirstLine;
}

function centroidPointFirstLine(x, y) {
  centroidStream.point = centroidPointLine;
  centroidPoint(centroid_x0 = x, centroid_y0 = y);
}

function centroidPointLine(x, y) {
  var dx = x - centroid_x0, dy = y - centroid_y0, z = math_sqrt(dx * dx + dy * dy);
  centroid_X1 += z * (centroid_x0 + x) / 2;
  centroid_Y1 += z * (centroid_y0 + y) / 2;
  Z1 += z;
  centroidPoint(centroid_x0 = x, centroid_y0 = y);
}

function centroidLineEnd() {
  centroidStream.point = centroidPoint;
}

function centroidRingStart() {
  centroidStream.point = centroidPointFirstRing;
}

function centroidRingEnd() {
  centroidPointRing(centroid_x00, centroid_y00);
}

function centroidPointFirstRing(x, y) {
  centroidStream.point = centroidPointRing;
  centroidPoint(centroid_x00 = centroid_x0 = x, centroid_y00 = centroid_y0 = y);
}

function centroidPointRing(x, y) {
  var dx = x - centroid_x0,
      dy = y - centroid_y0,
      z = math_sqrt(dx * dx + dy * dy);

  centroid_X1 += z * (centroid_x0 + x) / 2;
  centroid_Y1 += z * (centroid_y0 + y) / 2;
  Z1 += z;

  z = centroid_y0 * x - centroid_x0 * y;
  centroid_X2 += z * (centroid_x0 + x);
  Y2 += z * (centroid_y0 + y);
  Z2 += z * 3;
  centroidPoint(centroid_x0 = x, centroid_y0 = y);
}

/* harmony default export */ var centroid = (centroidStream);

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/context.js



function PathContext(context) {
  this._context = context;
}

PathContext.prototype = {
  _radius: 4.5,
  pointRadius: function(_) {
    return this._radius = _, this;
  },
  polygonStart: function() {
    this._line = 0;
  },
  polygonEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line === 0) this._context.closePath();
    this._point = NaN;
  },
  point: function(x, y) {
    switch (this._point) {
      case 0: {
        this._context.moveTo(x, y);
        this._point = 1;
        break;
      }
      case 1: {
        this._context.lineTo(x, y);
        break;
      }
      default: {
        this._context.moveTo(x + this._radius, y);
        this._context.arc(x, y, this._radius, 0, math_tau);
        break;
      }
    }
  },
  result: noop_noop
};

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/measure.js




var lengthSum = adder(),
    lengthRing,
    measure_x00,
    measure_y00,
    measure_x0,
    measure_y0;

var lengthStream = {
  point: noop_noop,
  lineStart: function() {
    lengthStream.point = lengthPointFirst;
  },
  lineEnd: function() {
    if (lengthRing) lengthPoint(measure_x00, measure_y00);
    lengthStream.point = noop_noop;
  },
  polygonStart: function() {
    lengthRing = true;
  },
  polygonEnd: function() {
    lengthRing = null;
  },
  result: function() {
    var length = +lengthSum;
    lengthSum.reset();
    return length;
  }
};

function lengthPointFirst(x, y) {
  lengthStream.point = lengthPoint;
  measure_x00 = measure_x0 = x, measure_y00 = measure_y0 = y;
}

function lengthPoint(x, y) {
  measure_x0 -= x, measure_y0 -= y;
  lengthSum.add(math_sqrt(measure_x0 * measure_x0 + measure_y0 * measure_y0));
  measure_x0 = x, measure_y0 = y;
}

/* harmony default export */ var path_measure = (lengthStream);

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/string.js
function PathString() {
  this._string = [];
}

PathString.prototype = {
  _radius: 4.5,
  _circle: string_circle(4.5),
  pointRadius: function(_) {
    if ((_ = +_) !== this._radius) this._radius = _, this._circle = null;
    return this;
  },
  polygonStart: function() {
    this._line = 0;
  },
  polygonEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line === 0) this._string.push("Z");
    this._point = NaN;
  },
  point: function(x, y) {
    switch (this._point) {
      case 0: {
        this._string.push("M", x, ",", y);
        this._point = 1;
        break;
      }
      case 1: {
        this._string.push("L", x, ",", y);
        break;
      }
      default: {
        if (this._circle == null) this._circle = string_circle(this._radius);
        this._string.push("M", x, ",", y, this._circle);
        break;
      }
    }
  },
  result: function() {
    if (this._string.length) {
      var result = this._string.join("");
      this._string = [];
      return result;
    } else {
      return null;
    }
  }
};

function string_circle(radius) {
  return "m0," + radius
      + "a" + radius + "," + radius + " 0 1,1 0," + -2 * radius
      + "a" + radius + "," + radius + " 0 1,1 0," + 2 * radius
      + "z";
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/path/index.js









/* harmony default export */ var d3_geo_src_path = (function(projection, context) {
  var pointRadius = 4.5,
      projectionStream,
      contextStream;

  function path(object) {
    if (object) {
      if (typeof pointRadius === "function") contextStream.pointRadius(+pointRadius.apply(this, arguments));
      src_stream(object, projectionStream(contextStream));
    }
    return contextStream.result();
  }

  path.area = function(object) {
    src_stream(object, projectionStream(path_area));
    return path_area.result();
  };

  path.measure = function(object) {
    src_stream(object, projectionStream(path_measure));
    return path_measure.result();
  };

  path.bounds = function(object) {
    src_stream(object, projectionStream(path_bounds));
    return path_bounds.result();
  };

  path.centroid = function(object) {
    src_stream(object, projectionStream(centroid));
    return centroid.result();
  };

  path.projection = function(_) {
    return arguments.length ? (projectionStream = _ == null ? (projection = null, d3_geo_src_identity) : (projection = _).stream, path) : projection;
  };

  path.context = function(_) {
    if (!arguments.length) return context;
    contextStream = _ == null ? (context = null, new PathString) : new PathContext(context = _);
    if (typeof pointRadius !== "function") contextStream.pointRadius(pointRadius);
    return path;
  };

  path.pointRadius = function(_) {
    if (!arguments.length) return pointRadius;
    pointRadius = typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
    return path;
  };

  return path.projection(projection).context(context);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/buffer.js


/* harmony default export */ var clip_buffer = (function() {
  var lines = [],
      line;
  return {
    point: function(x, y, m) {
      line.push([x, y, m]);
    },
    lineStart: function() {
      lines.push(line = []);
    },
    lineEnd: noop_noop,
    rejoin: function() {
      if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));
    },
    result: function() {
      var result = lines;
      lines = [];
      line = null;
      return result;
    }
  };
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/pointEqual.js


/* harmony default export */ var pointEqual = (function(a, b) {
  return math_abs(a[0] - b[0]) < src_math_epsilon && math_abs(a[1] - b[1]) < src_math_epsilon;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/rejoin.js



function Intersection(point, points, other, entry) {
  this.x = point;
  this.z = points;
  this.o = other; // another intersection
  this.e = entry; // is an entry?
  this.v = false; // visited
  this.n = this.p = null; // next & previous
}

// A generalized polygon clipping algorithm: given a polygon that has been cut
// into its visible line segments, and rejoins the segments by interpolating
// along the clip edge.
/* harmony default export */ var rejoin = (function(segments, compareIntersection, startInside, interpolate, stream) {
  var subject = [],
      clip = [],
      i,
      n;

  segments.forEach(function(segment) {
    if ((n = segment.length - 1) <= 0) return;
    var n, p0 = segment[0], p1 = segment[n], x;

    if (pointEqual(p0, p1)) {
      if (!p0[2] && !p1[2]) {
        stream.lineStart();
        for (i = 0; i < n; ++i) stream.point((p0 = segment[i])[0], p0[1]);
        stream.lineEnd();
        return;
      }
      // handle degenerate cases by moving the point
      p1[0] += 2 * src_math_epsilon;
    }

    subject.push(x = new Intersection(p0, segment, null, true));
    clip.push(x.o = new Intersection(p0, null, x, false));
    subject.push(x = new Intersection(p1, segment, null, false));
    clip.push(x.o = new Intersection(p1, null, x, true));
  });

  if (!subject.length) return;

  clip.sort(compareIntersection);
  rejoin_link(subject);
  rejoin_link(clip);

  for (i = 0, n = clip.length; i < n; ++i) {
    clip[i].e = startInside = !startInside;
  }

  var start = subject[0],
      points,
      point;

  while (1) {
    // Find first unvisited intersection.
    var current = start,
        isSubject = true;
    while (current.v) if ((current = current.n) === start) return;
    points = current.z;
    stream.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points.length; i < n; ++i) stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.n.x, 1, stream);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points = current.p.z;
          for (i = points.length - 1; i >= 0; --i) stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.p.x, -1, stream);
        }
        current = current.p;
      }
      current = current.o;
      points = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream.lineEnd();
  }
});

function rejoin_link(array) {
  if (!(n = array.length)) return;
  var n,
      i = 0,
      a = array[0],
      b;
  while (++i < n) {
    a.n = b = array[i];
    b.p = a;
    a = b;
  }
  a.n = b = array[0];
  b.p = a;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/cartesian.js


function cartesian_spherical(cartesian) {
  return [math_atan2(cartesian[1], cartesian[0]), math_asin(cartesian[2])];
}

function cartesian_cartesian(spherical) {
  var lambda = spherical[0], phi = spherical[1], cosPhi = src_math_cos(phi);
  return [cosPhi * src_math_cos(lambda), cosPhi * src_math_sin(lambda), src_math_sin(phi)];
}

function cartesianDot(a, b) {
  return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
}

function cartesianCross(a, b) {
  return [a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]];
}

// TODO return a
function cartesianAddInPlace(a, b) {
  a[0] += b[0], a[1] += b[1], a[2] += b[2];
}

function cartesianScale(vector, k) {
  return [vector[0] * k, vector[1] * k, vector[2] * k];
}

// TODO return d
function cartesianNormalizeInPlace(d) {
  var l = math_sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  d[0] /= l, d[1] /= l, d[2] /= l;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/polygonContains.js




var polygonContains_sum = adder();

function longitude(point) {
  if (math_abs(point[0]) <= math_pi)
    return point[0];
  else
    return math_sign(point[0]) * ((math_abs(point[0]) + math_pi) % math_tau - math_pi);
}

/* harmony default export */ var polygonContains = (function(polygon, point) {
  var lambda = longitude(point),
      phi = point[1],
      sinPhi = src_math_sin(phi),
      normal = [src_math_sin(lambda), -src_math_cos(lambda), 0],
      angle = 0,
      winding = 0;

  polygonContains_sum.reset();

  if (sinPhi === 1) phi = math_halfPi + src_math_epsilon;
  else if (sinPhi === -1) phi = -math_halfPi - src_math_epsilon;

  for (var i = 0, n = polygon.length; i < n; ++i) {
    if (!(m = (ring = polygon[i]).length)) continue;
    var ring,
        m,
        point0 = ring[m - 1],
        lambda0 = longitude(point0),
        phi0 = point0[1] / 2 + quarterPi,
        sinPhi0 = src_math_sin(phi0),
        cosPhi0 = src_math_cos(phi0);

    for (var j = 0; j < m; ++j, lambda0 = lambda1, sinPhi0 = sinPhi1, cosPhi0 = cosPhi1, point0 = point1) {
      var point1 = ring[j],
          lambda1 = longitude(point1),
          phi1 = point1[1] / 2 + quarterPi,
          sinPhi1 = src_math_sin(phi1),
          cosPhi1 = src_math_cos(phi1),
          delta = lambda1 - lambda0,
          sign = delta >= 0 ? 1 : -1,
          absDelta = sign * delta,
          antimeridian = absDelta > math_pi,
          k = sinPhi0 * sinPhi1;

      polygonContains_sum.add(math_atan2(k * sign * src_math_sin(absDelta), cosPhi0 * cosPhi1 + k * src_math_cos(absDelta)));
      angle += antimeridian ? delta + sign * math_tau : delta;

      // Are the longitudes either side of the point’s meridian (lambda),
      // and are the latitudes smaller than the parallel (phi)?
      if (antimeridian ^ lambda0 >= lambda ^ lambda1 >= lambda) {
        var arc = cartesianCross(cartesian_cartesian(point0), cartesian_cartesian(point1));
        cartesianNormalizeInPlace(arc);
        var intersection = cartesianCross(normal, arc);
        cartesianNormalizeInPlace(intersection);
        var phiArc = (antimeridian ^ delta >= 0 ? -1 : 1) * math_asin(intersection[2]);
        if (phi > phiArc || phi === phiArc && (arc[0] || arc[1])) {
          winding += antimeridian ^ delta >= 0 ? 1 : -1;
        }
      }
    }
  }

  // First, determine whether the South pole is inside or outside:
  //
  // It is inside if:
  // * the polygon winds around it in a clockwise direction.
  // * the polygon does not (cumulatively) wind around it, but has a negative
  //   (counter-clockwise) area.
  //
  // Second, count the (signed) number of times a segment crosses a lambda
  // from the point to the South pole.  If it is zero, then the point is the
  // same side as the South pole.

  return (angle < -src_math_epsilon || angle < src_math_epsilon && polygonContains_sum < -src_math_epsilon) ^ (winding & 1);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/ascending.js
/* harmony default export */ var src_ascending = (function(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/bisector.js


/* harmony default export */ var src_bisector = (function(compare) {
  if (compare.length === 1) compare = bisector_ascendingComparator(compare);
  return {
    left: function(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) < 0) lo = mid + 1;
        else hi = mid;
      }
      return lo;
    },
    right: function(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) > 0) hi = mid;
        else lo = mid + 1;
      }
      return lo;
    }
  };
});

function bisector_ascendingComparator(f) {
  return function(d, x) {
    return src_ascending(f(d), x);
  };
}

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/bisect.js



var bisect_ascendingBisect = src_bisector(src_ascending);
var bisect_bisectRight = bisect_ascendingBisect.right;
var bisect_bisectLeft = bisect_ascendingBisect.left;
/* harmony default export */ var node_modules_d3_array_src_bisect = (bisect_bisectRight);

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/pairs.js
/* harmony default export */ var pairs = (function(array, f) {
  if (f == null) f = pair;
  var i = 0, n = array.length - 1, p = array[0], pairs = new Array(n < 0 ? 0 : n);
  while (i < n) pairs[i] = f(p, p = array[++i]);
  return pairs;
});

function pair(a, b) {
  return [a, b];
}

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/cross.js


/* harmony default export */ var src_cross = (function(values0, values1, reduce) {
  var n0 = values0.length,
      n1 = values1.length,
      values = new Array(n0 * n1),
      i0,
      i1,
      i,
      value0;

  if (reduce == null) reduce = pair;

  for (i0 = i = 0; i0 < n0; ++i0) {
    for (value0 = values0[i0], i1 = 0; i1 < n1; ++i1, ++i) {
      values[i] = reduce(value0, values1[i1]);
    }
  }

  return values;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/descending.js
/* harmony default export */ var src_descending = (function(a, b) {
  return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/number.js
/* harmony default export */ var d3_array_src_number = (function(x) {
  return x === null ? NaN : +x;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/variance.js


/* harmony default export */ var src_variance = (function(values, valueof) {
  var n = values.length,
      m = 0,
      i = -1,
      mean = 0,
      value,
      delta,
      sum = 0;

  if (valueof == null) {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(values[i]))) {
        delta = value - mean;
        mean += delta / ++m;
        sum += delta * (value - mean);
      }
    }
  }

  else {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(valueof(values[i], i, values)))) {
        delta = value - mean;
        mean += delta / ++m;
        sum += delta * (value - mean);
      }
    }
  }

  if (m > 1) return sum / (m - 1);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/deviation.js


/* harmony default export */ var src_deviation = (function(array, f) {
  var v = src_variance(array, f);
  return v ? Math.sqrt(v) : v;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/extent.js
/* harmony default export */ var src_extent = (function(values, valueof) {
  var n = values.length,
      i = -1,
      value,
      min,
      max;

  if (valueof == null) {
    while (++i < n) { // Find the first comparable value.
      if ((value = values[i]) != null && value >= value) {
        min = max = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = values[i]) != null) {
            if (min > value) min = value;
            if (max < value) max = value;
          }
        }
      }
    }
  }

  else {
    while (++i < n) { // Find the first comparable value.
      if ((value = valueof(values[i], i, values)) != null && value >= value) {
        min = max = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = valueof(values[i], i, values)) != null) {
            if (min > value) min = value;
            if (max < value) max = value;
          }
        }
      }
    }
  }

  return [min, max];
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/array.js
var array_array = Array.prototype;

var array_slice = array_array.slice;
var array_map = array_array.map;

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/constant.js
/* harmony default export */ var d3_array_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/identity.js
/* harmony default export */ var d3_array_src_identity = (function(x) {
  return x;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/range.js
/* harmony default export */ var d3_array_src_range = (function(start, stop, step) {
  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;

  var i = -1,
      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
      range = new Array(n);

  while (++i < n) {
    range[i] = start + i * step;
  }

  return range;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/ticks.js
var ticks_e10 = Math.sqrt(50),
    ticks_e5 = Math.sqrt(10),
    ticks_e2 = Math.sqrt(2);

/* harmony default export */ var d3_array_src_ticks = (function(start, stop, count) {
  var reverse,
      i = -1,
      n,
      ticks,
      step;

  stop = +stop, start = +start, count = +count;
  if (start === stop && count > 0) return [start];
  if (reverse = stop < start) n = start, start = stop, stop = n;
  if ((step = ticks_tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];

  if (step > 0) {
    start = Math.ceil(start / step);
    stop = Math.floor(stop / step);
    ticks = new Array(n = Math.ceil(stop - start + 1));
    while (++i < n) ticks[i] = (start + i) * step;
  } else {
    start = Math.floor(start * step);
    stop = Math.ceil(stop * step);
    ticks = new Array(n = Math.ceil(start - stop + 1));
    while (++i < n) ticks[i] = (start - i) / step;
  }

  if (reverse) ticks.reverse();

  return ticks;
});

function ticks_tickIncrement(start, stop, count) {
  var step = (stop - start) / Math.max(0, count),
      power = Math.floor(Math.log(step) / Math.LN10),
      error = step / Math.pow(10, power);
  return power >= 0
      ? (error >= ticks_e10 ? 10 : error >= ticks_e5 ? 5 : error >= ticks_e2 ? 2 : 1) * Math.pow(10, power)
      : -Math.pow(10, -power) / (error >= ticks_e10 ? 10 : error >= ticks_e5 ? 5 : error >= ticks_e2 ? 2 : 1);
}

function ticks_tickStep(start, stop, count) {
  var step0 = Math.abs(stop - start) / Math.max(0, count),
      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
      error = step0 / step1;
  if (error >= ticks_e10) step1 *= 10;
  else if (error >= ticks_e5) step1 *= 5;
  else if (error >= ticks_e2) step1 *= 2;
  return stop < start ? -step1 : step1;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/threshold/sturges.js
/* harmony default export */ var sturges = (function(values) {
  return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/histogram.js









/* harmony default export */ var src_histogram = (function() {
  var value = d3_array_src_identity,
      domain = src_extent,
      threshold = sturges;

  function histogram(data) {
    var i,
        n = data.length,
        x,
        values = new Array(n);

    for (i = 0; i < n; ++i) {
      values[i] = value(data[i], i, data);
    }

    var xz = domain(values),
        x0 = xz[0],
        x1 = xz[1],
        tz = threshold(values, x0, x1);

    // Convert number of thresholds into uniform thresholds.
    if (!Array.isArray(tz)) {
      tz = ticks_tickStep(x0, x1, tz);
      tz = d3_array_src_range(Math.ceil(x0 / tz) * tz, x1, tz); // exclusive
    }

    // Remove any thresholds outside the domain.
    var m = tz.length;
    while (tz[0] <= x0) tz.shift(), --m;
    while (tz[m - 1] > x1) tz.pop(), --m;

    var bins = new Array(m + 1),
        bin;

    // Initialize bins.
    for (i = 0; i <= m; ++i) {
      bin = bins[i] = [];
      bin.x0 = i > 0 ? tz[i - 1] : x0;
      bin.x1 = i < m ? tz[i] : x1;
    }

    // Assign data to bins by value, ignoring any outside the domain.
    for (i = 0; i < n; ++i) {
      x = values[i];
      if (x0 <= x && x <= x1) {
        bins[node_modules_d3_array_src_bisect(tz, x, 0, m)].push(data[i]);
      }
    }

    return bins;
  }

  histogram.value = function(_) {
    return arguments.length ? (value = typeof _ === "function" ? _ : d3_array_src_constant(_), histogram) : value;
  };

  histogram.domain = function(_) {
    return arguments.length ? (domain = typeof _ === "function" ? _ : d3_array_src_constant([_[0], _[1]]), histogram) : domain;
  };

  histogram.thresholds = function(_) {
    return arguments.length ? (threshold = typeof _ === "function" ? _ : Array.isArray(_) ? d3_array_src_constant(array_slice.call(_)) : d3_array_src_constant(_), histogram) : threshold;
  };

  return histogram;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/quantile.js


/* harmony default export */ var src_quantile = (function(values, p, valueof) {
  if (valueof == null) valueof = d3_array_src_number;
  if (!(n = values.length)) return;
  if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);
  if (p >= 1) return +valueof(values[n - 1], n - 1, values);
  var n,
      i = (n - 1) * p,
      i0 = Math.floor(i),
      value0 = +valueof(values[i0], i0, values),
      value1 = +valueof(values[i0 + 1], i0 + 1, values);
  return value0 + (value1 - value0) * (i - i0);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/threshold/freedmanDiaconis.js





/* harmony default export */ var freedmanDiaconis = (function(values, min, max) {
  values = array_map.call(values, d3_array_src_number).sort(src_ascending);
  return Math.ceil((max - min) / (2 * (src_quantile(values, 0.75) - src_quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/threshold/scott.js


/* harmony default export */ var scott = (function(values, min, max) {
  return Math.ceil((max - min) / (3.5 * src_deviation(values) * Math.pow(values.length, -1 / 3)));
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/max.js
/* harmony default export */ var src_max = (function(values, valueof) {
  var n = values.length,
      i = -1,
      value,
      max;

  if (valueof == null) {
    while (++i < n) { // Find the first comparable value.
      if ((value = values[i]) != null && value >= value) {
        max = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = values[i]) != null && value > max) {
            max = value;
          }
        }
      }
    }
  }

  else {
    while (++i < n) { // Find the first comparable value.
      if ((value = valueof(values[i], i, values)) != null && value >= value) {
        max = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = valueof(values[i], i, values)) != null && value > max) {
            max = value;
          }
        }
      }
    }
  }

  return max;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/mean.js


/* harmony default export */ var src_mean = (function(values, valueof) {
  var n = values.length,
      m = n,
      i = -1,
      value,
      sum = 0;

  if (valueof == null) {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(values[i]))) sum += value;
      else --m;
    }
  }

  else {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(valueof(values[i], i, values)))) sum += value;
      else --m;
    }
  }

  if (m) return sum / m;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/median.js




/* harmony default export */ var src_median = (function(values, valueof) {
  var n = values.length,
      i = -1,
      value,
      numbers = [];

  if (valueof == null) {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(values[i]))) {
        numbers.push(value);
      }
    }
  }

  else {
    while (++i < n) {
      if (!isNaN(value = d3_array_src_number(valueof(values[i], i, values)))) {
        numbers.push(value);
      }
    }
  }

  return src_quantile(numbers.sort(src_ascending), 0.5);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/merge.js
/* harmony default export */ var src_merge = (function(arrays) {
  var n = arrays.length,
      m,
      i = -1,
      j = 0,
      merged,
      array;

  while (++i < n) j += arrays[i].length;
  merged = new Array(j);

  while (--n >= 0) {
    array = arrays[n];
    m = array.length;
    while (--m >= 0) {
      merged[--j] = array[m];
    }
  }

  return merged;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/min.js
/* harmony default export */ var src_min = (function(values, valueof) {
  var n = values.length,
      i = -1,
      value,
      min;

  if (valueof == null) {
    while (++i < n) { // Find the first comparable value.
      if ((value = values[i]) != null && value >= value) {
        min = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = values[i]) != null && min > value) {
            min = value;
          }
        }
      }
    }
  }

  else {
    while (++i < n) { // Find the first comparable value.
      if ((value = valueof(values[i], i, values)) != null && value >= value) {
        min = value;
        while (++i < n) { // Compare the remaining values.
          if ((value = valueof(values[i], i, values)) != null && min > value) {
            min = value;
          }
        }
      }
    }
  }

  return min;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/permute.js
/* harmony default export */ var permute = (function(array, indexes) {
  var i = indexes.length, permutes = new Array(i);
  while (i--) permutes[i] = array[indexes[i]];
  return permutes;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/scan.js


/* harmony default export */ var scan = (function(values, compare) {
  if (!(n = values.length)) return;
  var n,
      i = 0,
      j = 0,
      xi,
      xj = values[j];

  if (compare == null) compare = src_ascending;

  while (++i < n) {
    if (compare(xi = values[i], xj) < 0 || compare(xj, xj) !== 0) {
      xj = xi, j = i;
    }
  }

  if (compare(xj, xj) === 0) return j;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/shuffle.js
/* harmony default export */ var shuffle = (function(array, i0, i1) {
  var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
      t,
      i;

  while (m) {
    i = Math.random() * m-- | 0;
    t = array[m + i0];
    array[m + i0] = array[i + i0];
    array[i + i0] = t;
  }

  return array;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/sum.js
/* harmony default export */ var src_sum = (function(values, valueof) {
  var n = values.length,
      i = -1,
      value,
      sum = 0;

  if (valueof == null) {
    while (++i < n) {
      if (value = +values[i]) sum += value; // Note: zero and null are equivalent.
    }
  }

  else {
    while (++i < n) {
      if (value = +valueof(values[i], i, values)) sum += value;
    }
  }

  return sum;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/transpose.js


/* harmony default export */ var src_transpose = (function(matrix) {
  if (!(n = matrix.length)) return [];
  for (var i = -1, m = src_min(matrix, transpose_length), transpose = new Array(m); ++i < m;) {
    for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
      row[j] = matrix[j][i];
    }
  }
  return transpose;
});

function transpose_length(d) {
  return d.length;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/zip.js


/* harmony default export */ var zip = (function() {
  return src_transpose(arguments);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/node_modules/d3-array/src/index.js




























// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/index.js






/* harmony default export */ var src_clip = (function(pointVisible, clipLine, interpolate, start) {
  return function(sink) {
    var line = clipLine(sink),
        ringBuffer = clip_buffer(),
        ringSink = clipLine(ringBuffer),
        polygonStarted = false,
        polygon,
        segments,
        ring;

    var clip = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function() {
        clip.point = pointRing;
        clip.lineStart = ringStart;
        clip.lineEnd = ringEnd;
        segments = [];
        polygon = [];
      },
      polygonEnd: function() {
        clip.point = point;
        clip.lineStart = lineStart;
        clip.lineEnd = lineEnd;
        segments = src_merge(segments);
        var startInside = polygonContains(polygon, start);
        if (segments.length) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          rejoin(segments, clip_compareIntersection, startInside, interpolate, sink);
        } else if (startInside) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          interpolate(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted) sink.polygonEnd(), polygonStarted = false;
        segments = polygon = null;
      },
      sphere: function() {
        sink.polygonStart();
        sink.lineStart();
        interpolate(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      }
    };

    function point(lambda, phi) {
      if (pointVisible(lambda, phi)) sink.point(lambda, phi);
    }

    function pointLine(lambda, phi) {
      line.point(lambda, phi);
    }

    function lineStart() {
      clip.point = pointLine;
      line.lineStart();
    }

    function lineEnd() {
      clip.point = point;
      line.lineEnd();
    }

    function pointRing(lambda, phi) {
      ring.push([lambda, phi]);
      ringSink.point(lambda, phi);
    }

    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }

    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();

      var clean = ringSink.clean(),
          ringSegments = ringBuffer.result(),
          i, n = ringSegments.length, m,
          segment,
          point;

      ring.pop();
      polygon.push(ring);
      ring = null;

      if (!n) return;

      // No intersections.
      if (clean & 1) {
        segment = ringSegments[0];
        if ((m = segment.length - 1) > 0) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          for (i = 0; i < m; ++i) sink.point((point = segment[i])[0], point[1]);
          sink.lineEnd();
        }
        return;
      }

      // Rejoin connected segments.
      // TODO reuse ringBuffer.rejoin()?
      if (n > 1 && clean & 2) ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));

      segments.push(ringSegments.filter(validSegment));
    }

    return clip;
  };
});

function validSegment(segment) {
  return segment.length > 1;
}

// Intersections are sorted along the clip edge. For both antimeridian cutting
// and circle clipping, the same comparison is used.
function clip_compareIntersection(a, b) {
  return ((a = a.x)[0] < 0 ? a[1] - math_halfPi - src_math_epsilon : math_halfPi - a[1])
       - ((b = b.x)[0] < 0 ? b[1] - math_halfPi - src_math_epsilon : math_halfPi - b[1]);
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/antimeridian.js



/* harmony default export */ var clip_antimeridian = (src_clip(
  function() { return true; },
  clipAntimeridianLine,
  clipAntimeridianInterpolate,
  [-math_pi, -math_halfPi]
));

// Takes a line and cuts into visible segments. Return values: 0 - there were
// intersections or the line was empty; 1 - no intersections; 2 - there were
// intersections, and the first and last segments should be rejoined.
function clipAntimeridianLine(stream) {
  var lambda0 = NaN,
      phi0 = NaN,
      sign0 = NaN,
      clean; // no intersections

  return {
    lineStart: function() {
      stream.lineStart();
      clean = 1;
    },
    point: function(lambda1, phi1) {
      var sign1 = lambda1 > 0 ? math_pi : -math_pi,
          delta = math_abs(lambda1 - lambda0);
      if (math_abs(delta - math_pi) < src_math_epsilon) { // line crosses a pole
        stream.point(lambda0, phi0 = (phi0 + phi1) / 2 > 0 ? math_halfPi : -math_halfPi);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        stream.point(lambda1, phi0);
        clean = 0;
      } else if (sign0 !== sign1 && delta >= math_pi) { // line crosses antimeridian
        if (math_abs(lambda0 - sign0) < src_math_epsilon) lambda0 -= sign0 * src_math_epsilon; // handle degeneracies
        if (math_abs(lambda1 - sign1) < src_math_epsilon) lambda1 -= sign1 * src_math_epsilon;
        phi0 = clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        clean = 0;
      }
      stream.point(lambda0 = lambda1, phi0 = phi1);
      sign0 = sign1;
    },
    lineEnd: function() {
      stream.lineEnd();
      lambda0 = phi0 = NaN;
    },
    clean: function() {
      return 2 - clean; // if intersections, rejoin first and last segments
    }
  };
}

function clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1) {
  var cosPhi0,
      cosPhi1,
      sinLambda0Lambda1 = src_math_sin(lambda0 - lambda1);
  return math_abs(sinLambda0Lambda1) > src_math_epsilon
      ? atan((src_math_sin(phi0) * (cosPhi1 = src_math_cos(phi1)) * src_math_sin(lambda1)
          - src_math_sin(phi1) * (cosPhi0 = src_math_cos(phi0)) * src_math_sin(lambda0))
          / (cosPhi0 * cosPhi1 * sinLambda0Lambda1))
      : (phi0 + phi1) / 2;
}

function clipAntimeridianInterpolate(from, to, direction, stream) {
  var phi;
  if (from == null) {
    phi = direction * math_halfPi;
    stream.point(-math_pi, phi);
    stream.point(0, phi);
    stream.point(math_pi, phi);
    stream.point(math_pi, 0);
    stream.point(math_pi, -phi);
    stream.point(0, -phi);
    stream.point(-math_pi, -phi);
    stream.point(-math_pi, 0);
    stream.point(-math_pi, phi);
  } else if (math_abs(from[0] - to[0]) > src_math_epsilon) {
    var lambda = from[0] < to[0] ? math_pi : -math_pi;
    phi = direction * lambda / 2;
    stream.point(-lambda, phi);
    stream.point(0, phi);
    stream.point(lambda, phi);
  } else {
    stream.point(to[0], to[1]);
  }
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/constant.js
/* harmony default export */ var d3_geo_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/compose.js
/* harmony default export */ var compose = (function(a, b) {

  function compose(x, y) {
    return x = a(x, y), b(x[0], x[1]);
  }

  if (a.invert && b.invert) compose.invert = function(x, y) {
    return x = b.invert(x, y), x && a.invert(x[0], x[1]);
  };

  return compose;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/rotation.js



function rotationIdentity(lambda, phi) {
  return [math_abs(lambda) > math_pi ? lambda + Math.round(-lambda / math_tau) * math_tau : lambda, phi];
}

rotationIdentity.invert = rotationIdentity;

function rotateRadians(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= math_tau) ? (deltaPhi || deltaGamma ? compose(rotationLambda(deltaLambda), rotationPhiGamma(deltaPhi, deltaGamma))
    : rotationLambda(deltaLambda))
    : (deltaPhi || deltaGamma ? rotationPhiGamma(deltaPhi, deltaGamma)
    : rotationIdentity);
}

function forwardRotationLambda(deltaLambda) {
  return function(lambda, phi) {
    return lambda += deltaLambda, [lambda > math_pi ? lambda - math_tau : lambda < -math_pi ? lambda + math_tau : lambda, phi];
  };
}

function rotationLambda(deltaLambda) {
  var rotation = forwardRotationLambda(deltaLambda);
  rotation.invert = forwardRotationLambda(-deltaLambda);
  return rotation;
}

function rotationPhiGamma(deltaPhi, deltaGamma) {
  var cosDeltaPhi = src_math_cos(deltaPhi),
      sinDeltaPhi = src_math_sin(deltaPhi),
      cosDeltaGamma = src_math_cos(deltaGamma),
      sinDeltaGamma = src_math_sin(deltaGamma);

  function rotation(lambda, phi) {
    var cosPhi = src_math_cos(phi),
        x = src_math_cos(lambda) * cosPhi,
        y = src_math_sin(lambda) * cosPhi,
        z = src_math_sin(phi),
        k = z * cosDeltaPhi + x * sinDeltaPhi;
    return [
      math_atan2(y * cosDeltaGamma - k * sinDeltaGamma, x * cosDeltaPhi - z * sinDeltaPhi),
      math_asin(k * cosDeltaGamma + y * sinDeltaGamma)
    ];
  }

  rotation.invert = function(lambda, phi) {
    var cosPhi = src_math_cos(phi),
        x = src_math_cos(lambda) * cosPhi,
        y = src_math_sin(lambda) * cosPhi,
        z = src_math_sin(phi),
        k = z * cosDeltaGamma - y * sinDeltaGamma;
    return [
      math_atan2(y * cosDeltaGamma + z * sinDeltaGamma, x * cosDeltaPhi + k * sinDeltaPhi),
      math_asin(k * cosDeltaPhi - x * sinDeltaPhi)
    ];
  };

  return rotation;
}

/* harmony default export */ var src_rotation = (function(rotate) {
  rotate = rotateRadians(rotate[0] * radians, rotate[1] * radians, rotate.length > 2 ? rotate[2] * radians : 0);

  function forward(coordinates) {
    coordinates = rotate(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= math_degrees, coordinates[1] *= math_degrees, coordinates;
  }

  forward.invert = function(coordinates) {
    coordinates = rotate.invert(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= math_degrees, coordinates[1] *= math_degrees, coordinates;
  };

  return forward;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/circle.js





// Generates a circle centered at [0°, 0°], with a given radius and precision.
function circleStream(stream, radius, delta, direction, t0, t1) {
  if (!delta) return;
  var cosRadius = src_math_cos(radius),
      sinRadius = src_math_sin(radius),
      step = direction * delta;
  if (t0 == null) {
    t0 = radius + direction * math_tau;
    t1 = radius - step / 2;
  } else {
    t0 = circleRadius(cosRadius, t0);
    t1 = circleRadius(cosRadius, t1);
    if (direction > 0 ? t0 < t1 : t0 > t1) t0 += direction * math_tau;
  }
  for (var point, t = t0; direction > 0 ? t > t1 : t < t1; t -= step) {
    point = cartesian_spherical([cosRadius, -sinRadius * src_math_cos(t), -sinRadius * src_math_sin(t)]);
    stream.point(point[0], point[1]);
  }
}

// Returns the signed angle of a cartesian point relative to [cosRadius, 0, 0].
function circleRadius(cosRadius, point) {
  point = cartesian_cartesian(point), point[0] -= cosRadius;
  cartesianNormalizeInPlace(point);
  var radius = math_acos(-point[1]);
  return ((-point[2] < 0 ? -radius : radius) + math_tau - src_math_epsilon) % math_tau;
}

/* harmony default export */ var src_circle = (function() {
  var center = d3_geo_src_constant([0, 0]),
      radius = d3_geo_src_constant(90),
      precision = d3_geo_src_constant(6),
      ring,
      rotate,
      stream = {point: point};

  function point(x, y) {
    ring.push(x = rotate(x, y));
    x[0] *= math_degrees, x[1] *= math_degrees;
  }

  function circle() {
    var c = center.apply(this, arguments),
        r = radius.apply(this, arguments) * radians,
        p = precision.apply(this, arguments) * radians;
    ring = [];
    rotate = rotateRadians(-c[0] * radians, -c[1] * radians, 0).invert;
    circleStream(stream, r, p, 1);
    c = {type: "Polygon", coordinates: [ring]};
    ring = rotate = null;
    return c;
  }

  circle.center = function(_) {
    return arguments.length ? (center = typeof _ === "function" ? _ : d3_geo_src_constant([+_[0], +_[1]]), circle) : center;
  };

  circle.radius = function(_) {
    return arguments.length ? (radius = typeof _ === "function" ? _ : d3_geo_src_constant(+_), circle) : radius;
  };

  circle.precision = function(_) {
    return arguments.length ? (precision = typeof _ === "function" ? _ : d3_geo_src_constant(+_), circle) : precision;
  };

  return circle;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/circle.js






/* harmony default export */ var clip_circle = (function(radius) {
  var cr = src_math_cos(radius),
      delta = 6 * radians,
      smallRadius = cr > 0,
      notHemisphere = math_abs(cr) > src_math_epsilon; // TODO optimise for this common case

  function interpolate(from, to, direction, stream) {
    circleStream(stream, radius, delta, direction, from, to);
  }

  function visible(lambda, phi) {
    return src_math_cos(lambda) * src_math_cos(phi) > cr;
  }

  // Takes a line and cuts into visible segments. Return values used for polygon
  // clipping: 0 - there were intersections or the line was empty; 1 - no
  // intersections 2 - there were intersections, and the first and last segments
  // should be rejoined.
  function clipLine(stream) {
    var point0, // previous point
        c0, // code for previous point
        v0, // visibility of previous point
        v00, // visibility of first point
        clean; // no intersections
    return {
      lineStart: function() {
        v00 = v0 = false;
        clean = 1;
      },
      point: function(lambda, phi) {
        var point1 = [lambda, phi],
            point2,
            v = visible(lambda, phi),
            c = smallRadius
              ? v ? 0 : code(lambda, phi)
              : v ? code(lambda + (lambda < 0 ? math_pi : -math_pi), phi) : 0;
        if (!point0 && (v00 = v0 = v)) stream.lineStart();
        if (v !== v0) {
          point2 = intersect(point0, point1);
          if (!point2 || pointEqual(point0, point2) || pointEqual(point1, point2))
            point1[2] = 1;
        }
        if (v !== v0) {
          clean = 0;
          if (v) {
            // outside going in
            stream.lineStart();
            point2 = intersect(point1, point0);
            stream.point(point2[0], point2[1]);
          } else {
            // inside going out
            point2 = intersect(point0, point1);
            stream.point(point2[0], point2[1], 2);
            stream.lineEnd();
          }
          point0 = point2;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          // If the codes for two points are different, or are both zero,
          // and there this segment intersects with the small circle.
          if (!(c & c0) && (t = intersect(point1, point0, true))) {
            clean = 0;
            if (smallRadius) {
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
            } else {
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
              stream.lineStart();
              stream.point(t[0][0], t[0][1], 3);
            }
          }
        }
        if (v && (!point0 || !pointEqual(point0, point1))) {
          stream.point(point1[0], point1[1]);
        }
        point0 = point1, v0 = v, c0 = c;
      },
      lineEnd: function() {
        if (v0) stream.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function() {
        return clean | ((v00 && v0) << 1);
      }
    };
  }

  // Intersects the great circle between a and b with the clip circle.
  function intersect(a, b, two) {
    var pa = cartesian_cartesian(a),
        pb = cartesian_cartesian(b);

    // We have two planes, n1.p = d1 and n2.p = d2.
    // Find intersection line p(t) = c1 n1 + c2 n2 + t (n1 ⨯ n2).
    var n1 = [1, 0, 0], // normal
        n2 = cartesianCross(pa, pb),
        n2n2 = cartesianDot(n2, n2),
        n1n2 = n2[0], // cartesianDot(n1, n2),
        determinant = n2n2 - n1n2 * n1n2;

    // Two polar points.
    if (!determinant) return !two && a;

    var c1 =  cr * n2n2 / determinant,
        c2 = -cr * n1n2 / determinant,
        n1xn2 = cartesianCross(n1, n2),
        A = cartesianScale(n1, c1),
        B = cartesianScale(n2, c2);
    cartesianAddInPlace(A, B);

    // Solve |p(t)|^2 = 1.
    var u = n1xn2,
        w = cartesianDot(A, u),
        uu = cartesianDot(u, u),
        t2 = w * w - uu * (cartesianDot(A, A) - 1);

    if (t2 < 0) return;

    var t = math_sqrt(t2),
        q = cartesianScale(u, (-w - t) / uu);
    cartesianAddInPlace(q, A);
    q = cartesian_spherical(q);

    if (!two) return q;

    // Two intersection points.
    var lambda0 = a[0],
        lambda1 = b[0],
        phi0 = a[1],
        phi1 = b[1],
        z;

    if (lambda1 < lambda0) z = lambda0, lambda0 = lambda1, lambda1 = z;

    var delta = lambda1 - lambda0,
        polar = math_abs(delta - math_pi) < src_math_epsilon,
        meridian = polar || delta < src_math_epsilon;

    if (!polar && phi1 < phi0) z = phi0, phi0 = phi1, phi1 = z;

    // Check that the first point is between a and b.
    if (meridian
        ? polar
          ? phi0 + phi1 > 0 ^ q[1] < (math_abs(q[0] - lambda0) < src_math_epsilon ? phi0 : phi1)
          : phi0 <= q[1] && q[1] <= phi1
        : delta > math_pi ^ (lambda0 <= q[0] && q[0] <= lambda1)) {
      var q1 = cartesianScale(u, (-w + t) / uu);
      cartesianAddInPlace(q1, A);
      return [q, cartesian_spherical(q1)];
    }
  }

  // Generates a 4-bit vector representing the location of a point relative to
  // the small circle's bounding box.
  function code(lambda, phi) {
    var r = smallRadius ? radius : math_pi - radius,
        code = 0;
    if (lambda < -r) code |= 1; // left
    else if (lambda > r) code |= 2; // right
    if (phi < -r) code |= 4; // below
    else if (phi > r) code |= 8; // above
    return code;
  }

  return src_clip(visible, clipLine, interpolate, smallRadius ? [0, -radius] : [-math_pi, radius - math_pi]);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/line.js
/* harmony default export */ var clip_line = (function(a, b, x0, y0, x1, y1) {
  var ax = a[0],
      ay = a[1],
      bx = b[0],
      by = b[1],
      t0 = 0,
      t1 = 1,
      dx = bx - ax,
      dy = by - ay,
      r;

  r = x0 - ax;
  if (!dx && r > 0) return;
  r /= dx;
  if (dx < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dx > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = x1 - ax;
  if (!dx && r < 0) return;
  r /= dx;
  if (dx < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dx > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  r = y0 - ay;
  if (!dy && r > 0) return;
  r /= dy;
  if (dy < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dy > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = y1 - ay;
  if (!dy && r < 0) return;
  r /= dy;
  if (dy < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dy > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  if (t0 > 0) a[0] = ax + t0 * dx, a[1] = ay + t0 * dy;
  if (t1 < 1) b[0] = ax + t1 * dx, b[1] = ay + t1 * dy;
  return true;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/clip/rectangle.js






var clipMax = 1e9, clipMin = -clipMax;

// TODO Use d3-polygon’s polygonContains here for the ring check?
// TODO Eliminate duplicate buffering in clipBuffer and polygon.push?

function clipRectangle(x0, y0, x1, y1) {

  function visible(x, y) {
    return x0 <= x && x <= x1 && y0 <= y && y <= y1;
  }

  function interpolate(from, to, direction, stream) {
    var a = 0, a1 = 0;
    if (from == null
        || (a = corner(from, direction)) !== (a1 = corner(to, direction))
        || comparePoint(from, to) < 0 ^ direction > 0) {
      do stream.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0);
      while ((a = (a + direction + 4) % 4) !== a1);
    } else {
      stream.point(to[0], to[1]);
    }
  }

  function corner(p, direction) {
    return math_abs(p[0] - x0) < src_math_epsilon ? direction > 0 ? 0 : 3
        : math_abs(p[0] - x1) < src_math_epsilon ? direction > 0 ? 2 : 1
        : math_abs(p[1] - y0) < src_math_epsilon ? direction > 0 ? 1 : 0
        : direction > 0 ? 3 : 2; // abs(p[1] - y1) < epsilon
  }

  function compareIntersection(a, b) {
    return comparePoint(a.x, b.x);
  }

  function comparePoint(a, b) {
    var ca = corner(a, 1),
        cb = corner(b, 1);
    return ca !== cb ? ca - cb
        : ca === 0 ? b[1] - a[1]
        : ca === 1 ? a[0] - b[0]
        : ca === 2 ? a[1] - b[1]
        : b[0] - a[0];
  }

  return function(stream) {
    var activeStream = stream,
        bufferStream = clip_buffer(),
        segments,
        polygon,
        ring,
        x__, y__, v__, // first point
        x_, y_, v_, // previous point
        first,
        clean;

    var clipStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: polygonStart,
      polygonEnd: polygonEnd
    };

    function point(x, y) {
      if (visible(x, y)) activeStream.point(x, y);
    }

    function polygonInside() {
      var winding = 0;

      for (var i = 0, n = polygon.length; i < n; ++i) {
        for (var ring = polygon[i], j = 1, m = ring.length, point = ring[0], a0, a1, b0 = point[0], b1 = point[1]; j < m; ++j) {
          a0 = b0, a1 = b1, point = ring[j], b0 = point[0], b1 = point[1];
          if (a1 <= y1) { if (b1 > y1 && (b0 - a0) * (y1 - a1) > (b1 - a1) * (x0 - a0)) ++winding; }
          else { if (b1 <= y1 && (b0 - a0) * (y1 - a1) < (b1 - a1) * (x0 - a0)) --winding; }
        }
      }

      return winding;
    }

    // Buffer geometry within a polygon and then clip it en masse.
    function polygonStart() {
      activeStream = bufferStream, segments = [], polygon = [], clean = true;
    }

    function polygonEnd() {
      var startInside = polygonInside(),
          cleanInside = clean && startInside,
          visible = (segments = src_merge(segments)).length;
      if (cleanInside || visible) {
        stream.polygonStart();
        if (cleanInside) {
          stream.lineStart();
          interpolate(null, null, 1, stream);
          stream.lineEnd();
        }
        if (visible) {
          rejoin(segments, compareIntersection, startInside, interpolate, stream);
        }
        stream.polygonEnd();
      }
      activeStream = stream, segments = polygon = ring = null;
    }

    function lineStart() {
      clipStream.point = linePoint;
      if (polygon) polygon.push(ring = []);
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }

    // TODO rather than special-case polygons, simply handle them separately.
    // Ideally, coincident intersection points should be jittered to avoid
    // clipping issues.
    function lineEnd() {
      if (segments) {
        linePoint(x__, y__);
        if (v__ && v_) bufferStream.rejoin();
        segments.push(bufferStream.result());
      }
      clipStream.point = point;
      if (v_) activeStream.lineEnd();
    }

    function linePoint(x, y) {
      var v = visible(x, y);
      if (polygon) ring.push([x, y]);
      if (first) {
        x__ = x, y__ = y, v__ = v;
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x, y);
        }
      } else {
        if (v && v_) activeStream.point(x, y);
        else {
          var a = [x_ = Math.max(clipMin, Math.min(clipMax, x_)), y_ = Math.max(clipMin, Math.min(clipMax, y_))],
              b = [x = Math.max(clipMin, Math.min(clipMax, x)), y = Math.max(clipMin, Math.min(clipMax, y))];
          if (clip_line(a, b, x0, y0, x1, y1)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a[0], a[1]);
            }
            activeStream.point(b[0], b[1]);
            if (!v) activeStream.lineEnd();
            clean = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x, y);
            clean = false;
          }
        }
      }
      x_ = x, y_ = y, v_ = v;
    }

    return clipStream;
  };
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/transform.js
/* harmony default export */ var d3_geo_src_transform = (function(methods) {
  return {
    stream: transform_transformer(methods)
  };
});

function transform_transformer(methods) {
  return function(stream) {
    var s = new TransformStream;
    for (var key in methods) s[key] = methods[key];
    s.stream = stream;
    return s;
  };
}

function TransformStream() {}

TransformStream.prototype = {
  constructor: TransformStream,
  point: function(x, y) { this.stream.point(x, y); },
  sphere: function() { this.stream.sphere(); },
  lineStart: function() { this.stream.lineStart(); },
  lineEnd: function() { this.stream.lineEnd(); },
  polygonStart: function() { this.stream.polygonStart(); },
  polygonEnd: function() { this.stream.polygonEnd(); }
};

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/fit.js



function fit_fit(projection, fitBounds, object) {
  var clip = projection.clipExtent && projection.clipExtent();
  projection.scale(150).translate([0, 0]);
  if (clip != null) projection.clipExtent(null);
  src_stream(object, projection.stream(path_bounds));
  fitBounds(path_bounds.result());
  if (clip != null) projection.clipExtent(clip);
  return projection;
}

function fitExtent(projection, extent, object) {
  return fit_fit(projection, function(b) {
    var w = extent[1][0] - extent[0][0],
        h = extent[1][1] - extent[0][1],
        k = Math.min(w / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])),
        x = +extent[0][0] + (w - k * (b[1][0] + b[0][0])) / 2,
        y = +extent[0][1] + (h - k * (b[1][1] + b[0][1])) / 2;
    projection.scale(150 * k).translate([x, y]);
  }, object);
}

function fitSize(projection, size, object) {
  return fitExtent(projection, [[0, 0], size], object);
}

function fitWidth(projection, width, object) {
  return fit_fit(projection, function(b) {
    var w = +width,
        k = w / (b[1][0] - b[0][0]),
        x = (w - k * (b[1][0] + b[0][0])) / 2,
        y = -k * b[0][1];
    projection.scale(150 * k).translate([x, y]);
  }, object);
}

function fitHeight(projection, height, object) {
  return fit_fit(projection, function(b) {
    var h = +height,
        k = h / (b[1][1] - b[0][1]),
        x = -k * b[0][0],
        y = (h - k * (b[1][1] + b[0][1])) / 2;
    projection.scale(150 * k).translate([x, y]);
  }, object);
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/resample.js




var maxDepth = 16, // maximum depth of subdivision
    cosMinDistance = src_math_cos(30 * radians); // cos(minimum angular distance)

/* harmony default export */ var resample = (function(project, delta2) {
  return +delta2 ? resample_resample(project, delta2) : resampleNone(project);
});

function resampleNone(project) {
  return transform_transformer({
    point: function(x, y) {
      x = project(x, y);
      this.stream.point(x[0], x[1]);
    }
  });
}

function resample_resample(project, delta2) {

  function resampleLineTo(x0, y0, lambda0, a0, b0, c0, x1, y1, lambda1, a1, b1, c1, depth, stream) {
    var dx = x1 - x0,
        dy = y1 - y0,
        d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a = a0 + a1,
          b = b0 + b1,
          c = c0 + c1,
          m = math_sqrt(a * a + b * b + c * c),
          phi2 = math_asin(c /= m),
          lambda2 = math_abs(math_abs(c) - 1) < src_math_epsilon || math_abs(lambda0 - lambda1) < src_math_epsilon ? (lambda0 + lambda1) / 2 : math_atan2(b, a),
          p = project(lambda2, phi2),
          x2 = p[0],
          y2 = p[1],
          dx2 = x2 - x0,
          dy2 = y2 - y0,
          dz = dy * dx2 - dx * dy2;
      if (dz * dz / d2 > delta2 // perpendicular projected distance
          || math_abs((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 // midpoint close to an end
          || a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance) { // angular distance
        resampleLineTo(x0, y0, lambda0, a0, b0, c0, x2, y2, lambda2, a /= m, b /= m, c, depth, stream);
        stream.point(x2, y2);
        resampleLineTo(x2, y2, lambda2, a, b, c, x1, y1, lambda1, a1, b1, c1, depth, stream);
      }
    }
  }
  return function(stream) {
    var lambda00, x00, y00, a00, b00, c00, // first point
        lambda0, x0, y0, a0, b0, c0; // previous point

    var resampleStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function() { stream.polygonStart(); resampleStream.lineStart = ringStart; },
      polygonEnd: function() { stream.polygonEnd(); resampleStream.lineStart = lineStart; }
    };

    function point(x, y) {
      x = project(x, y);
      stream.point(x[0], x[1]);
    }

    function lineStart() {
      x0 = NaN;
      resampleStream.point = linePoint;
      stream.lineStart();
    }

    function linePoint(lambda, phi) {
      var c = cartesian_cartesian([lambda, phi]), p = project(lambda, phi);
      resampleLineTo(x0, y0, lambda0, a0, b0, c0, x0 = p[0], y0 = p[1], lambda0 = lambda, a0 = c[0], b0 = c[1], c0 = c[2], maxDepth, stream);
      stream.point(x0, y0);
    }

    function lineEnd() {
      resampleStream.point = point;
      stream.lineEnd();
    }

    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }

    function ringPoint(lambda, phi) {
      linePoint(lambda00 = lambda, phi), x00 = x0, y00 = y0, a00 = a0, b00 = b0, c00 = c0;
      resampleStream.point = linePoint;
    }

    function ringEnd() {
      resampleLineTo(x0, y0, lambda0, a0, b0, c0, x00, y00, lambda00, a00, b00, c00, maxDepth, stream);
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }

    return resampleStream;
  };
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/index.js











var transformRadians = transform_transformer({
  point: function(x, y) {
    this.stream.point(x * radians, y * radians);
  }
});

function transformRotate(rotate) {
  return transform_transformer({
    point: function(x, y) {
      var r = rotate(x, y);
      return this.stream.point(r[0], r[1]);
    }
  });
}

function scaleTranslate(k, dx, dy, sx, sy) {
  function transform(x, y) {
    x *= sx; y *= sy;
    return [dx + k * x, dy - k * y];
  }
  transform.invert = function(x, y) {
    return [(x - dx) / k * sx, (dy - y) / k * sy];
  };
  return transform;
}

function scaleTranslateRotate(k, dx, dy, sx, sy, alpha) {
  var cosAlpha = src_math_cos(alpha),
      sinAlpha = src_math_sin(alpha),
      a = cosAlpha * k,
      b = sinAlpha * k,
      ai = cosAlpha / k,
      bi = sinAlpha / k,
      ci = (sinAlpha * dy - cosAlpha * dx) / k,
      fi = (sinAlpha * dx + cosAlpha * dy) / k;
  function transform(x, y) {
    x *= sx; y *= sy;
    return [a * x - b * y + dx, dy - b * x - a * y];
  }
  transform.invert = function(x, y) {
    return [sx * (ai * x - bi * y + ci), sy * (fi - bi * x - ai * y)];
  };
  return transform;
}

function projection_projection(project) {
  return projectionMutator(function() { return project; })();
}

function projectionMutator(projectAt) {
  var project,
      k = 150, // scale
      x = 480, y = 250, // translate
      lambda = 0, phi = 0, // center
      deltaLambda = 0, deltaPhi = 0, deltaGamma = 0, rotate, // pre-rotate
      alpha = 0, // post-rotate angle
      sx = 1, // reflectX
      sy = 1, // reflectX
      theta = null, preclip = clip_antimeridian, // pre-clip angle
      x0 = null, y0, x1, y1, postclip = d3_geo_src_identity, // post-clip extent
      delta2 = 0.5, // precision
      projectResample,
      projectTransform,
      projectRotateTransform,
      cache,
      cacheStream;

  function projection(point) {
    return projectRotateTransform(point[0] * radians, point[1] * radians);
  }

  function invert(point) {
    point = projectRotateTransform.invert(point[0], point[1]);
    return point && [point[0] * math_degrees, point[1] * math_degrees];
  }

  projection.stream = function(stream) {
    return cache && cacheStream === stream ? cache : cache = transformRadians(transformRotate(rotate)(preclip(projectResample(postclip(cacheStream = stream)))));
  };

  projection.preclip = function(_) {
    return arguments.length ? (preclip = _, theta = undefined, reset()) : preclip;
  };

  projection.postclip = function(_) {
    return arguments.length ? (postclip = _, x0 = y0 = x1 = y1 = null, reset()) : postclip;
  };

  projection.clipAngle = function(_) {
    return arguments.length ? (preclip = +_ ? clip_circle(theta = _ * radians) : (theta = null, clip_antimeridian), reset()) : theta * math_degrees;
  };

  projection.clipExtent = function(_) {
    return arguments.length ? (postclip = _ == null ? (x0 = y0 = x1 = y1 = null, d3_geo_src_identity) : clipRectangle(x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]), reset()) : x0 == null ? null : [[x0, y0], [x1, y1]];
  };

  projection.scale = function(_) {
    return arguments.length ? (k = +_, recenter()) : k;
  };

  projection.translate = function(_) {
    return arguments.length ? (x = +_[0], y = +_[1], recenter()) : [x, y];
  };

  projection.center = function(_) {
    return arguments.length ? (lambda = _[0] % 360 * radians, phi = _[1] % 360 * radians, recenter()) : [lambda * math_degrees, phi * math_degrees];
  };

  projection.rotate = function(_) {
    return arguments.length ? (deltaLambda = _[0] % 360 * radians, deltaPhi = _[1] % 360 * radians, deltaGamma = _.length > 2 ? _[2] % 360 * radians : 0, recenter()) : [deltaLambda * math_degrees, deltaPhi * math_degrees, deltaGamma * math_degrees];
  };

  projection.angle = function(_) {
    return arguments.length ? (alpha = _ % 360 * radians, recenter()) : alpha * math_degrees;
  };

  projection.reflectX = function(_) {
    return arguments.length ? (sx = _ ? -1 : 1, recenter()) : sx < 0;
  };

  projection.reflectY = function(_) {
    return arguments.length ? (sy = _ ? -1 : 1, recenter()) : sy < 0;
  };

  projection.precision = function(_) {
    return arguments.length ? (projectResample = resample(projectTransform, delta2 = _ * _), reset()) : math_sqrt(delta2);
  };

  projection.fitExtent = function(extent, object) {
    return fitExtent(projection, extent, object);
  };

  projection.fitSize = function(size, object) {
    return fitSize(projection, size, object);
  };

  projection.fitWidth = function(width, object) {
    return fitWidth(projection, width, object);
  };

  projection.fitHeight = function(height, object) {
    return fitHeight(projection, height, object);
  };

  function recenter() {
    var center = scaleTranslateRotate(k, 0, 0, sx, sy, alpha).apply(null, project(lambda, phi)),
        transform = (alpha ? scaleTranslateRotate : scaleTranslate)(k, x - center[0], y - center[1], sx, sy, alpha);
    rotate = rotateRadians(deltaLambda, deltaPhi, deltaGamma);
    projectTransform = compose(project, transform);
    projectRotateTransform = compose(rotate, projectTransform);
    projectResample = resample(projectTransform, delta2);
    return reset();
  }

  function reset() {
    cache = cacheStream = null;
    return projection;
  }

  return function() {
    project = projectAt.apply(this, arguments);
    projection.invert = project.invert && invert;
    return recenter();
  };
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/conic.js



function conicProjection(projectAt) {
  var phi0 = 0,
      phi1 = math_pi / 3,
      m = projectionMutator(projectAt),
      p = m(phi0, phi1);

  p.parallels = function(_) {
    return arguments.length ? m(phi0 = _[0] * radians, phi1 = _[1] * radians) : [phi0 * math_degrees, phi1 * math_degrees];
  };

  return p;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/cylindricalEqualArea.js


function cylindricalEqualAreaRaw(phi0) {
  var cosPhi0 = src_math_cos(phi0);

  function forward(lambda, phi) {
    return [lambda * cosPhi0, src_math_sin(phi) / cosPhi0];
  }

  forward.invert = function(x, y) {
    return [x / cosPhi0, math_asin(y * cosPhi0)];
  };

  return forward;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/conicEqualArea.js




function conicEqualAreaRaw(y0, y1) {
  var sy0 = src_math_sin(y0), n = (sy0 + src_math_sin(y1)) / 2;

  // Are the parallels symmetrical around the Equator?
  if (math_abs(n) < src_math_epsilon) return cylindricalEqualAreaRaw(y0);

  var c = 1 + sy0 * (2 * n - sy0), r0 = math_sqrt(c) / n;

  function project(x, y) {
    var r = math_sqrt(c - 2 * n * src_math_sin(y)) / n;
    return [r * src_math_sin(x *= n), r0 - r * src_math_cos(x)];
  }

  project.invert = function(x, y) {
    var r0y = r0 - y,
        l = math_atan2(x, math_abs(r0y)) * math_sign(r0y);
    if (r0y * n < 0)
      l -= math_pi * math_sign(x) * math_sign(r0y);
    return [l / n, math_asin((c - (x * x + r0y * r0y) * n * n) / (2 * n))];
  };

  return project;
}

/* harmony default export */ var conicEqualArea = (function() {
  return conicProjection(conicEqualAreaRaw)
      .scale(155.424)
      .center([0, 33.6442]);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/albers.js


/* harmony default export */ var albers = (function() {
  return conicEqualArea()
      .parallels([29.5, 45.5])
      .scale(1070)
      .translate([480, 250])
      .rotate([96, 0])
      .center([-0.6, 38.7]);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/albersUsa.js





// The projections must have mutually exclusive clip regions on the sphere,
// as this will avoid emitting interleaving lines and polygons.
function multiplex(streams) {
  var n = streams.length;
  return {
    point: function(x, y) { var i = -1; while (++i < n) streams[i].point(x, y); },
    sphere: function() { var i = -1; while (++i < n) streams[i].sphere(); },
    lineStart: function() { var i = -1; while (++i < n) streams[i].lineStart(); },
    lineEnd: function() { var i = -1; while (++i < n) streams[i].lineEnd(); },
    polygonStart: function() { var i = -1; while (++i < n) streams[i].polygonStart(); },
    polygonEnd: function() { var i = -1; while (++i < n) streams[i].polygonEnd(); }
  };
}

// A composite projection for the United States, configured by default for
// 960×500. The projection also works quite well at 960×600 if you change the
// scale to 1285 and adjust the translate accordingly. The set of standard
// parallels for each region comes from USGS, which is published here:
// http://egsc.usgs.gov/isb/pubs/MapProjections/projections.html#albers
/* harmony default export */ var projection_albersUsa = (function() {
  var cache,
      cacheStream,
      lower48 = albers(), lower48Point,
      alaska = conicEqualArea().rotate([154, 0]).center([-2, 58.5]).parallels([55, 65]), alaskaPoint, // EPSG:3338
      hawaii = conicEqualArea().rotate([157, 0]).center([-3, 19.9]).parallels([8, 18]), hawaiiPoint, // ESRI:102007
      point, pointStream = {point: function(x, y) { point = [x, y]; }};

  function albersUsa(coordinates) {
    var x = coordinates[0], y = coordinates[1];
    return point = null,
        (lower48Point.point(x, y), point)
        || (alaskaPoint.point(x, y), point)
        || (hawaiiPoint.point(x, y), point);
  }

  albersUsa.invert = function(coordinates) {
    var k = lower48.scale(),
        t = lower48.translate(),
        x = (coordinates[0] - t[0]) / k,
        y = (coordinates[1] - t[1]) / k;
    return (y >= 0.120 && y < 0.234 && x >= -0.425 && x < -0.214 ? alaska
        : y >= 0.166 && y < 0.234 && x >= -0.214 && x < -0.115 ? hawaii
        : lower48).invert(coordinates);
  };

  albersUsa.stream = function(stream) {
    return cache && cacheStream === stream ? cache : cache = multiplex([lower48.stream(cacheStream = stream), alaska.stream(stream), hawaii.stream(stream)]);
  };

  albersUsa.precision = function(_) {
    if (!arguments.length) return lower48.precision();
    lower48.precision(_), alaska.precision(_), hawaii.precision(_);
    return reset();
  };

  albersUsa.scale = function(_) {
    if (!arguments.length) return lower48.scale();
    lower48.scale(_), alaska.scale(_ * 0.35), hawaii.scale(_);
    return albersUsa.translate(lower48.translate());
  };

  albersUsa.translate = function(_) {
    if (!arguments.length) return lower48.translate();
    var k = lower48.scale(), x = +_[0], y = +_[1];

    lower48Point = lower48
        .translate(_)
        .clipExtent([[x - 0.455 * k, y - 0.238 * k], [x + 0.455 * k, y + 0.238 * k]])
        .stream(pointStream);

    alaskaPoint = alaska
        .translate([x - 0.307 * k, y + 0.201 * k])
        .clipExtent([[x - 0.425 * k + src_math_epsilon, y + 0.120 * k + src_math_epsilon], [x - 0.214 * k - src_math_epsilon, y + 0.234 * k - src_math_epsilon]])
        .stream(pointStream);

    hawaiiPoint = hawaii
        .translate([x - 0.205 * k, y + 0.212 * k])
        .clipExtent([[x - 0.214 * k + src_math_epsilon, y + 0.166 * k + src_math_epsilon], [x - 0.115 * k - src_math_epsilon, y + 0.234 * k - src_math_epsilon]])
        .stream(pointStream);

    return reset();
  };

  albersUsa.fitExtent = function(extent, object) {
    return fitExtent(albersUsa, extent, object);
  };

  albersUsa.fitSize = function(size, object) {
    return fitSize(albersUsa, size, object);
  };

  albersUsa.fitWidth = function(width, object) {
    return fitWidth(albersUsa, width, object);
  };

  albersUsa.fitHeight = function(height, object) {
    return fitHeight(albersUsa, height, object);
  };

  function reset() {
    cache = cacheStream = null;
    return albersUsa;
  }

  return albersUsa.scale(1070);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/azimuthal.js


function azimuthalRaw(scale) {
  return function(x, y) {
    var cx = src_math_cos(x),
        cy = src_math_cos(y),
        k = scale(cx * cy);
    return [
      k * cy * src_math_sin(x),
      k * src_math_sin(y)
    ];
  }
}

function azimuthalInvert(angle) {
  return function(x, y) {
    var z = math_sqrt(x * x + y * y),
        c = angle(z),
        sc = src_math_sin(c),
        cc = src_math_cos(c);
    return [
      math_atan2(x * sc, z * cc),
      math_asin(z && y * sc / z)
    ];
  }
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/azimuthalEqualArea.js




var azimuthalEqualAreaRaw = azimuthalRaw(function(cxcy) {
  return math_sqrt(2 / (1 + cxcy));
});

azimuthalEqualAreaRaw.invert = azimuthalInvert(function(z) {
  return 2 * math_asin(z / 2);
});

/* harmony default export */ var azimuthalEqualArea = (function() {
  return projection_projection(azimuthalEqualAreaRaw)
      .scale(124.75)
      .clipAngle(180 - 1e-3);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/azimuthalEquidistant.js




var azimuthalEquidistantRaw = azimuthalRaw(function(c) {
  return (c = math_acos(c)) && c / src_math_sin(c);
});

azimuthalEquidistantRaw.invert = azimuthalInvert(function(z) {
  return z;
});

/* harmony default export */ var azimuthalEquidistant = (function() {
  return projection_projection(azimuthalEquidistantRaw)
      .scale(79.4188)
      .clipAngle(180 - 1e-3);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/mercator.js




function mercatorRaw(lambda, phi) {
  return [lambda, math_log(tan((math_halfPi + phi) / 2))];
}

mercatorRaw.invert = function(x, y) {
  return [x, 2 * atan(math_exp(y)) - math_halfPi];
};

/* harmony default export */ var mercator = (function() {
  return mercatorProjection(mercatorRaw)
      .scale(961 / math_tau);
});

function mercatorProjection(project) {
  var m = projection_projection(project),
      center = m.center,
      scale = m.scale,
      translate = m.translate,
      clipExtent = m.clipExtent,
      x0 = null, y0, x1, y1; // clip extent

  m.scale = function(_) {
    return arguments.length ? (scale(_), reclip()) : scale();
  };

  m.translate = function(_) {
    return arguments.length ? (translate(_), reclip()) : translate();
  };

  m.center = function(_) {
    return arguments.length ? (center(_), reclip()) : center();
  };

  m.clipExtent = function(_) {
    return arguments.length ? ((_ == null ? x0 = y0 = x1 = y1 = null : (x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1])), reclip()) : x0 == null ? null : [[x0, y0], [x1, y1]];
  };

  function reclip() {
    var k = math_pi * scale(),
        t = m(src_rotation(m.rotate()).invert([0, 0]));
    return clipExtent(x0 == null
        ? [[t[0] - k, t[1] - k], [t[0] + k, t[1] + k]] : project === mercatorRaw
        ? [[Math.max(t[0] - k, x0), y0], [Math.min(t[0] + k, x1), y1]]
        : [[x0, Math.max(t[1] - k, y0)], [x1, Math.min(t[1] + k, y1)]]);
  }

  return reclip();
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/conicConformal.js




function tany(y) {
  return tan((math_halfPi + y) / 2);
}

function conicConformalRaw(y0, y1) {
  var cy0 = src_math_cos(y0),
      n = y0 === y1 ? src_math_sin(y0) : math_log(cy0 / src_math_cos(y1)) / math_log(tany(y1) / tany(y0)),
      f = cy0 * math_pow(tany(y0), n) / n;

  if (!n) return mercatorRaw;

  function project(x, y) {
    if (f > 0) { if (y < -math_halfPi + src_math_epsilon) y = -math_halfPi + src_math_epsilon; }
    else { if (y > math_halfPi - src_math_epsilon) y = math_halfPi - src_math_epsilon; }
    var r = f / math_pow(tany(y), n);
    return [r * src_math_sin(n * x), f - r * src_math_cos(n * x)];
  }

  project.invert = function(x, y) {
    var fy = f - y, r = math_sign(n) * math_sqrt(x * x + fy * fy),
      l = math_atan2(x, math_abs(fy)) * math_sign(fy);
    if (fy * n < 0)
      l -= math_pi * math_sign(x) * math_sign(fy);
    return [l / n, 2 * atan(math_pow(f / r, 1 / n)) - math_halfPi];
  };

  return project;
}

/* harmony default export */ var conicConformal = (function() {
  return conicProjection(conicConformalRaw)
      .scale(109.5)
      .parallels([30, 30]);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/equirectangular.js


function equirectangularRaw(lambda, phi) {
  return [lambda, phi];
}

equirectangularRaw.invert = equirectangularRaw;

/* harmony default export */ var equirectangular = (function() {
  return projection_projection(equirectangularRaw)
      .scale(152.63);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/conicEquidistant.js




function conicEquidistantRaw(y0, y1) {
  var cy0 = src_math_cos(y0),
      n = y0 === y1 ? src_math_sin(y0) : (cy0 - src_math_cos(y1)) / (y1 - y0),
      g = cy0 / n + y0;

  if (math_abs(n) < src_math_epsilon) return equirectangularRaw;

  function project(x, y) {
    var gy = g - y, nx = n * x;
    return [gy * src_math_sin(nx), g - gy * src_math_cos(nx)];
  }

  project.invert = function(x, y) {
    var gy = g - y,
        l = math_atan2(x, math_abs(gy)) * math_sign(gy);
    if (gy * n < 0)
      l -= math_pi * math_sign(x) * math_sign(gy);
    return [l / n, g - math_sign(n) * math_sqrt(x * x + gy * gy)];
  };

  return project;
}

/* harmony default export */ var conicEquidistant = (function() {
  return conicProjection(conicEquidistantRaw)
      .scale(131.154)
      .center([0, 13.9389]);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/equalEarth.js



var A1 = 1.340264,
    A2 = -0.081106,
    A3 = 0.000893,
    A4 = 0.003796,
    equalEarth_M = math_sqrt(3) / 2,
    equalEarth_iterations = 12;

function equalEarthRaw(lambda, phi) {
  var l = math_asin(equalEarth_M * src_math_sin(phi)), l2 = l * l, l6 = l2 * l2 * l2;
  return [
    lambda * src_math_cos(l) / (equalEarth_M * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2))),
    l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2))
  ];
}

equalEarthRaw.invert = function(x, y) {
  var l = y, l2 = l * l, l6 = l2 * l2 * l2;
  for (var i = 0, delta, fy, fpy; i < equalEarth_iterations; ++i) {
    fy = l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2)) - y;
    fpy = A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2);
    l -= delta = fy / fpy, l2 = l * l, l6 = l2 * l2 * l2;
    if (math_abs(delta) < math_epsilon2) break;
  }
  return [
    equalEarth_M * x * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2)) / src_math_cos(l),
    math_asin(src_math_sin(l) / equalEarth_M)
  ];
};

/* harmony default export */ var equalEarth = (function() {
  return projection_projection(equalEarthRaw)
      .scale(177.158);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/gnomonic.js




function gnomonicRaw(x, y) {
  var cy = src_math_cos(y), k = src_math_cos(x) * cy;
  return [cy * src_math_sin(x) / k, src_math_sin(y) / k];
}

gnomonicRaw.invert = azimuthalInvert(atan);

/* harmony default export */ var gnomonic = (function() {
  return projection_projection(gnomonicRaw)
      .scale(144.049)
      .clipAngle(60);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/identity.js






/* harmony default export */ var projection_identity = (function() {
  var k = 1, tx = 0, ty = 0, sx = 1, sy = 1, // scale, translate and reflect
      alpha = 0, ca, sa, // angle
      x0 = null, y0, x1, y1, // clip extent
      kx = 1, ky = 1,
      transform = transform_transformer({
        point: function(x, y) {
          var p = projection([x, y])
          this.stream.point(p[0], p[1]);
        }
      }),
      postclip = d3_geo_src_identity,
      cache,
      cacheStream;

  function reset() {
    kx = k * sx;
    ky = k * sy;
    cache = cacheStream = null;
    return projection;
  }

  function projection (p) {
    var x = p[0] * kx, y = p[1] * ky;
    if (alpha) {
      var t = y * ca - x * sa;
      x = x * ca + y * sa;
      y = t;
    }    
    return [x + tx, y + ty];
  }
  projection.invert = function(p) {
    var x = p[0] - tx, y = p[1] - ty;
    if (alpha) {
      var t = y * ca + x * sa;
      x = x * ca - y * sa;
      y = t;
    }
    return [x / kx, y / ky];
  };
  projection.stream = function(stream) {
    return cache && cacheStream === stream ? cache : cache = transform(postclip(cacheStream = stream));
  };
  projection.postclip = function(_) {
    return arguments.length ? (postclip = _, x0 = y0 = x1 = y1 = null, reset()) : postclip;
  };
  projection.clipExtent = function(_) {
    return arguments.length ? (postclip = _ == null ? (x0 = y0 = x1 = y1 = null, d3_geo_src_identity) : clipRectangle(x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]), reset()) : x0 == null ? null : [[x0, y0], [x1, y1]];
  };
  projection.scale = function(_) {
    return arguments.length ? (k = +_, reset()) : k;
  };
  projection.translate = function(_) {
    return arguments.length ? (tx = +_[0], ty = +_[1], reset()) : [tx, ty];
  }
  projection.angle = function(_) {
    return arguments.length ? (alpha = _ % 360 * radians, sa = src_math_sin(alpha), ca = src_math_cos(alpha), reset()) : alpha * math_degrees;
  };
  projection.reflectX = function(_) {
    return arguments.length ? (sx = _ ? -1 : 1, reset()) : sx < 0;
  };
  projection.reflectY = function(_) {
    return arguments.length ? (sy = _ ? -1 : 1, reset()) : sy < 0;
  };
  projection.fitExtent = function(extent, object) {
    return fitExtent(projection, extent, object);
  };
  projection.fitSize = function(size, object) {
    return fitSize(projection, size, object);
  };
  projection.fitWidth = function(width, object) {
    return fitWidth(projection, width, object);
  };
  projection.fitHeight = function(height, object) {
    return fitHeight(projection, height, object);
  };

  return projection;
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/naturalEarth1.js



function naturalEarth1Raw(lambda, phi) {
  var phi2 = phi * phi, phi4 = phi2 * phi2;
  return [
    lambda * (0.8707 - 0.131979 * phi2 + phi4 * (-0.013791 + phi4 * (0.003971 * phi2 - 0.001529 * phi4))),
    phi * (1.007226 + phi2 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4)))
  ];
}

naturalEarth1Raw.invert = function(x, y) {
  var phi = y, i = 25, delta;
  do {
    var phi2 = phi * phi, phi4 = phi2 * phi2;
    phi -= delta = (phi * (1.007226 + phi2 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4))) - y) /
        (1.007226 + phi2 * (0.015085 * 3 + phi4 * (-0.044475 * 7 + 0.028874 * 9 * phi2 - 0.005916 * 11 * phi4)));
  } while (math_abs(delta) > src_math_epsilon && --i > 0);
  return [
    x / (0.8707 + (phi2 = phi * phi) * (-0.131979 + phi2 * (-0.013791 + phi2 * phi2 * phi2 * (0.003971 - 0.001529 * phi2)))),
    phi
  ];
};

/* harmony default export */ var naturalEarth1 = (function() {
  return projection_projection(naturalEarth1Raw)
      .scale(175.295);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/orthographic.js




function orthographicRaw(x, y) {
  return [src_math_cos(y) * src_math_sin(x), src_math_sin(y)];
}

orthographicRaw.invert = azimuthalInvert(math_asin);

/* harmony default export */ var orthographic = (function() {
  return projection_projection(orthographicRaw)
      .scale(249.5)
      .clipAngle(90 + src_math_epsilon);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/stereographic.js




function stereographicRaw(x, y) {
  var cy = src_math_cos(y), k = 1 + src_math_cos(x) * cy;
  return [cy * src_math_sin(x) / k, src_math_sin(y) / k];
}

stereographicRaw.invert = azimuthalInvert(function(z) {
  return 2 * atan(z);
});

/* harmony default export */ var stereographic = (function() {
  return projection_projection(stereographicRaw)
      .scale(250)
      .clipAngle(142);
});

// CONCATENATED MODULE: ./node_modules/d3-geo/src/projection/transverseMercator.js



function transverseMercatorRaw(lambda, phi) {
  return [math_log(tan((math_halfPi + phi) / 2)), -lambda];
}

transverseMercatorRaw.invert = function(x, y) {
  return [-y, 2 * atan(math_exp(x)) - math_halfPi];
};

/* harmony default export */ var transverseMercator = (function() {
  var m = mercatorProjection(transverseMercatorRaw),
      center = m.center,
      rotate = m.rotate;

  m.center = function(_) {
    return arguments.length ? center([-_[1], _[0]]) : (_ = center(), [_[1], -_[0]]);
  };

  m.rotate = function(_) {
    return arguments.length ? rotate([_[0], _[1], _.length > 2 ? _[2] + 90 : 90]) : (_ = rotate(), [_[0], _[1], _[2] - 90]);
  };

  return rotate([0, 0, 90])
      .scale(159.155);
});

// CONCATENATED MODULE: ./node_modules/d3-geo-projection/src/math.js
var src_math_abs = Math.abs;
var math_atan = Math.atan;
var src_math_atan2 = Math.atan2;
var math_ceil = Math.ceil;
var d3_geo_projection_src_math_cos = Math.cos;
var src_math_exp = Math.exp;
var src_math_floor = Math.floor;
var src_math_log = Math.log;
var src_math_max = Math.max;
var src_math_min = Math.min;
var src_math_pow = Math.pow;
var math_round = Math.round;
var src_math_sign = Math.sign || function(x) { return x > 0 ? 1 : x < 0 ? -1 : 0; };
var d3_geo_projection_src_math_sin = Math.sin;
var math_tan = Math.tan;

var d3_geo_projection_src_math_epsilon = 1e-6;
var src_math_epsilon2 = 1e-12;
var src_math_pi = Math.PI;
var src_math_halfPi = src_math_pi / 2;
var math_quarterPi = src_math_pi / 4;
var sqrt1_2 = Math.SQRT1_2;
var sqrt2 = src_math_sqrt(2);
var sqrtPi = src_math_sqrt(src_math_pi);
var src_math_tau = src_math_pi * 2;
var src_math_degrees = 180 / src_math_pi;
var math_radians = src_math_pi / 180;

function sinci(x) {
  return x ? x / Math.sin(x) : 1;
}

function src_math_asin(x) {
  return x > 1 ? src_math_halfPi : x < -1 ? -src_math_halfPi : Math.asin(x);
}

function src_math_acos(x) {
  return x > 1 ? 0 : x < -1 ? src_math_pi : Math.acos(x);
}

function src_math_sqrt(x) {
  return x > 0 ? Math.sqrt(x) : 0;
}

function math_tanh(x) {
  x = src_math_exp(2 * x);
  return (x - 1) / (x + 1);
}

function math_sinh(x) {
  return (src_math_exp(x) - src_math_exp(-x)) / 2;
}

function math_cosh(x) {
  return (src_math_exp(x) + src_math_exp(-x)) / 2;
}

function arsinh(x) {
  return src_math_log(x + src_math_sqrt(x * x + 1));
}

function arcosh(x) {
  return src_math_log(x + src_math_sqrt(x * x - 1));
}

// CONCATENATED MODULE: ./node_modules/d3-geo-projection/src/mollweide.js



function mollweideBromleyTheta(cp, phi) {
  var cpsinPhi = cp * d3_geo_projection_src_math_sin(phi), i = 30, delta;
  do phi -= delta = (phi + d3_geo_projection_src_math_sin(phi) - cpsinPhi) / (1 + d3_geo_projection_src_math_cos(phi));
  while (src_math_abs(delta) > d3_geo_projection_src_math_epsilon && --i > 0);
  return phi / 2;
}

function mollweideBromleyRaw(cx, cy, cp) {

  function forward(lambda, phi) {
    return [cx * lambda * d3_geo_projection_src_math_cos(phi = mollweideBromleyTheta(cp, phi)), cy * d3_geo_projection_src_math_sin(phi)];
  }

  forward.invert = function(x, y) {
    return y = src_math_asin(y / cy), [x / (cx * d3_geo_projection_src_math_cos(y)), src_math_asin((2 * y + d3_geo_projection_src_math_sin(2 * y)) / cp)];
  };

  return forward;
}

var mollweideRaw = mollweideBromleyRaw(sqrt2 / src_math_halfPi, sqrt2, src_math_pi);

/* harmony default export */ var mollweide = (function() {
  return projection_projection(mollweideRaw)
      .scale(169.529);
});

// CONCATENATED MODULE: ./node_modules/vega-projection/src/projections.js




var defaultPath = d3_geo_src_path();

var projectionProperties = [
  // standard properties in d3-geo
  'clipAngle',
  'clipExtent',
  'scale',
  'translate',
  'center',
  'rotate',
  'parallels',
  'precision',
  'reflectX',
  'reflectY',

  // extended properties in d3-geo-projections
  'coefficient',
  'distance',
  'fraction',
  'lobes',
  'parallel',
  'radius',
  'ratio',
  'spacing',
  'tilt'
];

/**
 * Augment projections with their type and a copy method.
 */
function projections_create(type, constructor) {
  return function projection() {
    var p = constructor();

    p.type = type;

    p.path = d3_geo_src_path().projection(p);

    p.copy = p.copy || function() {
      var c = projection();
      projectionProperties.forEach(function(prop) {
        if (p[prop]) c[prop](p[prop]());
      });
      c.path.pointRadius(p.path.pointRadius());
      return c;
    };

    return p;
  };
}

function projections_projection(type, proj) {
  if (!type || typeof type !== 'string') {
    throw new Error('Projection type must be a name string.');
  }
  type = type.toLowerCase();
  if (arguments.length > 1) {
    projections[type] = projections_create(type, proj);
    return this;
  } else {
    return projections[type] || null;
  }
}

function getProjectionPath(proj) {
  return (proj && proj.path) || defaultPath;
}

var projections = {
  // base d3-geo projection types
  albers:               albers,
  albersusa:            projection_albersUsa,
  azimuthalequalarea:   azimuthalEqualArea,
  azimuthalequidistant: azimuthalEquidistant,
  conicconformal:       conicConformal,
  conicequalarea:       conicEqualArea,
  conicequidistant:     conicEquidistant,
  equalEarth:           equalEarth,
  equirectangular:      equirectangular,
  gnomonic:             gnomonic,
  identity:             projection_identity,
  mercator:             mercator,
  mollweide:            mollweide,
  naturalEarth1:        naturalEarth1,
  orthographic:         orthographic,
  stereographic:        stereographic,
  transversemercator:   transverseMercator
};

for (var projections_key in projections) {
  projections_projection(projections_key, projections[projections_key]);
}

// CONCATENATED MODULE: ./node_modules/vega-projection/index.js


// CONCATENATED MODULE: ./node_modules/vega-geo/src/GeoPath.js




/**
 * Map GeoJSON data to an SVG path string.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(number, number): *} params.projection - The cartographic
 *   projection to apply.
 * @param {function(object): *} [params.field] - The field with GeoJSON data,
 *   or null if the tuple itself is a GeoJSON feature.
 * @param {string} [params.as='path'] - The output field in which to store
 *   the generated path data (default 'path').
 */
function GeoPath(params) {
  Transform.call(this, null, params);
}

GeoPath.Definition = {
  'type': 'GeoPath',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'projection', 'type': 'projection' },
    { 'name': 'field', 'type': 'field' },
    { 'name': 'pointRadius', 'type': 'number', 'expr': true },
    { 'name': 'as', 'type': 'string', 'default': 'path' }
  ]
};

var GeoPath_prototype = Object(vega_util["y" /* inherits */])(GeoPath, Transform);

GeoPath_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.ALL),
      path = this.value,
      field = _.field || vega_util["x" /* identity */],
      as = _.as || 'path',
      flag = out.SOURCE;

  function set(t) { t[as] = path(field(t)); }

  if (!path || _.modified()) {
    // parameters updated, reset and reflow
    this.value = path = getProjectionPath(_.projection);
    out.materialize().reflow();
  } else {
    flag = field === vega_util["x" /* identity */] || pulse.modified(field.fields)
      ? out.ADD_MOD
      : out.ADD;
  }

  var prev = initPath(path, _.pointRadius);
  out.visit(flag, set);
  path.pointRadius(prev);

  return out.modifies(as);
};

function initPath(path, pointRadius) {
  var prev = path.pointRadius();
  path.context(null);
  if (pointRadius != null) {
    path.pointRadius(pointRadius);
  }
  return prev;
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/GeoPoint.js



/**
 * Geo-code a longitude/latitude point to an x/y coordinate.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(number, number): *} params.projection - The cartographic
 *   projection to apply.
 * @param {Array<function(object): *>} params.fields - A two-element array of
 *   field accessors for the longitude and latitude values.
 * @param {Array<string>} [params.as] - A two-element array of field names
 *   under which to store the result. Defaults to ['x','y'].
 */
function GeoPoint(params) {
  Transform.call(this, null, params);
}

GeoPoint.Definition = {
  'type': 'GeoPoint',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'projection', 'type': 'projection', 'required': true },
    { 'name': 'fields', 'type': 'field', 'array': true, 'required': true, 'length': 2 },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': 2, 'default': ['x', 'y'] }
  ]
};

var GeoPoint_prototype = Object(vega_util["y" /* inherits */])(GeoPoint, Transform);

GeoPoint_prototype.transform = function(_, pulse) {
  var proj = _.projection,
      lon = _.fields[0],
      lat = _.fields[1],
      as = _.as || ['x', 'y'],
      x = as[0],
      y = as[1],
      mod;

  function set(t) {
    var xy = proj([lon(t), lat(t)]);
    if (xy) {
      t[x] = xy[0];
      t[y] = xy[1];
    } else {
      t[x] = undefined;
      t[y] = undefined;
    }
  }

  if (_.modified()) {
    // parameters updated, reflow
    pulse = pulse.materialize().reflow(true).visit(pulse.SOURCE, set);
  } else {
    mod = pulse.modified(lon.fields) || pulse.modified(lat.fields);
    pulse.visit(mod ? pulse.ADD_MOD : pulse.ADD, set);
  }

  return pulse.modifies(as);
};

// CONCATENATED MODULE: ./node_modules/vega-geo/src/GeoShape.js




/**
 * Annotate items with a geopath shape generator.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(number, number): *} params.projection - The cartographic
 *   projection to apply.
 * @param {function(object): *} [params.field] - The field with GeoJSON data,
 *   or null if the tuple itself is a GeoJSON feature.
 * @param {string} [params.as='shape'] - The output field in which to store
 *   the generated path data (default 'shape').
 */
function GeoShape(params) {
  Transform.call(this, null, params);
}

GeoShape.Definition = {
  'type': 'GeoShape',
  'metadata': {'modifies': true, 'nomod': true},
  'params': [
    { 'name': 'projection', 'type': 'projection' },
    { 'name': 'field', 'type': 'field', 'default': 'datum' },
    { 'name': 'pointRadius', 'type': 'number', 'expr': true },
    { 'name': 'as', 'type': 'string', 'default': 'shape' }
  ]
};

var GeoShape_prototype = Object(vega_util["y" /* inherits */])(GeoShape, Transform);

GeoShape_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.ALL),
      shape = this.value,
      as = _.as || 'shape',
      flag = out.ADD;

  if (!shape || _.modified()) {
    // parameters updated, reset and reflow
    this.value = shape = shapeGenerator(
      getProjectionPath(_.projection),
      _.field || Object(vega_util["t" /* field */])('datum'),
      _.pointRadius
    );
    out.materialize().reflow();
    flag = out.SOURCE;
  }

  out.visit(flag, function(t) { t[as] = shape; });

  return out.modifies(as);
};

function shapeGenerator(path, field, pointRadius) {
  var shape = pointRadius == null
    ? function(_) { return path(field(_)); }
    : function(_) {
      var prev = path.pointRadius(),
          value = path.pointRadius(pointRadius)(field(_));
      path.pointRadius(prev);
      return value;
    };
  shape.context = function(_) {
    path.context(_);
    return shape;
  };

  return shape;
}

// CONCATENATED MODULE: ./node_modules/d3-geo/src/graticule.js



function graticuleX(y0, y1, dy) {
  var y = d3_array_src_range(y0, y1 - src_math_epsilon, dy).concat(y1);
  return function(x) { return y.map(function(y) { return [x, y]; }); };
}

function graticuleY(x0, x1, dx) {
  var x = d3_array_src_range(x0, x1 - src_math_epsilon, dx).concat(x1);
  return function(y) { return x.map(function(x) { return [x, y]; }); };
}

function graticule_graticule() {
  var x1, x0, X1, X0,
      y1, y0, Y1, Y0,
      dx = 10, dy = dx, DX = 90, DY = 360,
      x, y, X, Y,
      precision = 2.5;

  function graticule() {
    return {type: "MultiLineString", coordinates: lines()};
  }

  function lines() {
    return d3_array_src_range(ceil(X0 / DX) * DX, X1, DX).map(X)
        .concat(d3_array_src_range(ceil(Y0 / DY) * DY, Y1, DY).map(Y))
        .concat(d3_array_src_range(ceil(x0 / dx) * dx, x1, dx).filter(function(x) { return math_abs(x % DX) > src_math_epsilon; }).map(x))
        .concat(d3_array_src_range(ceil(y0 / dy) * dy, y1, dy).filter(function(y) { return math_abs(y % DY) > src_math_epsilon; }).map(y));
  }

  graticule.lines = function() {
    return lines().map(function(coordinates) { return {type: "LineString", coordinates: coordinates}; });
  };

  graticule.outline = function() {
    return {
      type: "Polygon",
      coordinates: [
        X(X0).concat(
        Y(Y1).slice(1),
        X(X1).reverse().slice(1),
        Y(Y0).reverse().slice(1))
      ]
    };
  };

  graticule.extent = function(_) {
    if (!arguments.length) return graticule.extentMinor();
    return graticule.extentMajor(_).extentMinor(_);
  };

  graticule.extentMajor = function(_) {
    if (!arguments.length) return [[X0, Y0], [X1, Y1]];
    X0 = +_[0][0], X1 = +_[1][0];
    Y0 = +_[0][1], Y1 = +_[1][1];
    if (X0 > X1) _ = X0, X0 = X1, X1 = _;
    if (Y0 > Y1) _ = Y0, Y0 = Y1, Y1 = _;
    return graticule.precision(precision);
  };

  graticule.extentMinor = function(_) {
    if (!arguments.length) return [[x0, y0], [x1, y1]];
    x0 = +_[0][0], x1 = +_[1][0];
    y0 = +_[0][1], y1 = +_[1][1];
    if (x0 > x1) _ = x0, x0 = x1, x1 = _;
    if (y0 > y1) _ = y0, y0 = y1, y1 = _;
    return graticule.precision(precision);
  };

  graticule.step = function(_) {
    if (!arguments.length) return graticule.stepMinor();
    return graticule.stepMajor(_).stepMinor(_);
  };

  graticule.stepMajor = function(_) {
    if (!arguments.length) return [DX, DY];
    DX = +_[0], DY = +_[1];
    return graticule;
  };

  graticule.stepMinor = function(_) {
    if (!arguments.length) return [dx, dy];
    dx = +_[0], dy = +_[1];
    return graticule;
  };

  graticule.precision = function(_) {
    if (!arguments.length) return precision;
    precision = +_;
    x = graticuleX(y0, y1, 90);
    y = graticuleY(x0, x1, precision);
    X = graticuleX(Y0, Y1, 90);
    Y = graticuleY(X0, X1, precision);
    return graticule;
  };

  return graticule
      .extentMajor([[-180, -90 + src_math_epsilon], [180, 90 - src_math_epsilon]])
      .extentMinor([[-180, -80 - src_math_epsilon], [180, 80 + src_math_epsilon]]);
}

function graticule10() {
  return graticule_graticule()();
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/Graticule.js




/**
 * GeoJSON feature generator for creating graticules.
 * @constructor
 */
function Graticule(params) {
  Transform.call(this, [], params);
  this.generator = graticule_graticule();
}

Graticule.Definition = {
  'type': 'Graticule',
  'metadata': {'changes': true, 'generates': true},
  'params': [
    { 'name': 'extent', 'type': 'array', 'array': true, 'length': 2,
      'content': {'type': 'number', 'array': true, 'length': 2} },
    { 'name': 'extentMajor', 'type': 'array', 'array': true, 'length': 2,
      'content': {'type': 'number', 'array': true, 'length': 2} },
    { 'name': 'extentMinor', 'type': 'array', 'array': true, 'length': 2,
      'content': {'type': 'number', 'array': true, 'length': 2} },
    { 'name': 'step', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'stepMajor', 'type': 'number', 'array': true, 'length': 2, 'default': [90, 360] },
    { 'name': 'stepMinor', 'type': 'number', 'array': true, 'length': 2, 'default': [10, 10] },
    { 'name': 'precision', 'type': 'number', 'default': 2.5 }
  ]
};

var Graticule_prototype = Object(vega_util["y" /* inherits */])(Graticule, Transform);

Graticule_prototype.transform = function(_, pulse) {
  var src = this.value,
      gen = this.generator, t;

  if (!src.length || _.modified()) {
    for (var prop in _) {
      if (Object(vega_util["D" /* isFunction */])(gen[prop])) {
        gen[prop](_[prop]);
      }
    }
  }

  t = gen();
  if (src.length) {
    pulse.mod.push(replace(src[0], t));
  } else {
    pulse.add.push(ingest(t));
  }
  src[0] = t;

  return pulse;
};

// CONCATENATED MODULE: ./node_modules/vega-geo/src/Heatmap.js






/**
 * Render a heatmap image for input raster grid data.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} [params.field] - The field with raster grid
 *   data. If unspecified, the tuple itself is interpreted as a raster grid.
 * @param {string} [params.color] - A constant color value or function for
 *   individual pixel color. If a function, it will be invoked with an input
 *   object that includes $x, $y, $value, and $max fields for the grid.
 * @param {number} [params.opacity] - A constant opacity value or function for
 *   individual pixel opacity. If a function, it will be invoked with an input
 *   object that includes $x, $y, $value, and $max fields for the grid.
 * @param {string} [params.resolve] - The method for resolving maximum values
 *   across multiple input grids. If 'independent' (the default), maximum
 *   calculation will be performed separately for each grid. If 'shared',
 *   a single global maximum will be used for all input grids.
 * @param {string} [params.as='image'] - The output field in which to store
 *   the generated bitmap canvas images (default 'image').
 */
function Heatmap(params) {
  Transform.call(this, null, params);
}

Heatmap.Definition = {
  'type': 'heatmap',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'color', 'type': 'string', 'expr': true},
    { 'name': 'opacity', 'type': 'number', 'expr': true},
    { 'name': 'resolve', 'type': 'enum', 'values': ['shared', 'independent'], 'default': 'independent' },
    { 'name': 'as', 'type': 'string', 'default': 'image' }
  ]
};

var Heatmap_prototype = Object(vega_util["y" /* inherits */])(Heatmap, Transform);

Heatmap_prototype.transform = function(_, pulse) {
  if (!pulse.changed() && !_.modified()) {
    return pulse.StopPropagation;
  }

  var source = pulse.materialize(pulse.SOURCE).source,
      shared = _.resolve === 'shared',
      field = _.field || vega_util["x" /* identity */],
      opacity = opacity_(_.opacity, _),
      color = color_(_.color, _),
      as = _.as || 'image',
      obj = {
        $x: 0, $y: 0, $value: 0,
        $max: shared ? max_max(source.map(t => max_max(field(t).values))) : 0
      };

  source.forEach(t => {
    const v = field(t);

    // build proxy data object
    const o = Object(vega_util["o" /* extend */])({}, t, obj);
    // set maximum value if not globally shared
    if (!shared) o.$max = max_max(v.values || []);

    // generate canvas image
    // optimize color/opacity if not pixel-dependent
    t[as] = toCanvas(v, o,
      color.dep ? color : Object(vega_util["l" /* constant */])(color(o)),
      opacity.dep ? opacity : Object(vega_util["l" /* constant */])(opacity(o))
    );
  });

  return pulse.reflow(true).modifies(as);
};

// get image color function
function color_(color, _) {
  let f;
  if (Object(vega_util["D" /* isFunction */])(color)) {
    f = obj => color_rgb(color(obj, _));
    f.dep = dependency(color);
  } else {
    // default to mid-grey
    f = Object(vega_util["l" /* constant */])(color_rgb(color || '#888'));
  }
  return f;
}

// get image opacity function
function opacity_(opacity, _) {
  let f;
  if (Object(vega_util["D" /* isFunction */])(opacity)) {
    f = obj => opacity(obj, _);
    f.dep = dependency(opacity);
  } else if (opacity) {
    f = Object(vega_util["l" /* constant */])(opacity);
  } else {
    // default to [0, max] opacity gradient
    f = obj => (obj.$value / obj.$max) || 0;
    f.dep = true;
  }
  return f;
}

// check if function depends on individual pixel data
function dependency(f) {
  if (!Object(vega_util["D" /* isFunction */])(f)) return false;
  const set = Object(vega_util["db" /* toSet */])(Object(vega_util["g" /* accessorFields */])(f));
  return set.$x || set.$y || set.$value || set.$max;
}

// render raster grid to canvas
function toCanvas(grid, obj, color, opacity) {
  const n = grid.width,
        m = grid.height,
        x1 = grid.x1 || 0,
        y1 = grid.y1 || 0,
        x2 = grid.x2 || n,
        y2 = grid.y2 || m,
        val = grid.values,
        value = val ? i => val[i] : vega_util["kb" /* zero */],
        can = domCanvas(x2 - x1, y2 - y1),
        ctx = can.getContext('2d'),
        img = ctx.getImageData(0, 0, x2 - x1, y2 - y1),
        pix = img.data;

  for (let j=y1, k=0; j<y2; ++j) {
    obj.$y = j - y1;
    for (let i=x1, r=j*n; i<x2; ++i, k+=4) {
      obj.$x = i - x1;
      obj.$value = value(i + r);

      const v = color(obj);
      pix[k+0] = v.r;
      pix[k+1] = v.g;
      pix[k+2] = v.b;
      pix[k+3] = ~~(255 * opacity(obj));
    }
  }

  ctx.putImageData(img, 0, 0);
  return can;
}

// CONCATENATED MODULE: ./node_modules/vega-geo/src/Projection.js





/**
 * Maintains a cartographic projection.
 * @constructor
 * @param {object} params - The parameters for this operator.
 */
function Projection(params) {
  Transform.call(this, null, params);
  this.modified(true); // always treat as modified
}

var Projection_prototype = Object(vega_util["y" /* inherits */])(Projection, Transform);

Projection_prototype.transform = function(_, pulse) {
  var proj = this.value;

  if (!proj || _.modified('type')) {
    this.value = (proj = Projection_create(_.type));
    projectionProperties.forEach(function(prop) {
      if (_[prop] != null) Projection_set(proj, prop, _[prop]);
    });
  } else {
    projectionProperties.forEach(function(prop) {
      if (_.modified(prop)) Projection_set(proj, prop, _[prop]);
    });
  }

  if (_.pointRadius != null) proj.path.pointRadius(_.pointRadius);
  if (_.fit) Projection_fit(proj, _);

  return pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);
};

function Projection_fit(proj, _) {
  var data = collectGeoJSON(_.fit);
  _.extent ? proj.fitExtent(_.extent, data)
    : _.size ? proj.fitSize(_.size, data) : 0;
}

function Projection_create(type) {
  var constructor = projections_projection((type || 'mercator').toLowerCase());
  if (!constructor) Object(vega_util["n" /* error */])('Unrecognized projection type: ' + type);
  return constructor();
}

function Projection_set(proj, key, value) {
   if (Object(vega_util["D" /* isFunction */])(proj[key])) proj[key](value);
}

function collectGeoJSON(data) {
  data = Object(vega_util["i" /* array */])(data);
  return data.length === 1 ? data[0]
    : {
        type: FeatureCollection,
        features: data.reduce((a, f) => a.concat(featurize(f)), [])
      };
}

function featurize(f) {
  return f.type === FeatureCollection
    ? f.features
    : Object(vega_util["i" /* array */])(f).filter(d => d != null).map(
        d => d.type === Feature ? d : {type: Feature, geometry: d}
      );
}

// CONCATENATED MODULE: ./node_modules/vega-geo/index.js











// CONCATENATED MODULE: ./node_modules/d3-force/src/center.js
/* harmony default export */ var src_center = (function(x, y) {
  var nodes;

  if (x == null) x = 0;
  if (y == null) y = 0;

  function force() {
    var i,
        n = nodes.length,
        node,
        sx = 0,
        sy = 0;

    for (i = 0; i < n; ++i) {
      node = nodes[i], sx += node.x, sy += node.y;
    }

    for (sx = sx / n - x, sy = sy / n - y, i = 0; i < n; ++i) {
      node = nodes[i], node.x -= sx, node.y -= sy;
    }
  }

  force.initialize = function(_) {
    nodes = _;
  };

  force.x = function(_) {
    return arguments.length ? (x = +_, force) : x;
  };

  force.y = function(_) {
    return arguments.length ? (y = +_, force) : y;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/add.js
/* harmony default export */ var src_add = (function(d) {
  var x = +this._x.call(null, d),
      y = +this._y.call(null, d);
  return add_add(this.cover(x, y), x, y, d);
});

function add_add(tree, x, y, d) {
  if (isNaN(x) || isNaN(y)) return tree; // ignore invalid points

  var parent,
      node = tree._root,
      leaf = {data: d},
      x0 = tree._x0,
      y0 = tree._y0,
      x1 = tree._x1,
      y1 = tree._y1,
      xm,
      ym,
      xp,
      yp,
      right,
      bottom,
      i,
      j;

  // If the tree is empty, initialize the root as a leaf.
  if (!node) return tree._root = leaf, tree;

  // Find the existing leaf for the new point, or add it.
  while (node.length) {
    if (right = x >= (xm = (x0 + x1) / 2)) x0 = xm; else x1 = xm;
    if (bottom = y >= (ym = (y0 + y1) / 2)) y0 = ym; else y1 = ym;
    if (parent = node, !(node = node[i = bottom << 1 | right])) return parent[i] = leaf, tree;
  }

  // Is the new point is exactly coincident with the existing point?
  xp = +tree._x.call(null, node.data);
  yp = +tree._y.call(null, node.data);
  if (x === xp && y === yp) return leaf.next = node, parent ? parent[i] = leaf : tree._root = leaf, tree;

  // Otherwise, split the leaf node until the old and new point are separated.
  do {
    parent = parent ? parent[i] = new Array(4) : tree._root = new Array(4);
    if (right = x >= (xm = (x0 + x1) / 2)) x0 = xm; else x1 = xm;
    if (bottom = y >= (ym = (y0 + y1) / 2)) y0 = ym; else y1 = ym;
  } while ((i = bottom << 1 | right) === (j = (yp >= ym) << 1 | (xp >= xm)));
  return parent[j] = node, parent[i] = leaf, tree;
}

function addAll(data) {
  var d, i, n = data.length,
      x,
      y,
      xz = new Array(n),
      yz = new Array(n),
      x0 = Infinity,
      y0 = Infinity,
      x1 = -Infinity,
      y1 = -Infinity;

  // Compute the points and their extent.
  for (i = 0; i < n; ++i) {
    if (isNaN(x = +this._x.call(null, d = data[i])) || isNaN(y = +this._y.call(null, d))) continue;
    xz[i] = x;
    yz[i] = y;
    if (x < x0) x0 = x;
    if (x > x1) x1 = x;
    if (y < y0) y0 = y;
    if (y > y1) y1 = y;
  }

  // If there were no (valid) points, abort.
  if (x0 > x1 || y0 > y1) return this;

  // Expand the tree to cover the new points.
  this.cover(x0, y0).cover(x1, y1);

  // Add the new points.
  for (i = 0; i < n; ++i) {
    add_add(this, xz[i], yz[i], data[i]);
  }

  return this;
}

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/cover.js
/* harmony default export */ var cover = (function(x, y) {
  if (isNaN(x = +x) || isNaN(y = +y)) return this; // ignore invalid points

  var x0 = this._x0,
      y0 = this._y0,
      x1 = this._x1,
      y1 = this._y1;

  // If the quadtree has no extent, initialize them.
  // Integer extent are necessary so that if we later double the extent,
  // the existing quadrant boundaries don’t change due to floating point error!
  if (isNaN(x0)) {
    x1 = (x0 = Math.floor(x)) + 1;
    y1 = (y0 = Math.floor(y)) + 1;
  }

  // Otherwise, double repeatedly to cover.
  else {
    var z = x1 - x0,
        node = this._root,
        parent,
        i;

    while (x0 > x || x >= x1 || y0 > y || y >= y1) {
      i = (y < y0) << 1 | (x < x0);
      parent = new Array(4), parent[i] = node, node = parent, z *= 2;
      switch (i) {
        case 0: x1 = x0 + z, y1 = y0 + z; break;
        case 1: x0 = x1 - z, y1 = y0 + z; break;
        case 2: x1 = x0 + z, y0 = y1 - z; break;
        case 3: x0 = x1 - z, y0 = y1 - z; break;
      }
    }

    if (this._root && this._root.length) this._root = node;
  }

  this._x0 = x0;
  this._y0 = y0;
  this._x1 = x1;
  this._y1 = y1;
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/data.js
/* harmony default export */ var src_data = (function() {
  var data = [];
  this.visit(function(node) {
    if (!node.length) do data.push(node.data); while (node = node.next)
  });
  return data;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/extent.js
/* harmony default export */ var d3_quadtree_src_extent = (function(_) {
  return arguments.length
      ? this.cover(+_[0][0], +_[0][1]).cover(+_[1][0], +_[1][1])
      : isNaN(this._x0) ? undefined : [[this._x0, this._y0], [this._x1, this._y1]];
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/quad.js
/* harmony default export */ var src_quad = (function(node, x0, y0, x1, y1) {
  this.node = node;
  this.x0 = x0;
  this.y0 = y0;
  this.x1 = x1;
  this.y1 = y1;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/find.js


/* harmony default export */ var src_find = (function(x, y, radius) {
  var data,
      x0 = this._x0,
      y0 = this._y0,
      x1,
      y1,
      x2,
      y2,
      x3 = this._x1,
      y3 = this._y1,
      quads = [],
      node = this._root,
      q,
      i;

  if (node) quads.push(new src_quad(node, x0, y0, x3, y3));
  if (radius == null) radius = Infinity;
  else {
    x0 = x - radius, y0 = y - radius;
    x3 = x + radius, y3 = y + radius;
    radius *= radius;
  }

  while (q = quads.pop()) {

    // Stop searching if this quadrant can’t contain a closer node.
    if (!(node = q.node)
        || (x1 = q.x0) > x3
        || (y1 = q.y0) > y3
        || (x2 = q.x1) < x0
        || (y2 = q.y1) < y0) continue;

    // Bisect the current quadrant.
    if (node.length) {
      var xm = (x1 + x2) / 2,
          ym = (y1 + y2) / 2;

      quads.push(
        new src_quad(node[3], xm, ym, x2, y2),
        new src_quad(node[2], x1, ym, xm, y2),
        new src_quad(node[1], xm, y1, x2, ym),
        new src_quad(node[0], x1, y1, xm, ym)
      );

      // Visit the closest quadrant first.
      if (i = (y >= ym) << 1 | (x >= xm)) {
        q = quads[quads.length - 1];
        quads[quads.length - 1] = quads[quads.length - 1 - i];
        quads[quads.length - 1 - i] = q;
      }
    }

    // Visit this point. (Visiting coincident points isn’t necessary!)
    else {
      var dx = x - +this._x.call(null, node.data),
          dy = y - +this._y.call(null, node.data),
          d2 = dx * dx + dy * dy;
      if (d2 < radius) {
        var d = Math.sqrt(radius = d2);
        x0 = x - d, y0 = y - d;
        x3 = x + d, y3 = y + d;
        data = node.data;
      }
    }
  }

  return data;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/remove.js
/* harmony default export */ var src_remove = (function(d) {
  if (isNaN(x = +this._x.call(null, d)) || isNaN(y = +this._y.call(null, d))) return this; // ignore invalid points

  var parent,
      node = this._root,
      retainer,
      previous,
      next,
      x0 = this._x0,
      y0 = this._y0,
      x1 = this._x1,
      y1 = this._y1,
      x,
      y,
      xm,
      ym,
      right,
      bottom,
      i,
      j;

  // If the tree is empty, initialize the root as a leaf.
  if (!node) return this;

  // Find the leaf node for the point.
  // While descending, also retain the deepest parent with a non-removed sibling.
  if (node.length) while (true) {
    if (right = x >= (xm = (x0 + x1) / 2)) x0 = xm; else x1 = xm;
    if (bottom = y >= (ym = (y0 + y1) / 2)) y0 = ym; else y1 = ym;
    if (!(parent = node, node = node[i = bottom << 1 | right])) return this;
    if (!node.length) break;
    if (parent[(i + 1) & 3] || parent[(i + 2) & 3] || parent[(i + 3) & 3]) retainer = parent, j = i;
  }

  // Find the point to remove.
  while (node.data !== d) if (!(previous = node, node = node.next)) return this;
  if (next = node.next) delete node.next;

  // If there are multiple coincident points, remove just the point.
  if (previous) return (next ? previous.next = next : delete previous.next), this;

  // If this is the root point, remove it.
  if (!parent) return this._root = next, this;

  // Remove this leaf.
  next ? parent[i] = next : delete parent[i];

  // If the parent now contains exactly one leaf, collapse superfluous parents.
  if ((node = parent[0] || parent[1] || parent[2] || parent[3])
      && node === (parent[3] || parent[2] || parent[1] || parent[0])
      && !node.length) {
    if (retainer) retainer[j] = node;
    else this._root = node;
  }

  return this;
});

function removeAll(data) {
  for (var i = 0, n = data.length; i < n; ++i) this.remove(data[i]);
  return this;
}

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/root.js
/* harmony default export */ var src_root = (function() {
  return this._root;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/size.js
/* harmony default export */ var src_size = (function() {
  var size = 0;
  this.visit(function(node) {
    if (!node.length) do ++size; while (node = node.next)
  });
  return size;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/visit.js


/* harmony default export */ var src_visit = (function(callback) {
  var quads = [], q, node = this._root, child, x0, y0, x1, y1;
  if (node) quads.push(new src_quad(node, this._x0, this._y0, this._x1, this._y1));
  while (q = quads.pop()) {
    if (!callback(node = q.node, x0 = q.x0, y0 = q.y0, x1 = q.x1, y1 = q.y1) && node.length) {
      var xm = (x0 + x1) / 2, ym = (y0 + y1) / 2;
      if (child = node[3]) quads.push(new src_quad(child, xm, ym, x1, y1));
      if (child = node[2]) quads.push(new src_quad(child, x0, ym, xm, y1));
      if (child = node[1]) quads.push(new src_quad(child, xm, y0, x1, ym));
      if (child = node[0]) quads.push(new src_quad(child, x0, y0, xm, ym));
    }
  }
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/visitAfter.js


/* harmony default export */ var visitAfter = (function(callback) {
  var quads = [], next = [], q;
  if (this._root) quads.push(new src_quad(this._root, this._x0, this._y0, this._x1, this._y1));
  while (q = quads.pop()) {
    var node = q.node;
    if (node.length) {
      var child, x0 = q.x0, y0 = q.y0, x1 = q.x1, y1 = q.y1, xm = (x0 + x1) / 2, ym = (y0 + y1) / 2;
      if (child = node[0]) quads.push(new src_quad(child, x0, y0, xm, ym));
      if (child = node[1]) quads.push(new src_quad(child, xm, y0, x1, ym));
      if (child = node[2]) quads.push(new src_quad(child, x0, ym, xm, y1));
      if (child = node[3]) quads.push(new src_quad(child, xm, ym, x1, y1));
    }
    next.push(q);
  }
  while (q = next.pop()) {
    callback(q.node, q.x0, q.y0, q.x1, q.y1);
  }
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/x.js
function defaultX(d) {
  return d[0];
}

/* harmony default export */ var src_x = (function(_) {
  return arguments.length ? (this._x = _, this) : this._x;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/y.js
function defaultY(d) {
  return d[1];
}

/* harmony default export */ var src_y = (function(_) {
  return arguments.length ? (this._y = _, this) : this._y;
});

// CONCATENATED MODULE: ./node_modules/d3-quadtree/src/quadtree.js













function quadtree(nodes, x, y) {
  var tree = new Quadtree(x == null ? defaultX : x, y == null ? defaultY : y, NaN, NaN, NaN, NaN);
  return nodes == null ? tree : tree.addAll(nodes);
}

function Quadtree(x, y, x0, y0, x1, y1) {
  this._x = x;
  this._y = y;
  this._x0 = x0;
  this._y0 = y0;
  this._x1 = x1;
  this._y1 = y1;
  this._root = undefined;
}

function leaf_copy(leaf) {
  var copy = {data: leaf.data}, next = copy;
  while (leaf = leaf.next) next = next.next = {data: leaf.data};
  return copy;
}

var treeProto = quadtree.prototype = Quadtree.prototype;

treeProto.copy = function() {
  var copy = new Quadtree(this._x, this._y, this._x0, this._y0, this._x1, this._y1),
      node = this._root,
      nodes,
      child;

  if (!node) return copy;

  if (!node.length) return copy._root = leaf_copy(node), copy;

  nodes = [{source: node, target: copy._root = new Array(4)}];
  while (node = nodes.pop()) {
    for (var i = 0; i < 4; ++i) {
      if (child = node.source[i]) {
        if (child.length) nodes.push({source: child, target: node.target[i] = new Array(4)});
        else node.target[i] = leaf_copy(child);
      }
    }
  }

  return copy;
};

treeProto.add = src_add;
treeProto.addAll = addAll;
treeProto.cover = cover;
treeProto.data = src_data;
treeProto.extent = d3_quadtree_src_extent;
treeProto.find = src_find;
treeProto.remove = src_remove;
treeProto.removeAll = removeAll;
treeProto.root = src_root;
treeProto.size = src_size;
treeProto.visit = src_visit;
treeProto.visitAfter = visitAfter;
treeProto.x = src_x;
treeProto.y = src_y;

// CONCATENATED MODULE: ./node_modules/d3-force/src/constant.js
/* harmony default export */ var d3_force_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/jiggle.js
/* harmony default export */ var jiggle = (function() {
  return (Math.random() - 0.5) * 1e-6;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/collide.js




function collide_x(d) {
  return d.x + d.vx;
}

function collide_y(d) {
  return d.y + d.vy;
}

/* harmony default export */ var collide = (function(radius) {
  var nodes,
      radii,
      strength = 1,
      iterations = 1;

  if (typeof radius !== "function") radius = d3_force_src_constant(radius == null ? 1 : +radius);

  function force() {
    var i, n = nodes.length,
        tree,
        node,
        xi,
        yi,
        ri,
        ri2;

    for (var k = 0; k < iterations; ++k) {
      tree = quadtree(nodes, collide_x, collide_y).visitAfter(prepare);
      for (i = 0; i < n; ++i) {
        node = nodes[i];
        ri = radii[node.index], ri2 = ri * ri;
        xi = node.x + node.vx;
        yi = node.y + node.vy;
        tree.visit(apply);
      }
    }

    function apply(quad, x0, y0, x1, y1) {
      var data = quad.data, rj = quad.r, r = ri + rj;
      if (data) {
        if (data.index > node.index) {
          var x = xi - data.x - data.vx,
              y = yi - data.y - data.vy,
              l = x * x + y * y;
          if (l < r * r) {
            if (x === 0) x = jiggle(), l += x * x;
            if (y === 0) y = jiggle(), l += y * y;
            l = (r - (l = Math.sqrt(l))) / l * strength;
            node.vx += (x *= l) * (r = (rj *= rj) / (ri2 + rj));
            node.vy += (y *= l) * r;
            data.vx -= x * (r = 1 - r);
            data.vy -= y * r;
          }
        }
        return;
      }
      return x0 > xi + r || x1 < xi - r || y0 > yi + r || y1 < yi - r;
    }
  }

  function prepare(quad) {
    if (quad.data) return quad.r = radii[quad.data.index];
    for (var i = quad.r = 0; i < 4; ++i) {
      if (quad[i] && quad[i].r > quad.r) {
        quad.r = quad[i].r;
      }
    }
  }

  function initialize() {
    if (!nodes) return;
    var i, n = nodes.length, node;
    radii = new Array(n);
    for (i = 0; i < n; ++i) node = nodes[i], radii[node.index] = +radius(node, i, nodes);
  }

  force.initialize = function(_) {
    nodes = _;
    initialize();
  };

  force.iterations = function(_) {
    return arguments.length ? (iterations = +_, force) : iterations;
  };

  force.strength = function(_) {
    return arguments.length ? (strength = +_, force) : strength;
  };

  force.radius = function(_) {
    return arguments.length ? (radius = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : radius;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/link.js



function link_index(d) {
  return d.index;
}

function link_find(nodeById, nodeId) {
  var node = nodeById.get(nodeId);
  if (!node) throw new Error("missing: " + nodeId);
  return node;
}

/* harmony default export */ var src_link = (function(links) {
  var id = link_index,
      strength = defaultStrength,
      strengths,
      distance = d3_force_src_constant(30),
      distances,
      nodes,
      count,
      bias,
      iterations = 1;

  if (links == null) links = [];

  function defaultStrength(link) {
    return 1 / Math.min(count[link.source.index], count[link.target.index]);
  }

  function force(alpha) {
    for (var k = 0, n = links.length; k < iterations; ++k) {
      for (var i = 0, link, source, target, x, y, l, b; i < n; ++i) {
        link = links[i], source = link.source, target = link.target;
        x = target.x + target.vx - source.x - source.vx || jiggle();
        y = target.y + target.vy - source.y - source.vy || jiggle();
        l = Math.sqrt(x * x + y * y);
        l = (l - distances[i]) / l * alpha * strengths[i];
        x *= l, y *= l;
        target.vx -= x * (b = bias[i]);
        target.vy -= y * b;
        source.vx += x * (b = 1 - b);
        source.vy += y * b;
      }
    }
  }

  function initialize() {
    if (!nodes) return;

    var i,
        n = nodes.length,
        m = links.length,
        nodeById = new Map(nodes.map((d, i) => [id(d, i, nodes), d])),
        link;

    for (i = 0, count = new Array(n); i < m; ++i) {
      link = links[i], link.index = i;
      if (typeof link.source !== "object") link.source = link_find(nodeById, link.source);
      if (typeof link.target !== "object") link.target = link_find(nodeById, link.target);
      count[link.source.index] = (count[link.source.index] || 0) + 1;
      count[link.target.index] = (count[link.target.index] || 0) + 1;
    }

    for (i = 0, bias = new Array(m); i < m; ++i) {
      link = links[i], bias[i] = count[link.source.index] / (count[link.source.index] + count[link.target.index]);
    }

    strengths = new Array(m), initializeStrength();
    distances = new Array(m), initializeDistance();
  }

  function initializeStrength() {
    if (!nodes) return;

    for (var i = 0, n = links.length; i < n; ++i) {
      strengths[i] = +strength(links[i], i, links);
    }
  }

  function initializeDistance() {
    if (!nodes) return;

    for (var i = 0, n = links.length; i < n; ++i) {
      distances[i] = +distance(links[i], i, links);
    }
  }

  force.initialize = function(_) {
    nodes = _;
    initialize();
  };

  force.links = function(_) {
    return arguments.length ? (links = _, initialize(), force) : links;
  };

  force.id = function(_) {
    return arguments.length ? (id = _, force) : id;
  };

  force.iterations = function(_) {
    return arguments.length ? (iterations = +_, force) : iterations;
  };

  force.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : d3_force_src_constant(+_), initializeStrength(), force) : strength;
  };

  force.distance = function(_) {
    return arguments.length ? (distance = typeof _ === "function" ? _ : d3_force_src_constant(+_), initializeDistance(), force) : distance;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-dispatch/src/dispatch.js
var dispatch_noop = {value: function() {}};

function dispatch() {
  for (var i = 0, n = arguments.length, _ = {}, t; i < n; ++i) {
    if (!(t = arguments[i] + "") || (t in _) || /[\s.]/.test(t)) throw new Error("illegal type: " + t);
    _[t] = [];
  }
  return new Dispatch(_);
}

function Dispatch(_) {
  this._ = _;
}

function parseTypenames(typenames, types) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name = "", i = t.indexOf(".");
    if (i >= 0) name = t.slice(i + 1), t = t.slice(0, i);
    if (t && !types.hasOwnProperty(t)) throw new Error("unknown type: " + t);
    return {type: t, name: name};
  });
}

Dispatch.prototype = dispatch.prototype = {
  constructor: Dispatch,
  on: function(typename, callback) {
    var _ = this._,
        T = parseTypenames(typename + "", _),
        t,
        i = -1,
        n = T.length;

    // If no callback was specified, return the callback of the given type and name.
    if (arguments.length < 2) {
      while (++i < n) if ((t = (typename = T[i]).type) && (t = dispatch_get(_[t], typename.name))) return t;
      return;
    }

    // If a type was specified, set the callback for the given type and name.
    // Otherwise, if a null callback was specified, remove callbacks of the given name.
    if (callback != null && typeof callback !== "function") throw new Error("invalid callback: " + callback);
    while (++i < n) {
      if (t = (typename = T[i]).type) _[t] = dispatch_set(_[t], typename.name, callback);
      else if (callback == null) for (t in _) _[t] = dispatch_set(_[t], typename.name, null);
    }

    return this;
  },
  copy: function() {
    var copy = {}, _ = this._;
    for (var t in _) copy[t] = _[t].slice();
    return new Dispatch(copy);
  },
  call: function(type, that) {
    if ((n = arguments.length - 2) > 0) for (var args = new Array(n), i = 0, n, t; i < n; ++i) args[i] = arguments[i + 2];
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);
  },
  apply: function(type, that, args) {
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (var t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);
  }
};

function dispatch_get(type, name) {
  for (var i = 0, n = type.length, c; i < n; ++i) {
    if ((c = type[i]).name === name) {
      return c.value;
    }
  }
}

function dispatch_set(type, name, callback) {
  for (var i = 0, n = type.length; i < n; ++i) {
    if (type[i].name === name) {
      type[i] = dispatch_noop, type = type.slice(0, i).concat(type.slice(i + 1));
      break;
    }
  }
  if (callback != null) type.push({name: name, value: callback});
  return type;
}

/* harmony default export */ var src_dispatch = (dispatch);

// CONCATENATED MODULE: ./node_modules/d3-timer/src/timer.js
var timer_frame = 0, // is an animation frame pending?
    timeout = 0, // is a timeout pending?
    timer_interval = 0, // are any timers active?
    pokeDelay = 1000, // how frequently we check for clock skew
    taskHead,
    taskTail,
    clockLast = 0,
    clockNow = 0,
    clockSkew = 0,
    clock = typeof performance === "object" && performance.now ? performance : Date,
    setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f) { setTimeout(f, 17); };

function now() {
  return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
}

function clearNow() {
  clockNow = 0;
}

function Timer() {
  this._call =
  this._time =
  this._next = null;
}

Timer.prototype = timer.prototype = {
  constructor: Timer,
  restart: function(callback, delay, time) {
    if (typeof callback !== "function") throw new TypeError("callback is not a function");
    time = (time == null ? now() : +time) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail) taskTail._next = this;
      else taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time;
    sleep();
  },
  stop: function() {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  }
};

function timer(callback, delay, time) {
  var t = new Timer;
  t.restart(callback, delay, time);
  return t;
}

function timerFlush() {
  now(); // Get the current time, if not already set.
  ++timer_frame; // Pretend we’ve set an alarm, if we haven’t already.
  var t = taskHead, e;
  while (t) {
    if ((e = clockNow - t._time) >= 0) t._call.call(null, e);
    t = t._next;
  }
  --timer_frame;
}

function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  timer_frame = timeout = 0;
  try {
    timerFlush();
  } finally {
    timer_frame = 0;
    nap();
    clockNow = 0;
  }
}

function poke() {
  var now = clock.now(), delay = now - clockLast;
  if (delay > pokeDelay) clockSkew -= delay, clockLast = now;
}

function nap() {
  var t0, t1 = taskHead, t2, time = Infinity;
  while (t1) {
    if (t1._call) {
      if (time > t1._time) time = t1._time;
      t0 = t1, t1 = t1._next;
    } else {
      t2 = t1._next, t1._next = null;
      t1 = t0 ? t0._next = t2 : taskHead = t2;
    }
  }
  taskTail = t0;
  sleep(time);
}

function sleep(time) {
  if (timer_frame) return; // Soonest alarm already set, or will be.
  if (timeout) timeout = clearTimeout(timeout);
  var delay = time - clockNow; // Strictly less than if we recomputed clockNow.
  if (delay > 24) {
    if (time < Infinity) timeout = setTimeout(wake, time - clock.now() - clockSkew);
    if (timer_interval) timer_interval = clearInterval(timer_interval);
  } else {
    if (!timer_interval) clockLast = clock.now(), timer_interval = setInterval(poke, pokeDelay);
    timer_frame = 1, setFrame(wake);
  }
}

// CONCATENATED MODULE: ./node_modules/d3-force/src/simulation.js



function simulation_x(d) {
  return d.x;
}

function simulation_y(d) {
  return d.y;
}

var initialRadius = 10,
    initialAngle = Math.PI * (3 - Math.sqrt(5));

/* harmony default export */ var src_simulation = (function(nodes) {
  var simulation,
      alpha = 1,
      alphaMin = 0.001,
      alphaDecay = 1 - Math.pow(alphaMin, 1 / 300),
      alphaTarget = 0,
      velocityDecay = 0.6,
      forces = new Map(),
      stepper = timer(step),
      event = src_dispatch("tick", "end");

  if (nodes == null) nodes = [];

  function step() {
    tick();
    event.call("tick", simulation);
    if (alpha < alphaMin) {
      stepper.stop();
      event.call("end", simulation);
    }
  }

  function tick(iterations) {
    var i, n = nodes.length, node;

    if (iterations === undefined) iterations = 1;

    for (var k = 0; k < iterations; ++k) {
      alpha += (alphaTarget - alpha) * alphaDecay;

      forces.forEach(function(force) {
        force(alpha);
      });

      for (i = 0; i < n; ++i) {
        node = nodes[i];
        if (node.fx == null) node.x += node.vx *= velocityDecay;
        else node.x = node.fx, node.vx = 0;
        if (node.fy == null) node.y += node.vy *= velocityDecay;
        else node.y = node.fy, node.vy = 0;
      }
    }

    return simulation;
  }

  function initializeNodes() {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.index = i;
      if (node.fx != null) node.x = node.fx;
      if (node.fy != null) node.y = node.fy;
      if (isNaN(node.x) || isNaN(node.y)) {
        var radius = initialRadius * Math.sqrt(i), angle = i * initialAngle;
        node.x = radius * Math.cos(angle);
        node.y = radius * Math.sin(angle);
      }
      if (isNaN(node.vx) || isNaN(node.vy)) {
        node.vx = node.vy = 0;
      }
    }
  }

  function initializeForce(force) {
    if (force.initialize) force.initialize(nodes);
    return force;
  }

  initializeNodes();

  return simulation = {
    tick: tick,

    restart: function() {
      return stepper.restart(step), simulation;
    },

    stop: function() {
      return stepper.stop(), simulation;
    },

    nodes: function(_) {
      return arguments.length ? (nodes = _, initializeNodes(), forces.forEach(initializeForce), simulation) : nodes;
    },

    alpha: function(_) {
      return arguments.length ? (alpha = +_, simulation) : alpha;
    },

    alphaMin: function(_) {
      return arguments.length ? (alphaMin = +_, simulation) : alphaMin;
    },

    alphaDecay: function(_) {
      return arguments.length ? (alphaDecay = +_, simulation) : +alphaDecay;
    },

    alphaTarget: function(_) {
      return arguments.length ? (alphaTarget = +_, simulation) : alphaTarget;
    },

    velocityDecay: function(_) {
      return arguments.length ? (velocityDecay = 1 - _, simulation) : 1 - velocityDecay;
    },

    force: function(name, _) {
      return arguments.length > 1 ? ((_ == null ? forces.delete(name) : forces.set(name, initializeForce(_))), simulation) : forces.get(name);
    },

    find: function(x, y, radius) {
      var i = 0,
          n = nodes.length,
          dx,
          dy,
          d2,
          node,
          closest;

      if (radius == null) radius = Infinity;
      else radius *= radius;

      for (i = 0; i < n; ++i) {
        node = nodes[i];
        dx = x - node.x;
        dy = y - node.y;
        d2 = dx * dx + dy * dy;
        if (d2 < radius) closest = node, radius = d2;
      }

      return closest;
    },

    on: function(name, _) {
      return arguments.length > 1 ? (event.on(name, _), simulation) : event.on(name);
    }
  };
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/manyBody.js





/* harmony default export */ var manyBody = (function() {
  var nodes,
      node,
      alpha,
      strength = d3_force_src_constant(-30),
      strengths,
      distanceMin2 = 1,
      distanceMax2 = Infinity,
      theta2 = 0.81;

  function force(_) {
    var i, n = nodes.length, tree = quadtree(nodes, simulation_x, simulation_y).visitAfter(accumulate);
    for (alpha = _, i = 0; i < n; ++i) node = nodes[i], tree.visit(apply);
  }

  function initialize() {
    if (!nodes) return;
    var i, n = nodes.length, node;
    strengths = new Array(n);
    for (i = 0; i < n; ++i) node = nodes[i], strengths[node.index] = +strength(node, i, nodes);
  }

  function accumulate(quad) {
    var strength = 0, q, c, weight = 0, x, y, i;

    // For internal nodes, accumulate forces from child quadrants.
    if (quad.length) {
      for (x = y = i = 0; i < 4; ++i) {
        if ((q = quad[i]) && (c = Math.abs(q.value))) {
          strength += q.value, weight += c, x += c * q.x, y += c * q.y;
        }
      }
      quad.x = x / weight;
      quad.y = y / weight;
    }

    // For leaf nodes, accumulate forces from coincident quadrants.
    else {
      q = quad;
      q.x = q.data.x;
      q.y = q.data.y;
      do strength += strengths[q.data.index];
      while (q = q.next);
    }

    quad.value = strength;
  }

  function apply(quad, x1, _, x2) {
    if (!quad.value) return true;

    var x = quad.x - node.x,
        y = quad.y - node.y,
        w = x2 - x1,
        l = x * x + y * y;

    // Apply the Barnes-Hut approximation if possible.
    // Limit forces for very close nodes; randomize direction if coincident.
    if (w * w / theta2 < l) {
      if (l < distanceMax2) {
        if (x === 0) x = jiggle(), l += x * x;
        if (y === 0) y = jiggle(), l += y * y;
        if (l < distanceMin2) l = Math.sqrt(distanceMin2 * l);
        node.vx += x * quad.value * alpha / l;
        node.vy += y * quad.value * alpha / l;
      }
      return true;
    }

    // Otherwise, process points directly.
    else if (quad.length || l >= distanceMax2) return;

    // Limit forces for very close nodes; randomize direction if coincident.
    if (quad.data !== node || quad.next) {
      if (x === 0) x = jiggle(), l += x * x;
      if (y === 0) y = jiggle(), l += y * y;
      if (l < distanceMin2) l = Math.sqrt(distanceMin2 * l);
    }

    do if (quad.data !== node) {
      w = strengths[quad.data.index] * alpha / l;
      node.vx += x * w;
      node.vy += y * w;
    } while (quad = quad.next);
  }

  force.initialize = function(_) {
    nodes = _;
    initialize();
  };

  force.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : strength;
  };

  force.distanceMin = function(_) {
    return arguments.length ? (distanceMin2 = _ * _, force) : Math.sqrt(distanceMin2);
  };

  force.distanceMax = function(_) {
    return arguments.length ? (distanceMax2 = _ * _, force) : Math.sqrt(distanceMax2);
  };

  force.theta = function(_) {
    return arguments.length ? (theta2 = _ * _, force) : Math.sqrt(theta2);
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/radial.js


/* harmony default export */ var radial = (function(radius, x, y) {
  var nodes,
      strength = d3_force_src_constant(0.1),
      strengths,
      radiuses;

  if (typeof radius !== "function") radius = d3_force_src_constant(+radius);
  if (x == null) x = 0;
  if (y == null) y = 0;

  function force(alpha) {
    for (var i = 0, n = nodes.length; i < n; ++i) {
      var node = nodes[i],
          dx = node.x - x || 1e-6,
          dy = node.y - y || 1e-6,
          r = Math.sqrt(dx * dx + dy * dy),
          k = (radiuses[i] - r) * strengths[i] * alpha / r;
      node.vx += dx * k;
      node.vy += dy * k;
    }
  }

  function initialize() {
    if (!nodes) return;
    var i, n = nodes.length;
    strengths = new Array(n);
    radiuses = new Array(n);
    for (i = 0; i < n; ++i) {
      radiuses[i] = +radius(nodes[i], i, nodes);
      strengths[i] = isNaN(radiuses[i]) ? 0 : +strength(nodes[i], i, nodes);
    }
  }

  force.initialize = function(_) {
    nodes = _, initialize();
  };

  force.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : strength;
  };

  force.radius = function(_) {
    return arguments.length ? (radius = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : radius;
  };

  force.x = function(_) {
    return arguments.length ? (x = +_, force) : x;
  };

  force.y = function(_) {
    return arguments.length ? (y = +_, force) : y;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/x.js


/* harmony default export */ var d3_force_src_x = (function(x) {
  var strength = d3_force_src_constant(0.1),
      nodes,
      strengths,
      xz;

  if (typeof x !== "function") x = d3_force_src_constant(x == null ? 0 : +x);

  function force(alpha) {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.vx += (xz[i] - node.x) * strengths[i] * alpha;
    }
  }

  function initialize() {
    if (!nodes) return;
    var i, n = nodes.length;
    strengths = new Array(n);
    xz = new Array(n);
    for (i = 0; i < n; ++i) {
      strengths[i] = isNaN(xz[i] = +x(nodes[i], i, nodes)) ? 0 : +strength(nodes[i], i, nodes);
    }
  }

  force.initialize = function(_) {
    nodes = _;
    initialize();
  };

  force.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : strength;
  };

  force.x = function(_) {
    return arguments.length ? (x = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : x;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/y.js


/* harmony default export */ var d3_force_src_y = (function(y) {
  var strength = d3_force_src_constant(0.1),
      nodes,
      strengths,
      yz;

  if (typeof y !== "function") y = d3_force_src_constant(y == null ? 0 : +y);

  function force(alpha) {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.vy += (yz[i] - node.y) * strengths[i] * alpha;
    }
  }

  function initialize() {
    if (!nodes) return;
    var i, n = nodes.length;
    strengths = new Array(n);
    yz = new Array(n);
    for (i = 0; i < n; ++i) {
      strengths[i] = isNaN(yz[i] = +y(nodes[i], i, nodes)) ? 0 : +strength(nodes[i], i, nodes);
    }
  }

  force.initialize = function(_) {
    nodes = _;
    initialize();
  };

  force.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : strength;
  };

  force.y = function(_) {
    return arguments.length ? (y = typeof _ === "function" ? _ : d3_force_src_constant(+_), initialize(), force) : y;
  };

  return force;
});

// CONCATENATED MODULE: ./node_modules/d3-force/src/index.js









// CONCATENATED MODULE: ./node_modules/vega-force/src/Force.js




var ForceMap = {
  center: src_center,
  collide: collide,
  nbody: manyBody,
  link: src_link,
  x: d3_force_src_x,
  y: d3_force_src_y
};

var Forces = 'forces',
    ForceParams = [
      'alpha', 'alphaMin', 'alphaTarget',
      'velocityDecay', 'forces'
    ],
    ForceConfig = ['static', 'iterations'],
    ForceOutput = ['x', 'y', 'vx', 'vy'];

/**
 * Force simulation layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {Array<object>} params.forces - The forces to apply.
 */
function Force(params) {
  Transform.call(this, null, params);
}

Force.Definition = {
  'type': 'Force',
  'metadata': {'modifies': true},
  'params': [
    { 'name': 'static', 'type': 'boolean', 'default': false },
    { 'name': 'restart', 'type': 'boolean', 'default': false },
    { 'name': 'iterations', 'type': 'number', 'default': 300 },
    { 'name': 'alpha', 'type': 'number', 'default': 1 },
    { 'name': 'alphaMin', 'type': 'number', 'default': 0.001 },
    { 'name': 'alphaTarget', 'type': 'number', 'default': 0 },
    { 'name': 'velocityDecay', 'type': 'number', 'default': 0.4 },
    { 'name': 'forces', 'type': 'param', 'array': true,
      'params': [
        {
          'key': {'force': 'center'},
          'params': [
            { 'name': 'x', 'type': 'number', 'default': 0 },
            { 'name': 'y', 'type': 'number', 'default': 0 }
          ]
        },
        {
          'key': {'force': 'collide'},
          'params': [
            { 'name': 'radius', 'type': 'number', 'expr': true },
            { 'name': 'strength', 'type': 'number', 'default': 0.7 },
            { 'name': 'iterations', 'type': 'number', 'default': 1 }
          ]
        },
        {
          'key': {'force': 'nbody'},
          'params': [
            { 'name': 'strength', 'type': 'number', 'default': -30 },
            { 'name': 'theta', 'type': 'number', 'default': 0.9 },
            { 'name': 'distanceMin', 'type': 'number', 'default': 1 },
            { 'name': 'distanceMax', 'type': 'number' }
          ]
        },
        {
          'key': {'force': 'link'},
          'params': [
            { 'name': 'links', 'type': 'data' },
            { 'name': 'id', 'type': 'field' },
            { 'name': 'distance', 'type': 'number', 'default': 30, 'expr': true },
            { 'name': 'strength', 'type': 'number', 'expr': true },
            { 'name': 'iterations', 'type': 'number', 'default': 1 }
          ]
        },
        {
          'key': {'force': 'x'},
          'params': [
            { 'name': 'strength', 'type': 'number', 'default': 0.1 },
            { 'name': 'x', 'type': 'field' }
          ]
        },
        {
          'key': {'force': 'y'},
          'params': [
            { 'name': 'strength', 'type': 'number', 'default': 0.1 },
            { 'name': 'y', 'type': 'field' }
          ]
        }
      ] },
    {
      'name': 'as', 'type': 'string', 'array': true, 'modify': false,
      'default': ForceOutput
    }
  ]
};

var Force_prototype = Object(vega_util["y" /* inherits */])(Force, Transform);

Force_prototype.transform = function(_, pulse) {
  var sim = this.value,
      change = pulse.changed(pulse.ADD_REM),
      params = _.modified(ForceParams),
      iters = _.iterations || 300;

  // configure simulation
  if (!sim) {
    this.value = sim = Force_simulation(pulse.source, _);
    sim.on('tick', rerun(pulse.dataflow, this));
    if (!_.static) {
      change = true;
      sim.tick(); // ensure we run on init
    }
    pulse.modifies('index');
  } else {
    if (change) {
      pulse.modifies('index');
      sim.nodes(pulse.source);
    }
    if (params || pulse.changed(pulse.MOD)) {
      setup(sim, _, 0, pulse);
    }
  }

  // run simulation
  if (params || change || _.modified(ForceConfig)
      || (pulse.changed() && _.restart))
  {
    sim.alpha(Math.max(sim.alpha(), _.alpha || 1))
       .alphaDecay(1 - Math.pow(sim.alphaMin(), 1 / iters));

    if (_.static) {
      for (sim.stop(); --iters >= 0;) sim.tick();
    } else {
      if (sim.stopped()) sim.restart();
      if (!change) return pulse.StopPropagation; // defer to sim ticks
    }
  }

  return this.finish(_, pulse);
};

Force_prototype.finish = function(_, pulse) {
  var dataflow = pulse.dataflow;

  // inspect dependencies, touch link source data
  for (var args=this._argops, j=0, m=args.length, arg; j<m; ++j) {
    arg = args[j];
    if (arg.name !== Forces || arg.op._argval.force !== 'link') {
      continue;
    }
    for (var ops=arg.op._argops, i=0, n=ops.length, op; i<n; ++i) {
      if (ops[i].name === 'links' && (op = ops[i].op.source)) {
        dataflow.pulse(op, dataflow.changeset().reflow());
        break;
      }
    }
  }

  // reflow all nodes
  return pulse.reflow(_.modified()).modifies(ForceOutput);
};

function rerun(df, op) {
  return function() { df.touch(op).run(); };
}

function Force_simulation(nodes, _) {
  var sim = src_simulation(nodes),
      stopped = false,
      stop = sim.stop,
      restart = sim.restart;

  sim.stopped = function() {
    return stopped;
  };
  sim.restart = function() {
    stopped = false;
    return restart();
  };
  sim.stop = function() {
    stopped = true;
    return stop();
  };

  return setup(sim, _, true).on('end', function() { stopped = true; });
}

function setup(sim, _, init, pulse) {
  var f = Object(vega_util["i" /* array */])(_.forces), i, n, p, name;

  for (i=0, n=ForceParams.length; i<n; ++i) {
    p = ForceParams[i];
    if (p !== Forces && _.modified(p)) sim[p](_[p]);
  }

  for (i=0, n=f.length; i<n; ++i) {
    name = Forces + i;
    p = init || _.modified(Forces, i) ? getForce(f[i])
      : pulse && modified(f[i], pulse) ? sim.force(name)
      : null;
    if (p) sim.force(name, p);
  }

  for (n=(sim.numForces || 0); i<n; ++i) {
    sim.force(Forces + i, null); // remove
  }

  sim.numForces = f.length;
  return sim;
}

function modified(f, pulse) {
  var k, v;
  for (k in f) {
    if (Object(vega_util["D" /* isFunction */])(v = f[k]) && pulse.modified(Object(vega_util["g" /* accessorFields */])(v)))
      return 1;
  }
  return 0;
}

function getForce(_) {
  var f, p;

  if (!Object(vega_util["v" /* hasOwnProperty */])(ForceMap, _.force)) {
    Object(vega_util["n" /* error */])('Unrecognized force: ' + _.force);
  }
  f = ForceMap[_.force]();

  for (p in _) {
    if (Object(vega_util["D" /* isFunction */])(f[p])) setForceParam(f[p], _[p], _);
  }

  return f;
}

function setForceParam(f, v, _) {
  f(Object(vega_util["D" /* isFunction */])(v) ? function(d) { return v(d, _); } : v);
}

// CONCATENATED MODULE: ./node_modules/vega-force/index.js


// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/lookup.js
// Build lookup table mapping tuple keys to tree node instances
/* harmony default export */ var src_lookup = (function(tree, key, filter) {
  var map = {};
  tree.each(function(node) {
    var t = node.data;
    if (filter(t)) map[key(t)] = node;
  });
  tree.lookup = map;
  return tree;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/count.js
function count_count(node) {
  var sum = 0,
      children = node.children,
      i = children && children.length;
  if (!i) sum = 1;
  else while (--i >= 0) sum += children[i].value;
  node.value = sum;
}

/* harmony default export */ var hierarchy_count = (function() {
  return this.eachAfter(count_count);
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/each.js
/* harmony default export */ var each = (function(callback) {
  var node = this, current, next = [node], children, i, n;
  do {
    current = next.reverse(), next = [];
    while (node = current.pop()) {
      callback(node), children = node.children;
      if (children) for (i = 0, n = children.length; i < n; ++i) {
        next.push(children[i]);
      }
    }
  } while (next.length);
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/eachBefore.js
/* harmony default export */ var eachBefore = (function(callback) {
  var node = this, nodes = [node], children, i;
  while (node = nodes.pop()) {
    callback(node), children = node.children;
    if (children) for (i = children.length - 1; i >= 0; --i) {
      nodes.push(children[i]);
    }
  }
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/eachAfter.js
/* harmony default export */ var eachAfter = (function(callback) {
  var node = this, nodes = [node], next = [], children, i, n;
  while (node = nodes.pop()) {
    next.push(node), children = node.children;
    if (children) for (i = 0, n = children.length; i < n; ++i) {
      nodes.push(children[i]);
    }
  }
  while (node = next.pop()) {
    callback(node);
  }
  return this;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/sum.js
/* harmony default export */ var hierarchy_sum = (function(value) {
  return this.eachAfter(function(node) {
    var sum = +value(node.data) || 0,
        children = node.children,
        i = children && children.length;
    while (--i >= 0) sum += children[i].value;
    node.value = sum;
  });
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/sort.js
/* harmony default export */ var hierarchy_sort = (function(compare) {
  return this.eachBefore(function(node) {
    if (node.children) {
      node.children.sort(compare);
    }
  });
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/path.js
/* harmony default export */ var hierarchy_path = (function(end) {
  var start = this,
      ancestor = leastCommonAncestor(start, end),
      nodes = [start];
  while (start !== ancestor) {
    start = start.parent;
    nodes.push(start);
  }
  var k = nodes.length;
  while (end !== ancestor) {
    nodes.splice(k, 0, end);
    end = end.parent;
  }
  return nodes;
});

function leastCommonAncestor(a, b) {
  if (a === b) return a;
  var aNodes = a.ancestors(),
      bNodes = b.ancestors(),
      c = null;
  a = aNodes.pop();
  b = bNodes.pop();
  while (a === b) {
    c = a;
    a = aNodes.pop();
    b = bNodes.pop();
  }
  return c;
}

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/ancestors.js
/* harmony default export */ var ancestors = (function() {
  var node = this, nodes = [node];
  while (node = node.parent) {
    nodes.push(node);
  }
  return nodes;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/descendants.js
/* harmony default export */ var descendants = (function() {
  var nodes = [];
  this.each(function(node) {
    nodes.push(node);
  });
  return nodes;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/leaves.js
/* harmony default export */ var leaves = (function() {
  var leaves = [];
  this.eachBefore(function(node) {
    if (!node.children) {
      leaves.push(node);
    }
  });
  return leaves;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/links.js
/* harmony default export */ var hierarchy_links = (function() {
  var root = this, links = [];
  root.each(function(node) {
    if (node !== root) { // Don’t include the root’s parent, if any.
      links.push({source: node.parent, target: node});
    }
  });
  return links;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/hierarchy/index.js












function hierarchy(data, children) {
  var root = new Node(data),
      valued = +data.value && (root.value = data.value),
      node,
      nodes = [root],
      child,
      childs,
      i,
      n;

  if (children == null) children = defaultChildren;

  while (node = nodes.pop()) {
    if (valued) node.value = +node.data.value;
    if ((childs = children(node.data)) && (n = childs.length)) {
      node.children = new Array(n);
      for (i = n - 1; i >= 0; --i) {
        nodes.push(child = node.children[i] = new Node(childs[i]));
        child.parent = node;
        child.depth = node.depth + 1;
      }
    }
  }

  return root.eachBefore(computeHeight);
}

function node_copy() {
  return hierarchy(this).eachBefore(copyData);
}

function defaultChildren(d) {
  return d.children;
}

function copyData(node) {
  node.data = node.data.data;
}

function computeHeight(node) {
  var height = 0;
  do node.height = height;
  while ((node = node.parent) && (node.height < ++height));
}

function Node(data) {
  this.data = data;
  this.depth =
  this.height = 0;
  this.parent = null;
}

Node.prototype = hierarchy.prototype = {
  constructor: Node,
  count: hierarchy_count,
  each: each,
  eachAfter: eachAfter,
  eachBefore: eachBefore,
  sum: hierarchy_sum,
  sort: hierarchy_sort,
  path: hierarchy_path,
  ancestors: ancestors,
  descendants: descendants,
  leaves: leaves,
  links: hierarchy_links,
  copy: node_copy
};

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Nest.js





 /**
  * Nest tuples into a tree structure, grouped by key values.
  * @constructor
  * @param {object} params - The parameters for this operator.
  * @param {Array<function(object): *>} params.keys - The key fields to nest by, in order.
  * @param {boolean} [params.generate=false] - A boolean flag indicating if
  *   non-leaf nodes generated by this transform should be included in the
  *   output. The default (false) includes only the input data (leaf nodes)
  *   in the data stream.
  */
function Nest(params) {
  Transform.call(this, null, params);
}

Nest.Definition = {
  'type': 'Nest',
  'metadata': {'treesource': true, 'changes': true},
  'params': [
    { 'name': 'keys', 'type': 'field', 'array': true },
    { 'name': 'generate', 'type': 'boolean' }
  ]
};

var Nest_prototype = Object(vega_util["y" /* inherits */])(Nest, Transform);

function Nest_children(n) {
  return n.values;
}

Nest_prototype.transform = function(_, pulse) {
  if (!pulse.source) {
    Object(vega_util["n" /* error */])('Nest transform requires an upstream data source.');
  }

  var gen = _.generate,
      mod = _.modified(),
      out = pulse.clone(),
      tree = this.value;

  if (!tree || mod || pulse.changed()) {
    // collect nodes to remove
    if (tree) {
      tree.each(node => {
        if (node.children && isTuple(node.data)) {
          out.rem.push(node.data);
        }
      });
    }

    // generate new tree structure
    this.value = tree = hierarchy({
      values: Object(vega_util["i" /* array */])(_.keys)
        .reduce((n, k) => { n.key(k); return n; }, nest())
        .entries(out.source)
    }, Nest_children);

    // collect nodes to add
    if (gen) {
      tree.each(node => {
        if (node.children) {
          node = ingest(node.data);
          out.add.push(node);
          out.source.push(node);
        }
      });
    }

    // build lookup table
    src_lookup(tree, tupleid, tupleid);
  }

  out.source.root = tree;
  return out;
};

function nest() {
  var keys = [],
      nest;

  function apply(array, depth) {
    if (depth >= keys.length) {
      return array;
    }

    var i = -1,
        n = array.length,
        key = keys[depth++],
        keyValue,
        value,
        valuesByKey = {},
        values,
        result = {};

    while (++i < n) {
      keyValue = key(value = array[i]) + '';
      if (values = valuesByKey[keyValue]) {
        values.push(value);
      } else {
        valuesByKey[keyValue] = [value];
      }
    }

    for (keyValue in valuesByKey) {
      result[keyValue] = apply(valuesByKey[keyValue], depth);
    }

    return result;
  }

  function entries(map, depth) {
    if (++depth > keys.length) return map;
    var array = [], k;
    for (k in map) {
      array.push({key: k, values: entries(map[k], depth)});
    }
    return array;
  }

  return nest = {
    entries: array => entries(apply(array, 0), 0),
    key: d => { keys.push(d); return nest; }
  };
}

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/HierarchyLayout.js



/**
 * Abstract class for tree layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 */
function HierarchyLayout(params) {
  Transform.call(this, null, params);
}

var HierarchyLayout_prototype = Object(vega_util["y" /* inherits */])(HierarchyLayout, Transform);

HierarchyLayout_prototype.transform = function(_, pulse) {
  if (!pulse.source || !pulse.source.root) {
    Object(vega_util["n" /* error */])(this.constructor.name
      + ' transform requires a backing tree data source.');
  }

  var layout = this.layout(_.method),
      fields = this.fields,
      root = pulse.source.root,
      as = _.as || fields;

  if (_.field) root.sum(_.field); else root.count();
  if (_.sort) root.sort(stableCompare(_.sort, d => d.data));

  setParams(layout, this.params, _);
  if (layout.separation) {
    layout.separation(_.separation !== false ? defaultSeparation : vega_util["O" /* one */]);
  }

  try {
    this.value = layout(root);
  } catch (err) {
    Object(vega_util["n" /* error */])(err);
  }
  root.each(function(node) { setFields(node, fields, as); });

  return pulse.reflow(_.modified()).modifies(as).modifies('leaf');
};

function setParams(layout, params, _) {
  for (var p, i=0, n=params.length; i<n; ++i) {
    p = params[i];
    if (p in _) layout[p](_[p]);
  }
}

function setFields(node, fields, as) {
  var t = node.data;
  for (var i=0, n=fields.length-1; i<n; ++i) {
    t[as[i]] = node[fields[i]];
  }
  t[as[n]] = node.children ? node.children.length : 0;
}

function defaultSeparation(a, b) {
  return a.parent === b.parent ? 1 : 2;
}

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/array.js
var src_array_slice = Array.prototype.slice;

function array_shuffle(array) {
  var m = array.length,
      t,
      i;

  while (m) {
    i = Math.random() * m-- | 0;
    t = array[m];
    array[m] = array[i];
    array[i] = t;
  }

  return array;
}

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/pack/enclose.js


/* harmony default export */ var enclose = (function(circles) {
  var i = 0, n = (circles = array_shuffle(src_array_slice.call(circles))).length, B = [], p, e;

  while (i < n) {
    p = circles[i];
    if (e && enclosesWeak(e, p)) ++i;
    else e = encloseBasis(B = extendBasis(B, p)), i = 0;
  }

  return e;
});

function extendBasis(B, p) {
  var i, j;

  if (enclosesWeakAll(p, B)) return [p];

  // If we get here then B must have at least one element.
  for (i = 0; i < B.length; ++i) {
    if (enclosesNot(p, B[i])
        && enclosesWeakAll(encloseBasis2(B[i], p), B)) {
      return [B[i], p];
    }
  }

  // If we get here then B must have at least two elements.
  for (i = 0; i < B.length - 1; ++i) {
    for (j = i + 1; j < B.length; ++j) {
      if (enclosesNot(encloseBasis2(B[i], B[j]), p)
          && enclosesNot(encloseBasis2(B[i], p), B[j])
          && enclosesNot(encloseBasis2(B[j], p), B[i])
          && enclosesWeakAll(encloseBasis3(B[i], B[j], p), B)) {
        return [B[i], B[j], p];
      }
    }
  }

  // If we get here then something is very wrong.
  throw new Error;
}

function enclosesNot(a, b) {
  var dr = a.r - b.r, dx = b.x - a.x, dy = b.y - a.y;
  return dr < 0 || dr * dr < dx * dx + dy * dy;
}

function enclosesWeak(a, b) {
  var dr = a.r - b.r + 1e-6, dx = b.x - a.x, dy = b.y - a.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}

function enclosesWeakAll(a, B) {
  for (var i = 0; i < B.length; ++i) {
    if (!enclosesWeak(a, B[i])) {
      return false;
    }
  }
  return true;
}

function encloseBasis(B) {
  switch (B.length) {
    case 1: return encloseBasis1(B[0]);
    case 2: return encloseBasis2(B[0], B[1]);
    case 3: return encloseBasis3(B[0], B[1], B[2]);
  }
}

function encloseBasis1(a) {
  return {
    x: a.x,
    y: a.y,
    r: a.r
  };
}

function encloseBasis2(a, b) {
  var x1 = a.x, y1 = a.y, r1 = a.r,
      x2 = b.x, y2 = b.y, r2 = b.r,
      x21 = x2 - x1, y21 = y2 - y1, r21 = r2 - r1,
      l = Math.sqrt(x21 * x21 + y21 * y21);
  return {
    x: (x1 + x2 + x21 / l * r21) / 2,
    y: (y1 + y2 + y21 / l * r21) / 2,
    r: (l + r1 + r2) / 2
  };
}

function encloseBasis3(a, b, c) {
  var x1 = a.x, y1 = a.y, r1 = a.r,
      x2 = b.x, y2 = b.y, r2 = b.r,
      x3 = c.x, y3 = c.y, r3 = c.r,
      a2 = x1 - x2,
      a3 = x1 - x3,
      b2 = y1 - y2,
      b3 = y1 - y3,
      c2 = r2 - r1,
      c3 = r3 - r1,
      d1 = x1 * x1 + y1 * y1 - r1 * r1,
      d2 = d1 - x2 * x2 - y2 * y2 + r2 * r2,
      d3 = d1 - x3 * x3 - y3 * y3 + r3 * r3,
      ab = a3 * b2 - a2 * b3,
      xa = (b2 * d3 - b3 * d2) / (ab * 2) - x1,
      xb = (b3 * c2 - b2 * c3) / ab,
      ya = (a3 * d2 - a2 * d3) / (ab * 2) - y1,
      yb = (a2 * c3 - a3 * c2) / ab,
      A = xb * xb + yb * yb - 1,
      B = 2 * (r1 + xa * xb + ya * yb),
      C = xa * xa + ya * ya - r1 * r1,
      r = -(A ? (B + Math.sqrt(B * B - 4 * A * C)) / (2 * A) : C / B);
  return {
    x: x1 + xa + xb * r,
    y: y1 + ya + yb * r,
    r: r
  };
}

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/pack/siblings.js


function siblings_place(b, a, c) {
  var dx = b.x - a.x, x, a2,
      dy = b.y - a.y, y, b2,
      d2 = dx * dx + dy * dy;
  if (d2) {
    a2 = a.r + c.r, a2 *= a2;
    b2 = b.r + c.r, b2 *= b2;
    if (a2 > b2) {
      x = (d2 + b2 - a2) / (2 * d2);
      y = Math.sqrt(Math.max(0, b2 / d2 - x * x));
      c.x = b.x - x * dx - y * dy;
      c.y = b.y - x * dy + y * dx;
    } else {
      x = (d2 + a2 - b2) / (2 * d2);
      y = Math.sqrt(Math.max(0, a2 / d2 - x * x));
      c.x = a.x + x * dx - y * dy;
      c.y = a.y + x * dy + y * dx;
    }
  } else {
    c.x = a.x + c.r;
    c.y = a.y;
  }
}

function intersects(a, b) {
  var dr = a.r + b.r - 1e-6, dx = b.x - a.x, dy = b.y - a.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}

function score(node) {
  var a = node._,
      b = node.next._,
      ab = a.r + b.r,
      dx = (a.x * b.r + b.x * a.r) / ab,
      dy = (a.y * b.r + b.y * a.r) / ab;
  return dx * dx + dy * dy;
}

function siblings_Node(circle) {
  this._ = circle;
  this.next = null;
  this.previous = null;
}

function packEnclose(circles) {
  if (!(n = circles.length)) return 0;

  var a, b, c, n, aa, ca, i, j, k, sj, sk;

  // Place the first circle.
  a = circles[0], a.x = 0, a.y = 0;
  if (!(n > 1)) return a.r;

  // Place the second circle.
  b = circles[1], a.x = -b.r, b.x = a.r, b.y = 0;
  if (!(n > 2)) return a.r + b.r;

  // Place the third circle.
  siblings_place(b, a, c = circles[2]);

  // Initialize the front-chain using the first three circles a, b and c.
  a = new siblings_Node(a), b = new siblings_Node(b), c = new siblings_Node(c);
  a.next = c.previous = b;
  b.next = a.previous = c;
  c.next = b.previous = a;

  // Attempt to place each remaining circle…
  pack: for (i = 3; i < n; ++i) {
    siblings_place(a._, b._, c = circles[i]), c = new siblings_Node(c);

    // Find the closest intersecting circle on the front-chain, if any.
    // “Closeness” is determined by linear distance along the front-chain.
    // “Ahead” or “behind” is likewise determined by linear distance.
    j = b.next, k = a.previous, sj = b._.r, sk = a._.r;
    do {
      if (sj <= sk) {
        if (intersects(j._, c._)) {
          b = j, a.next = b, b.previous = a, --i;
          continue pack;
        }
        sj += j._.r, j = j.next;
      } else {
        if (intersects(k._, c._)) {
          a = k, a.next = b, b.previous = a, --i;
          continue pack;
        }
        sk += k._.r, k = k.previous;
      }
    } while (j !== k.next);

    // Success! Insert the new circle c between a and b.
    c.previous = a, c.next = b, a.next = b.previous = b = c;

    // Compute the new closest circle pair to the centroid.
    aa = score(a);
    while ((c = c.next) !== b) {
      if ((ca = score(c)) < aa) {
        a = c, aa = ca;
      }
    }
    b = a.next;
  }

  // Compute the enclosing circle of the front chain.
  a = [b._], c = b; while ((c = c.next) !== b) a.push(c._); c = enclose(a);

  // Translate the circles to put the enclosing circle around the origin.
  for (i = 0; i < n; ++i) a = circles[i], a.x -= c.x, a.y -= c.y;

  return c.r;
}

/* harmony default export */ var siblings = (function(circles) {
  packEnclose(circles);
  return circles;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/accessors.js
function optional(f) {
  return f == null ? null : required(f);
}

function required(f) {
  if (typeof f !== "function") throw new Error;
  return f;
}

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/constant.js
function constantZero() {
  return 0;
}

/* harmony default export */ var d3_hierarchy_src_constant = (function(x) {
  return function() {
    return x;
  };
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/pack/index.js




function defaultRadius(d) {
  return Math.sqrt(d.value);
}

/* harmony default export */ var src_pack = (function() {
  var radius = null,
      dx = 1,
      dy = 1,
      padding = constantZero;

  function pack(root) {
    root.x = dx / 2, root.y = dy / 2;
    if (radius) {
      root.eachBefore(radiusLeaf(radius))
          .eachAfter(packChildren(padding, 0.5))
          .eachBefore(translateChild(1));
    } else {
      root.eachBefore(radiusLeaf(defaultRadius))
          .eachAfter(packChildren(constantZero, 1))
          .eachAfter(packChildren(padding, root.r / Math.min(dx, dy)))
          .eachBefore(translateChild(Math.min(dx, dy) / (2 * root.r)));
    }
    return root;
  }

  pack.radius = function(x) {
    return arguments.length ? (radius = optional(x), pack) : radius;
  };

  pack.size = function(x) {
    return arguments.length ? (dx = +x[0], dy = +x[1], pack) : [dx, dy];
  };

  pack.padding = function(x) {
    return arguments.length ? (padding = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), pack) : padding;
  };

  return pack;
});

function radiusLeaf(radius) {
  return function(node) {
    if (!node.children) {
      node.r = Math.max(0, +radius(node) || 0);
    }
  };
}

function packChildren(padding, k) {
  return function(node) {
    if (children = node.children) {
      var children,
          i,
          n = children.length,
          r = padding(node) * k || 0,
          e;

      if (r) for (i = 0; i < n; ++i) children[i].r += r;
      e = packEnclose(children);
      if (r) for (i = 0; i < n; ++i) children[i].r -= r;
      node.r = e + r;
    }
  };
}

function translateChild(k) {
  return function(node) {
    var parent = node.parent;
    node.r *= k;
    if (parent) {
      node.x = parent.x + k * node.x;
      node.y = parent.y + k * node.y;
    }
  };
}

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Pack.js




var Pack_Output = ['x', 'y', 'r', 'depth', 'children'];

/**
 * Packed circle tree layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to size nodes.
 */
function Pack(params) {
  HierarchyLayout.call(this, params);
}

Pack.Definition = {
  'type': 'Pack',
  'metadata': {'tree': true, 'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'padding', 'type': 'number', 'default': 0 },
    { 'name': 'radius', 'type': 'field', 'default': null },
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': Pack_Output.length, 'default': Pack_Output }
  ]
};

var Pack_prototype = Object(vega_util["y" /* inherits */])(Pack, HierarchyLayout);

Pack_prototype.layout = src_pack;

Pack_prototype.params = ['radius', 'size', 'padding'];

Pack_prototype.fields = Pack_Output;

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/round.js
/* harmony default export */ var treemap_round = (function(node) {
  node.x0 = Math.round(node.x0);
  node.y0 = Math.round(node.y0);
  node.x1 = Math.round(node.x1);
  node.y1 = Math.round(node.y1);
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/dice.js
/* harmony default export */ var dice = (function(parent, x0, y0, x1, y1) {
  var nodes = parent.children,
      node,
      i = -1,
      n = nodes.length,
      k = parent.value && (x1 - x0) / parent.value;

  while (++i < n) {
    node = nodes[i], node.y0 = y0, node.y1 = y1;
    node.x0 = x0, node.x1 = x0 += node.value * k;
  }
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/partition.js



/* harmony default export */ var src_partition = (function() {
  var dx = 1,
      dy = 1,
      padding = 0,
      round = false;

  function partition(root) {
    var n = root.height + 1;
    root.x0 =
    root.y0 = padding;
    root.x1 = dx;
    root.y1 = dy / n;
    root.eachBefore(positionNode(dy, n));
    if (round) root.eachBefore(treemap_round);
    return root;
  }

  function positionNode(dy, n) {
    return function(node) {
      if (node.children) {
        dice(node, node.x0, dy * (node.depth + 1) / n, node.x1, dy * (node.depth + 2) / n);
      }
      var x0 = node.x0,
          y0 = node.y0,
          x1 = node.x1 - padding,
          y1 = node.y1 - padding;
      if (x1 < x0) x0 = x1 = (x0 + x1) / 2;
      if (y1 < y0) y0 = y1 = (y0 + y1) / 2;
      node.x0 = x0;
      node.y0 = y0;
      node.x1 = x1;
      node.y1 = y1;
    };
  }

  partition.round = function(x) {
    return arguments.length ? (round = !!x, partition) : round;
  };

  partition.size = function(x) {
    return arguments.length ? (dx = +x[0], dy = +x[1], partition) : [dx, dy];
  };

  partition.padding = function(x) {
    return arguments.length ? (padding = +x, partition) : padding;
  };

  return partition;
});

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Partition.js




var Partition_Output = ['x0', 'y0', 'x1', 'y1', 'depth', 'children'];

/**
 * Partition tree layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to size nodes.
 */
function Partition(params) {
  HierarchyLayout.call(this, params);
}

Partition.Definition = {
  'type': 'Partition',
  'metadata': {'tree': true, 'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'padding', 'type': 'number', 'default': 0 },
    { 'name': 'round', 'type': 'boolean', 'default': false },
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': Partition_Output.length, 'default': Partition_Output }
  ]
};

var Partition_prototype = Object(vega_util["y" /* inherits */])(Partition, HierarchyLayout);

Partition_prototype.layout = src_partition;

Partition_prototype.params = ['size', 'round', 'padding'];

Partition_prototype.fields = Partition_Output;

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/stratify.js



var keyPrefix = "$", // Protect against keys like “__proto__”.
    preroot = {depth: -1},
    ambiguous = {};

function defaultId(d) {
  return d.id;
}

function defaultParentId(d) {
  return d.parentId;
}

/* harmony default export */ var src_stratify = (function() {
  var id = defaultId,
      parentId = defaultParentId;

  function stratify(data) {
    var d,
        i,
        n = data.length,
        root,
        parent,
        node,
        nodes = new Array(n),
        nodeId,
        nodeKey,
        nodeByKey = {};

    for (i = 0; i < n; ++i) {
      d = data[i], node = nodes[i] = new Node(d);
      if ((nodeId = id(d, i, data)) != null && (nodeId += "")) {
        nodeKey = keyPrefix + (node.id = nodeId);
        nodeByKey[nodeKey] = nodeKey in nodeByKey ? ambiguous : node;
      }
    }

    for (i = 0; i < n; ++i) {
      node = nodes[i], nodeId = parentId(data[i], i, data);
      if (nodeId == null || !(nodeId += "")) {
        if (root) throw new Error("multiple roots");
        root = node;
      } else {
        parent = nodeByKey[keyPrefix + nodeId];
        if (!parent) throw new Error("missing: " + nodeId);
        if (parent === ambiguous) throw new Error("ambiguous: " + nodeId);
        if (parent.children) parent.children.push(node);
        else parent.children = [node];
        node.parent = parent;
      }
    }

    if (!root) throw new Error("no root");
    root.parent = preroot;
    root.eachBefore(function(node) { node.depth = node.parent.depth + 1; --n; }).eachBefore(computeHeight);
    root.parent = null;
    if (n > 0) throw new Error("cycle");

    return root;
  }

  stratify.id = function(x) {
    return arguments.length ? (id = required(x), stratify) : id;
  };

  stratify.parentId = function(x) {
    return arguments.length ? (parentId = required(x), stratify) : parentId;
  };

  return stratify;
});

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Stratify.js





 /**
  * Stratify a collection of tuples into a tree structure based on
  * id and parent id fields.
  * @constructor
  * @param {object} params - The parameters for this operator.
  * @param {function(object): *} params.key - Unique key field for each tuple.
  * @param {function(object): *} params.parentKey - Field with key for parent tuple.
  */
function Stratify(params) {
  Transform.call(this, null, params);
}

Stratify.Definition = {
  'type': 'Stratify',
  'metadata': {'treesource': true},
  'params': [
    { 'name': 'key', 'type': 'field', 'required': true },
    { 'name': 'parentKey', 'type': 'field', 'required': true  }
  ]
};

var Stratify_prototype = Object(vega_util["y" /* inherits */])(Stratify, Transform);

Stratify_prototype.transform = function(_, pulse) {
  if (!pulse.source) {
    Object(vega_util["n" /* error */])('Stratify transform requires an upstream data source.');
  }

  var tree = this.value,
      mod = _.modified(),
      out = pulse.fork(pulse.ALL).materialize(pulse.SOURCE),
      run = !this.value
         || mod
         || pulse.changed(pulse.ADD_REM)
         || pulse.modified(_.key.fields)
         || pulse.modified(_.parentKey.fields);

  // prevent upstream source pollution
  out.source = out.source.slice();

  if (run) {
    if (out.source.length) {
      tree = src_lookup(
        src_stratify().id(_.key).parentId(_.parentKey)(out.source)
        , _.key, vega_util["gb" /* truthy */]);
    } else {
      tree = src_lookup(src_stratify()([{}]), _.key, _.key);
    }
  }

  out.source.root = this.value = tree;
  return out;
};

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/tree.js


function tree_defaultSeparation(a, b) {
  return a.parent === b.parent ? 1 : 2;
}

// function radialSeparation(a, b) {
//   return (a.parent === b.parent ? 1 : 2) / a.depth;
// }

// This function is used to traverse the left contour of a subtree (or
// subforest). It returns the successor of v on this contour. This successor is
// either given by the leftmost child of v or by the thread of v. The function
// returns null if and only if v is on the highest level of its subtree.
function nextLeft(v) {
  var children = v.children;
  return children ? children[0] : v.t;
}

// This function works analogously to nextLeft.
function nextRight(v) {
  var children = v.children;
  return children ? children[children.length - 1] : v.t;
}

// Shifts the current subtree rooted at w+. This is done by increasing
// prelim(w+) and mod(w+) by shift.
function moveSubtree(wm, wp, shift) {
  var change = shift / (wp.i - wm.i);
  wp.c -= change;
  wp.s += shift;
  wm.c += change;
  wp.z += shift;
  wp.m += shift;
}

// All other shifts, applied to the smaller subtrees between w- and w+, are
// performed by this function. To prepare the shifts, we have to adjust
// change(w+), shift(w+), and change(w-).
function executeShifts(v) {
  var shift = 0,
      change = 0,
      children = v.children,
      i = children.length,
      w;
  while (--i >= 0) {
    w = children[i];
    w.z += shift;
    w.m += shift;
    shift += w.s + (change += w.c);
  }
}

// If vi-’s ancestor is a sibling of v, returns vi-’s ancestor. Otherwise,
// returns the specified (default) ancestor.
function nextAncestor(vim, v, ancestor) {
  return vim.a.parent === v.parent ? vim.a : ancestor;
}

function TreeNode(node, i) {
  this._ = node;
  this.parent = null;
  this.children = null;
  this.A = null; // default ancestor
  this.a = this; // ancestor
  this.z = 0; // prelim
  this.m = 0; // mod
  this.c = 0; // change
  this.s = 0; // shift
  this.t = null; // thread
  this.i = i; // number
}

TreeNode.prototype = Object.create(Node.prototype);

function treeRoot(root) {
  var tree = new TreeNode(root, 0),
      node,
      nodes = [tree],
      child,
      children,
      i,
      n;

  while (node = nodes.pop()) {
    if (children = node._.children) {
      node.children = new Array(n = children.length);
      for (i = n - 1; i >= 0; --i) {
        nodes.push(child = node.children[i] = new TreeNode(children[i], i));
        child.parent = node;
      }
    }
  }

  (tree.parent = new TreeNode(null, 0)).children = [tree];
  return tree;
}

// Node-link tree diagram using the Reingold-Tilford "tidy" algorithm
/* harmony default export */ var src_tree = (function() {
  var separation = tree_defaultSeparation,
      dx = 1,
      dy = 1,
      nodeSize = null;

  function tree(root) {
    var t = treeRoot(root);

    // Compute the layout using Buchheim et al.’s algorithm.
    t.eachAfter(firstWalk), t.parent.m = -t.z;
    t.eachBefore(secondWalk);

    // If a fixed node size is specified, scale x and y.
    if (nodeSize) root.eachBefore(sizeNode);

    // If a fixed tree size is specified, scale x and y based on the extent.
    // Compute the left-most, right-most, and depth-most nodes for extents.
    else {
      var left = root,
          right = root,
          bottom = root;
      root.eachBefore(function(node) {
        if (node.x < left.x) left = node;
        if (node.x > right.x) right = node;
        if (node.depth > bottom.depth) bottom = node;
      });
      var s = left === right ? 1 : separation(left, right) / 2,
          tx = s - left.x,
          kx = dx / (right.x + s + tx),
          ky = dy / (bottom.depth || 1);
      root.eachBefore(function(node) {
        node.x = (node.x + tx) * kx;
        node.y = node.depth * ky;
      });
    }

    return root;
  }

  // Computes a preliminary x-coordinate for v. Before that, FIRST WALK is
  // applied recursively to the children of v, as well as the function
  // APPORTION. After spacing out the children by calling EXECUTE SHIFTS, the
  // node v is placed to the midpoint of its outermost children.
  function firstWalk(v) {
    var children = v.children,
        siblings = v.parent.children,
        w = v.i ? siblings[v.i - 1] : null;
    if (children) {
      executeShifts(v);
      var midpoint = (children[0].z + children[children.length - 1].z) / 2;
      if (w) {
        v.z = w.z + separation(v._, w._);
        v.m = v.z - midpoint;
      } else {
        v.z = midpoint;
      }
    } else if (w) {
      v.z = w.z + separation(v._, w._);
    }
    v.parent.A = apportion(v, w, v.parent.A || siblings[0]);
  }

  // Computes all real x-coordinates by summing up the modifiers recursively.
  function secondWalk(v) {
    v._.x = v.z + v.parent.m;
    v.m += v.parent.m;
  }

  // The core of the algorithm. Here, a new subtree is combined with the
  // previous subtrees. Threads are used to traverse the inside and outside
  // contours of the left and right subtree up to the highest common level. The
  // vertices used for the traversals are vi+, vi-, vo-, and vo+, where the
  // superscript o means outside and i means inside, the subscript - means left
  // subtree and + means right subtree. For summing up the modifiers along the
  // contour, we use respective variables si+, si-, so-, and so+. Whenever two
  // nodes of the inside contours conflict, we compute the left one of the
  // greatest uncommon ancestors using the function ANCESTOR and call MOVE
  // SUBTREE to shift the subtree and prepare the shifts of smaller subtrees.
  // Finally, we add a new thread (if necessary).
  function apportion(v, w, ancestor) {
    if (w) {
      var vip = v,
          vop = v,
          vim = w,
          vom = vip.parent.children[0],
          sip = vip.m,
          sop = vop.m,
          sim = vim.m,
          som = vom.m,
          shift;
      while (vim = nextRight(vim), vip = nextLeft(vip), vim && vip) {
        vom = nextLeft(vom);
        vop = nextRight(vop);
        vop.a = v;
        shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
        if (shift > 0) {
          moveSubtree(nextAncestor(vim, v, ancestor), v, shift);
          sip += shift;
          sop += shift;
        }
        sim += vim.m;
        sip += vip.m;
        som += vom.m;
        sop += vop.m;
      }
      if (vim && !nextRight(vop)) {
        vop.t = vim;
        vop.m += sim - sop;
      }
      if (vip && !nextLeft(vom)) {
        vom.t = vip;
        vom.m += sip - som;
        ancestor = v;
      }
    }
    return ancestor;
  }

  function sizeNode(node) {
    node.x *= dx;
    node.y = node.depth * dy;
  }

  tree.separation = function(x) {
    return arguments.length ? (separation = x, tree) : separation;
  };

  tree.size = function(x) {
    return arguments.length ? (nodeSize = false, dx = +x[0], dy = +x[1], tree) : (nodeSize ? null : [dx, dy]);
  };

  tree.nodeSize = function(x) {
    return arguments.length ? (nodeSize = true, dx = +x[0], dy = +x[1], tree) : (nodeSize ? [dx, dy] : null);
  };

  return tree;
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/cluster.js
function cluster_defaultSeparation(a, b) {
  return a.parent === b.parent ? 1 : 2;
}

function meanX(children) {
  return children.reduce(meanXReduce, 0) / children.length;
}

function meanXReduce(x, c) {
  return x + c.x;
}

function maxY(children) {
  return 1 + children.reduce(maxYReduce, 0);
}

function maxYReduce(y, c) {
  return Math.max(y, c.y);
}

function leafLeft(node) {
  var children;
  while (children = node.children) node = children[0];
  return node;
}

function leafRight(node) {
  var children;
  while (children = node.children) node = children[children.length - 1];
  return node;
}

/* harmony default export */ var cluster = (function() {
  var separation = cluster_defaultSeparation,
      dx = 1,
      dy = 1,
      nodeSize = false;

  function cluster(root) {
    var previousNode,
        x = 0;

    // First walk, computing the initial x & y values.
    root.eachAfter(function(node) {
      var children = node.children;
      if (children) {
        node.x = meanX(children);
        node.y = maxY(children);
      } else {
        node.x = previousNode ? x += separation(node, previousNode) : 0;
        node.y = 0;
        previousNode = node;
      }
    });

    var left = leafLeft(root),
        right = leafRight(root),
        x0 = left.x - separation(left, right) / 2,
        x1 = right.x + separation(right, left) / 2;

    // Second walk, normalizing x & y to the desired size.
    return root.eachAfter(nodeSize ? function(node) {
      node.x = (node.x - root.x) * dx;
      node.y = (root.y - node.y) * dy;
    } : function(node) {
      node.x = (node.x - x0) / (x1 - x0) * dx;
      node.y = (1 - (root.y ? node.y / root.y : 1)) * dy;
    });
  }

  cluster.separation = function(x) {
    return arguments.length ? (separation = x, cluster) : separation;
  };

  cluster.size = function(x) {
    return arguments.length ? (nodeSize = false, dx = +x[0], dy = +x[1], cluster) : (nodeSize ? null : [dx, dy]);
  };

  cluster.nodeSize = function(x) {
    return arguments.length ? (nodeSize = true, dx = +x[0], dy = +x[1], cluster) : (nodeSize ? [dx, dy] : null);
  };

  return cluster;
});

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Tree.js




var Layouts = {
  tidy: src_tree,
  cluster: cluster
};

var Tree_Output = ['x', 'y', 'depth', 'children'];

/**
 * Tree layout. Depending on the method parameter, performs either
 * Reingold-Tilford 'tidy' layout or dendrogram 'cluster' layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 */
function Tree(params) {
  HierarchyLayout.call(this, params);
}

Tree.Definition = {
  'type': 'Tree',
  'metadata': {'tree': true, 'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'method', 'type': 'enum', 'default': 'tidy', 'values': ['tidy', 'cluster'] },
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'nodeSize', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'separation', 'type': 'boolean', 'default': true },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': Tree_Output.length, 'default': Tree_Output }
  ]
};

var Tree_prototype = Object(vega_util["y" /* inherits */])(Tree, HierarchyLayout);

/**
 * Tree layout generator. Supports both 'tidy' and 'cluster' layouts.
 */
Tree_prototype.layout = function(method) {
  var m = method || 'tidy';
  if (Object(vega_util["v" /* hasOwnProperty */])(Layouts, m)) return Layouts[m]();
  else Object(vega_util["n" /* error */])('Unrecognized Tree layout method: ' + m);
};

Tree_prototype.params = ['size', 'nodeSize'];

Tree_prototype.fields = Tree_Output;

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/TreeLinks.js



 /**
  * Generate tuples representing links between tree nodes.
  * The resulting tuples will contain 'source' and 'target' fields,
  * which point to parent and child node tuples, respectively.
  * @constructor
  * @param {object} params - The parameters for this operator.
  */
function TreeLinks(params) {
  Transform.call(this, [], params);
}

TreeLinks.Definition = {
  'type': 'TreeLinks',
  'metadata': {'tree': true, 'generates': true, 'changes': true},
  'params': []
};

var TreeLinks_prototype = Object(vega_util["y" /* inherits */])(TreeLinks, Transform);

TreeLinks_prototype.transform = function(_, pulse) {
  var links = this.value,
      tree = pulse.source && pulse.source.root,
      out = pulse.fork(pulse.NO_SOURCE),
      lut = {};

  if (!tree) Object(vega_util["n" /* error */])('TreeLinks transform requires a tree data source.');

  if (pulse.changed(pulse.ADD_REM)) {
    // remove previous links
    out.rem = links;

    // build lookup table of valid tuples
    pulse.visit(pulse.SOURCE, function(t) { lut[tupleid(t)] = 1; });

    // generate links for all edges incident on valid tuples
    tree.each(function(node) {
      var t = node.data,
          p = node.parent && node.parent.data;
      if (p && lut[tupleid(t)] && lut[tupleid(p)]) {
        out.add.push(ingest({source: p, target: t}));
      }
    });
    this.value = out.add;
  }

  else if (pulse.changed(pulse.MOD)) {
    // build lookup table of modified tuples
    pulse.visit(pulse.MOD, function(t) { lut[tupleid(t)] = 1; });

    // gather links incident on modified tuples
    links.forEach(function(link) {
      if (lut[tupleid(link.source)] || lut[tupleid(link.target)]) {
        out.mod.push(link);
      }
    });
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/binary.js
/* harmony default export */ var binary = (function(parent, x0, y0, x1, y1) {
  var nodes = parent.children,
      i, n = nodes.length,
      sum, sums = new Array(n + 1);

  for (sums[0] = sum = i = 0; i < n; ++i) {
    sums[i + 1] = sum += nodes[i].value;
  }

  partition(0, n, parent.value, x0, y0, x1, y1);

  function partition(i, j, value, x0, y0, x1, y1) {
    if (i >= j - 1) {
      var node = nodes[i];
      node.x0 = x0, node.y0 = y0;
      node.x1 = x1, node.y1 = y1;
      return;
    }

    var valueOffset = sums[i],
        valueTarget = (value / 2) + valueOffset,
        k = i + 1,
        hi = j - 1;

    while (k < hi) {
      var mid = k + hi >>> 1;
      if (sums[mid] < valueTarget) k = mid + 1;
      else hi = mid;
    }

    if ((valueTarget - sums[k - 1]) < (sums[k] - valueTarget) && i + 1 < k) --k;

    var valueLeft = sums[k] - valueOffset,
        valueRight = value - valueLeft;

    if ((x1 - x0) > (y1 - y0)) {
      var xk = (x0 * valueRight + x1 * valueLeft) / value;
      partition(i, k, valueLeft, x0, y0, xk, y1);
      partition(k, j, valueRight, xk, y0, x1, y1);
    } else {
      var yk = (y0 * valueRight + y1 * valueLeft) / value;
      partition(i, k, valueLeft, x0, y0, x1, yk);
      partition(k, j, valueRight, x0, yk, x1, y1);
    }
  }
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/slice.js
/* harmony default export */ var treemap_slice = (function(parent, x0, y0, x1, y1) {
  var nodes = parent.children,
      node,
      i = -1,
      n = nodes.length,
      k = parent.value && (y1 - y0) / parent.value;

  while (++i < n) {
    node = nodes[i], node.x0 = x0, node.x1 = x1;
    node.y0 = y0, node.y1 = y0 += node.value * k;
  }
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/sliceDice.js



/* harmony default export */ var sliceDice = (function(parent, x0, y0, x1, y1) {
  (parent.depth & 1 ? treemap_slice : dice)(parent, x0, y0, x1, y1);
});

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/squarify.js



var squarify_phi = (1 + Math.sqrt(5)) / 2;

function squarifyRatio(ratio, parent, x0, y0, x1, y1) {
  var rows = [],
      nodes = parent.children,
      row,
      nodeValue,
      i0 = 0,
      i1 = 0,
      n = nodes.length,
      dx, dy,
      value = parent.value,
      sumValue,
      minValue,
      maxValue,
      newRatio,
      minRatio,
      alpha,
      beta;

  while (i0 < n) {
    dx = x1 - x0, dy = y1 - y0;

    // Find the next non-empty node.
    do sumValue = nodes[i1++].value; while (!sumValue && i1 < n);
    minValue = maxValue = sumValue;
    alpha = Math.max(dy / dx, dx / dy) / (value * ratio);
    beta = sumValue * sumValue * alpha;
    minRatio = Math.max(maxValue / beta, beta / minValue);

    // Keep adding nodes while the aspect ratio maintains or improves.
    for (; i1 < n; ++i1) {
      sumValue += nodeValue = nodes[i1].value;
      if (nodeValue < minValue) minValue = nodeValue;
      if (nodeValue > maxValue) maxValue = nodeValue;
      beta = sumValue * sumValue * alpha;
      newRatio = Math.max(maxValue / beta, beta / minValue);
      if (newRatio > minRatio) { sumValue -= nodeValue; break; }
      minRatio = newRatio;
    }

    // Position and record the row orientation.
    rows.push(row = {value: sumValue, dice: dx < dy, children: nodes.slice(i0, i1)});
    if (row.dice) dice(row, x0, y0, x1, value ? y0 += dy * sumValue / value : y1);
    else treemap_slice(row, x0, y0, value ? x0 += dx * sumValue / value : x1, y1);
    value -= sumValue, i0 = i1;
  }

  return rows;
}

/* harmony default export */ var squarify = ((function custom(ratio) {

  function squarify(parent, x0, y0, x1, y1) {
    squarifyRatio(ratio, parent, x0, y0, x1, y1);
  }

  squarify.ratio = function(x) {
    return custom((x = +x) > 1 ? x : 1);
  };

  return squarify;
})(squarify_phi));

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/resquarify.js




/* harmony default export */ var treemap_resquarify = ((function custom(ratio) {

  function resquarify(parent, x0, y0, x1, y1) {
    if ((rows = parent._squarify) && (rows.ratio === ratio)) {
      var rows,
          row,
          nodes,
          i,
          j = -1,
          n,
          m = rows.length,
          value = parent.value;

      while (++j < m) {
        row = rows[j], nodes = row.children;
        for (i = row.value = 0, n = nodes.length; i < n; ++i) row.value += nodes[i].value;
        if (row.dice) dice(row, x0, y0, x1, y0 += (y1 - y0) * row.value / value);
        else treemap_slice(row, x0, y0, x0 += (x1 - x0) * row.value / value, y1);
        value -= row.value;
      }
    } else {
      parent._squarify = rows = squarifyRatio(ratio, parent, x0, y0, x1, y1);
      rows.ratio = ratio;
    }
  }

  resquarify.ratio = function(x) {
    return custom((x = +x) > 1 ? x : 1);
  };

  return resquarify;
})(squarify_phi));

// CONCATENATED MODULE: ./node_modules/d3-hierarchy/src/treemap/index.js





/* harmony default export */ var src_treemap = (function() {
  var tile = squarify,
      round = false,
      dx = 1,
      dy = 1,
      paddingStack = [0],
      paddingInner = constantZero,
      paddingTop = constantZero,
      paddingRight = constantZero,
      paddingBottom = constantZero,
      paddingLeft = constantZero;

  function treemap(root) {
    root.x0 =
    root.y0 = 0;
    root.x1 = dx;
    root.y1 = dy;
    root.eachBefore(positionNode);
    paddingStack = [0];
    if (round) root.eachBefore(treemap_round);
    return root;
  }

  function positionNode(node) {
    var p = paddingStack[node.depth],
        x0 = node.x0 + p,
        y0 = node.y0 + p,
        x1 = node.x1 - p,
        y1 = node.y1 - p;
    if (x1 < x0) x0 = x1 = (x0 + x1) / 2;
    if (y1 < y0) y0 = y1 = (y0 + y1) / 2;
    node.x0 = x0;
    node.y0 = y0;
    node.x1 = x1;
    node.y1 = y1;
    if (node.children) {
      p = paddingStack[node.depth + 1] = paddingInner(node) / 2;
      x0 += paddingLeft(node) - p;
      y0 += paddingTop(node) - p;
      x1 -= paddingRight(node) - p;
      y1 -= paddingBottom(node) - p;
      if (x1 < x0) x0 = x1 = (x0 + x1) / 2;
      if (y1 < y0) y0 = y1 = (y0 + y1) / 2;
      tile(node, x0, y0, x1, y1);
    }
  }

  treemap.round = function(x) {
    return arguments.length ? (round = !!x, treemap) : round;
  };

  treemap.size = function(x) {
    return arguments.length ? (dx = +x[0], dy = +x[1], treemap) : [dx, dy];
  };

  treemap.tile = function(x) {
    return arguments.length ? (tile = required(x), treemap) : tile;
  };

  treemap.padding = function(x) {
    return arguments.length ? treemap.paddingInner(x).paddingOuter(x) : treemap.paddingInner();
  };

  treemap.paddingInner = function(x) {
    return arguments.length ? (paddingInner = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), treemap) : paddingInner;
  };

  treemap.paddingOuter = function(x) {
    return arguments.length ? treemap.paddingTop(x).paddingRight(x).paddingBottom(x).paddingLeft(x) : treemap.paddingTop();
  };

  treemap.paddingTop = function(x) {
    return arguments.length ? (paddingTop = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), treemap) : paddingTop;
  };

  treemap.paddingRight = function(x) {
    return arguments.length ? (paddingRight = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), treemap) : paddingRight;
  };

  treemap.paddingBottom = function(x) {
    return arguments.length ? (paddingBottom = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), treemap) : paddingBottom;
  };

  treemap.paddingLeft = function(x) {
    return arguments.length ? (paddingLeft = typeof x === "function" ? x : d3_hierarchy_src_constant(+x), treemap) : paddingLeft;
  };

  return treemap;
});

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/src/Treemap.js




var Tiles = {
  binary: binary,
  dice: dice,
  slice: treemap_slice,
  slicedice: sliceDice,
  squarify: squarify,
  resquarify: treemap_resquarify
};

var Treemap_Output = ['x0', 'y0', 'x1', 'y1', 'depth', 'children'];

/**
 * Treemap layout.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.field - The value field to size nodes.
 */
function Treemap(params) {
  HierarchyLayout.call(this, params);
}

Treemap.Definition = {
  'type': 'Treemap',
  'metadata': {'tree': true, 'modifies': true},
  'params': [
    { 'name': 'field', 'type': 'field' },
    { 'name': 'sort', 'type': 'compare' },
    { 'name': 'method', 'type': 'enum', 'default': 'squarify',
      'values': ['squarify', 'resquarify', 'binary', 'dice', 'slice', 'slicedice'] },
    { 'name': 'padding', 'type': 'number', 'default': 0 },
    { 'name': 'paddingInner', 'type': 'number', 'default': 0 },
    { 'name': 'paddingOuter', 'type': 'number', 'default': 0 },
    { 'name': 'paddingTop', 'type': 'number', 'default': 0 },
    { 'name': 'paddingRight', 'type': 'number', 'default': 0 },
    { 'name': 'paddingBottom', 'type': 'number', 'default': 0 },
    { 'name': 'paddingLeft', 'type': 'number', 'default': 0 },
    { 'name': 'ratio', 'type': 'number', 'default': 1.618033988749895 },
    { 'name': 'round', 'type': 'boolean', 'default': false },
    { 'name': 'size', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'as', 'type': 'string', 'array': true, 'length': Treemap_Output.length, 'default': Treemap_Output }
  ]
};

var Treemap_prototype = Object(vega_util["y" /* inherits */])(Treemap, HierarchyLayout);

/**
 * Treemap layout generator. Adds 'method' and 'ratio' parameters
 * to configure the underlying tile method.
 */
Treemap_prototype.layout = function() {
  var x = src_treemap();
  x.ratio = function(_) {
    var t = x.tile();
    if (t.ratio) x.tile(t.ratio(_));
  };
  x.method = function(_) {
    if (Object(vega_util["v" /* hasOwnProperty */])(Tiles, _)) x.tile(Tiles[_]);
    else Object(vega_util["n" /* error */])('Unrecognized Treemap layout method: ' + _);
  };
  return x;
};

Treemap_prototype.params = [
  'method', 'ratio', 'size', 'round',
  'padding', 'paddingInner', 'paddingOuter',
  'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft'
];

Treemap_prototype.fields = Treemap_Output;

// CONCATENATED MODULE: ./node_modules/vega-hierarchy/index.js








// CONCATENATED MODULE: ./node_modules/vega-regression/src/partition.js
/* harmony default export */ var vega_regression_src_partition = (function(data, groupby) {
  var groups = [],
      get = function(f) { return f(t); },
      map, i, n, t, k, g;

  // partition data points into stack groups
  if (groupby == null) {
    groups.push(data);
  } else {
    for (map={}, i=0, n=data.length; i<n; ++i) {
      t = data[i];
      k = groupby.map(get);
      g = map[k];
      if (!g) {
        map[k] = (g = []);
        g.dims = k;
        groups.push(g);
      }
      g.push(t);
    }
  }

  return groups;
});

// CONCATENATED MODULE: ./node_modules/vega-regression/src/Loess.js





/**
 * Compute locally-weighted regression fits for one or more data groups.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.x - An accessor for the predictor data field.
 * @param {function(object): *} params.y - An accessor for the predicted data field.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors to groupby.
 * @param {number} [params.bandwidth=0.3] - The loess bandwidth.
 */
function Loess(params) {
  Transform.call(this, null, params);
}

Loess.Definition = {
  'type': 'Loess',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'x', 'type': 'field', 'required': true },
    { 'name': 'y', 'type': 'field', 'required': true },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'bandwidth', 'type': 'number', 'default': 0.3 },
    { 'name': 'as', 'type': 'string', 'array': true }
  ]
};

var Loess_prototype = Object(vega_util["y" /* inherits */])(Loess, Transform);

Loess_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);

  if (!this.value || pulse.changed() || _.modified()) {
    const source = pulse.materialize(pulse.SOURCE).source,
          groups = vega_regression_src_partition(source, _.groupby),
          names = (_.groupby || []).map(vega_util["h" /* accessorName */]),
          m = names.length,
          as = _.as || [Object(vega_util["h" /* accessorName */])(_.x), Object(vega_util["h" /* accessorName */])(_.y)],
          values = [];

    groups.forEach(g => {
      loess(g, _.x, _.y, _.bandwidth || 0.3).forEach(p => {
        const t = {};
        for (let i=0; i<m; ++i) {
          t[names[i]] = g.dims[i];
        }
        t[as[0]] = p[0];
        t[as[1]] = p[1];
        values.push(ingest(t));
      });
    });

    if (this.value) out.rem = this.value;
    this.value = out.add = out.source = values;
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-regression/src/Regression.js





const Regression_Methods = {
  linear: linear,
  log:    log,
  exp:    exp,
  pow:    pow,
  quad:   regression_quad,
  poly:   poly
};

function degreesOfFreedom(method, order) {
  return method === 'poly' ? order : method === 'quad' ? 2 : 1;
}

/**
 * Compute regression fits for one or more data groups.
 * @constructor
 * @param {object} params - The parameters for this operator.
 * @param {function(object): *} params.x - An accessor for the predictor data field.
 * @param {function(object): *} params.y - An accessor for the predicted data field.
 * @param {string} [params.method='linear'] - The regression method to apply.
 * @param {Array<function(object): *>} [params.groupby] - An array of accessors to groupby.
 * @param {Array<number>} [params.extent] - The domain extent over which to plot the regression line.
 * @param {number} [params.order=3] - The polynomial order. Only applies to the 'poly' method.
 */
function Regression(params) {
  Transform.call(this, null, params);
}

Regression.Definition = {
  'type': 'Regression',
  'metadata': {'generates': true},
  'params': [
    { 'name': 'x', 'type': 'field', 'required': true },
    { 'name': 'y', 'type': 'field', 'required': true },
    { 'name': 'groupby', 'type': 'field', 'array': true },
    { 'name': 'method', 'type': 'string', 'default': 'linear', 'values': Object.keys(Regression_Methods) },
    { 'name': 'order', 'type': 'number', 'default': 3 },
    { 'name': 'extent', 'type': 'number', 'array': true, 'length': 2 },
    { 'name': 'params', 'type': 'boolean', 'default': false },
    { 'name': 'as', 'type': 'string', 'array': true }
  ]
};

var Regression_prototype = Object(vega_util["y" /* inherits */])(Regression, Transform);

Regression_prototype.transform = function(_, pulse) {
  var out = pulse.fork(pulse.NO_SOURCE | pulse.NO_FIELDS);

  if (!this.value || pulse.changed() || _.modified()) {
    const source = pulse.materialize(pulse.SOURCE).source,
          groups = vega_regression_src_partition(source, _.groupby),
          names = (_.groupby || []).map(vega_util["h" /* accessorName */]),
          method = _.method || 'linear',
          order = _.order || 3,
          dof = degreesOfFreedom(method, order),
          as = _.as || [Object(vega_util["h" /* accessorName */])(_.x), Object(vega_util["h" /* accessorName */])(_.y)],
          fit = Regression_Methods[method],
          values = [];

    let domain = _.extent;

    if (!Object(vega_util["v" /* hasOwnProperty */])(Regression_Methods, method)) {
      Object(vega_util["n" /* error */])('Invalid regression method: ' + method);
    }

    if (domain != null) {
      if (method === 'log' && domain[0] <= 0) {
        pulse.dataflow.warn('Ignoring extent with values <= 0 for log regression.');
        domain = null;
      }
    }

    groups.forEach(g => {
      const n = g.length;
      if (n <= dof) {
        pulse.dataflow.warn('Skipping regression with more parameters than data points.');
        return;
      }

      const model = fit(g, _.x, _.y, order);

      if (_.params) {
        // if parameter vectors requested return those
        values.push(ingest({
          keys: g.dims,
          coef: model.coef,
          rSquared: model.rSquared
        }));
        return;
      }

      const dom = domain || Object(vega_util["p" /* extent */])(g, _.x),
            add = p => {
              const t = {};
              for (let i=0; i<names.length; ++i) {
                t[names[i]] = g.dims[i];
              }
              t[as[0]] = p[0];
              t[as[1]] = p[1];
              values.push(ingest(t));
            };

      if (method === 'linear') {
        // for linear regression we only need the end points
        dom.forEach(x => add([x, model.predict(x)]));
      } else {
        // otherwise return trend line sample points
        sampleCurve(model.predict, dom, 25, 200).forEach(add);
      }
    });

    if (this.value) out.rem = this.value;
    this.value = out.add = out.source = values;
  }

  return out;
};

// CONCATENATED MODULE: ./node_modules/vega-regression/index.js



// CONCATENATED MODULE: ./node_modules/delaunator/index.js

const delaunator_EPSILON = Math.pow(2, -52);
const EDGE_STACK = new Uint32Array(512);

class Delaunator {

    static from(points, getX = defaultGetX, getY = defaultGetY) {
        const n = points.length;
        const coords = new Float64Array(n * 2);

        for (let i = 0; i < n; i++) {
            const p = points[i];
            coords[2 * i] = getX(p);
            coords[2 * i + 1] = getY(p);
        }

        return new Delaunator(coords);
    }

    constructor(coords) {
        const n = coords.length >> 1;
        if (n > 0 && typeof coords[0] !== 'number') throw new Error('Expected coords to contain numbers.');

        this.coords = coords;

        // arrays that will store the triangulation graph
        const maxTriangles = Math.max(2 * n - 5, 0);
        this._triangles = new Uint32Array(maxTriangles * 3);
        this._halfedges = new Int32Array(maxTriangles * 3);

        // temporary arrays for tracking the edges of the advancing convex hull
        this._hashSize = Math.ceil(Math.sqrt(n));
        this._hullPrev = new Uint32Array(n); // edge to prev edge
        this