"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getChildren(elem) {
    return elem.children || null;
}
exports.getChildren = getChildren;
function getParent(elem) {
    return elem.parent || null;
}
exports.getParent = getParent;
function getSiblings(elem) {
    var parent = getParent(elem);
    return parent ? getChildren(parent) : [elem];
}
exports.getSiblings = getSiblings;
function getAttributeValue(elem, name) {
    var _a;
    return (_a = elem.attribs) === null || _a === void 0 ? void 0 : _a[name];
}
exports.getAttributeValue = getAttributeValue;
function hasAttrib(elem, name) {
    return (!!elem.attribs &&
        Object.prototype.hasOwnProperty.call(elem.attribs, name) &&
        elem.attribs[name] != null);
}
exports.hasAttrib = hasAttrib;
/***
 * Returns the name property of an element
 *
 * @param elem The element to get the name for
 */
function getName(elem) {
    return elem.name;
}
exports.getName = getName;
