"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const RoomEvent_1 = require("./RoomEvent");
const InvalidEventError_1 = require("./InvalidEventError");
/**
 * Represents an m.room.member state event
 * @category Matrix events
 */
class MembershipEvent extends RoomEvent_1.StateEvent {
    constructor(event) {
        super(event);
    }
    /**
     * The user ID the membership affects.
     */
    get membershipFor() {
        return this.stateKey;
    }
    /**
     * The user's membership.
     */
    get membership() {
        const membership = this.content.membership;
        if (!membership)
            throw new InvalidEventError_1.InvalidEventError("no membership field in content");
        return membership;
    }
}
exports.MembershipEvent = MembershipEvent;
