/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.atom.Bullet;
import net.sourceforge.plantuml.creole.legacy.AtomText;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class StripeStyle {
    private final StripeStyleType type;
    private final int order;
    private final char style;

    public StripeStyle(StripeStyleType type, int order, char style) {
        this.type = type;
        this.order = order;
        this.style = style;
    }

    public final StripeStyleType getType() {
        return this.type;
    }

    public Atom getHeader(FontConfiguration fontConfiguration, CreoleContext context) {
        if (this.type == StripeStyleType.LIST_WITHOUT_NUMBER) {
            return new Bullet(fontConfiguration, this.order);
        }
        if (this.type == StripeStyleType.LIST_WITH_NUMBER) {
            int localNumber = context.getLocalNumber(this.order);
            return AtomText.createListNumber(fontConfiguration, this.order, localNumber);
        }
        return null;
    }

    public final int getOrder() {
        return this.order;
    }

    public char getStyle() {
        return this.style;
    }
}

