/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.GCalendar;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeHeaderWeekly
extends TimeHeader {
    private final GCalendar calendar;

    private double getTimeHeaderHeight() {
        return 29.0;
    }

    public TimeHeaderWeekly(GCalendar calendar, Wink min, Wink max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<Day, String> nameDays) {
        super(min, max, new TimeScaleCompressed(calendar, PrintScale.WEEKLY.getCompress()));
        this.calendar = calendar;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeight) {
        this.drawCalendar(ug, totalHeight);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, 16.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    private void drawCalendar(UGraphic ug, double totalHeight) {
        this.printDaysOfMonth(ug);
        this.printSmallVbars(ug, totalHeight);
        this.printMonths(ug);
    }

    private void printMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Wink wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            Day day = this.calendar.toDayAsDate(wink);
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!day.monthYear().equals(last)) {
                this.drawVbar(ug, x1, 0.0, 16.0);
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = day.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printSmallVbars(UGraphic ug, double totalHeight) {
        Wink wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            if (this.calendar.toDayAsDate(wink).getDayOfWeek() == DayOfWeek.MONDAY) {
                this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), 16.0, totalHeight);
            }
            wink = wink.increment();
        }
    }

    private void printDaysOfMonth(UGraphic ug) {
        Wink wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            Day day = this.calendar.toDayAsDate(wink);
            if (day.getDayOfWeek() == DayOfWeek.MONDAY) {
                this.printLeft(ug.apply(UTranslate.dy(16.0)), this.getTextBlock("" + day.getDayOfMonth(), 10, false), this.getTimeScale().getStartingPosition(wink) + 5.0);
            }
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(monthYear.shortName(), 12, true);
        TextBlock big = this.getTextBlock(monthYear.shortNameYYYY(), 12, true);
        this.printCentered(ug, start, end, small, big);
    }

    private void drawVbar(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(HColorUtils.LIGHT_GRAY).apply(new UTranslate(x, y1)).draw(vbar);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

