/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.util.Packet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPCompoundPacket
extends RTCPPacket {
    RTCPPacket[] packets;

    public RTCPCompoundPacket(Packet base) {
        super(base);
        this.type = -1;
    }

    public RTCPCompoundPacket(RTCPPacket[] packets) {
        this.packets = packets;
        this.type = -1;
        this.received = false;
    }

    public String toString() {
        return "RTCP Packet with the following subpackets:\n" + this.toString(this.packets);
    }

    public String toString(RTCPPacket[] packets) {
        String s = "";
        int i = 0;
        while (i < packets.length) {
            s = s + packets[i];
            ++i;
        }
        return s;
    }

    public int calcLength() {
        int len = 0;
        if (this.packets == null || this.packets.length < 1) {
            throw new IllegalArgumentException("Bad RTCP Compound Packet");
        }
        int i = 0;
        while (i < this.packets.length) {
            len += this.packets[i].calcLength();
            ++i;
        }
        return len;
    }

    void assemble(DataOutputStream out) throws IOException {
        throw new IllegalArgumentException("Recursive Compound Packet");
    }

    public void assemble(int len, boolean encrypted) {
        int laststart;
        this.length = len;
        this.offset = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            if (encrypted) {
                this.offset += 4;
            }
            laststart = this.offset;
            int i = 0;
            while (i < this.packets.length) {
                laststart = baos.size();
                this.packets[i].assemble(out);
                ++i;
            }
        }
        catch (IOException e) {
            throw new NullPointerException("Impossible IO Exception");
        }
        int prelen = baos.size();
        this.data = baos.toByteArray();
        if (prelen > len) {
            throw new NullPointerException("RTCP Packet overflow");
        }
        if (prelen < len) {
            if (this.data.length < len) {
                this.data = new byte[len];
                System.arraycopy(this.data, 0, this.data, 0, prelen);
            }
            int n = laststart;
            this.data[n] = (byte)(this.data[n] | 0x20);
            this.data[len - 1] = (byte)(len - prelen);
            int temp = (this.data[laststart + 3] & 0xFF) + (len - prelen >> 2);
            if (temp >= 256) {
                int n2 = laststart + 2;
                this.data[n2] = (byte)(this.data[n2] + (len - prelen >> 10));
            }
            this.data[laststart + 3] = (byte)temp;
        }
    }
}

