/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SerialNativeInterface {
    private static final String libVersion = "2.8";
    private static final String libMinorSuffix = "0";
    public static final int OS_LINUX = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_MAC_OS_X = 3;
    private static int osType = -1;
    public static final long ERR_PORT_BUSY = -1L;
    public static final long ERR_PORT_NOT_FOUND = -2L;
    public static final long ERR_PERMISSION_DENIED = -3L;
    public static final long ERR_INCORRECT_SERIAL_PORT = -4L;
    public static final String PROPERTY_JSSC_NO_TIOCEXCL = "JSSC_NO_TIOCEXCL";
    public static final String PROPERTY_JSSC_IGNPAR = "JSSC_IGNPAR";
    public static final String PROPERTY_JSSC_PARMRK = "JSSC_PARMRK";

    static {
        String osName = System.getProperty("os.name");
        String architecture = System.getProperty("os.arch");
        String userHome = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        String tmpFolder = System.getProperty("java.io.tmpdir");
        String libRootFolder = new File(userHome).canWrite() ? userHome : tmpFolder;
        String javaLibPath = System.getProperty("java.library.path");
        if (osName.equals("Linux")) {
            osName = "linux";
            osType = 0;
        } else if (osName.startsWith("Win")) {
            osName = "windows";
            osType = 1;
        } else if (osName.equals("SunOS")) {
            osName = "solaris";
            osType = 2;
        } else if (osName.equals("Mac OS X") || osName.equals("Darwin")) {
            osName = "mac_os_x";
            osType = 3;
        }
        if (architecture.equals("i386") || architecture.equals("i686")) {
            architecture = "x86";
        } else if (architecture.equals("amd64") || architecture.equals("universal")) {
            architecture = "x86_64";
        } else if (architecture.equals("arm")) {
            String floatStr = "sf";
            if (javaLibPath.toLowerCase().contains("gnueabihf") || javaLibPath.toLowerCase().contains("armhf")) {
                floatStr = "hf";
            } else {
                try {
                    Process readelfProcess = Runtime.getRuntime().exec("readelf -A /proc/self/exe");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(readelfProcess.getInputStream()));
                    String buffer = "";
                    while ((buffer = reader.readLine()) != null && !buffer.isEmpty()) {
                        if (!buffer.toLowerCase().contains("Tag_ABI_VFP_args".toLowerCase())) continue;
                        floatStr = "hf";
                        break;
                    }
                    reader.close();
                }
                catch (Exception readelfProcess) {
                    // empty catch block
                }
            }
            architecture = "arm" + floatStr;
        }
        String jsscLibPath = System.getProperty("jssc.library.path");
        String libFolderPath = jsscLibPath != null ? jsscLibPath : String.valueOf(libRootFolder) + fileSeparator + ".jssc" + fileSeparator + osName;
        String libName = "jSSC-2.8_" + architecture;
        libName = System.mapLibraryName(libName);
        if (libName.endsWith(".dylib")) {
            libName = libName.replace(".dylib", ".jnilib");
        }
        boolean loadLib = false;
        if (SerialNativeInterface.isLibFolderExist(libFolderPath)) {
            if (SerialNativeInterface.isLibFileExist(String.valueOf(libFolderPath) + fileSeparator + libName)) {
                loadLib = true;
            } else if (SerialNativeInterface.extractLib(String.valueOf(libFolderPath) + fileSeparator + libName, osName, libName)) {
                loadLib = true;
            }
        } else if (new File(libFolderPath).mkdirs() && SerialNativeInterface.extractLib(String.valueOf(libFolderPath) + fileSeparator + libName, osName, libName)) {
            loadLib = true;
        }
        if (loadLib) {
            System.load(String.valueOf(libFolderPath) + fileSeparator + libName);
            String versionBase = SerialNativeInterface.getLibraryBaseVersion();
            String versionNative = SerialNativeInterface.getNativeLibraryVersion();
            if (!versionBase.equals(versionNative)) {
                System.err.println("Warning! jSSC Java and Native versions mismatch (Java: " + versionBase + ", Native: " + versionNative + ")");
            }
        }
    }

    private static boolean isLibFolderExist(String libFolderPath) {
        boolean returnValue = false;
        File folder = new File(libFolderPath);
        if (folder.exists() && folder.isDirectory()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static boolean isLibFileExist(String libFilePath) {
        boolean returnValue = false;
        File folder = new File(libFilePath);
        if (folder.exists() && folder.isFile()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static boolean extractLib(String libFilePath, String osName, String libName) {
        boolean returnValue = false;
        File libFile = new File(libFilePath);
        InputStream input = null;
        FileOutputStream output = null;
        input = SerialNativeInterface.class.getResourceAsStream("/libs/" + osName + "/" + libName);
        if (input != null) {
            byte[] buffer = new byte[4096];
            try {
                int read;
                output = new FileOutputStream(libFilePath);
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                output.close();
                input.close();
                returnValue = true;
            }
            catch (Exception ex) {
                try {
                    output.close();
                    if (libFile.exists()) {
                        libFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return returnValue;
    }

    public static int getOsType() {
        return osType;
    }

    public static String getLibraryVersion() {
        return "2.8.0";
    }

    public static String getLibraryBaseVersion() {
        return libVersion;
    }

    public static String getLibraryMinorSuffix() {
        return libMinorSuffix;
    }

    public static native String getNativeLibraryVersion();

    public native long openPort(String var1, boolean var2);

    public native boolean setParams(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9);

    public native boolean purgePort(long var1, int var3);

    public native boolean closePort(long var1);

    public native boolean setEventsMask(long var1, int var3);

    public native int getEventsMask(long var1);

    public native int[][] waitEvents(long var1);

    public native boolean setRTS(long var1, boolean var3);

    public native boolean setDTR(long var1, boolean var3);

    public native byte[] readBytes(long var1, int var3);

    public native boolean writeBytes(long var1, byte[] var3);

    public native int[] getBuffersBytesCount(long var1);

    public native boolean setFlowControlMode(long var1, int var3);

    public native int getFlowControlMode(long var1);

    public native String[] getSerialPortNames();

    public native int[] getLinesStatus(long var1);

    public native boolean sendBreak(long var1, int var3);
}

