/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.openoffice.da.comp.w2lcommon.filter.FilterDataParser;
import org.openoffice.da.comp.w2lcommon.filter.GraphicConverterImpl;
import org.w3c.dom.Document;
import writer2latex.api.Converter;
import writer2latex.api.ConverterFactory;
import writer2latex.api.ConverterResult;
import writer2latex.api.OutputFile;
import writer2latex.util.Misc;

public class UNOConverter {
    private XComponentContext xComponentContext;
    private Converter converter;
    private String sTargetFormat = null;
    private XOutputStream xos = null;
    private String sURL = null;

    public UNOConverter(PropertyValue[] lArguments, XComponentContext xComponentContext) {
        this.xComponentContext = xComponentContext;
        HashMap<String, String> filterNames = new HashMap<String, String>();
        filterNames.put("org.openoffice.da.writer2latex", "application/x-latex");
        filterNames.put("org.openoffice.da.writer2bibtex", "application/x-bibtex");
        filterNames.put("org.openoffice.da.writer2xhtml", "text/html");
        filterNames.put("org.openoffice.da.writer2xhtml11", "application/xhtml11");
        filterNames.put("org.openoffice.da.writer2xhtml5", "text/html5");
        filterNames.put("org.openoffice.da.writer2xhtml.mathml", "application/xhtml+xml");
        filterNames.put("org.openoffice.da.writer2xhtml.epub", "application/epub+zip");
        filterNames.put("org.openoffice.da.writer2xhtml.epub3", "epub3");
        filterNames.put("org.openoffice.da.calc2xhtml", "text/html");
        filterNames.put("org.openoffice.da.calc2xhtml11", "application/xhtml11");
        filterNames.put("org.openoffice.da.calc2xhtml5", "text/html5");
        Object filterData = null;
        Object filterOptions = null;
        PropertyValue[] pValue = lArguments;
        for (int i = 0; i < pValue.length; ++i) {
            try {
                if (pValue[i].Name.compareTo("FilterName") == 0) {
                    String sFilterName = (String)AnyConverter.toObject((Type)new Type(String.class), (Object)pValue[i].Value);
                    this.sTargetFormat = filterNames.containsKey(sFilterName) ? (String)filterNames.get(sFilterName) : sFilterName;
                }
                if (pValue[i].Name.compareTo("OutputStream") == 0) {
                    this.xos = (XOutputStream)AnyConverter.toObject((Type)new Type(XOutputStream.class), (Object)pValue[i].Value);
                }
                if (pValue[i].Name.compareTo("URL") == 0) {
                    this.sURL = (String)AnyConverter.toObject((Type)new Type(String.class), (Object)pValue[i].Value);
                }
                if (pValue[i].Name.compareTo("FilterData") == 0) {
                    filterData = pValue[i].Value;
                }
                if (pValue[i].Name.compareTo("FilterOptions") != 0) continue;
                filterOptions = pValue[i].Value;
                continue;
            }
            catch (IllegalArgumentException AnyExec) {
                System.err.println("\nIllegalArgumentException " + (Object)((Object)AnyExec));
            }
        }
        if (this.sURL == null) {
            this.sURL = "";
        }
        this.converter = ConverterFactory.createConverter(this.sTargetFormat);
        if (this.converter == null) {
            throw new RuntimeException("Failed to create converter to " + this.sTargetFormat);
        }
        if (filterData != null) {
            FilterDataParser fdp = new FilterDataParser(xComponentContext);
            fdp.applyFilterData(filterData, this.converter);
        } else if (filterOptions != null) {
            FilterDataParser fdp = new FilterDataParser(xComponentContext);
            fdp.applyFilterOptions(filterOptions, this.converter);
        }
        this.converter.setGraphicConverter(new GraphicConverterImpl(xComponentContext));
    }

    public void convert(Document dom) throws IOException {
        this.writeFiles(this.converter.convert(dom, Misc.makeFileName(this.getFileName(this.sURL)), true));
    }

    public void convert(XInputStream xis) throws IOException {
        XInputStreamToInputStreamAdapter is = new XInputStreamToInputStreamAdapter(xis);
        this.writeFiles(this.converter.convert((InputStream)is, Misc.makeFileName(this.getFileName(this.sURL))));
    }

    private void writeFiles(ConverterResult result) throws IOException {
        Iterator<OutputFile> docEnum = result.iterator();
        if (docEnum.hasNext()) {
            if (this.xos != null) {
                XOutputStreamToOutputStreamAdapter newxos = new XOutputStreamToOutputStreamAdapter(this.xos);
                docEnum.next().write((OutputStream)newxos);
                newxos.flush();
                newxos.close();
            }
            if (docEnum.hasNext() && this.sURL.startsWith("file:")) {
                XSimpleFileAccess2 sfa2 = null;
                try {
                    Object sfaObject = this.xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", this.xComponentContext);
                    sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
                }
                catch (Exception sfaObject) {
                    // empty catch block
                }
                if (sfa2 != null) {
                    String sNewURL = null;
                    sNewURL = this.sURL.lastIndexOf("/") > -1 ? this.sURL.substring(0, this.sURL.lastIndexOf("/") + 1) : "";
                    while (docEnum.hasNext()) {
                        OutputFile docOut = docEnum.next();
                        String sFullFileName = Misc.makeHref(docOut.getFileName());
                        String sDirName = "";
                        String sFileName = sFullFileName;
                        int nSlash = sFileName.indexOf("/");
                        if (nSlash > -1) {
                            sDirName = sFileName.substring(0, nSlash);
                            sFileName = sFileName.substring(nSlash + 1);
                        }
                        try {
                            if (sDirName.length() > 0 && !sfa2.exists(sNewURL + sDirName)) {
                                sfa2.createFolder(sNewURL + sDirName);
                            }
                            Object xPipeObj = this.xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.io.Pipe", this.xComponentContext);
                            XInputStream xInStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)xPipeObj);
                            XOutputStream xOutStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)xPipeObj);
                            XOutputStreamToOutputStreamAdapter outStream = new XOutputStreamToOutputStreamAdapter(xOutStream);
                            docOut.write((OutputStream)outStream);
                            outStream.flush();
                            outStream.close();
                            xOutStream.closeOutput();
                            sfa2.writeFile(sNewURL + sFullFileName, xInStream);
                        }
                        catch (Throwable e) {
                            throw new IOException("Error writing file " + sFileName + " " + e.getMessage());
                        }
                    }
                }
            }
        } else {
            throw new IOException("Conversion failed: Internal error");
        }
    }

    private String getFileName(String origName) {
        String name = null;
        if (origName != null) {
            if (origName.equalsIgnoreCase("")) {
                name = "OutFile";
            } else {
                if (origName.lastIndexOf("/") >= 0) {
                    origName = origName.substring(origName.lastIndexOf("/") + 1, origName.length());
                }
                name = origName.lastIndexOf(".") >= 0 ? origName.substring(0, origName.lastIndexOf(".")) : origName;
            }
        } else {
            name = "OutFile";
        }
        return name;
    }
}

