/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.RadarChart;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class RadarChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private RadarChart radarChart;
    private ListChangeListener<ChartData> chartDataListener;
    private ChartDataEventListener chartEventListener;

    public RadarChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.radarChart = new RadarChart(this.tile.getChartData());
        this.radarChart.setMaxValue(this.tile.getMaxValue());
        this.radarChart.setUnit(this.tile.getUnit());
        this.radarChart.setLegendVisible(true);
        this.radarChart.setThresholdVisible(this.tile.isThresholdVisible());
        this.radarChart.setMode(this.tile.getRadarChartMode());
        this.radarChart.setGridColor(this.tile.getChartGridColor());
        this.radarChart.setChartTextColor(this.tile.getTextColor());
        this.radarChart.setThresholdColor(this.tile.getThresholdColor());
        this.radarChart.setGradientStops(this.tile.getGradientStops());
        this.chartEventListener = e -> this.radarChart.redraw();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.chartDataListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartDataEventListener(this.chartEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartDataEventListener(this.chartEventListener));
            }
            this.radarChart.redraw();
        };
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getTextColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.radarChart, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            this.radarChart.setThresholdVisible(this.tile.isThresholdVisible());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.radarChart.setMinValue(this.tile.getMinValue());
            this.radarChart.setMaxValue(this.tile.getMaxValue());
            this.radarChart.setThreshold(this.tile.getThreshold());
            this.radarChart.setUnit(this.tile.getUnit());
            this.radarChart.setMode(this.tile.getRadarChartMode());
            this.radarChart.setThresholdColor(this.tile.getThresholdColor());
            this.radarChart.setGradientStops(this.tile.getGradientStops());
        }
    }

    @Override
    public void dispose() {
        this.radarChart.dispose();
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        double chartSize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double chartWidth = this.contentBounds.getWidth();
        double chartHeight = this.contentBounds.getHeight();
        double d = chartSize = chartWidth < chartHeight ? chartWidth : chartHeight;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.radarChart.setPrefSize(chartSize, chartSize);
            this.radarChart.relocate((this.width - chartSize) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartSize) * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.radarChart.setSmoothing(this.tile.isSmoothing());
        this.radarChart.setUnit(this.tile.getUnit());
        this.radarChart.setMode(this.tile.getRadarChartMode());
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.radarChart.redraw();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.radarChart.setChartBackgroundColor(this.tile.getBackgroundColor());
        this.radarChart.setGridColor(this.tile.getForegroundColor());
        this.radarChart.setChartTextColor(this.tile.getForegroundColor());
        this.radarChart.setThresholdColor(this.tile.getThresholdColor());
        this.radarChart.setGradientStops(this.tile.getGradientStops());
        this.radarChart.setGridColor(this.tile.getChartGridColor());
    }
}

