/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.daten.DownloadStartInfo;
import mediathek.gui.messages.TimerEvent;
import mediathek.gui.messages.TrayIconEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.thrift.MessageType;
import mediathek.tool.notification.thrift.NotificationMessage;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MVTray {
    private final Daten daten = Daten.getInstance();
    private int trayState = 0;
    private SystemTray tray = null;
    private TrayIcon trayIcon = null;
    private int count = 0;
    private static final Logger logger = LogManager.getLogger(MVTray.class);

    public MVTray() {
        this.daten.getMessageBus().subscribe(this);
    }

    @Handler
    private void handleTimerEvent(TimerEvent msg) {
        SwingUtilities.invokeLater(() -> {
            ++this.count;
            if (this.count > 3) {
                this.trayIcon.setToolTip(this.getInfoTextDownloads());
                this.count = 0;
            }
            DownloadStartInfo info = this.daten.getListeDownloads().getStarts();
            if (info.error > 0) {
                if (this.trayState != 2) {
                    this.trayState = 2;
                    this.trayIcon.setImage(Icons.ICON_TRAY_ERROR);
                }
            } else if (info.running > 0) {
                if (this.trayState != 1) {
                    this.trayState = 1;
                    this.trayIcon.setImage(Icons.ICON_TRAY_DOWNLOAD);
                }
            } else if (this.trayState != 0) {
                this.trayState = 0;
                this.trayIcon.setImage(Icons.ICON_TRAY);
            }
        });
    }

    public void beenden() {
        if (this.tray != null && this.trayIcon != null) {
            this.tray.remove(this.trayIcon);
        }
    }

    public MVTray systemTray() {
        if (!SystemTray.isSupported()) {
            logger.info("Tray wird nicht unterst\u00fctzt");
            return null;
        }
        this.tray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(Icons.ICON_TRAY);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip(this.getInfoTextDownloads());
        this.addListener();
        PopupMenu popup = new PopupMenu();
        this.trayIcon.setPopupMenu(popup);
        MenuItem itemInfo = new MenuItem("Infos anzeigen");
        itemInfo.addActionListener(e -> this.addNotification(this.getTextInfos()));
        popup.add(itemInfo);
        MenuItem itemRemoveTray = new MenuItem("Trayicon ausblenden");
        itemRemoveTray.addActionListener(e -> {
            MediathekGui.ui().setVisible(true);
            MVConfig.add(MVConfig.Configs.SYSTEM_USE_TRAY, Boolean.toString(false));
            MediathekGui.ui().initializeSystemTray();
            this.daten.getMessageBus().publishAsync(new TrayIconEvent());
        });
        popup.add(itemRemoveTray);
        popup.addSeparator();
        MenuItem itemBeenden = new MenuItem("Programm beenden");
        itemBeenden.addActionListener(e -> MediathekGui.ui().beenden(false, false));
        popup.add(itemBeenden);
        this.trayIcon.setPopupMenu(popup);
        try {
            this.tray.add(this.trayIcon);
            return this;
        }
        catch (AWTException e2) {
            logger.error("Tray konnte nicht geladen werden", (Throwable)e2);
            return null;
        }
    }

    private void addListener() {
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    MediathekGui ui;
                    ui.setVisible(!(ui = MediathekGui.ui()).isVisible());
                    if (ui.isVisible()) {
                        ui.toFront();
                        ui.requestFocus();
                    }
                }
            }
        });
    }

    private String getTextInfos() {
        Object strText = "";
        strText = (String)strText + "Filmliste erstellt: " + this.daten.getListeFilme().genDate() + " Uhr  ";
        strText = (String)strText + "\n";
        strText = (String)strText + "Anz. Filme: " + this.daten.getListeFilme().size();
        strText = (String)strText + "\n";
        strText = (String)strText + this.getInfoTextDownloads();
        return strText;
    }

    private String getInfoTextDownloads() {
        DownloadStartInfo info = this.daten.getListeDownloads().getStarts();
        String text = "Downloads: " + info.total_starts;
        if (info.hasValues()) {
            text = text + "   [ ";
            text = text + (String)(info.running == 1 ? "1 l\u00e4uft" : info.running + " laufen");
            if (info.running > 0) {
                text = text + " (" + this.daten.getDownloadInfos().getBandwidthStr() + ")";
            }
            text = text + (String)(info.initialized == 1 ? ", 1 wartet" : ", " + info.initialized + " warten");
            if (info.finished > 0) {
                text = text + (String)(info.finished == 1 ? ", 1 fertig" : ", " + info.finished + " fertig");
            }
            if (info.error > 0) {
                text = text + (String)(info.error == 1 ? ", 1 fehlerhaft" : ", " + info.error + " fehlerhaft");
            }
            text = text + " ]";
        }
        return text;
    }

    private void addNotification(String meldung) {
        NotificationMessage msg = new NotificationMessage();
        msg.setTitle("Programminfos");
        msg.setMessage(meldung);
        msg.setType(MessageType.INFO);
        this.daten.notificationCenter().displayNotification(msg);
    }
}

