# -*- coding: utf-8 -*-
info = {
    "name": "mr",
    "date_order": "DMY",
    "january": [
        "जानेवारी",
        "जाने"
    ],
    "february": [
        "फेब्रुवारी",
        "फेब्रु"
    ],
    "march": [
        "मार्च"
    ],
    "april": [
        "एप्रिल",
        "एप्रि"
    ],
    "may": [
        "मे"
    ],
    "june": [
        "जून"
    ],
    "july": [
        "जुलै"
    ],
    "august": [
        "ऑगस्ट",
        "ऑग"
    ],
    "september": [
        "सप्टेंबर",
        "सप्टें"
    ],
    "october": [
        "ऑक्टोबर",
        "ऑक्टो"
    ],
    "november": [
        "नोव्हेंबर",
        "नोव्हें"
    ],
    "december": [
        "डिसेंबर",
        "डिसें"
    ],
    "monday": [
        "सोमवार",
        "सोम"
    ],
    "tuesday": [
        "मंगळवार",
        "मंगळ"
    ],
    "wednesday": [
        "बुधवार",
        "बुध"
    ],
    "thursday": [
        "गुरुवार",
        "गुरु"
    ],
    "friday": [
        "शुक्रवार",
        "शुक्र"
    ],
    "saturday": [
        "शनिवार",
        "शनि"
    ],
    "sunday": [
        "रविवार",
        "रवि"
    ],
    "am": [
        "मपू"
    ],
    "pm": [
        "मउ"
    ],
    "year": [
        "वर्ष"
    ],
    "month": [
        "महिना"
    ],
    "week": [
        "आठवडा"
    ],
    "day": [
        "दिवस"
    ],
    "hour": [
        "तास"
    ],
    "minute": [
        "मिनिट",
        "मि"
    ],
    "second": [
        "सेकंद",
        "से"
    ],
    "relative-type": {
        "1 year ago": [
            "मागील वर्ष"
        ],
        "0 year ago": [
            "हे वर्ष"
        ],
        "in 1 year": [
            "पुढील वर्ष"
        ],
        "1 month ago": [
            "मागील महिना"
        ],
        "0 month ago": [
            "हा महिना"
        ],
        "in 1 month": [
            "पुढील महिना"
        ],
        "1 week ago": [
            "मागील आठवडा"
        ],
        "0 week ago": [
            "हा आठवडा"
        ],
        "in 1 week": [
            "पुढील आठवडा"
        ],
        "1 day ago": [
            "काल"
        ],
        "0 day ago": [
            "आज"
        ],
        "in 1 day": [
            "उद्या"
        ],
        "0 hour ago": [
            "तासात"
        ],
        "0 minute ago": [
            "या मिनिटात"
        ],
        "0 second ago": [
            "आत्ता"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) वर्षामध्ये",
            "(\\d+) वर्षांमध्ये"
        ],
        "\\1 year ago": [
            "(\\d+) वर्षापूर्वी",
            "(\\d+) वर्षांपूर्वी"
        ],
        "in \\1 month": [
            "(\\d+) महिन्यामध्ये",
            "(\\d+) महिन्यांमध्ये"
        ],
        "\\1 month ago": [
            "(\\d+) महिन्यापूर्वी",
            "(\\d+) महिन्यांपूर्वी"
        ],
        "in \\1 week": [
            "(\\d+) आठवड्यामध्ये",
            "(\\d+) आठवड्यांमध्ये"
        ],
        "\\1 week ago": [
            "(\\d+) आठवड्यापूर्वी",
            "(\\d+) आठवड्यांपूर्वी"
        ],
        "in \\1 day": [
            "(\\d+) दिवसामध्ये",
            "(\\d+) दिवसांमध्ये"
        ],
        "\\1 day ago": [
            "(\\d+) दिवसापूर्वी",
            "(\\d+) दिवसांपूर्वी"
        ],
        "in \\1 hour": [
            "(\\d+) तासामध्ये",
            "(\\d+) तासांमध्ये"
        ],
        "\\1 hour ago": [
            "(\\d+) तासापूर्वी",
            "(\\d+) तासांपूर्वी"
        ],
        "in \\1 minute": [
            "(\\d+) मिनिटामध्ये",
            "(\\d+) मिनिटांमध्ये",
            "(\\d+) मिनि मध्ये"
        ],
        "\\1 minute ago": [
            "(\\d+) मिनिटापूर्वी",
            "(\\d+) मिनिटांपूर्वी",
            "(\\d+) मिनि पूर्वी"
        ],
        "in \\1 second": [
            "(\\d+) सेकंदामध्ये",
            "(\\d+) सेकंदांमध्ये",
            "(\\d+) से मध्ये"
        ],
        "\\1 second ago": [
            "(\\d+) सेकंदापूर्वी",
            "(\\d+) सेकंदांपूर्वी",
            "(\\d+) से पूर्वी"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
